/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import netscape.javascript.JSObject;
import org.jmol.api.JmolAppletInterface;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.applet.JmolAppletRegistry;
import org.jmol.applet.Jvm12;
import org.jmol.appletwrapper.AppletWrapper;
import org.jmol.appletwrapper.WrappedApplet;
import org.jmol.i18n.GT;
import org.jmol.popup.JmolPopup;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public class Jmol
implements WrappedApplet {
    Jvm12 jvm12;
    JmolPopup jmolpopup;
    boolean mayScript;
    boolean haveDocumentAccess;
    boolean popupMenuAllowed = true;
    boolean needPopupMenu;
    boolean loading;
    String[] callbacks = new String[13];
    String language;
    String menuStructure;
    String htmlName;
    String fullName;
    String syncId;
    String languagePath;
    AppletWrapper appletWrapper;
    private JmolViewer viewer;
    private static final boolean REQUIRE_PROGRESSBAR = true;
    private boolean jvm12orGreater;
    private boolean hasProgressBar;
    protected boolean doTranslate = true;
    private String statusForm;
    private String statusText;
    private String statusTextarea;
    private int paintCounter;
    boolean isSigned;
    public boolean showPaintTime = false;
    private boolean isUpdating;
    protected Graphics gRight;
    protected boolean isStereoSlave;
    private static final String[] progressbarMsgs = new String[]{"Jmol developer alert!", "", "Please use jmol.js. You are missing the require 'progressbar' parameter.", "  <param name='progressbar' value='true' />"};
    private int timeLast;
    private int timeCount;
    private int timeTotal;
    private long timeBegin;
    private int lastMotionEventNumber;
    private static final int SCRIPT_CHECK = 0;
    private static final int SCRIPT_WAIT = 1;
    private static final int SCRIPT_NOWAIT = 2;
    StringBuffer outputBuffer;

    public void setAppletWrapper(AppletWrapper appletWrapper) {
        this.appletWrapper = appletWrapper;
    }

    public void init() {
        this.htmlName = this.getParameter("name");
        this.syncId = this.getParameter("syncId");
        this.fullName = this.htmlName + "__" + this.syncId + "__";
        System.out.println("Jmol applet " + this.fullName + " initializing");
        this.setLogging();
        String string = this.getParameter("mayscript");
        this.mayScript = string != null && !string.equalsIgnoreCase("false");
        JmolAppletRegistry.checkIn(this.fullName, this.appletWrapper);
        this.initWindows();
        this.initApplication();
    }

    public void destroy() {
        this.gRight = null;
        JmolAppletRegistry.checkOut(this.fullName);
        this.viewer.setModeMouse(-1);
        this.viewer = null;
        if (this.jvm12 != null) {
            this.jvm12.console = null;
            this.jvm12 = null;
        }
        System.out.println("Jmol applet " + this.fullName + " destroyed");
    }

    String getParameter(String string) {
        return this.appletWrapper.getParameter(string);
    }

    public Graphics setStereoGraphics(boolean bl) {
        this.isStereoSlave = bl;
        return bl ? this.appletWrapper.getGraphics() : null;
    }

    public void initWindows() {
        String string;
        String string2 = "-applet";
        boolean bl = this.isSigned = this.getBooleanValue("signed", false) || this.appletWrapper.isSigned();
        if (this.isSigned) {
            string2 = string2 + "-signed";
        }
        if (this.getBooleanValue("useCommandThread", this.isSigned)) {
            string2 = string2 + "-threaded";
        }
        if ((string = this.getValue("MaximumSize", null)) != null) {
            string2 = string2 + "-maximumSize " + string;
        }
        if ((string = this.getValue("JmolAppletProxy", null)) != null) {
            string2 = string2 + "-appletProxy " + string;
        }
        this.viewer = JmolViewer.allocateViewer(this.appletWrapper, null, this.fullName, this.appletWrapper.getDocumentBase(), this.appletWrapper.getCodeBase(), string2, new MyStatusListener());
        String string3 = this.getParameter("menuFile");
        if (string3 != null) {
            this.menuStructure = this.viewer.getFileAsString(string3);
        }
        this.jvm12orGreater = this.viewer.isJvm12orGreater();
        if (this.jvm12orGreater) {
            this.jvm12 = new Jvm12(this.appletWrapper, this.viewer, string2);
        }
        if (Logger.debugging) {
            Logger.debug("checking for jsoWindow mayScript=" + this.mayScript);
        }
        if (this.mayScript) {
            this.haveDocumentAccess = false;
            this.mayScript = false;
            JSObject jSObject = null;
            JSObject jSObject2 = null;
            try {
                jSObject = JSObject.getWindow((Applet)this.appletWrapper);
                if (Logger.debugging) {
                    Logger.debug("jsoWindow=" + jSObject);
                }
                if (jSObject == null) {
                    Logger.error("jsoWindow returned null ... no JavaScript callbacks :-(");
                } else {
                    this.mayScript = true;
                }
                jSObject2 = (JSObject)jSObject.getMember("document");
                if (jSObject2 == null) {
                    Logger.error("jsoDocument returned null ... no DOM manipulations :-(");
                } else {
                    this.haveDocumentAccess = true;
                }
            }
            catch (Exception exception) {
                Logger.error("Microsoft MSIE bug -- http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=5012558 " + exception);
            }
            if (Logger.debugging) {
                Logger.debug("jsoWindow:" + jSObject + " jsoDocument:" + jSObject2 + " mayScript:" + this.mayScript + " haveDocumentAccess:" + this.haveDocumentAccess);
            }
        }
    }

    private void setLogging() {
        int n = this.getValue("logLevel", this.getBooleanValue("debug", false) ? "5" : "4").charAt(0) - 48;
        if (n != 4) {
            System.out.println("setting logLevel=" + n + " -- To change, use script \"set logLevel [0-5]\"");
        }
        Logger.setLogLevel(n);
    }

    private boolean getBooleanValue(String string, boolean bl) {
        String string2 = this.getValue(string, bl ? "true" : "");
        return string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("on") || string2.equalsIgnoreCase("yes");
    }

    private String getValue(String string, String string2) {
        String string3 = this.getParameter(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    private String getValueLowerCase(String string, String string2) {
        String string3 = this.getValue(string, string2);
        if (string3 != null && (string3 = string3.trim().toLowerCase()).length() == 0) {
            string3 = null;
        }
        return string3;
    }

    public void initApplication() {
        int n;
        this.viewer.pushHoldRepaint();
        this.hasProgressBar = this.getBooleanValue("progressbar", false);
        String string = this.getValueLowerCase("emulate", "jmol");
        this.setStringProperty("defaults", string.equals("chime") ? "RasMol" : "Jmol");
        this.setStringProperty("backgroundColor", this.getValue("bgcolor", this.getValue("boxbgcolor", "black")));
        this.viewer.setBooleanProperty("frank", true);
        this.loading = true;
        for (n = 0; n < 13; ++n) {
            String string2 = JmolConstants.getCallbackName(n);
            this.setValue(string2, null);
        }
        this.loading = false;
        this.language = this.getParameter("language");
        if (this.language != null) {
            System.out.print("requested language=" + this.language + "; ");
            new GT(this.language);
        }
        this.doTranslate = !"none".equals(this.language) && this.getBooleanValue("doTranslate", true);
        this.language = GT.getLanguage();
        System.out.println("language=" + this.language);
        n = 0;
        for (int i = 0; i < 13 && n == 0; ++i) {
            n = this.callbacks[i] != null ? 1 : 0;
        }
        if (!(n == 0 && this.statusForm == null && this.statusText == null || this.mayScript)) {
            Logger.warn("MAYSCRIPT missing -- all applet JavaScript calls disabled");
        }
        if (this.callbacks[11] == null && this.callbacks[2] == null && (this.callbacks[7] != null || this.statusForm != null || this.statusText != null)) {
            if (this.doTranslate && this.getValue("doTranslate", null) == null) {
                this.doTranslate = false;
                Logger.warn("Note -- Presence of message callback disables disable translation; to enable message translation use jmolSetTranslation(true) prior to jmolApplet()");
            }
            if (this.doTranslate) {
                Logger.warn("Note -- Automatic language translation may affect parsing of message callbacks messages; use scriptCallback or errorCallback to process errors");
            }
        }
        if (!this.doTranslate) {
            GT.setDoTranslate(false);
            Logger.warn("Note -- language translation disabled");
        }
        this.statusForm = this.getValue("StatusForm", null);
        this.statusText = this.getValue("StatusText", null);
        this.statusTextarea = this.getValue("StatusTextarea", null);
        if (this.statusForm != null && this.statusText != null) {
            Logger.info("applet text status will be reported to document." + this.statusForm + "." + this.statusText);
        }
        if (this.statusForm != null && this.statusTextarea != null) {
            Logger.info("applet textarea status will be reported to document." + this.statusForm + "." + this.statusTextarea);
        }
        this.needPopupMenu = this.getBooleanValue("popupMenu", true);
        if (this.needPopupMenu) {
            this.getPopupMenu(false);
        }
        this.loadNodeId(this.getValue("loadNodeId", null));
        String string3 = this.getValue("script", "");
        String string4 = this.getValue("loadInline", null);
        if (string4 != null) {
            this.loadInlineSeparated(string4, string3.length() > 0 ? string3 : null);
        } else {
            string4 = this.getValue("load", null);
            if (string4 != null) {
                string3 = "load \"" + string4 + "\";" + string3;
            }
            if (string3.length() > 0) {
                this.scriptProcessor(string3, null, 2);
            }
        }
        this.viewer.popHoldRepaint();
    }

    private void setValue(String string, String string2) {
        this.setStringProperty(string, this.getValue(string, string2));
    }

    private void setStringProperty(String string, String string2) {
        if (string2 == null) {
            return;
        }
        Logger.info(string + " = \"" + string2 + "\"");
        this.viewer.setStringProperty(string, string2);
    }

    void sendJsTextStatus(String string) {
        if (!this.haveDocumentAccess || this.statusForm == null || this.statusText == null) {
            return;
        }
        try {
            JSObject jSObject = JSObject.getWindow((Applet)this.appletWrapper);
            JSObject jSObject2 = (JSObject)jSObject.getMember("document");
            JSObject jSObject3 = (JSObject)jSObject2.getMember(this.statusForm);
            if (this.statusText != null) {
                JSObject jSObject4 = (JSObject)jSObject3.getMember(this.statusText);
                jSObject4.setMember("value", string);
            }
        }
        catch (Exception exception) {
            Logger.error("error indicating status at document." + this.statusForm + "." + this.statusText + ":" + exception.toString());
        }
    }

    void sendJsTextareaStatus(String string) {
        if (!this.haveDocumentAccess || this.statusForm == null || this.statusTextarea == null) {
            return;
        }
        try {
            JSObject jSObject = JSObject.getWindow((Applet)this.appletWrapper);
            JSObject jSObject2 = (JSObject)jSObject.getMember("document");
            JSObject jSObject3 = (JSObject)jSObject2.getMember(this.statusForm);
            if (this.statusTextarea != null) {
                JSObject jSObject4 = (JSObject)jSObject3.getMember(this.statusTextarea);
                if (string == null) {
                    jSObject4.setMember("value", "");
                } else {
                    String string2 = (String)jSObject4.getMember("value");
                    jSObject4.setMember("value", string2 + "\n" + string);
                }
            }
        }
        catch (Exception exception) {
            Logger.error("error indicating status at document." + this.statusForm + "." + this.statusTextarea + ":" + exception.toString());
        }
    }

    public void paint(Graphics graphics) {
        this.update(graphics, "paint ");
    }

    public void update(Graphics graphics) {
        this.update(graphics, "update");
    }

    private void update(Graphics graphics, String string) {
        if (this.viewer == null) {
            return;
        }
        if (this.isUpdating) {
            return;
        }
        this.isUpdating = true;
        if (this.showPaintTime) {
            this.startPaintClock();
        }
        Dimension dimension = this.jvm12orGreater ? this.jvm12.getSize() : this.appletWrapper.size();
        this.viewer.setScreenDimension(dimension);
        ++this.paintCounter;
        if (!this.isSigned && !this.hasProgressBar && this.paintCounter < 30 && (this.paintCounter & 1) == 0) {
            this.printProgressbarMessage(graphics);
            this.viewer.repaintView();
        } else if (!this.isStereoSlave) {
            this.viewer.renderScreenImage(graphics, this.gRight, dimension, null);
        }
        if (this.showPaintTime) {
            this.stopPaintClock();
            this.showTimes(10, 10, graphics);
        }
        this.isUpdating = false;
    }

    private void printProgressbarMessage(Graphics graphics) {
        graphics.setColor(Color.yellow);
        graphics.fillRect(0, 0, 10000, 10000);
        graphics.setColor(Color.black);
        int n = 0;
        int n2 = 13;
        while (n < progressbarMsgs.length) {
            graphics.drawString(progressbarMsgs[n], 10, n2);
            ++n;
            n2 += 13;
        }
    }

    public boolean handleEvent(Event event) {
        if (this.viewer == null) {
            return false;
        }
        return this.viewer.handleOldJvm10Event(event);
    }

    private void startPaintClock() {
        this.timeBegin = System.currentTimeMillis();
        int n = this.viewer.getMotionEventNumber();
        if (this.lastMotionEventNumber != n) {
            this.lastMotionEventNumber = n;
            this.timeTotal = 0;
            this.timeCount = 0;
            this.timeLast = -1;
        }
    }

    private void stopPaintClock() {
        int n = (int)(System.currentTimeMillis() - this.timeBegin);
        if (this.timeLast != -1) {
            this.timeTotal += this.timeLast;
            ++this.timeCount;
        }
        this.timeLast = n;
    }

    private String fmt(int n) {
        if (n < 0) {
            return "---";
        }
        if (n < 10) {
            return "  " + n;
        }
        if (n < 100) {
            return " " + n;
        }
        return "" + n;
    }

    private void showTimes(int n, int n2, Graphics graphics) {
        int n3 = this.timeCount == 0 ? -1 : (this.timeTotal + this.timeCount / 2) / this.timeCount;
        graphics.setColor(Color.green);
        graphics.drawString(this.fmt(this.timeLast) + "ms : " + this.fmt(n3) + "ms", n, n2);
    }

    private String scriptProcessor(String string, String string2, int n) {
        if (string == null || string.length() == 0) {
            return "";
        }
        switch (n) {
            case 0: {
                String string3 = this.viewer.scriptCheck(string);
                return string3 == null ? "" : string3;
            }
            case 1: {
                if (string2 != null) {
                    return this.viewer.scriptWaitStatus(string, string2).toString();
                }
                return this.viewer.scriptWait(string);
            }
        }
        return this.viewer.script(string);
    }

    public void script(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.scriptProcessor(string, null, 2);
    }

    public String scriptCheck(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return this.scriptProcessor(string, null, 0);
    }

    public String scriptNoWait(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return this.scriptProcessor(string, null, 2);
    }

    public String scriptWait(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        this.outputBuffer = null;
        return this.scriptProcessor(string, null, 1);
    }

    public String scriptWait(String string, String string2) {
        if (string == null || string.length() == 0) {
            return "";
        }
        this.outputBuffer = null;
        return this.scriptProcessor(string, string2, 1);
    }

    public String scriptWaitOutput(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        this.outputBuffer = new StringBuffer();
        this.viewer.scriptWaitStatus(string, "");
        String string2 = this.outputBuffer == null ? "" : this.outputBuffer.toString();
        this.outputBuffer = null;
        return string2;
    }

    public synchronized void syncScript(String string) {
        this.viewer.syncScript(string, "~");
    }

    public String getAppletInfo() {
        return GT._("Jmol Applet version {0} {1}.\n\nAn OpenScience project.\n\nSee http://www.jmol.org for more information", new Object[]{JmolConstants.version, JmolConstants.date}) + "\nhtmlName = " + Escape.escape(this.htmlName) + "\nsyncId = " + Escape.escape(this.syncId) + "\ndocumentBase = " + Escape.escape("" + this.appletWrapper.getDocumentBase()) + "\ncodeBase = " + Escape.escape("" + this.appletWrapper.getCodeBase());
    }

    public Object getProperty(String string) {
        return this.viewer.getProperty(null, string, "");
    }

    public Object getProperty(String string, String string2) {
        return this.viewer.getProperty(null, string, string2);
    }

    public String getPropertyAsString(String string) {
        return this.viewer.getProperty("readable", string, "").toString();
    }

    public String getPropertyAsString(String string, String string2) {
        return this.viewer.getProperty("readable", string, string2).toString();
    }

    public String getPropertyAsJSON(String string) {
        return this.viewer.getProperty("JSON", string, "").toString();
    }

    public String getPropertyAsJSON(String string, String string2) {
        return this.viewer.getProperty("JSON", string, string2).toString();
    }

    public String loadInlineString(String string, String string2, boolean bl) {
        String string3 = this.viewer.loadInline(string, bl);
        if (string3 == null) {
            this.script(string2);
        }
        return string3;
    }

    public String loadInlineArray(String[] stringArray, String string, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        String string2 = this.viewer.loadInline(stringArray, bl);
        if (string2 == null) {
            this.script(string);
        }
        return string2;
    }

    public String loadInline(String string) {
        return this.loadInlineString(string, "", false);
    }

    public String loadInline(String string, String string2) {
        return this.loadInlineString(string, string2, false);
    }

    public String loadInline(String[] stringArray) {
        return this.loadInlineArray(stringArray, "", false);
    }

    public String loadInline(String[] stringArray, String string) {
        return this.loadInlineArray(stringArray, string, false);
    }

    private String loadInlineSeparated(String string, String string2) {
        if (string == null) {
            return null;
        }
        String string3 = this.viewer.loadInline(string);
        if (string3 == null) {
            this.script(string2);
        }
        return string3;
    }

    public String loadDOMNode(JSObject jSObject) {
        return this.viewer.openDOM(jSObject);
    }

    public String loadNodeId(String string) {
        if (!this.haveDocumentAccess) {
            return "ERROR: NO DOCUMENT ACCESS";
        }
        if (string == null) {
            return null;
        }
        Object[] objectArray = new Object[]{string};
        JSObject jSObject = null;
        try {
            Object[] objectArray2;
            JSObject jSObject2;
            JSObject jSObject3 = JSObject.getWindow((Applet)this.appletWrapper);
            JSObject jSObject4 = (JSObject)jSObject3.getMember("document");
            jSObject = (JSObject)jSObject4.call("getElementById", objectArray);
            if (jSObject == null && (jSObject2 = (JSObject)jSObject4.call("getElementsByTagNameNS", objectArray2 = new Object[]{"http://www.xml-cml.org/schema/cml2/core", "cml"})) != null) {
                Object[] objectArray3;
                String string2;
                for (int i = 0; i < ((Number)jSObject2.getMember("length")).intValue() && !string.equals(string2 = (String)(jSObject = (JSObject)jSObject2.getSlot(i)).call("getAttribute", objectArray3 = new Object[]{"id"})); ++i) {
                    jSObject = null;
                }
            }
        }
        catch (Exception exception) {
            return "" + exception;
        }
        return jSObject == null ? "ERROR: No CML node" : this.loadDOMNode(jSObject);
    }

    public void getPopupMenu(boolean bl) {
        this.jmolpopup = JmolPopup.newJmolPopup(this.viewer, this.doTranslate, this.menuStructure, this.popupMenuAllowed);
        if (this.jmolpopup != null && this.jvm12 != null && !this.popupMenuAllowed) {
            if (bl) {
                this.jvm12.showConsole(false);
            }
            if (this.jvm12.console == null) {
                this.jvm12.getConsole();
            }
            this.jmolpopup.installMainMenu(this.jvm12.console.getMyMenuBar());
        }
    }

    class MyStatusListener
    implements JmolStatusListener {
        private boolean haveNotifiedError;
        private String defaultMessage;

        MyStatusListener() {
        }

        public boolean notifyEnabled(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    return true;
                }
            }
            return Jmol.this.callbacks[n] != null;
        }

        public void notifyCallback(int n, Object[] objectArray) {
            Object object;
            boolean bl;
            String string = Jmol.this.callbacks[n];
            boolean bl2 = bl = string != null && (objectArray == null || objectArray[0] == null);
            if (objectArray != null) {
                objectArray[0] = Jmol.this.htmlName;
            }
            String string2 = objectArray == null || objectArray[1] == null ? null : objectArray[1].toString();
            switch (n) {
                case 0: {
                    int n2;
                    object = (int[])objectArray[1];
                    int n3 = object[0];
                    int n4 = object[1];
                    int n5 = object[2];
                    int n6 = object[3];
                    Object object2 = object[4];
                    boolean bl3 = n3 <= -2;
                    int n7 = n6 < 0 ? -1 : 1;
                    int n8 = n2 = object2 < 0 ? -1 : 1;
                    if (bl) {
                        objectArray = new Object[]{Jmol.this.htmlName, new Integer(Math.max(n3, -2 - n3)), new Integer(n4), new Integer(n5), new Integer(Math.abs(n6)), new Integer(Math.abs((int)object2)), new Integer(bl3 ? 1 : 0), new Integer(n7), new Integer(n2)};
                    }
                    if (Jmol.this.jmolpopup == null || bl3) break;
                    Jmol.this.jmolpopup.updateComputedMenus();
                    break;
                }
                case 1: {
                    boolean bl4 = (Integer)objectArray[2] == 1;
                    boolean bl5 = true;
                    if (!bl) {
                        if (bl4) {
                            this.consoleMessage(string2);
                            bl5 = false;
                        }
                        n = 7;
                        string = Jmol.this.callbacks[7];
                        boolean bl6 = bl = string != null;
                    }
                    if (!bl5) break;
                    this.output(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    String string3 = (String)objectArray[4];
                    if (string3 == null) break;
                    this.showStatusAndConsole((string3.indexOf("NOTE:") >= 0 ? "" : GT._("File Error:")) + string3, true);
                    return;
                }
                case 6: {
                    String string4;
                    if (!bl) {
                        n = 7;
                        string = Jmol.this.callbacks[7];
                        boolean bl7 = bl = string != null;
                    }
                    if ((string4 = (String)objectArray[3]).indexOf("Picked") >= 0) {
                        this.showStatusAndConsole(string2, true);
                        break;
                    }
                    if (string4.indexOf("Completed") < 0) break;
                    string2 = string4 + ": " + string2;
                    this.consoleMessage(string2);
                    break;
                }
                case 7: {
                    if (bl) {
                        this.output(string2);
                    } else {
                        this.consoleMessage(string2);
                    }
                    if (string2 != null) break;
                    return;
                }
                case 8: {
                    break;
                }
                case 9: {
                    this.showStatusAndConsole(string2, true);
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    boolean bl8;
                    int n9 = (Integer)objectArray[3];
                    boolean bl9 = bl8 = n9 == 0;
                    if (n9 > 0) {
                        this.notifyScriptTermination();
                    } else if (!bl) {
                        n = 7;
                        string = Jmol.this.callbacks[7];
                        bl = string != null;
                    }
                    this.showStatusAndConsole(string2, bl8);
                    break;
                }
                case 12: {
                    this.sendScript(string2, (String)objectArray[2], true, bl);
                    return;
                }
            }
            if (!bl || !Jmol.this.mayScript) {
                return;
            }
            try {
                object = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                if (string.equals("alert")) {
                    ((JSObject)object).call(string, string2);
                } else if (string.length() > 0) {
                    ((JSObject)object).call(string, objectArray);
                }
            }
            catch (Exception exception) {
                if (!this.haveNotifiedError && Logger.debugging) {
                    Logger.debug(JmolConstants.getCallbackName(n) + " call error to " + string + ": " + exception);
                }
                this.haveNotifiedError = true;
            }
        }

        private void output(String string) {
            if (Jmol.this.outputBuffer != null && string != null) {
                Jmol.this.outputBuffer.append(string).append('\n');
            }
        }

        private void notifyScriptTermination() {
        }

        private String notifySync(String string, String string2) {
            String string3 = Jmol.this.callbacks[12];
            if (!Jmol.this.mayScript || string3 == null) {
                return string;
            }
            try {
                JSObject jSObject = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                if (string3.length() > 0) {
                    return "" + jSObject.call(string3, Jmol.this.htmlName, string, string2);
                }
            }
            catch (Exception exception) {
                if (!this.haveNotifiedError && Logger.debugging) {
                    Logger.debug("syncCallback call error to " + string3 + ": " + exception);
                }
                this.haveNotifiedError = true;
            }
            return string;
        }

        public void setCallbackFunction(String string, String string2) {
            if (string.equalsIgnoreCase("menu")) {
                Jmol.this.menuStructure = string2;
                if (Jmol.this.needPopupMenu) {
                    Jmol.this.getPopupMenu(false);
                }
                return;
            }
            if (string.equalsIgnoreCase("language")) {
                new GT(string2);
                Jmol.this.language = GT.getLanguage();
                if (Jmol.this.needPopupMenu) {
                    Jmol.this.getPopupMenu(true);
                }
                this.clearDefaultConsoleMessage();
                if (Jmol.this.jvm12 != null && Jmol.this.isSigned) {
                    Jvm12.newDialog(true);
                }
                return;
            }
            int n = JmolConstants.getCallbackId(string);
            if (n >= 0 && (Jmol.this.loading || n != 3)) {
                Jmol.this.callbacks[n] = string2;
                return;
            }
            String string3 = "";
            for (int i = 0; i < 13; ++i) {
                string3 = string3 + " " + JmolConstants.getCallbackName(i);
            }
            this.consoleMessage("Available callbacks include: " + string3);
        }

        protected void finalize() throws Throwable {
            Logger.debug("MyStatusListener finalize " + this);
            super.finalize();
        }

        public String eval(String string) {
            int n = string.indexOf("\u0001");
            if (n >= 0) {
                return this.sendScript(string.substring(n + 1), string.substring(0, n), false, false);
            }
            if (string.startsWith("_GET_MENU")) {
                return Jmol.this.jmolpopup == null ? "" : Jmol.this.jmolpopup.getMenu("Jmol version " + Viewer.getJmolVersion() + "|" + string);
            }
            if (!Jmol.this.haveDocumentAccess) {
                return "NO EVAL ALLOWED";
            }
            JSObject jSObject = null;
            JSObject jSObject2 = null;
            try {
                jSObject = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                jSObject2 = (JSObject)jSObject.getMember("document");
            }
            catch (Exception exception) {
                if (Logger.debugging) {
                    Logger.debug(" error setting jsoWindow or jsoDocument:" + jSObject + ", " + jSObject2);
                }
                return "NO EVAL ALLOWED";
            }
            if (Jmol.this.callbacks[3] != null) {
                this.notifyCallback(3, new Object[]{null, string});
                return "";
            }
            try {
                if (!Jmol.this.haveDocumentAccess || ((Boolean)jSObject2.eval("!!_jmol.noEval")).booleanValue()) {
                    return "NO EVAL ALLOWED";
                }
            }
            catch (Exception exception) {
                Logger.error("# no _jmol in evaluating " + string + ":" + exception.toString());
                return "";
            }
            try {
                return "" + jSObject2.eval(string);
            }
            catch (Exception exception) {
                Logger.error("# error evaluating " + string + ":" + exception.toString());
                return "";
            }
        }

        public String createImage(String string, String string2, Object object, int n) {
            boolean bl;
            boolean bl2 = bl = n != Integer.MIN_VALUE;
            if (Jmol.this.isSigned) {
                if (Jmol.this.jvm12 != null) {
                    try {
                        return Jmol.this.jvm12.createImage(string, string2, object, n);
                    }
                    catch (Exception exception) {}
                }
            } else if (bl) {
                return GT._("File creation by this applet is not allowed. For Base64 JPEG format, use {0}.", "jmolGetPropertyAsString('image')");
            }
            return GT._("File creation failed.");
        }

        public float[][] functionXY(String string, int n, int n2) {
            float[][] fArray = new float[Math.abs(n)][Math.abs(n2)];
            if (!Jmol.this.mayScript || n == 0 || n2 == 0) {
                return fArray;
            }
            try {
                JSObject jSObject = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                if (n > 0 && n2 > 0) {
                    for (int i = 0; i < n; ++i) {
                        for (int j = 0; j < n2; ++j) {
                            fArray[i][j] = ((Double)jSObject.call(string, Jmol.this.htmlName, new Integer(i), new Integer(j))).floatValue();
                        }
                    }
                } else if (n2 > 0) {
                    String string2 = (String)jSObject.call(string, Jmol.this.htmlName, new Integer(n), new Integer(n2));
                    n = Math.abs(n);
                    float[] fArray2 = new float[n * n2];
                    Parser.parseFloatArray(string2, null, fArray2);
                    int n3 = 0;
                    for (int i = 0; i < n; ++i) {
                        int n4 = 0;
                        while (n4 < n2) {
                            fArray[i][n4] = fArray2[n3];
                            ++n4;
                            ++n3;
                        }
                    }
                } else {
                    jSObject.call(string, new Object[]{Jmol.this.htmlName, new Integer(n), new Integer(n2), fArray});
                }
            }
            catch (Exception exception) {
                Logger.error("Exception " + exception.getMessage() + " with nX, nY: " + n + " " + n2);
            }
            return fArray;
        }

        public void handlePopupMenu(int n, int n2) {
            if (!Jmol.this.popupMenuAllowed) {
                this.showConsole(true);
                return;
            }
            if (Jmol.this.jmolpopup == null) {
                return;
            }
            if (!Jmol.this.language.equals(GT.getLanguage())) {
                Jmol.this.getPopupMenu(true);
                Jmol.this.language = GT.getLanguage();
            }
            Jmol.this.jmolpopup.show(n, n2);
        }

        public void showUrl(String string) {
            if (Logger.debugging) {
                Logger.debug("showUrl(" + string + ")");
            }
            if (string != null && string.length() > 0) {
                try {
                    URL uRL = new URL(string);
                    Jmol.this.appletWrapper.getAppletContext().showDocument(uRL, "_blank");
                }
                catch (MalformedURLException malformedURLException) {
                    this.showStatusAndConsole("Malformed URL:" + string, true);
                }
            }
        }

        private void showStatusAndConsole(String string, boolean bl) {
            try {
                Jmol.this.appletWrapper.showStatus(string);
                Jmol.this.sendJsTextStatus(string);
                if (bl) {
                    this.consoleMessage(string);
                } else {
                    this.output(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void clearDefaultConsoleMessage() {
            this.defaultMessage = null;
        }

        private void consoleMessage(String string) {
            if (Jmol.this.jvm12 != null && Jmol.this.jvm12.haveConsole()) {
                if (this.defaultMessage == null) {
                    GT.setDoTranslate(true);
                    this.defaultMessage = GT._("Messages will appear here. Enter commands in the box below. Click the console Help menu item for on-line help, which will appear in a new browser window.");
                    GT.setDoTranslate(Jmol.this.doTranslate);
                }
                if (Jmol.this.jvm12.getConsoleMessage().startsWith(this.defaultMessage)) {
                    Jmol.this.jvm12.consoleMessage("");
                }
                Jmol.this.jvm12.consoleMessage(string);
                if (string == null) {
                    Jmol.this.jvm12.consoleMessage(this.defaultMessage);
                }
            }
            this.output(string);
            Jmol.this.sendJsTextareaStatus(string);
        }

        public void showConsole(boolean bl) {
            if (Jmol.this.jvm12 != null) {
                Jmol.this.jvm12.showConsole(bl);
            }
        }

        private String sendScript(String string, String string2, boolean bl, boolean bl2) {
            boolean bl3;
            if (bl2 && ((string = this.notifySync(string, string2)) == null || string.length() == 0 || string.equals("0"))) {
                return "";
            }
            Vector vector = new Vector();
            JmolAppletRegistry.findApplets(string2, Jmol.this.syncId, Jmol.this.fullName, vector);
            int n = vector.size();
            if (n == 0) {
                if (!bl2 && !string2.equals("*")) {
                    Logger.error(Jmol.this.fullName + " couldn't find applet " + string2);
                }
                return "";
            }
            StringBuffer stringBuffer = bl ? null : new StringBuffer();
            boolean bl4 = bl && string.equals("GET_GRAPHICS");
            boolean bl5 = bl3 = bl && string.equals("SET_GRAPHICS_OFF");
            if (bl4) {
                Jmol.this.gRight = null;
            }
            for (int i = 0; i < n; ++i) {
                String string3 = (String)vector.elementAt(i);
                JmolAppletInterface jmolAppletInterface = (JmolAppletInterface)JmolAppletRegistry.htRegistry.get(string3);
                if (Logger.debugging) {
                    Logger.debug(Jmol.this.fullName + " sending to " + string3 + ": " + string);
                }
                try {
                    if (bl4 || bl3) {
                        Jmol.this.gRight = jmolAppletInterface.setStereoGraphics(bl4);
                        return "";
                    }
                    if (bl) {
                        jmolAppletInterface.syncScript(string);
                        continue;
                    }
                    stringBuffer.append(jmolAppletInterface.scriptWait(string, "output")).append("\n");
                    continue;
                }
                catch (Exception exception) {
                    String string4 = Jmol.this.htmlName + " couldn't send to " + string3 + ": " + string + ": " + exception;
                    Logger.error(string4);
                    if (bl) continue;
                    stringBuffer.append(string4);
                }
            }
            return bl ? "" : stringBuffer.toString();
        }

        public Hashtable getRegistryInfo() {
            JmolAppletRegistry.checkIn(null, null);
            return JmolAppletRegistry.htRegistry;
        }

        public String dialogAsk(String string, String string2) {
            if (!Jmol.this.isSigned || Jmol.this.jvm12 == null) {
                return null;
            }
            return Jmol.this.jvm12.dialogAsk(string, string2);
        }
    }
}

