/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.jmol.api.JmolFileReaderInterface;
import org.jmol.api.JmolViewer;
import org.jmol.util.BinaryDocument;
import org.jmol.util.CompoundDocument;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.util.ZipUtil;
import org.jmol.viewer.MonitorInputStream;
import org.jmol.viewer.Viewer;

public class FileManager {
    protected Viewer viewer;
    private String openErrorMessage;
    private URL appletDocumentBase = null;
    private URL appletCodeBase = null;
    private String appletProxy;
    private String nameAsGiven = "zapped";
    private String fullPathName;
    private String fileName;
    private String fileType;
    private String inlineData;
    private String loadScript;
    FileReaderThread fileReaderThread;
    FilesReaderThread filesReaderThread;
    private DOMReaderThread aDOMReaderThread;
    private static final int URL_LOCAL = 3;
    private static final String[] urlPrefixes = new String[]{"http:", "https:", "ftp:", "file:"};
    private static final String[] urlPrefixPairs = new String[]{"http:", "http://", "www.", "http://www.", "https:", "https://", "ftp:", "ftp://", "file:", "file:///"};

    String getInlineData(int n) {
        return n < 0 ? this.inlineData : "";
    }

    FileManager(Viewer viewer) {
        this.viewer = viewer;
        this.clear();
    }

    String getState(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        if (stringBuffer != null) {
            stringBuffer.append("  _setFileState;\n");
            stringBuffer2.append("function _setFileState();\n\n");
        }
        stringBuffer2.append(this.loadScript);
        if (this.viewer.getModelSetFileName().equals("zapped")) {
            stringBuffer2.append("  zap;\n");
        }
        if (stringBuffer != null) {
            stringBuffer2.append("\nend function;\n\n");
        }
        return stringBuffer2.toString();
    }

    String getFileTypeName(String string) {
        int n = string.indexOf("::");
        if (n >= 0) {
            return string.substring(0, n);
        }
        Object object = this.getUnzippedBufferedReaderOrErrorMessageFromName(string, true, false, true);
        if (object instanceof BufferedReader) {
            return this.viewer.getModelAdapter().getFileTypeName((BufferedReader)object);
        }
        if (object instanceof ZipInputStream) {
            String string2 = this.getZipDirectoryAsString(string);
            return this.viewer.getModelAdapter().getFileTypeName(FileManager.getBufferedReaderForString(string2));
        }
        if (object instanceof String[]) {
            return ((String[])object)[0];
        }
        return null;
    }

    void clear() {
        this.setLoadScript("", false);
        this.nameAsGiven = "zapped";
        this.fileName = "zapped";
        this.fullPathName = "zapped";
    }

    String getLoadScript() {
        return this.loadScript;
    }

    private void setLoadScript(String string, boolean bl) {
        if (this.loadScript == null || !bl) {
            this.loadScript = "";
        }
        this.loadScript = this.loadScript + this.viewer.getLoadState();
        this.addLoadScript(string);
    }

    void addLoadScript(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("-")) {
            this.loadScript = "";
            return;
        }
        this.loadScript = this.loadScript + "  " + string + ";\n";
    }

    void createAtomSetCollectionFromFile(String string, Hashtable hashtable, String string2, boolean bl) {
        this.setLoadScript(string2, bl);
        int n = string.indexOf("::");
        this.nameAsGiven = n >= 0 ? string.substring(n + 2) : string;
        this.fileType = n >= 0 ? string.substring(0, n) : null;
        Logger.info("\nFileManager.getAtomSetCollectionFromFile(" + this.nameAsGiven + ") //" + string);
        this.fileName = null;
        this.fullPathName = null;
        this.openErrorMessage = null;
        String[] stringArray = this.classifyName(this.nameAsGiven, true);
        if (stringArray == null) {
            return;
        }
        this.setNames(stringArray);
        hashtable.put("fullPathName", (this.fileType == null ? "" : this.fileType + "::") + this.fullPathName.replace('\\', '/'));
        if (this.openErrorMessage != null) {
            Logger.error("file ERROR: " + this.openErrorMessage);
            return;
        }
        if (this.viewer.getMessageStyleChime() && this.viewer.getDebugScript()) {
            this.viewer.scriptStatus("Requesting " + this.fullPathName);
        }
        this.fileReaderThread = new FileReaderThread(this.fullPathName, this.nameAsGiven, this.fileType, null, hashtable);
        this.fileReaderThread.run();
    }

    void createAtomSetCollectionFromFiles(String string, String[] stringArray, String string2, boolean bl, Hashtable hashtable) {
        this.setLoadScript(string2, bl);
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = new String[stringArray.length];
        String[] stringArray4 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf("::");
            this.nameAsGiven = n >= 0 ? stringArray[i].substring(n + 2) : stringArray[i];
            this.fileType = n >= 0 ? stringArray[i].substring(0, n) : null;
            this.fileName = null;
            this.fullPathName = null;
            this.openErrorMessage = null;
            String[] stringArray5 = this.classifyName(this.nameAsGiven, true);
            if (stringArray5 == null) {
                return;
            }
            this.setNames(stringArray5);
            if (this.openErrorMessage != null) {
                Logger.error("file ERROR: " + this.openErrorMessage);
                return;
            }
            stringArray2[i] = this.fullPathName;
            stringArray[i] = this.fullPathName.replace('\\', '/');
            stringArray4[i] = this.fileType;
            stringArray3[i] = this.nameAsGiven;
        }
        this.fileName = this.nameAsGiven = string;
        this.fullPathName = this.nameAsGiven;
        this.inlineData = "";
        this.filesReaderThread = new FilesReaderThread(stringArray2, stringArray3, stringArray4, null, hashtable);
        this.filesReaderThread.run();
    }

    void createAtomSetCollectionFromString(String string, Hashtable hashtable, boolean bl) {
        String string2 = bl ? "append" : "model";
        String string3 = "data \"" + string2 + " inline\"\n" + string + "end \"" + string2 + " inline\";";
        this.setLoadScript(string3, bl);
        Logger.info("FileManager.getAtomSetCollectionFromString()");
        this.openErrorMessage = null;
        this.fileName = "string";
        this.fullPathName = "string";
        this.inlineData = string;
        this.fileReaderThread = new FileReaderThread("string", "string", null, FileManager.getBufferedReaderForString(string), hashtable);
        this.fileReaderThread.run();
    }

    void createAtomSeCollectionFromStrings(String[] stringArray, Hashtable hashtable, boolean bl) {
        String string = "\"" + this.viewer.getDataSeparator() + "\"";
        String string2 = "\"" + (bl ? "append" : "model") + " inline\"";
        String string3 = "set dataSeparator \"~~~next file~~~\";\ndata " + string2;
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string3 = string3 + "~~~next file~~~";
            }
            string3 = string3 + stringArray[i];
        }
        string3 = string3 + "end " + string2 + ";set dataSeparator " + string;
        this.setLoadScript(string3, bl);
        Logger.info("FileManager.getAtomSetCollectionFromStrings(string[])");
        this.openErrorMessage = null;
        this.fileName = "string[]";
        this.fullPathName = "string[]";
        this.inlineData = "";
        String[] stringArray2 = new String[stringArray.length];
        Reader[] readerArray = new StringReader[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = "string[" + i + "]";
            readerArray[i] = new StringReader(stringArray[i]);
        }
        this.filesReaderThread = new FilesReaderThread(stringArray2, stringArray2, null, readerArray, null);
        this.filesReaderThread.run();
    }

    void createAtomSetCollectionFromDOM(Object object) {
        this.openErrorMessage = null;
        this.fileName = "JSNode";
        this.fullPathName = "JSNode";
        this.inlineData = "";
        this.aDOMReaderThread = new DOMReaderThread(object);
        this.aDOMReaderThread.run();
    }

    void createAtomSetCollectionFromReader(String string, String string2, Reader reader) {
        this.openErrorMessage = null;
        this.fullPathName = string;
        this.fileName = string2;
        this.fileType = null;
        this.fileReaderThread = new FileReaderThread(string, string, this.fileType, new BufferedReader(reader), null);
        this.fileReaderThread.run();
    }

    static boolean isGzip(InputStream inputStream) throws Exception {
        byte[] byArray = new byte[4];
        inputStream.mark(5);
        int n = inputStream.read(byArray, 0, 4);
        inputStream.reset();
        return n == 4 && byArray[0] == 31 && byArray[1] == -117;
    }

    public Object getFileAsBytes(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        String[] stringArray = null;
        if (string.indexOf("|") >= 0) {
            stringArray = TextFormat.split(string, "|");
            string = stringArray[0];
        }
        if ((object = this.getInputStreamOrErrorMessageFromName(string, false)) instanceof String) {
            return "Error:" + object;
        }
        try {
            BufferedInputStream bufferedInputStream;
            BufferedInputStream bufferedInputStream2 = bufferedInputStream = new BufferedInputStream((InputStream)object, 8192);
            byte[] byArray = ZipUtil.isZipFile(bufferedInputStream2) && stringArray != null && 1 < stringArray.length ? ZipUtil.getZipFileContentsAsBytes(bufferedInputStream2, stringArray, 1) : ZipUtil.getStreamAsBytes(bufferedInputStream);
            ((InputStream)bufferedInputStream2).close();
            return byArray;
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    boolean getFileDataOrErrorAsString(String[] stringArray) {
        stringArray[1] = "";
        String string = stringArray[0];
        if (string == null) {
            return false;
        }
        Object object = this.getBufferedReaderOrErrorMessageFromName(string, stringArray, false);
        if (object instanceof String) {
            stringArray[1] = (String)object;
            return false;
        }
        try {
            String string2;
            BufferedReader bufferedReader = (BufferedReader)object;
            StringBuffer stringBuffer = new StringBuffer(8192);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append('\n');
            }
            bufferedReader.close();
            stringArray[1] = stringBuffer.toString();
            return true;
        }
        catch (Exception exception) {
            stringArray[1] = exception.getMessage();
            return false;
        }
    }

    Object getFileAsImage(String string, Hashtable hashtable) {
        if (string == null) {
            return "";
        }
        String[] stringArray = this.classifyName(string, true);
        if (stringArray == null) {
            return "cannot read file name: " + string;
        }
        Image image = null;
        this.fullPathName = stringArray[0].replace('\\', '/');
        if (FileManager.urlTypeIndex(this.fullPathName) >= 0) {
            try {
                image = Toolkit.getDefaultToolkit().createImage(new URL(this.fullPathName));
            }
            catch (Exception exception) {
                return "bad URL: " + this.fullPathName;
            }
        } else {
            image = Toolkit.getDefaultToolkit().createImage(this.fullPathName);
        }
        try {
            MediaTracker mediaTracker = new MediaTracker(this.viewer.getAwtComponent());
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (Exception exception) {
            return exception.getMessage() + " opening " + this.fullPathName;
        }
        if (image.getWidth(null) < 1) {
            return "invalid or missing image " + this.fullPathName;
        }
        hashtable.put("fullPathName", this.fullPathName);
        return image;
    }

    private String getFileDataAsSections(String[] stringArray, Hashtable hashtable) {
        String string = stringArray[1];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(hashtable.get(hashtable.get("OUTPUT")));
        for (int i = 2; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            string2 = this.getFileDataAsSections(string2, string, hashtable);
            Logger.info("reading " + string2);
            String string3 = (String)hashtable.get(string2);
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private String getFileDataAsSections(String string, String string2, Hashtable hashtable) {
        if (string == null) {
            return null;
        }
        String[] stringArray = null;
        boolean bl = false;
        String string3 = string.replace('\\', '/');
        if (string.indexOf(":asBinaryString") >= 0) {
            bl = true;
            string = string.substring(0, string.indexOf(":asBinaryString"));
        }
        StringBuffer stringBuffer = null;
        if (hashtable.containsKey(string3)) {
            return string3;
        }
        if (string.indexOf("#JMOL_MODEL ") >= 0) {
            hashtable.put(string3, string3 + "\n");
            return string3;
        }
        if (string.indexOf("|") >= 0) {
            stringArray = TextFormat.split(string, "|");
            string = stringArray[0];
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            Object object = this.getInputStreamOrErrorMessageFromName(string, false);
            if (object instanceof String) {
                hashtable.put(string3, (String)object + "\n");
                return string3;
            }
            bufferedInputStream = new BufferedInputStream((InputStream)object, 8192);
            if (CompoundDocument.isCompoundDocument(bufferedInputStream)) {
                CompoundDocument compoundDocument = new CompoundDocument(bufferedInputStream);
                compoundDocument.getAllData(string.replace('\\', '/'), "Molecule", hashtable);
            } else if (ZipUtil.isZipFile(bufferedInputStream)) {
                ZipUtil.getAllData(bufferedInputStream, stringArray, string.replace('\\', '/'), "Molecule", hashtable);
            } else if (bl) {
                BinaryDocument binaryDocument = new BinaryDocument();
                binaryDocument.setStream(bufferedInputStream, false);
                stringBuffer = new StringBuffer();
                if (string2 != null) {
                    stringBuffer.append("BEGIN Directory Entry " + string3 + "\n");
                }
                try {
                    while (true) {
                        stringBuffer.append(Integer.toHexString(binaryDocument.readByte() & 0xFF)).append(' ');
                    }
                }
                catch (Exception exception) {
                    stringBuffer.append('\n');
                    if (string2 != null) {
                        stringBuffer.append("\nEND Directory Entry " + string3 + "\n");
                    }
                    hashtable.put(string3, stringBuffer.toString());
                }
            } else {
                String string4;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(FileManager.isGzip(bufferedInputStream) ? new GZIPInputStream(bufferedInputStream) : bufferedInputStream));
                stringBuffer = new StringBuffer();
                if (string2 != null) {
                    stringBuffer.append("BEGIN Directory Entry " + string3 + "\n");
                }
                while ((string4 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string4);
                    stringBuffer.append('\n');
                }
                bufferedReader.close();
                if (string2 != null) {
                    stringBuffer.append("\nEND Directory Entry " + string3 + "\n");
                }
                hashtable.put(string3, stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            hashtable.put(string3, exception.getMessage());
        }
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!hashtable.containsKey(string3)) {
            hashtable.put(string3, "FILE NOT FOUND: " + string3 + "\n");
        }
        return string3;
    }

    Object getAtomSetCollectionOrError() {
        Object object = null;
        if (this.fileReaderThread != null) {
            object = this.fileReaderThread.atomSetCollection;
            if (this.fileReaderThread.errorMessage != null) {
                this.openErrorMessage = this.fileReaderThread.errorMessage;
            }
        } else if (this.filesReaderThread != null) {
            object = this.filesReaderThread.atomSetCollection;
            if (this.filesReaderThread.errorMessage != null) {
                this.openErrorMessage = this.filesReaderThread.errorMessage;
            }
        } else if (this.aDOMReaderThread != null) {
            object = this.aDOMReaderThread.atomSetCollection;
            if (this.aDOMReaderThread.errorMessage != null) {
                this.openErrorMessage = this.aDOMReaderThread.errorMessage;
            }
        }
        if (this.openErrorMessage != null) {
            return this.openErrorMessage;
        }
        if (object == null) {
            return "Client file is null loading:" + this.nameAsGiven;
        }
        return object;
    }

    void deallocateReaderThreads() {
        this.fileReaderThread = null;
        this.filesReaderThread = null;
        this.aDOMReaderThread = null;
        this.openErrorMessage = null;
    }

    String getFullPathName() {
        return this.fullPathName != null ? this.fullPathName : this.nameAsGiven;
    }

    void setFileInfo(String[] stringArray) {
        try {
            this.fullPathName = stringArray[0];
            this.fileName = stringArray[1];
            this.inlineData = stringArray[2];
            this.loadScript = stringArray[3];
        }
        catch (Exception exception) {
            Logger.error("Exception saving file info: " + exception.getMessage());
        }
    }

    String[] getFileInfo() {
        return new String[]{this.fullPathName, this.fileName, this.inlineData, this.loadScript};
    }

    String getFileName() {
        return this.fileName != null ? this.fileName : this.nameAsGiven;
    }

    String getAppletDocumentBase() {
        if (this.appletDocumentBase == null) {
            return "";
        }
        return this.appletDocumentBase.toString();
    }

    void setAppletContext(URL uRL, URL uRL2, String string) {
        this.appletDocumentBase = uRL;
        this.appletCodeBase = uRL2;
        Logger.info("appletDocumentBase=" + this.appletDocumentBase + "\nappletCodeBase=" + this.appletCodeBase);
        this.appletProxy = string;
    }

    void setAppletProxy(String string) {
        this.appletProxy = string == null || string.length() == 0 ? null : string;
    }

    private static int urlTypeIndex(String string) {
        for (int i = 0; i < urlPrefixes.length; ++i) {
            if (!string.startsWith(urlPrefixes[i])) continue;
            return i;
        }
        return -1;
    }

    private void setNames(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.fullPathName = stringArray[0];
        this.fileName = stringArray[1];
    }

    private String[] classifyName(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("?") && (string = this.viewer.dialogAsk("load", string.substring(1))) == null) {
            if (bl) {
                this.openErrorMessage = "#CANCELED#";
            }
            return null;
        }
        File file = null;
        URL uRL = null;
        String[] stringArray = null;
        if (string.indexOf("=") == 0) {
            string = TextFormat.formatString(this.viewer.getLoadFormat(), "FILE", string.substring(1));
        }
        if (string.indexOf(":") < 0 && string.indexOf("/") != 0) {
            string = FileManager.addDirectory(this.viewer.getDefaultDirectory(), string);
        }
        if (this.appletDocumentBase != null) {
            try {
                if (string.indexOf(":\\") == 1 || string.indexOf(":/") == 1) {
                    string = "file:/" + string;
                } else if (string.indexOf("/") == 0 && this.viewer.getBooleanProperty("_signedApplet")) {
                    string = "file:" + string;
                }
                uRL = new URL(this.appletDocumentBase, string);
            }
            catch (MalformedURLException malformedURLException) {
                if (bl) {
                    this.openErrorMessage = malformedURLException.getMessage();
                }
                return null;
            }
        } else if (FileManager.urlTypeIndex(string) >= 0) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                if (bl) {
                    this.openErrorMessage = malformedURLException.getMessage();
                }
                return null;
            }
        } else {
            file = new File(string);
            stringArray = new String[]{file.getAbsolutePath(), file.getName(), "file:/" + file.getAbsolutePath().replace('\\', '/')};
        }
        if (uRL != null) {
            stringArray = new String[3];
            stringArray[0] = stringArray[2] = uRL.toString();
            stringArray[1] = stringArray[0].substring(stringArray[0].lastIndexOf(47) + 1);
        }
        if (bl && (file != null || FileManager.urlTypeIndex(stringArray[0]) == 3)) {
            String string2 = file == null ? TextFormat.trim(stringArray[0].substring(5), "/") : stringArray[0];
            string2 = string2.substring(0, string2.length() - stringArray[1].length() - 1);
            FileManager.setLocalPath(this.viewer, string2, true);
        }
        return stringArray;
    }

    String getDefaultDirectory(String string) {
        String[] stringArray = this.classifyName(string, true);
        if (stringArray == null) {
            return "";
        }
        string = this.fixPath(stringArray[0]);
        return stringArray == null ? "" : string.substring(0, string.lastIndexOf("/"));
    }

    private String fixPath(String string) {
        string = string.replace('\\', '/');
        int n = (string = TextFormat.simpleReplace(string, "/./", "/")).lastIndexOf("//") + 1;
        if (n < 1) {
            n = string.indexOf(":/") + 1;
        }
        if (n < 1) {
            n = string.indexOf("/");
        }
        String string2 = string.substring(0, n);
        string = string.substring(n);
        while ((n = string.lastIndexOf("/../")) >= 0) {
            int n2 = string.substring(0, n).lastIndexOf("/");
            if (n2 < 0) {
                return TextFormat.simpleReplace(string2 + string, "/../", "/");
            }
            string = string.substring(0, n2) + string.substring(n + 3);
        }
        if (string.length() == 0) {
            string = "/";
        }
        return string2 + string;
    }

    public String getFullPath(String string, boolean bl) {
        String[] stringArray = this.classifyName(string, false);
        return stringArray == null ? "" : (bl ? stringArray[2] : stringArray[0].replace('\\', '/'));
    }

    public static String getLocalUrl(File file) {
        int n;
        if (file.getName().startsWith("=")) {
            return file.getName();
        }
        String string = file.getAbsolutePath().replace('\\', '/');
        for (n = 0; n < urlPrefixPairs.length; ++n) {
            if (string.indexOf(urlPrefixPairs[n]) != 0) continue;
            return null;
        }
        for (n = 0; n < urlPrefixPairs.length; n += 2) {
            if (string.indexOf(urlPrefixPairs[n]) <= 0) continue;
            return urlPrefixPairs[n + 1] + TextFormat.trim(string.substring(string.indexOf(urlPrefixPairs[n]) + urlPrefixPairs[n].length()), "/");
        }
        return null;
    }

    public static File getLocalDirectory(JmolViewer jmolViewer, boolean bl) {
        File file;
        String string = (String)jmolViewer.getParameter(bl ? "currentLocalPath" : "defaultDirectoryLocal");
        if (string.length() == 0 && bl) {
            string = (String)jmolViewer.getParameter("defaultDirectoryLocal");
        }
        if (string.length() == 0) {
            return jmolViewer.isApplet() ? null : new File(System.getProperty("user.dir"));
        }
        if (jmolViewer.isApplet() && string.indexOf("file:/") == 0) {
            string = FileManager.setLocalPathForWritingFile(jmolViewer, string);
        }
        return (file = new File(string)).isDirectory() ? file : file.getParentFile();
    }

    public static void setLocalPath(JmolViewer jmolViewer, String string, boolean bl) {
        while (string.endsWith("/") || string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        jmolViewer.setStringProperty("currentLocalPath", string);
        if (!bl) {
            jmolViewer.setStringProperty("defaultDirectoryLocal", string);
        }
    }

    public static String setLocalPathForWritingFile(JmolViewer jmolViewer, String string) {
        if (string.indexOf("file:/") == 0) {
            return string.substring(6);
        }
        if (string.indexOf("/") == 0 || string.indexOf(":") >= 0) {
            return string;
        }
        File file = FileManager.getLocalDirectory(jmolViewer, false);
        return file == null ? string : file.toString().replace('\\', '/') + "/" + string;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String addDirectory(String string, String string2) {
        String string3;
        if (string.length() == 0) {
            return string2;
        }
        int n = string2.length() > 0 ? (int)string2.charAt(0) : 32;
        String string4 = string.toLowerCase();
        if ((string4.endsWith(".zip") || string4.endsWith(".tar")) && n != 124 && n != 47) {
            string = string + "|";
        }
        StringBuffer stringBuffer = new StringBuffer().append(string);
        if (n != 47 && n != 47) {
            char c = string.charAt(string.length() - 1);
            n = c;
            if (c != '|' && n != 47) {
                string3 = "/";
                return stringBuffer.append(string3).append(string2).toString();
            }
        }
        string3 = "";
        return stringBuffer.append(string3).append(string2).toString();
    }

    Object getInputStreamOrErrorMessageFromName(String string, boolean bl) {
        return FileManager.getInputStream(string, bl, this.appletDocumentBase, this.appletProxy);
    }

    public static Object getInputStream(String string, boolean bl, URL uRL, String string2) {
        String string3 = null;
        int n = urlPrefixes.length;
        while (--n >= 0 && !string.startsWith(urlPrefixes[n])) {
        }
        boolean bl2 = n >= 0;
        boolean bl3 = uRL != null;
        InputStream inputStream = null;
        try {
            int n2;
            if (bl3 || bl2) {
                if (bl3 && bl2 && string2 != null) {
                    string = string2 + "?url=" + URLEncoder.encode(string, "utf-8");
                }
                URL uRL2 = bl3 ? new URL(uRL, string) : new URL(string);
                string = uRL2.toString();
                if (bl) {
                    Logger.info("FileManager opening " + uRL2.toString());
                }
                URLConnection uRLConnection = uRL2.openConnection();
                n2 = uRLConnection.getContentLength();
                inputStream = uRLConnection.getInputStream();
            } else {
                if (bl) {
                    Logger.info("FileManager opening " + string);
                }
                File file = new File(string);
                n2 = (int)file.length();
                inputStream = new FileInputStream(file);
            }
            return new MonitorInputStream(inputStream, n2);
        }
        catch (Exception exception) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            string3 = "" + exception;
            return string3;
        }
    }

    public static BufferedReader getBufferedReaderForString(String string) {
        return new BufferedReader(new StringReader(string));
    }

    Object getBufferedReaderOrErrorMessageFromName(String string, String[] stringArray, boolean bl) {
        String[] stringArray2 = this.classifyName(string, true);
        if (stringArray2 == null) {
            return "cannot read file name: " + string;
        }
        if (stringArray != null) {
            stringArray[0] = stringArray2[0].replace('\\', '/');
        }
        return this.getUnzippedBufferedReaderOrErrorMessageFromName(stringArray2[0], false, bl, false);
    }

    Object getUnzippedBufferedReaderOrErrorMessageFromName(String string, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        String[] stringArray = null;
        String[] stringArray2 = this.viewer.getModelAdapter().specialLoad(string, "filesNeeded?");
        if (stringArray2 != null) {
            if (bl3) {
                return stringArray2;
            }
            if (stringArray2[2] != null) {
                String string2 = stringArray2[1];
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                if (stringArray2.length == 3) {
                    String string3 = this.getFileDataAsSections(stringArray2[2], string2, hashtable);
                    hashtable.put("OUTPUT", string3);
                    stringArray2 = this.viewer.getModelAdapter().specialLoad(string, (String)hashtable.get(string3));
                    if (stringArray2.length == 3) {
                        string3 = this.getFileDataAsSections(stringArray2[2], string2, hashtable);
                        hashtable.put("OUTPUT", string3);
                        stringArray2 = this.viewer.getModelAdapter().specialLoad(stringArray2[1], (String)hashtable.get(string3));
                    }
                }
                return FileManager.getBufferedReaderForString(this.getFileDataAsSections(stringArray2, hashtable));
            }
        }
        if (string.indexOf("|") >= 0) {
            stringArray = TextFormat.split(string, "|");
            string = stringArray[0];
        }
        if ((object = this.getInputStreamOrErrorMessageFromName(string, true)) instanceof String) {
            return object;
        }
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object, 8192);
            FilterInputStream filterInputStream = bufferedInputStream;
            if (CompoundDocument.isCompoundDocument(filterInputStream)) {
                CompoundDocument compoundDocument = new CompoundDocument(bufferedInputStream);
                return FileManager.getBufferedReaderForString(compoundDocument.getAllData("Molecule").toString());
            }
            if (FileManager.isGzip(filterInputStream)) {
                filterInputStream = new GZIPInputStream(bufferedInputStream);
            } else if (ZipUtil.isZipFile(filterInputStream)) {
                if (bl) {
                    return new ZipInputStream(bufferedInputStream);
                }
                if (bl2) {
                    return (InputStream)ZipUtil.getZipFileContents(filterInputStream, stringArray, 1, true);
                }
                String string4 = (String)ZipUtil.getZipFileContents(filterInputStream, stringArray, 1, false);
                ((InputStream)filterInputStream).close();
                return FileManager.getBufferedReaderForString(string4);
            }
            if (bl2) {
                return filterInputStream;
            }
            return new BufferedReader(new InputStreamReader(filterInputStream));
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    String[] getZipDirectory(String string, boolean bl) {
        return ZipUtil.getZipDirectoryAndClose((InputStream)this.getInputStreamOrErrorMessageFromName(string, false), bl);
    }

    String getZipDirectoryAsString(String string) {
        return ZipUtil.getZipDirectoryAsStringAndClose((InputStream)this.getInputStreamOrErrorMessageFromName(string, false));
    }

    class FilesReaderThread
    implements Runnable,
    JmolFileReaderInterface {
        String errorMessage;
        private String[] fullPathNamesInThread;
        private String[] namesAsGivenInThread;
        private String[] fileTypesInThread;
        Object atomSetCollection;
        private Reader[] stringReaders;
        private Hashtable[] htParamsSet;
        private Hashtable htParams;

        FilesReaderThread(String[] stringArray, String[] stringArray2, String[] stringArray3, Reader[] readerArray, Hashtable hashtable) {
            this.fullPathNamesInThread = stringArray;
            this.namesAsGivenInThread = stringArray2;
            this.fileTypesInThread = stringArray3;
            this.stringReaders = readerArray;
            this.htParams = hashtable;
        }

        public void run() {
            if (this.stringReaders != null) {
                this.createAtomSetCollection();
                this.stringReaders = null;
            } else {
                this.htParamsSet = new Hashtable[this.fullPathNamesInThread.length];
                for (int i = 0; i < this.htParamsSet.length; ++i) {
                    this.htParamsSet[i] = this.htParams;
                }
                Object object = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionFromReaders(this, this.fullPathNamesInThread, this.fileTypesInThread, this.htParamsSet);
                if (object instanceof String) {
                    this.errorMessage = (String)object;
                } else {
                    this.atomSetCollection = object;
                }
                if (this.errorMessage != null) {
                    Logger.error("file ERROR: " + this.errorMessage);
                }
            }
        }

        private void createAtomSetCollection() {
            Object object = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionFromReaders(this, this.fullPathNamesInThread, this.fileTypesInThread, null);
            if (object == null) {
                return;
            }
            if (object instanceof String) {
                this.errorMessage = (String)object;
            } else {
                this.atomSetCollection = object;
            }
        }

        public BufferedReader getBufferedReader(int n) {
            Object object;
            if (this.stringReaders != null) {
                return new BufferedReader(this.stringReaders[n]);
            }
            String string = this.fullPathNamesInThread[n];
            String[] stringArray = null;
            Hashtable hashtable = this.htParamsSet[0];
            hashtable.remove("subFileList");
            if (string.indexOf("|") >= 0) {
                stringArray = TextFormat.split(string, "|");
                string = stringArray[0];
            }
            if ((object = FileManager.this.getUnzippedBufferedReaderOrErrorMessageFromName(string, true, false, false)) instanceof ZipInputStream) {
                if (stringArray != null) {
                    hashtable.put("subFileList", stringArray);
                }
                String[] stringArray2 = FileManager.this.getZipDirectory(string, true);
                BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)FileManager.this.getInputStreamOrErrorMessageFromName(string, false), 8192);
                object = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionOrBufferedReaderFromZip(bufferedInputStream, string, stringArray2, hashtable, true);
            }
            if (object instanceof BufferedReader) {
                return (BufferedReader)object;
            }
            this.errorMessage = object == null ? "error opening:" + this.namesAsGivenInThread[n] : (String)object;
            return null;
        }
    }

    class FileReaderThread
    implements Runnable {
        String errorMessage;
        String fullPathNameInThread;
        String nameAsGivenInThread;
        String fileTypeInThread;
        Object atomSetCollection;
        BufferedReader reader;
        Hashtable htParams;

        FileReaderThread(String string, String string2, String string3, BufferedReader bufferedReader, Hashtable hashtable) {
            this.fullPathNameInThread = string;
            this.nameAsGivenInThread = string2;
            this.fileTypeInThread = string3;
            this.reader = bufferedReader;
            this.htParams = hashtable;
        }

        public void run() {
            if (this.reader != null) {
                this.createAtomSetCollection();
            } else {
                String string = this.fullPathNameInThread;
                String[] stringArray = null;
                Object object = FileManager.this.getUnzippedBufferedReaderOrErrorMessageFromName(string, true, false, false);
                if (string.indexOf("|") >= 0) {
                    stringArray = TextFormat.split(string, "|");
                    string = stringArray[0];
                }
                if (object instanceof BufferedReader) {
                    this.reader = (BufferedReader)object;
                    this.createAtomSetCollection();
                } else if (object instanceof ZipInputStream) {
                    if (stringArray != null) {
                        this.htParams.put("subFileList", stringArray);
                    }
                    this.createAtomSetCollection(string, (ZipInputStream)object);
                } else {
                    String string2 = this.errorMessage = object == null ? "error opening:" + this.nameAsGivenInThread : (String)object;
                }
            }
            if (this.errorMessage != null) {
                Logger.error("file ERROR: " + this.fullPathNameInThread + "\n" + this.errorMessage);
            }
        }

        private void createAtomSetCollection(String string, ZipInputStream zipInputStream) {
            String[] stringArray = FileManager.this.getZipDirectory(string, true);
            Object object = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionOrBufferedReaderFromZip(zipInputStream, string, stringArray, this.htParams, false);
            if (object instanceof String) {
                this.errorMessage = (String)object;
            } else {
                this.atomSetCollection = object;
            }
            try {
                zipInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void createAtomSetCollection() {
            Object object = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionFromReader(this.fullPathNameInThread, this.fileTypeInThread, this.reader, this.htParams);
            if (object instanceof String) {
                this.errorMessage = (String)object;
            } else {
                this.atomSetCollection = object;
            }
        }
    }

    class DOMReaderThread
    implements Runnable {
        String errorMessage;
        Object aDOMNode;
        Object atomSetCollection;

        DOMReaderThread(Object object) {
            this.aDOMNode = object;
        }

        public void run() {
            this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionFromDOM(this.aDOMNode);
            this.errorMessage = null;
        }
    }
}

