/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class SplashPanel
extends JPanel
implements MouseListener,
Runnable {
    PlinkoNegativeBinomial plinko;
    double w;
    double h;
    int TOTAL;
    int[] HIST;
    double MAX;
    Point[][] PINS;
    double DIST;
    double BALL_RAD;
    int PIN_RAD;
    int BINS = 20;
    PlinkoBall FIRST_BALL;
    int BALL_COUNT;
    int BOTTOM_MARGIN = 5;
    private static final int hx = 15;
    private static final int hy = 15;
    private static final int bgGrey = 192;
    Image[] IMAGES;
    boolean newBackground = true;
    boolean active = true;
    Thread thread;
    Image background;
    Graphics2D backGraphics;
    int FUDGE = 200;

    public SplashPanel(PlinkoNegativeBinomial plinkoNegativeBinomial) {
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.plinko = plinkoNegativeBinomial;
        for (int i = 0; i < 25; ++i) {
            this.dropBall();
            this.FIRST_BALL.ROW = 10 + (int)(10.0 * Math.random());
            this.FIRST_BALL.COL = (int)((double)this.FIRST_BALL.ROW * Math.random());
            this.FIRST_BALL.C = 10;
            this.FIRST_BALL.t = i % 11;
        }
        this.start();
    }

    public void start() {
        this.active = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        while (this.active) {
            if (Math.random() < 0.4) {
                this.dropBall();
                this.FIRST_BALL.ROW = 11;
                this.FIRST_BALL.COL = (int)((double)this.FIRST_BALL.ROW * Math.random());
                this.FIRST_BALL.C = 10;
            }
            this.repaint();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void dropBall() {
        if (this.FIRST_BALL == null) {
            this.FIRST_BALL = new PlinkoBall();
        } else {
            this.FIRST_BALL.previousBall = new PlinkoBall();
            this.FIRST_BALL.previousBall.nextBall = this.FIRST_BALL;
            this.FIRST_BALL = this.FIRST_BALL.previousBall;
        }
    }

    public void setup() {
        int n;
        this.DIST = this.h - (double)this.BOTTOM_MARGIN < this.h / 2.0 ? (this.h - (double)this.BOTTOM_MARGIN) / (double)this.BINS : (this.w - 10.0) / (double)(2 * this.BINS);
        this.PIN_RAD = (int)this.DIST / 9 + 1;
        this.BALL_RAD = Math.max(2.0 * this.DIST / 7.0, 2.0) + 1.0;
        this.IMAGES = new Image[PlinkoBoard.COLORS.length];
        for (n = 0; n < PlinkoBoard.COLORS.length; ++n) {
            this.IMAGES[n] = PlinkoBoard.getBall(this.BALL_RAD, PlinkoBoard.COLORS[n]);
        }
        this.PINS = new Point[this.BINS][];
        for (n = 0; n < this.BINS; ++n) {
            this.PINS[n] = new Point[n + 1];
            for (int i = 0; i <= n; ++i) {
                this.PINS[n][i] = new Point((int)(this.DIST * (double)(2 * i - n) + this.w / 2.0) - this.FUDGE / 2, (int)(this.DIST * (double)(n + 1)) - (this.FUDGE - 15));
            }
        }
        for (n = 0; n < this.BINS; ++n) {
            this.PINS[this.BINS - 1][n] = new Point((int)(this.DIST * (double)(2 * n - this.BINS + 1) + this.w / 2.0), (int)(this.h - 30.0 - this.BALL_RAD));
        }
    }

    public void paintComponent(Graphics graphics) {
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.h = this.w = (double)(Math.max(this.getWidth(), this.getHeight()) + this.FUDGE);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.background == null || (double)this.background.getWidth(this) != this.h || (double)this.background.getHeight(this) != this.w) {
            this.setup();
            this.background = this.createImage((int)this.w, (int)this.h);
            this.drawBackground((int)this.w, (int)this.h);
        }
        graphics2D.drawImage(this.background, 0, 0, this);
        Object object = this.FIRST_BALL;
        while (object != null) {
            graphics.drawImage(this.IMAGES[((PlinkoBall)object).spaz], (int)(((PlinkoBall)object).X - this.BALL_RAD), (int)(((PlinkoBall)object).Y - 2.0 * this.BALL_RAD - (double)this.PIN_RAD + 1.0), this);
            if (this.active) {
                this.increment((PlinkoBall)object);
            }
            object = ((PlinkoBall)object).nextBall;
        }
        this.w = this.getWidth();
        this.h = this.getHeight();
        graphics2D.setColor(new Color(128, 128, 128, 220));
        graphics2D.setFont(new Font("Helvetica", 1, this.plinko.font_size));
        object = this.plinko.click_text;
        graphics2D.drawString((String)object, (int)(this.w - (double)graphics2D.getFontMetrics().stringWidth((String)object) - 5.0), (int)(this.h - 5.0));
    }

    public void increment(PlinkoBall plinkoBall) {
        if (plinkoBall.t == plinkoBall.C && plinkoBall.ROW < this.BINS - 2) {
            ++plinkoBall.ROW;
            plinkoBall.COL += plinkoBall.DIR;
            plinkoBall.t = 0;
            plinkoBall.DIR = 0;
            if (Math.random() < 0.5) {
                plinkoBall.DIR = 1;
            }
            plinkoBall.C = 10;
        }
        double d = this.DIST * (double)plinkoBall.t * (double)(2 * plinkoBall.DIR - 1) / (double)plinkoBall.C;
        if (plinkoBall.ROW < 0) {
            plinkoBall.X = this.PINS[0][0].x;
            d = Math.abs(d);
            plinkoBall.Y = (double)this.PINS[0][0].y - this.DIST + this.DIST * (double)plinkoBall.t * (double)plinkoBall.t / (double)(plinkoBall.C * plinkoBall.C);
        } else if (plinkoBall.ROW < this.BINS - 2) {
            plinkoBall.X = (double)this.PINS[plinkoBall.ROW][plinkoBall.COL].x + d;
            d = Math.abs(d);
            plinkoBall.Y = (double)this.PINS[plinkoBall.ROW][plinkoBall.COL].y - this.DIST * PlinkoBoard.DYS[plinkoBall.C][plinkoBall.t];
        } else {
            plinkoBall.X = (double)this.PINS[plinkoBall.ROW][plinkoBall.COL].x + d;
            plinkoBall.X = d > 0.0 ? Math.min(plinkoBall.X, (double)this.PINS[plinkoBall.ROW][plinkoBall.COL].x + 2.0 * this.DIST - this.BALL_RAD) : Math.max(plinkoBall.X, (double)this.PINS[plinkoBall.ROW][plinkoBall.COL].x - 2.0 * this.DIST + this.BALL_RAD + 1.0);
            d = Math.abs(d);
            PlinkoBall plinkoBall2 = plinkoBall;
            PlinkoBall plinkoBall3 = plinkoBall;
            plinkoBall.Y = (double)this.PINS[plinkoBall.ROW][plinkoBall.COL].y - d * (PlinkoBall.A * d / this.DIST + PlinkoBall.B);
        }
        ++plinkoBall.t;
        if (plinkoBall.Y > this.h - (double)this.BOTTOM_MARGIN - (double)this.PIN_RAD) {
            if (plinkoBall.previousBall != null && plinkoBall.nextBall != null) {
                plinkoBall.previousBall.nextBall = plinkoBall.nextBall;
                plinkoBall.nextBall.previousBall = plinkoBall.previousBall;
            } else if (plinkoBall.previousBall != null && plinkoBall.nextBall == null) {
                plinkoBall.previousBall.nextBall = null;
            } else if (plinkoBall.previousBall == null && plinkoBall.nextBall != null) {
                plinkoBall.nextBall.previousBall = null;
                this.FIRST_BALL = plinkoBall.nextBall;
            } else {
                this.FIRST_BALL = null;
            }
            --this.BALL_COUNT;
        }
    }

    public void drawBackground(int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)this.background.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(Color.black);
        Image image = PlinkoBoard.getBall(this.PIN_RAD, Color.black);
        for (int i = 0; i < this.BINS - 1; ++i) {
            for (int j = 0; j <= i; ++j) {
                Point point = this.PINS[i][j];
                graphics2D.drawImage(image, point.x - this.PIN_RAD, point.y - this.PIN_RAD, this);
            }
        }
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.active = false;
        this.plinko.showFrame();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

