/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.io.IOException;
import org.freehep.graphicsio.PathConstructor;

public abstract class AbstractPathConstructor
implements PathConstructor {
    protected double currentX = 0.0;
    protected double currentY = 0.0;

    protected AbstractPathConstructor() {
    }

    public void flush() throws IOException {
        this.currentX = 0.0;
        this.currentY = 0.0;
    }

    public boolean addPath(Shape shape) throws IOException {
        return this.addPath(shape, null);
    }

    public boolean addPath(Shape shape, AffineTransform affineTransform) throws IOException {
        return AbstractPathConstructor.addPath(this, shape, affineTransform);
    }

    public static boolean addPath(PathConstructor pathConstructor, Shape shape, AffineTransform affineTransform) throws IOException {
        PathIterator pathIterator = shape.getPathIterator(affineTransform);
        double[] dArray = new double[6];
        double d2 = 0.0;
        double d3 = 0.0;
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(dArray);
            switch (n2) {
                case 0: {
                    pathConstructor.move(dArray[0], dArray[1]);
                    d2 = dArray[0];
                    d3 = dArray[1];
                    break;
                }
                case 1: {
                    pathConstructor.line(dArray[0], dArray[1]);
                    break;
                }
                case 2: {
                    pathConstructor.quad(dArray[0], dArray[1], dArray[2], dArray[3]);
                    break;
                }
                case 3: {
                    pathConstructor.cubic(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                    break;
                }
                case 4: {
                    pathConstructor.closePath(d2, d3);
                }
            }
            pathIterator.next();
        }
        pathConstructor.flush();
        return pathIterator.getWindingRule() == 0;
    }

    public static boolean isEvenOdd(Shape shape) {
        return shape.getPathIterator(null).getWindingRule() == 0;
    }
}

