/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import javax.swing.JCheckBox;
import org.freehep.graphicsio.exportchooser.Options;

public class OptionCheckBox
extends JCheckBox
implements Options {
    protected boolean initialState;
    protected String key;

    public OptionCheckBox(Properties properties, String string, String string2) {
        super(string2, (boolean)new Boolean(properties.getProperty(string, "false")));
        this.key = string;
        this.initialState = this.isSelected();
    }

    public boolean applyChangedOptions(Properties properties) {
        if (this.isSelected() != this.initialState) {
            properties.setProperty(this.key, Boolean.toString(this.isSelected()));
            return true;
        }
        return false;
    }

    public void enables(final Component component) {
        if (component.isEnabled()) {
            component.setEnabled(this.isSelected());
            this.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    component.setEnabled(OptionCheckBox.this.isSelected());
                }
            });
            this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                        component.setEnabled(OptionCheckBox.this.isSelected());
                    } else {
                        component.setEnabled(false);
                    }
                }
            });
        }
    }

    public void disables(final Component component) {
        if (component.isEnabled()) {
            component.setEnabled(!this.isSelected());
            this.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    component.setEnabled(!OptionCheckBox.this.isSelected());
                }
            });
            this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                        component.setEnabled(!OptionCheckBox.this.isSelected());
                    } else {
                        component.setEnabled(false);
                    }
                }
            });
        }
    }

    public void shows(final Component component) {
        component.setVisible(this.isSelected());
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                component.setVisible(OptionCheckBox.this.isSelected());
            }
        });
    }

    public void hides(final Component component) {
        component.setVisible(!this.isSelected());
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                component.setVisible(!OptionCheckBox.this.isSelected());
            }
        });
    }
}

