/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import org.freehep.graphicsio.exportchooser.Options;

public class OptionComboBox
extends JComboBox
implements Options {
    protected String initialSelectedItem;
    protected String key;

    public OptionComboBox(Properties properties, String string, String[] stringArray) {
        super(stringArray);
        this.setSelectedItem(properties.getProperty(string, stringArray[0]));
        this.setEnabled(stringArray.length > 1);
        this.key = string;
        this.initialSelectedItem = (String)this.getSelectedItem();
    }

    public boolean applyChangedOptions(Properties properties) {
        if (!this.getSelectedItem().equals(this.initialSelectedItem)) {
            properties.setProperty(this.key, (String)this.getSelectedItem());
            return true;
        }
        return false;
    }

    public void enables(final String string, final Component component) {
        if (component.isEnabled()) {
            component.setEnabled(this.getSelectedItem().equals(string));
            this.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    component.setEnabled(OptionComboBox.this.getSelectedItem().equals(string));
                }
            });
        }
    }

    public void shows(final String string, final Component component) {
        component.setVisible(this.getSelectedItem().equals(string));
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                component.setVisible(OptionComboBox.this.getSelectedItem().equals(string));
            }
        });
    }

    public void selects(final String string, final AbstractButton abstractButton) {
        abstractButton.setSelected(this.getSelectedItem().equals(string));
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                abstractButton.setSelected(OptionComboBox.this.getSelectedItem().equals(string));
            }
        });
    }
}

