/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.svg;

import java.awt.Shape;
import java.awt.font.GlyphMetrics;
import java.awt.geom.AffineTransform;
import org.freehep.graphicsio.svg.SVGGraphics2D;

public class SVGGlyph {
    public static int FONT_SIZE = 100;
    public static int UNITS_PER_EM = 2048;
    private Shape glyph;
    private int unicode;
    private GlyphMetrics glyphMetrics;
    private static AffineTransform defaultTransform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);

    public SVGGlyph(Shape shape, int n2, GlyphMetrics glyphMetrics) {
        this.unicode = n2;
        this.glyph = shape;
        this.glyphMetrics = glyphMetrics;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<glyph ");
        stringBuffer.append("unicode=\"");
        String string = "0000" + Integer.toHexString(this.unicode);
        stringBuffer.append("&#x");
        stringBuffer.append(string.substring(string.length() - 4));
        stringBuffer.append(';');
        stringBuffer.append("\" ");
        if (this.glyphMetrics != null) {
            stringBuffer.append(this.getHorizontalAdvanceXString());
            stringBuffer.append(this.getHorizontalAdvanceYString());
        }
        stringBuffer.append(this.getPathString());
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    protected String getPathString() {
        return SVGGraphics2D.getPathContent(this.glyph.getPathIterator(defaultTransform));
    }

    public String getHorizontalAdvanceXString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.glyphMetrics.getAdvanceX() != 0.0f) {
            stringBuffer.append("horiz-adv-x=\"");
            stringBuffer.append(SVGGraphics2D.fixedPrecision(this.glyphMetrics.getAdvanceX()));
            stringBuffer.append("\" ");
        }
        return stringBuffer.toString();
    }

    public String getHorizontalAdvanceYString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.glyphMetrics.getAdvanceY() != 0.0f) {
            stringBuffer.append("horiz-adv-y=\"");
            stringBuffer.append(SVGGraphics2D.fixedPrecision(this.glyphMetrics.getAdvanceY()));
            stringBuffer.append("\" ");
        }
        return stringBuffer.toString();
    }
}

