/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import junit.framework.AssertionFailedError;

public class Assert
extends junit.framework.Assert {
    protected Assert() {
    }

    public static void assertEquals(File file, File file2, boolean bl2) throws FileNotFoundException, IOException {
        FilterInputStream filterInputStream = new BufferedInputStream(new FileInputStream(file));
        if (file.getPath().toLowerCase().endsWith(".gz")) {
            filterInputStream = new GZIPInputStream(filterInputStream);
        }
        FilterInputStream filterInputStream2 = new BufferedInputStream(new FileInputStream(file2));
        if (file2.getPath().toLowerCase().endsWith(".gz")) {
            filterInputStream2 = new GZIPInputStream(filterInputStream2);
        }
        Assert.assertEquals(filterInputStream, filterInputStream2, bl2, "File " + file2.getPath());
    }

    public static void assertEquals(InputStream inputStream, InputStream inputStream2, boolean bl2, String string) throws IOException {
        if (bl2) {
            int n2 = Assert.diff(inputStream, inputStream2);
            if (n2 >= 0) {
                throw new AssertionFailedError(string + ": comparison failed at offset " + n2);
            }
        } else {
            int n3 = Assert.diff(new BufferedReader(new InputStreamReader(inputStream)), new BufferedReader(new InputStreamReader(inputStream2)));
            if (n3 >= 0) {
                throw new AssertionFailedError(string + ": comparison failed at line " + n3);
            }
        }
    }

    private static int diff(InputStream inputStream, InputStream inputStream2) throws IOException {
        int n2;
        int n3;
        int n4 = 0;
        do {
            n3 = inputStream.read();
            n2 = inputStream2.read();
            ++n4;
        } while (n3 >= 0 && n2 >= 0 && n3 == n2);
        inputStream.close();
        inputStream2.close();
        return n3 == n2 ? -1 : n4 - 1;
    }

    private static int diff(BufferedReader bufferedReader, BufferedReader bufferedReader2) throws IOException {
        String string;
        String string2;
        int n2 = 1;
        do {
            string2 = bufferedReader.readLine();
            string = bufferedReader2.readLine();
            ++n2;
        } while (string2 != null && string != null && string2.equals(string));
        bufferedReader.close();
        bufferedReader2.close();
        return string2 == null && string == null ? -1 : n2 - 1;
    }
}

