/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class DoubleHashtable
extends AbstractCollection
implements Serializable {
    private static final long serialVersionUID = -545653328241864972L;
    private Hashtable table = new Hashtable();

    public void clear() {
        this.table.clear();
    }

    public void clear(Object object) {
        Hashtable hashtable = this.get(object);
        if (hashtable != null) {
            hashtable.clear();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("DoubleHashtable.clone() is not (yet) supported.");
    }

    public boolean contains(Object object) {
        if (object == null) {
            object = this;
        }
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = this.get(enumeration.nextElement());
            if (!hashtable.contains(object)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object object) {
        if (object == null) {
            object = this;
        }
        return this.table.containsKey(object);
    }

    public boolean containsKey(Object object, Object object2) {
        Hashtable hashtable;
        if (object2 == null) {
            object2 = this;
        }
        return (hashtable = this.get(object)) != null ? hashtable.containsKey(object2) : false;
    }

    public Enumeration elements() {
        return new Enumeration(){
            private Enumeration subtableEnumeration;
            private Enumeration valueEnumeration;
            private Object nullValue;
            {
                this.subtableEnumeration = DoubleHashtable.this.table.elements();
                this.nullValue = DoubleHashtable.this;
            }

            public boolean hasMoreElements() {
                if (this.valueEnumeration == null || !this.valueEnumeration.hasMoreElements()) {
                    if (!this.subtableEnumeration.hasMoreElements()) {
                        return false;
                    }
                    this.valueEnumeration = ((Hashtable)this.subtableEnumeration.nextElement()).elements();
                }
                return true;
            }

            public Object nextElement() {
                this.hasMoreElements();
                Object e2 = this.valueEnumeration.nextElement();
                return e2 == this.nullValue ? null : e2;
            }
        };
    }

    public Iterator iterator() {
        return new Iterator(){
            private Iterator subtableIterator;
            private Map subtable;
            private Iterator valueIterator;
            private Object nullValue;
            {
                this.subtableIterator = DoubleHashtable.this.table.entrySet().iterator();
                this.nullValue = DoubleHashtable.this;
            }

            public boolean hasNext() {
                if (this.valueIterator == null || !this.valueIterator.hasNext()) {
                    if (!this.subtableIterator.hasNext()) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)this.subtableIterator.next();
                    this.subtable = (Map)entry.getValue();
                    this.valueIterator = this.subtable.entrySet().iterator();
                }
                return true;
            }

            public Object next() {
                this.hasNext();
                Map.Entry entry = (Map.Entry)this.valueIterator.next();
                Object v2 = entry.getValue();
                return v2 == this.nullValue ? null : v2;
            }

            public void remove() {
                this.valueIterator.remove();
                if (this.subtable.isEmpty()) {
                    this.subtableIterator.remove();
                }
            }
        };
    }

    public Hashtable get(Object object) {
        if (object == null) {
            object = this;
        }
        return (Hashtable)this.table.get(object);
    }

    public Object get(Object object, Object object2) {
        Hashtable hashtable;
        if (object2 == null) {
            object2 = this;
        }
        Object var4_4 = (hashtable = this.get(object)) == null ? null : hashtable.get(object2);
        return var4_4 == this ? null : var4_4;
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public Enumeration keys() {
        return this.table.keys();
    }

    public Enumeration keys(Object object) {
        final Hashtable hashtable = this.get(object);
        return new Enumeration(){
            private Enumeration subkeys;
            private Object nullKey;
            {
                this.subkeys = hashtable == null ? null : hashtable.keys();
                this.nullKey = DoubleHashtable.this;
            }

            public boolean hasMoreElements() {
                return this.subkeys == null ? false : this.subkeys.hasMoreElements();
            }

            public Object nextElement() {
                if (this.subkeys == null) {
                    throw new NoSuchElementException();
                }
                Object e2 = this.subkeys.nextElement();
                return e2 == this.nullKey ? null : e2;
            }
        };
    }

    public Object put(Object object, Object object2, Object object3) {
        Hashtable<Object, Object> hashtable = this.get(object);
        if (hashtable == null) {
            hashtable = new Hashtable<Object, Object>();
            if (object == null) {
                object = this;
            }
            this.table.put(object, hashtable);
        }
        if (object2 == null) {
            object2 = this;
        }
        if (object3 == null) {
            object3 = this;
        }
        Object v2 = hashtable.get(object2);
        hashtable.put(object2, object3);
        return v2 == this ? null : v2;
    }

    public Object remove(Object object, Object object2) {
        Hashtable hashtable = this.get(object);
        if (hashtable == null) {
            return null;
        }
        if (object2 == null) {
            object2 = this;
        }
        Object v2 = hashtable.remove(object2);
        if (hashtable.isEmpty()) {
            if (object == null) {
                object = this;
            }
            this.table.remove(object);
        }
        return v2 == this ? null : v2;
    }

    public int size() {
        int n2 = 0;
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            Hashtable hashtable = this.get(k2);
            n2 += hashtable.size();
        }
        return n2;
    }

    public String toString() {
        return "DoubleHashtable@" + this.hashCode();
    }
}

