/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import org.freehep.util.io.FinishableOutputStream;

public class CompressableOutputStream
extends FilterOutputStream
implements FinishableOutputStream {
    private boolean compress = false;
    private DeflaterOutputStream dos;

    public CompressableOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(int n2) throws IOException {
        if (this.compress) {
            this.dos.write(n2);
        } else {
            this.out.write(n2);
        }
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        for (int i2 = 0; i2 < n3; ++i2) {
            this.write(byArray[n2 + i2]);
        }
    }

    public void finish() throws IOException {
        if (this.compress) {
            this.dos.finish();
        }
        if (this.out instanceof FinishableOutputStream) {
            ((FinishableOutputStream)((Object)this.out)).finish();
        }
    }

    public void close() throws IOException {
        if (this.compress) {
            this.finish();
            this.dos.close();
        } else {
            this.out.close();
        }
    }

    public void startCompressing() throws IOException {
        this.out.flush();
        this.compress = true;
        this.dos = new DeflaterOutputStream(this.out);
    }
}

