/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.freehep.util.io.Action;
import org.freehep.util.io.ActionHeader;
import org.freehep.util.io.ActionSet;
import org.freehep.util.io.ByteCountInputStream;
import org.freehep.util.io.IncompleteActionException;
import org.freehep.util.io.IncompleteTagException;
import org.freehep.util.io.Tag;
import org.freehep.util.io.TagHeader;
import org.freehep.util.io.TagSet;

public abstract class TaggedInputStream
extends ByteCountInputStream {
    protected TagSet tagSet;
    protected ActionSet actionSet;

    public TaggedInputStream(InputStream inputStream, TagSet tagSet, ActionSet actionSet) {
        this(inputStream, tagSet, actionSet, false);
    }

    public TaggedInputStream(InputStream inputStream, TagSet tagSet, ActionSet actionSet, boolean bl2) {
        super(inputStream, bl2, 8);
        this.tagSet = tagSet;
        this.actionSet = actionSet;
    }

    public void addTag(Tag tag) {
        this.tagSet.addTag(tag);
    }

    protected abstract TagHeader readTagHeader() throws IOException;

    public Tag readTag() throws IOException {
        TagHeader tagHeader = this.readTagHeader();
        if (tagHeader == null) {
            return null;
        }
        int n2 = (int)tagHeader.getLength();
        Tag tag = this.tagSet.get(tagHeader.getTag());
        this.pushBuffer(n2);
        tag = tag.read(tagHeader.getTag(), this, n2);
        byte[] byArray = this.popBuffer();
        if (byArray != null) {
            throw new IncompleteTagException(tag, byArray);
        }
        return tag;
    }

    public void addAction(Action action) {
        this.actionSet.addAction(action);
    }

    protected abstract ActionHeader readActionHeader() throws IOException;

    public Action readAction() throws IOException {
        ActionHeader actionHeader = this.readActionHeader();
        if (actionHeader == null) {
            return null;
        }
        int n2 = (int)actionHeader.getLength();
        Action action = this.actionSet.get(actionHeader.getAction());
        this.pushBuffer(n2);
        action = action.read(actionHeader.getAction(), this, n2);
        byte[] byArray = this.popBuffer();
        if (byArray != null) {
            throw new IncompleteActionException(action, byArray);
        }
        return action;
    }
}

