/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel;

import atp.sHotEqn;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.TextField;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import rene.dialogs.Warning;
import rene.gui.CloseDialog;
import rene.gui.Global;
import rene.gui.MyCheckboxMenuItem;
import rene.gui.MyMenuItem;
import rene.util.FileName;
import rene.util.ImageSelection;
import rene.util.MyVector;
import rene.util.PngEncoder;
import rene.util.sort.SortObject;
import rene.util.sort.Sorter;
import rene.util.xml.XmlReader;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTagPI;
import rene.util.xml.XmlTree;
import rene.util.xml.XmlWriter;
import rene.zirkel.DragThread;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelApplet;
import rene.zirkel.ZirkelCanvasInterface;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.ChangedListener;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionDisplayPanel;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Count;
import rene.zirkel.construction.Interpreter;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.IntersectionConstructor;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.dialogs.AgainQuestion;
import rene.zirkel.dialogs.DefineMacro;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.dialogs.MessageWindow;
import rene.zirkel.dialogs.ReplaceMacroQuestion;
import rene.zirkel.dialogs.SelectDialog;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.graphics.Drawing;
import rene.zirkel.graphics.LatexOutput;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics11;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.graphics.MyGraphicsEPS;
import rene.zirkel.graphics.MyGraphicsFig;
import rene.zirkel.graphics.MyGraphicsPDF;
import rene.zirkel.graphics.MyGraphicsSvg;
import rene.zirkel.graphics.PolygonDrawer;
import rene.zirkel.graphics.TrackPainter;
import rene.zirkel.listener.AddEventListener;
import rene.zirkel.listener.DoneListener;
import rene.zirkel.listener.StatusListener;
import rene.zirkel.macro.Macro;
import rene.zirkel.macro.MacroBar;
import rene.zirkel.macro.MacroItem;
import rene.zirkel.macro.MacroMenu;
import rene.zirkel.macro.MacroRunner;
import rene.zirkel.macro.MacroSelectDialog;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.AreaObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FixedAngleObject;
import rene.zirkel.objects.FixedCircleObject;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PointonObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.RayObject;
import rene.zirkel.objects.SegmentObject;
import rene.zirkel.objects.TwoPointLineObject;
import rene.zirkel.objects.UserFunctionObject;
import rene.zirkel.structures.CoordinatesXY;
import rene.zirkel.tools.AnimatorTool;
import rene.zirkel.tools.BinderTool;
import rene.zirkel.tools.BreakpointAnimator;
import rene.zirkel.tools.EditTool;
import rene.zirkel.tools.LabelMover;
import rene.zirkel.tools.MetaMover;
import rene.zirkel.tools.MoverTool;
import rene.zirkel.tools.ObjectTracker;
import rene.zirkel.tools.SaveJob;
import rene.zirkel.tools.SetAwayTool;
import rene.zirkel.tools.SetCurveCenterTool;
import rene.zirkel.tools.SetFixedAngle;
import rene.zirkel.tools.SetFixedCircle;
import rene.zirkel.tools.SetRangeTool;
import rene.zirkel.tools.SetTargetsTool;
import rene.zirkel.tools.Tracker;
import rene.zirkel.tools.ZoomerTool;

public class ZirkelCanvas
extends Panel
implements MouseListener,
MouseMotionListener,
ItemListener,
AddEventListener,
ActionListener,
ChangedListener,
MouseWheelListener {
    ObjectConstructor OC = new MoverTool();
    Construction C = new Construction();
    Construction COriginal;
    StatusListener SL = null;
    public Image I = null;
    MyGraphics IG;
    Image Background = null;
    FontMetrics FM;
    double PointSize = 4.0;
    double MinPointSize = 3.0;
    double FontSize = 12.0;
    double MinFontSize = 12.0;
    public int IW = 0;
    public int IH = 0;
    public double Xmin;
    public double DX;
    public double Ymin;
    public double DY;
    boolean ShowHidden = false;
    Frame F = new Frame();
    boolean ReadOnly;
    boolean AllowRightMouse = true;
    PopupMenu PM;
    CheckboxMenuItem CheckboxHidden;
    MenuItem Replay;
    MenuItem Empty;
    boolean Job = false;
    String Last = "";
    Vector Targets = new Vector();
    ConstructionObject[] TargetO;
    ConstructionObject[] TargetS;
    int ShowColor = 0;
    public static double EditFactor = 1000000.0;
    public static double LengthsFactor = 100.0;
    public static double AnglesFactor = 1.0;
    public boolean Visual = Global.getParameter("options.visual", true);
    boolean All;
    boolean Interactive = true;
    public int GridColor = 0;
    public int GridThickness = 2;
    public boolean ShowGrid = false;
    public boolean AxesOnly = false;
    public boolean GridLabels = true;
    public boolean GridBold = false;
    public boolean GridLarge = false;
    public Dimension UseSize = null;
    ZirkelCanvasInterface ZCI;
    DoneListener DL;
    int Moved = 0;
    boolean Dragging = false;
    boolean RightClicked = false;
    boolean Control = false;
    public boolean SmartBoardPreview = false;
    DragThread DT = null;
    ConstructionObject LastPaint = null;
    boolean Frozen = false;
    MessageWindow MW;
    final double PointSizeFactor = 240.0;
    int CC = 0;
    MyVector Breaks = new MyVector();
    int[] xg = new int[64];
    int[] yg = new int[64];
    public double SelectionPointFactor = Global.getParameter("selectionsize", 1.5);
    public double Scale = 1.0;
    static char[] c = new char[20];
    int nc;
    MyVector V = new MyVector();
    boolean NewPoint = false;
    boolean IntersectionYes = false;
    MyVector Indicated = new MyVector();
    PointObject IndicatePoint = null;
    boolean Preview = false;
    ConstructionObject LastNonPreview = null;
    MoveableObject PreviewObject = null;
    Vector Macros = new Vector();
    public boolean ProtectMacros = false;
    public MacroMenu MM = null;
    public String MacroCurrentComment;
    MacroBar MBar;
    TextField TF;
    Image OldBackground = null;
    MyVector Drawings = new MyVector();
    int PointLast;
    int LineLast;
    int AngleLast;
    sHotEqn HE = null;
    public ConstructionDisplayPanel CDP = null;

    public ZirkelCanvas(boolean bl, boolean bl2, boolean bl3) {
        this.ReadOnly = bl;
        boolean bl4 = this.AllowRightMouse = !bl;
        if (Global.getParameter("options.nopopupmenu", false)) {
            this.PM = null;
        } else if (this.ReadOnly) {
            this.PM = new PopupMenu();
            this.CheckboxHidden = new MyCheckboxMenuItem(Zirkel.name("popup.hidden"));
            this.CheckboxHidden.addItemListener(this);
            if (bl3) {
                this.PM.add(this.CheckboxHidden);
            }
            this.Replay = new MyMenuItem(Zirkel.name("popup.replay"));
            this.Replay.addActionListener(this);
            if (bl2) {
                this.PM.add(this.Replay);
            }
            if (bl3 || bl2) {
                this.add(this.PM);
            } else {
                this.PM = null;
            }
        } else {
            this.PM = new PopupMenu();
            this.Empty = new MyMenuItem(Zirkel.name("popup.empty"));
            this.add(this.PM);
        }
        this.C.CL = this;
        this.clear();
        this.updateDigits();
        this.C.addAddEventListener(this);
        this.addMouseWheelListener(this);
    }

    public ZirkelCanvas(boolean bl) {
        this(bl, true, true);
    }

    public ZirkelCanvas() {
        this(false, true, true);
    }

    public Dimension getMinimumSize() {
        if (this.Background == null || !Global.getParameter("background.usesize", false)) {
            if (this.UseSize != null) {
                return this.UseSize;
            }
            return new Dimension(600, 600);
        }
        int n = this.Background.getWidth(this);
        if (n < 10) {
            return new Dimension(600, 600);
        }
        int n2 = this.Background.getHeight(this);
        if (Global.getParameter("background.usewidth", false)) {
            int n3 = this.getSize().width;
            int n4 = (int)((double)n2 / (double)n * (double)n3 + 0.5);
            return new Dimension(n3, n4);
        }
        return new Dimension(n, n2);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void updateDigits() {
        EditFactor = Math.pow(10.0, Global.getParameter("digits.edit", 5));
        LengthsFactor = Math.pow(10.0, Global.getParameter("digits.lengths", 5));
        AnglesFactor = Math.pow(10.0, Global.getParameter("digits.angles", 0));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.CheckboxHidden) {
            this.ShowHidden = this.CheckboxHidden.getState();
            this.repaint();
        }
    }

    public void setZirkelCanvasListener(ZirkelCanvasInterface zirkelCanvasInterface) {
        this.ZCI = zirkelCanvasInterface;
    }

    public String loadImage() {
        return this.ZCI.loadImage();
    }

    public Image doLoadImage(String string) {
        return this.ZCI.doLoadImage(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block3: {
            block2: {
                if (!this.Interactive) {
                    return;
                }
                if (actionEvent.getSource() != this.Replay) break block2;
                if (this.ZCI == null) break block3;
                this.ZCI.replayChosen();
                break block3;
            }
            Enumeration enumeration = this.Macros.elements();
            while (enumeration.hasMoreElements()) {
                MacroItem macroItem = (MacroItem)enumeration.nextElement();
                if (macroItem.I != actionEvent.getSource()) continue;
                if (this.ZCI == null) break;
                this.ZCI.runMacro(macroItem.M);
                break;
            }
        }
    }

    public double col(double d2) {
        return (d2 - this.Xmin) / this.DX * (double)this.IW;
    }

    public double row(double d2) {
        return (double)this.IH - (d2 - this.Ymin) / this.DY * (double)this.IH;
    }

    public int width() {
        return this.IW;
    }

    public int height() {
        return this.IH;
    }

    public double x(int n) {
        return this.Xmin + this.DX * (double)n / (double)this.IW;
    }

    public double y(int n) {
        return this.Ymin + this.DY * (double)(this.IH - n) / (double)this.IH;
    }

    public double dx(int n) {
        return this.DX * (double)n / (double)this.IW;
    }

    public double dy(int n) {
        return this.DY * (double)n / (double)this.IH;
    }

    public double dx(double d2) {
        return this.DX * d2 / (double)this.IW;
    }

    public double dy(double d2) {
        return this.DY * d2 / (double)this.IH;
    }

    public double maxX() {
        return this.Xmin + this.DX;
    }

    public double minX() {
        return this.Xmin;
    }

    public double maxY() {
        return this.Ymin + this.DY;
    }

    public double minY() {
        return this.Ymin;
    }

    public boolean isInside(double d2, double d3) {
        return d2 >= this.Xmin && d2 < this.Xmin + this.DX && d3 >= this.Ymin && d3 < this.Ymin + this.DY;
    }

    public double dCenter(double d2, double d3) {
        double d4 = d2 - (this.Xmin + this.DX / 2.0);
        double d5 = d3 - (this.Ymin + this.DY / 2.0);
        return Math.sqrt(d4 * d4 + d5 * d5) / Math.max(this.DX / 2.0, this.DY / 2.0);
    }

    public void recompute() {
        if (this.IH < this.IW) {
            this.Xmin = this.C.getX() - this.C.getW();
            this.DX = this.C.getW() * 2.0;
            this.DY = this.DX / (double)this.IW * (double)this.IH;
            this.Ymin = this.C.getY() - this.DY / 2.0;
        } else {
            this.Ymin = this.C.getY() - this.C.getW();
            this.DY = this.C.getW() * 2.0;
            this.DX = this.DY / (double)this.IH * (double)this.IW;
            this.Xmin = this.C.getX() - this.DY / 2.0;
        }
        this.C.setH(this.DY);
        if (this.DX > 0.0) {
            this.C.setPixel((double)this.getSize().width / this.DX);
        }
    }

    public void setDoneListener(DoneListener doneListener) {
        this.DL = doneListener;
    }

    public void addObject(ConstructionObject constructionObject) {
        this.C.add(constructionObject);
        if (this.Preview) {
            constructionObject.setIndicated(true);
            constructionObject.setSelectable(false);
        }
        this.C.updateCircleDep();
    }

    public void added(Construction construction, ConstructionObject constructionObject) {
        if (this.displayJob() && this.TargetO.length > 0) {
            int n;
            boolean bl = true;
            for (n = 0; n < this.TargetO.length; ++n) {
                if (this.TargetS[n] != null && !this.TargetS[n].isInConstruction()) {
                    this.TargetS[n] = null;
                }
                if (this.TargetS[n] != null) continue;
                bl = false;
                if (!this.TargetO[n].equals(constructionObject)) continue;
                this.TargetS[n] = constructionObject;
            }
            n = 1;
            for (int i = 0; i < this.TargetO.length; ++i) {
                if (this.TargetS[i] != null) continue;
                n = 0;
                break;
            }
            if (n != 0 && this.DL != null && !bl) {
                this.repaint();
                this.DL.notifyDone();
                this.freeJob();
            }
        }
        this.repaint();
    }

    public boolean check(Construction construction) {
        int n;
        int n2 = this.TargetO.length;
        for (n = 0; n < n2; ++n) {
            this.TargetS[n] = null;
        }
        n = 0;
        Enumeration enumeration = construction.elements();
        block1: while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (constructionObject.isKeep()) continue;
            for (int i = 0; i < n2; ++i) {
                if (this.TargetS[i] != null || !constructionObject.equals(this.TargetO[i])) continue;
                this.TargetS[i] = constructionObject;
                ++n;
                continue block1;
            }
        }
        return n == n2;
    }

    public void check() {
        if (this.displayJob() && this.TargetO.length > 0) {
            int n;
            boolean bl = true;
            for (n = 0; n < this.TargetO.length; ++n) {
                if (this.TargetS[n] != null && !this.TargetS[n].isInConstruction()) {
                    this.TargetS[n] = null;
                }
                if (this.TargetS[n] != null) continue;
                bl = false;
            }
            n = this.check(this.C) ? 1 : 0;
            if (n != 0 && this.DL != null && !bl) {
                this.repaint();
                this.DL.notifyDone();
                this.freeJob();
            }
        }
    }

    public synchronized void mousePressed(MouseEvent mouseEvent) {
        if (!this.Interactive) {
            return;
        }
        this.SmartBoardPreview = false;
        this.clearIndicated();
        this.clearPreview();
        this.repaint();
        this.requestFocus();
        this.Dragging = false;
        this.RightClicked = false;
        this.Moved = 0;
        if (mouseEvent.isMetaDown() && this.AllowRightMouse) {
            ConstructionObject constructionObject;
            if (!this.ReadOnly) {
                constructionObject = this.selectLabel(mouseEvent.getX(), mouseEvent.getY());
                if (constructionObject != null) {
                    this.Dragging = true;
                    this.setTool(new LabelMover(this.OC, this, mouseEvent.getX(), mouseEvent.getY(), constructionObject, mouseEvent.isShiftDown()));
                    return;
                }
                if (mouseEvent.isShiftDown() && mouseEvent.isControlDown()) {
                    constructionObject = this.selectObject(mouseEvent.getX(), mouseEvent.getY());
                    if (constructionObject == null) {
                        return;
                    }
                    constructionObject.toggleHidden();
                    this.repaint();
                    return;
                }
                if (mouseEvent.isControlDown()) {
                    constructionObject = this.selectObject(mouseEvent.getX(), mouseEvent.getY());
                    if (constructionObject == null) {
                        return;
                    }
                    new EditConditionals(this.getFrame(), constructionObject);
                    this.validate();
                    this.repaint();
                    return;
                }
            }
            constructionObject = this.selectImmediateMoveableObject(mouseEvent.getX(), mouseEvent.getY());
            this.RightClicked = true;
            if (constructionObject != null) {
                this.Dragging = true;
                this.setTool(new MetaMover(this.OC, this, constructionObject, mouseEvent));
                return;
            }
            if (!Global.getParameter("options.nomousezoom", false)) {
                if (this.selectObjects(mouseEvent.getX(), mouseEvent.getY()).size() == 0) {
                    this.setTool(new ZoomerTool(this.OC, mouseEvent, this));
                }
                return;
            }
        } else {
            if (!this.SmartBoardPreview && Global.getParameter("smartboard", false) && this.OC.useSmartBoard()) {
                this.OC.mouseMoved(mouseEvent, this, Global.getParameter("options.indicate.simple", false));
                this.SmartBoardPreview = true;
                return;
            }
            this.Control = mouseEvent.isControlDown();
            this.OC.mousePressed(mouseEvent, this);
            this.Control = false;
        }
    }

    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        if (!this.Interactive) {
            return;
        }
        if (this.DT != null) {
            this.DT.waitReady();
        }
        if (this.RightClicked) {
            MyVector myVector;
            this.RightClicked = false;
            this.OC.mouseReleased(mouseEvent, this);
            if (this.Moved <= 2 && this.AllowRightMouse && !this.ReadOnly && (myVector = this.selectObjects(mouseEvent.getX(), mouseEvent.getY())).size() > 0) {
                ConstructionObject constructionObject = this.select(myVector, mouseEvent.getX(), mouseEvent.getY());
                if (constructionObject != null) {
                    new EditTool().mousePressed(mouseEvent, constructionObject, this);
                    this.check();
                    return;
                }
                this.repaintCD();
                return;
            }
            if (this.Moved <= 2 && this.PM != null && !Global.getParameter("restricted", false)) {
                int n = 2;
                if (this.ReadOnly || !Global.getParameter("options.doubleclick", false)) {
                    n = 1;
                }
                if (mouseEvent.getClickCount() >= n && (this.ReadOnly || this.Macros.size() != 0)) {
                    this.PM.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
            this.repaintCD();
            return;
        }
        if (this.SmartBoardPreview && Global.getParameter("smartboard", false)) {
            this.Control = mouseEvent.isControlDown();
            this.clearIndicated();
            this.clearPreview();
            this.repaint();
            this.Dragging = false;
            this.OC.mousePressed(mouseEvent, this);
            this.SmartBoardPreview = false;
            this.mouseReleased(mouseEvent);
            return;
        }
        if (!this.Dragging) {
            this.OC.mouseReleased(mouseEvent, this);
            this.Dragging = false;
            this.repaintCD();
            return;
        }
        if (this.Moved <= 1) {
            if (this.OC instanceof LabelMover) {
                ((LabelMover)this.OC).resetPoint();
                this.OC.mouseReleased(mouseEvent, this);
            } else if (this.OC instanceof MetaMover) {
                this.OC.mouseReleased(mouseEvent, this);
                if (!this.ReadOnly) {
                    new EditTool().mousePressed(mouseEvent, this);
                }
            }
        } else {
            this.OC.mouseReleased(mouseEvent, this);
        }
        this.repaintCD();
        this.check();
        this.Dragging = false;
    }

    public synchronized void mouseClicked(MouseEvent mouseEvent) {
    }

    public synchronized void mouseExited(MouseEvent mouseEvent) {
        if (!this.Interactive) {
            return;
        }
        this.clearIndicated();
        this.clearPreview();
        this.repaint();
        this.SmartBoardPreview = false;
        this.RightClicked = false;
        this.repaintCD();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public synchronized void mouseMoved(MouseEvent mouseEvent) {
        if (!this.Interactive || !Global.getParameter("options.indicate", true)) {
            return;
        }
        if (Global.getParameter("smartboard", false)) {
            return;
        }
        Count.setAllAlternate(true);
        this.OC.mouseMoved(mouseEvent, this, Global.getParameter("options.indicate.simple", false));
        Count.setAllAlternate(false);
        this.repaintCD();
    }

    public synchronized void mouseDragged(MouseEvent mouseEvent) {
        if (!this.Interactive) {
            return;
        }
        if (this.DT == null) {
            this.DT = new DragThread(this);
        }
        if (this.SmartBoardPreview && Global.getParameter("smartboard", false)) {
            this.OC.mouseMoved(mouseEvent, this, Global.getParameter("options.indicate.simple", false));
        } else {
            this.DT.mouseDragged(mouseEvent);
            ++this.Moved;
        }
        this.repaintCD();
    }

    public synchronized void doMouseDragged(MouseEvent mouseEvent) {
        this.OC.mouseDragged(mouseEvent, this);
    }

    public void newImage() {
        this.I = null;
        this.repaint();
    }

    public void setFrozen(boolean bl) {
        this.Frozen = bl;
    }

    public synchronized void paint(Graphics graphics) {
        int n;
        if (this.Frozen) {
            return;
        }
        int n2 = this.getSize().width;
        int n3 = this.getSize().height;
        if (this.I == null || this.IW != n2 || this.IH != n3) {
            if (n2 == 0 || n3 == 0) {
                return;
            }
            this.IW = n2;
            this.IH = n3;
            this.I = this.createImage(this.IW, this.IH);
            if (!Global.getParameter("printscalepreview", false) || !Global.getParameter("printscale.sizes", false)) {
                if (!Global.getParameter("simplegraphics", false)) {
                    this.IG = new MyGraphics13(this.I.getGraphics(), this);
                    this.IG.setSize(this.IW, this.IH);
                } else {
                    this.IG = new MyGraphics11(this.I.getGraphics());
                    this.IG.setSize(this.IW, this.IH);
                }
                this.PointSize = (double)this.IH / 240.0;
                this.FontSize = this.PointSize * 4.0;
                this.MinPointSize = Global.getParameter("minpointsize", 3);
                if (this.PointSize < this.MinPointSize) {
                    this.PointSize = this.MinPointSize;
                }
                this.MinFontSize = Global.getParameter("minfontsize", 12);
                if (this.FontSize < this.MinFontSize) {
                    this.FontSize = this.MinFontSize;
                }
                this.IG.setDefaultFont((int)this.FontSize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
            } else {
                double d2 = (double)this.IW / Global.getParameter("printscale.width", 5.0);
                if (!Global.getParameter("simplegraphics", false)) {
                    this.IG = new MyGraphics13(this.I.getGraphics(), Global.getParameter("printscale.linewidth", 0.02) * d2, this, null);
                    this.IG.setSize(this.IW, this.IH);
                } else {
                    this.IG = new MyGraphics11(this.I.getGraphics());
                    this.IG.setSize(this.IW, this.IH);
                }
                this.PointSize = Global.getParameter("printscale.pointsize", 0.07) * d2;
                this.FontSize = Global.getParameter("printscale.textsize", 0.3) * d2;
                this.IG.setDefaultFont((int)this.FontSize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
            }
            this.recompute();
            this.C.dovalidate();
        }
        this.IG.clearRect(0, 0, this.IW, this.IH, this.getBackground());
        if (this.Background != null) {
            int n4 = this.Background.getWidth(this);
            n = this.Background.getHeight(this);
            if (n4 == this.IW && n == this.IH) {
                this.IG.drawImage(this.Background, 0, 0, this);
            } else if (Global.getParameter("background.tile", true) && n4 < this.IW && n < this.IH) {
                for (int i = this.IW % n4 / 2 - n4; i < this.IW; i += n4) {
                    for (int j = this.IH % n / 2 - n; j < this.IH; j += n) {
                        this.IG.drawImage(this.Background, i, j, this);
                    }
                }
            } else if (Global.getParameter("background.center", true)) {
                this.IG.drawImage(this.Background, (this.IW - n4) / 2, (this.IH - n) / 2, this);
            } else {
                this.IG.drawImage(this.Background, 0, 0, this.IW, this.IH, this);
            }
        }
        if (this.MW == null) {
            this.C.computeTracks(this);
            this.dopaint(this.IG);
        }
        if (Global.getParameter("printscale.middle", false) && Global.getParameter("printscalepreview", false)) {
            int n5 = Global.getParameter("printscale.w", this.IW);
            n = Global.getParameter("printscale.h", this.IH);
            this.IG.drawRect(this.IW / 2 - n5 / 2 - 3, this.IH / 2 - n / 2 - 3, n5 + 7, n + 7);
        }
        graphics.drawImage(this.I, 0, 0, this);
    }

    public synchronized void resetGraphics() {
        this.I = null;
        this.repaint();
    }

    public void updateBreakHide() {
        ConstructionObject constructionObject;
        this.Breaks.removeAllElements();
        Enumeration enumeration = this.C.elements();
        while (enumeration.hasMoreElements() && (constructionObject = (ConstructionObject)enumeration.nextElement()) != this.LastPaint && constructionObject != this.C.last()) {
            if (!constructionObject.isBreak()) continue;
            this.Breaks.addElement(constructionObject);
        }
        enumeration = this.C.elements();
        constructionObject = null;
        Enumeration enumeration2 = this.Breaks.elements();
        if (enumeration2.hasMoreElements()) {
            constructionObject = (ConstructionObject)enumeration2.nextElement();
        }
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject2 = (ConstructionObject)enumeration.nextElement();
            if (constructionObject != null && constructionObject.isHideBreak()) {
                constructionObject2.setBreakHide(true);
            } else {
                constructionObject2.setBreakHide(false);
            }
            if (constructionObject2 == constructionObject) {
                constructionObject = enumeration2.hasMoreElements() ? (ConstructionObject)enumeration2.nextElement() : null;
            }
            if (constructionObject2 != this.LastPaint) continue;
            break;
        }
    }

    void dopaint(MyGraphics myGraphics) {
        Object object;
        if (this.ShowGrid) {
            if (this.AxesOnly) {
                this.paintAxes(myGraphics);
            } else {
                this.paintGrid(myGraphics);
            }
        }
        long l = System.currentTimeMillis();
        this.updateBreakHide();
        Enumeration enumeration = this.C.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            object = (ConstructionObject[])enumeration.nextElement();
            ((ConstructionObject)object).HasZ = false;
            ((ConstructionObject)object).IsDrawn = false;
            try {
                if (!((ConstructionObject)object).selected()) {
                    ((ConstructionObject)object).Value = -((ConstructionObject)object).getZ();
                    ((ConstructionObject)object).HasZ = true;
                    ++n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object != this.LastPaint) continue;
            break;
        }
        enumeration = this.C.elements();
        while (enumeration.hasMoreElements()) {
            object = (ConstructionObject)enumeration.nextElement();
            if (((ConstructionObject)object).isBack() && !((ConstructionObject)object).HasZ) {
                ((ConstructionObject)object).paint(myGraphics, this);
                ((ConstructionObject)object).IsDrawn = true;
            }
            if (object != this.LastPaint) continue;
            break;
        }
        if (n > 0) {
            object = new ConstructionObject[n];
            enumeration = this.C.elements();
            n = 0;
            while (enumeration.hasMoreElements()) {
                ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
                if (!constructionObject.HasZ) continue;
                object[n++] = constructionObject;
            }
            Sorter.sort((SortObject[])object);
            for (int i = 0; i < n; ++i) {
                ((ConstructionObject)object[i]).paint(myGraphics, this);
                ((ConstructionObject)object[i]).IsDrawn = true;
            }
        }
        enumeration = this.C.elements();
        while (enumeration.hasMoreElements()) {
            object = (ConstructionObject)enumeration.nextElement();
            if (!((ConstructionObject)object).selected() && !((ConstructionObject)object).IsDrawn) {
                ((ConstructionObject)object).paint(myGraphics, this);
                ((ConstructionObject)object).IsDrawn = true;
            }
            if (object != this.LastPaint) continue;
            break;
        }
        enumeration = this.C.elements();
        while (enumeration.hasMoreElements()) {
            object = (ConstructionObject)enumeration.nextElement();
            if (!((ConstructionObject)object).IsDrawn) {
                ((ConstructionObject)object).paint(myGraphics, this);
                ((ConstructionObject)object).IsDrawn = true;
            }
            if (object != this.LastPaint) continue;
            break;
        }
        if (this.LastPaint == null) {
            this.paintTrack(myGraphics);
        }
        if (this.Interactive && this.IndicatePoint != null) {
            this.IndicatePoint.paint(myGraphics, this);
        }
        if ((l = System.currentTimeMillis() - l) > 250L && PolygonDrawer.step < 50) {
            PolygonDrawer.step *= 2;
        }
        if (l < 100L && PolygonDrawer.step > 4) {
            PolygonDrawer.step /= 2;
        }
        this.paintDrawings(myGraphics);
    }

    void dopaintFig(MyGraphicsFig myGraphicsFig) {
        if (this.ShowGrid) {
            this.paintGrid(myGraphicsFig);
        }
        myGraphicsFig.pushLayer(true);
        int n = 0;
        while (true) {
            ConstructionObject constructionObject;
            myGraphicsFig.pushLayer();
            int n2 = 0;
            Enumeration enumeration = this.C.elements();
            while (enumeration.hasMoreElements() && (constructionObject = (ConstructionObject)enumeration.nextElement()) != this.LastPaint) {
                if (n2 == n && constructionObject.isBack()) {
                    constructionObject.paint(myGraphicsFig, this);
                }
                if (!constructionObject.isBreak() || ++n2 <= n) continue;
                break;
            }
            if (n2 < n) break;
            n2 = 0;
            enumeration = this.C.elements();
            while (enumeration.hasMoreElements() && (constructionObject = (ConstructionObject)enumeration.nextElement()) != this.LastPaint) {
                if (n2 == n && !constructionObject.isBack() && !constructionObject.selected()) {
                    constructionObject.paint(myGraphicsFig, this);
                }
                if (!constructionObject.isBreak() || ++n2 <= n) continue;
                break;
            }
            n2 = 0;
            enumeration = this.C.elements();
            while (enumeration.hasMoreElements() && (constructionObject = (ConstructionObject)enumeration.nextElement()) != this.LastPaint) {
                if (n2 == n && !constructionObject.isBack() && constructionObject.selected()) {
                    constructionObject.paint(myGraphicsFig, this);
                }
                if (!constructionObject.isBreak() || ++n2 <= n) continue;
                break;
            }
            ++n;
        }
        myGraphicsFig.pushLayer(false);
        if (this.LastPaint == null) {
            this.paintTrack(myGraphicsFig);
        }
    }

    public void setGrid() {
        this.ShowGrid = Global.getParameter("showgrid", false);
        this.AxesOnly = Global.getParameter("axesonly", false);
        this.GridThickness = Global.getParameter("grid.thickness", 2);
        this.GridColor = Global.getParameter("grid.colorindex", 0);
        this.GridBold = Global.getParameter("grid.bold", false);
        this.GridLarge = Global.getParameter("grid.large", false);
        this.GridLabels = Global.getParameter("grid.labels", true);
    }

    void paintGrid(MyGraphics myGraphics) {
        int n;
        int n2;
        double d2;
        double d3;
        if (this.GridThickness == 0) {
            myGraphics.setColor(ZirkelFrame.Colors[Global.getParameter("grid.colorindex", 0)]);
        } else {
            myGraphics.setColor(ZirkelFrame.LightColors[this.GridColor]);
        }
        myGraphics.setFont(this.GridLarge, this.GridBold);
        double d4 = this.getGridSize();
        int n3 = this.IH;
        int n4 = 0;
        for (d3 = Math.floor((this.C.getX() - this.C.getW()) / d4 - 1.0) * d4; d3 < this.C.getX() + this.C.getW() && n4 < 64; d3 += d4) {
            int n5 = (int)this.col(d3);
            this.xg[n4++] = n5;
        }
        int n6 = 0;
        for (d2 = Math.floor((this.C.getY() - this.C.getW()) / d4 - 1.0) * d4; d2 < this.C.getY() + this.C.getW() && n6 < 64; d2 += d4) {
            n2 = (int)this.row(d2);
            this.yg[n6++] = n2;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i = 0; i < n6; ++i) {
                myGraphics.drawLine(this.xg[n2], this.yg[i] - n3, this.xg[n2], this.yg[i] + n3);
                myGraphics.drawLine(this.xg[n2] - n3, this.yg[i], this.xg[n2] + n3, this.yg[i]);
            }
        }
        if (this.GridThickness != 3) {
            if (0.0 < this.C.getX() + this.C.getW() && 0.0 > this.C.getX() - this.C.getW()) {
                n2 = (int)this.col(0.0);
                if (this.GridThickness != 1) {
                    myGraphics.drawLine(n2, 0.0, n2, this.IH);
                } else {
                    myGraphics.drawThickLine(n2, 0.0, n2, this.IH);
                }
            }
            if (0.0 < this.C.getY() + this.C.getW() && 0.0 > this.C.getY() - this.C.getW()) {
                n2 = (int)this.row(0.0);
                if (this.GridThickness != 1) {
                    myGraphics.drawLine(0.0, n2, this.IW, n2);
                } else {
                    myGraphics.drawThickLine(0.0, n2, this.IW, n2);
                }
            }
        }
        n3 *= 2;
        double d5 = Math.pow(10.0, Math.floor(Math.log(this.C.getW() * 2.0) / Math.log(10.0))) / 10.0;
        while (this.C.getW() * 2.0 / d5 >= 10.0) {
            d5 *= 10.0;
        }
        if (this.C.getW() * 2.0 / d5 < 5.0) {
            d5 /= 2.0;
        }
        FontMetrics fontMetrics = myGraphics.getFontMetrics();
        int n7 = fontMetrics.getHeight();
        d3 = Math.floor((this.C.getX() - this.C.getW()) / d5 - 1.0) * d5;
        int n8 = (int)this.row(0.0);
        if (n8 < 0 || n8 > this.IH - n7) {
            n8 = this.IH - n7;
        }
        while (d3 < this.C.getX() + this.C.getW()) {
            n = (int)this.col(d3);
            String string = this.format(d3);
            if (string.length() > 0) {
                if (this.GridLabels) {
                    myGraphics.drawString(string, n + 3, n8 + n7);
                }
                myGraphics.drawLine(n, n8 - n3, n, n8 + n3);
            }
            d3 += d5;
        }
        n = (int)this.col(0.0);
        if (n < 0 || n > this.IW - 20) {
            n = 0;
        }
        for (d2 = Math.floor((this.C.getY() - this.C.getW()) / d5 - 1.0) * d5; d2 < this.C.getY() + this.C.getW(); d2 += d5) {
            int n9 = (int)this.row(d2);
            String string = this.format(d2);
            if (string.length() <= 0) continue;
            if (this.GridLabels) {
                myGraphics.drawString(string, n + 3, n9 + n7);
            }
            myGraphics.drawLine(n - n3, n9, n + n3, n9);
        }
        if (!Zirkel.IsApplet) {
            myGraphics.drawThickLine((int)this.col(0.0), 0.0, (int)this.col(0.0), this.IH);
            myGraphics.drawThickLine(0.0, (int)this.row(0.0), this.IW, (int)this.row(0.0));
            myGraphics.setColor(Color.red);
            FontMetrics fontMetrics2 = myGraphics.getFontMetrics();
            int n10 = fontMetrics2.getHeight();
            String string = ZirkelApplet.yaxis_text + " ";
            String string2 = ZirkelApplet.xaxis_text;
            myGraphics.drawString(string2, this.col(0.0) + (double)(3 * n10), this.row(0.0) + (double)n10);
            int n11 = string.length();
            if (ZirkelApplet.yaxis_text_vertical) {
                String string3 = "";
                int n12 = 0;
                int n13 = 1;
                int n14 = 0;
                for (int i = 0; i < n11; ++i) {
                    string3 = string.substring(n12, n13);
                    if (string3.indexOf(" ") == -1) {
                        ++n13;
                        continue;
                    }
                    myGraphics.drawString(string3, this.col(0.0) - (double)(2 * n10), this.row(0.0) - (double)(8 * n10) + (double)(n14 * n10));
                    n12 = n13++;
                    ++n14;
                }
            } else {
                myGraphics.drawString(string, this.col(0.0) - (double)(n11 * n10 / 2), this.row(0.0) - (double)(10 * n10));
            }
        }
    }

    void paintAxes(MyGraphics myGraphics) {
        int n;
        int n2;
        double d2;
        double d3;
        if (this.GridThickness == 0) {
            myGraphics.setColor(ZirkelFrame.Colors[this.GridColor]);
        } else {
            myGraphics.setColor(ZirkelFrame.LightColors[this.GridColor]);
        }
        myGraphics.setFont(this.GridLarge, this.GridBold);
        double d4 = this.getGridSize();
        int n3 = (int)this.row(0.0);
        int n4 = this.IH;
        for (d3 = Math.floor((this.C.getX() - this.C.getW()) / d4 - 1.0) * d4; d3 < this.C.getX() + this.C.getW(); d3 += d4) {
            int n5 = (int)this.col(d3);
            myGraphics.drawLine(n5, n3 - n4, n5, n3 + n4);
        }
        int n6 = (int)this.col(0.0);
        for (d2 = Math.floor((this.C.getY() - this.C.getW()) / d4 - 1.0) * d4; d2 < this.C.getY() + this.C.getW(); d2 += d4) {
            n2 = (int)this.row(d2);
            myGraphics.drawLine(n6 - n4, n2, n6 + n4, n2);
        }
        if (this.GridThickness != 3) {
            if (0.0 < this.C.getX() + this.C.getW() && 0.0 > this.C.getX() - this.C.getW()) {
                n2 = (int)this.col(0.0);
                if (this.GridThickness != 1) {
                    myGraphics.drawLine(n2, 0.0, n2, this.IH);
                } else {
                    myGraphics.drawThickLine(n2, 0.0, n2, this.IH);
                }
            }
            if (0.0 < this.C.getY() + this.C.getW() && 0.0 > this.C.getY() - this.C.getW()) {
                n2 = (int)this.row(0.0);
                if (this.GridThickness != 1) {
                    myGraphics.drawLine(0.0, n2, this.IW, n2);
                } else {
                    myGraphics.drawThickLine(0.0, n2, this.IW, n2);
                }
            }
        }
        double d5 = Math.pow(10.0, Math.floor(Math.log(this.C.getW() * 2.0) / Math.log(10.0))) / 10.0;
        while (this.C.getW() * 2.0 / d5 >= 10.0) {
            d5 *= 10.0;
        }
        if (this.C.getW() * 2.0 / d5 < 5.0) {
            d5 /= 2.0;
        }
        FontMetrics fontMetrics = myGraphics.getFontMetrics();
        int n7 = fontMetrics.getHeight();
        d3 = Math.floor((this.C.getX() - this.C.getW()) / d5 - 1.0) * d5;
        int n8 = (int)this.row(0.0);
        if (n8 < 0 || n8 > this.IH - n7) {
            n8 = this.IH - n7;
        }
        while (d3 < this.C.getX() + this.C.getW()) {
            n = (int)this.col(d3);
            String string = this.format(d3);
            if (this.GridLabels) {
                myGraphics.drawString(string, n + 4, n8 + n7);
            }
            if (string.length() > 0) {
                myGraphics.drawLine(n, n8 - n4, n, n8 + n4);
            }
            d3 += d5;
        }
        n = (int)this.col(0.0);
        if (n < 0 || n > this.IW - 20) {
            n = 0;
        }
        for (d2 = Math.floor((this.C.getY() - this.C.getW()) / d5 - 1.0) * d5; d2 < this.C.getY() + this.C.getW(); d2 += d5) {
            int n9 = (int)this.row(d2);
            String string = this.format(d2);
            if (this.GridLabels) {
                myGraphics.drawString(string, n + 3, n9 + n7);
            }
            if (string.length() <= 0) continue;
            myGraphics.drawLine(n - n4, n9, n + n4, n9);
        }
    }

    public double pointSize() {
        return this.PointSize;
    }

    public double selectionSize() {
        return this.SelectionPointFactor * this.PointSize;
    }

    public int scale(int n) {
        return (int)(this.Scale * (double)n);
    }

    public String format(double d2) {
        double d3;
        this.nc = 0;
        boolean bl = false;
        if (d2 < -1.0E-12) {
            bl = true;
            d2 = -d2;
        }
        if (this.rekformat(d3 = (d2 += 1.0E-12) - Math.floor(d2), 8)) {
            ZirkelCanvas.c[this.nc++] = 46;
        }
        while (d2 >= 1.0) {
            double d4 = Math.floor(d2 / 10.0);
            ZirkelCanvas.c[this.nc++] = (char)(48 + (int)(d2 - d4 * 10.0));
            d2 = d4;
        }
        if (this.nc > 0 && bl) {
            ZirkelCanvas.c[this.nc++] = 45;
        }
        for (int i = 0; i < this.nc / 2; ++i) {
            char c2 = c[this.nc - 1 - i];
            ZirkelCanvas.c[this.nc - 1 - i] = c[i];
            ZirkelCanvas.c[i] = c2;
        }
        return new String(c, 0, this.nc);
    }

    boolean rekformat(double d2, int n) {
        double d3 = Math.floor(d2 *= 10.0);
        if (n == 0) {
            int n2 = (int)d3;
            if (n2 > 0) {
                ZirkelCanvas.c[this.nc++] = (char)(48 + n2);
                return true;
            }
            return false;
        }
        int n3 = (int)d3;
        if (this.rekformat(d2 - d3, n - 1) || n3 > 0) {
            ZirkelCanvas.c[this.nc++] = (char)(48 + n3);
            return true;
        }
        return false;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paintUntil(ConstructionObject constructionObject) {
        if (this.LastPaint == constructionObject) {
            return;
        }
        this.LastPaint = constructionObject;
        this.repaint();
    }

    public void validate() {
        this.dovalidate();
        if (this.OC instanceof TrackPainter) {
            ((TrackPainter)((Object)this.OC)).validate(this);
        }
    }

    public synchronized void dovalidate() {
        this.C.dovalidate();
    }

    public void sort(MyVector myVector) {
        if (myVector.size() < 2) {
            return;
        }
        Sorter.QuickSort(myVector.getArray(), 0, myVector.size() - 1);
    }

    public void sortRow(MyVector myVector) {
        Object[] objectArray = new ConstructionObject[myVector.size()];
        myVector.copyInto(objectArray);
        myVector.removeAllElements();
        Enumeration enumeration = this.C.elements();
        block0: while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != constructionObject) continue;
                myVector.addElement(constructionObject);
                continue block0;
            }
        }
    }

    public ConstructionObject selectCircleLine(int n, int n2, boolean bl) {
        MyVector myVector = this.selectCircleLineObjects(n, n2, bl, false);
        return this.select(myVector);
    }

    public ConstructionObject selectCircleLine(int n, int n2) {
        return this.selectCircleLine(n, n2, true);
    }

    public ConstructionObject selectPointonObject(int n, int n2, boolean bl) {
        MyVector myVector = this.selectPointonObjects(n, n2, bl, false);
        return this.select(myVector);
    }

    public ConstructionObject selectPointonObject(int n, int n2) {
        return this.selectPointonObject(n, n2, true);
    }

    public MyVector selectCircleLineObjects(int n, int n2, boolean bl, boolean bl2) {
        Enumeration enumeration = this.C.elements();
        this.V.removeAllElements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.isSelectable() || !(constructionObject instanceof PrimitiveLineObject) && !(constructionObject instanceof PrimitiveCircleObject) || !constructionObject.nearto(n, n2, true, this) || !bl && constructionObject.selected()) continue;
            if (bl2) {
                Enumeration enumeration2 = this.V.elements();
                while (enumeration2.hasMoreElements()) {
                    ConstructionObject constructionObject2 = (ConstructionObject)enumeration2.nextElement();
                    if (!constructionObject.locallyLike(constructionObject2)) continue;
                    constructionObject = null;
                    break;
                }
            }
            if (constructionObject == null) continue;
            this.V.addElement(constructionObject);
        }
        return this.V;
    }

    public MyVector selectCircleLineObjects(int n, int n2, boolean bl) {
        return this.selectCircleLineObjects(n, n2, bl, false);
    }

    public MyVector selectCircleLineObjects(int n, int n2) {
        return this.selectCircleLineObjects(n, n2, true, false);
    }

    public MyVector selectPointonObjects(int n, int n2, boolean bl, boolean bl2) {
        Enumeration enumeration = this.C.elements();
        this.V.removeAllElements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.isSelectable() || !(constructionObject instanceof PointonObject) || !constructionObject.nearto(n, n2, true, this) || !bl && constructionObject.selected()) continue;
            if (bl2) {
                Enumeration enumeration2 = this.V.elements();
                while (enumeration2.hasMoreElements()) {
                    ConstructionObject constructionObject2 = (ConstructionObject)enumeration2.nextElement();
                    if (!constructionObject.locallyLike(constructionObject2)) continue;
                    constructionObject = null;
                    break;
                }
            }
            if (constructionObject == null) continue;
            this.V.addElement(constructionObject);
        }
        return this.V;
    }

    public MyVector selectPointonObjects(int n, int n2, boolean bl) {
        return this.selectPointonObjects(n, n2, bl, false);
    }

    public MyVector selectPointonObjects(int n, int n2) {
        return this.selectPointonObjects(n, n2, true, false);
    }

    public MyVector selectObjects(int n, int n2, boolean bl) {
        Enumeration enumeration = this.C.elements();
        this.V.removeAllElements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.isSelectable() || !constructionObject.nearto(n, n2, this) || !bl && constructionObject.selected()) continue;
            this.V.addElement(constructionObject);
        }
        return this.V;
    }

    public MyVector selectObjects(int n, int n2) {
        return this.selectObjects(n, n2, true);
    }

    public ConstructionObject selectObject(int n, int n2, boolean bl) {
        MyVector myVector = this.selectObjects(n, n2, bl);
        return this.select(myVector, n, n2);
    }

    public ConstructionObject selectObject(int n, int n2) {
        return this.selectObject(n, n2, true);
    }

    public MyVector selectConstructableObjects(int n, int n2, boolean bl) {
        Enumeration enumeration = this.C.elements();
        this.V.removeAllElements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.valid() || !constructionObject.isFlag() || !constructionObject.nearto(n, n2, this) || !bl && constructionObject.selected()) continue;
            this.V.addElement(constructionObject);
        }
        return this.V;
    }

    public MyVector selectConstructableObjects(int n, int n2) {
        return this.selectConstructableObjects(n, n2, true);
    }

    public ConstructionObject selectConstructableObject(int n, int n2) {
        MyVector myVector = this.selectConstructableObjects(n, n2, true);
        return this.select(myVector, n, n2);
    }

    public PrimitiveLineObject selectLine(int n, int n2, boolean bl) {
        this.selectLineObjects(n, n2, bl);
        return (PrimitiveLineObject)this.select(this.V);
    }

    public void selectLineObjects(int n, int n2, boolean bl) {
        Enumeration enumeration = this.C.elements();
        this.V.removeAllElements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.isSelectable() || !(constructionObject instanceof PrimitiveLineObject) || !constructionObject.nearto(n, n2, this) || !bl && constructionObject.selected()) continue;
            this.V.addElement(constructionObject);
        }
    }

    public PrimitiveLineObject selectLine(int n, int n2) {
        return this.selectLine(n, n2, true);
    }

    public void selectPointsOrLines(int n, int n2, boolean bl) {
        Enumeration enumeration = this.C.elements();
        this.V.removeAllElements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.isSelectable() || !(constructionObject instanceof PrimitiveLineObject) && !(constructionObject instanceof PointObject) || !constructionObject.nearto(n, n2, this) || !bl && constructionObject.selected()) continue;
            this.V.addElement(constructionObject);
        }
    }

    public TwoPointLineObject selectTwoPointLine(int n, int n2, boolean bl) {
        this.selectTwoPointLines(n, n2, bl);
        return (TwoPointLineObject)this.select(this.V);
    }

    public void selectTwoPointLines(int n, int n2, boolean bl) {
        Enumeration enumeration = this.C.elements();
        this.V.removeAllElements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.isSelectable() || !(constructionObject instanceof TwoPointLineObject) || !constructionObject.nearto(n, n2, this) || !bl && constructionObject.selected()) continue;
            this.V.addElement(constructionObject);
        }
    }

    public TwoPointLineObject selectTwoPointLine(int n, int n2) {
        return this.selectTwoPointLine(n, n2, true);
    }

    public SegmentObject selectSegment(int n, int n2, boolean bl) {
        this.selectSegments(n, n2, bl);
        return (SegmentObject)this.select(this.V);
    }

    public void selectSegments(int n, int n2, boolean bl) {
        Enumeration enumeration = this.C.elements();
        this.V.removeAllElements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.isSelectable() || !(constructionObject instanceof SegmentObject) || !constructionObject.nearto(n, n2, this) || !bl && constructionObject.selected()) continue;
            this.V.addElement(constructionObject);
        }
    }

    public SegmentObject selectSegment(int n, int n2) {
        return this.selectSegment(n, n2, true);
    }

    public RayObject selectRay(int n, int n2, boolean bl) {
        this.selectRays(n, n2, bl);
        return (RayObject)this.select(this.V);
    }

    public void selectRays(int n, int n2, boolean bl) {
        Enumeration enumeration = this.C.elements();
        this.V.removeAllElements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.isSelectable() || !(constructionObject instanceof RayObject) || !constructionObject.nearto(n, n2, this) || !bl && constructionObject.selected()) continue;
            this.V.addElement(constructionObject);
        }
    }

    public RayObject selectRay(int n, int n2) {
        return this.selectRay(n, n2, true);
    }

    public PrimitiveCircleObject selectCircle(int n, int n2, boolean bl) {
        this.selectCircles(n, n2, bl);
        return (PrimitiveCircleObject)this.select(this.V);
    }

    public void selectCircles(int n, int n2, boolean bl) {
        ConstructionObject constructionObject;
        Enumeration enumeration = this.C.elements();
        this.V.removeAllElements();
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.isSelectable() || !(constructionObject instanceof PrimitiveCircleObject) || !constructionObject.nearto(n, n2, this) || !bl && constructionObject.selected()) continue;
            this.V.addElement(constructionObject);
            if (constructionObject.isFilledForSelect()) continue;
            bl2 = true;
        }
        if (bl2) {
            enumeration = this.V.elements();
            while (enumeration.hasMoreElements()) {
                constructionObject = (ConstructionObject)enumeration.nextElement();
                if (!constructionObject.isFilledForSelect()) continue;
                this.V.removeElement(constructionObject);
            }
        }
    }

    public PrimitiveCircleObject selectCircle(int n, int n2) {
        return this.selectCircle(n, n2, true);
    }

    public PointObject selectPoint(int n, int n2, boolean bl) {
        this.selectPointObjects(n, n2, bl);
        return (PointObject)this.select(this.V);
    }

    public void selectPointObjects(int n, int n2, boolean bl) {
        Enumeration enumeration = this.C.elements();
        this.V.removeAllElements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.isSelectable() || !(constructionObject instanceof PointObject) || !constructionObject.nearto(n, n2, this) || !bl && constructionObject.selected()) continue;
            this.V.addElement(constructionObject);
        }
    }

    public PointObject selectPoint(int n, int n2) {
        return this.selectPoint(n, n2, true);
    }

    public PointObject selectPoint(int n, int n2, boolean bl, ConstructionObject constructionObject) {
        this.selectPointObjects(n, n2, bl, constructionObject);
        return (PointObject)this.select(this.V);
    }

    public void selectPointObjects(int n, int n2, boolean bl, ConstructionObject constructionObject) {
        ConstructionObject constructionObject2;
        Enumeration enumeration = this.C.elements();
        this.V.removeAllElements();
        while (enumeration.hasMoreElements() && (constructionObject2 = (ConstructionObject)enumeration.nextElement()) != constructionObject) {
            if (!constructionObject2.isSelectable() || !(constructionObject2 instanceof PointObject) || !constructionObject2.nearto(n, n2, this) || !bl && constructionObject2.selected()) continue;
            this.V.addElement(constructionObject2);
        }
    }

    public PointObject selectPoint(int n, int n2, ConstructionObject constructionObject) {
        return this.selectPoint(n, n2, true, constructionObject);
    }

    public boolean isNewPoint() {
        return this.NewPoint;
    }

    public PointObject selectCreatePoint(int n, int n2, boolean bl, boolean bl2) {
        ConstructionObject constructionObject;
        this.NewPoint = false;
        if (this.Preview) {
            PointObject pointObject = new PointObject(this.C, this.x(n), this.y(n2));
            this.addObject(pointObject);
            pointObject.setSuperHidden(true);
            this.PreviewObject = pointObject;
            return pointObject;
        }
        Enumeration enumeration = this.C.elements();
        this.V.removeAllElements();
        while (enumeration.hasMoreElements()) {
            constructionObject = (ConstructionObject)enumeration.nextElement();
            if (constructionObject.isSelectable() && constructionObject instanceof PointObject && constructionObject.nearto(n, n2, this) && (bl || !constructionObject.selected())) {
                this.V.addElement(constructionObject);
            }
            this.sort(this.V);
        }
        if (this.V.size() > 0) {
            if (bl2) {
                return (PointObject)this.V.elementAt(0);
            }
            constructionObject = this.select(this.V, this.Control || !Global.getParameter("options.indicate", true));
            if (constructionObject != null) {
                return (PointObject)constructionObject;
            }
            return null;
        }
        constructionObject = this.tryCreateIntersection(n, n2, true);
        if (constructionObject != null) {
            return (PointObject)constructionObject;
        }
        if (!this.IntersectionYes) {
            return null;
        }
        MyVector myVector = this.selectPointonObjects(n, n2, true, false);
        this.filter(myVector, n, n2, true);
        if (myVector.size() > 0) {
            constructionObject = this.select(myVector, !this.Control);
            if (constructionObject == null) {
                return null;
            }
            if (constructionObject != null) {
                Object object;
                boolean bl3 = true;
                if (Global.getParameter("options.pointon", false)) {
                    object = new AgainQuestion(this.F, Zirkel.name("question.pointon"), Zirkel.name("question.title"));
                    ((CloseDialog)object).center(this.F);
                    ((Dialog)object).setVisible(true);
                    bl3 = ((AgainQuestion)object).yes();
                    Global.setParameter("options.pointon", ((AgainQuestion)object).again());
                }
                if (bl3) {
                    object = new PointObject(this.C, this.x(n), this.y(n2), constructionObject);
                    if (this.ShowGrid && Global.getParameter("grid.leftsnap", true)) {
                        ((PointObject)object).snap(this);
                    }
                    ((PointObject)object).setUseAlpha(true);
                    this.addObject((ConstructionObject)object);
                    this.validate();
                    ((PointObject)object).setDefaults();
                    this.NewPoint = true;
                    return object;
                }
                return null;
            }
        }
        PointObject pointObject = new PointObject(this.C, this.x(n), this.y(n2));
        if (this.ShowGrid && Global.getParameter("grid.leftsnap", true)) {
            pointObject.snap(this);
        }
        this.addObject(pointObject);
        pointObject.setDefaults();
        this.NewPoint = true;
        return pointObject;
    }

    public ConstructionObject tryCreateIntersection(int n, int n2, boolean bl) {
        Object object;
        MyVector myVector = this.selectPointonObjects(n, n2, true, true);
        this.sort(myVector);
        this.IntersectionYes = true;
        if (myVector.size() < 2) {
            return null;
        }
        ConstructionObject constructionObject = (ConstructionObject)myVector.elementAt(0);
        ConstructionObject constructionObject2 = (ConstructionObject)myVector.elementAt(1);
        if (!(constructionObject instanceof PointonObject) || !(constructionObject2 instanceof PointonObject)) {
            return null;
        }
        if (!((PointonObject)((Object)constructionObject)).canInteresectWith(constructionObject2) || !((PointonObject)((Object)constructionObject2)).canInteresectWith(constructionObject)) {
            return null;
        }
        IntersectionObject[] intersectionObjectArray = IntersectionConstructor.construct(constructionObject, constructionObject2, this.C);
        if (intersectionObjectArray.length == 1 && !intersectionObjectArray[0].valid()) {
            return null;
        }
        if (intersectionObjectArray.length == 2 && !intersectionObjectArray[0].valid() && !intersectionObjectArray[1].valid()) {
            return null;
        }
        if (bl && Global.getParameter("options.intersection", false)) {
            object = new AgainQuestion(this.F, Zirkel.name("question.intersection"), Zirkel.name("question.title"));
            ((CloseDialog)object).center(this.F);
            ((Dialog)object).setVisible(true);
            this.IntersectionYes = ((AgainQuestion)object).yes();
            Global.setParameter("options.intersection", ((AgainQuestion)object).again());
        }
        if (this.IntersectionYes) {
            if (intersectionObjectArray.length == 1 || !intersectionObjectArray[1].valid()) {
                this.addObject(intersectionObjectArray[0]);
                intersectionObjectArray[0].autoAway();
                intersectionObjectArray[0].validate(this.x(n), this.y(n2));
                this.validate();
                intersectionObjectArray[0].setDefaults();
                intersectionObjectArray[0].setRestricted(this.getRestricted());
                return intersectionObjectArray[0];
            }
            if (!intersectionObjectArray[0].valid()) {
                this.addObject(intersectionObjectArray[1]);
                intersectionObjectArray[1].autoAway();
                this.validate();
                intersectionObjectArray[1].setDefaults();
                intersectionObjectArray[1].setRestricted(this.getRestricted());
                return intersectionObjectArray[1];
            }
            object = intersectionObjectArray[0];
            double d2 = intersectionObjectArray[0].distanceTo(n, n2, this);
            double d3 = intersectionObjectArray[1].distanceTo(n, n2, this);
            if (d3 < d2) {
                object = intersectionObjectArray[1];
            }
            this.addObject((ConstructionObject)object);
            ((IntersectionObject)object).autoAway();
            ((IntersectionObject)object).validate(this.x(n), this.y(n2));
            this.validate();
            ((PointObject)object).setDefaults();
            ((IntersectionObject)object).setRestricted(this.getRestricted());
            this.NewPoint = true;
            return object;
        }
        return null;
    }

    public PointObject selectCreatePoint(int n, int n2) {
        return this.selectCreatePoint(n, n2, true, false);
    }

    public PointObject selectCreatePoint(int n, int n2, boolean bl) {
        return this.selectCreatePoint(n, n2, bl, false);
    }

    public ConstructionObject selectMoveablePoint(int n, int n2) {
        ConstructionObject constructionObject;
        ConstructionObject constructionObject2 = this.findSelectedObject();
        if (constructionObject2 instanceof PointObject && ((MoveableObject)((Object)constructionObject2)).moveable() && constructionObject2.nearto(n, n2, this)) {
            return constructionObject2;
        }
        this.V.removeAllElements();
        Enumeration enumeration = this.C.elements();
        while (enumeration.hasMoreElements()) {
            constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.isSelectable() || !(constructionObject instanceof PointObject) || !((MoveableObject)((Object)constructionObject)).moveable() || !constructionObject.nearto(n, n2, this)) continue;
            this.V.addElement(constructionObject);
        }
        if (this.V.size() == 1) {
            return (ConstructionObject)this.V.elementAt(0);
        }
        constructionObject = this.select(this.V);
        if (constructionObject != null) {
            constructionObject.setSelected(true);
        }
        return null;
    }

    public ConstructionObject selectWithSelector(int n, int n2, Selector selector, ConstructionObject constructionObject, boolean bl) {
        ConstructionObject constructionObject2;
        this.V.removeAllElements();
        Enumeration enumeration = this.C.elements();
        while (enumeration.hasMoreElements() && (constructionObject2 = (ConstructionObject)enumeration.nextElement()) != constructionObject) {
            if (!constructionObject2.isSelectable() || !selector.isAdmissible(this, constructionObject2) || !constructionObject2.nearto(n, n2, this)) continue;
            this.V.addElement(constructionObject2);
        }
        if (this.V.size() == 1) {
            return (ConstructionObject)this.V.elementAt(0);
        }
        if (!bl) {
            if (this.V.size() > 0) {
                return (ConstructionObject)this.V.elementAt(0);
            }
            return null;
        }
        constructionObject2 = this.select(this.V, n, n2);
        return constructionObject2;
    }

    public ConstructionObject selectWithSelector(int n, int n2, Selector selector, ConstructionObject constructionObject) {
        return this.selectWithSelector(n, n2, selector, constructionObject, true);
    }

    public ConstructionObject selectWithSelector(int n, int n2, Selector selector, boolean bl) {
        return this.selectWithSelector(n, n2, selector, null, bl);
    }

    public ConstructionObject selectWithSelector(int n, int n2, Selector selector) {
        return this.selectWithSelector(n, n2, selector, null, true);
    }

    public ConstructionObject selectImmediateMoveablePoint(int n, int n2) {
        Enumeration enumeration = this.C.elements();
        this.V.removeAllElements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.isSelectable() || !(constructionObject instanceof PointObject) || !((MoveableObject)((Object)constructionObject)).moveable() || !constructionObject.nearto(n, n2, this)) continue;
            this.V.addElement(constructionObject);
        }
        if (this.V.size() == 0) {
            return null;
        }
        return (ConstructionObject)this.V.elementAt(0);
    }

    public ConstructionObject selectMoveableObject(int n, int n2) {
        ConstructionObject constructionObject = this.findSelectedObject();
        if (constructionObject instanceof MoveableObject && ((MoveableObject)((Object)constructionObject)).moveable() && constructionObject.nearto(n, n2, this)) {
            return constructionObject;
        }
        this.selectMoveableObjects(n, n2);
        if (this.V.size() == 1) {
            return (ConstructionObject)this.V.elementAt(0);
        }
        ConstructionObject constructionObject2 = this.select(this.V);
        if (constructionObject2 != null) {
            if (!Global.getParameter("options.choice", true)) {
                return constructionObject2;
            }
            constructionObject2.setSelected(true);
        }
        return null;
    }

    public void selectMoveableObjects(int n, int n2, boolean bl) {
        this.V.removeAllElements();
        ConstructionObject constructionObject = this.findSelectedObject();
        if (constructionObject instanceof MoveableObject && ((MoveableObject)((Object)constructionObject)).moveable() && constructionObject.nearto(n, n2, this)) {
            this.V.addElement(constructionObject);
            return;
        }
        if (bl && constructionObject instanceof FixedCircleObject && constructionObject.nearto(n, n2, this) && ((FixedCircleObject)constructionObject).fixedByNumber()) {
            this.V.addElement(constructionObject);
            return;
        }
        if (bl && constructionObject instanceof FixedAngleObject && constructionObject.nearto(n, n2, this) && ((FixedAngleObject)constructionObject).fixedByNumber()) {
            this.V.addElement(constructionObject);
            return;
        }
        Enumeration enumeration = this.C.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject2 = (ConstructionObject)enumeration.nextElement();
            if (!bl && constructionObject2.isSelectable() && constructionObject2 instanceof MoveableObject && ((MoveableObject)((Object)constructionObject2)).moveable() && constructionObject2.nearto(n, n2, this)) {
                this.V.addElement(constructionObject2);
                continue;
            }
            if (bl && constructionObject2 instanceof FixedCircleObject && constructionObject2.nearto(n, n2, this) && ((FixedCircleObject)constructionObject2).fixedByNumber()) {
                this.V.addElement(constructionObject2);
                continue;
            }
            if (!bl || !(constructionObject2 instanceof FixedAngleObject) || !constructionObject2.nearto(n, n2, this) || !((FixedAngleObject)constructionObject2).fixedByNumber()) continue;
            this.V.addElement(constructionObject2);
        }
        this.filter(this.V, n, n2);
    }

    public void selectMoveableObjects(int n, int n2) {
        this.selectMoveableObjects(n, n2, false);
    }

    public ConstructionObject selectImmediateMoveableObject(int n, int n2) {
        Enumeration enumeration = this.C.elements();
        this.V.removeAllElements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.isSelectable() || !(constructionObject instanceof MoveableObject) || !((MoveableObject)((Object)constructionObject)).moveable() || !constructionObject.nearto(n, n2, this)) continue;
            this.V.addElement(constructionObject);
        }
        this.filter(this.V, n, n2);
        if (this.V.size() == 0) {
            return null;
        }
        return (ConstructionObject)this.V.elementAt(0);
    }

    public void filter(MyVector myVector, int n, int n2, boolean bl) {
        ConstructionObject constructionObject;
        boolean bl2 = false;
        boolean bl3 = false;
        Enumeration enumeration = myVector.elements();
        while (enumeration.hasMoreElements()) {
            constructionObject = (ConstructionObject)enumeration.nextElement();
            if (constructionObject instanceof PointObject) {
                bl2 = true;
            }
            if (constructionObject.isFilledForSelect()) continue;
            bl3 = true;
        }
        if (bl2) {
            enumeration = myVector.elements();
            while (enumeration.hasMoreElements()) {
                constructionObject = (ConstructionObject)enumeration.nextElement();
                if (constructionObject.onlynearto(n, n2, this)) continue;
                myVector.removeElement(constructionObject);
            }
        } else if (bl3) {
            enumeration = myVector.elements();
            while (enumeration.hasMoreElements()) {
                constructionObject = (ConstructionObject)enumeration.nextElement();
                if (!constructionObject.isFilledForSelect()) continue;
                myVector.removeElement(constructionObject);
            }
        }
        this.sort(myVector);
        if (!bl) {
            myVector.truncate(1);
        }
    }

    public void filter(MyVector myVector, int n, int n2) {
        this.filter(myVector, n, n2, Global.getParameter("options.choice", true) || this.Control);
    }

    public ConstructionObject select(MyVector myVector, int n, int n2, boolean bl) {
        if (myVector.size() == 0) {
            return null;
        }
        if (myVector.size() == 1) {
            return (ConstructionObject)myVector.elementAt(0);
        }
        this.filter(myVector, n, n2);
        if (myVector.size() == 1) {
            return (ConstructionObject)myVector.elementAt(0);
        }
        if (!bl) {
            return (ConstructionObject)myVector.elementAt(0);
        }
        this.sortRow(this.V);
        this.RightClicked = false;
        SelectDialog selectDialog = new SelectDialog(this.F, myVector);
        if (selectDialog.isAborted()) {
            return null;
        }
        return selectDialog.getObject();
    }

    public ConstructionObject select(MyVector myVector, int n, int n2) {
        return this.select(myVector, n, n2, Global.getParameter("options.choice", true) || this.Control);
    }

    public ConstructionObject select(MyVector myVector, boolean bl) {
        if (myVector.size() == 0) {
            return null;
        }
        if (myVector.size() == 1) {
            return (ConstructionObject)myVector.elementAt(0);
        }
        if (!bl) {
            return (ConstructionObject)myVector.elementAt(0);
        }
        this.sortRow(this.V);
        this.RightClicked = false;
        SelectDialog selectDialog = new SelectDialog(this.F, myVector);
        if (selectDialog.isAborted()) {
            return null;
        }
        return selectDialog.getObject();
    }

    public ConstructionObject select(MyVector myVector) {
        return this.select(myVector, Global.getParameter("options.choice", true) || this.Control);
    }

    public ConstructionObject selectLabel(int n, int n2) {
        Enumeration enumeration = this.C.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.isSelectable() || !constructionObject.textcontains(n, n2, this)) continue;
            return constructionObject;
        }
        return null;
    }

    public ConstructionObject findSelectedObject() {
        Enumeration enumeration = this.C.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.selected()) continue;
            return constructionObject;
        }
        return null;
    }

    public void indicate(MyVector myVector, boolean bl) {
        if (myVector.size() == 1) {
            if (bl) {
                this.setCursor(new Cursor(1));
            } else if (myVector.elementAt(0) instanceof PointObject) {
                this.setCursor(new Cursor(12));
            }
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (this.Indicated.equalsIdentical(myVector)) {
            return;
        }
        Enumeration enumeration = this.Indicated.elements();
        while (enumeration.hasMoreElements()) {
            ((ConstructionObject)enumeration.nextElement()).setIndicated(false);
        }
        this.Indicated.removeAllElements();
        enumeration = myVector.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            this.Indicated.addElement(constructionObject);
            constructionObject.setIndicated(true, bl);
        }
        this.repaint();
    }

    public void indicate(MyVector myVector) {
        this.indicate(myVector, false);
    }

    public void clearIndicated() {
        this.IndicatePoint = null;
        if (this.Indicated.size() == 0) {
            return;
        }
        Enumeration enumeration = this.Indicated.elements();
        while (enumeration.hasMoreElements()) {
            ((ConstructionObject)enumeration.nextElement()).setIndicated(false);
        }
        this.Indicated.removeAllElements();
        this.setCursor(Cursor.getDefaultCursor());
        this.repaint();
    }

    public void movePreview(MouseEvent mouseEvent) {
        if (this.PreviewObject != null) {
            this.PreviewObject.move(this.x(mouseEvent.getX()), this.y(mouseEvent.getY()));
            this.validate();
            this.repaint();
        }
    }

    public void prepareForPreview(MouseEvent mouseEvent) {
        this.LastNonPreview = this.C.last();
        this.Preview = true;
    }

    public boolean isPreview() {
        return this.Preview;
    }

    public void clearPreview() {
        if (!this.Preview) {
            return;
        }
        this.C.clearAfter(this.LastNonPreview);
        this.LastNonPreview = null;
        this.PreviewObject = null;
        this.Preview = false;
        Count.fixAll(false);
    }

    public void setPreviewObject(MoveableObject moveableObject) {
        this.PreviewObject = moveableObject;
    }

    public ConstructionObject indicateTryCreateIntersection(int n, int n2, boolean bl) {
        IntersectionObject intersectionObject;
        MyVector myVector = this.selectPointonObjects(n, n2, true, true);
        this.sort(myVector);
        this.IntersectionYes = true;
        if (myVector.size() < 2) {
            return null;
        }
        IntersectionObject[] intersectionObjectArray = IntersectionConstructor.construct((ConstructionObject)myVector.elementAt(0), (ConstructionObject)myVector.elementAt(1), this.C);
        if (intersectionObjectArray.length == 1 && !intersectionObjectArray[0].valid()) {
            return null;
        }
        if (intersectionObjectArray.length == 2) {
            if (!intersectionObjectArray[1].valid()) {
                if (!intersectionObjectArray[0].valid()) {
                    return null;
                }
            } else {
                intersectionObject = intersectionObjectArray[0];
                intersectionObjectArray[0] = intersectionObjectArray[1];
                intersectionObjectArray[1] = intersectionObject;
            }
        }
        intersectionObject = intersectionObjectArray[0];
        if (intersectionObjectArray.length == 2 && intersectionObjectArray[1].valid()) {
            double d2 = intersectionObjectArray[0].distanceTo(n, n2, this);
            double d3 = intersectionObjectArray[1].distanceTo(n, n2, this);
            if (d3 < d2) {
                intersectionObject = intersectionObjectArray[1];
            }
        }
        intersectionObject.setDefaults();
        intersectionObject.setIndicated(true);
        intersectionObject.setType(2);
        intersectionObject.setColorType(1);
        this.IndicatePoint = intersectionObject;
        this.indicate(myVector);
        intersectionObject.validate(this.x(n), this.y(n2));
        return intersectionObject;
    }

    public void indicateCreatePoint(int n, int n2, boolean bl) {
        ConstructionObject constructionObject;
        Enumeration enumeration = this.C.elements();
        this.V.removeAllElements();
        while (enumeration.hasMoreElements()) {
            constructionObject = (ConstructionObject)enumeration.nextElement();
            if (constructionObject.isSelectable() && constructionObject instanceof PointObject && constructionObject.nearto(n, n2, this) && (bl || !constructionObject.selected())) {
                this.V.addElement(constructionObject);
            }
            this.sort(this.V);
        }
        if (this.V.size() > 0) {
            this.IndicatePoint = null;
            this.filter(this.V, n, n2, false);
            this.indicate(this.V);
            return;
        }
        constructionObject = (PointObject)this.indicateTryCreateIntersection(n, n2, true);
        if (constructionObject != null) {
            return;
        }
        MyVector myVector = this.selectPointonObjects(n, n2, true, false);
        this.filter(myVector, n, n2, true);
        if (myVector.size() >= 1) {
            if (!myVector.equalsIdentical(this.Indicated)) {
                constructionObject = new PointObject(this.C, this.x(n), this.y(n2), (ConstructionObject)myVector.elementAt(0));
                if (this.ShowGrid && !Global.getParameter("grid.leftsnap", false)) {
                    ((PointObject)constructionObject).snap(this);
                }
                ((PointObject)constructionObject).setUseAlpha(true);
                ((PointObject)constructionObject).validate();
                constructionObject.setIndicated(true);
                ((PointObject)constructionObject).setType(2);
                constructionObject.setColorType(1);
                this.IndicatePoint = constructionObject;
                this.indicate(myVector);
            } else if (this.IndicatePoint != null) {
                this.IndicatePoint.setType(2);
                this.IndicatePoint.setColorType(1);
                this.IndicatePoint.move(this.x(n), this.y(n2));
                this.IndicatePoint.project((ConstructionObject)myVector.elementAt(0));
                this.repaint();
            }
        } else {
            this.clearIndicated();
        }
    }

    public void indicateCircleLineObjects(int n, int n2) {
        MyVector myVector = this.selectCircleLineObjects(n, n2);
        this.filter(this.V, n, n2);
        this.indicate(myVector);
    }

    public void indicatePointonObjects(int n, int n2) {
        MyVector myVector = this.selectPointonObjects(n, n2);
        this.filter(this.V, n, n2);
        this.indicate(myVector);
    }

    public void indicateIntersectedObjects(int n, int n2) {
        MyVector myVector = this.selectPointonObjects(n, n2);
        if (!myVector.equalsIdentical(this.Indicated) && myVector.size() >= 2) {
            IntersectionObject[] intersectionObjectArray = IntersectionConstructor.construct((ConstructionObject)myVector.elementAt(0), (ConstructionObject)myVector.elementAt(1), this.C);
            IntersectionObject intersectionObject = intersectionObjectArray[0];
            if (intersectionObjectArray.length == 2) {
                double d2 = intersectionObjectArray[0].distanceTo(n, n2, this);
                double d3 = intersectionObjectArray[1].distanceTo(n, n2, this);
                if (d3 < d2) {
                    intersectionObject = intersectionObjectArray[1];
                }
                intersectionObject.autoAway();
            }
            intersectionObject.validate();
            intersectionObject.setDefaults();
            intersectionObject.setIndicated(true);
            intersectionObject.setColorType(1);
            intersectionObject.setType(2);
            this.IndicatePoint = intersectionObject;
        } else {
            this.IndicatePoint = null;
        }
        this.indicate(myVector);
    }

    public void indicateLineObjects(int n, int n2) {
        this.selectLineObjects(n, n2, true);
        this.filter(this.V, n, n2);
        this.indicate(this.V);
    }

    public void indicatePointObjects(int n, int n2) {
        this.selectPointObjects(n, n2, true);
        this.filter(this.V, n, n2);
        this.indicate(this.V);
    }

    public void indicatePointObjects(int n, int n2, ConstructionObject constructionObject) {
        this.selectPointObjects(n, n2, true, constructionObject);
        this.filter(this.V, n, n2);
        this.indicate(this.V);
    }

    public void indicatePointsOrLines(int n, int n2) {
        this.selectPointsOrLines(n, n2, true);
        this.filter(this.V, n, n2);
        this.indicate(this.V);
    }

    public void indicateSegments(int n, int n2) {
        this.selectSegments(n, n2, true);
        this.filter(this.V, n, n2);
        this.indicate(this.V);
    }

    public void indicateRays(int n, int n2) {
        this.selectRays(n, n2, true);
        this.filter(this.V, n, n2);
        this.indicate(this.V);
    }

    public void indicateTwoPointLines(int n, int n2) {
        this.selectTwoPointLines(n, n2, true);
        this.filter(this.V, n, n2);
        this.indicate(this.V);
    }

    public void indicateCircles(int n, int n2) {
        this.selectCircles(n, n2, true);
        this.filter(this.V, n, n2);
        this.indicate(this.V);
    }

    public void indicateMoveableObjects(int n, int n2, boolean bl) {
        this.selectMoveableObjects(n, n2, bl);
        this.filter(this.V, n, n2);
        this.indicate(this.V);
    }

    public void indicateMoveableObjects(int n, int n2) {
        this.indicateMoveableObjects(n, n2, false);
    }

    public void indicateWithSelector(int n, int n2, Selector selector) {
        this.selectWithSelector(n, n2, selector, false);
        this.filter(this.V, n, n2);
        this.indicate(this.V);
    }

    public void indicateWithSelector(int n, int n2, Selector selector, ConstructionObject constructionObject) {
        this.selectWithSelector(n, n2, selector, constructionObject, false);
        this.filter(this.V, n, n2);
        this.indicate(this.V);
    }

    public void indicateConstructableObjects(int n, int n2) {
        this.selectConstructableObjects(n, n2);
        this.filter(this.V, n, n2);
        this.indicate(this.V);
    }

    public void indicateObjects(int n, int n2, boolean bl) {
        this.selectObjects(n, n2);
        this.filter(this.V, n, n2);
        this.indicate(this.V, bl);
    }

    public void indicateObjects(int n, int n2) {
        this.indicateObjects(n, n2, false);
    }

    public void setTool(ObjectConstructor objectConstructor) {
        if (this.OC != null) {
            this.OC.invalidate(this);
        }
        this.OC = objectConstructor;
        this.OC.showStatus(this);
        this.clearIndicated();
        this.clearPreview();
    }

    public void setSuddenTool(ObjectConstructor objectConstructor) {
        this.OC = objectConstructor;
    }

    public void reset() {
        this.clearPreview();
        this.clearIndicated();
        this.OC.reset(this);
    }

    public void clearSelected() {
        Enumeration enumeration = this.C.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            constructionObject.setSelected(false);
        }
        this.repaint();
    }

    public synchronized void clear() {
        this.displayJob(false);
        if (this.OC != null) {
            this.OC.invalidate(this);
        }
        this.C.clear();
        this.recompute();
        this.setDefaultColor(0);
        this.setDefaultColorType(0);
        this.setDefaultType(2);
        this.setGrid();
        this.reloadCD();
    }

    public synchronized void back() {
        this.reset();
        ConstructionObject constructionObject = this.C.lastByNumber();
        if (constructionObject == null) {
            return;
        }
        if (constructionObject.isKeep()) {
            return;
        }
        this.delete(constructionObject);
        while ((constructionObject = this.C.lastByNumber()) != null && constructionObject.mustHide(this) && !constructionObject.isHideBreak() && !constructionObject.isKeep()) {
            this.delete(constructionObject);
        }
        this.validate();
    }

    public synchronized void undo() {
        this.reset();
        this.C.undo();
    }

    public void delete(ConstructionObject constructionObject) {
        if (this.C.last() == null) {
            return;
        }
        if (constructionObject.isKeep()) {
            return;
        }
        this.C.clearConstructables();
        constructionObject.setFlag(true);
        this.C.determineChildren();
        this.C.delete(false);
    }

    public void delete(Vector vector) {
        if (this.C.last() == null) {
            return;
        }
        this.C.clearConstructables();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (constructionObject.isKeep()) {
                return;
            }
            constructionObject.setFlag(true);
        }
        this.C.determineChildren();
        this.C.delete(false);
    }

    public boolean depends(ConstructionObject constructionObject, ConstructionObject constructionObject2) {
        this.C.clearConstructables();
        constructionObject2.setFlag(true);
        this.C.determineChildren();
        return constructionObject.isFlag();
    }

    public void addStatusListener(StatusListener statusListener) {
        this.SL = statusListener;
    }

    public void showStatus(String string) {
        if (this.SL != null) {
            this.SL.showStatus(string);
        }
    }

    public void showStatus() {
        if (this.OC != null) {
            this.OC.showStatus(this);
        }
    }

    public boolean showHidden() {
        return this.ShowHidden;
    }

    public void setDefaultColor(int n) {
        this.C.DefaultColor = n;
    }

    public int getDefaultColor() {
        return this.C.DefaultColor;
    }

    public void setDefaultType(int n) {
        this.C.DefaultType = n;
    }

    public int getDefaultType() {
        return this.C.DefaultType;
    }

    public void setPartial(boolean bl) {
        this.C.Partial = bl;
    }

    public boolean getPartial() {
        return this.C.Partial;
    }

    public void setRestricted(boolean bl) {
        this.C.Restricted = bl;
    }

    public boolean getRestricted() {
        return this.C.Restricted;
    }

    public void setPartialLines(boolean bl) {
        this.C.PartialLines = bl;
    }

    public boolean getPartialLines() {
        return this.C.PartialLines;
    }

    public void setVectors(boolean bl) {
        this.C.Vectors = bl;
    }

    public boolean getVectors() {
        return this.C.Vectors;
    }

    public void setLongNames(boolean bl) {
        this.C.LongNames = bl;
    }

    public boolean getLongNames() {
        return this.C.LongNames;
    }

    public void setLargeFont(boolean bl) {
        this.C.LargeFont = bl;
    }

    public boolean getLargeFont() {
        return this.C.LargeFont;
    }

    public void setBoldFont(boolean bl) {
        this.C.BoldFont = bl;
    }

    public boolean getBoldFont() {
        return this.C.BoldFont;
    }

    public void setObtuse(boolean bl) {
        this.C.Obtuse = bl;
    }

    public boolean getObtuse() {
        return this.C.Obtuse;
    }

    public void setSolid(boolean bl) {
        this.C.Solid = bl;
    }

    public boolean getSolid() {
        return this.C.Solid;
    }

    public void setShowNames(boolean bl) {
        this.C.ShowNames = bl;
    }

    public boolean getShowNames() {
        return this.C.ShowNames;
    }

    public void setShowValues(boolean bl) {
        this.C.ShowValues = bl;
    }

    public boolean getShowValues() {
        return this.C.ShowValues;
    }

    public void setDefaultColorType(int n) {
        this.C.DefaultColorType = n;
    }

    public int getDefaultColorType() {
        return this.C.DefaultColorType;
    }

    public void setShowHidden(boolean bl) {
        this.ShowHidden = bl;
        this.repaint();
    }

    public boolean getShowHidden() {
        return this.ShowHidden;
    }

    public void setHidden(boolean bl) {
        this.C.Hidden = bl;
    }

    public boolean hides(ConstructionObject constructionObject) {
        if (this.OC instanceof SetTargetsTool) {
            return !constructionObject.isFlag();
        }
        return false;
    }

    public void save(OutputStream outputStream, boolean bl, boolean bl2, boolean bl3, Vector vector, String string) throws IOException {
        Object object;
        XmlWriter xmlWriter;
        boolean bl4 = Global.getParameter("options.utf", true);
        if (bl4) {
            xmlWriter = new XmlWriter(new PrintWriter((Writer)new OutputStreamWriter(outputStream, "UTF8"), true));
            xmlWriter.printEncoding(bl4 ? "utf-8" : "iso-8859-1");
        } else {
            xmlWriter = new XmlWriter(new PrintWriter((Writer)new OutputStreamWriter(outputStream), true));
            xmlWriter.printXml();
        }
        xmlWriter.startTagNewLine("CaR");
        if (bl2) {
            Sorter.sort(vector);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = ((MacroItem)enumeration.nextElement()).M;
                if (!bl3 && ((Macro)object).isProtected()) continue;
                ((Macro)object).saveMacro(xmlWriter);
            }
        }
        if (bl) {
            xmlWriter.startTagStart("Construction");
            if (this.isJob()) {
                xmlWriter.printArg("job", "true");
                xmlWriter.printArg("last", this.Last);
                int n = 1;
                object = this.Targets.elements();
                while (object.hasMoreElements()) {
                    xmlWriter.printArg("target" + n, (String)object.nextElement());
                    ++n;
                }
            }
            xmlWriter.startTagEndNewLine();
            xmlWriter.startTagStart("Window");
            xmlWriter.printArg("x", "" + this.C.getX());
            xmlWriter.printArg("y", "" + this.C.getY());
            xmlWriter.printArg("w", "" + this.C.getW());
            if (this.ShowGrid) {
                xmlWriter.printArg("showgrid", "true");
            }
            xmlWriter.finishTagNewLine();
            if (this.ShowGrid) {
                xmlWriter.startTagStart("Grid");
                if (this.AxesOnly) {
                    xmlWriter.printArg("axesonly", "true");
                }
                xmlWriter.printArg("color", "" + this.GridColor);
                xmlWriter.printArg("thickness", "" + this.GridThickness);
                if (!this.GridLabels) {
                    xmlWriter.printArg("nolabels", "true");
                } else {
                    if (this.GridLarge) {
                        xmlWriter.printArg("large", "true");
                    }
                    if (this.GridBold) {
                        xmlWriter.printArg("bold", "true");
                    }
                }
                xmlWriter.finishTagNewLine();
            }
            if (this.getConstruction().BackgroundFile != null && !this.getConstruction().BackgroundFile.equals("")) {
                xmlWriter.startTagStart("Background");
                xmlWriter.printArg("file", this.getConstruction().BackgroundFile);
                if (this.getConstruction().ResizeBackground) {
                    xmlWriter.printArg("resize", "true");
                }
                xmlWriter.finishTagNewLine();
            }
            if (!this.C.getComment().equals("")) {
                xmlWriter.startTagNewLine("Comment");
                xmlWriter.printParagraphs(this.C.getComment(), 60);
                xmlWriter.endTagNewLine("Comment");
            }
            if (!this.C.getJobComment().equals("")) {
                xmlWriter.startTagNewLine("Assignment");
                xmlWriter.printParagraphs(this.C.getJobComment(), 60);
                xmlWriter.endTagNewLine("Assignment");
            }
            if (!string.equals("")) {
                xmlWriter.finishTag("Restrict", "icons", string);
            }
            if (this.OC instanceof ObjectTracker) {
                ((ObjectTracker)this.OC).save(xmlWriter);
            } else if (this.OC instanceof Tracker) {
                ((Tracker)this.OC).save(xmlWriter);
            } else if (this.OC instanceof AnimatorTool) {
                ((AnimatorTool)this.OC).save(xmlWriter);
            } else if (this.OC instanceof BreakpointAnimator) {
                ((BreakpointAnimator)this.OC).save(xmlWriter);
            }
            this.saveDrawings(xmlWriter);
            xmlWriter.startTagNewLine("Objects");
            this.C.save(xmlWriter);
            xmlWriter.endTagNewLine("Objects");
            xmlWriter.endTagNewLine("Construction");
        }
        xmlWriter.endTagNewLine("CaR");
    }

    public void load(InputStream inputStream, boolean bl, boolean bl2) throws Exception {
        if (bl) {
            this.C.clear();
            this.All = false;
            this.paint(this.getGraphics());
        } else {
            this.All = true;
        }
        XmlReader xmlReader = new XmlReader();
        xmlReader.init(inputStream);
        XmlTree xmlTree = xmlReader.scan();
        if (xmlTree == null) {
            throw new ConstructionException("XML file not recognized");
        }
        Enumeration enumeration = xmlTree.getContent();
        while (enumeration.hasMoreElements()) {
            xmlTree = (XmlTree)enumeration.nextElement();
            if (xmlTree.getTag() instanceof XmlTagPI) continue;
            if (xmlTree.getTag().name().equals("CaR")) break;
            throw new ConstructionException("CaR tag not found");
        }
        enumeration = xmlTree.getContent();
        boolean bl3 = false;
        while (enumeration.hasMoreElements()) {
            xmlTree = (XmlTree)enumeration.nextElement();
            XmlTag xmlTag = xmlTree.getTag();
            if (xmlTag.name().equals("Macro")) {
                if (!bl2) continue;
                try {
                    Count.setAllAlternate(true);
                    Macro macro = new Macro(this, xmlTree);
                    int n = 0;
                    for (n = 0; n < this.Macros.size(); ++n) {
                        if (!((MacroItem)this.Macros.elementAt((int)n)).M.getName().equals(macro.getName())) continue;
                        bl3 = this.replaceMacro(macro, n, bl3);
                        break;
                    }
                    if (n >= this.Macros.size()) {
                        this.appendMacro(macro);
                    }
                }
                catch (ConstructionException constructionException) {
                    Count.setAllAlternate(false);
                    throw constructionException;
                }
                Count.setAllAlternate(false);
                continue;
            }
            if (xmlTag.name().equals("Construction")) {
                if (!bl) continue;
                boolean bl4 = false;
                if (xmlTag.hasParam("job")) {
                    bl4 = true;
                    this.Last = xmlTag.getValue("last");
                    if (this.Last == null) {
                        throw new ConstructionException(Zirkel.name("exception.job"));
                    }
                    String string = xmlTag.getValue("target");
                    if (string == null) {
                        this.Targets = new Vector();
                        int n = 1;
                        while (true) {
                            String string2 = xmlTag.getValue("target" + n);
                            ++n;
                            if (string2 != null) {
                                this.Targets.addElement(string2);
                                continue;
                            }
                            break;
                        }
                    } else {
                        this.Targets = new Vector();
                        this.Targets.addElement(string);
                    }
                    if (this.Targets.size() == 0) {
                        throw new ConstructionException(Zirkel.name("exception.job"));
                    }
                }
                this.C.load(xmlTree, this);
                if (!bl4) break;
                if (this.C.find(this.Last) == null) {
                    throw new ConstructionException(Zirkel.name("exception.job"));
                }
                Enumeration enumeration2 = this.Targets.elements();
                while (enumeration2.hasMoreElements()) {
                    String string = (String)enumeration2.nextElement();
                    if (this.C.find(string) != null || string.startsWith("~") && this.C.find(string.substring(1)) != null) continue;
                    throw new ConstructionException(Zirkel.name("exception.job"));
                }
                this.Job = true;
                break;
            }
            throw new ConstructionException("Construction not found");
        }
        this.recompute();
        this.C.translateOffsets(this);
        this.resetSum();
        this.validate();
        this.repaint();
        this.reloadCD();
        this.repaint();
    }

    public void resetSum() {
        Enumeration enumeration = this.C.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!(constructionObject instanceof ExpressionObject)) continue;
            ((ExpressionObject)constructionObject).reset();
        }
    }

    public void warning(String string, String string2) {
        Warning warning = new Warning(this.F, string, Zirkel.name("warning"), true, string2);
        warning.center(this.F);
        warning.setVisible(true);
    }

    public void warning(String string) {
        this.warning(string, "");
    }

    public void load(InputStream inputStream) throws Exception {
        try {
            this.C.Loading = true;
            this.load(inputStream, true, true);
            this.C.Loading = false;
        }
        catch (Exception exception) {
            this.C.Loading = false;
            throw exception;
        }
    }

    public String getComment() {
        return this.C.getComment();
    }

    public void setComment(String string) {
        this.C.setComment(string);
    }

    public String getJobComment() {
        return this.C.getJobComment();
    }

    public void setJobComment(String string) {
        this.C.setJobComment(string);
    }

    public void setFrame(Frame frame) {
        this.F = frame;
    }

    public Frame getFrame() {
        return this.F;
    }

    public void magnify(double d2) {
        this.C.setXYW(this.C.getX(), this.C.getY(), this.C.getW() * d2);
        this.recompute();
        this.validate();
        this.repaint();
    }

    public void shift(double d2, double d3) {
        this.C.setXYW(this.C.getX() + d2 * this.C.getW(), this.C.getY() + d3 * this.C.getW(), this.C.getW());
        this.recompute();
        this.validate();
        this.repaint();
    }

    public void paintTrack(MyGraphics myGraphics) {
        if (!(this.OC instanceof TrackPainter)) {
            return;
        }
        ((TrackPainter)((Object)this.OC)).paint(myGraphics, this);
    }

    public void updateTexts(ConstructionObject constructionObject, String string) {
        this.C.updateTexts(constructionObject, string);
    }

    public Construction getConstruction() {
        return this.C;
    }

    public void setShowGrid(boolean bl) {
        this.ShowGrid = bl;
        this.repaint();
    }

    public void toggleShowGrid() {
        if (this.ShowGrid && !this.AxesOnly) {
            this.AxesOnly = true;
        } else if (this.ShowGrid) {
            this.ShowGrid = false;
        } else {
            this.AxesOnly = false;
            this.ShowGrid = true;
        }
        Global.setParameter("showgrid", this.ShowGrid);
        Global.setParameter("axesonly", this.AxesOnly);
        this.repaint();
    }

    public boolean showGrid() {
        return this.ShowGrid;
    }

    public void setJob(ConstructionObject constructionObject) {
        this.Job = true;
        this.Last = constructionObject.getName();
        this.Targets = new Vector();
    }

    public void addJobTarget(ConstructionObject constructionObject, boolean bl) {
        if (bl) {
            this.Targets.addElement("~" + constructionObject.getName());
        } else {
            this.Targets.addElement(constructionObject.getName());
        }
    }

    public void clearTargets() {
        this.Targets = new Vector();
    }

    public void clearJob() {
        this.Job = false;
    }

    public boolean isJob() {
        Enumeration enumeration = this.Targets.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.C.find(string) != null || string.startsWith("~") && this.C.find(string.substring(1)) != null) continue;
            return false;
        }
        return this.Job && this.C.find(this.Last) != null && this.Targets.size() > 0;
    }

    public boolean inTargets(String string) {
        Enumeration enumeration = this.Targets.elements();
        while (enumeration.hasMoreElements()) {
            if (!((String)enumeration.nextElement()).equals(string)) continue;
            return true;
        }
        return false;
    }

    public void displayJob(boolean bl) {
        this.clearSelected();
        if (!(this.OC instanceof SaveJob)) {
            this.OC.reset(this);
        }
        if (bl) {
            String string;
            ConstructionObject constructionObject;
            this.C.setOriginalOrder(true);
            if (this.displayJob() || !this.isJob()) {
                return;
            }
            Construction construction = new Construction();
            construction.setXYW(this.C.getX(), this.C.getY(), this.C.getW());
            Enumeration enumeration = this.C.elements();
            while (enumeration.hasMoreElements()) {
                constructionObject = (ConstructionObject)enumeration.nextElement();
                constructionObject.setJobTarget(true);
                constructionObject.setJobTarget(false);
            }
            enumeration = this.C.elements();
            while (enumeration.hasMoreElements()) {
                constructionObject = (ConstructionObject)enumeration.nextElement();
                construction.add(constructionObject);
                constructionObject.setKeep(true);
                if (this.inTargets(constructionObject.getName()) || this.inTargets("~" + constructionObject.getName())) {
                    constructionObject.setJobTarget(true);
                }
                if (!constructionObject.getName().equals(this.Last)) continue;
                break;
            }
            while (enumeration.hasMoreElements()) {
                constructionObject = (ConstructionObject)enumeration.nextElement();
                if (!this.inTargets(constructionObject.getName()) && !this.inTargets("~" + constructionObject.getName())) continue;
                construction.add(constructionObject);
                constructionObject.setKeep(true);
                constructionObject.setJobTarget(true);
            }
            int n = 0;
            enumeration = this.Targets.elements();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string.startsWith("~")) continue;
                ++n;
            }
            this.TargetO = new ConstructionObject[n];
            this.TargetS = new ConstructionObject[n];
            n = 0;
            enumeration = this.Targets.elements();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string.startsWith("~")) continue;
                this.TargetO[n] = construction.find(string);
                this.TargetS[n] = null;
                ++n;
            }
            this.COriginal = this.C;
            this.C = construction;
            this.C.addAddEventListener(this);
            this.C.setComment(this.COriginal.getJobComment());
            this.recompute();
            this.reloadCD();
            this.repaint();
        } else {
            if (!this.displayJob()) {
                return;
            }
            this.C.removeAddEventListener(this);
            this.C = this.COriginal;
            this.COriginal = null;
            Enumeration enumeration = this.C.elements();
            while (enumeration.hasMoreElements()) {
                ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
                constructionObject.setKeep(false);
                constructionObject.setJobTarget(false);
            }
            this.C.setOriginalOrder(false);
            this.recompute();
            this.reloadCD();
            this.repaint();
        }
    }

    public void freeJob() {
        Enumeration enumeration = this.C.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            constructionObject.setKeep(false);
            constructionObject.setJobTarget(false);
            this.repaint();
        }
    }

    public boolean displayJob() {
        return this.COriginal != null;
    }

    public void setShowColor(int n) {
        this.ShowColor = n;
        this.repaint();
    }

    public int getShowColor() {
        return this.ShowColor;
    }

    public ObjectConstructor getOC() {
        return this.OC;
    }

    public Vector getMacros() {
        return this.Macros;
    }

    public boolean haveMacros() {
        return this.Macros.size() > 0;
    }

    public boolean haveNonprotectedMacros() {
        Enumeration enumeration = this.Macros.elements();
        while (enumeration.hasMoreElements()) {
            MacroItem macroItem = (MacroItem)enumeration.nextElement();
            if (macroItem.M.isProtected()) continue;
            return true;
        }
        return false;
    }

    boolean defineMacro() {
        this.clearSelected();
        Vector vector = this.C.getParameters();
        if (vector.size() == 0) {
            this.warning(Zirkel.name("definemacro.noparams"));
            return false;
        }
        DefineMacro defineMacro = new DefineMacro(this.F, this);
        defineMacro.center(this.getFrame());
        defineMacro.setVisible(true);
        if (defineMacro.isAborted() || defineMacro.getName().equals("")) {
            return false;
        }
        Macro macro = new Macro(this, defineMacro.getName(), defineMacro.getComment(), defineMacro.getParams());
        try {
            this.defineMacro(this.C, macro, defineMacro.targetsOnly(), defineMacro.invisible(), defineMacro.getPromptFor(), defineMacro.hideduplicates());
        }
        catch (ConstructionException constructionException) {
            this.warning(constructionException.getDescription());
            this.OC.reset(this);
            return false;
        }
        this.storeMacro(macro, false);
        this.OC.reset(this);
        return true;
    }

    public Macro copyMacro(Macro macro, String string, boolean[] blArray) {
        try {
            Macro macro2 = (Macro)macro.clone();
            macro2.Name = string;
            boolean[] blArray2 = new boolean[blArray.length];
            for (int i = 0; i < blArray2.length; ++i) {
                blArray2[i] = blArray[i];
            }
            macro2.Fixed = blArray2;
            this.storeMacro(macro2, true);
            return macro2;
        }
        catch (Exception exception) {
            return macro;
        }
    }

    public void defineMacro(Construction construction, Macro macro, boolean bl, boolean bl2, String[] stringArray, boolean bl3) throws ConstructionException {
        int n;
        Object object;
        Vector vector = construction.getParameters();
        Vector vector2 = construction.getTargets();
        construction.setTranslation(macro);
        construction.clearTranslations();
        if (vector2.size() == 0) {
            construction.determineConstructables();
        } else {
            construction.clearConstructables();
            construction.setParameterAsConstructables();
            for (int i = 0; i < vector2.size(); ++i) {
                construction.determineConstructables((ConstructionObject)vector2.elementAt(i));
            }
        }
        Count.setAllAlternate(true);
        macro.clearTranslators();
        Enumeration enumeration = construction.elements();
        while (enumeration.hasMoreElements()) {
            object = (ConstructionObject[])enumeration.nextElement();
            if (!(object instanceof TwoPointLineObject) || !this.canConvert(construction, (TwoPointLineObject)object) || !((ConstructionObject)object).isMainParameter()) continue;
            ((TwoPointLineObject)object).getP1().setFlag(false);
            ((TwoPointLineObject)object).getP2().setFlag(false);
        }
        enumeration = construction.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (constructionObject.isFlag() && (!constructionObject.isParameter() || constructionObject.isMainParameter() || this.needed(construction, constructionObject, null))) {
                ConstructionObject constructionObject2;
                if (constructionObject instanceof PointObject && constructionObject.isParameter()) {
                    constructionObject2 = (PointObject)constructionObject;
                    object = constructionObject2.isSpecialParameter() && ((PointObject)constructionObject2).dependsOnParametersOnly() ? constructionObject2.copy() : new PointObject(construction, ((PointObject)constructionObject2).getX(), ((PointObject)constructionObject2).getY());
                } else if (constructionObject instanceof FunctionObject && constructionObject.isParameter()) {
                    constructionObject2 = new FunctionObject(construction);
                    ((FunctionObject)constructionObject2).setExpressions("x", "0", "0");
                    ((FunctionObject)constructionObject2).setRange("-10", "10", "0.1");
                    object = constructionObject2;
                } else if (constructionObject instanceof UserFunctionObject && constructionObject.isParameter()) {
                    constructionObject2 = new UserFunctionObject(construction);
                    ((UserFunctionObject)constructionObject2).setExpressions("x", "0");
                    object = constructionObject2;
                } else if (constructionObject instanceof ExpressionObject && constructionObject.isParameter()) {
                    object = new ExpressionObject(construction, 0.0, 0.0);
                    ((ExpressionObject)object).setExpression(constructionObject.getValue() + "", constructionObject.getConstruction());
                    ((ExpressionObject)object).setCurrentValue(constructionObject.getValue());
                } else if (constructionObject instanceof TwoPointLineObject && this.canConvert(construction, (TwoPointLineObject)constructionObject) && constructionObject.isParameter()) {
                    object = new PrimitiveLineObject(construction);
                } else if (constructionObject instanceof PrimitiveLineObject && !(constructionObject instanceof TwoPointLineObject) && !(constructionObject instanceof FixedAngleObject) && constructionObject.isParameter()) {
                    object = new PrimitiveLineObject(construction);
                } else if (constructionObject instanceof PrimitiveCircleObject && constructionObject.isParameter()) {
                    object = new PrimitiveCircleObject(construction, ((PrimitiveCircleObject)constructionObject).getP1());
                    ((ConstructionObject)object).translateConditionals();
                    ((ConstructionObject)object).translate();
                } else if (constructionObject instanceof AreaObject && constructionObject.isParameter()) {
                    object = new AreaObject(construction, new Vector());
                    ((ConstructionObject)object).translateConditionals();
                    ((ConstructionObject)object).translate();
                } else {
                    object = constructionObject.copy();
                }
                if (object == null) continue;
                macro.add((ConstructionObject)object);
                if (constructionObject.isMainParameter()) {
                    ((ConstructionObject)object).setName(constructionObject.getName());
                }
                if (bl && !constructionObject.isTarget() && !constructionObject.isParameter()) {
                    if (bl2) {
                        ((ConstructionObject)object).setSuperHidden(true);
                    } else {
                        ((ConstructionObject)object).setHidden(true);
                    }
                }
                if (constructionObject.isParameter() && constructionObject.isHidden()) {
                    ((ConstructionObject)object).setHidden(true);
                }
                constructionObject.setTranslation((ConstructionObject)object);
                continue;
            }
            constructionObject.setTranslation(null);
        }
        enumeration = construction.elements();
        while (enumeration.hasMoreElements()) {
            object = (ConstructionObject)enumeration.nextElement();
            if (!((ConstructionObject)object).isFlag() || ((ConstructionObject)object).isParameter()) continue;
            ((ConstructionObject)object).laterTranslate(construction);
        }
        Count.setAllAlternate(false);
        construction.clearErrors();
        macro.runTranslators(construction);
        enumeration = construction.getErrors();
        if (enumeration.hasMoreElements()) {
            this.warning((String)enumeration.nextElement(), "macroerror");
        }
        object = new ConstructionObject[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            object[i] = ((ConstructionObject)vector.elementAt(i)).getTranslation();
        }
        macro.setParams((ConstructionObject[])object);
        String[] stringArray2 = new String[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            ConstructionObject constructionObject = construction.find(stringArray[n]);
            if (constructionObject == null || constructionObject.getTranslation() == null || !(constructionObject instanceof FixedCircleObject) && !(constructionObject instanceof FixedAngleObject) && !(constructionObject instanceof ExpressionObject)) {
                throw new ConstructionException(Zirkel.name("exception.prompt"));
            }
            for (int i = 0; i < vector.size(); ++i) {
                ConstructionObject constructionObject3 = (ConstructionObject)vector.elementAt(i);
                if (constructionObject3 != constructionObject) continue;
                throw new ConstructionException(Zirkel.name("exception.prompt.parameter"));
            }
            stringArray2[n] = constructionObject.getTranslation().getName();
        }
        macro.setPromptFor(stringArray2);
        for (n = 0; n < stringArray.length; ++n) {
            macro.setPromptName(n, stringArray[n]);
        }
        macro.hideDuplicates(bl3);
    }

    public boolean needed(Construction construction, ConstructionObject constructionObject, ConstructionObject constructionObject2) {
        Enumeration enumeration = construction.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject3 = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject3.isFlag() || constructionObject3 == constructionObject2 || !construction.dependsDirectlyOn(constructionObject3, constructionObject)) continue;
            return true;
        }
        return false;
    }

    public boolean canConvert(Construction construction, TwoPointLineObject twoPointLineObject) {
        PointObject pointObject = twoPointLineObject.getP1();
        PointObject pointObject2 = twoPointLineObject.getP2();
        if (pointObject.isMainParameter() || pointObject2.isMainParameter()) {
            return false;
        }
        return !this.needed(construction, pointObject, twoPointLineObject) && !this.needed(construction, pointObject2, twoPointLineObject);
    }

    public void defineMacro(String string, String string2, Construction construction) throws ConstructionException {
        Vector vector = construction.getTargets();
        String[] stringArray = new String[construction.Prompts.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)construction.Prompts.elementAt(i);
        }
        Macro macro = new Macro(this, string, string2, stringArray);
        this.defineMacro(construction, macro, vector.size() > 0 && !construction.ShowAll, construction.SuperHide, construction.getPromptFor(), true);
        this.storeMacro(macro, true);
    }

    public void storeMacro(Macro macro, boolean bl) {
        int n = 0;
        for (n = 0; n < this.Macros.size(); ++n) {
            if (!((MacroItem)this.Macros.elementAt((int)n)).M.getName().equals(macro.getName())) continue;
            this.All = this.replaceMacro(macro, n, bl);
            break;
        }
        if (n >= this.Macros.size()) {
            this.appendMacro(macro);
        }
    }

    public void appendMacro(Macro macro) {
        if (!this.ReadOnly) {
            if (this.ProtectMacros) {
                macro.setProtected(true);
            }
            if (this.MM == null) {
                this.MM = new MacroMenu(this.PM, "", null);
            }
            MacroItem macroItem = this.MM.add(macro, macro.getName());
            macroItem.I.addActionListener(this);
            this.Macros.addElement(macroItem);
        } else {
            if (this.MM == null) {
                this.MM = new MacroMenu(null, "", null);
            }
            MacroItem macroItem = this.MM.add(macro, macro.getName());
            if (macroItem.I != null) {
                macroItem.I.addActionListener(this);
            }
            this.Macros.addElement(macroItem);
        }
    }

    public boolean replaceMacro(Macro macro, int n, boolean bl) {
        MacroItem macroItem = (MacroItem)this.Macros.elementAt(n);
        if (bl) {
            this.Macros.setElementAt(new MacroItem(macro, macroItem.I), n);
            return true;
        }
        ReplaceMacroQuestion replaceMacroQuestion = new ReplaceMacroQuestion(this.getFrame(), macro);
        replaceMacroQuestion.center(this.getFrame());
        replaceMacroQuestion.setVisible(true);
        if (replaceMacroQuestion.isNo()) {
            return false;
        }
        MacroItem macroItem2 = new MacroItem(macro, macroItem.I);
        this.MM.replace((MacroItem)this.Macros.elementAt(n), macroItem2);
        this.Macros.setElementAt(macroItem2, n);
        return replaceMacroQuestion.isAll();
    }

    public Macro chooseMacro() {
        if (this.Macros.size() == 0) {
            this.warning(Zirkel.name("definemacro.nomacro"));
            return null;
        }
        MacroSelectDialog macroSelectDialog = new MacroSelectDialog(this.getFrame(), this.MM, false);
        macroSelectDialog.setVisible(true);
        return macroSelectDialog.getMacro();
    }

    public Vector chooseMacros() {
        if (this.Macros.size() == 0) {
            this.warning(Zirkel.name("definemacro.nomacro"));
            return null;
        }
        MacroSelectDialog macroSelectDialog = new MacroSelectDialog(this.getFrame(), this.MM, true);
        macroSelectDialog.setVisible(true);
        return macroSelectDialog.getMacros();
    }

    public Macro chooseMacro(String string) {
        Enumeration enumeration = this.Macros.elements();
        while (enumeration.hasMoreElements()) {
            Macro macro = ((MacroItem)enumeration.nextElement()).M;
            if (!macro.getName().equals(string)) continue;
            return macro;
        }
        return null;
    }

    public void deleteMacros(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MacroItem macroItem = (MacroItem)enumeration.nextElement();
            this.deleteMacro(macroItem);
        }
    }

    public void deleteMacro(MacroItem macroItem) {
        this.Macros.removeElement(macroItem);
        if (macroItem.I != null) {
            macroItem.I.removeActionListener(this);
            this.MM.remove(macroItem);
        }
    }

    public void clearMacros() {
        Enumeration enumeration = this.Macros.elements();
        while (enumeration.hasMoreElements()) {
            MacroItem macroItem = (MacroItem)enumeration.nextElement();
            if (macroItem.I == null) continue;
            macroItem.I.removeActionListener(this);
            this.MM.remove(macroItem);
        }
        this.Macros.removeAllElements();
    }

    public void clearNonprotectedMacros() {
        Vector<MacroItem> vector = new Vector<MacroItem>();
        Enumeration enumeration = this.Macros.elements();
        while (enumeration.hasMoreElements()) {
            MacroItem macroItem = (MacroItem)enumeration.nextElement();
            if (macroItem.M.isProtected()) continue;
            vector.addElement(macroItem);
        }
        this.deleteMacros(vector);
    }

    public void clearProtectedMacros() {
        Vector<MacroItem> vector = new Vector<MacroItem>();
        Enumeration enumeration = this.Macros.elements();
        while (enumeration.hasMoreElements()) {
            MacroItem macroItem = (MacroItem)enumeration.nextElement();
            if (!macroItem.M.isProtected()) continue;
            vector.addElement(macroItem);
        }
        this.deleteMacros(vector);
    }

    public void protectMacros() {
        Enumeration enumeration = this.Macros.elements();
        while (enumeration.hasMoreElements()) {
            MacroItem macroItem = (MacroItem)enumeration.nextElement();
            macroItem.M.setProtected(true);
        }
    }

    public void renameMacro(Macro macro, String string) {
        Enumeration enumeration = this.Macros.elements();
        while (enumeration.hasMoreElements()) {
            MacroItem macroItem = (MacroItem)enumeration.nextElement();
            if (macroItem.I == null || macroItem.M != macro) continue;
            this.deleteMacro(macroItem);
            break;
        }
        macro.setName(string);
        this.appendMacro(macro);
    }

    public void setMacroBar(MacroBar macroBar) {
        this.MBar = macroBar;
    }

    public void updateMacroBar() {
        if (this.MBar != null) {
            this.MBar.update(this.Macros);
        }
    }

    public void setTextField(TextField textField) {
        this.TF = textField;
    }

    public void setPrompt(String string) {
        if (this.TF != null) {
            this.TF.setText(string);
        }
    }

    public void loadRun(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = "";
        String string2 = "";
        try {
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf("//");
                if (n >= 0) {
                    string2 = string.substring(n + 2).trim();
                    string = string.substring(0, n);
                } else {
                    string2 = "";
                }
                string = string.trim();
                int n2 = 0;
                n2 = Interpreter.startTest("macro", string);
                if (n2 >= 0) {
                    this.loadMacro(bufferedReader, string.substring(n2).trim());
                    continue;
                }
                if (string.equals("")) continue;
                this.C.interpret(this, string, string2);
            }
        }
        catch (ConstructionException constructionException) {
            this.warning(constructionException.getDescription() + " --- " + string);
        }
        catch (Exception exception) {
            this.warning(exception.toString() + " --- " + string);
            exception.printStackTrace();
        }
        this.C.updateCircleDep();
    }

    public void loadMacro(BufferedReader bufferedReader, String string) throws ConstructionException {
        Construction construction = new Construction();
        construction.clear();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl = true;
        boolean bl2 = true;
        block4: while (true) {
            try {
                while (true) {
                    if ((string2 = bufferedReader.readLine()) == null) {
                        throw new ConstructionException(Zirkel.name("exception.macroend"));
                    }
                    string2 = string2.trim();
                    int n = string2.indexOf("//");
                    if (bl && n == 0) {
                        String string5 = string2.substring(n + 2).trim();
                        if (bl2) {
                            string4 = string4 + string5;
                            bl2 = false;
                            continue;
                        }
                        if (string5.equals("")) {
                            string4 = string4 + "\n";
                            bl2 = true;
                            continue;
                        }
                        string4 = string4 + " " + string5;
                        bl2 = false;
                        continue;
                    }
                    bl = false;
                    if (n >= 0) {
                        string3 = string2.substring(n + 2).trim();
                        string2 = string2.substring(0, n);
                    } else {
                        string3 = "";
                    }
                    string2 = string2.trim();
                    if (string2.equals(Zirkel.name("end")) || string2.toLowerCase().equals("end")) break block4;
                    if (string2.equals("")) continue;
                    construction.interpret(this, string2, string3);
                }
            }
            catch (InvalidException invalidException) {
                continue;
            }
            catch (ConstructionException constructionException) {
                throw new ConstructionException(constructionException.getDescription() + " --- " + string2);
            }
            catch (IOException iOException) {
                this.warning(iOException.toString());
                return;
            }
            break;
        }
        this.defineMacro(string, string4, construction);
    }

    public double getGridSize() {
        double d2 = Math.pow(10.0, Math.floor(Math.log(this.C.getW() * 2.0) / Math.log(10.0))) / 10.0;
        if (this.C.getW() * 2.0 / d2 >= 30.0) {
            d2 *= 5.0;
        }
        if (this.C.getW() * 2.0 / d2 < 10.0) {
            d2 /= 2.0;
        }
        return d2;
    }

    public synchronized void print(Graphics graphics, int n, int n2) {
        if (this.IW == 0 || this.I == null) {
            return;
        }
        this.startWaiting();
        int n3 = this.IW;
        int n4 = this.IH;
        this.Scale = (double)n / (double)n3;
        this.PointSize *= this.Scale;
        double d2 = this.FontSize * this.Scale;
        MyGraphics11 myGraphics11 = new MyGraphics11(graphics);
        myGraphics11.setSize(n3, n4);
        ((MyGraphics)myGraphics11).setDefaultFont((int)d2, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
        this.IW = n;
        this.IH = n2;
        this.recompute();
        if (this.Background != null) {
            int n5 = this.Background.getWidth(this);
            int n6 = this.Background.getHeight(this);
            if (n5 == this.IW && n6 == this.IH) {
                ((MyGraphics)myGraphics11).drawImage(this.Background, 0, 0, this);
            } else if (Global.getParameter("background.tile", true) && n5 < this.IW && n6 < this.IH) {
                for (int i = this.IW % n5 / 2 - n5; i < this.IW; i += n5) {
                    for (int j = this.IH % n6 / 2 - n6; j < this.IH; j += n6) {
                        ((MyGraphics)myGraphics11).drawImage(this.Background, i, j, this);
                    }
                }
            } else if (Global.getParameter("background.center", true)) {
                ((MyGraphics)myGraphics11).drawImage(this.Background, (this.IW - n5) / 2, (this.IH - n6) / 2, this);
            } else {
                ((MyGraphics)myGraphics11).drawImage(this.Background, 0, 0, this.IW, this.IH, this);
            }
        }
        this.dopaint(myGraphics11);
        this.Interactive = true;
        this.Scale = 1.0;
        this.I = null;
        this.endWaiting();
        this.repaint();
    }

    public LatexOutput createBB(String string, int n, int n2, double d2) {
        try {
            String string2 = "";
            if (Global.getParameter("options.fullpath", true)) {
                string2 = FileName.pathAndSeparator(string);
            }
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string2 + FileName.purefilename(string) + ".bb"));
            printWriter.println("%%BoundingBox: 0 0 " + n + " " + n2);
            printWriter.close();
            printWriter = new PrintWriter(new FileOutputStream(string2 + FileName.purefilename(string) + ".ztx"));
            LatexOutput latexOutput = new LatexOutput(printWriter);
            latexOutput.open(n, n2, d2, string2 + FileName.filename(string));
            return latexOutput;
        }
        catch (Exception exception) {
            this.warning(exception.toString());
            return null;
        }
    }

    public synchronized boolean savePNG(String string, boolean bl) {
        int n;
        int n2;
        int n3;
        LatexOutput latexOutput = null;
        if (this.IW == 0 || this.I == null) {
            return false;
        }
        if (Global.getParameter("printscale.middle", true)) {
            this.savePreviewAsPNG(string);
            return true;
        }
        double d2 = Global.getParameter("printscale.dpi", 300);
        if (!Global.getParameter("printscale.sizes", false)) {
            n3 = Global.getParameter("printscale.w", this.IW);
            n2 = Global.getParameter("printscale.h", this.IH);
            if (bl) {
                latexOutput = this.createBB(string, n3, n2, d2);
            }
            n = this.IW;
            this.IW = n3;
            this.IH = n2;
            this.Scale = (double)this.IW / (double)n;
            this.I = this.createImage(this.IW, this.IH);
            if (!Global.getParameter("simplegraphics", false)) {
                this.IG = new MyGraphics13(this.I.getGraphics(), this.Scale, this, latexOutput);
                this.IG.setSize(n3, n2);
            } else {
                this.IG = new MyGraphics11(this.I.getGraphics());
                this.IG.setSize(n3, n2);
            }
            double d3 = this.PointSize * this.Scale;
            double d4 = this.FontSize * this.Scale;
            if (this.Scale < 1.0) {
                if (Global.getParameter("options.minpointsize", false) && d3 < this.MinPointSize) {
                    d3 = this.MinPointSize;
                }
                if (Global.getParameter("options.minfontsize", false) && d4 < this.MinFontSize) {
                    d4 = this.MinFontSize;
                }
            }
            this.IG.setDefaultFont((int)d4, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
            this.PointSize = d3;
        } else {
            n3 = this.IW;
            d2 = Global.getParameter("printscale.dpi", 300.0);
            this.IW = (int)(Global.getParameter("printscale.width", 5.0) / 2.54 * d2);
            this.IH = (int)(Global.getParameter("printscale.height", 5.0) / 2.54 * d2);
            if (bl) {
                latexOutput = this.createBB(string, this.IW, this.IH, d2);
            }
            this.I = this.createImage(this.IW, this.IH);
            if (!Global.getParameter("simplegraphics", false)) {
                this.IG = new MyGraphics13(this.I.getGraphics(), Global.getParameter("printscale.linewidth", 0.02) / 2.54 * d2, this, latexOutput);
                this.IG.setSize(this.IW, this.IH);
            } else {
                this.IG = new MyGraphics11(this.I.getGraphics());
                this.IG.setSize(this.IW, this.IH);
            }
            this.PointSize = Global.getParameter("printscale.pointsize", 0.07) / 2.54 * d2;
            this.IG.setDefaultFont((int)(Global.getParameter("printscale.textsize", 0.3) / 2.54 * d2), Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
            this.Scale = (double)this.IW / (double)n3;
        }
        this.recompute();
        if (Global.getParameter("options.bitmapbackground", false)) {
            this.IG.clearRect(0, 0, this.IW, this.IH, this.getBackground());
        } else {
            this.IG.clearRect(0, 0, this.IW, this.IH, Color.white);
        }
        if (this.Background != null) {
            n3 = this.Background.getWidth(this);
            n2 = this.Background.getHeight(this);
            if (n3 == this.IW && n2 == this.IH) {
                this.IG.drawImage(this.Background, 0, 0, this);
            } else if (Global.getParameter("background.tile", true) && n3 < this.IW && n2 < this.IH) {
                for (n = this.IW % n3 / 2 - n3; n < this.IW; n += n3) {
                    for (int i = this.IH % n2 / 2 - n2; i < this.IH; i += n2) {
                        this.IG.drawImage(this.Background, n, i, this);
                    }
                }
            } else if (Global.getParameter("background.center", true)) {
                this.IG.drawImage(this.Background, (this.IW - n3) / 2, (this.IH - n2) / 2, this);
            } else {
                this.IG.drawImage(this.Background, 0, 0, this.IW, this.IH, this);
            }
        }
        this.dopaint(this.IG);
        if (latexOutput != null) {
            latexOutput.close();
        }
        this.Interactive = true;
        if (!string.equals("")) {
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
                PngEncoder pngEncoder = new PngEncoder(this.I, false, 0, 9);
                pngEncoder.setDPI(d2);
                bufferedOutputStream.write(pngEncoder.pngEncode());
                bufferedOutputStream.close();
            }
            catch (Exception exception) {
                this.warning(exception.toString());
            }
        } else {
            try {
                Clipboard clipboard = this.getToolkit().getSystemClipboard();
                ImageSelection imageSelection = new ImageSelection(this.I);
                clipboard.setContents(imageSelection, null);
            }
            catch (Exception exception) {
                this.Scale = 1.0;
                this.I = null;
                this.repaint();
                return false;
            }
        }
        this.Scale = 1.0;
        this.I = null;
        this.repaint();
        return true;
    }

    public void savePreviewAsPNG(String string) {
        int n = Global.getParameter("printscale.w", this.IW);
        int n2 = Global.getParameter("printscale.h", this.IH);
        Image image = this.createImage(n, n2);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, n, n2);
        graphics.drawImage(this.I, -(this.IW - n) / 2, -(this.IH - n2) / 2, this);
        if (!string.equals("")) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                PngEncoder pngEncoder = new PngEncoder(image, false, 0, 9);
                fileOutputStream.write(pngEncoder.pngEncode());
                fileOutputStream.close();
            }
            catch (Exception exception) {
                this.warning(exception.toString());
            }
        } else {
            try {
                Clipboard clipboard = this.getToolkit().getSystemClipboard();
                ImageSelection imageSelection = new ImageSelection(this.I);
                clipboard.setContents(imageSelection, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void saveFIG(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            MyGraphicsFig myGraphicsFig = new MyGraphicsFig(printWriter, this.IW, this.IH);
            myGraphicsFig.setSize(this.IW, this.IH);
            this.dopaintFig(myGraphicsFig);
            myGraphicsFig.close();
            printWriter.close();
        }
        catch (Exception exception) {
            this.warning(exception.toString());
            exception.printStackTrace();
        }
    }

    public void saveSVG(String string) {
        try {
            OutputStream outputStream = new FileOutputStream(string);
            if (ZirkelFrame.isCompressed(string)) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF8"));
            MyGraphicsSvg myGraphicsSvg = new MyGraphicsSvg(printWriter, this.IW, this.IH);
            myGraphicsSvg.setSize(this.IW, this.IH);
            this.dopaint(myGraphicsSvg);
            myGraphicsSvg.close();
            printWriter.close();
        }
        catch (Exception exception) {
            this.warning(exception.toString());
            exception.printStackTrace();
        }
    }

    public void savePDF(String string) {
        PrintWriter printWriter = null;
        try {
            OutputStream outputStream = new FileOutputStream(string);
            if (ZirkelFrame.isCompressed(string)) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "CP1252"));
        }
        catch (Exception exception) {
            this.warning(exception.toString());
            exception.printStackTrace();
        }
        int n = this.IW;
        int n2 = this.IH;
        this.IW = (int)((double)Global.getParameter("printscale.width", this.IW * 2) / 2.54 * 72.0 + 0.5);
        this.IH = (int)((double)Global.getParameter("printscale.height", this.IH * 2) / 2.54 * 72.0 + 0.5);
        double d2 = this.PointSize;
        this.Scale = (double)this.IW / (double)n;
        double d3 = this.PointSize * this.Scale;
        double d4 = this.FontSize * this.Scale + 1.0;
        double d5 = this.Scale;
        if (Global.getParameter("printscale.sizes", false)) {
            d3 = Global.getParameter("printscale.pointsize", 0.07) / 2.54 * 72.0;
            d4 = Global.getParameter("printscale.fontsize", 0.3) / 2.54 * 72.0;
            d5 = Global.getParameter("printscale.linewidth", 0.02) / 2.54 * 72.0;
        }
        this.PointSize = d3;
        this.recompute();
        MyGraphicsPDF myGraphicsPDF = new MyGraphicsPDF(printWriter, this.IW, this.IH, d5);
        myGraphicsPDF.setSize(this.IW, this.IH);
        myGraphicsPDF.setDefaultFont((int)d4, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
        try {
            this.dopaint(myGraphicsPDF);
            myGraphicsPDF.close();
            printWriter.close();
        }
        catch (Exception exception) {
            this.warning(exception.toString());
            exception.printStackTrace();
        }
        this.IW = n;
        this.IH = n2;
        this.Scale = 1.0;
        this.PointSize = d2;
        this.I = null;
        this.repaint();
    }

    public void saveEPS(String string) {
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(string);
            if (ZirkelFrame.isCompressed(string)) {
                outputStream = new GZIPOutputStream(outputStream);
            }
        }
        catch (Exception exception) {
            this.warning(exception.toString());
            exception.printStackTrace();
        }
        int n = this.IW;
        int n2 = this.IH;
        this.IW = (int)((double)Global.getParameter("printscale.width", this.IW * 2) / 2.54 * 72.0 + 0.5);
        this.IH = (int)((double)Global.getParameter("printscale.height", this.IH * 2) / 2.54 * 72.0 + 0.5);
        double d2 = this.PointSize;
        this.Scale = (double)this.IW / (double)n;
        double d3 = this.PointSize * this.Scale;
        double d4 = this.FontSize * this.Scale + 1.0;
        double d5 = this.Scale;
        if (Global.getParameter("printscale.sizes", false)) {
            d3 = Global.getParameter("printscale.pointsize", 0.07) / 2.54 * 72.0;
            d4 = Global.getParameter("printscale.fontsize", 0.3) / 2.54 * 72.0;
            d5 = Global.getParameter("printscale.linewidth", 0.02) / 2.54 * 72.0;
        }
        this.PointSize = d3;
        this.recompute();
        try {
            MyGraphicsEPS myGraphicsEPS = new MyGraphicsEPS(outputStream, this.IW, this.IH);
            myGraphicsEPS.setSize(this.IW, this.IH);
            myGraphicsEPS.setLineWidth(d5);
            myGraphicsEPS.setDefaultFont((int)d4, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
            this.dopaint(myGraphicsEPS);
            myGraphicsEPS.close();
            outputStream.close();
        }
        catch (Exception exception) {
            this.warning(exception.toString());
            exception.printStackTrace();
        }
        this.IW = n;
        this.IH = n2;
        this.Scale = 1.0;
        this.PointSize = d2;
        this.I = null;
        this.repaint();
    }

    public void returnPressed() {
        if (this.OC instanceof MacroRunner) {
            ((MacroRunner)this.OC).returnPressed(this);
        }
    }

    public void bind(PointObject pointObject) {
        this.setTool(new BinderTool(this, pointObject, this.OC));
    }

    public void setAway(IntersectionObject intersectionObject, boolean bl) {
        this.setTool(new SetAwayTool(this, intersectionObject, bl, this.OC));
    }

    public void setCurveCenter(FunctionObject functionObject) {
        this.setTool(new SetCurveCenterTool(this, functionObject, this.OC));
    }

    public void range(PrimitiveCircleObject primitiveCircleObject) {
        this.setTool(new SetRangeTool(this, primitiveCircleObject, this.OC));
    }

    public void set(FixedAngleObject fixedAngleObject) {
        this.setTool(new SetFixedAngle(this, fixedAngleObject, this.OC));
    }

    public void set(FixedCircleObject fixedCircleObject) {
        this.setTool(new SetFixedCircle(this, fixedCircleObject, this.OC));
    }

    public boolean enabled(String string) {
        if (this.ZCI != null) {
            return this.ZCI.enabled(string);
        }
        return true;
    }

    public void pause(boolean bl) {
        this.OC.pause(bl);
    }

    public void setReadOnly(boolean bl) {
        this.ReadOnly = bl;
    }

    public void allowRightMouse(boolean bl) {
        this.AllowRightMouse = bl;
    }

    public boolean changed() {
        return this.C.changed();
    }

    public void grab(boolean bl) {
        if (bl) {
            this.OldBackground = this.Background;
            this.Background = this.createImage(this.IW, this.IH);
            Graphics graphics = this.Background.getGraphics();
            graphics.drawImage(this.I, 0, 0, this);
        } else {
            this.Background = this.OldBackground;
            this.OldBackground = null;
        }
        this.repaint();
    }

    public void setBackground(Image image) {
        this.Background = image;
        this.repaint();
    }

    public void setInteractive(boolean bl) {
        this.Interactive = bl;
    }

    public ObjectConstructor getCurrentTool() {
        return this.OC;
    }

    public synchronized void addDrawing(Drawing drawing) {
        this.Drawings.addElement(drawing);
    }

    public synchronized void clearDrawings() {
        this.Drawings.removeAllElements();
        this.repaint();
    }

    public synchronized void paintDrawings(MyGraphics myGraphics) {
        Enumeration enumeration = this.Drawings.elements();
        while (enumeration.hasMoreElements()) {
            Drawing drawing = (Drawing)enumeration.nextElement();
            Enumeration enumeration2 = drawing.elements();
            if (!enumeration2.hasMoreElements()) continue;
            myGraphics.setColor(ZirkelFrame.Colors[drawing.getColor()]);
            CoordinatesXY coordinatesXY = (CoordinatesXY)enumeration2.nextElement();
            int n = (int)this.col(coordinatesXY.X);
            int n2 = (int)this.row(coordinatesXY.Y);
            while (enumeration2.hasMoreElements()) {
                coordinatesXY = (CoordinatesXY)enumeration2.nextElement();
                int n3 = (int)this.col(coordinatesXY.X);
                int n4 = (int)this.row(coordinatesXY.Y);
                myGraphics.drawLine(n, n2, n3, n4);
                n = n3;
                n2 = n4;
            }
        }
    }

    public void saveDrawings(XmlWriter xmlWriter) {
        Enumeration enumeration = this.Drawings.elements();
        while (enumeration.hasMoreElements()) {
            Drawing drawing = (Drawing)enumeration.nextElement();
            Enumeration enumeration2 = drawing.elements();
            if (!enumeration2.hasMoreElements()) continue;
            xmlWriter.startTagNewLine("Draw", "color", "" + drawing.getColor());
            while (enumeration2.hasMoreElements()) {
                CoordinatesXY coordinatesXY = (CoordinatesXY)enumeration2.nextElement();
                xmlWriter.startTagStart("Point");
                xmlWriter.printArg("x", "" + coordinatesXY.X);
                xmlWriter.printArg("y", "" + coordinatesXY.Y);
                xmlWriter.finishTagNewLine();
            }
            xmlWriter.endTagNewLine("Draw");
        }
    }

    public void loadDrawings(XmlTree xmlTree) throws ConstructionException {
        XmlTag xmlTag = xmlTree.getTag();
        if (!xmlTag.name().equals("Draw")) {
            return;
        }
        Drawing drawing = new Drawing();
        try {
            if (xmlTag.hasParam("color")) {
                drawing.setColor(Integer.parseInt(xmlTag.getValue("color")));
            }
        }
        catch (Exception exception) {
            throw new ConstructionException("Illegal Draw Parameter");
        }
        Enumeration enumeration = xmlTree.getContent();
        while (enumeration.hasMoreElements()) {
            XmlTree xmlTree2 = (XmlTree)enumeration.nextElement();
            xmlTag = xmlTree2.getTag();
            if (!xmlTag.name().equals("Point")) continue;
            try {
                double d2 = new Double(xmlTag.getValue("x"));
                double d3 = new Double(xmlTag.getValue("y"));
                drawing.addXY(d2, d3);
            }
            catch (Exception exception) {
                throw new ConstructionException("Illegal Draw Parameter");
            }
        }
        this.Drawings.addElement(drawing);
    }

    public void renameABC(ConstructionObject constructionObject, boolean bl, boolean bl2) {
        if (!bl) {
            if (constructionObject instanceof PointObject) {
                for (int i = 65; i <= 90; ++i) {
                    ConstructionObject constructionObject2 = this.C.find("" + (char)i);
                    if (constructionObject2 != null) continue;
                    constructionObject.setName("" + (char)i);
                    constructionObject.setShowName(true);
                    this.repaint();
                    break;
                }
            } else if (constructionObject instanceof AngleObject || constructionObject instanceof FixedAngleObject) {
                for (int i = 97; i <= 122; ++i) {
                    ConstructionObject constructionObject3 = this.C.find("\\" + (char)i);
                    if (constructionObject3 != null) continue;
                    constructionObject.setName("\\" + (char)i);
                    constructionObject.setShowName(true);
                    this.repaint();
                    break;
                }
            } else if (constructionObject instanceof PrimitiveLineObject) {
                for (int i = 97; i <= 122; ++i) {
                    ConstructionObject constructionObject4 = this.C.find("" + (char)i);
                    if (constructionObject4 != null) continue;
                    constructionObject.setName("" + (char)i);
                    constructionObject.setShowName(true);
                    this.repaint();
                    break;
                }
            }
        } else {
            if (bl2) {
                this.PointLast = 0;
                this.LineLast = 0;
                this.AngleLast = 0;
            }
            if (constructionObject instanceof PointObject) {
                String string = "" + (char)(65 + this.PointLast);
                ConstructionObject constructionObject5 = this.C.find(string);
                if (constructionObject5 != null && constructionObject5 != constructionObject) {
                    constructionObject5.setName("***temp***");
                    String string2 = constructionObject.getName();
                    constructionObject.setName(string);
                    constructionObject5.setName(string2);
                } else {
                    constructionObject.setName(string);
                }
                ++this.PointLast;
            } else if (constructionObject instanceof AngleObject || constructionObject instanceof FixedAngleObject) {
                String string = "\\" + (char)(97 + this.AngleLast);
                ConstructionObject constructionObject6 = this.C.find(string);
                if (constructionObject6 != null && constructionObject6 != constructionObject) {
                    constructionObject6.setName("***temp***");
                    String string3 = constructionObject.getName();
                    constructionObject.setName(string);
                    constructionObject6.setName(string3);
                } else {
                    constructionObject.setName(string);
                }
                ++this.AngleLast;
            } else if (constructionObject instanceof PrimitiveLineObject) {
                String string = "" + (char)(97 + this.LineLast);
                ConstructionObject constructionObject7 = this.C.find(string);
                if (constructionObject7 != null && constructionObject7 != constructionObject) {
                    constructionObject7.setName("***temp***");
                    String string4 = constructionObject.getName();
                    constructionObject.setName(string);
                    constructionObject7.setName(string4);
                } else {
                    constructionObject.setName(string);
                }
                ++this.LineLast;
            }
        }
    }

    public void selectAllMoveableVisibleObjects() {
        Enumeration enumeration = this.C.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!(constructionObject instanceof MoveableObject) || !((MoveableObject)((Object)constructionObject)).moveable() || constructionObject.mustHide(this)) continue;
            constructionObject.setStrongSelected(true);
        }
    }

    public void hideDuplicates(ConstructionObject constructionObject) {
        ConstructionObject constructionObject2;
        Enumeration enumeration = this.C.elements();
        if (constructionObject != null) {
            while (enumeration.hasMoreElements() && (constructionObject2 = (ConstructionObject)enumeration.nextElement()) != constructionObject) {
            }
        }
        block1: while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject3;
            constructionObject2 = (ConstructionObject)enumeration.nextElement();
            if (constructionObject2.mustHide(this) || constructionObject2.isKeep()) continue;
            Enumeration enumeration2 = this.C.elements();
            while (enumeration2.hasMoreElements() && (constructionObject3 = (ConstructionObject)enumeration2.nextElement()) != constructionObject2) {
                if (constructionObject3.mustHide(this) || constructionObject3.isKeep() || !constructionObject2.equals(constructionObject3)) continue;
                constructionObject2.setHidden(true);
                continue block1;
            }
        }
    }

    public void hideDuplicates() {
        this.hideDuplicates(null);
    }

    public void createCurve() {
        FunctionObject functionObject = new FunctionObject(this.C);
        functionObject.setDefaults();
        this.C.add(functionObject);
        functionObject.setExpressions("x", "x", "0");
        functionObject.edit(this);
        if (functionObject.EditAborted) {
            this.delete(functionObject);
        }
        this.repaint();
        this.reloadCD();
    }

    public void createFunction() {
        UserFunctionObject userFunctionObject = new UserFunctionObject(this.C);
        userFunctionObject.setDefaults();
        userFunctionObject.setShowName(true);
        userFunctionObject.setShowValue(true);
        this.C.add(userFunctionObject);
        userFunctionObject.setExpressions("x", "0");
        userFunctionObject.edit(this);
        if (userFunctionObject.EditAborted) {
            this.delete(userFunctionObject);
        }
        this.repaint();
        this.reloadCD();
    }

    public void editLast() {
        if (this.C.last() == null) {
            return;
        }
        this.C.last().edit(this);
    }

    public void breakpointLast(boolean bl, boolean bl2) {
        ConstructionObject constructionObject = this.C.last();
        if (constructionObject == null) {
            return;
        }
        if (bl2) {
            constructionObject.setHideBreak(bl);
        } else {
            constructionObject.setBreak(bl);
        }
    }

    public void notifyChanged() {
        if (!this.C.Loading) {
            this.reloadCD();
        }
    }

    public void startWaiting() {
        this.Interactive = false;
        this.showMessage(Zirkel.name("message.saving"));
    }

    public void endWaiting() {
        this.Interactive = true;
        this.hideMessage();
    }

    public void showMessage(String string) {
        this.hideMessage();
        this.MW = new MessageWindow(this.F, string);
        this.MW.setVisible(true);
    }

    public void hideMessage() {
        if (this.MW != null) {
            this.MW.setVisible(false);
            this.MW.dispose();
            this.MW = null;
        }
    }

    public void setHotEqn(String string) {
        if (this.HE == null) {
            this.HE = new sHotEqn(this);
        }
        this.HE.setEquation(string);
    }

    public int paintHotEqn(int n, int n2, Graphics graphics) {
        if (this.HE == null) {
            return 0;
        }
        return this.HE.paint(n, n2, graphics);
    }

    public void reloadCD() {
        if (this.CDP != null && this.C != null) {
            this.CDP.reload();
        }
    }

    public void repaintCD() {
        if (this.CDP != null && this.C != null) {
            this.CDP.updateDisplay();
        }
    }

    public void callCDAction(String string) {
        if (this.CDP != null && this.C != null) {
            this.CDP.doAction(string);
        }
    }

    public void callCDItem(String string, boolean bl) {
        if (this.CDP != null && this.C != null) {
            this.CDP.itemAction(string, bl);
        }
    }

    public void callCDToggleItem(String string) {
        if (this.CDP != null && this.C != null) {
            this.CDP.itemToggleAction(string);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (Global.getParameter("options.nomousezoom", false)) {
            return;
        }
        if (mouseWheelEvent.getScrollType() == 1) {
            if (mouseWheelEvent.getWheelRotation() < 0) {
                this.magnify(1.0 / Math.sqrt(Math.sqrt(2.0)));
            } else {
                this.magnify(Math.sqrt(Math.sqrt(2.0)));
            }
        } else {
            int n = mouseWheelEvent.getScrollAmount();
            if (mouseWheelEvent.getWheelRotation() < 0) {
                this.magnify(1.0 / Math.pow(2.0, (double)n / 12.0));
            } else {
                this.magnify(Math.pow(2.0, (double)n / 12.0));
            }
        }
    }
}

