/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import rene.gui.ButtonAction;
import rene.gui.DoActionListener;
import rene.gui.IconBar;
import rene.gui.MyLabel;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.dialogs.ObjectEditDialog;
import rene.zirkel.objects.FixedAngleObject;

class FixedAngleEditDialog
extends ObjectEditDialog {
    TextField Length;
    Checkbox Fixed;
    IconBar SizeIB;
    ZirkelCanvas ZC;
    Button SetButton;

    public FixedAngleEditDialog(Frame frame, FixedAngleObject fixedAngleObject, ZirkelCanvas zirkelCanvas) {
        super(frame, Zirkel.name("edit.angle.title"), fixedAngleObject, "fixedangle");
        this.ZC = zirkelCanvas;
    }

    public void addFirst(Panel panel) {
        FixedAngleObject fixedAngleObject = (FixedAngleObject)this.O;
        this.Length = new TextFieldAction((DoActionListener)this, "Length", fixedAngleObject.getE());
        panel.add(new MyLabel(Zirkel.name("edit.angle.length")));
        panel.add(this.Length);
        this.Fixed = new Checkbox("");
        this.Fixed.setState(!fixedAngleObject.isDragable());
        panel.add(new MyLabel(Zirkel.name("edit.fixed")));
        panel.add(this.Fixed);
    }

    public void doAction(String string) {
        if (string.equals("Length") && this.Fixed != null) {
            this.Fixed.setState(true);
            super.doAction("OK");
        } else if (string.equals("Set")) {
            this.ZC.set((FixedAngleObject)this.O);
            super.doAction("OK");
        } else {
            super.doAction(string);
        }
    }

    public void addSecond(Panel panel) {
        FixedAngleObject fixedAngleObject = (FixedAngleObject)this.O;
        this.SizeIB = new IconBar(this.F);
        this.SizeIB.addToggleGroupLeft("angle", 5);
        this.SizeIB.toggle("angle", fixedAngleObject.getDisplaySize());
        this.SizeIB.addOnOffLeft("filled");
        this.SizeIB.setState("filled", fixedAngleObject.isFilled());
        this.SizeIB.addOnOffLeft("obtuse");
        this.SizeIB.setState("obtuse", fixedAngleObject.getObtuse());
        this.SizeIB.addOnOffLeft("inverse");
        this.SizeIB.setState("inverse", fixedAngleObject.getInverse());
        this.SizeIB.addOnOffLeft("anglereduce");
        this.SizeIB.setState("anglereduce", fixedAngleObject.isReduced());
        panel.add(new MyLabel(""));
        panel.add(this.SizeIB);
        this.SizeIB.setIconBarListener(this);
    }

    public void addButton(Panel panel) {
        this.SetButton = new ButtonAction(this, Zirkel.name("edit.fixedangle.set"), "Set");
        panel.add(this.SetButton);
    }

    public void iconPressed(String string) {
        if (string.equals("filled") && this.SizeIB.getState("filled")) {
            this.IB.setState("isback", true);
        }
        super.iconPressed(string);
    }

    public void setAction() {
        FixedAngleObject fixedAngleObject = (FixedAngleObject)this.O;
        fixedAngleObject.setObtuse(this.SizeIB.getState("obtuse"));
        fixedAngleObject.setInverse(this.SizeIB.getState("inverse"));
        fixedAngleObject.setReduced(this.SizeIB.getState("anglereduce"));
        fixedAngleObject.setEditFixed(this.Length.getText());
        fixedAngleObject.setDisplaySize(this.SizeIB.getToggleState("angle"));
        fixedAngleObject.setFilled(this.SizeIB.getState("filled"));
        fixedAngleObject.setDragable(!this.Fixed.getState());
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.Fixed != null && this.Fixed.getState()) {
            this.Length.requestFocus();
        } else {
            super.focusGained(focusEvent);
        }
    }
}

