/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.awt;

import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.InputObject;
import edu.hws.jcm.awt.JCMError;
import edu.hws.jcm.data.Cases;
import edu.hws.jcm.data.Expression;
import edu.hws.jcm.data.ExpressionProgram;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.Parser;
import edu.hws.jcm.data.SimpleFunction;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.data.Variable;
import java.awt.Color;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;

public class ExpressionInput
extends TextField
implements InputObject,
Value {
    protected EI expr = new EI();
    protected Parser parser;
    protected boolean hasChanged;
    protected boolean throwErrors;
    private Controller onUserAction;
    private Controller onTextChange;
    protected String errorMessage;
    private long serialNumber;

    public ExpressionInput() {
        this("", null);
    }

    public ExpressionInput(String string, Parser parser) {
        super(30);
        if (string == null) {
            string = "";
        }
        super.setText(string);
        this.setBackground(Color.white);
        this.enableEvents(8L);
        this.setParser(parser);
        this.checkInput();
        this.throwErrors = true;
    }

    public void setParser(Parser parser) {
        this.parser = parser == null ? new Parser() : parser;
        this.hasChanged = true;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public Function getFunction(Variable variable) {
        return new SimpleFunction((Expression)this.expr, variable);
    }

    public Function getFunction(Variable[] variableArray) {
        return new SimpleFunction((Expression)this.expr, variableArray);
    }

    public double getVal() {
        return this.expr.getVal();
    }

    public void setOnUserAction(Controller controller) {
        this.onUserAction = controller;
        this.enableEvents(128L);
    }

    public Controller getOnUserAction() {
        return this.onUserAction;
    }

    public void notifyControllerOnChange(Controller controller) {
        this.setOnUserAction(controller);
    }

    public void setOnTextChange(Controller controller) {
        this.onTextChange = controller;
        this.enableEvents(1024L);
        if (controller != null) {
            this.throwErrors = false;
        }
    }

    public Controller getOnTextChange() {
        return this.onTextChange;
    }

    public void setThrowErrors(boolean bl) {
        this.throwErrors = bl;
    }

    public boolean getThrowErrors() {
        return this.throwErrors;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void checkInput() {
        if (!this.hasChanged) {
            return;
        }
        ++this.expr.serialNumber;
        String string = this.getText();
        try {
            this.expr.exp = this.parser.parse(string);
            this.errorMessage = null;
            this.hasChanged = false;
        }
        catch (ParseError parseError) {
            this.expr.exp = null;
            if (this.throwErrors) {
                this.errorMessage = "Error in expression: " + parseError.getMessage();
                this.setCaretPosition(parseError.context.pos);
                this.requestFocus();
                throw new JCMError(parseError.getMessage(), this);
            }
            this.errorMessage = "Error in expression at position " + parseError.context.pos + ": " + parseError.getMessage();
        }
    }

    public void setText(String string) {
        super.setText(string);
        this.hasChanged = true;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            boolean bl;
            int n = keyEvent.getKeyCode();
            char c = keyEvent.getKeyChar();
            boolean bl2 = c != '\u0000' && (Character.isDigit(c) || Character.isLetter(c)) || c == '.' || c == '(' || c == ')' || c == '-' || c == '+' || c == '*' || c == '/' || c == '^' || c == ',' || c == ':' || c == '?' || c == '|' || c == '&' || c == '~' || c == '=' || c == '<' || c == '>' || c == '!' || n == 127 || n == 32 || n == 8;
            boolean bl3 = bl = bl2 || n == 9 || n == 10 || c == '\u0000';
            if (!bl) {
                keyEvent.consume();
                Toolkit.getDefaultToolkit().beep();
            } else if (bl2) {
                this.hasChanged = true;
            }
        }
        super.processKeyEvent(keyEvent);
    }

    public void processActionEvent(ActionEvent actionEvent) {
        if (this.onUserAction != null) {
            this.onUserAction.compute();
        }
        super.processActionEvent(actionEvent);
    }

    public void processTextEvent(TextEvent textEvent) {
        if (this.onTextChange != null) {
            this.onTextChange.compute();
        }
        super.processTextEvent(textEvent);
    }

    protected class EI
    implements Expression {
        ExpressionProgram exp;
        EI derivativeOf;
        Variable wrt;
        int serialNumber = -1;

        EI() {
        }

        public double getVal() {
            this.checkForChanges();
            if (this.exp == null) {
                return Double.NaN;
            }
            return this.exp.getVal();
        }

        public double getValueWithCases(Cases cases) {
            this.checkForChanges();
            if (this.exp == null) {
                return Double.NaN;
            }
            return this.exp.getValueWithCases(cases);
        }

        public String toString() {
            this.checkForChanges();
            if (this.exp == null) {
                return "(undefined)";
            }
            return this.exp.toString();
        }

        public Expression derivative(Variable variable) {
            EI eI = new EI();
            eI.derivativeOf = this;
            eI.wrt = variable;
            return eI;
        }

        public boolean dependsOn(Variable variable) {
            this.checkForChanges();
            return this.exp.dependsOn(variable);
        }

        void checkForChanges() {
            if (this.derivativeOf != null) {
                this.derivativeOf.checkForChanges();
                if (this.serialNumber != this.derivativeOf.serialNumber) {
                    this.serialNumber = this.derivativeOf.serialNumber;
                    this.exp = ExpressionInput.this.errorMessage != null ? null : (ExpressionProgram)this.derivativeOf.exp.derivative(this.wrt);
                }
            }
        }
    }
}

