/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.AreaObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;

public class AreaConstructor
extends ObjectConstructor {
    Vector Points = new Vector();

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!zirkelCanvas.Visual) {
            return;
        }
        double d2 = zirkelCanvas.x(mouseEvent.getX());
        double d3 = zirkelCanvas.y(mouseEvent.getY());
        PointObject pointObject = zirkelCanvas.selectCreatePoint(mouseEvent.getX(), mouseEvent.getY());
        if (pointObject != null) {
            pointObject.setSelected(true);
            Enumeration enumeration = this.Points.elements();
            while (enumeration.hasMoreElements()) {
                if (enumeration.nextElement() != pointObject) continue;
                if (this.Points.size() >= 3) {
                    AreaObject areaObject = new AreaObject(zirkelCanvas.getConstruction(), this.Points);
                    zirkelCanvas.addObject(areaObject);
                    areaObject.setDefaults();
                    if (!areaObject.isSolid()) {
                        areaObject.setBack(true);
                    }
                }
                this.reset(zirkelCanvas);
                return;
            }
            this.Points.addElement(pointObject);
            zirkelCanvas.repaint();
        }
    }

    public String getTag() {
        return "Polygon";
    }

    public void construct(Construction construction, String string, String[] stringArray, int n) throws ConstructionException {
        if (n < 3) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        Vector<ConstructionObject> vector = new Vector<ConstructionObject>();
        for (int i = 0; i < n; ++i) {
            ConstructionObject constructionObject = construction.find(stringArray[i]);
            if (constructionObject == null) {
                throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[i]);
            }
            if (!(constructionObject instanceof PointObject)) {
                throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[i]);
            }
            vector.addElement(constructionObject);
        }
        AreaObject areaObject = new AreaObject(construction, vector);
        if (!string.equals("")) {
            areaObject.setNameCheck(string);
        }
        construction.add(areaObject);
        areaObject.setDefaults();
        areaObject.setBack(true);
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        if (!this.testTree(xmlTree, "Polygon")) {
            return false;
        }
        XmlTag xmlTag = xmlTree.getTag();
        try {
            ConstructionObject constructionObject;
            int n = 1;
            Vector<PointObject> vector = new Vector<PointObject>();
            while ((constructionObject = (PointObject)construction.find(xmlTag.getValue("point" + n))) != null) {
                vector.addElement((PointObject)constructionObject);
                ++n;
            }
            constructionObject = new AreaObject(construction, vector);
            constructionObject.setBack(true);
            this.setName(xmlTag, constructionObject);
            this.set(xmlTree, constructionObject);
            construction.add(constructionObject);
            this.setConditionals(xmlTree, construction, constructionObject);
        }
        catch (ConstructionException constructionException) {
            throw constructionException;
        }
        catch (Exception exception) {
            throw new ConstructionException("Polygon parameters illegal!");
        }
        return true;
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        zirkelCanvas.showStatus(Zirkel.name("message.area"));
        zirkelCanvas.setPrompt("=" + Zirkel.name("prompt.area"));
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        super.reset(zirkelCanvas);
        this.Points = new Vector();
        zirkelCanvas.showStatus(Zirkel.name("message.area"));
    }
}

