/* File generated automatically from tools/winapi/tests.dat; do not edit! */
/* This file can be copied, modified and distributed without restriction. */

/*
 * Unit tests for data structure packing
 */

#define WINVER 0x0501
#define _WIN32_IE 0x0501
#define _WIN32_WINNT 0x0501

#define WINE_NOWINSOCK

#include "windef.h"
#include "mmsystem.h"
#include "digitalv.h"

#include "wine/test.h"

/***********************************************************************
 * Compatibility macros
 */

#define DWORD_PTR UINT_PTR
#define LONG_PTR INT_PTR
#define ULONG_PTR UINT_PTR

/***********************************************************************
 * Windows API extension
 */

#if defined(_MSC_VER) && (_MSC_VER >= 1300) && defined(__cplusplus)
# define _TYPE_ALIGNMENT(type) __alignof(type)
#elif defined(__GNUC__)
# define _TYPE_ALIGNMENT(type) __alignof__(type)
#else
/*
 * FIXME: May not be possible without a compiler extension
 *        (if type is not just a name that is, otherwise the normal
 *         TYPE_ALIGNMENT can be used)
 */
#endif

#if defined(TYPE_ALIGNMENT) && defined(_MSC_VER) && _MSC_VER >= 800 && !defined(__cplusplus)
#pragma warning(disable:4116)
#endif

#if !defined(TYPE_ALIGNMENT) && defined(_TYPE_ALIGNMENT)
# define TYPE_ALIGNMENT _TYPE_ALIGNMENT
#endif

/***********************************************************************
 * Test helper macros
 */

#define TEST_TYPE_SIZE(type, size)             C_ASSERT(sizeof(type) == size);

#ifdef TYPE_ALIGNMENT
# define TEST_TYPE_ALIGN(type, align)          C_ASSERT(TYPE_ALIGNMENT(type) == align);
#else
# define TEST_TYPE_ALIGN(type, align)
#endif

#ifdef _TYPE_ALIGNMENT
# define TEST_TARGET_ALIGN(type, align)        C_ASSERT(_TYPE_ALIGNMENT(*(type)0) == align);
# define TEST_FIELD_ALIGN(type, field, align)  C_ASSERT(_TYPE_ALIGNMENT(((type*)0)->field) == align);
#else
# define TEST_TARGET_ALIGN(type, align)
# define TEST_FIELD_ALIGN(type, field, align)
#endif

#define TEST_FIELD_OFFSET(type, field, offset) C_ASSERT(FIELD_OFFSET(type, field) == offset);

#define TEST_TARGET_SIZE(type, size)            TEST_TYPE_SIZE(*(type)0, size)
#define TEST_FIELD_SIZE(type, field, size)      TEST_TYPE_SIZE((((type*)0)->field), size)
#define TEST_TYPE_SIGNED(type)                  C_ASSERT((type) -1 < 0);
#define TEST_TYPE_UNSIGNED(type)                C_ASSERT((type) -1 > 0);


#ifdef _WIN64

static void test_pack_MMTIME(void)
{
    /* MMTIME (pack 1) */
    TEST_FIELD_SIZE  (MMTIME, wType, 4)
    TEST_FIELD_ALIGN (MMTIME, wType, 1)
    TEST_FIELD_OFFSET(MMTIME, wType, 0)
}

static void test_pack_DRVCONFIGINFO(void)
{
    /* DRVCONFIGINFO (pack 1) */
    TEST_TYPE_SIZE   (DRVCONFIGINFO, 20)
    TEST_TYPE_ALIGN  (DRVCONFIGINFO, 1)
    TEST_FIELD_SIZE  (DRVCONFIGINFO, dwDCISize, 4)
    TEST_FIELD_ALIGN (DRVCONFIGINFO, dwDCISize, 1)
    TEST_FIELD_OFFSET(DRVCONFIGINFO, dwDCISize, 0)
    TEST_FIELD_SIZE  (DRVCONFIGINFO, lpszDCISectionName, 8)
    TEST_FIELD_ALIGN (DRVCONFIGINFO, lpszDCISectionName, 1)
    TEST_FIELD_OFFSET(DRVCONFIGINFO, lpszDCISectionName, 4)
    TEST_FIELD_SIZE  (DRVCONFIGINFO, lpszDCIAliasName, 8)
    TEST_FIELD_ALIGN (DRVCONFIGINFO, lpszDCIAliasName, 1)
    TEST_FIELD_OFFSET(DRVCONFIGINFO, lpszDCIAliasName, 12)
}

static void test_pack_WAVEHDR(void)
{
    /* WAVEHDR (pack 1) */
    TEST_TYPE_SIZE   (WAVEHDR, 48)
    TEST_TYPE_ALIGN  (WAVEHDR, 1)
    TEST_FIELD_SIZE  (WAVEHDR, lpData, 8)
    TEST_FIELD_ALIGN (WAVEHDR, lpData, 1)
    TEST_FIELD_OFFSET(WAVEHDR, lpData, 0)
    TEST_FIELD_SIZE  (WAVEHDR, dwBufferLength, 4)
    TEST_FIELD_ALIGN (WAVEHDR, dwBufferLength, 1)
    TEST_FIELD_OFFSET(WAVEHDR, dwBufferLength, 8)
    TEST_FIELD_SIZE  (WAVEHDR, dwBytesRecorded, 4)
    TEST_FIELD_ALIGN (WAVEHDR, dwBytesRecorded, 1)
    TEST_FIELD_OFFSET(WAVEHDR, dwBytesRecorded, 12)
    TEST_FIELD_SIZE  (WAVEHDR, dwUser, 8)
    TEST_FIELD_ALIGN (WAVEHDR, dwUser, 1)
    TEST_FIELD_OFFSET(WAVEHDR, dwUser, 16)
    TEST_FIELD_SIZE  (WAVEHDR, dwFlags, 4)
    TEST_FIELD_ALIGN (WAVEHDR, dwFlags, 1)
    TEST_FIELD_OFFSET(WAVEHDR, dwFlags, 24)
    TEST_FIELD_SIZE  (WAVEHDR, dwLoops, 4)
    TEST_FIELD_ALIGN (WAVEHDR, dwLoops, 1)
    TEST_FIELD_OFFSET(WAVEHDR, dwLoops, 28)
    TEST_FIELD_SIZE  (WAVEHDR, lpNext, 8)
    TEST_FIELD_ALIGN (WAVEHDR, lpNext, 1)
    TEST_FIELD_OFFSET(WAVEHDR, lpNext, 32)
    TEST_FIELD_SIZE  (WAVEHDR, reserved, 8)
    TEST_FIELD_ALIGN (WAVEHDR, reserved, 1)
    TEST_FIELD_OFFSET(WAVEHDR, reserved, 40)
}

static void test_pack_WAVEOUTCAPSA(void)
{
    /* WAVEOUTCAPSA (pack 1) */
    TEST_FIELD_SIZE  (WAVEOUTCAPSA, wMid, 2)
    TEST_FIELD_ALIGN (WAVEOUTCAPSA, wMid, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPSA, wMid, 0)
    TEST_FIELD_SIZE  (WAVEOUTCAPSA, wPid, 2)
    TEST_FIELD_ALIGN (WAVEOUTCAPSA, wPid, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPSA, wPid, 2)
    TEST_FIELD_SIZE  (WAVEOUTCAPSA, vDriverVersion, 4)
    TEST_FIELD_ALIGN (WAVEOUTCAPSA, vDriverVersion, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPSA, vDriverVersion, 4)
}

static void test_pack_WAVEOUTCAPSW(void)
{
    /* WAVEOUTCAPSW (pack 1) */
    TEST_FIELD_SIZE  (WAVEOUTCAPSW, wMid, 2)
    TEST_FIELD_ALIGN (WAVEOUTCAPSW, wMid, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPSW, wMid, 0)
    TEST_FIELD_SIZE  (WAVEOUTCAPSW, wPid, 2)
    TEST_FIELD_ALIGN (WAVEOUTCAPSW, wPid, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPSW, wPid, 2)
    TEST_FIELD_SIZE  (WAVEOUTCAPSW, vDriverVersion, 4)
    TEST_FIELD_ALIGN (WAVEOUTCAPSW, vDriverVersion, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPSW, vDriverVersion, 4)
}

static void test_pack_WAVEOUTCAPS2A(void)
{
    /* WAVEOUTCAPS2A (pack 1) */
    TEST_FIELD_SIZE  (WAVEOUTCAPS2A, wMid, 2)
    TEST_FIELD_ALIGN (WAVEOUTCAPS2A, wMid, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPS2A, wMid, 0)
    TEST_FIELD_SIZE  (WAVEOUTCAPS2A, wPid, 2)
    TEST_FIELD_ALIGN (WAVEOUTCAPS2A, wPid, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPS2A, wPid, 2)
    TEST_FIELD_SIZE  (WAVEOUTCAPS2A, vDriverVersion, 4)
    TEST_FIELD_ALIGN (WAVEOUTCAPS2A, vDriverVersion, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPS2A, vDriverVersion, 4)
}

static void test_pack_WAVEOUTCAPS2W(void)
{
    /* WAVEOUTCAPS2W (pack 1) */
    TEST_FIELD_SIZE  (WAVEOUTCAPS2W, wMid, 2)
    TEST_FIELD_ALIGN (WAVEOUTCAPS2W, wMid, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPS2W, wMid, 0)
    TEST_FIELD_SIZE  (WAVEOUTCAPS2W, wPid, 2)
    TEST_FIELD_ALIGN (WAVEOUTCAPS2W, wPid, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPS2W, wPid, 2)
    TEST_FIELD_SIZE  (WAVEOUTCAPS2W, vDriverVersion, 4)
    TEST_FIELD_ALIGN (WAVEOUTCAPS2W, vDriverVersion, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPS2W, vDriverVersion, 4)
}

static void test_pack_WAVEINCAPSA(void)
{
    /* WAVEINCAPSA (pack 1) */
    TEST_FIELD_SIZE  (WAVEINCAPSA, wMid, 2)
    TEST_FIELD_ALIGN (WAVEINCAPSA, wMid, 1)
    TEST_FIELD_OFFSET(WAVEINCAPSA, wMid, 0)
    TEST_FIELD_SIZE  (WAVEINCAPSA, wPid, 2)
    TEST_FIELD_ALIGN (WAVEINCAPSA, wPid, 1)
    TEST_FIELD_OFFSET(WAVEINCAPSA, wPid, 2)
    TEST_FIELD_SIZE  (WAVEINCAPSA, vDriverVersion, 4)
    TEST_FIELD_ALIGN (WAVEINCAPSA, vDriverVersion, 1)
    TEST_FIELD_OFFSET(WAVEINCAPSA, vDriverVersion, 4)
}

static void test_pack_WAVEINCAPSW(void)
{
    /* WAVEINCAPSW (pack 1) */
    TEST_FIELD_SIZE  (WAVEINCAPSW, wMid, 2)
    TEST_FIELD_ALIGN (WAVEINCAPSW, wMid, 1)
    TEST_FIELD_OFFSET(WAVEINCAPSW, wMid, 0)
    TEST_FIELD_SIZE  (WAVEINCAPSW, wPid, 2)
    TEST_FIELD_ALIGN (WAVEINCAPSW, wPid, 1)
    TEST_FIELD_OFFSET(WAVEINCAPSW, wPid, 2)
    TEST_FIELD_SIZE  (WAVEINCAPSW, vDriverVersion, 4)
    TEST_FIELD_ALIGN (WAVEINCAPSW, vDriverVersion, 1)
    TEST_FIELD_OFFSET(WAVEINCAPSW, vDriverVersion, 4)
}

static void test_pack_WAVEINCAPS2A(void)
{
    /* WAVEINCAPS2A (pack 1) */
    TEST_FIELD_SIZE  (WAVEINCAPS2A, wMid, 2)
    TEST_FIELD_ALIGN (WAVEINCAPS2A, wMid, 1)
    TEST_FIELD_OFFSET(WAVEINCAPS2A, wMid, 0)
    TEST_FIELD_SIZE  (WAVEINCAPS2A, wPid, 2)
    TEST_FIELD_ALIGN (WAVEINCAPS2A, wPid, 1)
    TEST_FIELD_OFFSET(WAVEINCAPS2A, wPid, 2)
    TEST_FIELD_SIZE  (WAVEINCAPS2A, vDriverVersion, 4)
    TEST_FIELD_ALIGN (WAVEINCAPS2A, vDriverVersion, 1)
    TEST_FIELD_OFFSET(WAVEINCAPS2A, vDriverVersion, 4)
}

static void test_pack_WAVEINCAPS2W(void)
{
    /* WAVEINCAPS2W (pack 1) */
    TEST_FIELD_SIZE  (WAVEINCAPS2W, wMid, 2)
    TEST_FIELD_ALIGN (WAVEINCAPS2W, wMid, 1)
    TEST_FIELD_OFFSET(WAVEINCAPS2W, wMid, 0)
    TEST_FIELD_SIZE  (WAVEINCAPS2W, wPid, 2)
    TEST_FIELD_ALIGN (WAVEINCAPS2W, wPid, 1)
    TEST_FIELD_OFFSET(WAVEINCAPS2W, wPid, 2)
    TEST_FIELD_SIZE  (WAVEINCAPS2W, vDriverVersion, 4)
    TEST_FIELD_ALIGN (WAVEINCAPS2W, vDriverVersion, 1)
    TEST_FIELD_OFFSET(WAVEINCAPS2W, vDriverVersion, 4)
}

static void test_pack_WAVEFORMAT(void)
{
    /* WAVEFORMAT (pack 1) */
    TEST_TYPE_SIZE   (WAVEFORMAT, 14)
    TEST_TYPE_ALIGN  (WAVEFORMAT, 1)
    TEST_FIELD_SIZE  (WAVEFORMAT, wFormatTag, 2)
    TEST_FIELD_ALIGN (WAVEFORMAT, wFormatTag, 1)
    TEST_FIELD_OFFSET(WAVEFORMAT, wFormatTag, 0)
    TEST_FIELD_SIZE  (WAVEFORMAT, nChannels, 2)
    TEST_FIELD_ALIGN (WAVEFORMAT, nChannels, 1)
    TEST_FIELD_OFFSET(WAVEFORMAT, nChannels, 2)
    TEST_FIELD_SIZE  (WAVEFORMAT, nSamplesPerSec, 4)
    TEST_FIELD_ALIGN (WAVEFORMAT, nSamplesPerSec, 1)
    TEST_FIELD_OFFSET(WAVEFORMAT, nSamplesPerSec, 4)
    TEST_FIELD_SIZE  (WAVEFORMAT, nAvgBytesPerSec, 4)
    TEST_FIELD_ALIGN (WAVEFORMAT, nAvgBytesPerSec, 1)
    TEST_FIELD_OFFSET(WAVEFORMAT, nAvgBytesPerSec, 8)
    TEST_FIELD_SIZE  (WAVEFORMAT, nBlockAlign, 2)
    TEST_FIELD_ALIGN (WAVEFORMAT, nBlockAlign, 1)
    TEST_FIELD_OFFSET(WAVEFORMAT, nBlockAlign, 12)
}

static void test_pack_PCMWAVEFORMAT(void)
{
    /* PCMWAVEFORMAT (pack 1) */
    TEST_TYPE_SIZE   (PCMWAVEFORMAT, 16)
    TEST_TYPE_ALIGN  (PCMWAVEFORMAT, 1)
    TEST_FIELD_SIZE  (PCMWAVEFORMAT, wf, 14)
    TEST_FIELD_ALIGN (PCMWAVEFORMAT, wf, 1)
    TEST_FIELD_OFFSET(PCMWAVEFORMAT, wf, 0)
    TEST_FIELD_SIZE  (PCMWAVEFORMAT, wBitsPerSample, 2)
    TEST_FIELD_ALIGN (PCMWAVEFORMAT, wBitsPerSample, 1)
    TEST_FIELD_OFFSET(PCMWAVEFORMAT, wBitsPerSample, 14)
}

static void test_pack_WAVEFORMATEX(void)
{
    /* WAVEFORMATEX (pack 1) */
    TEST_TYPE_SIZE   (WAVEFORMATEX, 18)
    TEST_TYPE_ALIGN  (WAVEFORMATEX, 1)
    TEST_FIELD_SIZE  (WAVEFORMATEX, wFormatTag, 2)
    TEST_FIELD_ALIGN (WAVEFORMATEX, wFormatTag, 1)
    TEST_FIELD_OFFSET(WAVEFORMATEX, wFormatTag, 0)
    TEST_FIELD_SIZE  (WAVEFORMATEX, nChannels, 2)
    TEST_FIELD_ALIGN (WAVEFORMATEX, nChannels, 1)
    TEST_FIELD_OFFSET(WAVEFORMATEX, nChannels, 2)
    TEST_FIELD_SIZE  (WAVEFORMATEX, nSamplesPerSec, 4)
    TEST_FIELD_ALIGN (WAVEFORMATEX, nSamplesPerSec, 1)
    TEST_FIELD_OFFSET(WAVEFORMATEX, nSamplesPerSec, 4)
    TEST_FIELD_SIZE  (WAVEFORMATEX, nAvgBytesPerSec, 4)
    TEST_FIELD_ALIGN (WAVEFORMATEX, nAvgBytesPerSec, 1)
    TEST_FIELD_OFFSET(WAVEFORMATEX, nAvgBytesPerSec, 8)
    TEST_FIELD_SIZE  (WAVEFORMATEX, nBlockAlign, 2)
    TEST_FIELD_ALIGN (WAVEFORMATEX, nBlockAlign, 1)
    TEST_FIELD_OFFSET(WAVEFORMATEX, nBlockAlign, 12)
    TEST_FIELD_SIZE  (WAVEFORMATEX, wBitsPerSample, 2)
    TEST_FIELD_ALIGN (WAVEFORMATEX, wBitsPerSample, 1)
    TEST_FIELD_OFFSET(WAVEFORMATEX, wBitsPerSample, 14)
    TEST_FIELD_SIZE  (WAVEFORMATEX, cbSize, 2)
    TEST_FIELD_ALIGN (WAVEFORMATEX, cbSize, 1)
    TEST_FIELD_OFFSET(WAVEFORMATEX, cbSize, 16)
}

static void test_pack_MIDIOUTCAPSA(void)
{
    /* MIDIOUTCAPSA (pack 1) */
    TEST_FIELD_SIZE  (MIDIOUTCAPSA, wMid, 2)
    TEST_FIELD_ALIGN (MIDIOUTCAPSA, wMid, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPSA, wMid, 0)
    TEST_FIELD_SIZE  (MIDIOUTCAPSA, wPid, 2)
    TEST_FIELD_ALIGN (MIDIOUTCAPSA, wPid, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPSA, wPid, 2)
    TEST_FIELD_SIZE  (MIDIOUTCAPSA, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIDIOUTCAPSA, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPSA, vDriverVersion, 4)
}

static void test_pack_MIDIOUTCAPSW(void)
{
    /* MIDIOUTCAPSW (pack 1) */
    TEST_FIELD_SIZE  (MIDIOUTCAPSW, wMid, 2)
    TEST_FIELD_ALIGN (MIDIOUTCAPSW, wMid, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPSW, wMid, 0)
    TEST_FIELD_SIZE  (MIDIOUTCAPSW, wPid, 2)
    TEST_FIELD_ALIGN (MIDIOUTCAPSW, wPid, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPSW, wPid, 2)
    TEST_FIELD_SIZE  (MIDIOUTCAPSW, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIDIOUTCAPSW, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPSW, vDriverVersion, 4)
}

static void test_pack_MIDIOUTCAPS2A(void)
{
    /* MIDIOUTCAPS2A (pack 1) */
    TEST_FIELD_SIZE  (MIDIOUTCAPS2A, wMid, 2)
    TEST_FIELD_ALIGN (MIDIOUTCAPS2A, wMid, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPS2A, wMid, 0)
    TEST_FIELD_SIZE  (MIDIOUTCAPS2A, wPid, 2)
    TEST_FIELD_ALIGN (MIDIOUTCAPS2A, wPid, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPS2A, wPid, 2)
    TEST_FIELD_SIZE  (MIDIOUTCAPS2A, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIDIOUTCAPS2A, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPS2A, vDriverVersion, 4)
}

static void test_pack_MIDIOUTCAPS2W(void)
{
    /* MIDIOUTCAPS2W (pack 1) */
    TEST_FIELD_SIZE  (MIDIOUTCAPS2W, wMid, 2)
    TEST_FIELD_ALIGN (MIDIOUTCAPS2W, wMid, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPS2W, wMid, 0)
    TEST_FIELD_SIZE  (MIDIOUTCAPS2W, wPid, 2)
    TEST_FIELD_ALIGN (MIDIOUTCAPS2W, wPid, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPS2W, wPid, 2)
    TEST_FIELD_SIZE  (MIDIOUTCAPS2W, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIDIOUTCAPS2W, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPS2W, vDriverVersion, 4)
}

static void test_pack_MIDIINCAPSA(void)
{
    /* MIDIINCAPSA (pack 1) */
    TEST_FIELD_SIZE  (MIDIINCAPSA, wMid, 2)
    TEST_FIELD_ALIGN (MIDIINCAPSA, wMid, 1)
    TEST_FIELD_OFFSET(MIDIINCAPSA, wMid, 0)
    TEST_FIELD_SIZE  (MIDIINCAPSA, wPid, 2)
    TEST_FIELD_ALIGN (MIDIINCAPSA, wPid, 1)
    TEST_FIELD_OFFSET(MIDIINCAPSA, wPid, 2)
    TEST_FIELD_SIZE  (MIDIINCAPSA, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIDIINCAPSA, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIDIINCAPSA, vDriverVersion, 4)
}

static void test_pack_MIDIINCAPSW(void)
{
    /* MIDIINCAPSW (pack 1) */
    TEST_FIELD_SIZE  (MIDIINCAPSW, wMid, 2)
    TEST_FIELD_ALIGN (MIDIINCAPSW, wMid, 1)
    TEST_FIELD_OFFSET(MIDIINCAPSW, wMid, 0)
    TEST_FIELD_SIZE  (MIDIINCAPSW, wPid, 2)
    TEST_FIELD_ALIGN (MIDIINCAPSW, wPid, 1)
    TEST_FIELD_OFFSET(MIDIINCAPSW, wPid, 2)
    TEST_FIELD_SIZE  (MIDIINCAPSW, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIDIINCAPSW, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIDIINCAPSW, vDriverVersion, 4)
}

static void test_pack_MIDIINCAPS2A(void)
{
    /* MIDIINCAPS2A (pack 1) */
    TEST_FIELD_SIZE  (MIDIINCAPS2A, wMid, 2)
    TEST_FIELD_ALIGN (MIDIINCAPS2A, wMid, 1)
    TEST_FIELD_OFFSET(MIDIINCAPS2A, wMid, 0)
    TEST_FIELD_SIZE  (MIDIINCAPS2A, wPid, 2)
    TEST_FIELD_ALIGN (MIDIINCAPS2A, wPid, 1)
    TEST_FIELD_OFFSET(MIDIINCAPS2A, wPid, 2)
    TEST_FIELD_SIZE  (MIDIINCAPS2A, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIDIINCAPS2A, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIDIINCAPS2A, vDriverVersion, 4)
}

static void test_pack_MIDIINCAPS2W(void)
{
    /* MIDIINCAPS2W (pack 1) */
    TEST_FIELD_SIZE  (MIDIINCAPS2W, wMid, 2)
    TEST_FIELD_ALIGN (MIDIINCAPS2W, wMid, 1)
    TEST_FIELD_OFFSET(MIDIINCAPS2W, wMid, 0)
    TEST_FIELD_SIZE  (MIDIINCAPS2W, wPid, 2)
    TEST_FIELD_ALIGN (MIDIINCAPS2W, wPid, 1)
    TEST_FIELD_OFFSET(MIDIINCAPS2W, wPid, 2)
    TEST_FIELD_SIZE  (MIDIINCAPS2W, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIDIINCAPS2W, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIDIINCAPS2W, vDriverVersion, 4)
}

static void test_pack_MIDIHDR(void)
{
    /* MIDIHDR (pack 1) */
    TEST_TYPE_SIZE   (MIDIHDR, 112)
    TEST_TYPE_ALIGN  (MIDIHDR, 1)
    TEST_FIELD_SIZE  (MIDIHDR, lpData, 8)
    TEST_FIELD_ALIGN (MIDIHDR, lpData, 1)
    TEST_FIELD_OFFSET(MIDIHDR, lpData, 0)
    TEST_FIELD_SIZE  (MIDIHDR, dwBufferLength, 4)
    TEST_FIELD_ALIGN (MIDIHDR, dwBufferLength, 1)
    TEST_FIELD_OFFSET(MIDIHDR, dwBufferLength, 8)
    TEST_FIELD_SIZE  (MIDIHDR, dwBytesRecorded, 4)
    TEST_FIELD_ALIGN (MIDIHDR, dwBytesRecorded, 1)
    TEST_FIELD_OFFSET(MIDIHDR, dwBytesRecorded, 12)
    TEST_FIELD_SIZE  (MIDIHDR, dwUser, 8)
    TEST_FIELD_ALIGN (MIDIHDR, dwUser, 1)
    TEST_FIELD_OFFSET(MIDIHDR, dwUser, 16)
    TEST_FIELD_SIZE  (MIDIHDR, dwFlags, 4)
    TEST_FIELD_ALIGN (MIDIHDR, dwFlags, 1)
    TEST_FIELD_OFFSET(MIDIHDR, dwFlags, 24)
    TEST_FIELD_SIZE  (MIDIHDR, lpNext, 8)
    TEST_FIELD_ALIGN (MIDIHDR, lpNext, 1)
    TEST_FIELD_OFFSET(MIDIHDR, lpNext, 28)
    TEST_FIELD_SIZE  (MIDIHDR, reserved, 8)
    TEST_FIELD_ALIGN (MIDIHDR, reserved, 1)
    TEST_FIELD_OFFSET(MIDIHDR, reserved, 36)
    TEST_FIELD_SIZE  (MIDIHDR, dwOffset, 4)
    TEST_FIELD_ALIGN (MIDIHDR, dwOffset, 1)
    TEST_FIELD_OFFSET(MIDIHDR, dwOffset, 44)
    TEST_FIELD_SIZE  (MIDIHDR, dwReserved, 64)
    TEST_FIELD_ALIGN (MIDIHDR, dwReserved, 1)
    TEST_FIELD_OFFSET(MIDIHDR, dwReserved, 48)
}

static void test_pack_MIDIEVENT(void)
{
    /* MIDIEVENT (pack 1) */
    TEST_TYPE_SIZE   (MIDIEVENT, 16)
    TEST_TYPE_ALIGN  (MIDIEVENT, 1)
    TEST_FIELD_SIZE  (MIDIEVENT, dwDeltaTime, 4)
    TEST_FIELD_ALIGN (MIDIEVENT, dwDeltaTime, 1)
    TEST_FIELD_OFFSET(MIDIEVENT, dwDeltaTime, 0)
    TEST_FIELD_SIZE  (MIDIEVENT, dwStreamID, 4)
    TEST_FIELD_ALIGN (MIDIEVENT, dwStreamID, 1)
    TEST_FIELD_OFFSET(MIDIEVENT, dwStreamID, 4)
    TEST_FIELD_SIZE  (MIDIEVENT, dwEvent, 4)
    TEST_FIELD_ALIGN (MIDIEVENT, dwEvent, 1)
    TEST_FIELD_OFFSET(MIDIEVENT, dwEvent, 8)
    TEST_FIELD_SIZE  (MIDIEVENT, dwParms, 4)
    TEST_FIELD_ALIGN (MIDIEVENT, dwParms, 1)
    TEST_FIELD_OFFSET(MIDIEVENT, dwParms, 12)
}

static void test_pack_AUXCAPSA(void)
{
    /* AUXCAPSA (pack 1) */
    TEST_FIELD_SIZE  (AUXCAPSA, wMid, 2)
    TEST_FIELD_ALIGN (AUXCAPSA, wMid, 1)
    TEST_FIELD_OFFSET(AUXCAPSA, wMid, 0)
    TEST_FIELD_SIZE  (AUXCAPSA, wPid, 2)
    TEST_FIELD_ALIGN (AUXCAPSA, wPid, 1)
    TEST_FIELD_OFFSET(AUXCAPSA, wPid, 2)
    TEST_FIELD_SIZE  (AUXCAPSA, vDriverVersion, 4)
    TEST_FIELD_ALIGN (AUXCAPSA, vDriverVersion, 1)
    TEST_FIELD_OFFSET(AUXCAPSA, vDriverVersion, 4)
}

static void test_pack_AUXCAPSW(void)
{
    /* AUXCAPSW (pack 1) */
    TEST_FIELD_SIZE  (AUXCAPSW, wMid, 2)
    TEST_FIELD_ALIGN (AUXCAPSW, wMid, 1)
    TEST_FIELD_OFFSET(AUXCAPSW, wMid, 0)
    TEST_FIELD_SIZE  (AUXCAPSW, wPid, 2)
    TEST_FIELD_ALIGN (AUXCAPSW, wPid, 1)
    TEST_FIELD_OFFSET(AUXCAPSW, wPid, 2)
    TEST_FIELD_SIZE  (AUXCAPSW, vDriverVersion, 4)
    TEST_FIELD_ALIGN (AUXCAPSW, vDriverVersion, 1)
    TEST_FIELD_OFFSET(AUXCAPSW, vDriverVersion, 4)
}

static void test_pack_AUXCAPS2A(void)
{
    /* AUXCAPS2A (pack 1) */
    TEST_FIELD_SIZE  (AUXCAPS2A, wMid, 2)
    TEST_FIELD_ALIGN (AUXCAPS2A, wMid, 1)
    TEST_FIELD_OFFSET(AUXCAPS2A, wMid, 0)
    TEST_FIELD_SIZE  (AUXCAPS2A, wPid, 2)
    TEST_FIELD_ALIGN (AUXCAPS2A, wPid, 1)
    TEST_FIELD_OFFSET(AUXCAPS2A, wPid, 2)
    TEST_FIELD_SIZE  (AUXCAPS2A, vDriverVersion, 4)
    TEST_FIELD_ALIGN (AUXCAPS2A, vDriverVersion, 1)
    TEST_FIELD_OFFSET(AUXCAPS2A, vDriverVersion, 4)
}

static void test_pack_AUXCAPS2W(void)
{
    /* AUXCAPS2W (pack 1) */
    TEST_FIELD_SIZE  (AUXCAPS2W, wMid, 2)
    TEST_FIELD_ALIGN (AUXCAPS2W, wMid, 1)
    TEST_FIELD_OFFSET(AUXCAPS2W, wMid, 0)
    TEST_FIELD_SIZE  (AUXCAPS2W, wPid, 2)
    TEST_FIELD_ALIGN (AUXCAPS2W, wPid, 1)
    TEST_FIELD_OFFSET(AUXCAPS2W, wPid, 2)
    TEST_FIELD_SIZE  (AUXCAPS2W, vDriverVersion, 4)
    TEST_FIELD_ALIGN (AUXCAPS2W, vDriverVersion, 1)
    TEST_FIELD_OFFSET(AUXCAPS2W, vDriverVersion, 4)
}

static void test_pack_TIMECAPS(void)
{
    /* TIMECAPS (pack 1) */
    TEST_TYPE_SIZE   (TIMECAPS, 8)
    TEST_TYPE_ALIGN  (TIMECAPS, 1)
    TEST_FIELD_SIZE  (TIMECAPS, wPeriodMin, 4)
    TEST_FIELD_ALIGN (TIMECAPS, wPeriodMin, 1)
    TEST_FIELD_OFFSET(TIMECAPS, wPeriodMin, 0)
    TEST_FIELD_SIZE  (TIMECAPS, wPeriodMax, 4)
    TEST_FIELD_ALIGN (TIMECAPS, wPeriodMax, 1)
    TEST_FIELD_OFFSET(TIMECAPS, wPeriodMax, 4)
}

static void test_pack_JOYCAPSA(void)
{
    /* JOYCAPSA (pack 1) */
    TEST_FIELD_SIZE  (JOYCAPSA, wMid, 2)
    TEST_FIELD_ALIGN (JOYCAPSA, wMid, 1)
    TEST_FIELD_OFFSET(JOYCAPSA, wMid, 0)
    TEST_FIELD_SIZE  (JOYCAPSA, wPid, 2)
    TEST_FIELD_ALIGN (JOYCAPSA, wPid, 1)
    TEST_FIELD_OFFSET(JOYCAPSA, wPid, 2)
}

static void test_pack_JOYCAPSW(void)
{
    /* JOYCAPSW (pack 1) */
    TEST_FIELD_SIZE  (JOYCAPSW, wMid, 2)
    TEST_FIELD_ALIGN (JOYCAPSW, wMid, 1)
    TEST_FIELD_OFFSET(JOYCAPSW, wMid, 0)
    TEST_FIELD_SIZE  (JOYCAPSW, wPid, 2)
    TEST_FIELD_ALIGN (JOYCAPSW, wPid, 1)
    TEST_FIELD_OFFSET(JOYCAPSW, wPid, 2)
}

static void test_pack_JOYCAPS2A(void)
{
    /* JOYCAPS2A (pack 1) */
    TEST_FIELD_SIZE  (JOYCAPS2A, wMid, 2)
    TEST_FIELD_ALIGN (JOYCAPS2A, wMid, 1)
    TEST_FIELD_OFFSET(JOYCAPS2A, wMid, 0)
    TEST_FIELD_SIZE  (JOYCAPS2A, wPid, 2)
    TEST_FIELD_ALIGN (JOYCAPS2A, wPid, 1)
    TEST_FIELD_OFFSET(JOYCAPS2A, wPid, 2)
}

static void test_pack_JOYCAPS2W(void)
{
    /* JOYCAPS2W (pack 1) */
    TEST_FIELD_SIZE  (JOYCAPS2W, wMid, 2)
    TEST_FIELD_ALIGN (JOYCAPS2W, wMid, 1)
    TEST_FIELD_OFFSET(JOYCAPS2W, wMid, 0)
    TEST_FIELD_SIZE  (JOYCAPS2W, wPid, 2)
    TEST_FIELD_ALIGN (JOYCAPS2W, wPid, 1)
    TEST_FIELD_OFFSET(JOYCAPS2W, wPid, 2)
}

static void test_pack_JOYINFO(void)
{
    /* JOYINFO (pack 1) */
    TEST_TYPE_SIZE   (JOYINFO, 16)
    TEST_TYPE_ALIGN  (JOYINFO, 1)
    TEST_FIELD_SIZE  (JOYINFO, wXpos, 4)
    TEST_FIELD_ALIGN (JOYINFO, wXpos, 1)
    TEST_FIELD_OFFSET(JOYINFO, wXpos, 0)
    TEST_FIELD_SIZE  (JOYINFO, wYpos, 4)
    TEST_FIELD_ALIGN (JOYINFO, wYpos, 1)
    TEST_FIELD_OFFSET(JOYINFO, wYpos, 4)
    TEST_FIELD_SIZE  (JOYINFO, wZpos, 4)
    TEST_FIELD_ALIGN (JOYINFO, wZpos, 1)
    TEST_FIELD_OFFSET(JOYINFO, wZpos, 8)
    TEST_FIELD_SIZE  (JOYINFO, wButtons, 4)
    TEST_FIELD_ALIGN (JOYINFO, wButtons, 1)
    TEST_FIELD_OFFSET(JOYINFO, wButtons, 12)
}

static void test_pack_JOYINFOEX(void)
{
    /* JOYINFOEX (pack 1) */
    TEST_TYPE_SIZE   (JOYINFOEX, 52)
    TEST_TYPE_ALIGN  (JOYINFOEX, 1)
    TEST_FIELD_SIZE  (JOYINFOEX, dwSize, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwSize, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwSize, 0)
    TEST_FIELD_SIZE  (JOYINFOEX, dwFlags, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwFlags, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwFlags, 4)
    TEST_FIELD_SIZE  (JOYINFOEX, dwXpos, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwXpos, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwXpos, 8)
    TEST_FIELD_SIZE  (JOYINFOEX, dwYpos, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwYpos, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwYpos, 12)
    TEST_FIELD_SIZE  (JOYINFOEX, dwZpos, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwZpos, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwZpos, 16)
    TEST_FIELD_SIZE  (JOYINFOEX, dwRpos, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwRpos, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwRpos, 20)
    TEST_FIELD_SIZE  (JOYINFOEX, dwUpos, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwUpos, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwUpos, 24)
    TEST_FIELD_SIZE  (JOYINFOEX, dwVpos, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwVpos, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwVpos, 28)
    TEST_FIELD_SIZE  (JOYINFOEX, dwButtons, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwButtons, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwButtons, 32)
    TEST_FIELD_SIZE  (JOYINFOEX, dwButtonNumber, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwButtonNumber, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwButtonNumber, 36)
    TEST_FIELD_SIZE  (JOYINFOEX, dwPOV, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwPOV, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwPOV, 40)
    TEST_FIELD_SIZE  (JOYINFOEX, dwReserved1, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwReserved1, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwReserved1, 44)
    TEST_FIELD_SIZE  (JOYINFOEX, dwReserved2, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwReserved2, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwReserved2, 48)
}

static void test_pack_MIXERCAPSA(void)
{
    /* MIXERCAPSA (pack 1) */
    TEST_FIELD_SIZE  (MIXERCAPSA, wMid, 2)
    TEST_FIELD_ALIGN (MIXERCAPSA, wMid, 1)
    TEST_FIELD_OFFSET(MIXERCAPSA, wMid, 0)
    TEST_FIELD_SIZE  (MIXERCAPSA, wPid, 2)
    TEST_FIELD_ALIGN (MIXERCAPSA, wPid, 1)
    TEST_FIELD_OFFSET(MIXERCAPSA, wPid, 2)
    TEST_FIELD_SIZE  (MIXERCAPSA, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIXERCAPSA, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIXERCAPSA, vDriverVersion, 4)
}

static void test_pack_MIXERCAPSW(void)
{
    /* MIXERCAPSW (pack 1) */
    TEST_FIELD_SIZE  (MIXERCAPSW, wMid, 2)
    TEST_FIELD_ALIGN (MIXERCAPSW, wMid, 1)
    TEST_FIELD_OFFSET(MIXERCAPSW, wMid, 0)
    TEST_FIELD_SIZE  (MIXERCAPSW, wPid, 2)
    TEST_FIELD_ALIGN (MIXERCAPSW, wPid, 1)
    TEST_FIELD_OFFSET(MIXERCAPSW, wPid, 2)
    TEST_FIELD_SIZE  (MIXERCAPSW, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIXERCAPSW, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIXERCAPSW, vDriverVersion, 4)
}

static void test_pack_MIXERCAPS2A(void)
{
    /* MIXERCAPS2A (pack 1) */
    TEST_FIELD_SIZE  (MIXERCAPS2A, wMid, 2)
    TEST_FIELD_ALIGN (MIXERCAPS2A, wMid, 1)
    TEST_FIELD_OFFSET(MIXERCAPS2A, wMid, 0)
    TEST_FIELD_SIZE  (MIXERCAPS2A, wPid, 2)
    TEST_FIELD_ALIGN (MIXERCAPS2A, wPid, 1)
    TEST_FIELD_OFFSET(MIXERCAPS2A, wPid, 2)
    TEST_FIELD_SIZE  (MIXERCAPS2A, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIXERCAPS2A, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIXERCAPS2A, vDriverVersion, 4)
}

static void test_pack_MIXERCAPS2W(void)
{
    /* MIXERCAPS2W (pack 1) */
    TEST_FIELD_SIZE  (MIXERCAPS2W, wMid, 2)
    TEST_FIELD_ALIGN (MIXERCAPS2W, wMid, 1)
    TEST_FIELD_OFFSET(MIXERCAPS2W, wMid, 0)
    TEST_FIELD_SIZE  (MIXERCAPS2W, wPid, 2)
    TEST_FIELD_ALIGN (MIXERCAPS2W, wPid, 1)
    TEST_FIELD_OFFSET(MIXERCAPS2W, wPid, 2)
    TEST_FIELD_SIZE  (MIXERCAPS2W, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIXERCAPS2W, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIXERCAPS2W, vDriverVersion, 4)
}

static void test_pack_MIXERLINEA(void)
{
    /* MIXERLINEA (pack 1) */
    TEST_FIELD_SIZE  (MIXERLINEA, cbStruct, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, cbStruct, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, cbStruct, 0)
    TEST_FIELD_SIZE  (MIXERLINEA, dwDestination, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, dwDestination, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, dwDestination, 4)
    TEST_FIELD_SIZE  (MIXERLINEA, dwSource, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, dwSource, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, dwSource, 8)
    TEST_FIELD_SIZE  (MIXERLINEA, dwLineID, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, dwLineID, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, dwLineID, 12)
    TEST_FIELD_SIZE  (MIXERLINEA, fdwLine, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, fdwLine, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, fdwLine, 16)
    TEST_FIELD_SIZE  (MIXERLINEA, dwUser, 8)
    TEST_FIELD_ALIGN (MIXERLINEA, dwUser, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, dwUser, 20)
    TEST_FIELD_SIZE  (MIXERLINEA, dwComponentType, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, dwComponentType, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, dwComponentType, 28)
    TEST_FIELD_SIZE  (MIXERLINEA, cChannels, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, cChannels, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, cChannels, 32)
    TEST_FIELD_SIZE  (MIXERLINEA, cConnections, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, cConnections, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, cConnections, 36)
    TEST_FIELD_SIZE  (MIXERLINEA, cControls, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, cControls, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, cControls, 40)
}

static void test_pack_MIXERLINEW(void)
{
    /* MIXERLINEW (pack 1) */
    TEST_FIELD_SIZE  (MIXERLINEW, cbStruct, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, cbStruct, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, cbStruct, 0)
    TEST_FIELD_SIZE  (MIXERLINEW, dwDestination, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, dwDestination, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, dwDestination, 4)
    TEST_FIELD_SIZE  (MIXERLINEW, dwSource, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, dwSource, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, dwSource, 8)
    TEST_FIELD_SIZE  (MIXERLINEW, dwLineID, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, dwLineID, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, dwLineID, 12)
    TEST_FIELD_SIZE  (MIXERLINEW, fdwLine, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, fdwLine, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, fdwLine, 16)
    TEST_FIELD_SIZE  (MIXERLINEW, dwUser, 8)
    TEST_FIELD_ALIGN (MIXERLINEW, dwUser, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, dwUser, 20)
    TEST_FIELD_SIZE  (MIXERLINEW, dwComponentType, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, dwComponentType, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, dwComponentType, 28)
    TEST_FIELD_SIZE  (MIXERLINEW, cChannels, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, cChannels, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, cChannels, 32)
    TEST_FIELD_SIZE  (MIXERLINEW, cConnections, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, cConnections, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, cConnections, 36)
    TEST_FIELD_SIZE  (MIXERLINEW, cControls, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, cControls, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, cControls, 40)
}

static void test_pack_MIXERCONTROLA(void)
{
    /* MIXERCONTROLA (pack 1) */
    TEST_FIELD_SIZE  (MIXERCONTROLA, cbStruct, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLA, cbStruct, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLA, cbStruct, 0)
    TEST_FIELD_SIZE  (MIXERCONTROLA, dwControlID, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLA, dwControlID, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLA, dwControlID, 4)
    TEST_FIELD_SIZE  (MIXERCONTROLA, dwControlType, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLA, dwControlType, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLA, dwControlType, 8)
    TEST_FIELD_SIZE  (MIXERCONTROLA, fdwControl, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLA, fdwControl, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLA, fdwControl, 12)
    TEST_FIELD_SIZE  (MIXERCONTROLA, cMultipleItems, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLA, cMultipleItems, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLA, cMultipleItems, 16)
}

static void test_pack_MIXERCONTROLW(void)
{
    /* MIXERCONTROLW (pack 1) */
    TEST_FIELD_SIZE  (MIXERCONTROLW, cbStruct, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLW, cbStruct, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLW, cbStruct, 0)
    TEST_FIELD_SIZE  (MIXERCONTROLW, dwControlID, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLW, dwControlID, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLW, dwControlID, 4)
    TEST_FIELD_SIZE  (MIXERCONTROLW, dwControlType, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLW, dwControlType, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLW, dwControlType, 8)
    TEST_FIELD_SIZE  (MIXERCONTROLW, fdwControl, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLW, fdwControl, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLW, fdwControl, 12)
    TEST_FIELD_SIZE  (MIXERCONTROLW, cMultipleItems, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLW, cMultipleItems, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLW, cMultipleItems, 16)
}

static void test_pack_MIXERCONTROLDETAILS(void)
{
    /* MIXERCONTROLDETAILS (pack 1) */
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS, cbStruct, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS, cbStruct, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS, cbStruct, 0)
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS, dwControlID, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS, dwControlID, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS, dwControlID, 4)
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS, cChannels, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS, cChannels, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS, cChannels, 8)
}

static void test_pack_MIXERCONTROLDETAILS_LISTTEXTA(void)
{
    /* MIXERCONTROLDETAILS_LISTTEXTA (pack 1) */
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS_LISTTEXTA, dwParam1, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS_LISTTEXTA, dwParam1, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS_LISTTEXTA, dwParam1, 0)
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS_LISTTEXTA, dwParam2, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS_LISTTEXTA, dwParam2, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS_LISTTEXTA, dwParam2, 4)
}

static void test_pack_MIXERCONTROLDETAILS_LISTTEXTW(void)
{
    /* MIXERCONTROLDETAILS_LISTTEXTW (pack 1) */
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS_LISTTEXTW, dwParam1, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS_LISTTEXTW, dwParam1, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS_LISTTEXTW, dwParam1, 0)
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS_LISTTEXTW, dwParam2, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS_LISTTEXTW, dwParam2, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS_LISTTEXTW, dwParam2, 4)
}

static void test_pack_MIXERCONTROLDETAILS_BOOLEAN(void)
{
    /* MIXERCONTROLDETAILS_BOOLEAN (pack 1) */
    TEST_TYPE_SIZE   (MIXERCONTROLDETAILS_BOOLEAN, 4)
    TEST_TYPE_ALIGN  (MIXERCONTROLDETAILS_BOOLEAN, 1)
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS_BOOLEAN, fValue, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS_BOOLEAN, fValue, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS_BOOLEAN, fValue, 0)
}

static void test_pack_MIXERCONTROLDETAILS_SIGNED(void)
{
    /* MIXERCONTROLDETAILS_SIGNED (pack 1) */
    TEST_TYPE_SIZE   (MIXERCONTROLDETAILS_SIGNED, 4)
    TEST_TYPE_ALIGN  (MIXERCONTROLDETAILS_SIGNED, 1)
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS_SIGNED, lValue, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS_SIGNED, lValue, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS_SIGNED, lValue, 0)
}

static void test_pack_MIXERCONTROLDETAILS_UNSIGNED(void)
{
    /* MIXERCONTROLDETAILS_UNSIGNED (pack 1) */
    TEST_TYPE_SIZE   (MIXERCONTROLDETAILS_UNSIGNED, 4)
    TEST_TYPE_ALIGN  (MIXERCONTROLDETAILS_UNSIGNED, 1)
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS_UNSIGNED, dwValue, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS_UNSIGNED, dwValue, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS_UNSIGNED, dwValue, 0)
}

static void test_pack_MMIOINFO(void)
{
    /* MMIOINFO (pack 1) */
    TEST_FIELD_SIZE  (MMIOINFO, dwFlags, 4)
    TEST_FIELD_ALIGN (MMIOINFO, dwFlags, 1)
    TEST_FIELD_OFFSET(MMIOINFO, dwFlags, 0)
    TEST_FIELD_SIZE  (MMIOINFO, fccIOProc, 4)
    TEST_FIELD_ALIGN (MMIOINFO, fccIOProc, 1)
    TEST_FIELD_OFFSET(MMIOINFO, fccIOProc, 4)
    TEST_FIELD_SIZE  (MMIOINFO, pIOProc, 8)
    TEST_FIELD_ALIGN (MMIOINFO, pIOProc, 1)
    TEST_FIELD_OFFSET(MMIOINFO, pIOProc, 8)
    TEST_FIELD_SIZE  (MMIOINFO, wErrorRet, 4)
    TEST_FIELD_ALIGN (MMIOINFO, wErrorRet, 1)
    TEST_FIELD_OFFSET(MMIOINFO, wErrorRet, 16)
}

static void test_pack_MMCKINFO(void)
{
    /* MMCKINFO (pack 1) */
    TEST_TYPE_SIZE   (MMCKINFO, 20)
    TEST_TYPE_ALIGN  (MMCKINFO, 1)
    TEST_FIELD_SIZE  (MMCKINFO, ckid, 4)
    TEST_FIELD_ALIGN (MMCKINFO, ckid, 1)
    TEST_FIELD_OFFSET(MMCKINFO, ckid, 0)
    TEST_FIELD_SIZE  (MMCKINFO, cksize, 4)
    TEST_FIELD_ALIGN (MMCKINFO, cksize, 1)
    TEST_FIELD_OFFSET(MMCKINFO, cksize, 4)
    TEST_FIELD_SIZE  (MMCKINFO, fccType, 4)
    TEST_FIELD_ALIGN (MMCKINFO, fccType, 1)
    TEST_FIELD_OFFSET(MMCKINFO, fccType, 8)
    TEST_FIELD_SIZE  (MMCKINFO, dwDataOffset, 4)
    TEST_FIELD_ALIGN (MMCKINFO, dwDataOffset, 1)
    TEST_FIELD_OFFSET(MMCKINFO, dwDataOffset, 12)
    TEST_FIELD_SIZE  (MMCKINFO, dwFlags, 4)
    TEST_FIELD_ALIGN (MMCKINFO, dwFlags, 1)
    TEST_FIELD_OFFSET(MMCKINFO, dwFlags, 16)
}

static void test_pack_MCI_GENERIC_PARMS(void)
{
    /* MCI_GENERIC_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_GENERIC_PARMS, 8)
    TEST_TYPE_ALIGN  (MCI_GENERIC_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_GENERIC_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_GENERIC_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_GENERIC_PARMS, dwCallback, 0)
}

static void test_pack_MCI_OPEN_PARMSA(void)
{
    /* MCI_OPEN_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_OPEN_PARMSA, 36)
    TEST_TYPE_ALIGN  (MCI_OPEN_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSA, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSA, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSA, wDeviceID, 8)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSA, lpstrDeviceType, 8)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSA, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSA, lpstrDeviceType, 12)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSA, lpstrElementName, 8)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSA, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSA, lpstrElementName, 20)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSA, lpstrAlias, 8)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSA, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSA, lpstrAlias, 28)
}

static void test_pack_MCI_OPEN_PARMSW(void)
{
    /* MCI_OPEN_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_OPEN_PARMSW, 36)
    TEST_TYPE_ALIGN  (MCI_OPEN_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSW, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSW, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSW, wDeviceID, 8)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSW, lpstrDeviceType, 8)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSW, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSW, lpstrDeviceType, 12)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSW, lpstrElementName, 8)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSW, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSW, lpstrElementName, 20)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSW, lpstrAlias, 8)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSW, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSW, lpstrAlias, 28)
}

static void test_pack_MCI_PLAY_PARMS(void)
{
    /* MCI_PLAY_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_PLAY_PARMS, 16)
    TEST_TYPE_ALIGN  (MCI_PLAY_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_PLAY_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_PLAY_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_PLAY_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_PLAY_PARMS, dwFrom, 4)
    TEST_FIELD_ALIGN (MCI_PLAY_PARMS, dwFrom, 1)
    TEST_FIELD_OFFSET(MCI_PLAY_PARMS, dwFrom, 8)
    TEST_FIELD_SIZE  (MCI_PLAY_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_PLAY_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_PLAY_PARMS, dwTo, 12)
}

static void test_pack_MCI_SEEK_PARMS(void)
{
    /* MCI_SEEK_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_SEEK_PARMS, 12)
    TEST_TYPE_ALIGN  (MCI_SEEK_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_SEEK_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_SEEK_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_SEEK_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_SEEK_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_SEEK_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_SEEK_PARMS, dwTo, 8)
}

static void test_pack_MCI_STATUS_PARMS(void)
{
    /* MCI_STATUS_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_STATUS_PARMS, 24)
    TEST_TYPE_ALIGN  (MCI_STATUS_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_STATUS_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_STATUS_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_STATUS_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_STATUS_PARMS, dwReturn, 8)
    TEST_FIELD_ALIGN (MCI_STATUS_PARMS, dwReturn, 1)
    TEST_FIELD_OFFSET(MCI_STATUS_PARMS, dwReturn, 8)
    TEST_FIELD_SIZE  (MCI_STATUS_PARMS, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_STATUS_PARMS, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_STATUS_PARMS, dwItem, 16)
    TEST_FIELD_SIZE  (MCI_STATUS_PARMS, dwTrack, 4)
    TEST_FIELD_ALIGN (MCI_STATUS_PARMS, dwTrack, 1)
    TEST_FIELD_OFFSET(MCI_STATUS_PARMS, dwTrack, 20)
}

static void test_pack_MCI_INFO_PARMSA(void)
{
    /* MCI_INFO_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_INFO_PARMSA, 20)
    TEST_TYPE_ALIGN  (MCI_INFO_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_INFO_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_INFO_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_INFO_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_INFO_PARMSA, lpstrReturn, 8)
    TEST_FIELD_ALIGN (MCI_INFO_PARMSA, lpstrReturn, 1)
    TEST_FIELD_OFFSET(MCI_INFO_PARMSA, lpstrReturn, 8)
    TEST_FIELD_SIZE  (MCI_INFO_PARMSA, dwRetSize, 4)
    TEST_FIELD_ALIGN (MCI_INFO_PARMSA, dwRetSize, 1)
    TEST_FIELD_OFFSET(MCI_INFO_PARMSA, dwRetSize, 16)
}

static void test_pack_MCI_INFO_PARMSW(void)
{
    /* MCI_INFO_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_INFO_PARMSW, 20)
    TEST_TYPE_ALIGN  (MCI_INFO_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_INFO_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_INFO_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_INFO_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_INFO_PARMSW, lpstrReturn, 8)
    TEST_FIELD_ALIGN (MCI_INFO_PARMSW, lpstrReturn, 1)
    TEST_FIELD_OFFSET(MCI_INFO_PARMSW, lpstrReturn, 8)
    TEST_FIELD_SIZE  (MCI_INFO_PARMSW, dwRetSize, 4)
    TEST_FIELD_ALIGN (MCI_INFO_PARMSW, dwRetSize, 1)
    TEST_FIELD_OFFSET(MCI_INFO_PARMSW, dwRetSize, 16)
}

static void test_pack_MCI_GETDEVCAPS_PARMS(void)
{
    /* MCI_GETDEVCAPS_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_GETDEVCAPS_PARMS, 16)
    TEST_TYPE_ALIGN  (MCI_GETDEVCAPS_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_GETDEVCAPS_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_GETDEVCAPS_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_GETDEVCAPS_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_GETDEVCAPS_PARMS, dwReturn, 4)
    TEST_FIELD_ALIGN (MCI_GETDEVCAPS_PARMS, dwReturn, 1)
    TEST_FIELD_OFFSET(MCI_GETDEVCAPS_PARMS, dwReturn, 8)
    TEST_FIELD_SIZE  (MCI_GETDEVCAPS_PARMS, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_GETDEVCAPS_PARMS, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_GETDEVCAPS_PARMS, dwItem, 12)
}

static void test_pack_MCI_SYSINFO_PARMSA(void)
{
    /* MCI_SYSINFO_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_SYSINFO_PARMSA, 28)
    TEST_TYPE_ALIGN  (MCI_SYSINFO_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSA, lpstrReturn, 8)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSA, lpstrReturn, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSA, lpstrReturn, 8)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSA, dwRetSize, 4)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSA, dwRetSize, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSA, dwRetSize, 16)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSA, dwNumber, 4)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSA, dwNumber, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSA, dwNumber, 20)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSA, wDeviceType, 4)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSA, wDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSA, wDeviceType, 24)
}

static void test_pack_MCI_SYSINFO_PARMSW(void)
{
    /* MCI_SYSINFO_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_SYSINFO_PARMSW, 28)
    TEST_TYPE_ALIGN  (MCI_SYSINFO_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSW, lpstrReturn, 8)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSW, lpstrReturn, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSW, lpstrReturn, 8)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSW, dwRetSize, 4)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSW, dwRetSize, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSW, dwRetSize, 16)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSW, dwNumber, 4)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSW, dwNumber, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSW, dwNumber, 20)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSW, wDeviceType, 4)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSW, wDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSW, wDeviceType, 24)
}

static void test_pack_MCI_SET_PARMS(void)
{
    /* MCI_SET_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_SET_PARMS, 16)
    TEST_TYPE_ALIGN  (MCI_SET_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_SET_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_SET_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_SET_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_SET_PARMS, dwTimeFormat, 4)
    TEST_FIELD_ALIGN (MCI_SET_PARMS, dwTimeFormat, 1)
    TEST_FIELD_OFFSET(MCI_SET_PARMS, dwTimeFormat, 8)
    TEST_FIELD_SIZE  (MCI_SET_PARMS, dwAudio, 4)
    TEST_FIELD_ALIGN (MCI_SET_PARMS, dwAudio, 1)
    TEST_FIELD_OFFSET(MCI_SET_PARMS, dwAudio, 12)
}

static void test_pack_MCI_BREAK_PARMS(void)
{
    /* MCI_BREAK_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_BREAK_PARMS, 20)
    TEST_TYPE_ALIGN  (MCI_BREAK_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_BREAK_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_BREAK_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_BREAK_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_BREAK_PARMS, nVirtKey, 4)
    TEST_FIELD_ALIGN (MCI_BREAK_PARMS, nVirtKey, 1)
    TEST_FIELD_OFFSET(MCI_BREAK_PARMS, nVirtKey, 8)
    TEST_FIELD_SIZE  (MCI_BREAK_PARMS, hwndBreak, 8)
    TEST_FIELD_ALIGN (MCI_BREAK_PARMS, hwndBreak, 1)
    TEST_FIELD_OFFSET(MCI_BREAK_PARMS, hwndBreak, 12)
}

static void test_pack_MCI_SOUND_PARMSA(void)
{
    /* MCI_SOUND_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_SOUND_PARMSA, 16)
    TEST_TYPE_ALIGN  (MCI_SOUND_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_SOUND_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_SOUND_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_SOUND_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_SOUND_PARMSA, lpstrSoundName, 8)
    TEST_FIELD_ALIGN (MCI_SOUND_PARMSA, lpstrSoundName, 1)
    TEST_FIELD_OFFSET(MCI_SOUND_PARMSA, lpstrSoundName, 8)
}

static void test_pack_MCI_SOUND_PARMSW(void)
{
    /* MCI_SOUND_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_SOUND_PARMSW, 16)
    TEST_TYPE_ALIGN  (MCI_SOUND_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_SOUND_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_SOUND_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_SOUND_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_SOUND_PARMSW, lpstrSoundName, 8)
    TEST_FIELD_ALIGN (MCI_SOUND_PARMSW, lpstrSoundName, 1)
    TEST_FIELD_OFFSET(MCI_SOUND_PARMSW, lpstrSoundName, 8)
}

static void test_pack_MCI_SAVE_PARMSA(void)
{
    /* MCI_SAVE_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_SAVE_PARMSA, 16)
    TEST_TYPE_ALIGN  (MCI_SAVE_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_SAVE_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_SAVE_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_SAVE_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_SAVE_PARMSA, lpfilename, 8)
    TEST_FIELD_ALIGN (MCI_SAVE_PARMSA, lpfilename, 1)
    TEST_FIELD_OFFSET(MCI_SAVE_PARMSA, lpfilename, 8)
}

static void test_pack_MCI_SAVE_PARMSW(void)
{
    /* MCI_SAVE_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_SAVE_PARMSW, 16)
    TEST_TYPE_ALIGN  (MCI_SAVE_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_SAVE_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_SAVE_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_SAVE_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_SAVE_PARMSW, lpfilename, 8)
    TEST_FIELD_ALIGN (MCI_SAVE_PARMSW, lpfilename, 1)
    TEST_FIELD_OFFSET(MCI_SAVE_PARMSW, lpfilename, 8)
}

static void test_pack_MCI_LOAD_PARMSA(void)
{
    /* MCI_LOAD_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_LOAD_PARMSA, 16)
    TEST_TYPE_ALIGN  (MCI_LOAD_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_LOAD_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_LOAD_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_LOAD_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_LOAD_PARMSA, lpfilename, 8)
    TEST_FIELD_ALIGN (MCI_LOAD_PARMSA, lpfilename, 1)
    TEST_FIELD_OFFSET(MCI_LOAD_PARMSA, lpfilename, 8)
}

static void test_pack_MCI_LOAD_PARMSW(void)
{
    /* MCI_LOAD_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_LOAD_PARMSW, 16)
    TEST_TYPE_ALIGN  (MCI_LOAD_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_LOAD_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_LOAD_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_LOAD_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_LOAD_PARMSW, lpfilename, 8)
    TEST_FIELD_ALIGN (MCI_LOAD_PARMSW, lpfilename, 1)
    TEST_FIELD_OFFSET(MCI_LOAD_PARMSW, lpfilename, 8)
}

static void test_pack_MCI_RECORD_PARMS(void)
{
    /* MCI_RECORD_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_RECORD_PARMS, 16)
    TEST_TYPE_ALIGN  (MCI_RECORD_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_RECORD_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_RECORD_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_RECORD_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_RECORD_PARMS, dwFrom, 4)
    TEST_FIELD_ALIGN (MCI_RECORD_PARMS, dwFrom, 1)
    TEST_FIELD_OFFSET(MCI_RECORD_PARMS, dwFrom, 8)
    TEST_FIELD_SIZE  (MCI_RECORD_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_RECORD_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_RECORD_PARMS, dwTo, 12)
}

static void test_pack_MCI_VD_PLAY_PARMS(void)
{
    /* MCI_VD_PLAY_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_VD_PLAY_PARMS, 20)
    TEST_TYPE_ALIGN  (MCI_VD_PLAY_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_VD_PLAY_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_VD_PLAY_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_VD_PLAY_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_VD_PLAY_PARMS, dwFrom, 4)
    TEST_FIELD_ALIGN (MCI_VD_PLAY_PARMS, dwFrom, 1)
    TEST_FIELD_OFFSET(MCI_VD_PLAY_PARMS, dwFrom, 8)
    TEST_FIELD_SIZE  (MCI_VD_PLAY_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_VD_PLAY_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_VD_PLAY_PARMS, dwTo, 12)
    TEST_FIELD_SIZE  (MCI_VD_PLAY_PARMS, dwSpeed, 4)
    TEST_FIELD_ALIGN (MCI_VD_PLAY_PARMS, dwSpeed, 1)
    TEST_FIELD_OFFSET(MCI_VD_PLAY_PARMS, dwSpeed, 16)
}

static void test_pack_MCI_VD_STEP_PARMS(void)
{
    /* MCI_VD_STEP_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_VD_STEP_PARMS, 12)
    TEST_TYPE_ALIGN  (MCI_VD_STEP_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_VD_STEP_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_VD_STEP_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_VD_STEP_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_VD_STEP_PARMS, dwFrames, 4)
    TEST_FIELD_ALIGN (MCI_VD_STEP_PARMS, dwFrames, 1)
    TEST_FIELD_OFFSET(MCI_VD_STEP_PARMS, dwFrames, 8)
}

static void test_pack_MCI_VD_ESCAPE_PARMSA(void)
{
    /* MCI_VD_ESCAPE_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_VD_ESCAPE_PARMSA, 16)
    TEST_TYPE_ALIGN  (MCI_VD_ESCAPE_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_VD_ESCAPE_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_VD_ESCAPE_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_VD_ESCAPE_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_VD_ESCAPE_PARMSA, lpstrCommand, 8)
    TEST_FIELD_ALIGN (MCI_VD_ESCAPE_PARMSA, lpstrCommand, 1)
    TEST_FIELD_OFFSET(MCI_VD_ESCAPE_PARMSA, lpstrCommand, 8)
}

static void test_pack_MCI_VD_ESCAPE_PARMSW(void)
{
    /* MCI_VD_ESCAPE_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_VD_ESCAPE_PARMSW, 16)
    TEST_TYPE_ALIGN  (MCI_VD_ESCAPE_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_VD_ESCAPE_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_VD_ESCAPE_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_VD_ESCAPE_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_VD_ESCAPE_PARMSW, lpstrCommand, 8)
    TEST_FIELD_ALIGN (MCI_VD_ESCAPE_PARMSW, lpstrCommand, 1)
    TEST_FIELD_OFFSET(MCI_VD_ESCAPE_PARMSW, lpstrCommand, 8)
}

static void test_pack_MCI_WAVE_OPEN_PARMSA(void)
{
    /* MCI_WAVE_OPEN_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_WAVE_OPEN_PARMSA, 40)
    TEST_TYPE_ALIGN  (MCI_WAVE_OPEN_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSA, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSA, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSA, wDeviceID, 8)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSA, lpstrDeviceType, 8)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSA, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSA, lpstrDeviceType, 12)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSA, lpstrElementName, 8)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSA, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSA, lpstrElementName, 20)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSA, lpstrAlias, 8)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSA, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSA, lpstrAlias, 28)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSA, dwBufferSeconds, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSA, dwBufferSeconds, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSA, dwBufferSeconds, 36)
}

static void test_pack_MCI_WAVE_OPEN_PARMSW(void)
{
    /* MCI_WAVE_OPEN_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_WAVE_OPEN_PARMSW, 40)
    TEST_TYPE_ALIGN  (MCI_WAVE_OPEN_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSW, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSW, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSW, wDeviceID, 8)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSW, lpstrDeviceType, 8)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSW, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSW, lpstrDeviceType, 12)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSW, lpstrElementName, 8)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSW, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSW, lpstrElementName, 20)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSW, lpstrAlias, 8)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSW, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSW, lpstrAlias, 28)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSW, dwBufferSeconds, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSW, dwBufferSeconds, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSW, dwBufferSeconds, 36)
}

static void test_pack_MCI_WAVE_DELETE_PARMS(void)
{
    /* MCI_WAVE_DELETE_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_WAVE_DELETE_PARMS, 16)
    TEST_TYPE_ALIGN  (MCI_WAVE_DELETE_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_WAVE_DELETE_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_WAVE_DELETE_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_DELETE_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_WAVE_DELETE_PARMS, dwFrom, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_DELETE_PARMS, dwFrom, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_DELETE_PARMS, dwFrom, 8)
    TEST_FIELD_SIZE  (MCI_WAVE_DELETE_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_DELETE_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_DELETE_PARMS, dwTo, 12)
}

static void test_pack_MCI_WAVE_SET_PARMS(void)
{
    /* MCI_WAVE_SET_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_WAVE_SET_PARMS, 48)
    TEST_TYPE_ALIGN  (MCI_WAVE_SET_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, dwTimeFormat, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, dwTimeFormat, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, dwTimeFormat, 8)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, dwAudio, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, dwAudio, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, dwAudio, 12)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, wInput, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, wInput, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, wInput, 16)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, wOutput, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, wOutput, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, wOutput, 20)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, wFormatTag, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, wFormatTag, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, wFormatTag, 24)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, nChannels, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, nChannels, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, nChannels, 28)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, nSamplesPerSec, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, nSamplesPerSec, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, nSamplesPerSec, 32)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, nAvgBytesPerSec, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, nAvgBytesPerSec, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, nAvgBytesPerSec, 36)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, nBlockAlign, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, nBlockAlign, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, nBlockAlign, 40)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, wBitsPerSample, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, wBitsPerSample, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, wBitsPerSample, 44)
}

static void test_pack_MCI_SEQ_SET_PARMS(void)
{
    /* MCI_SEQ_SET_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_SEQ_SET_PARMS, 36)
    TEST_TYPE_ALIGN  (MCI_SEQ_SET_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_SEQ_SET_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_SEQ_SET_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_SEQ_SET_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_SEQ_SET_PARMS, dwTimeFormat, 4)
    TEST_FIELD_ALIGN (MCI_SEQ_SET_PARMS, dwTimeFormat, 1)
    TEST_FIELD_OFFSET(MCI_SEQ_SET_PARMS, dwTimeFormat, 8)
    TEST_FIELD_SIZE  (MCI_SEQ_SET_PARMS, dwAudio, 4)
    TEST_FIELD_ALIGN (MCI_SEQ_SET_PARMS, dwAudio, 1)
    TEST_FIELD_OFFSET(MCI_SEQ_SET_PARMS, dwAudio, 12)
    TEST_FIELD_SIZE  (MCI_SEQ_SET_PARMS, dwTempo, 4)
    TEST_FIELD_ALIGN (MCI_SEQ_SET_PARMS, dwTempo, 1)
    TEST_FIELD_OFFSET(MCI_SEQ_SET_PARMS, dwTempo, 16)
    TEST_FIELD_SIZE  (MCI_SEQ_SET_PARMS, dwPort, 4)
    TEST_FIELD_ALIGN (MCI_SEQ_SET_PARMS, dwPort, 1)
    TEST_FIELD_OFFSET(MCI_SEQ_SET_PARMS, dwPort, 20)
    TEST_FIELD_SIZE  (MCI_SEQ_SET_PARMS, dwSlave, 4)
    TEST_FIELD_ALIGN (MCI_SEQ_SET_PARMS, dwSlave, 1)
    TEST_FIELD_OFFSET(MCI_SEQ_SET_PARMS, dwSlave, 24)
    TEST_FIELD_SIZE  (MCI_SEQ_SET_PARMS, dwMaster, 4)
    TEST_FIELD_ALIGN (MCI_SEQ_SET_PARMS, dwMaster, 1)
    TEST_FIELD_OFFSET(MCI_SEQ_SET_PARMS, dwMaster, 28)
    TEST_FIELD_SIZE  (MCI_SEQ_SET_PARMS, dwOffset, 4)
    TEST_FIELD_ALIGN (MCI_SEQ_SET_PARMS, dwOffset, 1)
    TEST_FIELD_OFFSET(MCI_SEQ_SET_PARMS, dwOffset, 32)
}

static void test_pack_MCI_ANIM_OPEN_PARMSA(void)
{
    /* MCI_ANIM_OPEN_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_ANIM_OPEN_PARMSA, 48)
    TEST_TYPE_ALIGN  (MCI_ANIM_OPEN_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSA, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSA, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSA, wDeviceID, 8)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSA, lpstrDeviceType, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSA, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSA, lpstrDeviceType, 12)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSA, lpstrElementName, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSA, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSA, lpstrElementName, 20)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSA, lpstrAlias, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSA, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSA, lpstrAlias, 28)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSA, dwStyle, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSA, dwStyle, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSA, dwStyle, 36)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSA, hWndParent, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSA, hWndParent, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSA, hWndParent, 40)
}

static void test_pack_MCI_ANIM_OPEN_PARMSW(void)
{
    /* MCI_ANIM_OPEN_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_ANIM_OPEN_PARMSW, 48)
    TEST_TYPE_ALIGN  (MCI_ANIM_OPEN_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSW, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSW, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSW, wDeviceID, 8)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSW, lpstrDeviceType, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSW, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSW, lpstrDeviceType, 12)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSW, lpstrElementName, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSW, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSW, lpstrElementName, 20)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSW, lpstrAlias, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSW, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSW, lpstrAlias, 28)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSW, dwStyle, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSW, dwStyle, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSW, dwStyle, 36)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSW, hWndParent, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSW, hWndParent, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSW, hWndParent, 40)
}

static void test_pack_MCI_ANIM_PLAY_PARMS(void)
{
    /* MCI_ANIM_PLAY_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_ANIM_PLAY_PARMS, 20)
    TEST_TYPE_ALIGN  (MCI_ANIM_PLAY_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_ANIM_PLAY_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_PLAY_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_PLAY_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_ANIM_PLAY_PARMS, dwFrom, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_PLAY_PARMS, dwFrom, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_PLAY_PARMS, dwFrom, 8)
    TEST_FIELD_SIZE  (MCI_ANIM_PLAY_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_PLAY_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_PLAY_PARMS, dwTo, 12)
    TEST_FIELD_SIZE  (MCI_ANIM_PLAY_PARMS, dwSpeed, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_PLAY_PARMS, dwSpeed, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_PLAY_PARMS, dwSpeed, 16)
}

static void test_pack_MCI_ANIM_STEP_PARMS(void)
{
    /* MCI_ANIM_STEP_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_ANIM_STEP_PARMS, 12)
    TEST_TYPE_ALIGN  (MCI_ANIM_STEP_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_ANIM_STEP_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_STEP_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_STEP_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_ANIM_STEP_PARMS, dwFrames, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_STEP_PARMS, dwFrames, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_STEP_PARMS, dwFrames, 8)
}

static void test_pack_MCI_ANIM_WINDOW_PARMSA(void)
{
    /* MCI_ANIM_WINDOW_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_ANIM_WINDOW_PARMSA, 28)
    TEST_TYPE_ALIGN  (MCI_ANIM_WINDOW_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_ANIM_WINDOW_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_WINDOW_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_WINDOW_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_ANIM_WINDOW_PARMSA, hWnd, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_WINDOW_PARMSA, hWnd, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_WINDOW_PARMSA, hWnd, 8)
    TEST_FIELD_SIZE  (MCI_ANIM_WINDOW_PARMSA, nCmdShow, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_WINDOW_PARMSA, nCmdShow, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_WINDOW_PARMSA, nCmdShow, 16)
    TEST_FIELD_SIZE  (MCI_ANIM_WINDOW_PARMSA, lpstrText, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_WINDOW_PARMSA, lpstrText, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_WINDOW_PARMSA, lpstrText, 20)
}

static void test_pack_MCI_ANIM_WINDOW_PARMSW(void)
{
    /* MCI_ANIM_WINDOW_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_ANIM_WINDOW_PARMSW, 28)
    TEST_TYPE_ALIGN  (MCI_ANIM_WINDOW_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_ANIM_WINDOW_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_WINDOW_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_WINDOW_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_ANIM_WINDOW_PARMSW, hWnd, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_WINDOW_PARMSW, hWnd, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_WINDOW_PARMSW, hWnd, 8)
    TEST_FIELD_SIZE  (MCI_ANIM_WINDOW_PARMSW, nCmdShow, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_WINDOW_PARMSW, nCmdShow, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_WINDOW_PARMSW, nCmdShow, 16)
    TEST_FIELD_SIZE  (MCI_ANIM_WINDOW_PARMSW, lpstrText, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_WINDOW_PARMSW, lpstrText, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_WINDOW_PARMSW, lpstrText, 20)
}

static void test_pack_MCI_ANIM_UPDATE_PARMS(void)
{
    /* MCI_ANIM_UPDATE_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_ANIM_UPDATE_PARMS, 32)
    TEST_TYPE_ALIGN  (MCI_ANIM_UPDATE_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_ANIM_UPDATE_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_UPDATE_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_UPDATE_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_ANIM_UPDATE_PARMS, rc, 16)
    TEST_FIELD_ALIGN (MCI_ANIM_UPDATE_PARMS, rc, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_UPDATE_PARMS, rc, 8)
    TEST_FIELD_SIZE  (MCI_ANIM_UPDATE_PARMS, hDC, 8)
    TEST_FIELD_ALIGN (MCI_ANIM_UPDATE_PARMS, hDC, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_UPDATE_PARMS, hDC, 24)
}

static void test_pack_MCI_OVLY_OPEN_PARMSA(void)
{
    /* MCI_OVLY_OPEN_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_OVLY_OPEN_PARMSA, 48)
    TEST_TYPE_ALIGN  (MCI_OVLY_OPEN_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSA, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSA, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSA, wDeviceID, 8)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSA, lpstrDeviceType, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSA, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSA, lpstrDeviceType, 12)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSA, lpstrElementName, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSA, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSA, lpstrElementName, 20)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSA, lpstrAlias, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSA, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSA, lpstrAlias, 28)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSA, dwStyle, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSA, dwStyle, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSA, dwStyle, 36)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSA, hWndParent, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSA, hWndParent, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSA, hWndParent, 40)
}

static void test_pack_MCI_OVLY_OPEN_PARMSW(void)
{
    /* MCI_OVLY_OPEN_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_OVLY_OPEN_PARMSW, 48)
    TEST_TYPE_ALIGN  (MCI_OVLY_OPEN_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSW, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSW, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSW, wDeviceID, 8)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSW, lpstrDeviceType, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSW, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSW, lpstrDeviceType, 12)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSW, lpstrElementName, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSW, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSW, lpstrElementName, 20)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSW, lpstrAlias, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSW, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSW, lpstrAlias, 28)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSW, dwStyle, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSW, dwStyle, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSW, dwStyle, 36)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSW, hWndParent, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSW, hWndParent, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSW, hWndParent, 40)
}

static void test_pack_MCI_OVLY_WINDOW_PARMSA(void)
{
    /* MCI_OVLY_WINDOW_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_OVLY_WINDOW_PARMSA, 28)
    TEST_TYPE_ALIGN  (MCI_OVLY_WINDOW_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_OVLY_WINDOW_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_WINDOW_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_WINDOW_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OVLY_WINDOW_PARMSA, hWnd, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_WINDOW_PARMSA, hWnd, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_WINDOW_PARMSA, hWnd, 8)
    TEST_FIELD_SIZE  (MCI_OVLY_WINDOW_PARMSA, nCmdShow, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_WINDOW_PARMSA, nCmdShow, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_WINDOW_PARMSA, nCmdShow, 16)
    TEST_FIELD_SIZE  (MCI_OVLY_WINDOW_PARMSA, lpstrText, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_WINDOW_PARMSA, lpstrText, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_WINDOW_PARMSA, lpstrText, 20)
}

static void test_pack_MCI_OVLY_WINDOW_PARMSW(void)
{
    /* MCI_OVLY_WINDOW_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_OVLY_WINDOW_PARMSW, 28)
    TEST_TYPE_ALIGN  (MCI_OVLY_WINDOW_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_OVLY_WINDOW_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_WINDOW_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_WINDOW_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OVLY_WINDOW_PARMSW, hWnd, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_WINDOW_PARMSW, hWnd, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_WINDOW_PARMSW, hWnd, 8)
    TEST_FIELD_SIZE  (MCI_OVLY_WINDOW_PARMSW, nCmdShow, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_WINDOW_PARMSW, nCmdShow, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_WINDOW_PARMSW, nCmdShow, 16)
    TEST_FIELD_SIZE  (MCI_OVLY_WINDOW_PARMSW, lpstrText, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_WINDOW_PARMSW, lpstrText, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_WINDOW_PARMSW, lpstrText, 20)
}

static void test_pack_MCI_OVLY_SAVE_PARMSA(void)
{
    /* MCI_OVLY_SAVE_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_OVLY_SAVE_PARMSA, 32)
    TEST_TYPE_ALIGN  (MCI_OVLY_SAVE_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_OVLY_SAVE_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_SAVE_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_SAVE_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OVLY_SAVE_PARMSA, lpfilename, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_SAVE_PARMSA, lpfilename, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_SAVE_PARMSA, lpfilename, 8)
    TEST_FIELD_SIZE  (MCI_OVLY_SAVE_PARMSA, rc, 16)
    TEST_FIELD_ALIGN (MCI_OVLY_SAVE_PARMSA, rc, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_SAVE_PARMSA, rc, 16)
}

static void test_pack_MCI_OVLY_SAVE_PARMSW(void)
{
    /* MCI_OVLY_SAVE_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_OVLY_SAVE_PARMSW, 32)
    TEST_TYPE_ALIGN  (MCI_OVLY_SAVE_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_OVLY_SAVE_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_SAVE_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_SAVE_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OVLY_SAVE_PARMSW, lpfilename, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_SAVE_PARMSW, lpfilename, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_SAVE_PARMSW, lpfilename, 8)
    TEST_FIELD_SIZE  (MCI_OVLY_SAVE_PARMSW, rc, 16)
    TEST_FIELD_ALIGN (MCI_OVLY_SAVE_PARMSW, rc, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_SAVE_PARMSW, rc, 16)
}

static void test_pack_MCI_OVLY_LOAD_PARMSA(void)
{
    /* MCI_OVLY_LOAD_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_OVLY_LOAD_PARMSA, 32)
    TEST_TYPE_ALIGN  (MCI_OVLY_LOAD_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_OVLY_LOAD_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_LOAD_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_LOAD_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OVLY_LOAD_PARMSA, lpfilename, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_LOAD_PARMSA, lpfilename, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_LOAD_PARMSA, lpfilename, 8)
    TEST_FIELD_SIZE  (MCI_OVLY_LOAD_PARMSA, rc, 16)
    TEST_FIELD_ALIGN (MCI_OVLY_LOAD_PARMSA, rc, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_LOAD_PARMSA, rc, 16)
}

static void test_pack_MCI_OVLY_LOAD_PARMSW(void)
{
    /* MCI_OVLY_LOAD_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_OVLY_LOAD_PARMSW, 32)
    TEST_TYPE_ALIGN  (MCI_OVLY_LOAD_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_OVLY_LOAD_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_LOAD_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_LOAD_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OVLY_LOAD_PARMSW, lpfilename, 8)
    TEST_FIELD_ALIGN (MCI_OVLY_LOAD_PARMSW, lpfilename, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_LOAD_PARMSW, lpfilename, 8)
    TEST_FIELD_SIZE  (MCI_OVLY_LOAD_PARMSW, rc, 16)
    TEST_FIELD_ALIGN (MCI_OVLY_LOAD_PARMSW, rc, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_LOAD_PARMSW, rc, 16)
}

static void test_pack_MCI_DGV_RECT_PARMS(void)
{
    /* MCI_DGV_RECT_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_RECT_PARMS, 24)
    TEST_TYPE_ALIGN  (MCI_DGV_RECT_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_RECT_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_RECT_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RECT_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_RECT_PARMS, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_RECT_PARMS, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RECT_PARMS, rc, 8)
}

static void test_pack_MCI_DGV_CAPTURE_PARMSA(void)
{
    /* MCI_DGV_CAPTURE_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_CAPTURE_PARMSA, 32)
    TEST_TYPE_ALIGN  (MCI_DGV_CAPTURE_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_CAPTURE_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_CAPTURE_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CAPTURE_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_CAPTURE_PARMSA, lpstrFileName, 8)
    TEST_FIELD_ALIGN (MCI_DGV_CAPTURE_PARMSA, lpstrFileName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CAPTURE_PARMSA, lpstrFileName, 8)
    TEST_FIELD_SIZE  (MCI_DGV_CAPTURE_PARMSA, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_CAPTURE_PARMSA, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CAPTURE_PARMSA, rc, 16)
}

static void test_pack_MCI_DGV_CAPTURE_PARMSW(void)
{
    /* MCI_DGV_CAPTURE_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_CAPTURE_PARMSW, 32)
    TEST_TYPE_ALIGN  (MCI_DGV_CAPTURE_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_CAPTURE_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_CAPTURE_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CAPTURE_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_CAPTURE_PARMSW, lpstrFileName, 8)
    TEST_FIELD_ALIGN (MCI_DGV_CAPTURE_PARMSW, lpstrFileName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CAPTURE_PARMSW, lpstrFileName, 8)
    TEST_FIELD_SIZE  (MCI_DGV_CAPTURE_PARMSW, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_CAPTURE_PARMSW, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CAPTURE_PARMSW, rc, 16)
}

static void test_pack_MCI_DGV_COPY_PARMS(void)
{
    /* MCI_DGV_COPY_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_COPY_PARMS, 40)
    TEST_TYPE_ALIGN  (MCI_DGV_COPY_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_COPY_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_COPY_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_COPY_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_COPY_PARMS, dwFrom, 4)
    TEST_FIELD_ALIGN (MCI_DGV_COPY_PARMS, dwFrom, 1)
    TEST_FIELD_OFFSET(MCI_DGV_COPY_PARMS, dwFrom, 8)
    TEST_FIELD_SIZE  (MCI_DGV_COPY_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_DGV_COPY_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_DGV_COPY_PARMS, dwTo, 12)
    TEST_FIELD_SIZE  (MCI_DGV_COPY_PARMS, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_COPY_PARMS, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_COPY_PARMS, rc, 16)
    TEST_FIELD_SIZE  (MCI_DGV_COPY_PARMS, dwAudioStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_COPY_PARMS, dwAudioStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_COPY_PARMS, dwAudioStream, 32)
    TEST_FIELD_SIZE  (MCI_DGV_COPY_PARMS, dwVideoStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_COPY_PARMS, dwVideoStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_COPY_PARMS, dwVideoStream, 36)
}

static void test_pack_MCI_DGV_CUE_PARMS(void)
{
    /* MCI_DGV_CUE_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_CUE_PARMS, 12)
    TEST_TYPE_ALIGN  (MCI_DGV_CUE_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_CUE_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_CUE_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CUE_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_CUE_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_DGV_CUE_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CUE_PARMS, dwTo, 8)
}

static void test_pack_MCI_DGV_CUT_PARMS(void)
{
    /* MCI_DGV_CUT_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_CUT_PARMS, 40)
    TEST_TYPE_ALIGN  (MCI_DGV_CUT_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_CUT_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_CUT_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CUT_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_CUT_PARMS, dwFrom, 4)
    TEST_FIELD_ALIGN (MCI_DGV_CUT_PARMS, dwFrom, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CUT_PARMS, dwFrom, 8)
    TEST_FIELD_SIZE  (MCI_DGV_CUT_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_DGV_CUT_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CUT_PARMS, dwTo, 12)
    TEST_FIELD_SIZE  (MCI_DGV_CUT_PARMS, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_CUT_PARMS, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CUT_PARMS, rc, 16)
    TEST_FIELD_SIZE  (MCI_DGV_CUT_PARMS, dwAudioStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_CUT_PARMS, dwAudioStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CUT_PARMS, dwAudioStream, 32)
    TEST_FIELD_SIZE  (MCI_DGV_CUT_PARMS, dwVideoStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_CUT_PARMS, dwVideoStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CUT_PARMS, dwVideoStream, 36)
}

static void test_pack_MCI_DGV_DELETE_PARMS(void)
{
    /* MCI_DGV_DELETE_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_DELETE_PARMS, 40)
    TEST_TYPE_ALIGN  (MCI_DGV_DELETE_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_DELETE_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_DELETE_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_DELETE_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_DELETE_PARMS, dwFrom, 4)
    TEST_FIELD_ALIGN (MCI_DGV_DELETE_PARMS, dwFrom, 1)
    TEST_FIELD_OFFSET(MCI_DGV_DELETE_PARMS, dwFrom, 8)
    TEST_FIELD_SIZE  (MCI_DGV_DELETE_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_DGV_DELETE_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_DGV_DELETE_PARMS, dwTo, 12)
    TEST_FIELD_SIZE  (MCI_DGV_DELETE_PARMS, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_DELETE_PARMS, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_DELETE_PARMS, rc, 16)
    TEST_FIELD_SIZE  (MCI_DGV_DELETE_PARMS, dwAudioStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_DELETE_PARMS, dwAudioStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_DELETE_PARMS, dwAudioStream, 32)
    TEST_FIELD_SIZE  (MCI_DGV_DELETE_PARMS, dwVideoStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_DELETE_PARMS, dwVideoStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_DELETE_PARMS, dwVideoStream, 36)
}

static void test_pack_MCI_DGV_INFO_PARMSA(void)
{
    /* MCI_DGV_INFO_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_INFO_PARMSA, 24)
    TEST_TYPE_ALIGN  (MCI_DGV_INFO_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_INFO_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_INFO_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_INFO_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_INFO_PARMSA, lpstrReturn, 8)
    TEST_FIELD_ALIGN (MCI_DGV_INFO_PARMSA, lpstrReturn, 1)
    TEST_FIELD_OFFSET(MCI_DGV_INFO_PARMSA, lpstrReturn, 8)
    TEST_FIELD_SIZE  (MCI_DGV_INFO_PARMSA, dwRetSize, 4)
    TEST_FIELD_ALIGN (MCI_DGV_INFO_PARMSA, dwRetSize, 1)
    TEST_FIELD_OFFSET(MCI_DGV_INFO_PARMSA, dwRetSize, 16)
    TEST_FIELD_SIZE  (MCI_DGV_INFO_PARMSA, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_INFO_PARMSA, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_INFO_PARMSA, dwItem, 20)
}

static void test_pack_MCI_DGV_INFO_PARMSW(void)
{
    /* MCI_DGV_INFO_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_INFO_PARMSW, 24)
    TEST_TYPE_ALIGN  (MCI_DGV_INFO_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_INFO_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_INFO_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_INFO_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_INFO_PARMSW, lpstrReturn, 8)
    TEST_FIELD_ALIGN (MCI_DGV_INFO_PARMSW, lpstrReturn, 1)
    TEST_FIELD_OFFSET(MCI_DGV_INFO_PARMSW, lpstrReturn, 8)
    TEST_FIELD_SIZE  (MCI_DGV_INFO_PARMSW, dwRetSize, 4)
    TEST_FIELD_ALIGN (MCI_DGV_INFO_PARMSW, dwRetSize, 1)
    TEST_FIELD_OFFSET(MCI_DGV_INFO_PARMSW, dwRetSize, 16)
    TEST_FIELD_SIZE  (MCI_DGV_INFO_PARMSW, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_INFO_PARMSW, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_INFO_PARMSW, dwItem, 20)
}

static void test_pack_MCI_DGV_LIST_PARMSA(void)
{
    /* MCI_DGV_LIST_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_LIST_PARMSA, 36)
    TEST_TYPE_ALIGN  (MCI_DGV_LIST_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSA, lpstrReturn, 8)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSA, lpstrReturn, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSA, lpstrReturn, 8)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSA, dwLength, 4)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSA, dwLength, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSA, dwLength, 16)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSA, dwNumber, 4)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSA, dwNumber, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSA, dwNumber, 20)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSA, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSA, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSA, dwItem, 24)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSA, lpstrAlgorithm, 8)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSA, lpstrAlgorithm, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSA, lpstrAlgorithm, 28)
}

static void test_pack_MCI_DGV_LIST_PARMSW(void)
{
    /* MCI_DGV_LIST_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_LIST_PARMSW, 36)
    TEST_TYPE_ALIGN  (MCI_DGV_LIST_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSW, lpstrReturn, 8)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSW, lpstrReturn, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSW, lpstrReturn, 8)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSW, dwLength, 4)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSW, dwLength, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSW, dwLength, 16)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSW, dwNumber, 4)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSW, dwNumber, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSW, dwNumber, 20)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSW, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSW, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSW, dwItem, 24)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSW, lpstrAlgorithm, 8)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSW, lpstrAlgorithm, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSW, lpstrAlgorithm, 28)
}

static void test_pack_MCI_DGV_MONITOR_PARMS(void)
{
    /* MCI_DGV_MONITOR_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_MONITOR_PARMS, 16)
    TEST_TYPE_ALIGN  (MCI_DGV_MONITOR_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_MONITOR_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_MONITOR_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_MONITOR_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_MONITOR_PARMS, dwSource, 4)
    TEST_FIELD_ALIGN (MCI_DGV_MONITOR_PARMS, dwSource, 1)
    TEST_FIELD_OFFSET(MCI_DGV_MONITOR_PARMS, dwSource, 8)
    TEST_FIELD_SIZE  (MCI_DGV_MONITOR_PARMS, dwMethod, 4)
    TEST_FIELD_ALIGN (MCI_DGV_MONITOR_PARMS, dwMethod, 1)
    TEST_FIELD_OFFSET(MCI_DGV_MONITOR_PARMS, dwMethod, 12)
}

static void test_pack_MCI_DGV_OPEN_PARMSA(void)
{
    /* MCI_DGV_OPEN_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_OPEN_PARMSA, 48)
    TEST_TYPE_ALIGN  (MCI_DGV_OPEN_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSA, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSA, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSA, wDeviceID, 8)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSA, lpstrDeviceType, 8)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSA, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSA, lpstrDeviceType, 12)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSA, lpstrElementName, 8)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSA, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSA, lpstrElementName, 20)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSA, lpstrAlias, 8)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSA, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSA, lpstrAlias, 28)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSA, dwStyle, 4)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSA, dwStyle, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSA, dwStyle, 36)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSA, hWndParent, 8)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSA, hWndParent, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSA, hWndParent, 40)
}

static void test_pack_MCI_DGV_OPEN_PARMSW(void)
{
    /* MCI_DGV_OPEN_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_OPEN_PARMSW, 48)
    TEST_TYPE_ALIGN  (MCI_DGV_OPEN_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSW, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSW, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSW, wDeviceID, 8)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSW, lpstrDeviceType, 8)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSW, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSW, lpstrDeviceType, 12)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSW, lpstrElementName, 8)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSW, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSW, lpstrElementName, 20)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSW, lpstrAlias, 8)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSW, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSW, lpstrAlias, 28)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSW, dwStyle, 4)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSW, dwStyle, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSW, dwStyle, 36)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSW, hWndParent, 8)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSW, hWndParent, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSW, hWndParent, 40)
}

static void test_pack_MCI_DGV_PASTE_PARMS(void)
{
    /* MCI_DGV_PASTE_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_PASTE_PARMS, 36)
    TEST_TYPE_ALIGN  (MCI_DGV_PASTE_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_PASTE_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_PASTE_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_PASTE_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_PASTE_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_DGV_PASTE_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_DGV_PASTE_PARMS, dwTo, 8)
    TEST_FIELD_SIZE  (MCI_DGV_PASTE_PARMS, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_PASTE_PARMS, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_PASTE_PARMS, rc, 12)
    TEST_FIELD_SIZE  (MCI_DGV_PASTE_PARMS, dwAudioStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_PASTE_PARMS, dwAudioStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_PASTE_PARMS, dwAudioStream, 28)
    TEST_FIELD_SIZE  (MCI_DGV_PASTE_PARMS, dwVideoStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_PASTE_PARMS, dwVideoStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_PASTE_PARMS, dwVideoStream, 32)
}

static void test_pack_MCI_DGV_QUALITY_PARMSA(void)
{
    /* MCI_DGV_QUALITY_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_QUALITY_PARMSA, 28)
    TEST_TYPE_ALIGN  (MCI_DGV_QUALITY_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSA, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSA, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSA, dwItem, 8)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSA, lpstrName, 8)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSA, lpstrName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSA, lpstrName, 12)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSA, lpstrAlgorithm, 4)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSA, lpstrAlgorithm, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSA, lpstrAlgorithm, 20)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSA, dwHandle, 4)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSA, dwHandle, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSA, dwHandle, 24)
}

static void test_pack_MCI_DGV_QUALITY_PARMSW(void)
{
    /* MCI_DGV_QUALITY_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_QUALITY_PARMSW, 28)
    TEST_TYPE_ALIGN  (MCI_DGV_QUALITY_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSW, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSW, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSW, dwItem, 8)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSW, lpstrName, 8)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSW, lpstrName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSW, lpstrName, 12)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSW, lpstrAlgorithm, 4)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSW, lpstrAlgorithm, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSW, lpstrAlgorithm, 20)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSW, dwHandle, 4)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSW, dwHandle, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSW, dwHandle, 24)
}

static void test_pack_MCI_DGV_RECORD_PARMS(void)
{
    /* MCI_DGV_RECORD_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_RECORD_PARMS, 40)
    TEST_TYPE_ALIGN  (MCI_DGV_RECORD_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_RECORD_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_RECORD_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RECORD_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_RECORD_PARMS, dwFrom, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RECORD_PARMS, dwFrom, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RECORD_PARMS, dwFrom, 8)
    TEST_FIELD_SIZE  (MCI_DGV_RECORD_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RECORD_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RECORD_PARMS, dwTo, 12)
    TEST_FIELD_SIZE  (MCI_DGV_RECORD_PARMS, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_RECORD_PARMS, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RECORD_PARMS, rc, 16)
    TEST_FIELD_SIZE  (MCI_DGV_RECORD_PARMS, dwAudioStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RECORD_PARMS, dwAudioStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RECORD_PARMS, dwAudioStream, 32)
    TEST_FIELD_SIZE  (MCI_DGV_RECORD_PARMS, dwVideoStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RECORD_PARMS, dwVideoStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RECORD_PARMS, dwVideoStream, 36)
}

static void test_pack_MCI_DGV_RESERVE_PARMSA(void)
{
    /* MCI_DGV_RESERVE_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_RESERVE_PARMSA, 20)
    TEST_TYPE_ALIGN  (MCI_DGV_RESERVE_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_RESERVE_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_RESERVE_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESERVE_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_RESERVE_PARMSA, lpstrPath, 8)
    TEST_FIELD_ALIGN (MCI_DGV_RESERVE_PARMSA, lpstrPath, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESERVE_PARMSA, lpstrPath, 8)
    TEST_FIELD_SIZE  (MCI_DGV_RESERVE_PARMSA, dwSize, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RESERVE_PARMSA, dwSize, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESERVE_PARMSA, dwSize, 16)
}

static void test_pack_MCI_DGV_RESERVE_PARMSW(void)
{
    /* MCI_DGV_RESERVE_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_RESERVE_PARMSW, 20)
    TEST_TYPE_ALIGN  (MCI_DGV_RESERVE_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_RESERVE_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_RESERVE_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESERVE_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_RESERVE_PARMSW, lpstrPath, 8)
    TEST_FIELD_ALIGN (MCI_DGV_RESERVE_PARMSW, lpstrPath, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESERVE_PARMSW, lpstrPath, 8)
    TEST_FIELD_SIZE  (MCI_DGV_RESERVE_PARMSW, dwSize, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RESERVE_PARMSW, dwSize, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESERVE_PARMSW, dwSize, 16)
}

static void test_pack_MCI_DGV_RESTORE_PARMSA(void)
{
    /* MCI_DGV_RESTORE_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_RESTORE_PARMSA, 32)
    TEST_TYPE_ALIGN  (MCI_DGV_RESTORE_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_RESTORE_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_RESTORE_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESTORE_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_RESTORE_PARMSA, lpstrFileName, 8)
    TEST_FIELD_ALIGN (MCI_DGV_RESTORE_PARMSA, lpstrFileName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESTORE_PARMSA, lpstrFileName, 8)
    TEST_FIELD_SIZE  (MCI_DGV_RESTORE_PARMSA, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_RESTORE_PARMSA, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESTORE_PARMSA, rc, 16)
}

static void test_pack_MCI_DGV_RESTORE_PARMSW(void)
{
    /* MCI_DGV_RESTORE_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_RESTORE_PARMSW, 32)
    TEST_TYPE_ALIGN  (MCI_DGV_RESTORE_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_RESTORE_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_RESTORE_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESTORE_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_RESTORE_PARMSW, lpstrFileName, 8)
    TEST_FIELD_ALIGN (MCI_DGV_RESTORE_PARMSW, lpstrFileName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESTORE_PARMSW, lpstrFileName, 8)
    TEST_FIELD_SIZE  (MCI_DGV_RESTORE_PARMSW, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_RESTORE_PARMSW, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESTORE_PARMSW, rc, 16)
}

static void test_pack_MCI_DGV_SAVE_PARMSA(void)
{
    /* MCI_DGV_SAVE_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_SAVE_PARMSA, 32)
    TEST_TYPE_ALIGN  (MCI_DGV_SAVE_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_SAVE_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_SAVE_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SAVE_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_SAVE_PARMSA, lpstrFileName, 8)
    TEST_FIELD_ALIGN (MCI_DGV_SAVE_PARMSA, lpstrFileName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SAVE_PARMSA, lpstrFileName, 8)
    TEST_FIELD_SIZE  (MCI_DGV_SAVE_PARMSA, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_SAVE_PARMSA, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SAVE_PARMSA, rc, 16)
}

static void test_pack_MCI_DGV_SAVE_PARMSW(void)
{
    /* MCI_DGV_SAVE_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_SAVE_PARMSW, 32)
    TEST_TYPE_ALIGN  (MCI_DGV_SAVE_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_SAVE_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_SAVE_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SAVE_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_SAVE_PARMSW, lpstrFileName, 8)
    TEST_FIELD_ALIGN (MCI_DGV_SAVE_PARMSW, lpstrFileName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SAVE_PARMSW, lpstrFileName, 8)
    TEST_FIELD_SIZE  (MCI_DGV_SAVE_PARMSW, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_SAVE_PARMSW, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SAVE_PARMSW, rc, 16)
}

static void test_pack_MCI_DGV_SET_PARMS(void)
{
    /* MCI_DGV_SET_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_SET_PARMS, 24)
    TEST_TYPE_ALIGN  (MCI_DGV_SET_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_SET_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_SET_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SET_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_SET_PARMS, dwTimeFormat, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SET_PARMS, dwTimeFormat, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SET_PARMS, dwTimeFormat, 8)
    TEST_FIELD_SIZE  (MCI_DGV_SET_PARMS, dwAudio, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SET_PARMS, dwAudio, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SET_PARMS, dwAudio, 12)
    TEST_FIELD_SIZE  (MCI_DGV_SET_PARMS, dwFileFormat, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SET_PARMS, dwFileFormat, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SET_PARMS, dwFileFormat, 16)
    TEST_FIELD_SIZE  (MCI_DGV_SET_PARMS, dwSpeed, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SET_PARMS, dwSpeed, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SET_PARMS, dwSpeed, 20)
}

static void test_pack_MCI_DGV_SETAUDIO_PARMSA(void)
{
    /* MCI_DGV_SETAUDIO_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_SETAUDIO_PARMSA, 36)
    TEST_TYPE_ALIGN  (MCI_DGV_SETAUDIO_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSA, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSA, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSA, dwItem, 8)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSA, dwValue, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSA, dwValue, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSA, dwValue, 12)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSA, dwOver, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSA, dwOver, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSA, dwOver, 16)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSA, lpstrAlgorithm, 8)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSA, lpstrAlgorithm, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSA, lpstrAlgorithm, 20)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSA, lpstrQuality, 8)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSA, lpstrQuality, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSA, lpstrQuality, 28)
}

static void test_pack_MCI_DGV_SETAUDIO_PARMSW(void)
{
    /* MCI_DGV_SETAUDIO_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_SETAUDIO_PARMSW, 36)
    TEST_TYPE_ALIGN  (MCI_DGV_SETAUDIO_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSW, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSW, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSW, dwItem, 8)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSW, dwValue, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSW, dwValue, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSW, dwValue, 12)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSW, dwOver, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSW, dwOver, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSW, dwOver, 16)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSW, lpstrAlgorithm, 8)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSW, lpstrAlgorithm, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSW, lpstrAlgorithm, 20)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSW, lpstrQuality, 8)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSW, lpstrQuality, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSW, lpstrQuality, 28)
}

static void test_pack_MCI_DGV_SIGNAL_PARMS(void)
{
    /* MCI_DGV_SIGNAL_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_SIGNAL_PARMS, 20)
    TEST_TYPE_ALIGN  (MCI_DGV_SIGNAL_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_SIGNAL_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_SIGNAL_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SIGNAL_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_SIGNAL_PARMS, dwPosition, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SIGNAL_PARMS, dwPosition, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SIGNAL_PARMS, dwPosition, 8)
    TEST_FIELD_SIZE  (MCI_DGV_SIGNAL_PARMS, dwPeriod, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SIGNAL_PARMS, dwPeriod, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SIGNAL_PARMS, dwPeriod, 12)
    TEST_FIELD_SIZE  (MCI_DGV_SIGNAL_PARMS, dwUserParm, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SIGNAL_PARMS, dwUserParm, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SIGNAL_PARMS, dwUserParm, 16)
}

static void test_pack_MCI_DGV_SETVIDEO_PARMSA(void)
{
    /* MCI_DGV_SETVIDEO_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_SETVIDEO_PARMSA, 40)
    TEST_TYPE_ALIGN  (MCI_DGV_SETVIDEO_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSA, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSA, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSA, dwItem, 8)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSA, dwValue, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSA, dwValue, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSA, dwValue, 12)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSA, dwOver, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSA, dwOver, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSA, dwOver, 16)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSA, lpstrAlgorithm, 8)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSA, lpstrAlgorithm, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSA, lpstrAlgorithm, 20)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSA, lpstrQuality, 8)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSA, lpstrQuality, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSA, lpstrQuality, 28)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSA, dwSourceNumber, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSA, dwSourceNumber, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSA, dwSourceNumber, 36)
}

static void test_pack_MCI_DGV_SETVIDEO_PARMSW(void)
{
    /* MCI_DGV_SETVIDEO_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_SETVIDEO_PARMSW, 40)
    TEST_TYPE_ALIGN  (MCI_DGV_SETVIDEO_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSW, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSW, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSW, dwItem, 8)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSW, dwValue, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSW, dwValue, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSW, dwValue, 12)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSW, dwOver, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSW, dwOver, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSW, dwOver, 16)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSW, lpstrAlgorithm, 8)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSW, lpstrAlgorithm, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSW, lpstrAlgorithm, 20)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSW, lpstrQuality, 8)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSW, lpstrQuality, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSW, lpstrQuality, 28)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSW, dwSourceNumber, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSW, dwSourceNumber, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSW, dwSourceNumber, 36)
}

static void test_pack_MCI_DGV_STATUS_PARMSA(void)
{
    /* MCI_DGV_STATUS_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_STATUS_PARMSA, 36)
    TEST_TYPE_ALIGN  (MCI_DGV_STATUS_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSA, dwReturn, 8)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSA, dwReturn, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSA, dwReturn, 8)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSA, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSA, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSA, dwItem, 16)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSA, dwTrack, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSA, dwTrack, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSA, dwTrack, 20)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSA, lpstrDrive, 8)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSA, lpstrDrive, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSA, lpstrDrive, 24)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSA, dwReference, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSA, dwReference, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSA, dwReference, 32)
}

static void test_pack_MCI_DGV_STATUS_PARMSW(void)
{
    /* MCI_DGV_STATUS_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_STATUS_PARMSW, 36)
    TEST_TYPE_ALIGN  (MCI_DGV_STATUS_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSW, dwReturn, 8)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSW, dwReturn, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSW, dwReturn, 8)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSW, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSW, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSW, dwItem, 16)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSW, dwTrack, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSW, dwTrack, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSW, dwTrack, 20)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSW, lpstrDrive, 8)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSW, lpstrDrive, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSW, lpstrDrive, 24)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSW, dwReference, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSW, dwReference, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSW, dwReference, 32)
}

static void test_pack_MCI_DGV_STEP_PARMS(void)
{
    /* MCI_DGV_STEP_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_STEP_PARMS, 12)
    TEST_TYPE_ALIGN  (MCI_DGV_STEP_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_STEP_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_STEP_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STEP_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_STEP_PARMS, dwFrames, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STEP_PARMS, dwFrames, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STEP_PARMS, dwFrames, 8)
}

static void test_pack_MCI_DGV_UPDATE_PARMS(void)
{
    /* MCI_DGV_UPDATE_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_UPDATE_PARMS, 32)
    TEST_TYPE_ALIGN  (MCI_DGV_UPDATE_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_UPDATE_PARMS, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_UPDATE_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_UPDATE_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_UPDATE_PARMS, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_UPDATE_PARMS, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_UPDATE_PARMS, rc, 8)
    TEST_FIELD_SIZE  (MCI_DGV_UPDATE_PARMS, hDC, 8)
    TEST_FIELD_ALIGN (MCI_DGV_UPDATE_PARMS, hDC, 1)
    TEST_FIELD_OFFSET(MCI_DGV_UPDATE_PARMS, hDC, 24)
}

static void test_pack_MCI_DGV_WINDOW_PARMSA(void)
{
    /* MCI_DGV_WINDOW_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_WINDOW_PARMSA, 28)
    TEST_TYPE_ALIGN  (MCI_DGV_WINDOW_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_WINDOW_PARMSA, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_WINDOW_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_WINDOW_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_WINDOW_PARMSA, hWnd, 8)
    TEST_FIELD_ALIGN (MCI_DGV_WINDOW_PARMSA, hWnd, 1)
    TEST_FIELD_OFFSET(MCI_DGV_WINDOW_PARMSA, hWnd, 8)
    TEST_FIELD_SIZE  (MCI_DGV_WINDOW_PARMSA, nCmdShow, 4)
    TEST_FIELD_ALIGN (MCI_DGV_WINDOW_PARMSA, nCmdShow, 1)
    TEST_FIELD_OFFSET(MCI_DGV_WINDOW_PARMSA, nCmdShow, 16)
    TEST_FIELD_SIZE  (MCI_DGV_WINDOW_PARMSA, lpstrText, 8)
    TEST_FIELD_ALIGN (MCI_DGV_WINDOW_PARMSA, lpstrText, 1)
    TEST_FIELD_OFFSET(MCI_DGV_WINDOW_PARMSA, lpstrText, 20)
}

static void test_pack_MCI_DGV_WINDOW_PARMSW(void)
{
    /* MCI_DGV_WINDOW_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_WINDOW_PARMSW, 28)
    TEST_TYPE_ALIGN  (MCI_DGV_WINDOW_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_WINDOW_PARMSW, dwCallback, 8)
    TEST_FIELD_ALIGN (MCI_DGV_WINDOW_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_WINDOW_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_WINDOW_PARMSW, hWnd, 8)
    TEST_FIELD_ALIGN (MCI_DGV_WINDOW_PARMSW, hWnd, 1)
    TEST_FIELD_OFFSET(MCI_DGV_WINDOW_PARMSW, hWnd, 8)
    TEST_FIELD_SIZE  (MCI_DGV_WINDOW_PARMSW, nCmdShow, 4)
    TEST_FIELD_ALIGN (MCI_DGV_WINDOW_PARMSW, nCmdShow, 1)
    TEST_FIELD_OFFSET(MCI_DGV_WINDOW_PARMSW, nCmdShow, 16)
    TEST_FIELD_SIZE  (MCI_DGV_WINDOW_PARMSW, lpstrText, 8)
    TEST_FIELD_ALIGN (MCI_DGV_WINDOW_PARMSW, lpstrText, 1)
    TEST_FIELD_OFFSET(MCI_DGV_WINDOW_PARMSW, lpstrText, 20)
}

#else /* _WIN64 */

static void test_pack_MMTIME(void)
{
    /* MMTIME (pack 1) */
    TEST_FIELD_SIZE  (MMTIME, wType, 4)
    TEST_FIELD_ALIGN (MMTIME, wType, 1)
    TEST_FIELD_OFFSET(MMTIME, wType, 0)
}

static void test_pack_DRVCONFIGINFO(void)
{
    /* DRVCONFIGINFO (pack 1) */
    TEST_TYPE_SIZE   (DRVCONFIGINFO, 12)
    TEST_TYPE_ALIGN  (DRVCONFIGINFO, 1)
    TEST_FIELD_SIZE  (DRVCONFIGINFO, dwDCISize, 4)
    TEST_FIELD_ALIGN (DRVCONFIGINFO, dwDCISize, 1)
    TEST_FIELD_OFFSET(DRVCONFIGINFO, dwDCISize, 0)
    TEST_FIELD_SIZE  (DRVCONFIGINFO, lpszDCISectionName, 4)
    TEST_FIELD_ALIGN (DRVCONFIGINFO, lpszDCISectionName, 1)
    TEST_FIELD_OFFSET(DRVCONFIGINFO, lpszDCISectionName, 4)
    TEST_FIELD_SIZE  (DRVCONFIGINFO, lpszDCIAliasName, 4)
    TEST_FIELD_ALIGN (DRVCONFIGINFO, lpszDCIAliasName, 1)
    TEST_FIELD_OFFSET(DRVCONFIGINFO, lpszDCIAliasName, 8)
}

static void test_pack_WAVEHDR(void)
{
    /* WAVEHDR (pack 1) */
    TEST_TYPE_SIZE   (WAVEHDR, 32)
    TEST_TYPE_ALIGN  (WAVEHDR, 1)
    TEST_FIELD_SIZE  (WAVEHDR, lpData, 4)
    TEST_FIELD_ALIGN (WAVEHDR, lpData, 1)
    TEST_FIELD_OFFSET(WAVEHDR, lpData, 0)
    TEST_FIELD_SIZE  (WAVEHDR, dwBufferLength, 4)
    TEST_FIELD_ALIGN (WAVEHDR, dwBufferLength, 1)
    TEST_FIELD_OFFSET(WAVEHDR, dwBufferLength, 4)
    TEST_FIELD_SIZE  (WAVEHDR, dwBytesRecorded, 4)
    TEST_FIELD_ALIGN (WAVEHDR, dwBytesRecorded, 1)
    TEST_FIELD_OFFSET(WAVEHDR, dwBytesRecorded, 8)
    TEST_FIELD_SIZE  (WAVEHDR, dwUser, 4)
    TEST_FIELD_ALIGN (WAVEHDR, dwUser, 1)
    TEST_FIELD_OFFSET(WAVEHDR, dwUser, 12)
    TEST_FIELD_SIZE  (WAVEHDR, dwFlags, 4)
    TEST_FIELD_ALIGN (WAVEHDR, dwFlags, 1)
    TEST_FIELD_OFFSET(WAVEHDR, dwFlags, 16)
    TEST_FIELD_SIZE  (WAVEHDR, dwLoops, 4)
    TEST_FIELD_ALIGN (WAVEHDR, dwLoops, 1)
    TEST_FIELD_OFFSET(WAVEHDR, dwLoops, 20)
    TEST_FIELD_SIZE  (WAVEHDR, lpNext, 4)
    TEST_FIELD_ALIGN (WAVEHDR, lpNext, 1)
    TEST_FIELD_OFFSET(WAVEHDR, lpNext, 24)
    TEST_FIELD_SIZE  (WAVEHDR, reserved, 4)
    TEST_FIELD_ALIGN (WAVEHDR, reserved, 1)
    TEST_FIELD_OFFSET(WAVEHDR, reserved, 28)
}

static void test_pack_WAVEOUTCAPSA(void)
{
    /* WAVEOUTCAPSA (pack 1) */
    TEST_FIELD_SIZE  (WAVEOUTCAPSA, wMid, 2)
    TEST_FIELD_ALIGN (WAVEOUTCAPSA, wMid, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPSA, wMid, 0)
    TEST_FIELD_SIZE  (WAVEOUTCAPSA, wPid, 2)
    TEST_FIELD_ALIGN (WAVEOUTCAPSA, wPid, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPSA, wPid, 2)
    TEST_FIELD_SIZE  (WAVEOUTCAPSA, vDriverVersion, 4)
    TEST_FIELD_ALIGN (WAVEOUTCAPSA, vDriverVersion, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPSA, vDriverVersion, 4)
}

static void test_pack_WAVEOUTCAPSW(void)
{
    /* WAVEOUTCAPSW (pack 1) */
    TEST_FIELD_SIZE  (WAVEOUTCAPSW, wMid, 2)
    TEST_FIELD_ALIGN (WAVEOUTCAPSW, wMid, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPSW, wMid, 0)
    TEST_FIELD_SIZE  (WAVEOUTCAPSW, wPid, 2)
    TEST_FIELD_ALIGN (WAVEOUTCAPSW, wPid, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPSW, wPid, 2)
    TEST_FIELD_SIZE  (WAVEOUTCAPSW, vDriverVersion, 4)
    TEST_FIELD_ALIGN (WAVEOUTCAPSW, vDriverVersion, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPSW, vDriverVersion, 4)
}

static void test_pack_WAVEOUTCAPS2A(void)
{
    /* WAVEOUTCAPS2A (pack 1) */
    TEST_FIELD_SIZE  (WAVEOUTCAPS2A, wMid, 2)
    TEST_FIELD_ALIGN (WAVEOUTCAPS2A, wMid, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPS2A, wMid, 0)
    TEST_FIELD_SIZE  (WAVEOUTCAPS2A, wPid, 2)
    TEST_FIELD_ALIGN (WAVEOUTCAPS2A, wPid, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPS2A, wPid, 2)
    TEST_FIELD_SIZE  (WAVEOUTCAPS2A, vDriverVersion, 4)
    TEST_FIELD_ALIGN (WAVEOUTCAPS2A, vDriverVersion, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPS2A, vDriverVersion, 4)
}

static void test_pack_WAVEOUTCAPS2W(void)
{
    /* WAVEOUTCAPS2W (pack 1) */
    TEST_FIELD_SIZE  (WAVEOUTCAPS2W, wMid, 2)
    TEST_FIELD_ALIGN (WAVEOUTCAPS2W, wMid, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPS2W, wMid, 0)
    TEST_FIELD_SIZE  (WAVEOUTCAPS2W, wPid, 2)
    TEST_FIELD_ALIGN (WAVEOUTCAPS2W, wPid, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPS2W, wPid, 2)
    TEST_FIELD_SIZE  (WAVEOUTCAPS2W, vDriverVersion, 4)
    TEST_FIELD_ALIGN (WAVEOUTCAPS2W, vDriverVersion, 1)
    TEST_FIELD_OFFSET(WAVEOUTCAPS2W, vDriverVersion, 4)
}

static void test_pack_WAVEINCAPSA(void)
{
    /* WAVEINCAPSA (pack 1) */
    TEST_FIELD_SIZE  (WAVEINCAPSA, wMid, 2)
    TEST_FIELD_ALIGN (WAVEINCAPSA, wMid, 1)
    TEST_FIELD_OFFSET(WAVEINCAPSA, wMid, 0)
    TEST_FIELD_SIZE  (WAVEINCAPSA, wPid, 2)
    TEST_FIELD_ALIGN (WAVEINCAPSA, wPid, 1)
    TEST_FIELD_OFFSET(WAVEINCAPSA, wPid, 2)
    TEST_FIELD_SIZE  (WAVEINCAPSA, vDriverVersion, 4)
    TEST_FIELD_ALIGN (WAVEINCAPSA, vDriverVersion, 1)
    TEST_FIELD_OFFSET(WAVEINCAPSA, vDriverVersion, 4)
}

static void test_pack_WAVEINCAPSW(void)
{
    /* WAVEINCAPSW (pack 1) */
    TEST_FIELD_SIZE  (WAVEINCAPSW, wMid, 2)
    TEST_FIELD_ALIGN (WAVEINCAPSW, wMid, 1)
    TEST_FIELD_OFFSET(WAVEINCAPSW, wMid, 0)
    TEST_FIELD_SIZE  (WAVEINCAPSW, wPid, 2)
    TEST_FIELD_ALIGN (WAVEINCAPSW, wPid, 1)
    TEST_FIELD_OFFSET(WAVEINCAPSW, wPid, 2)
    TEST_FIELD_SIZE  (WAVEINCAPSW, vDriverVersion, 4)
    TEST_FIELD_ALIGN (WAVEINCAPSW, vDriverVersion, 1)
    TEST_FIELD_OFFSET(WAVEINCAPSW, vDriverVersion, 4)
}

static void test_pack_WAVEINCAPS2A(void)
{
    /* WAVEINCAPS2A (pack 1) */
    TEST_FIELD_SIZE  (WAVEINCAPS2A, wMid, 2)
    TEST_FIELD_ALIGN (WAVEINCAPS2A, wMid, 1)
    TEST_FIELD_OFFSET(WAVEINCAPS2A, wMid, 0)
    TEST_FIELD_SIZE  (WAVEINCAPS2A, wPid, 2)
    TEST_FIELD_ALIGN (WAVEINCAPS2A, wPid, 1)
    TEST_FIELD_OFFSET(WAVEINCAPS2A, wPid, 2)
    TEST_FIELD_SIZE  (WAVEINCAPS2A, vDriverVersion, 4)
    TEST_FIELD_ALIGN (WAVEINCAPS2A, vDriverVersion, 1)
    TEST_FIELD_OFFSET(WAVEINCAPS2A, vDriverVersion, 4)
}

static void test_pack_WAVEINCAPS2W(void)
{
    /* WAVEINCAPS2W (pack 1) */
    TEST_FIELD_SIZE  (WAVEINCAPS2W, wMid, 2)
    TEST_FIELD_ALIGN (WAVEINCAPS2W, wMid, 1)
    TEST_FIELD_OFFSET(WAVEINCAPS2W, wMid, 0)
    TEST_FIELD_SIZE  (WAVEINCAPS2W, wPid, 2)
    TEST_FIELD_ALIGN (WAVEINCAPS2W, wPid, 1)
    TEST_FIELD_OFFSET(WAVEINCAPS2W, wPid, 2)
    TEST_FIELD_SIZE  (WAVEINCAPS2W, vDriverVersion, 4)
    TEST_FIELD_ALIGN (WAVEINCAPS2W, vDriverVersion, 1)
    TEST_FIELD_OFFSET(WAVEINCAPS2W, vDriverVersion, 4)
}

static void test_pack_WAVEFORMAT(void)
{
    /* WAVEFORMAT (pack 1) */
    TEST_TYPE_SIZE   (WAVEFORMAT, 14)
    TEST_TYPE_ALIGN  (WAVEFORMAT, 1)
    TEST_FIELD_SIZE  (WAVEFORMAT, wFormatTag, 2)
    TEST_FIELD_ALIGN (WAVEFORMAT, wFormatTag, 1)
    TEST_FIELD_OFFSET(WAVEFORMAT, wFormatTag, 0)
    TEST_FIELD_SIZE  (WAVEFORMAT, nChannels, 2)
    TEST_FIELD_ALIGN (WAVEFORMAT, nChannels, 1)
    TEST_FIELD_OFFSET(WAVEFORMAT, nChannels, 2)
    TEST_FIELD_SIZE  (WAVEFORMAT, nSamplesPerSec, 4)
    TEST_FIELD_ALIGN (WAVEFORMAT, nSamplesPerSec, 1)
    TEST_FIELD_OFFSET(WAVEFORMAT, nSamplesPerSec, 4)
    TEST_FIELD_SIZE  (WAVEFORMAT, nAvgBytesPerSec, 4)
    TEST_FIELD_ALIGN (WAVEFORMAT, nAvgBytesPerSec, 1)
    TEST_FIELD_OFFSET(WAVEFORMAT, nAvgBytesPerSec, 8)
    TEST_FIELD_SIZE  (WAVEFORMAT, nBlockAlign, 2)
    TEST_FIELD_ALIGN (WAVEFORMAT, nBlockAlign, 1)
    TEST_FIELD_OFFSET(WAVEFORMAT, nBlockAlign, 12)
}

static void test_pack_PCMWAVEFORMAT(void)
{
    /* PCMWAVEFORMAT (pack 1) */
    TEST_TYPE_SIZE   (PCMWAVEFORMAT, 16)
    TEST_TYPE_ALIGN  (PCMWAVEFORMAT, 1)
    TEST_FIELD_SIZE  (PCMWAVEFORMAT, wf, 14)
    TEST_FIELD_ALIGN (PCMWAVEFORMAT, wf, 1)
    TEST_FIELD_OFFSET(PCMWAVEFORMAT, wf, 0)
    TEST_FIELD_SIZE  (PCMWAVEFORMAT, wBitsPerSample, 2)
    TEST_FIELD_ALIGN (PCMWAVEFORMAT, wBitsPerSample, 1)
    TEST_FIELD_OFFSET(PCMWAVEFORMAT, wBitsPerSample, 14)
}

static void test_pack_WAVEFORMATEX(void)
{
    /* WAVEFORMATEX (pack 1) */
    TEST_TYPE_SIZE   (WAVEFORMATEX, 18)
    TEST_TYPE_ALIGN  (WAVEFORMATEX, 1)
    TEST_FIELD_SIZE  (WAVEFORMATEX, wFormatTag, 2)
    TEST_FIELD_ALIGN (WAVEFORMATEX, wFormatTag, 1)
    TEST_FIELD_OFFSET(WAVEFORMATEX, wFormatTag, 0)
    TEST_FIELD_SIZE  (WAVEFORMATEX, nChannels, 2)
    TEST_FIELD_ALIGN (WAVEFORMATEX, nChannels, 1)
    TEST_FIELD_OFFSET(WAVEFORMATEX, nChannels, 2)
    TEST_FIELD_SIZE  (WAVEFORMATEX, nSamplesPerSec, 4)
    TEST_FIELD_ALIGN (WAVEFORMATEX, nSamplesPerSec, 1)
    TEST_FIELD_OFFSET(WAVEFORMATEX, nSamplesPerSec, 4)
    TEST_FIELD_SIZE  (WAVEFORMATEX, nAvgBytesPerSec, 4)
    TEST_FIELD_ALIGN (WAVEFORMATEX, nAvgBytesPerSec, 1)
    TEST_FIELD_OFFSET(WAVEFORMATEX, nAvgBytesPerSec, 8)
    TEST_FIELD_SIZE  (WAVEFORMATEX, nBlockAlign, 2)
    TEST_FIELD_ALIGN (WAVEFORMATEX, nBlockAlign, 1)
    TEST_FIELD_OFFSET(WAVEFORMATEX, nBlockAlign, 12)
    TEST_FIELD_SIZE  (WAVEFORMATEX, wBitsPerSample, 2)
    TEST_FIELD_ALIGN (WAVEFORMATEX, wBitsPerSample, 1)
    TEST_FIELD_OFFSET(WAVEFORMATEX, wBitsPerSample, 14)
    TEST_FIELD_SIZE  (WAVEFORMATEX, cbSize, 2)
    TEST_FIELD_ALIGN (WAVEFORMATEX, cbSize, 1)
    TEST_FIELD_OFFSET(WAVEFORMATEX, cbSize, 16)
}

static void test_pack_MIDIOUTCAPSA(void)
{
    /* MIDIOUTCAPSA (pack 1) */
    TEST_FIELD_SIZE  (MIDIOUTCAPSA, wMid, 2)
    TEST_FIELD_ALIGN (MIDIOUTCAPSA, wMid, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPSA, wMid, 0)
    TEST_FIELD_SIZE  (MIDIOUTCAPSA, wPid, 2)
    TEST_FIELD_ALIGN (MIDIOUTCAPSA, wPid, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPSA, wPid, 2)
    TEST_FIELD_SIZE  (MIDIOUTCAPSA, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIDIOUTCAPSA, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPSA, vDriverVersion, 4)
}

static void test_pack_MIDIOUTCAPSW(void)
{
    /* MIDIOUTCAPSW (pack 1) */
    TEST_FIELD_SIZE  (MIDIOUTCAPSW, wMid, 2)
    TEST_FIELD_ALIGN (MIDIOUTCAPSW, wMid, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPSW, wMid, 0)
    TEST_FIELD_SIZE  (MIDIOUTCAPSW, wPid, 2)
    TEST_FIELD_ALIGN (MIDIOUTCAPSW, wPid, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPSW, wPid, 2)
    TEST_FIELD_SIZE  (MIDIOUTCAPSW, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIDIOUTCAPSW, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPSW, vDriverVersion, 4)
}

static void test_pack_MIDIOUTCAPS2A(void)
{
    /* MIDIOUTCAPS2A (pack 1) */
    TEST_FIELD_SIZE  (MIDIOUTCAPS2A, wMid, 2)
    TEST_FIELD_ALIGN (MIDIOUTCAPS2A, wMid, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPS2A, wMid, 0)
    TEST_FIELD_SIZE  (MIDIOUTCAPS2A, wPid, 2)
    TEST_FIELD_ALIGN (MIDIOUTCAPS2A, wPid, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPS2A, wPid, 2)
    TEST_FIELD_SIZE  (MIDIOUTCAPS2A, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIDIOUTCAPS2A, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPS2A, vDriverVersion, 4)
}

static void test_pack_MIDIOUTCAPS2W(void)
{
    /* MIDIOUTCAPS2W (pack 1) */
    TEST_FIELD_SIZE  (MIDIOUTCAPS2W, wMid, 2)
    TEST_FIELD_ALIGN (MIDIOUTCAPS2W, wMid, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPS2W, wMid, 0)
    TEST_FIELD_SIZE  (MIDIOUTCAPS2W, wPid, 2)
    TEST_FIELD_ALIGN (MIDIOUTCAPS2W, wPid, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPS2W, wPid, 2)
    TEST_FIELD_SIZE  (MIDIOUTCAPS2W, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIDIOUTCAPS2W, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIDIOUTCAPS2W, vDriverVersion, 4)
}

static void test_pack_MIDIINCAPSA(void)
{
    /* MIDIINCAPSA (pack 1) */
    TEST_FIELD_SIZE  (MIDIINCAPSA, wMid, 2)
    TEST_FIELD_ALIGN (MIDIINCAPSA, wMid, 1)
    TEST_FIELD_OFFSET(MIDIINCAPSA, wMid, 0)
    TEST_FIELD_SIZE  (MIDIINCAPSA, wPid, 2)
    TEST_FIELD_ALIGN (MIDIINCAPSA, wPid, 1)
    TEST_FIELD_OFFSET(MIDIINCAPSA, wPid, 2)
    TEST_FIELD_SIZE  (MIDIINCAPSA, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIDIINCAPSA, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIDIINCAPSA, vDriverVersion, 4)
}

static void test_pack_MIDIINCAPSW(void)
{
    /* MIDIINCAPSW (pack 1) */
    TEST_FIELD_SIZE  (MIDIINCAPSW, wMid, 2)
    TEST_FIELD_ALIGN (MIDIINCAPSW, wMid, 1)
    TEST_FIELD_OFFSET(MIDIINCAPSW, wMid, 0)
    TEST_FIELD_SIZE  (MIDIINCAPSW, wPid, 2)
    TEST_FIELD_ALIGN (MIDIINCAPSW, wPid, 1)
    TEST_FIELD_OFFSET(MIDIINCAPSW, wPid, 2)
    TEST_FIELD_SIZE  (MIDIINCAPSW, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIDIINCAPSW, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIDIINCAPSW, vDriverVersion, 4)
}

static void test_pack_MIDIINCAPS2A(void)
{
    /* MIDIINCAPS2A (pack 1) */
    TEST_FIELD_SIZE  (MIDIINCAPS2A, wMid, 2)
    TEST_FIELD_ALIGN (MIDIINCAPS2A, wMid, 1)
    TEST_FIELD_OFFSET(MIDIINCAPS2A, wMid, 0)
    TEST_FIELD_SIZE  (MIDIINCAPS2A, wPid, 2)
    TEST_FIELD_ALIGN (MIDIINCAPS2A, wPid, 1)
    TEST_FIELD_OFFSET(MIDIINCAPS2A, wPid, 2)
    TEST_FIELD_SIZE  (MIDIINCAPS2A, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIDIINCAPS2A, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIDIINCAPS2A, vDriverVersion, 4)
}

static void test_pack_MIDIINCAPS2W(void)
{
    /* MIDIINCAPS2W (pack 1) */
    TEST_FIELD_SIZE  (MIDIINCAPS2W, wMid, 2)
    TEST_FIELD_ALIGN (MIDIINCAPS2W, wMid, 1)
    TEST_FIELD_OFFSET(MIDIINCAPS2W, wMid, 0)
    TEST_FIELD_SIZE  (MIDIINCAPS2W, wPid, 2)
    TEST_FIELD_ALIGN (MIDIINCAPS2W, wPid, 1)
    TEST_FIELD_OFFSET(MIDIINCAPS2W, wPid, 2)
    TEST_FIELD_SIZE  (MIDIINCAPS2W, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIDIINCAPS2W, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIDIINCAPS2W, vDriverVersion, 4)
}

static void test_pack_MIDIHDR(void)
{
    /* MIDIHDR (pack 1) */
    TEST_TYPE_SIZE   (MIDIHDR, 64)
    TEST_TYPE_ALIGN  (MIDIHDR, 1)
    TEST_FIELD_SIZE  (MIDIHDR, lpData, 4)
    TEST_FIELD_ALIGN (MIDIHDR, lpData, 1)
    TEST_FIELD_OFFSET(MIDIHDR, lpData, 0)
    TEST_FIELD_SIZE  (MIDIHDR, dwBufferLength, 4)
    TEST_FIELD_ALIGN (MIDIHDR, dwBufferLength, 1)
    TEST_FIELD_OFFSET(MIDIHDR, dwBufferLength, 4)
    TEST_FIELD_SIZE  (MIDIHDR, dwBytesRecorded, 4)
    TEST_FIELD_ALIGN (MIDIHDR, dwBytesRecorded, 1)
    TEST_FIELD_OFFSET(MIDIHDR, dwBytesRecorded, 8)
    TEST_FIELD_SIZE  (MIDIHDR, dwUser, 4)
    TEST_FIELD_ALIGN (MIDIHDR, dwUser, 1)
    TEST_FIELD_OFFSET(MIDIHDR, dwUser, 12)
    TEST_FIELD_SIZE  (MIDIHDR, dwFlags, 4)
    TEST_FIELD_ALIGN (MIDIHDR, dwFlags, 1)
    TEST_FIELD_OFFSET(MIDIHDR, dwFlags, 16)
    TEST_FIELD_SIZE  (MIDIHDR, lpNext, 4)
    TEST_FIELD_ALIGN (MIDIHDR, lpNext, 1)
    TEST_FIELD_OFFSET(MIDIHDR, lpNext, 20)
    TEST_FIELD_SIZE  (MIDIHDR, reserved, 4)
    TEST_FIELD_ALIGN (MIDIHDR, reserved, 1)
    TEST_FIELD_OFFSET(MIDIHDR, reserved, 24)
    TEST_FIELD_SIZE  (MIDIHDR, dwOffset, 4)
    TEST_FIELD_ALIGN (MIDIHDR, dwOffset, 1)
    TEST_FIELD_OFFSET(MIDIHDR, dwOffset, 28)
    TEST_FIELD_SIZE  (MIDIHDR, dwReserved, 32)
    TEST_FIELD_ALIGN (MIDIHDR, dwReserved, 1)
    TEST_FIELD_OFFSET(MIDIHDR, dwReserved, 32)
}

static void test_pack_MIDIEVENT(void)
{
    /* MIDIEVENT (pack 1) */
    TEST_TYPE_SIZE   (MIDIEVENT, 16)
    TEST_TYPE_ALIGN  (MIDIEVENT, 1)
    TEST_FIELD_SIZE  (MIDIEVENT, dwDeltaTime, 4)
    TEST_FIELD_ALIGN (MIDIEVENT, dwDeltaTime, 1)
    TEST_FIELD_OFFSET(MIDIEVENT, dwDeltaTime, 0)
    TEST_FIELD_SIZE  (MIDIEVENT, dwStreamID, 4)
    TEST_FIELD_ALIGN (MIDIEVENT, dwStreamID, 1)
    TEST_FIELD_OFFSET(MIDIEVENT, dwStreamID, 4)
    TEST_FIELD_SIZE  (MIDIEVENT, dwEvent, 4)
    TEST_FIELD_ALIGN (MIDIEVENT, dwEvent, 1)
    TEST_FIELD_OFFSET(MIDIEVENT, dwEvent, 8)
    TEST_FIELD_SIZE  (MIDIEVENT, dwParms, 4)
    TEST_FIELD_ALIGN (MIDIEVENT, dwParms, 1)
    TEST_FIELD_OFFSET(MIDIEVENT, dwParms, 12)
}

static void test_pack_AUXCAPSA(void)
{
    /* AUXCAPSA (pack 1) */
    TEST_FIELD_SIZE  (AUXCAPSA, wMid, 2)
    TEST_FIELD_ALIGN (AUXCAPSA, wMid, 1)
    TEST_FIELD_OFFSET(AUXCAPSA, wMid, 0)
    TEST_FIELD_SIZE  (AUXCAPSA, wPid, 2)
    TEST_FIELD_ALIGN (AUXCAPSA, wPid, 1)
    TEST_FIELD_OFFSET(AUXCAPSA, wPid, 2)
    TEST_FIELD_SIZE  (AUXCAPSA, vDriverVersion, 4)
    TEST_FIELD_ALIGN (AUXCAPSA, vDriverVersion, 1)
    TEST_FIELD_OFFSET(AUXCAPSA, vDriverVersion, 4)
}

static void test_pack_AUXCAPSW(void)
{
    /* AUXCAPSW (pack 1) */
    TEST_FIELD_SIZE  (AUXCAPSW, wMid, 2)
    TEST_FIELD_ALIGN (AUXCAPSW, wMid, 1)
    TEST_FIELD_OFFSET(AUXCAPSW, wMid, 0)
    TEST_FIELD_SIZE  (AUXCAPSW, wPid, 2)
    TEST_FIELD_ALIGN (AUXCAPSW, wPid, 1)
    TEST_FIELD_OFFSET(AUXCAPSW, wPid, 2)
    TEST_FIELD_SIZE  (AUXCAPSW, vDriverVersion, 4)
    TEST_FIELD_ALIGN (AUXCAPSW, vDriverVersion, 1)
    TEST_FIELD_OFFSET(AUXCAPSW, vDriverVersion, 4)
}

static void test_pack_AUXCAPS2A(void)
{
    /* AUXCAPS2A (pack 1) */
    TEST_FIELD_SIZE  (AUXCAPS2A, wMid, 2)
    TEST_FIELD_ALIGN (AUXCAPS2A, wMid, 1)
    TEST_FIELD_OFFSET(AUXCAPS2A, wMid, 0)
    TEST_FIELD_SIZE  (AUXCAPS2A, wPid, 2)
    TEST_FIELD_ALIGN (AUXCAPS2A, wPid, 1)
    TEST_FIELD_OFFSET(AUXCAPS2A, wPid, 2)
    TEST_FIELD_SIZE  (AUXCAPS2A, vDriverVersion, 4)
    TEST_FIELD_ALIGN (AUXCAPS2A, vDriverVersion, 1)
    TEST_FIELD_OFFSET(AUXCAPS2A, vDriverVersion, 4)
}

static void test_pack_AUXCAPS2W(void)
{
    /* AUXCAPS2W (pack 1) */
    TEST_FIELD_SIZE  (AUXCAPS2W, wMid, 2)
    TEST_FIELD_ALIGN (AUXCAPS2W, wMid, 1)
    TEST_FIELD_OFFSET(AUXCAPS2W, wMid, 0)
    TEST_FIELD_SIZE  (AUXCAPS2W, wPid, 2)
    TEST_FIELD_ALIGN (AUXCAPS2W, wPid, 1)
    TEST_FIELD_OFFSET(AUXCAPS2W, wPid, 2)
    TEST_FIELD_SIZE  (AUXCAPS2W, vDriverVersion, 4)
    TEST_FIELD_ALIGN (AUXCAPS2W, vDriverVersion, 1)
    TEST_FIELD_OFFSET(AUXCAPS2W, vDriverVersion, 4)
}

static void test_pack_TIMECAPS(void)
{
    /* TIMECAPS (pack 1) */
    TEST_TYPE_SIZE   (TIMECAPS, 8)
    TEST_TYPE_ALIGN  (TIMECAPS, 1)
    TEST_FIELD_SIZE  (TIMECAPS, wPeriodMin, 4)
    TEST_FIELD_ALIGN (TIMECAPS, wPeriodMin, 1)
    TEST_FIELD_OFFSET(TIMECAPS, wPeriodMin, 0)
    TEST_FIELD_SIZE  (TIMECAPS, wPeriodMax, 4)
    TEST_FIELD_ALIGN (TIMECAPS, wPeriodMax, 1)
    TEST_FIELD_OFFSET(TIMECAPS, wPeriodMax, 4)
}

static void test_pack_JOYCAPSA(void)
{
    /* JOYCAPSA (pack 1) */
    TEST_FIELD_SIZE  (JOYCAPSA, wMid, 2)
    TEST_FIELD_ALIGN (JOYCAPSA, wMid, 1)
    TEST_FIELD_OFFSET(JOYCAPSA, wMid, 0)
    TEST_FIELD_SIZE  (JOYCAPSA, wPid, 2)
    TEST_FIELD_ALIGN (JOYCAPSA, wPid, 1)
    TEST_FIELD_OFFSET(JOYCAPSA, wPid, 2)
}

static void test_pack_JOYCAPSW(void)
{
    /* JOYCAPSW (pack 1) */
    TEST_FIELD_SIZE  (JOYCAPSW, wMid, 2)
    TEST_FIELD_ALIGN (JOYCAPSW, wMid, 1)
    TEST_FIELD_OFFSET(JOYCAPSW, wMid, 0)
    TEST_FIELD_SIZE  (JOYCAPSW, wPid, 2)
    TEST_FIELD_ALIGN (JOYCAPSW, wPid, 1)
    TEST_FIELD_OFFSET(JOYCAPSW, wPid, 2)
}

static void test_pack_JOYCAPS2A(void)
{
    /* JOYCAPS2A (pack 1) */
    TEST_FIELD_SIZE  (JOYCAPS2A, wMid, 2)
    TEST_FIELD_ALIGN (JOYCAPS2A, wMid, 1)
    TEST_FIELD_OFFSET(JOYCAPS2A, wMid, 0)
    TEST_FIELD_SIZE  (JOYCAPS2A, wPid, 2)
    TEST_FIELD_ALIGN (JOYCAPS2A, wPid, 1)
    TEST_FIELD_OFFSET(JOYCAPS2A, wPid, 2)
}

static void test_pack_JOYCAPS2W(void)
{
    /* JOYCAPS2W (pack 1) */
    TEST_FIELD_SIZE  (JOYCAPS2W, wMid, 2)
    TEST_FIELD_ALIGN (JOYCAPS2W, wMid, 1)
    TEST_FIELD_OFFSET(JOYCAPS2W, wMid, 0)
    TEST_FIELD_SIZE  (JOYCAPS2W, wPid, 2)
    TEST_FIELD_ALIGN (JOYCAPS2W, wPid, 1)
    TEST_FIELD_OFFSET(JOYCAPS2W, wPid, 2)
}

static void test_pack_JOYINFO(void)
{
    /* JOYINFO (pack 1) */
    TEST_TYPE_SIZE   (JOYINFO, 16)
    TEST_TYPE_ALIGN  (JOYINFO, 1)
    TEST_FIELD_SIZE  (JOYINFO, wXpos, 4)
    TEST_FIELD_ALIGN (JOYINFO, wXpos, 1)
    TEST_FIELD_OFFSET(JOYINFO, wXpos, 0)
    TEST_FIELD_SIZE  (JOYINFO, wYpos, 4)
    TEST_FIELD_ALIGN (JOYINFO, wYpos, 1)
    TEST_FIELD_OFFSET(JOYINFO, wYpos, 4)
    TEST_FIELD_SIZE  (JOYINFO, wZpos, 4)
    TEST_FIELD_ALIGN (JOYINFO, wZpos, 1)
    TEST_FIELD_OFFSET(JOYINFO, wZpos, 8)
    TEST_FIELD_SIZE  (JOYINFO, wButtons, 4)
    TEST_FIELD_ALIGN (JOYINFO, wButtons, 1)
    TEST_FIELD_OFFSET(JOYINFO, wButtons, 12)
}

static void test_pack_JOYINFOEX(void)
{
    /* JOYINFOEX (pack 1) */
    TEST_TYPE_SIZE   (JOYINFOEX, 52)
    TEST_TYPE_ALIGN  (JOYINFOEX, 1)
    TEST_FIELD_SIZE  (JOYINFOEX, dwSize, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwSize, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwSize, 0)
    TEST_FIELD_SIZE  (JOYINFOEX, dwFlags, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwFlags, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwFlags, 4)
    TEST_FIELD_SIZE  (JOYINFOEX, dwXpos, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwXpos, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwXpos, 8)
    TEST_FIELD_SIZE  (JOYINFOEX, dwYpos, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwYpos, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwYpos, 12)
    TEST_FIELD_SIZE  (JOYINFOEX, dwZpos, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwZpos, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwZpos, 16)
    TEST_FIELD_SIZE  (JOYINFOEX, dwRpos, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwRpos, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwRpos, 20)
    TEST_FIELD_SIZE  (JOYINFOEX, dwUpos, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwUpos, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwUpos, 24)
    TEST_FIELD_SIZE  (JOYINFOEX, dwVpos, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwVpos, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwVpos, 28)
    TEST_FIELD_SIZE  (JOYINFOEX, dwButtons, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwButtons, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwButtons, 32)
    TEST_FIELD_SIZE  (JOYINFOEX, dwButtonNumber, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwButtonNumber, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwButtonNumber, 36)
    TEST_FIELD_SIZE  (JOYINFOEX, dwPOV, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwPOV, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwPOV, 40)
    TEST_FIELD_SIZE  (JOYINFOEX, dwReserved1, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwReserved1, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwReserved1, 44)
    TEST_FIELD_SIZE  (JOYINFOEX, dwReserved2, 4)
    TEST_FIELD_ALIGN (JOYINFOEX, dwReserved2, 1)
    TEST_FIELD_OFFSET(JOYINFOEX, dwReserved2, 48)
}

static void test_pack_MIXERCAPSA(void)
{
    /* MIXERCAPSA (pack 1) */
    TEST_FIELD_SIZE  (MIXERCAPSA, wMid, 2)
    TEST_FIELD_ALIGN (MIXERCAPSA, wMid, 1)
    TEST_FIELD_OFFSET(MIXERCAPSA, wMid, 0)
    TEST_FIELD_SIZE  (MIXERCAPSA, wPid, 2)
    TEST_FIELD_ALIGN (MIXERCAPSA, wPid, 1)
    TEST_FIELD_OFFSET(MIXERCAPSA, wPid, 2)
    TEST_FIELD_SIZE  (MIXERCAPSA, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIXERCAPSA, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIXERCAPSA, vDriverVersion, 4)
}

static void test_pack_MIXERCAPSW(void)
{
    /* MIXERCAPSW (pack 1) */
    TEST_FIELD_SIZE  (MIXERCAPSW, wMid, 2)
    TEST_FIELD_ALIGN (MIXERCAPSW, wMid, 1)
    TEST_FIELD_OFFSET(MIXERCAPSW, wMid, 0)
    TEST_FIELD_SIZE  (MIXERCAPSW, wPid, 2)
    TEST_FIELD_ALIGN (MIXERCAPSW, wPid, 1)
    TEST_FIELD_OFFSET(MIXERCAPSW, wPid, 2)
    TEST_FIELD_SIZE  (MIXERCAPSW, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIXERCAPSW, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIXERCAPSW, vDriverVersion, 4)
}

static void test_pack_MIXERCAPS2A(void)
{
    /* MIXERCAPS2A (pack 1) */
    TEST_FIELD_SIZE  (MIXERCAPS2A, wMid, 2)
    TEST_FIELD_ALIGN (MIXERCAPS2A, wMid, 1)
    TEST_FIELD_OFFSET(MIXERCAPS2A, wMid, 0)
    TEST_FIELD_SIZE  (MIXERCAPS2A, wPid, 2)
    TEST_FIELD_ALIGN (MIXERCAPS2A, wPid, 1)
    TEST_FIELD_OFFSET(MIXERCAPS2A, wPid, 2)
    TEST_FIELD_SIZE  (MIXERCAPS2A, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIXERCAPS2A, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIXERCAPS2A, vDriverVersion, 4)
}

static void test_pack_MIXERCAPS2W(void)
{
    /* MIXERCAPS2W (pack 1) */
    TEST_FIELD_SIZE  (MIXERCAPS2W, wMid, 2)
    TEST_FIELD_ALIGN (MIXERCAPS2W, wMid, 1)
    TEST_FIELD_OFFSET(MIXERCAPS2W, wMid, 0)
    TEST_FIELD_SIZE  (MIXERCAPS2W, wPid, 2)
    TEST_FIELD_ALIGN (MIXERCAPS2W, wPid, 1)
    TEST_FIELD_OFFSET(MIXERCAPS2W, wPid, 2)
    TEST_FIELD_SIZE  (MIXERCAPS2W, vDriverVersion, 4)
    TEST_FIELD_ALIGN (MIXERCAPS2W, vDriverVersion, 1)
    TEST_FIELD_OFFSET(MIXERCAPS2W, vDriverVersion, 4)
}

static void test_pack_MIXERLINEA(void)
{
    /* MIXERLINEA (pack 1) */
    TEST_FIELD_SIZE  (MIXERLINEA, cbStruct, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, cbStruct, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, cbStruct, 0)
    TEST_FIELD_SIZE  (MIXERLINEA, dwDestination, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, dwDestination, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, dwDestination, 4)
    TEST_FIELD_SIZE  (MIXERLINEA, dwSource, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, dwSource, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, dwSource, 8)
    TEST_FIELD_SIZE  (MIXERLINEA, dwLineID, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, dwLineID, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, dwLineID, 12)
    TEST_FIELD_SIZE  (MIXERLINEA, fdwLine, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, fdwLine, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, fdwLine, 16)
    TEST_FIELD_SIZE  (MIXERLINEA, dwUser, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, dwUser, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, dwUser, 20)
    TEST_FIELD_SIZE  (MIXERLINEA, dwComponentType, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, dwComponentType, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, dwComponentType, 24)
    TEST_FIELD_SIZE  (MIXERLINEA, cChannels, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, cChannels, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, cChannels, 28)
    TEST_FIELD_SIZE  (MIXERLINEA, cConnections, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, cConnections, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, cConnections, 32)
    TEST_FIELD_SIZE  (MIXERLINEA, cControls, 4)
    TEST_FIELD_ALIGN (MIXERLINEA, cControls, 1)
    TEST_FIELD_OFFSET(MIXERLINEA, cControls, 36)
}

static void test_pack_MIXERLINEW(void)
{
    /* MIXERLINEW (pack 1) */
    TEST_FIELD_SIZE  (MIXERLINEW, cbStruct, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, cbStruct, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, cbStruct, 0)
    TEST_FIELD_SIZE  (MIXERLINEW, dwDestination, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, dwDestination, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, dwDestination, 4)
    TEST_FIELD_SIZE  (MIXERLINEW, dwSource, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, dwSource, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, dwSource, 8)
    TEST_FIELD_SIZE  (MIXERLINEW, dwLineID, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, dwLineID, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, dwLineID, 12)
    TEST_FIELD_SIZE  (MIXERLINEW, fdwLine, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, fdwLine, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, fdwLine, 16)
    TEST_FIELD_SIZE  (MIXERLINEW, dwUser, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, dwUser, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, dwUser, 20)
    TEST_FIELD_SIZE  (MIXERLINEW, dwComponentType, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, dwComponentType, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, dwComponentType, 24)
    TEST_FIELD_SIZE  (MIXERLINEW, cChannels, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, cChannels, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, cChannels, 28)
    TEST_FIELD_SIZE  (MIXERLINEW, cConnections, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, cConnections, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, cConnections, 32)
    TEST_FIELD_SIZE  (MIXERLINEW, cControls, 4)
    TEST_FIELD_ALIGN (MIXERLINEW, cControls, 1)
    TEST_FIELD_OFFSET(MIXERLINEW, cControls, 36)
}

static void test_pack_MIXERCONTROLA(void)
{
    /* MIXERCONTROLA (pack 1) */
    TEST_FIELD_SIZE  (MIXERCONTROLA, cbStruct, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLA, cbStruct, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLA, cbStruct, 0)
    TEST_FIELD_SIZE  (MIXERCONTROLA, dwControlID, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLA, dwControlID, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLA, dwControlID, 4)
    TEST_FIELD_SIZE  (MIXERCONTROLA, dwControlType, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLA, dwControlType, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLA, dwControlType, 8)
    TEST_FIELD_SIZE  (MIXERCONTROLA, fdwControl, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLA, fdwControl, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLA, fdwControl, 12)
    TEST_FIELD_SIZE  (MIXERCONTROLA, cMultipleItems, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLA, cMultipleItems, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLA, cMultipleItems, 16)
}

static void test_pack_MIXERCONTROLW(void)
{
    /* MIXERCONTROLW (pack 1) */
    TEST_FIELD_SIZE  (MIXERCONTROLW, cbStruct, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLW, cbStruct, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLW, cbStruct, 0)
    TEST_FIELD_SIZE  (MIXERCONTROLW, dwControlID, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLW, dwControlID, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLW, dwControlID, 4)
    TEST_FIELD_SIZE  (MIXERCONTROLW, dwControlType, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLW, dwControlType, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLW, dwControlType, 8)
    TEST_FIELD_SIZE  (MIXERCONTROLW, fdwControl, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLW, fdwControl, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLW, fdwControl, 12)
    TEST_FIELD_SIZE  (MIXERCONTROLW, cMultipleItems, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLW, cMultipleItems, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLW, cMultipleItems, 16)
}

static void test_pack_MIXERCONTROLDETAILS(void)
{
    /* MIXERCONTROLDETAILS (pack 1) */
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS, cbStruct, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS, cbStruct, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS, cbStruct, 0)
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS, dwControlID, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS, dwControlID, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS, dwControlID, 4)
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS, cChannels, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS, cChannels, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS, cChannels, 8)
}

static void test_pack_MIXERCONTROLDETAILS_LISTTEXTA(void)
{
    /* MIXERCONTROLDETAILS_LISTTEXTA (pack 1) */
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS_LISTTEXTA, dwParam1, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS_LISTTEXTA, dwParam1, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS_LISTTEXTA, dwParam1, 0)
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS_LISTTEXTA, dwParam2, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS_LISTTEXTA, dwParam2, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS_LISTTEXTA, dwParam2, 4)
}

static void test_pack_MIXERCONTROLDETAILS_LISTTEXTW(void)
{
    /* MIXERCONTROLDETAILS_LISTTEXTW (pack 1) */
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS_LISTTEXTW, dwParam1, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS_LISTTEXTW, dwParam1, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS_LISTTEXTW, dwParam1, 0)
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS_LISTTEXTW, dwParam2, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS_LISTTEXTW, dwParam2, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS_LISTTEXTW, dwParam2, 4)
}

static void test_pack_MIXERCONTROLDETAILS_BOOLEAN(void)
{
    /* MIXERCONTROLDETAILS_BOOLEAN (pack 1) */
    TEST_TYPE_SIZE   (MIXERCONTROLDETAILS_BOOLEAN, 4)
    TEST_TYPE_ALIGN  (MIXERCONTROLDETAILS_BOOLEAN, 1)
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS_BOOLEAN, fValue, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS_BOOLEAN, fValue, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS_BOOLEAN, fValue, 0)
}

static void test_pack_MIXERCONTROLDETAILS_SIGNED(void)
{
    /* MIXERCONTROLDETAILS_SIGNED (pack 1) */
    TEST_TYPE_SIZE   (MIXERCONTROLDETAILS_SIGNED, 4)
    TEST_TYPE_ALIGN  (MIXERCONTROLDETAILS_SIGNED, 1)
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS_SIGNED, lValue, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS_SIGNED, lValue, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS_SIGNED, lValue, 0)
}

static void test_pack_MIXERCONTROLDETAILS_UNSIGNED(void)
{
    /* MIXERCONTROLDETAILS_UNSIGNED (pack 1) */
    TEST_TYPE_SIZE   (MIXERCONTROLDETAILS_UNSIGNED, 4)
    TEST_TYPE_ALIGN  (MIXERCONTROLDETAILS_UNSIGNED, 1)
    TEST_FIELD_SIZE  (MIXERCONTROLDETAILS_UNSIGNED, dwValue, 4)
    TEST_FIELD_ALIGN (MIXERCONTROLDETAILS_UNSIGNED, dwValue, 1)
    TEST_FIELD_OFFSET(MIXERCONTROLDETAILS_UNSIGNED, dwValue, 0)
}

static void test_pack_MMIOINFO(void)
{
    /* MMIOINFO (pack 1) */
    TEST_FIELD_SIZE  (MMIOINFO, dwFlags, 4)
    TEST_FIELD_ALIGN (MMIOINFO, dwFlags, 1)
    TEST_FIELD_OFFSET(MMIOINFO, dwFlags, 0)
    TEST_FIELD_SIZE  (MMIOINFO, fccIOProc, 4)
    TEST_FIELD_ALIGN (MMIOINFO, fccIOProc, 1)
    TEST_FIELD_OFFSET(MMIOINFO, fccIOProc, 4)
    TEST_FIELD_SIZE  (MMIOINFO, pIOProc, 4)
    TEST_FIELD_ALIGN (MMIOINFO, pIOProc, 1)
    TEST_FIELD_OFFSET(MMIOINFO, pIOProc, 8)
    TEST_FIELD_SIZE  (MMIOINFO, wErrorRet, 4)
    TEST_FIELD_ALIGN (MMIOINFO, wErrorRet, 1)
    TEST_FIELD_OFFSET(MMIOINFO, wErrorRet, 12)
}

static void test_pack_MMCKINFO(void)
{
    /* MMCKINFO (pack 1) */
    TEST_TYPE_SIZE   (MMCKINFO, 20)
    TEST_TYPE_ALIGN  (MMCKINFO, 1)
    TEST_FIELD_SIZE  (MMCKINFO, ckid, 4)
    TEST_FIELD_ALIGN (MMCKINFO, ckid, 1)
    TEST_FIELD_OFFSET(MMCKINFO, ckid, 0)
    TEST_FIELD_SIZE  (MMCKINFO, cksize, 4)
    TEST_FIELD_ALIGN (MMCKINFO, cksize, 1)
    TEST_FIELD_OFFSET(MMCKINFO, cksize, 4)
    TEST_FIELD_SIZE  (MMCKINFO, fccType, 4)
    TEST_FIELD_ALIGN (MMCKINFO, fccType, 1)
    TEST_FIELD_OFFSET(MMCKINFO, fccType, 8)
    TEST_FIELD_SIZE  (MMCKINFO, dwDataOffset, 4)
    TEST_FIELD_ALIGN (MMCKINFO, dwDataOffset, 1)
    TEST_FIELD_OFFSET(MMCKINFO, dwDataOffset, 12)
    TEST_FIELD_SIZE  (MMCKINFO, dwFlags, 4)
    TEST_FIELD_ALIGN (MMCKINFO, dwFlags, 1)
    TEST_FIELD_OFFSET(MMCKINFO, dwFlags, 16)
}

static void test_pack_MCI_GENERIC_PARMS(void)
{
    /* MCI_GENERIC_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_GENERIC_PARMS, 4)
    TEST_TYPE_ALIGN  (MCI_GENERIC_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_GENERIC_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_GENERIC_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_GENERIC_PARMS, dwCallback, 0)
}

static void test_pack_MCI_OPEN_PARMSA(void)
{
    /* MCI_OPEN_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_OPEN_PARMSA, 20)
    TEST_TYPE_ALIGN  (MCI_OPEN_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSA, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSA, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSA, wDeviceID, 4)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSA, lpstrDeviceType, 4)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSA, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSA, lpstrDeviceType, 8)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSA, lpstrElementName, 4)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSA, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSA, lpstrElementName, 12)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSA, lpstrAlias, 4)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSA, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSA, lpstrAlias, 16)
}

static void test_pack_MCI_OPEN_PARMSW(void)
{
    /* MCI_OPEN_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_OPEN_PARMSW, 20)
    TEST_TYPE_ALIGN  (MCI_OPEN_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSW, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSW, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSW, wDeviceID, 4)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSW, lpstrDeviceType, 4)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSW, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSW, lpstrDeviceType, 8)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSW, lpstrElementName, 4)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSW, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSW, lpstrElementName, 12)
    TEST_FIELD_SIZE  (MCI_OPEN_PARMSW, lpstrAlias, 4)
    TEST_FIELD_ALIGN (MCI_OPEN_PARMSW, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_OPEN_PARMSW, lpstrAlias, 16)
}

static void test_pack_MCI_PLAY_PARMS(void)
{
    /* MCI_PLAY_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_PLAY_PARMS, 12)
    TEST_TYPE_ALIGN  (MCI_PLAY_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_PLAY_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_PLAY_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_PLAY_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_PLAY_PARMS, dwFrom, 4)
    TEST_FIELD_ALIGN (MCI_PLAY_PARMS, dwFrom, 1)
    TEST_FIELD_OFFSET(MCI_PLAY_PARMS, dwFrom, 4)
    TEST_FIELD_SIZE  (MCI_PLAY_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_PLAY_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_PLAY_PARMS, dwTo, 8)
}

static void test_pack_MCI_SEEK_PARMS(void)
{
    /* MCI_SEEK_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_SEEK_PARMS, 8)
    TEST_TYPE_ALIGN  (MCI_SEEK_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_SEEK_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_SEEK_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_SEEK_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_SEEK_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_SEEK_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_SEEK_PARMS, dwTo, 4)
}

static void test_pack_MCI_STATUS_PARMS(void)
{
    /* MCI_STATUS_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_STATUS_PARMS, 16)
    TEST_TYPE_ALIGN  (MCI_STATUS_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_STATUS_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_STATUS_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_STATUS_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_STATUS_PARMS, dwReturn, 4)
    TEST_FIELD_ALIGN (MCI_STATUS_PARMS, dwReturn, 1)
    TEST_FIELD_OFFSET(MCI_STATUS_PARMS, dwReturn, 4)
    TEST_FIELD_SIZE  (MCI_STATUS_PARMS, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_STATUS_PARMS, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_STATUS_PARMS, dwItem, 8)
    TEST_FIELD_SIZE  (MCI_STATUS_PARMS, dwTrack, 4)
    TEST_FIELD_ALIGN (MCI_STATUS_PARMS, dwTrack, 1)
    TEST_FIELD_OFFSET(MCI_STATUS_PARMS, dwTrack, 12)
}

static void test_pack_MCI_INFO_PARMSA(void)
{
    /* MCI_INFO_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_INFO_PARMSA, 12)
    TEST_TYPE_ALIGN  (MCI_INFO_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_INFO_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_INFO_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_INFO_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_INFO_PARMSA, lpstrReturn, 4)
    TEST_FIELD_ALIGN (MCI_INFO_PARMSA, lpstrReturn, 1)
    TEST_FIELD_OFFSET(MCI_INFO_PARMSA, lpstrReturn, 4)
    TEST_FIELD_SIZE  (MCI_INFO_PARMSA, dwRetSize, 4)
    TEST_FIELD_ALIGN (MCI_INFO_PARMSA, dwRetSize, 1)
    TEST_FIELD_OFFSET(MCI_INFO_PARMSA, dwRetSize, 8)
}

static void test_pack_MCI_INFO_PARMSW(void)
{
    /* MCI_INFO_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_INFO_PARMSW, 12)
    TEST_TYPE_ALIGN  (MCI_INFO_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_INFO_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_INFO_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_INFO_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_INFO_PARMSW, lpstrReturn, 4)
    TEST_FIELD_ALIGN (MCI_INFO_PARMSW, lpstrReturn, 1)
    TEST_FIELD_OFFSET(MCI_INFO_PARMSW, lpstrReturn, 4)
    TEST_FIELD_SIZE  (MCI_INFO_PARMSW, dwRetSize, 4)
    TEST_FIELD_ALIGN (MCI_INFO_PARMSW, dwRetSize, 1)
    TEST_FIELD_OFFSET(MCI_INFO_PARMSW, dwRetSize, 8)
}

static void test_pack_MCI_GETDEVCAPS_PARMS(void)
{
    /* MCI_GETDEVCAPS_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_GETDEVCAPS_PARMS, 12)
    TEST_TYPE_ALIGN  (MCI_GETDEVCAPS_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_GETDEVCAPS_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_GETDEVCAPS_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_GETDEVCAPS_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_GETDEVCAPS_PARMS, dwReturn, 4)
    TEST_FIELD_ALIGN (MCI_GETDEVCAPS_PARMS, dwReturn, 1)
    TEST_FIELD_OFFSET(MCI_GETDEVCAPS_PARMS, dwReturn, 4)
    TEST_FIELD_SIZE  (MCI_GETDEVCAPS_PARMS, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_GETDEVCAPS_PARMS, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_GETDEVCAPS_PARMS, dwItem, 8)
}

static void test_pack_MCI_SYSINFO_PARMSA(void)
{
    /* MCI_SYSINFO_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_SYSINFO_PARMSA, 20)
    TEST_TYPE_ALIGN  (MCI_SYSINFO_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSA, lpstrReturn, 4)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSA, lpstrReturn, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSA, lpstrReturn, 4)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSA, dwRetSize, 4)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSA, dwRetSize, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSA, dwRetSize, 8)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSA, dwNumber, 4)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSA, dwNumber, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSA, dwNumber, 12)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSA, wDeviceType, 4)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSA, wDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSA, wDeviceType, 16)
}

static void test_pack_MCI_SYSINFO_PARMSW(void)
{
    /* MCI_SYSINFO_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_SYSINFO_PARMSW, 20)
    TEST_TYPE_ALIGN  (MCI_SYSINFO_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSW, lpstrReturn, 4)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSW, lpstrReturn, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSW, lpstrReturn, 4)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSW, dwRetSize, 4)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSW, dwRetSize, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSW, dwRetSize, 8)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSW, dwNumber, 4)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSW, dwNumber, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSW, dwNumber, 12)
    TEST_FIELD_SIZE  (MCI_SYSINFO_PARMSW, wDeviceType, 4)
    TEST_FIELD_ALIGN (MCI_SYSINFO_PARMSW, wDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_SYSINFO_PARMSW, wDeviceType, 16)
}

static void test_pack_MCI_SET_PARMS(void)
{
    /* MCI_SET_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_SET_PARMS, 12)
    TEST_TYPE_ALIGN  (MCI_SET_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_SET_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_SET_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_SET_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_SET_PARMS, dwTimeFormat, 4)
    TEST_FIELD_ALIGN (MCI_SET_PARMS, dwTimeFormat, 1)
    TEST_FIELD_OFFSET(MCI_SET_PARMS, dwTimeFormat, 4)
    TEST_FIELD_SIZE  (MCI_SET_PARMS, dwAudio, 4)
    TEST_FIELD_ALIGN (MCI_SET_PARMS, dwAudio, 1)
    TEST_FIELD_OFFSET(MCI_SET_PARMS, dwAudio, 8)
}

static void test_pack_MCI_BREAK_PARMS(void)
{
    /* MCI_BREAK_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_BREAK_PARMS, 12)
    TEST_TYPE_ALIGN  (MCI_BREAK_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_BREAK_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_BREAK_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_BREAK_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_BREAK_PARMS, nVirtKey, 4)
    TEST_FIELD_ALIGN (MCI_BREAK_PARMS, nVirtKey, 1)
    TEST_FIELD_OFFSET(MCI_BREAK_PARMS, nVirtKey, 4)
    TEST_FIELD_SIZE  (MCI_BREAK_PARMS, hwndBreak, 4)
    TEST_FIELD_ALIGN (MCI_BREAK_PARMS, hwndBreak, 1)
    TEST_FIELD_OFFSET(MCI_BREAK_PARMS, hwndBreak, 8)
}

static void test_pack_MCI_SOUND_PARMSA(void)
{
    /* MCI_SOUND_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_SOUND_PARMSA, 8)
    TEST_TYPE_ALIGN  (MCI_SOUND_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_SOUND_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_SOUND_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_SOUND_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_SOUND_PARMSA, lpstrSoundName, 4)
    TEST_FIELD_ALIGN (MCI_SOUND_PARMSA, lpstrSoundName, 1)
    TEST_FIELD_OFFSET(MCI_SOUND_PARMSA, lpstrSoundName, 4)
}

static void test_pack_MCI_SOUND_PARMSW(void)
{
    /* MCI_SOUND_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_SOUND_PARMSW, 8)
    TEST_TYPE_ALIGN  (MCI_SOUND_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_SOUND_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_SOUND_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_SOUND_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_SOUND_PARMSW, lpstrSoundName, 4)
    TEST_FIELD_ALIGN (MCI_SOUND_PARMSW, lpstrSoundName, 1)
    TEST_FIELD_OFFSET(MCI_SOUND_PARMSW, lpstrSoundName, 4)
}

static void test_pack_MCI_SAVE_PARMSA(void)
{
    /* MCI_SAVE_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_SAVE_PARMSA, 8)
    TEST_TYPE_ALIGN  (MCI_SAVE_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_SAVE_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_SAVE_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_SAVE_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_SAVE_PARMSA, lpfilename, 4)
    TEST_FIELD_ALIGN (MCI_SAVE_PARMSA, lpfilename, 1)
    TEST_FIELD_OFFSET(MCI_SAVE_PARMSA, lpfilename, 4)
}

static void test_pack_MCI_SAVE_PARMSW(void)
{
    /* MCI_SAVE_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_SAVE_PARMSW, 8)
    TEST_TYPE_ALIGN  (MCI_SAVE_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_SAVE_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_SAVE_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_SAVE_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_SAVE_PARMSW, lpfilename, 4)
    TEST_FIELD_ALIGN (MCI_SAVE_PARMSW, lpfilename, 1)
    TEST_FIELD_OFFSET(MCI_SAVE_PARMSW, lpfilename, 4)
}

static void test_pack_MCI_LOAD_PARMSA(void)
{
    /* MCI_LOAD_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_LOAD_PARMSA, 8)
    TEST_TYPE_ALIGN  (MCI_LOAD_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_LOAD_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_LOAD_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_LOAD_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_LOAD_PARMSA, lpfilename, 4)
    TEST_FIELD_ALIGN (MCI_LOAD_PARMSA, lpfilename, 1)
    TEST_FIELD_OFFSET(MCI_LOAD_PARMSA, lpfilename, 4)
}

static void test_pack_MCI_LOAD_PARMSW(void)
{
    /* MCI_LOAD_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_LOAD_PARMSW, 8)
    TEST_TYPE_ALIGN  (MCI_LOAD_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_LOAD_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_LOAD_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_LOAD_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_LOAD_PARMSW, lpfilename, 4)
    TEST_FIELD_ALIGN (MCI_LOAD_PARMSW, lpfilename, 1)
    TEST_FIELD_OFFSET(MCI_LOAD_PARMSW, lpfilename, 4)
}

static void test_pack_MCI_RECORD_PARMS(void)
{
    /* MCI_RECORD_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_RECORD_PARMS, 12)
    TEST_TYPE_ALIGN  (MCI_RECORD_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_RECORD_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_RECORD_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_RECORD_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_RECORD_PARMS, dwFrom, 4)
    TEST_FIELD_ALIGN (MCI_RECORD_PARMS, dwFrom, 1)
    TEST_FIELD_OFFSET(MCI_RECORD_PARMS, dwFrom, 4)
    TEST_FIELD_SIZE  (MCI_RECORD_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_RECORD_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_RECORD_PARMS, dwTo, 8)
}

static void test_pack_MCI_VD_PLAY_PARMS(void)
{
    /* MCI_VD_PLAY_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_VD_PLAY_PARMS, 16)
    TEST_TYPE_ALIGN  (MCI_VD_PLAY_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_VD_PLAY_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_VD_PLAY_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_VD_PLAY_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_VD_PLAY_PARMS, dwFrom, 4)
    TEST_FIELD_ALIGN (MCI_VD_PLAY_PARMS, dwFrom, 1)
    TEST_FIELD_OFFSET(MCI_VD_PLAY_PARMS, dwFrom, 4)
    TEST_FIELD_SIZE  (MCI_VD_PLAY_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_VD_PLAY_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_VD_PLAY_PARMS, dwTo, 8)
    TEST_FIELD_SIZE  (MCI_VD_PLAY_PARMS, dwSpeed, 4)
    TEST_FIELD_ALIGN (MCI_VD_PLAY_PARMS, dwSpeed, 1)
    TEST_FIELD_OFFSET(MCI_VD_PLAY_PARMS, dwSpeed, 12)
}

static void test_pack_MCI_VD_STEP_PARMS(void)
{
    /* MCI_VD_STEP_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_VD_STEP_PARMS, 8)
    TEST_TYPE_ALIGN  (MCI_VD_STEP_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_VD_STEP_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_VD_STEP_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_VD_STEP_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_VD_STEP_PARMS, dwFrames, 4)
    TEST_FIELD_ALIGN (MCI_VD_STEP_PARMS, dwFrames, 1)
    TEST_FIELD_OFFSET(MCI_VD_STEP_PARMS, dwFrames, 4)
}

static void test_pack_MCI_VD_ESCAPE_PARMSA(void)
{
    /* MCI_VD_ESCAPE_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_VD_ESCAPE_PARMSA, 8)
    TEST_TYPE_ALIGN  (MCI_VD_ESCAPE_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_VD_ESCAPE_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_VD_ESCAPE_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_VD_ESCAPE_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_VD_ESCAPE_PARMSA, lpstrCommand, 4)
    TEST_FIELD_ALIGN (MCI_VD_ESCAPE_PARMSA, lpstrCommand, 1)
    TEST_FIELD_OFFSET(MCI_VD_ESCAPE_PARMSA, lpstrCommand, 4)
}

static void test_pack_MCI_VD_ESCAPE_PARMSW(void)
{
    /* MCI_VD_ESCAPE_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_VD_ESCAPE_PARMSW, 8)
    TEST_TYPE_ALIGN  (MCI_VD_ESCAPE_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_VD_ESCAPE_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_VD_ESCAPE_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_VD_ESCAPE_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_VD_ESCAPE_PARMSW, lpstrCommand, 4)
    TEST_FIELD_ALIGN (MCI_VD_ESCAPE_PARMSW, lpstrCommand, 1)
    TEST_FIELD_OFFSET(MCI_VD_ESCAPE_PARMSW, lpstrCommand, 4)
}

static void test_pack_MCI_WAVE_OPEN_PARMSA(void)
{
    /* MCI_WAVE_OPEN_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_WAVE_OPEN_PARMSA, 24)
    TEST_TYPE_ALIGN  (MCI_WAVE_OPEN_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSA, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSA, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSA, wDeviceID, 4)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSA, lpstrDeviceType, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSA, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSA, lpstrDeviceType, 8)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSA, lpstrElementName, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSA, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSA, lpstrElementName, 12)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSA, lpstrAlias, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSA, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSA, lpstrAlias, 16)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSA, dwBufferSeconds, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSA, dwBufferSeconds, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSA, dwBufferSeconds, 20)
}

static void test_pack_MCI_WAVE_OPEN_PARMSW(void)
{
    /* MCI_WAVE_OPEN_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_WAVE_OPEN_PARMSW, 24)
    TEST_TYPE_ALIGN  (MCI_WAVE_OPEN_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSW, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSW, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSW, wDeviceID, 4)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSW, lpstrDeviceType, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSW, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSW, lpstrDeviceType, 8)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSW, lpstrElementName, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSW, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSW, lpstrElementName, 12)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSW, lpstrAlias, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSW, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSW, lpstrAlias, 16)
    TEST_FIELD_SIZE  (MCI_WAVE_OPEN_PARMSW, dwBufferSeconds, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_OPEN_PARMSW, dwBufferSeconds, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_OPEN_PARMSW, dwBufferSeconds, 20)
}

static void test_pack_MCI_WAVE_DELETE_PARMS(void)
{
    /* MCI_WAVE_DELETE_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_WAVE_DELETE_PARMS, 12)
    TEST_TYPE_ALIGN  (MCI_WAVE_DELETE_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_WAVE_DELETE_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_DELETE_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_DELETE_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_WAVE_DELETE_PARMS, dwFrom, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_DELETE_PARMS, dwFrom, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_DELETE_PARMS, dwFrom, 4)
    TEST_FIELD_SIZE  (MCI_WAVE_DELETE_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_DELETE_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_DELETE_PARMS, dwTo, 8)
}

static void test_pack_MCI_WAVE_SET_PARMS(void)
{
    /* MCI_WAVE_SET_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_WAVE_SET_PARMS, 44)
    TEST_TYPE_ALIGN  (MCI_WAVE_SET_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, dwTimeFormat, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, dwTimeFormat, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, dwTimeFormat, 4)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, dwAudio, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, dwAudio, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, dwAudio, 8)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, wInput, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, wInput, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, wInput, 12)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, wOutput, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, wOutput, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, wOutput, 16)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, wFormatTag, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, wFormatTag, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, wFormatTag, 20)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, nChannels, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, nChannels, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, nChannels, 24)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, nSamplesPerSec, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, nSamplesPerSec, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, nSamplesPerSec, 28)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, nAvgBytesPerSec, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, nAvgBytesPerSec, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, nAvgBytesPerSec, 32)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, nBlockAlign, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, nBlockAlign, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, nBlockAlign, 36)
    TEST_FIELD_SIZE  (MCI_WAVE_SET_PARMS, wBitsPerSample, 4)
    TEST_FIELD_ALIGN (MCI_WAVE_SET_PARMS, wBitsPerSample, 1)
    TEST_FIELD_OFFSET(MCI_WAVE_SET_PARMS, wBitsPerSample, 40)
}

static void test_pack_MCI_SEQ_SET_PARMS(void)
{
    /* MCI_SEQ_SET_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_SEQ_SET_PARMS, 32)
    TEST_TYPE_ALIGN  (MCI_SEQ_SET_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_SEQ_SET_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_SEQ_SET_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_SEQ_SET_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_SEQ_SET_PARMS, dwTimeFormat, 4)
    TEST_FIELD_ALIGN (MCI_SEQ_SET_PARMS, dwTimeFormat, 1)
    TEST_FIELD_OFFSET(MCI_SEQ_SET_PARMS, dwTimeFormat, 4)
    TEST_FIELD_SIZE  (MCI_SEQ_SET_PARMS, dwAudio, 4)
    TEST_FIELD_ALIGN (MCI_SEQ_SET_PARMS, dwAudio, 1)
    TEST_FIELD_OFFSET(MCI_SEQ_SET_PARMS, dwAudio, 8)
    TEST_FIELD_SIZE  (MCI_SEQ_SET_PARMS, dwTempo, 4)
    TEST_FIELD_ALIGN (MCI_SEQ_SET_PARMS, dwTempo, 1)
    TEST_FIELD_OFFSET(MCI_SEQ_SET_PARMS, dwTempo, 12)
    TEST_FIELD_SIZE  (MCI_SEQ_SET_PARMS, dwPort, 4)
    TEST_FIELD_ALIGN (MCI_SEQ_SET_PARMS, dwPort, 1)
    TEST_FIELD_OFFSET(MCI_SEQ_SET_PARMS, dwPort, 16)
    TEST_FIELD_SIZE  (MCI_SEQ_SET_PARMS, dwSlave, 4)
    TEST_FIELD_ALIGN (MCI_SEQ_SET_PARMS, dwSlave, 1)
    TEST_FIELD_OFFSET(MCI_SEQ_SET_PARMS, dwSlave, 20)
    TEST_FIELD_SIZE  (MCI_SEQ_SET_PARMS, dwMaster, 4)
    TEST_FIELD_ALIGN (MCI_SEQ_SET_PARMS, dwMaster, 1)
    TEST_FIELD_OFFSET(MCI_SEQ_SET_PARMS, dwMaster, 24)
    TEST_FIELD_SIZE  (MCI_SEQ_SET_PARMS, dwOffset, 4)
    TEST_FIELD_ALIGN (MCI_SEQ_SET_PARMS, dwOffset, 1)
    TEST_FIELD_OFFSET(MCI_SEQ_SET_PARMS, dwOffset, 28)
}

static void test_pack_MCI_ANIM_OPEN_PARMSA(void)
{
    /* MCI_ANIM_OPEN_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_ANIM_OPEN_PARMSA, 28)
    TEST_TYPE_ALIGN  (MCI_ANIM_OPEN_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSA, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSA, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSA, wDeviceID, 4)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSA, lpstrDeviceType, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSA, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSA, lpstrDeviceType, 8)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSA, lpstrElementName, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSA, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSA, lpstrElementName, 12)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSA, lpstrAlias, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSA, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSA, lpstrAlias, 16)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSA, dwStyle, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSA, dwStyle, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSA, dwStyle, 20)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSA, hWndParent, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSA, hWndParent, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSA, hWndParent, 24)
}

static void test_pack_MCI_ANIM_OPEN_PARMSW(void)
{
    /* MCI_ANIM_OPEN_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_ANIM_OPEN_PARMSW, 28)
    TEST_TYPE_ALIGN  (MCI_ANIM_OPEN_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSW, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSW, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSW, wDeviceID, 4)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSW, lpstrDeviceType, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSW, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSW, lpstrDeviceType, 8)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSW, lpstrElementName, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSW, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSW, lpstrElementName, 12)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSW, lpstrAlias, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSW, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSW, lpstrAlias, 16)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSW, dwStyle, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSW, dwStyle, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSW, dwStyle, 20)
    TEST_FIELD_SIZE  (MCI_ANIM_OPEN_PARMSW, hWndParent, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_OPEN_PARMSW, hWndParent, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_OPEN_PARMSW, hWndParent, 24)
}

static void test_pack_MCI_ANIM_PLAY_PARMS(void)
{
    /* MCI_ANIM_PLAY_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_ANIM_PLAY_PARMS, 16)
    TEST_TYPE_ALIGN  (MCI_ANIM_PLAY_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_ANIM_PLAY_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_PLAY_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_PLAY_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_ANIM_PLAY_PARMS, dwFrom, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_PLAY_PARMS, dwFrom, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_PLAY_PARMS, dwFrom, 4)
    TEST_FIELD_SIZE  (MCI_ANIM_PLAY_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_PLAY_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_PLAY_PARMS, dwTo, 8)
    TEST_FIELD_SIZE  (MCI_ANIM_PLAY_PARMS, dwSpeed, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_PLAY_PARMS, dwSpeed, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_PLAY_PARMS, dwSpeed, 12)
}

static void test_pack_MCI_ANIM_STEP_PARMS(void)
{
    /* MCI_ANIM_STEP_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_ANIM_STEP_PARMS, 8)
    TEST_TYPE_ALIGN  (MCI_ANIM_STEP_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_ANIM_STEP_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_STEP_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_STEP_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_ANIM_STEP_PARMS, dwFrames, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_STEP_PARMS, dwFrames, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_STEP_PARMS, dwFrames, 4)
}

static void test_pack_MCI_ANIM_WINDOW_PARMSA(void)
{
    /* MCI_ANIM_WINDOW_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_ANIM_WINDOW_PARMSA, 16)
    TEST_TYPE_ALIGN  (MCI_ANIM_WINDOW_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_ANIM_WINDOW_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_WINDOW_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_WINDOW_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_ANIM_WINDOW_PARMSA, hWnd, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_WINDOW_PARMSA, hWnd, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_WINDOW_PARMSA, hWnd, 4)
    TEST_FIELD_SIZE  (MCI_ANIM_WINDOW_PARMSA, nCmdShow, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_WINDOW_PARMSA, nCmdShow, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_WINDOW_PARMSA, nCmdShow, 8)
    TEST_FIELD_SIZE  (MCI_ANIM_WINDOW_PARMSA, lpstrText, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_WINDOW_PARMSA, lpstrText, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_WINDOW_PARMSA, lpstrText, 12)
}

static void test_pack_MCI_ANIM_WINDOW_PARMSW(void)
{
    /* MCI_ANIM_WINDOW_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_ANIM_WINDOW_PARMSW, 16)
    TEST_TYPE_ALIGN  (MCI_ANIM_WINDOW_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_ANIM_WINDOW_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_WINDOW_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_WINDOW_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_ANIM_WINDOW_PARMSW, hWnd, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_WINDOW_PARMSW, hWnd, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_WINDOW_PARMSW, hWnd, 4)
    TEST_FIELD_SIZE  (MCI_ANIM_WINDOW_PARMSW, nCmdShow, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_WINDOW_PARMSW, nCmdShow, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_WINDOW_PARMSW, nCmdShow, 8)
    TEST_FIELD_SIZE  (MCI_ANIM_WINDOW_PARMSW, lpstrText, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_WINDOW_PARMSW, lpstrText, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_WINDOW_PARMSW, lpstrText, 12)
}

static void test_pack_MCI_ANIM_UPDATE_PARMS(void)
{
    /* MCI_ANIM_UPDATE_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_ANIM_UPDATE_PARMS, 24)
    TEST_TYPE_ALIGN  (MCI_ANIM_UPDATE_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_ANIM_UPDATE_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_UPDATE_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_UPDATE_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_ANIM_UPDATE_PARMS, rc, 16)
    TEST_FIELD_ALIGN (MCI_ANIM_UPDATE_PARMS, rc, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_UPDATE_PARMS, rc, 4)
    TEST_FIELD_SIZE  (MCI_ANIM_UPDATE_PARMS, hDC, 4)
    TEST_FIELD_ALIGN (MCI_ANIM_UPDATE_PARMS, hDC, 1)
    TEST_FIELD_OFFSET(MCI_ANIM_UPDATE_PARMS, hDC, 20)
}

static void test_pack_MCI_OVLY_OPEN_PARMSA(void)
{
    /* MCI_OVLY_OPEN_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_OVLY_OPEN_PARMSA, 28)
    TEST_TYPE_ALIGN  (MCI_OVLY_OPEN_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSA, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSA, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSA, wDeviceID, 4)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSA, lpstrDeviceType, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSA, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSA, lpstrDeviceType, 8)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSA, lpstrElementName, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSA, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSA, lpstrElementName, 12)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSA, lpstrAlias, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSA, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSA, lpstrAlias, 16)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSA, dwStyle, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSA, dwStyle, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSA, dwStyle, 20)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSA, hWndParent, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSA, hWndParent, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSA, hWndParent, 24)
}

static void test_pack_MCI_OVLY_OPEN_PARMSW(void)
{
    /* MCI_OVLY_OPEN_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_OVLY_OPEN_PARMSW, 28)
    TEST_TYPE_ALIGN  (MCI_OVLY_OPEN_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSW, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSW, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSW, wDeviceID, 4)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSW, lpstrDeviceType, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSW, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSW, lpstrDeviceType, 8)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSW, lpstrElementName, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSW, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSW, lpstrElementName, 12)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSW, lpstrAlias, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSW, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSW, lpstrAlias, 16)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSW, dwStyle, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSW, dwStyle, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSW, dwStyle, 20)
    TEST_FIELD_SIZE  (MCI_OVLY_OPEN_PARMSW, hWndParent, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_OPEN_PARMSW, hWndParent, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_OPEN_PARMSW, hWndParent, 24)
}

static void test_pack_MCI_OVLY_WINDOW_PARMSA(void)
{
    /* MCI_OVLY_WINDOW_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_OVLY_WINDOW_PARMSA, 16)
    TEST_TYPE_ALIGN  (MCI_OVLY_WINDOW_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_OVLY_WINDOW_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_WINDOW_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_WINDOW_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OVLY_WINDOW_PARMSA, hWnd, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_WINDOW_PARMSA, hWnd, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_WINDOW_PARMSA, hWnd, 4)
    TEST_FIELD_SIZE  (MCI_OVLY_WINDOW_PARMSA, nCmdShow, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_WINDOW_PARMSA, nCmdShow, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_WINDOW_PARMSA, nCmdShow, 8)
    TEST_FIELD_SIZE  (MCI_OVLY_WINDOW_PARMSA, lpstrText, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_WINDOW_PARMSA, lpstrText, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_WINDOW_PARMSA, lpstrText, 12)
}

static void test_pack_MCI_OVLY_WINDOW_PARMSW(void)
{
    /* MCI_OVLY_WINDOW_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_OVLY_WINDOW_PARMSW, 16)
    TEST_TYPE_ALIGN  (MCI_OVLY_WINDOW_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_OVLY_WINDOW_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_WINDOW_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_WINDOW_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OVLY_WINDOW_PARMSW, hWnd, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_WINDOW_PARMSW, hWnd, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_WINDOW_PARMSW, hWnd, 4)
    TEST_FIELD_SIZE  (MCI_OVLY_WINDOW_PARMSW, nCmdShow, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_WINDOW_PARMSW, nCmdShow, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_WINDOW_PARMSW, nCmdShow, 8)
    TEST_FIELD_SIZE  (MCI_OVLY_WINDOW_PARMSW, lpstrText, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_WINDOW_PARMSW, lpstrText, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_WINDOW_PARMSW, lpstrText, 12)
}

static void test_pack_MCI_OVLY_SAVE_PARMSA(void)
{
    /* MCI_OVLY_SAVE_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_OVLY_SAVE_PARMSA, 24)
    TEST_TYPE_ALIGN  (MCI_OVLY_SAVE_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_OVLY_SAVE_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_SAVE_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_SAVE_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OVLY_SAVE_PARMSA, lpfilename, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_SAVE_PARMSA, lpfilename, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_SAVE_PARMSA, lpfilename, 4)
    TEST_FIELD_SIZE  (MCI_OVLY_SAVE_PARMSA, rc, 16)
    TEST_FIELD_ALIGN (MCI_OVLY_SAVE_PARMSA, rc, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_SAVE_PARMSA, rc, 8)
}

static void test_pack_MCI_OVLY_SAVE_PARMSW(void)
{
    /* MCI_OVLY_SAVE_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_OVLY_SAVE_PARMSW, 24)
    TEST_TYPE_ALIGN  (MCI_OVLY_SAVE_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_OVLY_SAVE_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_SAVE_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_SAVE_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OVLY_SAVE_PARMSW, lpfilename, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_SAVE_PARMSW, lpfilename, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_SAVE_PARMSW, lpfilename, 4)
    TEST_FIELD_SIZE  (MCI_OVLY_SAVE_PARMSW, rc, 16)
    TEST_FIELD_ALIGN (MCI_OVLY_SAVE_PARMSW, rc, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_SAVE_PARMSW, rc, 8)
}

static void test_pack_MCI_OVLY_LOAD_PARMSA(void)
{
    /* MCI_OVLY_LOAD_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_OVLY_LOAD_PARMSA, 24)
    TEST_TYPE_ALIGN  (MCI_OVLY_LOAD_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_OVLY_LOAD_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_LOAD_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_LOAD_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OVLY_LOAD_PARMSA, lpfilename, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_LOAD_PARMSA, lpfilename, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_LOAD_PARMSA, lpfilename, 4)
    TEST_FIELD_SIZE  (MCI_OVLY_LOAD_PARMSA, rc, 16)
    TEST_FIELD_ALIGN (MCI_OVLY_LOAD_PARMSA, rc, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_LOAD_PARMSA, rc, 8)
}

static void test_pack_MCI_OVLY_LOAD_PARMSW(void)
{
    /* MCI_OVLY_LOAD_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_OVLY_LOAD_PARMSW, 24)
    TEST_TYPE_ALIGN  (MCI_OVLY_LOAD_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_OVLY_LOAD_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_LOAD_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_LOAD_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_OVLY_LOAD_PARMSW, lpfilename, 4)
    TEST_FIELD_ALIGN (MCI_OVLY_LOAD_PARMSW, lpfilename, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_LOAD_PARMSW, lpfilename, 4)
    TEST_FIELD_SIZE  (MCI_OVLY_LOAD_PARMSW, rc, 16)
    TEST_FIELD_ALIGN (MCI_OVLY_LOAD_PARMSW, rc, 1)
    TEST_FIELD_OFFSET(MCI_OVLY_LOAD_PARMSW, rc, 8)
}

static void test_pack_MCI_DGV_RECT_PARMS(void)
{
    /* MCI_DGV_RECT_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_RECT_PARMS, 20)
    TEST_TYPE_ALIGN  (MCI_DGV_RECT_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_RECT_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RECT_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RECT_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_RECT_PARMS, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_RECT_PARMS, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RECT_PARMS, rc, 4)
}

static void test_pack_MCI_DGV_CAPTURE_PARMSA(void)
{
    /* MCI_DGV_CAPTURE_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_CAPTURE_PARMSA, 24)
    TEST_TYPE_ALIGN  (MCI_DGV_CAPTURE_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_CAPTURE_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_CAPTURE_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CAPTURE_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_CAPTURE_PARMSA, lpstrFileName, 4)
    TEST_FIELD_ALIGN (MCI_DGV_CAPTURE_PARMSA, lpstrFileName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CAPTURE_PARMSA, lpstrFileName, 4)
    TEST_FIELD_SIZE  (MCI_DGV_CAPTURE_PARMSA, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_CAPTURE_PARMSA, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CAPTURE_PARMSA, rc, 8)
}

static void test_pack_MCI_DGV_CAPTURE_PARMSW(void)
{
    /* MCI_DGV_CAPTURE_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_CAPTURE_PARMSW, 24)
    TEST_TYPE_ALIGN  (MCI_DGV_CAPTURE_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_CAPTURE_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_CAPTURE_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CAPTURE_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_CAPTURE_PARMSW, lpstrFileName, 4)
    TEST_FIELD_ALIGN (MCI_DGV_CAPTURE_PARMSW, lpstrFileName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CAPTURE_PARMSW, lpstrFileName, 4)
    TEST_FIELD_SIZE  (MCI_DGV_CAPTURE_PARMSW, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_CAPTURE_PARMSW, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CAPTURE_PARMSW, rc, 8)
}

static void test_pack_MCI_DGV_COPY_PARMS(void)
{
    /* MCI_DGV_COPY_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_COPY_PARMS, 36)
    TEST_TYPE_ALIGN  (MCI_DGV_COPY_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_COPY_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_COPY_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_COPY_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_COPY_PARMS, dwFrom, 4)
    TEST_FIELD_ALIGN (MCI_DGV_COPY_PARMS, dwFrom, 1)
    TEST_FIELD_OFFSET(MCI_DGV_COPY_PARMS, dwFrom, 4)
    TEST_FIELD_SIZE  (MCI_DGV_COPY_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_DGV_COPY_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_DGV_COPY_PARMS, dwTo, 8)
    TEST_FIELD_SIZE  (MCI_DGV_COPY_PARMS, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_COPY_PARMS, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_COPY_PARMS, rc, 12)
    TEST_FIELD_SIZE  (MCI_DGV_COPY_PARMS, dwAudioStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_COPY_PARMS, dwAudioStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_COPY_PARMS, dwAudioStream, 28)
    TEST_FIELD_SIZE  (MCI_DGV_COPY_PARMS, dwVideoStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_COPY_PARMS, dwVideoStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_COPY_PARMS, dwVideoStream, 32)
}

static void test_pack_MCI_DGV_CUE_PARMS(void)
{
    /* MCI_DGV_CUE_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_CUE_PARMS, 8)
    TEST_TYPE_ALIGN  (MCI_DGV_CUE_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_CUE_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_CUE_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CUE_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_CUE_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_DGV_CUE_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CUE_PARMS, dwTo, 4)
}

static void test_pack_MCI_DGV_CUT_PARMS(void)
{
    /* MCI_DGV_CUT_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_CUT_PARMS, 36)
    TEST_TYPE_ALIGN  (MCI_DGV_CUT_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_CUT_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_CUT_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CUT_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_CUT_PARMS, dwFrom, 4)
    TEST_FIELD_ALIGN (MCI_DGV_CUT_PARMS, dwFrom, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CUT_PARMS, dwFrom, 4)
    TEST_FIELD_SIZE  (MCI_DGV_CUT_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_DGV_CUT_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CUT_PARMS, dwTo, 8)
    TEST_FIELD_SIZE  (MCI_DGV_CUT_PARMS, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_CUT_PARMS, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CUT_PARMS, rc, 12)
    TEST_FIELD_SIZE  (MCI_DGV_CUT_PARMS, dwAudioStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_CUT_PARMS, dwAudioStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CUT_PARMS, dwAudioStream, 28)
    TEST_FIELD_SIZE  (MCI_DGV_CUT_PARMS, dwVideoStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_CUT_PARMS, dwVideoStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_CUT_PARMS, dwVideoStream, 32)
}

static void test_pack_MCI_DGV_DELETE_PARMS(void)
{
    /* MCI_DGV_DELETE_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_DELETE_PARMS, 36)
    TEST_TYPE_ALIGN  (MCI_DGV_DELETE_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_DELETE_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_DELETE_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_DELETE_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_DELETE_PARMS, dwFrom, 4)
    TEST_FIELD_ALIGN (MCI_DGV_DELETE_PARMS, dwFrom, 1)
    TEST_FIELD_OFFSET(MCI_DGV_DELETE_PARMS, dwFrom, 4)
    TEST_FIELD_SIZE  (MCI_DGV_DELETE_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_DGV_DELETE_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_DGV_DELETE_PARMS, dwTo, 8)
    TEST_FIELD_SIZE  (MCI_DGV_DELETE_PARMS, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_DELETE_PARMS, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_DELETE_PARMS, rc, 12)
    TEST_FIELD_SIZE  (MCI_DGV_DELETE_PARMS, dwAudioStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_DELETE_PARMS, dwAudioStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_DELETE_PARMS, dwAudioStream, 28)
    TEST_FIELD_SIZE  (MCI_DGV_DELETE_PARMS, dwVideoStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_DELETE_PARMS, dwVideoStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_DELETE_PARMS, dwVideoStream, 32)
}

static void test_pack_MCI_DGV_INFO_PARMSA(void)
{
    /* MCI_DGV_INFO_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_INFO_PARMSA, 16)
    TEST_TYPE_ALIGN  (MCI_DGV_INFO_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_INFO_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_INFO_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_INFO_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_INFO_PARMSA, lpstrReturn, 4)
    TEST_FIELD_ALIGN (MCI_DGV_INFO_PARMSA, lpstrReturn, 1)
    TEST_FIELD_OFFSET(MCI_DGV_INFO_PARMSA, lpstrReturn, 4)
    TEST_FIELD_SIZE  (MCI_DGV_INFO_PARMSA, dwRetSize, 4)
    TEST_FIELD_ALIGN (MCI_DGV_INFO_PARMSA, dwRetSize, 1)
    TEST_FIELD_OFFSET(MCI_DGV_INFO_PARMSA, dwRetSize, 8)
    TEST_FIELD_SIZE  (MCI_DGV_INFO_PARMSA, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_INFO_PARMSA, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_INFO_PARMSA, dwItem, 12)
}

static void test_pack_MCI_DGV_INFO_PARMSW(void)
{
    /* MCI_DGV_INFO_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_INFO_PARMSW, 16)
    TEST_TYPE_ALIGN  (MCI_DGV_INFO_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_INFO_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_INFO_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_INFO_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_INFO_PARMSW, lpstrReturn, 4)
    TEST_FIELD_ALIGN (MCI_DGV_INFO_PARMSW, lpstrReturn, 1)
    TEST_FIELD_OFFSET(MCI_DGV_INFO_PARMSW, lpstrReturn, 4)
    TEST_FIELD_SIZE  (MCI_DGV_INFO_PARMSW, dwRetSize, 4)
    TEST_FIELD_ALIGN (MCI_DGV_INFO_PARMSW, dwRetSize, 1)
    TEST_FIELD_OFFSET(MCI_DGV_INFO_PARMSW, dwRetSize, 8)
    TEST_FIELD_SIZE  (MCI_DGV_INFO_PARMSW, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_INFO_PARMSW, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_INFO_PARMSW, dwItem, 12)
}

static void test_pack_MCI_DGV_LIST_PARMSA(void)
{
    /* MCI_DGV_LIST_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_LIST_PARMSA, 24)
    TEST_TYPE_ALIGN  (MCI_DGV_LIST_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSA, lpstrReturn, 4)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSA, lpstrReturn, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSA, lpstrReturn, 4)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSA, dwLength, 4)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSA, dwLength, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSA, dwLength, 8)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSA, dwNumber, 4)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSA, dwNumber, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSA, dwNumber, 12)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSA, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSA, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSA, dwItem, 16)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSA, lpstrAlgorithm, 4)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSA, lpstrAlgorithm, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSA, lpstrAlgorithm, 20)
}

static void test_pack_MCI_DGV_LIST_PARMSW(void)
{
    /* MCI_DGV_LIST_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_LIST_PARMSW, 24)
    TEST_TYPE_ALIGN  (MCI_DGV_LIST_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSW, lpstrReturn, 4)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSW, lpstrReturn, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSW, lpstrReturn, 4)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSW, dwLength, 4)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSW, dwLength, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSW, dwLength, 8)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSW, dwNumber, 4)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSW, dwNumber, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSW, dwNumber, 12)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSW, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSW, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSW, dwItem, 16)
    TEST_FIELD_SIZE  (MCI_DGV_LIST_PARMSW, lpstrAlgorithm, 4)
    TEST_FIELD_ALIGN (MCI_DGV_LIST_PARMSW, lpstrAlgorithm, 1)
    TEST_FIELD_OFFSET(MCI_DGV_LIST_PARMSW, lpstrAlgorithm, 20)
}

static void test_pack_MCI_DGV_MONITOR_PARMS(void)
{
    /* MCI_DGV_MONITOR_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_MONITOR_PARMS, 12)
    TEST_TYPE_ALIGN  (MCI_DGV_MONITOR_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_MONITOR_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_MONITOR_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_MONITOR_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_MONITOR_PARMS, dwSource, 4)
    TEST_FIELD_ALIGN (MCI_DGV_MONITOR_PARMS, dwSource, 1)
    TEST_FIELD_OFFSET(MCI_DGV_MONITOR_PARMS, dwSource, 4)
    TEST_FIELD_SIZE  (MCI_DGV_MONITOR_PARMS, dwMethod, 4)
    TEST_FIELD_ALIGN (MCI_DGV_MONITOR_PARMS, dwMethod, 1)
    TEST_FIELD_OFFSET(MCI_DGV_MONITOR_PARMS, dwMethod, 8)
}

static void test_pack_MCI_DGV_OPEN_PARMSA(void)
{
    /* MCI_DGV_OPEN_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_OPEN_PARMSA, 28)
    TEST_TYPE_ALIGN  (MCI_DGV_OPEN_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSA, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSA, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSA, wDeviceID, 4)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSA, lpstrDeviceType, 4)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSA, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSA, lpstrDeviceType, 8)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSA, lpstrElementName, 4)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSA, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSA, lpstrElementName, 12)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSA, lpstrAlias, 4)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSA, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSA, lpstrAlias, 16)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSA, dwStyle, 4)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSA, dwStyle, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSA, dwStyle, 20)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSA, hWndParent, 4)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSA, hWndParent, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSA, hWndParent, 24)
}

static void test_pack_MCI_DGV_OPEN_PARMSW(void)
{
    /* MCI_DGV_OPEN_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_OPEN_PARMSW, 28)
    TEST_TYPE_ALIGN  (MCI_DGV_OPEN_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSW, wDeviceID, 4)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSW, wDeviceID, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSW, wDeviceID, 4)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSW, lpstrDeviceType, 4)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSW, lpstrDeviceType, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSW, lpstrDeviceType, 8)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSW, lpstrElementName, 4)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSW, lpstrElementName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSW, lpstrElementName, 12)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSW, lpstrAlias, 4)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSW, lpstrAlias, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSW, lpstrAlias, 16)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSW, dwStyle, 4)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSW, dwStyle, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSW, dwStyle, 20)
    TEST_FIELD_SIZE  (MCI_DGV_OPEN_PARMSW, hWndParent, 4)
    TEST_FIELD_ALIGN (MCI_DGV_OPEN_PARMSW, hWndParent, 1)
    TEST_FIELD_OFFSET(MCI_DGV_OPEN_PARMSW, hWndParent, 24)
}

static void test_pack_MCI_DGV_PASTE_PARMS(void)
{
    /* MCI_DGV_PASTE_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_PASTE_PARMS, 32)
    TEST_TYPE_ALIGN  (MCI_DGV_PASTE_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_PASTE_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_PASTE_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_PASTE_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_PASTE_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_DGV_PASTE_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_DGV_PASTE_PARMS, dwTo, 4)
    TEST_FIELD_SIZE  (MCI_DGV_PASTE_PARMS, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_PASTE_PARMS, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_PASTE_PARMS, rc, 8)
    TEST_FIELD_SIZE  (MCI_DGV_PASTE_PARMS, dwAudioStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_PASTE_PARMS, dwAudioStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_PASTE_PARMS, dwAudioStream, 24)
    TEST_FIELD_SIZE  (MCI_DGV_PASTE_PARMS, dwVideoStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_PASTE_PARMS, dwVideoStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_PASTE_PARMS, dwVideoStream, 28)
}

static void test_pack_MCI_DGV_QUALITY_PARMSA(void)
{
    /* MCI_DGV_QUALITY_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_QUALITY_PARMSA, 20)
    TEST_TYPE_ALIGN  (MCI_DGV_QUALITY_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSA, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSA, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSA, dwItem, 4)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSA, lpstrName, 4)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSA, lpstrName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSA, lpstrName, 8)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSA, lpstrAlgorithm, 4)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSA, lpstrAlgorithm, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSA, lpstrAlgorithm, 12)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSA, dwHandle, 4)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSA, dwHandle, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSA, dwHandle, 16)
}

static void test_pack_MCI_DGV_QUALITY_PARMSW(void)
{
    /* MCI_DGV_QUALITY_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_QUALITY_PARMSW, 20)
    TEST_TYPE_ALIGN  (MCI_DGV_QUALITY_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSW, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSW, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSW, dwItem, 4)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSW, lpstrName, 4)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSW, lpstrName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSW, lpstrName, 8)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSW, lpstrAlgorithm, 4)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSW, lpstrAlgorithm, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSW, lpstrAlgorithm, 12)
    TEST_FIELD_SIZE  (MCI_DGV_QUALITY_PARMSW, dwHandle, 4)
    TEST_FIELD_ALIGN (MCI_DGV_QUALITY_PARMSW, dwHandle, 1)
    TEST_FIELD_OFFSET(MCI_DGV_QUALITY_PARMSW, dwHandle, 16)
}

static void test_pack_MCI_DGV_RECORD_PARMS(void)
{
    /* MCI_DGV_RECORD_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_RECORD_PARMS, 36)
    TEST_TYPE_ALIGN  (MCI_DGV_RECORD_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_RECORD_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RECORD_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RECORD_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_RECORD_PARMS, dwFrom, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RECORD_PARMS, dwFrom, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RECORD_PARMS, dwFrom, 4)
    TEST_FIELD_SIZE  (MCI_DGV_RECORD_PARMS, dwTo, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RECORD_PARMS, dwTo, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RECORD_PARMS, dwTo, 8)
    TEST_FIELD_SIZE  (MCI_DGV_RECORD_PARMS, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_RECORD_PARMS, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RECORD_PARMS, rc, 12)
    TEST_FIELD_SIZE  (MCI_DGV_RECORD_PARMS, dwAudioStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RECORD_PARMS, dwAudioStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RECORD_PARMS, dwAudioStream, 28)
    TEST_FIELD_SIZE  (MCI_DGV_RECORD_PARMS, dwVideoStream, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RECORD_PARMS, dwVideoStream, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RECORD_PARMS, dwVideoStream, 32)
}

static void test_pack_MCI_DGV_RESERVE_PARMSA(void)
{
    /* MCI_DGV_RESERVE_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_RESERVE_PARMSA, 12)
    TEST_TYPE_ALIGN  (MCI_DGV_RESERVE_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_RESERVE_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RESERVE_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESERVE_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_RESERVE_PARMSA, lpstrPath, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RESERVE_PARMSA, lpstrPath, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESERVE_PARMSA, lpstrPath, 4)
    TEST_FIELD_SIZE  (MCI_DGV_RESERVE_PARMSA, dwSize, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RESERVE_PARMSA, dwSize, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESERVE_PARMSA, dwSize, 8)
}

static void test_pack_MCI_DGV_RESERVE_PARMSW(void)
{
    /* MCI_DGV_RESERVE_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_RESERVE_PARMSW, 12)
    TEST_TYPE_ALIGN  (MCI_DGV_RESERVE_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_RESERVE_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RESERVE_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESERVE_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_RESERVE_PARMSW, lpstrPath, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RESERVE_PARMSW, lpstrPath, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESERVE_PARMSW, lpstrPath, 4)
    TEST_FIELD_SIZE  (MCI_DGV_RESERVE_PARMSW, dwSize, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RESERVE_PARMSW, dwSize, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESERVE_PARMSW, dwSize, 8)
}

static void test_pack_MCI_DGV_RESTORE_PARMSA(void)
{
    /* MCI_DGV_RESTORE_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_RESTORE_PARMSA, 24)
    TEST_TYPE_ALIGN  (MCI_DGV_RESTORE_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_RESTORE_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RESTORE_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESTORE_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_RESTORE_PARMSA, lpstrFileName, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RESTORE_PARMSA, lpstrFileName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESTORE_PARMSA, lpstrFileName, 4)
    TEST_FIELD_SIZE  (MCI_DGV_RESTORE_PARMSA, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_RESTORE_PARMSA, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESTORE_PARMSA, rc, 8)
}

static void test_pack_MCI_DGV_RESTORE_PARMSW(void)
{
    /* MCI_DGV_RESTORE_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_RESTORE_PARMSW, 24)
    TEST_TYPE_ALIGN  (MCI_DGV_RESTORE_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_RESTORE_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RESTORE_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESTORE_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_RESTORE_PARMSW, lpstrFileName, 4)
    TEST_FIELD_ALIGN (MCI_DGV_RESTORE_PARMSW, lpstrFileName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESTORE_PARMSW, lpstrFileName, 4)
    TEST_FIELD_SIZE  (MCI_DGV_RESTORE_PARMSW, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_RESTORE_PARMSW, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_RESTORE_PARMSW, rc, 8)
}

static void test_pack_MCI_DGV_SAVE_PARMSA(void)
{
    /* MCI_DGV_SAVE_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_SAVE_PARMSA, 24)
    TEST_TYPE_ALIGN  (MCI_DGV_SAVE_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_SAVE_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SAVE_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SAVE_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_SAVE_PARMSA, lpstrFileName, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SAVE_PARMSA, lpstrFileName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SAVE_PARMSA, lpstrFileName, 4)
    TEST_FIELD_SIZE  (MCI_DGV_SAVE_PARMSA, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_SAVE_PARMSA, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SAVE_PARMSA, rc, 8)
}

static void test_pack_MCI_DGV_SAVE_PARMSW(void)
{
    /* MCI_DGV_SAVE_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_SAVE_PARMSW, 24)
    TEST_TYPE_ALIGN  (MCI_DGV_SAVE_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_SAVE_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SAVE_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SAVE_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_SAVE_PARMSW, lpstrFileName, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SAVE_PARMSW, lpstrFileName, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SAVE_PARMSW, lpstrFileName, 4)
    TEST_FIELD_SIZE  (MCI_DGV_SAVE_PARMSW, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_SAVE_PARMSW, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SAVE_PARMSW, rc, 8)
}

static void test_pack_MCI_DGV_SET_PARMS(void)
{
    /* MCI_DGV_SET_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_SET_PARMS, 20)
    TEST_TYPE_ALIGN  (MCI_DGV_SET_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_SET_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SET_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SET_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_SET_PARMS, dwTimeFormat, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SET_PARMS, dwTimeFormat, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SET_PARMS, dwTimeFormat, 4)
    TEST_FIELD_SIZE  (MCI_DGV_SET_PARMS, dwAudio, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SET_PARMS, dwAudio, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SET_PARMS, dwAudio, 8)
    TEST_FIELD_SIZE  (MCI_DGV_SET_PARMS, dwFileFormat, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SET_PARMS, dwFileFormat, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SET_PARMS, dwFileFormat, 12)
    TEST_FIELD_SIZE  (MCI_DGV_SET_PARMS, dwSpeed, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SET_PARMS, dwSpeed, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SET_PARMS, dwSpeed, 16)
}

static void test_pack_MCI_DGV_SETAUDIO_PARMSA(void)
{
    /* MCI_DGV_SETAUDIO_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_SETAUDIO_PARMSA, 24)
    TEST_TYPE_ALIGN  (MCI_DGV_SETAUDIO_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSA, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSA, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSA, dwItem, 4)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSA, dwValue, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSA, dwValue, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSA, dwValue, 8)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSA, dwOver, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSA, dwOver, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSA, dwOver, 12)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSA, lpstrAlgorithm, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSA, lpstrAlgorithm, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSA, lpstrAlgorithm, 16)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSA, lpstrQuality, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSA, lpstrQuality, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSA, lpstrQuality, 20)
}

static void test_pack_MCI_DGV_SETAUDIO_PARMSW(void)
{
    /* MCI_DGV_SETAUDIO_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_SETAUDIO_PARMSW, 24)
    TEST_TYPE_ALIGN  (MCI_DGV_SETAUDIO_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSW, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSW, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSW, dwItem, 4)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSW, dwValue, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSW, dwValue, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSW, dwValue, 8)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSW, dwOver, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSW, dwOver, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSW, dwOver, 12)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSW, lpstrAlgorithm, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSW, lpstrAlgorithm, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSW, lpstrAlgorithm, 16)
    TEST_FIELD_SIZE  (MCI_DGV_SETAUDIO_PARMSW, lpstrQuality, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETAUDIO_PARMSW, lpstrQuality, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETAUDIO_PARMSW, lpstrQuality, 20)
}

static void test_pack_MCI_DGV_SIGNAL_PARMS(void)
{
    /* MCI_DGV_SIGNAL_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_SIGNAL_PARMS, 16)
    TEST_TYPE_ALIGN  (MCI_DGV_SIGNAL_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_SIGNAL_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SIGNAL_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SIGNAL_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_SIGNAL_PARMS, dwPosition, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SIGNAL_PARMS, dwPosition, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SIGNAL_PARMS, dwPosition, 4)
    TEST_FIELD_SIZE  (MCI_DGV_SIGNAL_PARMS, dwPeriod, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SIGNAL_PARMS, dwPeriod, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SIGNAL_PARMS, dwPeriod, 8)
    TEST_FIELD_SIZE  (MCI_DGV_SIGNAL_PARMS, dwUserParm, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SIGNAL_PARMS, dwUserParm, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SIGNAL_PARMS, dwUserParm, 12)
}

static void test_pack_MCI_DGV_SETVIDEO_PARMSA(void)
{
    /* MCI_DGV_SETVIDEO_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_SETVIDEO_PARMSA, 28)
    TEST_TYPE_ALIGN  (MCI_DGV_SETVIDEO_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSA, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSA, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSA, dwItem, 4)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSA, dwValue, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSA, dwValue, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSA, dwValue, 8)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSA, dwOver, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSA, dwOver, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSA, dwOver, 12)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSA, lpstrAlgorithm, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSA, lpstrAlgorithm, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSA, lpstrAlgorithm, 16)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSA, lpstrQuality, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSA, lpstrQuality, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSA, lpstrQuality, 20)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSA, dwSourceNumber, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSA, dwSourceNumber, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSA, dwSourceNumber, 24)
}

static void test_pack_MCI_DGV_SETVIDEO_PARMSW(void)
{
    /* MCI_DGV_SETVIDEO_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_SETVIDEO_PARMSW, 28)
    TEST_TYPE_ALIGN  (MCI_DGV_SETVIDEO_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSW, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSW, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSW, dwItem, 4)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSW, dwValue, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSW, dwValue, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSW, dwValue, 8)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSW, dwOver, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSW, dwOver, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSW, dwOver, 12)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSW, lpstrAlgorithm, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSW, lpstrAlgorithm, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSW, lpstrAlgorithm, 16)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSW, lpstrQuality, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSW, lpstrQuality, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSW, lpstrQuality, 20)
    TEST_FIELD_SIZE  (MCI_DGV_SETVIDEO_PARMSW, dwSourceNumber, 4)
    TEST_FIELD_ALIGN (MCI_DGV_SETVIDEO_PARMSW, dwSourceNumber, 1)
    TEST_FIELD_OFFSET(MCI_DGV_SETVIDEO_PARMSW, dwSourceNumber, 24)
}

static void test_pack_MCI_DGV_STATUS_PARMSA(void)
{
    /* MCI_DGV_STATUS_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_STATUS_PARMSA, 24)
    TEST_TYPE_ALIGN  (MCI_DGV_STATUS_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSA, dwReturn, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSA, dwReturn, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSA, dwReturn, 4)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSA, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSA, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSA, dwItem, 8)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSA, dwTrack, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSA, dwTrack, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSA, dwTrack, 12)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSA, lpstrDrive, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSA, lpstrDrive, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSA, lpstrDrive, 16)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSA, dwReference, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSA, dwReference, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSA, dwReference, 20)
}

static void test_pack_MCI_DGV_STATUS_PARMSW(void)
{
    /* MCI_DGV_STATUS_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_STATUS_PARMSW, 24)
    TEST_TYPE_ALIGN  (MCI_DGV_STATUS_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSW, dwReturn, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSW, dwReturn, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSW, dwReturn, 4)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSW, dwItem, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSW, dwItem, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSW, dwItem, 8)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSW, dwTrack, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSW, dwTrack, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSW, dwTrack, 12)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSW, lpstrDrive, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSW, lpstrDrive, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSW, lpstrDrive, 16)
    TEST_FIELD_SIZE  (MCI_DGV_STATUS_PARMSW, dwReference, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STATUS_PARMSW, dwReference, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STATUS_PARMSW, dwReference, 20)
}

static void test_pack_MCI_DGV_STEP_PARMS(void)
{
    /* MCI_DGV_STEP_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_STEP_PARMS, 8)
    TEST_TYPE_ALIGN  (MCI_DGV_STEP_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_STEP_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STEP_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STEP_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_STEP_PARMS, dwFrames, 4)
    TEST_FIELD_ALIGN (MCI_DGV_STEP_PARMS, dwFrames, 1)
    TEST_FIELD_OFFSET(MCI_DGV_STEP_PARMS, dwFrames, 4)
}

static void test_pack_MCI_DGV_UPDATE_PARMS(void)
{
    /* MCI_DGV_UPDATE_PARMS (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_UPDATE_PARMS, 24)
    TEST_TYPE_ALIGN  (MCI_DGV_UPDATE_PARMS, 1)
    TEST_FIELD_SIZE  (MCI_DGV_UPDATE_PARMS, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_UPDATE_PARMS, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_UPDATE_PARMS, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_UPDATE_PARMS, rc, 16)
    TEST_FIELD_ALIGN (MCI_DGV_UPDATE_PARMS, rc, 1)
    TEST_FIELD_OFFSET(MCI_DGV_UPDATE_PARMS, rc, 4)
    TEST_FIELD_SIZE  (MCI_DGV_UPDATE_PARMS, hDC, 4)
    TEST_FIELD_ALIGN (MCI_DGV_UPDATE_PARMS, hDC, 1)
    TEST_FIELD_OFFSET(MCI_DGV_UPDATE_PARMS, hDC, 20)
}

static void test_pack_MCI_DGV_WINDOW_PARMSA(void)
{
    /* MCI_DGV_WINDOW_PARMSA (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_WINDOW_PARMSA, 16)
    TEST_TYPE_ALIGN  (MCI_DGV_WINDOW_PARMSA, 1)
    TEST_FIELD_SIZE  (MCI_DGV_WINDOW_PARMSA, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_WINDOW_PARMSA, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_WINDOW_PARMSA, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_WINDOW_PARMSA, hWnd, 4)
    TEST_FIELD_ALIGN (MCI_DGV_WINDOW_PARMSA, hWnd, 1)
    TEST_FIELD_OFFSET(MCI_DGV_WINDOW_PARMSA, hWnd, 4)
    TEST_FIELD_SIZE  (MCI_DGV_WINDOW_PARMSA, nCmdShow, 4)
    TEST_FIELD_ALIGN (MCI_DGV_WINDOW_PARMSA, nCmdShow, 1)
    TEST_FIELD_OFFSET(MCI_DGV_WINDOW_PARMSA, nCmdShow, 8)
    TEST_FIELD_SIZE  (MCI_DGV_WINDOW_PARMSA, lpstrText, 4)
    TEST_FIELD_ALIGN (MCI_DGV_WINDOW_PARMSA, lpstrText, 1)
    TEST_FIELD_OFFSET(MCI_DGV_WINDOW_PARMSA, lpstrText, 12)
}

static void test_pack_MCI_DGV_WINDOW_PARMSW(void)
{
    /* MCI_DGV_WINDOW_PARMSW (pack 1) */
    TEST_TYPE_SIZE   (MCI_DGV_WINDOW_PARMSW, 16)
    TEST_TYPE_ALIGN  (MCI_DGV_WINDOW_PARMSW, 1)
    TEST_FIELD_SIZE  (MCI_DGV_WINDOW_PARMSW, dwCallback, 4)
    TEST_FIELD_ALIGN (MCI_DGV_WINDOW_PARMSW, dwCallback, 1)
    TEST_FIELD_OFFSET(MCI_DGV_WINDOW_PARMSW, dwCallback, 0)
    TEST_FIELD_SIZE  (MCI_DGV_WINDOW_PARMSW, hWnd, 4)
    TEST_FIELD_ALIGN (MCI_DGV_WINDOW_PARMSW, hWnd, 1)
    TEST_FIELD_OFFSET(MCI_DGV_WINDOW_PARMSW, hWnd, 4)
    TEST_FIELD_SIZE  (MCI_DGV_WINDOW_PARMSW, nCmdShow, 4)
    TEST_FIELD_ALIGN (MCI_DGV_WINDOW_PARMSW, nCmdShow, 1)
    TEST_FIELD_OFFSET(MCI_DGV_WINDOW_PARMSW, nCmdShow, 8)
    TEST_FIELD_SIZE  (MCI_DGV_WINDOW_PARMSW, lpstrText, 4)
    TEST_FIELD_ALIGN (MCI_DGV_WINDOW_PARMSW, lpstrText, 1)
    TEST_FIELD_OFFSET(MCI_DGV_WINDOW_PARMSW, lpstrText, 12)
}

#endif /* _WIN64 */

static void test_pack(void)
{
    test_pack_AUXCAPS2A();
    test_pack_AUXCAPS2W();
    test_pack_AUXCAPSA();
    test_pack_AUXCAPSW();
    test_pack_DRVCONFIGINFO();
    test_pack_JOYCAPS2A();
    test_pack_JOYCAPS2W();
    test_pack_JOYCAPSA();
    test_pack_JOYCAPSW();
    test_pack_JOYINFO();
    test_pack_JOYINFOEX();
    test_pack_MCI_ANIM_OPEN_PARMSA();
    test_pack_MCI_ANIM_OPEN_PARMSW();
    test_pack_MCI_ANIM_PLAY_PARMS();
    test_pack_MCI_ANIM_STEP_PARMS();
    test_pack_MCI_ANIM_UPDATE_PARMS();
    test_pack_MCI_ANIM_WINDOW_PARMSA();
    test_pack_MCI_ANIM_WINDOW_PARMSW();
    test_pack_MCI_BREAK_PARMS();
    test_pack_MCI_DGV_CAPTURE_PARMSA();
    test_pack_MCI_DGV_CAPTURE_PARMSW();
    test_pack_MCI_DGV_COPY_PARMS();
    test_pack_MCI_DGV_CUE_PARMS();
    test_pack_MCI_DGV_CUT_PARMS();
    test_pack_MCI_DGV_DELETE_PARMS();
    test_pack_MCI_DGV_INFO_PARMSA();
    test_pack_MCI_DGV_INFO_PARMSW();
    test_pack_MCI_DGV_LIST_PARMSA();
    test_pack_MCI_DGV_LIST_PARMSW();
    test_pack_MCI_DGV_MONITOR_PARMS();
    test_pack_MCI_DGV_OPEN_PARMSA();
    test_pack_MCI_DGV_OPEN_PARMSW();
    test_pack_MCI_DGV_PASTE_PARMS();
    test_pack_MCI_DGV_QUALITY_PARMSA();
    test_pack_MCI_DGV_QUALITY_PARMSW();
    test_pack_MCI_DGV_RECORD_PARMS();
    test_pack_MCI_DGV_RECT_PARMS();
    test_pack_MCI_DGV_RESERVE_PARMSA();
    test_pack_MCI_DGV_RESERVE_PARMSW();
    test_pack_MCI_DGV_RESTORE_PARMSA();
    test_pack_MCI_DGV_RESTORE_PARMSW();
    test_pack_MCI_DGV_SAVE_PARMSA();
    test_pack_MCI_DGV_SAVE_PARMSW();
    test_pack_MCI_DGV_SETAUDIO_PARMSA();
    test_pack_MCI_DGV_SETAUDIO_PARMSW();
    test_pack_MCI_DGV_SETVIDEO_PARMSA();
    test_pack_MCI_DGV_SETVIDEO_PARMSW();
    test_pack_MCI_DGV_SET_PARMS();
    test_pack_MCI_DGV_SIGNAL_PARMS();
    test_pack_MCI_DGV_STATUS_PARMSA();
    test_pack_MCI_DGV_STATUS_PARMSW();
    test_pack_MCI_DGV_STEP_PARMS();
    test_pack_MCI_DGV_UPDATE_PARMS();
    test_pack_MCI_DGV_WINDOW_PARMSA();
    test_pack_MCI_DGV_WINDOW_PARMSW();
    test_pack_MCI_GENERIC_PARMS();
    test_pack_MCI_GETDEVCAPS_PARMS();
    test_pack_MCI_INFO_PARMSA();
    test_pack_MCI_INFO_PARMSW();
    test_pack_MCI_LOAD_PARMSA();
    test_pack_MCI_LOAD_PARMSW();
    test_pack_MCI_OPEN_PARMSA();
    test_pack_MCI_OPEN_PARMSW();
    test_pack_MCI_OVLY_LOAD_PARMSA();
    test_pack_MCI_OVLY_LOAD_PARMSW();
    test_pack_MCI_OVLY_OPEN_PARMSA();
    test_pack_MCI_OVLY_OPEN_PARMSW();
    test_pack_MCI_OVLY_SAVE_PARMSA();
    test_pack_MCI_OVLY_SAVE_PARMSW();
    test_pack_MCI_OVLY_WINDOW_PARMSA();
    test_pack_MCI_OVLY_WINDOW_PARMSW();
    test_pack_MCI_PLAY_PARMS();
    test_pack_MCI_RECORD_PARMS();
    test_pack_MCI_SAVE_PARMSA();
    test_pack_MCI_SAVE_PARMSW();
    test_pack_MCI_SEEK_PARMS();
    test_pack_MCI_SEQ_SET_PARMS();
    test_pack_MCI_SET_PARMS();
    test_pack_MCI_SOUND_PARMSA();
    test_pack_MCI_SOUND_PARMSW();
    test_pack_MCI_STATUS_PARMS();
    test_pack_MCI_SYSINFO_PARMSA();
    test_pack_MCI_SYSINFO_PARMSW();
    test_pack_MCI_VD_ESCAPE_PARMSA();
    test_pack_MCI_VD_ESCAPE_PARMSW();
    test_pack_MCI_VD_PLAY_PARMS();
    test_pack_MCI_VD_STEP_PARMS();
    test_pack_MCI_WAVE_DELETE_PARMS();
    test_pack_MCI_WAVE_OPEN_PARMSA();
    test_pack_MCI_WAVE_OPEN_PARMSW();
    test_pack_MCI_WAVE_SET_PARMS();
    test_pack_MIDIEVENT();
    test_pack_MIDIHDR();
    test_pack_MIDIINCAPS2A();
    test_pack_MIDIINCAPS2W();
    test_pack_MIDIINCAPSA();
    test_pack_MIDIINCAPSW();
    test_pack_MIDIOUTCAPS2A();
    test_pack_MIDIOUTCAPS2W();
    test_pack_MIDIOUTCAPSA();
    test_pack_MIDIOUTCAPSW();
    test_pack_MIXERCAPS2A();
    test_pack_MIXERCAPS2W();
    test_pack_MIXERCAPSA();
    test_pack_MIXERCAPSW();
    test_pack_MIXERCONTROLA();
    test_pack_MIXERCONTROLDETAILS();
    test_pack_MIXERCONTROLDETAILS_BOOLEAN();
    test_pack_MIXERCONTROLDETAILS_LISTTEXTA();
    test_pack_MIXERCONTROLDETAILS_LISTTEXTW();
    test_pack_MIXERCONTROLDETAILS_SIGNED();
    test_pack_MIXERCONTROLDETAILS_UNSIGNED();
    test_pack_MIXERCONTROLW();
    test_pack_MIXERLINEA();
    test_pack_MIXERLINEW();
    test_pack_MMCKINFO();
    test_pack_MMIOINFO();
    test_pack_MMTIME();
    test_pack_PCMWAVEFORMAT();
    test_pack_TIMECAPS();
    test_pack_WAVEFORMAT();
    test_pack_WAVEFORMATEX();
    test_pack_WAVEHDR();
    test_pack_WAVEINCAPS2A();
    test_pack_WAVEINCAPS2W();
    test_pack_WAVEINCAPSA();
    test_pack_WAVEINCAPSW();
    test_pack_WAVEOUTCAPS2A();
    test_pack_WAVEOUTCAPS2W();
    test_pack_WAVEOUTCAPSA();
    test_pack_WAVEOUTCAPSW();
}

START_TEST(generated)
{
    test_pack();
}
