1. INTRODUCCIN

Wine es un programa que permite la ejecucin de programas de Microsoft Windows
(incluyendo ejecutables de DOS, Windows 3.x y Win32) sobre Unix. Consiste en un
programa cargador que carga y ejecuta un binario de Microsoft Windows, y una
librera (llamada Winelib) que implementa las llamadas a la API de Windows
usando sus equivalentes Unix o X11. La librera puede tambin utilizarse para
portar cdigo Win32 a ejecutables Unix nativos.

Wine es software libre, publicado bajo la licencia GNU LGPL; vea el fichero
LICENSE para los detalles.

2. INICIO RPIDO

Cuando compile desde el cdigo fuente, se recomienda utilizar el Instalador de
Wine para contruir e instalar Wine. Desde el directorio superior del cdigo de
Wine (el cual contiene este fichero), ejecute:

./tools/wineinstall

Ejecute programas con "wine [opciones] programa". Para ms informacin y
resolucin de problemas, lea el resto de este fichero, la pgina de manual de
Wine, los ficheros en el directorio de documentacin del cdigo fuente de Wine
(vea "DOCUMENTACIN") y, especficamente, la numerosa informacin que se
encuentra en http://www.winehq.org.

3. REQUISITOS

Para compilar y ejecutar Wine, deber tener uno de los siguientes:

  Linux versin 2.0.36 o superior
  FreeBSD 5.3 o superior
  Solaris x86 2.5 o superior
  NetBSD-current

Ya que Wine requiere soporte de hilos a nivel de ncleo para ejecutarse, slo
se soportan los sistemas operativos arriba mencionados.
Otros sistemas operativos que soportan hilos de ncleo pueden ser soportados en
el futuro.

Informacin de Linux:
  A pesar de que Linux 2.2.x debera funcionar todava y Linux 2.0.x an podra
  funcionar (versiones antiguas de 2.0.x tenan problemas relacionados con los
  hilos), es mejor tener un ncleo actual como los 2.4.x.

Informacin de FreeBSD:
  Wine debera construirse sobre FreeBSD 4.x y FreeBSD 5.x, pero versiones
  anteriores a FreeBSD 5.3 generalmente no funcionarn adecuadamente.

  Ms informacin se puede encontrar en el rbol de portes de FreeBSD en
  <ftp://ftp.freebsd.org/pub/FreeBSD/ports/ports/emulators/wine/>.

Informacin de Solaris:
  Lo ms probable es que necesite construir con el conjunto de herramientas GNU
  (gcc, gas, etc.). Advertencia: el instalar gas *no* asegura que sea utilizado
  por gcc. Se dice que recompilar gcc tras la instalacin de gas o enlazar
  simblicamente cc, as y ld a las herramientas gnu es necesario.

Informacin de NetBSD:
  Asegrese de que posee las opciones USER_LDT, SYSVSHM, SYSVSEM, y SYSVMSG
  activadas en su ncleo.



Sistemas de ficheros soportados:
  Wine debera ejecutarse en la mayora de los sistemas de ficheros. Sin
  embargo, Wine no conseguir iniciarse si umsdos es utilizado para el
  directorio /tmp. Unos cuantos problemas de compatibilidad se han reportado
  tambin al utilizar ficheros accedidos a travs de Samba. Adems, como de
  momento NTFS slo puede ser utilizado con seguridad con acceso de slo
  lectura, recomendamos no utilizar NTFS, ya que los programas Windows
  necesitan acceso de escritura en casi cualquier sitio. En el caso de ficheros
  NTFS, cpielos a una localizacin escribible.

Requisitos bsicos:
  Necesita tener los ficheros de inclusin de desarrollo de X11 instalados
  (llamados xlib6g-dev en Debian y XFree86-devel en RedHat).

Requisitos de herramienta de construccin:
  Sobre sistemas x86 se requiere gcc >= 2.7.2.
  Versiones ms antiguas que la 2.7.2.3 pueden tener problemas cuando ciertos
  ficheros sean compilados con optimizacin, a menudo debido a problemas con el
  manejo de ficheros de cabecera. pgcc actualmente no funciona con Wine. La
  causa de este problema se desconoce.

  Por supuesto tambin necesita "make" (preferiblemente GNU make).

  Tambin necesita flex versin 2.5 o superior y bison. Si est utilizando
  RedHat o Debian, instale los paquetes flex y bison.

Libreras de soporte adicionales:
  Si desea soporte de impresin CUPS, por favor instale los paquetes cups y
  cups-devel.

Para los requisitos en el caso de que pretenda construir usted mismo la
documentacin, vea la seccin "DOCUMENTACIN".

4. COMPILACIN

En el caso de que elija no utilizar wineinstall, ejecute los siguientes
comandos para construir Wine:

./configure
make depend
make

Esto construir el programa "wine" y numerosas libreras/binarios de soporte.
El programa "wine" cargar y ejecutar ejecutables de Windows.
La librera "libwine" ("Winelib") puede utilizarse para compilar y enlazar
cdigo fuente de Windows bajo Unix.

Para ver las opciones de configuracin para la compilacin, haga ./configure
--help.

Para actualizar a nueva versin usando un fichero de parches, primero haga cd
al directorio superior de la versin (el que contiene este fichero README).
Entonces haga un "make clean", y parchee la versin con:

    gunzip -c fichero-parche | patch -p1

donde "fichero-parche" es el nombre del fichero de parches (algo como
Wine-aammdd.diff.gz). Entonces puede volver a ejecutar "./configure", y luego
"make depend && make".

5. CONFIGURACIN

Una vez que Wine ha sido construido correctamente, puede hacer "make install";
esto instalar el ejecutable de wine, la pgina de manual de Wine, y otros
cuantos ficheros necesarios.

No olvide desinstalar antes cualquier instalacin anterior de Wine conflictiva.
Intente "dpkg -r wine" o "rpm -e wine" o "make uninstall" antes de instalar.

Si desea leer la documentacin que proporcionada con el cdigo de Wine, vea la
seccin "DOCUMENTACIN".

Wine requiere un fichero de configuracin llamado "config" en su directorio
~/.wine. El formato de este fichero se explica en la pgina de manual del
fichero de configuracin (documentation/wine.conf.man).
El fichero documentation/samples/config contiene un ejemplo de fichero de
configuracin que tiene que adaptarse y copiarse a la localizacin mencionada
arriba.

Vea la zona de Soporte en http://www.winehq.org/ para ms consejos de
configuracin.

En el caso de que tenga problemas de carga de libreras (p. ej. "Error while
loading shared libraries: libntdll.so"), asegrese de aadir la ruta de las
libreras a /etc/ld.so.conf y ejecutar ldconfig como root.

6. EJECUTANDO PROGRAMAS

Cuando invoque Wine, puede especificar la ruta completa al ejecutable, o slo
el nombre del fichero.

Por ejemplo: para ejecutar el Solitario:

  wine sol                   (usando la ruta de bsqueda indicada en el fichero
  wine sol.exe                de configuracin para encontrar el fichero)

  wine c:\\windows\\sol.exe  (usando la sintaxis de nombre de fichero de DOS)

  wine /usr/windows/sol.exe  (usando la sintaxis de nombre de fichero de Unix)

  wine sol.exe /parametro1 -parametro2 parametro3
                             (llamando al programa con parmetros)

Nota: la ruta del fichero tambin se aadir a la ruta cuando se proporcione un
      nombre completo en la lnea de comandos.

Wine todava no est completo, por lo que algunos programas pueden fallar. Si
configura winedbg correctamente de acuerdo con documentation/debugger.sgml,
entrar en un depurador para que pueda investigar y corregir el problema.
Para ms informacin sobre cmo hacer esto, por favor lea el fichero
documentation/debugging.sgml.

Debera hacer copia de seguridad de todos sus ficheros importantes a los d
acceso desde Wine, o utilizar una copia especial para Wine de ellos, ya que ha
habido algunos casos de usuarios reportando corrupcin de ficheros. NO ejecute
Explorer, por lo tanto, si no posee una copia de seguridad adecuada, ya que
renombra/corrompe a veces algunos directorios. Tampoco otras aplicaciones MS
como p. ej. Messenger son seguras, ya que lanzan de algn modo Explorer. Esta
corrupcin particular (!$!$!$!$.pfr) puede corregirse al menos parcialmente
utilizando http://home.nexgo.de/andi.mohr/download/decorrupt_explorer

7. DOCUMENTACIN

Alguna documentacin (varias guas de Wine, etc.) puede encontrarse en el
directorio documentation/ (aparte de que tambin est disponible en WineHQ).

Si desea procesar los ficheros SGML de all, puede ejecutar "make doc"
en el directorio documentation/.
Para hacerlo requiere el paquete de herramientas sgml (para db2html, db2ps,
db2pdf) de nombre:
Doing so requires the... (BORRAR)
Debian:         docbook-utils
Mandrake:       sgml-tools-A.B.C-DDmdk
SuSE:           docbktls-A.BB.C-DD

8. OBTENIENDO MS INFORMACIN

WWW:    Una gran cantidad de informacin sobre Wine est disponible en WineHQ
        en http://www.winehq.org/ : varias guas de Wine, base de datos de
        aplicaciones, registro de bugs. Este es probablemente el mejor punto de
        partida.

FAQ:    La FAQ de Wine se encuentra en http://www.winehq.org/FAQ

Usenet: Puede discutir sobre temas relacionados con Wine y obtener ayuda en
        comp.emulators.ms-windows.wine.

Bugs:   Reporte bugs al Bugzilla de Wine en http://bugs.winehq.org
        Por favor, busque en la base de datos de bugzilla para comprobar si su
        problema ya se encuentra antes de enviar un informe de bug. Puede
        tambin enviar informes de bugs a comp.emulators.ms-windows.wine.
        Por favor, lea el fichero documentation/bugs.sgml para ver qu
        informacin se requiere.

IRC:    Hay disponoble ayuda online en el canal #WineHQ de irc.freenode.net.

CVS:    El rbol actual de desarrollo de Wine est disponible a travs de CVS.
        Vaya a http://www.winehq.org/cvs para ms informacin.

Listas de correo:
        Hay varias listas de correo para desarrolladores de Wine; vea
        http://www.winehq.org/forums para ms informacin.

Si aade algo, o corrige algn bug, por favor enve un parche (en formato
'diff -u') a la lista wine-patches@winehq.org para su inclusin en la siguiente
versin.

--
Alexandre Julliard
julliard@winehq.org
