1. INLEDNING

Wine r ett program som gr det mjligt att kra Windows-program
(inkluderat DOS, Windows 3.x och Win32) i Unix. Det bestr av en
programstartare som startar och kr Windows-programfiler, samt ett
bibliotek (kallat Winelib) som implementerar Windows API-anrop med hjlp
av deras Unix- eller X11-motsvarigheter. Biblioteket kan ocks anvndas
till att porta Win32-kod till vanliga Unix-program.

Wine r fri programvara, utgett under villkren i GNU LGPL; se
filen LICENSE fr detaljer.

2. KOM IGNG

Nr du bygger Wine frn kllkod s rekommenderas du anvnda Wines
installationsprogram. Kr fljande i rotkatalogen fr Wines kllkod:

./tools/wineinstall

Kr program med "wine [val] program". Se resten av denna fil,
Wines man-sidor samt sist men inte minst http://www.winehq.org/ fr mer
information och tips om hur problem kan lsas.


3. SYSTEMKRAV

Fr att kompilera och kra Wine krvs ett av fljande:

  Linux version 2.0.36 eller senare
  FreeBSD 6.3 eller senare
  Solaris x86 9 eller senare
  NetBSD-current
  Mac OS X 10.4 eller senare

Wine krver std fr trdar p kernelniv, och drfr r det bara
operativsystemen ovan som stds. Andra operativsystem som
stder kerneltrdar kommer eventuellt att stdjas i framtiden.

Information fr Linux
  ven om Linux 2.2.x antagligen fortfarande fungerar, och Linux 2.0.x kanske
  fungerar (tidiga 2.0.x-versioner uppvisade trdrelaterade problem), s r
  det bst att ha en nuvarande kernel som 2.4.x eller 2.6.x.

Information fr FreeBSD
  Wine kommer i regel inte fungera p FreeBSD-versioner ldre n 6.3 eller 7.0.
  FreeBSD 6.3 kan uppdateras for att stdja Wine. Se
  <http://wiki.freebsd.org/Wine> fr mer information.

Information fr Solaris
  Wine mste antagligen byggas med GNU toolchain (gcc, gas etc.).
  Varning: ven om gas installeras s r det inte skert att det anvnds av
  gcc. Det sgs att det r ndvndigt att antingen bygga gcc p nytt, eller
  skapa symboliska lnkar frn "cc", "as" och "ld" till GNU toolchain.

Information fr NetBSD
  USER_LDT, SYSVSHM, SYSVSEM och SYSVMSG mste vara aktiverade i kerneln.

Information fr Mac OS X:
  Du behver Xcode 2.4 eller senare fr att korrekt kunna bygga Wine p x86.


Stdda filsystem
  Wine kan kra p de flesta filsystem, men det har rapporterats problem vad
  gller kompatibilitet d samba anvnds fr att ansluta till filer. NTFS
  tillhandahller inte heller alla filsystemsfunktioner som behvs av alla
  program. Det rekommenderas att anvnda ett Linux-filsystem som exempelvis
  ext3.

Grundlggande krav:
  Utvecklingsfilerna fr X11 mste vara installerade (de kallas xlib6g-dev i
  Debian och XFree86-devel i Red Hat).

  Du mste givetvis ocks ha "make" (mest troligt "GNU make").

  Det r ocks ndvndigt att ha flex 2.5 eller senare samt bison.

Valfria stdbibliotek:
  configure-skriptet visar varningar nr valfria bibliotek inte hittats.
  Se http://wiki.winehq.org/Recommended_Packages fr information om
  vilka paket du br installera.

  P 64 bit-system mste du skerstlla att 32 bit-versionerna av
  ovannmnda bibliotek installerats; se
  http://wiki.winehq.org/WineOn64bit fr nrmare detaljer.

4. KOMPILERING

Kr fljande kommandon fr att bygga Wine om du inte anvnder wineinstall:

./configure
make depend
make

Detta bygger programmet "wine" och diverse stdbibliotek/programfiler.
Programfilen "wine" laddar och kr Windows-program.
Biblioteket "libwine" ("Winelib") kan anvndas till att bygga och lnka
Windows-kllkod i Unix.

Kr './configure --help' fr att se instllningar och val vid kompilering.

Gr fljande fr att uppgradera till en ny utgva med hjlp av en
uppdateringsfil:
G in i utgvans rotkatalog och kr kommandot "make clean".
Drefter uppdaterar du utgvan med

    bunzip -c uppdateringsfil | patch -p1

dr "uppdateringsfil" r namnet p uppdateringsfilen (ngot i stil med
wine-1.0.x.diff.bz2). Drefter kan du kra "./configure" och
"make depend && make".


5. INSTALLATION

Nr Wine r byggt kan du kra "make install" fr att installera det;
detta installerar ocks man-sidorna och ngra fler ndvndiga filer.

Glm inte att frst avinstallera gamla Wine-versioner. Prva antingen
"dpkg -r wine", "rpm -e wine" eller "make uninstall" fre installationen.

Nr Wine r installerat kan du anvnda instllningsprogrammet "winecfg".
Se hjlpavdelningen p http://www.winehq.org/ fr tips om instllningar.


6. KRNING AV PROGRAM

Nr du anvnder Wine kan du uppge hela skvgen till programfilen, eller
enbart ett filnamn.

Exempel: fr att kra Notepad:

        wine notepad               (anvnder skvgen angiven i Wines
        wine notepad.exe            konfigurationsfil fr att finna filen)

        wine c:\\windows\\notepad.exe  (anvndning av DOS-filnamnssyntax)

        wine ~/.wine/drive_c/windows/notepad.exe  (anvndning av Unix-filvgar)

        wine notepad.exe /parameter1 -parameter2 parameter3
                                   (kra program med parametrar)

Wine r inte nnu frdigutvecklat, s det r mjligt att tskilliga program
kraschar. I s fall ppnas Wines felskare, dr du kan underska och fixa
problemet. Ls delen "debugging" i Wines utvecklarmanual fr mer information
om hur detta kan gras.


7. MER INFORMATION

Internet:  Mycket information om Wine finns samlat p WineHQ p
           http://www.winehq.org/ : diverse guider, en programdatabas samt
           felsprning. Detta r antagligen det bsta stllet att brja.

Frgor:    Frgor och svar om Wine finns samlade p http://www.winehq.org/FAQ

Usenet:    Du kan diskutera problem med Wine och f hjlp p
           comp.emulators.ms-windows.wine.

Fel:       Rapportera fel till Wines Bugzilla p http://bugs.winehq.org
           Sk i Bugzilla-databasen fr att se om problemet redan finns
           rapporterat innan du snder en felrapport. Du kan ocks rapportera
           fel till comp.emulators.ms-windows.wine.

IRC:       Hjlp finns tillgnglig online p kanalen #WineHQ p
           irc.freenode.net.

GIT:       Wines nuvarande utvecklingsversion finns tillgnglig genom GIT.
           G till http://www.winehq.org/git fr mer information.

E-postlistor:
        Det finns flera e-postlistor fr Wine-utvecklare; se
        http://www.winehq.org/forums fr mer information.

Wiki:   Wines Wiki finns p http://wiki.winehq.org

Om du lgger till ngot eller fixar ett fel, r det bra om du snder
en patch (i 'diff -u'-format) till listan wine-patches@winehq.org fr
inkludering i nsta utgva av Wine.

--
Originalet till denna fil skrevs av
Alexandre Julliard
julliard@winehq.org

versatt till svenska av
Anders Jonsson
anders.jonsson@norsjonet.se
