###############################################################################
# ReqItclExtension.tcl
#
# This file implements the check for Itcl extension.
#
# Copyright (c) 2000 by Martin Pilka for CodeWeavers
###############################################################################

proc ItclLoadFail {aExt aErrMsg} {
  wm withdraw .
  tk_messageBox -title "WineSetupTk startup error" -icon error -message "Failed to load $aExt extension:\n\n$aErrMsg\n\nSee README.TXT file for more information." -type ok -parent .
  exit 1
}

# in case of statically linked executable this command is there
if {[info commands Et_NewBuiltinFile] != ""} {
  set RunningExe 1
} else {
  set RunningExe 0
}

if {!$RunningExe} {
  # Itcl not loaded yet
  if {[catch {package require Itcl} ErrMsg]} {
    puts "Itcl error: $ErrMsg"
    ItclLoadFail Itcl $ErrMsg
  }
  # Itk not loaded yet
  if {[catch {package require Itk} ErrMsg]} {
    puts "Itk error: $ErrMsg"
    ItclLoadFail Itk $ErrMsg
  }
}
namespace import -force itcl::*

if {$RunningExe} { source auto_path.tcl }
if {[catch {package require Iwidgets} ErrMsg]} {
  puts "Iwidgets error: $ErrMsg"
  ItclLoadFail Iwidgets $ErrMsg
}
if {$RunningExe} { source auto_path.tcl }

proc ItclLoadFail {} {
  puts "ItclLoadFail: undefined proc"
  exit 1
}
