/* packet-tango.c
 * Routines for IDL dissection
 *
 * Autogenerated from idl2wrs
 * Copyright 2001 Frank Singleton <frank.singleton@ericsson.com>
 */


/*
 * Wireshark - Network traffic analyzer
 * By Gerald Combs
 * Copyright 1999 - 2006 Gerald Combs
 */


/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <gmodule.h>

#include <string.h>
#include <glib.h>
#include <epan/packet.h>
#include <epan/proto.h>
#include <epan/dissectors/packet-giop.h>

#ifndef ENABLE_STATIC
G_MODULE_EXPORT const gchar version[] = "0.0.1";
#endif



static proto_tree *start_dissecting(tvbuff_t *tvb, packet_info *pinfo, proto_tree *ptree, int *offset);



/* Struct prototype declaration Start */


/* Struct = IDL:Tango/DevVarLongStringArray:1.0 */

static void decode_Tango_DevVarLongStringArray_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/DevVarDoubleStringArray:1.0 */

static void decode_Tango_DevVarDoubleStringArray_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/TimeVal:1.0 */

static void decode_Tango_TimeVal_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/DevCmdInfo:1.0 */

static void decode_Tango_DevCmdInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/DevCmdInfo_2:1.0 */

static void decode_Tango_DevCmdInfo_2_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/DevError:1.0 */

static void decode_Tango_DevError_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/NamedDevError:1.0 */

static void decode_Tango_NamedDevError_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/AttributeConfig:1.0 */

static void decode_Tango_AttributeConfig_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/AttributeConfig_2:1.0 */

static void decode_Tango_AttributeConfig_2_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/AttributeValue:1.0 */

static void decode_Tango_AttributeValue_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/AttributeDim:1.0 */

static void decode_Tango_AttributeDim_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/AttributeValue_3:1.0 */

static void decode_Tango_AttributeValue_3_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/ChangeEventProp:1.0 */

static void decode_Tango_ChangeEventProp_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/PeriodicEventProp:1.0 */

static void decode_Tango_PeriodicEventProp_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/ArchiveEventProp:1.0 */

static void decode_Tango_ArchiveEventProp_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/EventProperties:1.0 */

static void decode_Tango_EventProperties_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/AttributeAlarm:1.0 */

static void decode_Tango_AttributeAlarm_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/AttributeConfig_3:1.0 */

static void decode_Tango_AttributeConfig_3_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/DevInfo:1.0 */

static void decode_Tango_DevInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/DevInfo_3:1.0 */

static void decode_Tango_DevInfo_3_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/DevCmdHistory:1.0 */

static void decode_Tango_DevCmdHistory_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/DevAttrHistory:1.0 */

static void decode_Tango_DevAttrHistory_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct = IDL:Tango/DevAttrHistory_3:1.0 */

static void decode_Tango_DevAttrHistory_3_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_);


/* Struct prototype declaration End */


/* Union prototype declaration Start */


/* Union prototype declaration End */



/* Initialise the protocol and subtree pointers */

static int proto_tango = -1;

static gint ett_tango = -1;


/* Initialise the initial Alignment */

static guint32  boundary = GIOP_HEADER_SIZE;  /* initial value */



/* Initialise the Registered fields */

/* TODO - Use registered fields */

/*
 * IDL Operations Start
 */
 
static const char Tango_Device_command_inout_op[] = "command_inout" ;
static const char Tango_Device_get_attribute_config_op[] = "get_attribute_config" ;
static const char Tango_Device_set_attribute_config_op[] = "set_attribute_config" ;
static const char Tango_Device_read_attributes_op[] = "read_attributes" ;
static const char Tango_Device_write_attributes_op[] = "write_attributes" ;
static const char Tango_Device_ping_op[] = "ping" ;
static const char Tango_Device_black_box_op[] = "black_box" ;
static const char Tango_Device_info_op[] = "info" ;
static const char Tango_Device_command_list_query_op[] = "command_list_query" ;
static const char Tango_Device_command_query_op[] = "command_query" ;
static const char Tango_Device_2_command_inout_2_op[] = "command_inout_2" ;
static const char Tango_Device_2_read_attributes_2_op[] = "read_attributes_2" ;
static const char Tango_Device_2_get_attribute_config_2_op[] = "get_attribute_config_2" ;
static const char Tango_Device_2_command_list_query_2_op[] = "command_list_query_2" ;
static const char Tango_Device_2_command_query_2_op[] = "command_query_2" ;
static const char Tango_Device_2_command_inout_history_2_op[] = "command_inout_history_2" ;
static const char Tango_Device_2_read_attribute_history_2_op[] = "read_attribute_history_2" ;
static const char Tango_Device_3_read_attributes_3_op[] = "read_attributes_3" ;
static const char Tango_Device_3_write_attributes_3_op[] = "write_attributes_3" ;
static const char Tango_Device_3_read_attribute_history_3_op[] = "read_attribute_history_3" ;
static const char Tango_Device_3_info_3_op[] = "info_3" ;
static const char Tango_Device_3_get_attribute_config_3_op[] = "get_attribute_config_3" ;
static const char Tango_Device_3_set_attribute_config_3_op[] = "set_attribute_config_3" ;

/*
 * IDL Operations End
 */

/*  Begin Exception (containing members) String  Declare  */


static const char user_exception_Tango_DevFailed[] = "IDL:Tango/DevFailed:1.0" ; 
static const char user_exception_Tango_MultiDevFailed[] = "IDL:Tango/MultiDevFailed:1.0" ; 

/*  End Exception (containing members) String Declare  */

/*
 * IDL Attributes Start
 */
 
static const char get_Tango_Device_name_at[] = "_get_name" ;
static const char get_Tango_Device_description_at[] = "_get_description" ;
static const char get_Tango_Device_state_at[] = "_get_state" ;
static const char get_Tango_Device_status_at[] = "_get_status" ;
static const char get_Tango_Device_adm_name_at[] = "_get_adm_name" ;

/*
 * IDL Attributes End
 */

/*
 * IDL Enums Start
 */
 
/*
 * Enum = IDL:Tango/AttrQuality:1.0
 */
 
static const value_string Tango_AttrQuality[] = {

   { 0, "ATTR_VALID" }, 
   { 1, "ATTR_INVALID" }, 
   { 2, "ATTR_ALARM" }, 
   { 3, "ATTR_CHANGING" }, 
   { 4, "ATTR_WARNING" }, 
   { 0,       NULL },
};

/*
 * Enum = IDL:Tango/AttrWriteType:1.0
 */
 
static const value_string Tango_AttrWriteType[] = {

   { 0, "READ" }, 
   { 1, "READ_WITH_WRITE" }, 
   { 2, "WRITE" }, 
   { 3, "READ_WRITE" }, 
   { 0,       NULL },
};

/*
 * Enum = IDL:Tango/AttrDataFormat:1.0
 */
 
static const value_string Tango_AttrDataFormat[] = {

   { 0, "SCALAR" }, 
   { 1, "SPECTRUM" }, 
   { 2, "IMAGE" }, 
   { 0,       NULL },
};

/*
 * Enum = IDL:Tango/DevSource:1.0
 */
 
static const value_string Tango_DevSource[] = {

   { 0, "DEV" }, 
   { 1, "CACHE" }, 
   { 2, "CACHE_DEV" }, 
   { 0,       NULL },
};

/*
 * Enum = IDL:Tango/ErrSeverity:1.0
 */
 
static const value_string Tango_ErrSeverity[] = {

   { 0, "WARN" }, 
   { 1, "ERR" }, 
   { 2, "PANIC" }, 
   { 0,       NULL },
};

/*
 * Enum = IDL:Tango/DevState:1.0
 */
 
static const value_string Tango_DevState[] = {

   { 0, "ON" }, 
   { 1, "OFF" }, 
   { 2, "CLOSE" }, 
   { 3, "OPEN" }, 
   { 4, "INSERT" }, 
   { 5, "EXTRACT" }, 
   { 6, "MOVING" }, 
   { 7, "STANDBY" }, 
   { 8, "FAULT" }, 
   { 9, "INIT" }, 
   { 10, "RUNNING" }, 
   { 11, "ALARM" }, 
   { 12, "DISABLE" }, 
   { 13, "UNKNOWN" }, 
   { 0,       NULL },
};

/*
 * Enum = IDL:Tango/DispLevel:1.0
 */
 
static const value_string Tango_DispLevel[] = {

   { 0, "OPERATOR" }, 
   { 1, "EXPERT" }, 
   { 0,       NULL },
};

/*
 * IDL Enums End
 */
 
/*  Begin Exception Helper Functions  */


/* Exception = IDL:Tango/DevFailed:1.0 */

static void decode_ex_Tango_DevFailed(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4_loop_DevFailed_errors;
    guint32   i_DevFailed_errors;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4_loop_DevFailed_errors = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of DevFailed_errors = %u",u_octet4_loop_DevFailed_errors);
    }

    for (i_DevFailed_errors=0; i_DevFailed_errors < u_octet4_loop_DevFailed_errors; i_DevFailed_errors++) {

        /*  Begin struct "Tango_DevError"  */

        

        decode_Tango_DevError_st(tvb, pinfo, tree, offset, header, operation);

        /*  End struct "Tango_DevError"  */

    }

}

/* Exception = IDL:Tango/MultiDevFailed:1.0 */

static void decode_ex_Tango_MultiDevFailed(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4_loop_MultiDevFailed_errors;
    guint32   i_MultiDevFailed_errors;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4_loop_MultiDevFailed_errors = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of MultiDevFailed_errors = %u",u_octet4_loop_MultiDevFailed_errors);
    }

    for (i_MultiDevFailed_errors=0; i_MultiDevFailed_errors < u_octet4_loop_MultiDevFailed_errors; i_MultiDevFailed_errors++) {

        /*  Begin struct "Tango_NamedDevError"  */

        

        decode_Tango_NamedDevError_st(tvb, pinfo, tree, offset, header, operation);

        /*  End struct "Tango_NamedDevError"  */

    }

}


/*  End Exception Helper Functions  */

/*
 * Main delegator for exception handling
 *
 */

static gboolean decode_user_exception(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *ptree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_ ) {

    gboolean be _U_;                        /* big endianess */
    proto_tree *tree _U_;

    if (!header->exception_id)
        return FALSE;

    if (strcmp(header->exception_id, user_exception_Tango_DevFailed) == 0) {
       tree = start_dissecting(tvb, pinfo, ptree, offset);
       decode_ex_Tango_DevFailed(tvb, pinfo, tree, offset, header, operation);   /*  IDL:Tango/DevFailed:1.0  */
       return TRUE;
    }

    if (strcmp(header->exception_id, user_exception_Tango_MultiDevFailed) == 0) {
       tree = start_dissecting(tvb, pinfo, ptree, offset);
       decode_ex_Tango_MultiDevFailed(tvb, pinfo, tree, offset, header, operation);   /*  IDL:Tango/MultiDevFailed:1.0  */
       return TRUE;
    }



    return FALSE;    /* user exception not found */

}

/*  Begin Attribute Helper Functions  */


/* Attribute = IDL:Tango/Device/name:1.0 */

static void decode_get_Tango_Device_name_at(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"name (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

}


/* Attribute = IDL:Tango/Device/description:1.0 */

static void decode_get_Tango_Device_description_at(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"description (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

}


/* Attribute = IDL:Tango/Device/state:1.0 */

static void decode_get_Tango_Device_state_at(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    
    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"Enum value = %u (%s)",u_octet4,val_to_str(u_octet4,Tango_DevState,"Unknown Enum Value"));
    }

}


/* Attribute = IDL:Tango/Device/status:1.0 */

static void decode_get_Tango_Device_status_at(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"status (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

}


/* Attribute = IDL:Tango/Device/adm_name:1.0 */

static void decode_get_Tango_Device_adm_name_at(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"adm_name (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

}


/*  End Attribute Helper Functions  */

/*
 * IDL:Tango/Device/command_inout:1.0
 */

static void decode_Tango_Device_command_inout(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"command (%u) = %s",
              u_octet4, (u_octet4 > 0) ? seq : "");
        }

        g_free(seq);          /*  free buffer  */
        seq = NULL;

        get_CDR_any(tvb,tree,offset,stream_is_big_endian, boundary, header);

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            get_CDR_any(tvb,tree,offset,stream_is_big_endian, boundary, header);

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device/get_attribute_config:1.0
 */

static void decode_Tango_Device_get_attribute_config(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4_loop_names;
    guint32   i_names;
    guint32   u_octet4;
    gchar   *seq = NULL;
    guint32   u_octet4_loop_AttributeConfigList;
    guint32   i_AttributeConfigList;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        u_octet4_loop_names = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of names = %u",u_octet4_loop_names);
        }

        for (i_names=0; i_names < u_octet4_loop_names; i_names++) {

            u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
            if (tree) {
               proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"names (%u) = %s",
                  u_octet4, (u_octet4 > 0) ? seq : "");
            }

            g_free(seq);          /*  free buffer  */
            seq = NULL;

        }

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            u_octet4_loop_AttributeConfigList = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            if (tree) {
               proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of AttributeConfigList = %u",u_octet4_loop_AttributeConfigList);
            }

            for (i_AttributeConfigList=0; i_AttributeConfigList < u_octet4_loop_AttributeConfigList; i_AttributeConfigList++) {

                /*  Begin struct "Tango_AttributeConfig"  */

                

                decode_Tango_AttributeConfig_st(tvb, pinfo, tree, offset, header, operation);

                /*  End struct "Tango_AttributeConfig"  */

            }

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device/set_attribute_config:1.0
 */

static void decode_Tango_Device_set_attribute_config(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4_loop_new_conf;
    guint32   i_new_conf;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        u_octet4_loop_new_conf = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of new_conf = %u",u_octet4_loop_new_conf);
        }

        for (i_new_conf=0; i_new_conf < u_octet4_loop_new_conf; i_new_conf++) {

            /*  Begin struct "Tango_AttributeConfig"  */

            

            decode_Tango_AttributeConfig_st(tvb, pinfo, tree, offset, header, operation);

            /*  End struct "Tango_AttributeConfig"  */

        }

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            /* Function returns void */

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device/read_attributes:1.0
 */

static void decode_Tango_Device_read_attributes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4_loop_names;
    guint32   i_names;
    guint32   u_octet4;
    gchar   *seq = NULL;
    guint32   u_octet4_loop_AttributeValueList;
    guint32   i_AttributeValueList;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        u_octet4_loop_names = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of names = %u",u_octet4_loop_names);
        }

        for (i_names=0; i_names < u_octet4_loop_names; i_names++) {

            u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
            if (tree) {
               proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"names (%u) = %s",
                  u_octet4, (u_octet4 > 0) ? seq : "");
            }

            g_free(seq);          /*  free buffer  */
            seq = NULL;

        }

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            u_octet4_loop_AttributeValueList = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            if (tree) {
               proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of AttributeValueList = %u",u_octet4_loop_AttributeValueList);
            }

            for (i_AttributeValueList=0; i_AttributeValueList < u_octet4_loop_AttributeValueList; i_AttributeValueList++) {

                /*  Begin struct "Tango_AttributeValue"  */

                

                decode_Tango_AttributeValue_st(tvb, pinfo, tree, offset, header, operation);

                /*  End struct "Tango_AttributeValue"  */

            }

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device/write_attributes:1.0
 */

static void decode_Tango_Device_write_attributes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4_loop_values;
    guint32   i_values;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        u_octet4_loop_values = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of values = %u",u_octet4_loop_values);
        }

        for (i_values=0; i_values < u_octet4_loop_values; i_values++) {

            /*  Begin struct "Tango_AttributeValue"  */

            

            decode_Tango_AttributeValue_st(tvb, pinfo, tree, offset, header, operation);

            /*  End struct "Tango_AttributeValue"  */

        }

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            /* Function returns void */

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device/ping:1.0
 */

static void decode_Tango_Device_ping(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            /* Function returns void */

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device/black_box:1.0
 */

static void decode_Tango_Device_black_box(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    gint32    s_octet4;
    guint32   u_octet4_loop_DevVarStringArray;
    guint32   i_DevVarStringArray;
    guint32   u_octet4;
    gchar   *seq = NULL;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-4,4,"n = %i",s_octet4);
        }

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            u_octet4_loop_DevVarStringArray = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            if (tree) {
               proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of DevVarStringArray = %u",u_octet4_loop_DevVarStringArray);
            }

            for (i_DevVarStringArray=0; i_DevVarStringArray < u_octet4_loop_DevVarStringArray; i_DevVarStringArray++) {

                u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
                if (tree) {
                   proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevVarStringArray (%u) = %s",
                      u_octet4, (u_octet4 > 0) ? seq : "");
                }

                g_free(seq);          /*  free buffer  */
                seq = NULL;

            }

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device/info:1.0
 */

static void decode_Tango_Device_info(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            /*  Begin struct "Tango_DevInfo"  */

            

            decode_Tango_DevInfo_st(tvb, pinfo, tree, offset, header, operation);

            /*  End struct "Tango_DevInfo"  */

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device/command_list_query:1.0
 */

static void decode_Tango_Device_command_list_query(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4_loop_DevCmdInfoList;
    guint32   i_DevCmdInfoList;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            u_octet4_loop_DevCmdInfoList = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            if (tree) {
               proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of DevCmdInfoList = %u",u_octet4_loop_DevCmdInfoList);
            }

            for (i_DevCmdInfoList=0; i_DevCmdInfoList < u_octet4_loop_DevCmdInfoList; i_DevCmdInfoList++) {

                /*  Begin struct "Tango_DevCmdInfo"  */

                

                decode_Tango_DevCmdInfo_st(tvb, pinfo, tree, offset, header, operation);

                /*  End struct "Tango_DevCmdInfo"  */

            }

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device/command_query:1.0
 */

static void decode_Tango_Device_command_query(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"command (%u) = %s",
              u_octet4, (u_octet4 > 0) ? seq : "");
        }

        g_free(seq);          /*  free buffer  */
        seq = NULL;

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            /*  Begin struct "Tango_DevCmdInfo"  */

            

            decode_Tango_DevCmdInfo_st(tvb, pinfo, tree, offset, header, operation);

            /*  End struct "Tango_DevCmdInfo"  */

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device_2/command_inout_2:1.0
 */

static void decode_Tango_Device_2_command_inout_2(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"command (%u) = %s",
              u_octet4, (u_octet4 > 0) ? seq : "");
        }

        g_free(seq);          /*  free buffer  */
        seq = NULL;

        get_CDR_any(tvb,tree,offset,stream_is_big_endian, boundary, header);

        
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-4,4,"Enum value = %u (%s)",u_octet4,val_to_str(u_octet4,Tango_DevSource,"Unknown Enum Value"));
        }

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            get_CDR_any(tvb,tree,offset,stream_is_big_endian, boundary, header);

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device_2/read_attributes_2:1.0
 */

static void decode_Tango_Device_2_read_attributes_2(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4_loop_names;
    guint32   i_names;
    guint32   u_octet4;
    gchar   *seq = NULL;
    guint32   u_octet4_loop_AttributeValueList;
    guint32   i_AttributeValueList;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        u_octet4_loop_names = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of names = %u",u_octet4_loop_names);
        }

        for (i_names=0; i_names < u_octet4_loop_names; i_names++) {

            u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
            if (tree) {
               proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"names (%u) = %s",
                  u_octet4, (u_octet4 > 0) ? seq : "");
            }

            g_free(seq);          /*  free buffer  */
            seq = NULL;

        }

        
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-4,4,"Enum value = %u (%s)",u_octet4,val_to_str(u_octet4,Tango_DevSource,"Unknown Enum Value"));
        }

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            u_octet4_loop_AttributeValueList = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            if (tree) {
               proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of AttributeValueList = %u",u_octet4_loop_AttributeValueList);
            }

            for (i_AttributeValueList=0; i_AttributeValueList < u_octet4_loop_AttributeValueList; i_AttributeValueList++) {

                /*  Begin struct "Tango_AttributeValue"  */

                

                decode_Tango_AttributeValue_st(tvb, pinfo, tree, offset, header, operation);

                /*  End struct "Tango_AttributeValue"  */

            }

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device_2/get_attribute_config_2:1.0
 */

static void decode_Tango_Device_2_get_attribute_config_2(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4_loop_names;
    guint32   i_names;
    guint32   u_octet4;
    gchar   *seq = NULL;
    guint32   u_octet4_loop_AttributeConfigList_2;
    guint32   i_AttributeConfigList_2;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        u_octet4_loop_names = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of names = %u",u_octet4_loop_names);
        }

        for (i_names=0; i_names < u_octet4_loop_names; i_names++) {

            u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
            if (tree) {
               proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"names (%u) = %s",
                  u_octet4, (u_octet4 > 0) ? seq : "");
            }

            g_free(seq);          /*  free buffer  */
            seq = NULL;

        }

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            u_octet4_loop_AttributeConfigList_2 = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            if (tree) {
               proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of AttributeConfigList_2 = %u",u_octet4_loop_AttributeConfigList_2);
            }

            for (i_AttributeConfigList_2=0; i_AttributeConfigList_2 < u_octet4_loop_AttributeConfigList_2; i_AttributeConfigList_2++) {

                /*  Begin struct "Tango_AttributeConfig_2"  */

                

                decode_Tango_AttributeConfig_2_st(tvb, pinfo, tree, offset, header, operation);

                /*  End struct "Tango_AttributeConfig_2"  */

            }

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device_2/command_list_query_2:1.0
 */

static void decode_Tango_Device_2_command_list_query_2(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4_loop_DevCmdInfoList_2;
    guint32   i_DevCmdInfoList_2;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            u_octet4_loop_DevCmdInfoList_2 = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            if (tree) {
               proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of DevCmdInfoList_2 = %u",u_octet4_loop_DevCmdInfoList_2);
            }

            for (i_DevCmdInfoList_2=0; i_DevCmdInfoList_2 < u_octet4_loop_DevCmdInfoList_2; i_DevCmdInfoList_2++) {

                /*  Begin struct "Tango_DevCmdInfo_2"  */

                

                decode_Tango_DevCmdInfo_2_st(tvb, pinfo, tree, offset, header, operation);

                /*  End struct "Tango_DevCmdInfo_2"  */

            }

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device_2/command_query_2:1.0
 */

static void decode_Tango_Device_2_command_query_2(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"command (%u) = %s",
              u_octet4, (u_octet4 > 0) ? seq : "");
        }

        g_free(seq);          /*  free buffer  */
        seq = NULL;

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            /*  Begin struct "Tango_DevCmdInfo_2"  */

            

            decode_Tango_DevCmdInfo_2_st(tvb, pinfo, tree, offset, header, operation);

            /*  End struct "Tango_DevCmdInfo_2"  */

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device_2/command_inout_history_2:1.0
 */

static void decode_Tango_Device_2_command_inout_history_2(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    gint32    s_octet4;
    guint32   u_octet4_loop_DevCmdHistoryList;
    guint32   i_DevCmdHistoryList;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"command (%u) = %s",
              u_octet4, (u_octet4 > 0) ? seq : "");
        }

        g_free(seq);          /*  free buffer  */
        seq = NULL;

        s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-4,4,"n = %i",s_octet4);
        }

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            u_octet4_loop_DevCmdHistoryList = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            if (tree) {
               proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of DevCmdHistoryList = %u",u_octet4_loop_DevCmdHistoryList);
            }

            for (i_DevCmdHistoryList=0; i_DevCmdHistoryList < u_octet4_loop_DevCmdHistoryList; i_DevCmdHistoryList++) {

                /*  Begin struct "Tango_DevCmdHistory"  */

                

                decode_Tango_DevCmdHistory_st(tvb, pinfo, tree, offset, header, operation);

                /*  End struct "Tango_DevCmdHistory"  */

            }

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device_2/read_attribute_history_2:1.0
 */

static void decode_Tango_Device_2_read_attribute_history_2(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    gint32    s_octet4;
    guint32   u_octet4_loop_DevAttrHistoryList;
    guint32   i_DevAttrHistoryList;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"name (%u) = %s",
              u_octet4, (u_octet4 > 0) ? seq : "");
        }

        g_free(seq);          /*  free buffer  */
        seq = NULL;

        s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-4,4,"n = %i",s_octet4);
        }

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            u_octet4_loop_DevAttrHistoryList = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            if (tree) {
               proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of DevAttrHistoryList = %u",u_octet4_loop_DevAttrHistoryList);
            }

            for (i_DevAttrHistoryList=0; i_DevAttrHistoryList < u_octet4_loop_DevAttrHistoryList; i_DevAttrHistoryList++) {

                /*  Begin struct "Tango_DevAttrHistory"  */

                

                decode_Tango_DevAttrHistory_st(tvb, pinfo, tree, offset, header, operation);

                /*  End struct "Tango_DevAttrHistory"  */

            }

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device_3/read_attributes_3:1.0
 */

static void decode_Tango_Device_3_read_attributes_3(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4_loop_names;
    guint32   i_names;
    guint32   u_octet4;
    gchar   *seq = NULL;
    guint32   u_octet4_loop_AttributeValueList_3;
    guint32   i_AttributeValueList_3;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        u_octet4_loop_names = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of names = %u",u_octet4_loop_names);
        }

        for (i_names=0; i_names < u_octet4_loop_names; i_names++) {

            u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
            if (tree) {
               proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"names (%u) = %s",
                  u_octet4, (u_octet4 > 0) ? seq : "");
            }

            g_free(seq);          /*  free buffer  */
            seq = NULL;

        }

        
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-4,4,"Enum value = %u (%s)",u_octet4,val_to_str(u_octet4,Tango_DevSource,"Unknown Enum Value"));
        }

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            u_octet4_loop_AttributeValueList_3 = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            if (tree) {
               proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of AttributeValueList_3 = %u",u_octet4_loop_AttributeValueList_3);
            }

            for (i_AttributeValueList_3=0; i_AttributeValueList_3 < u_octet4_loop_AttributeValueList_3; i_AttributeValueList_3++) {

                /*  Begin struct "Tango_AttributeValue_3"  */

                

                decode_Tango_AttributeValue_3_st(tvb, pinfo, tree, offset, header, operation);

                /*  End struct "Tango_AttributeValue_3"  */

            }

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device_3/write_attributes_3:1.0
 */

static void decode_Tango_Device_3_write_attributes_3(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4_loop_values;
    guint32   i_values;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        u_octet4_loop_values = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of values = %u",u_octet4_loop_values);
        }

        for (i_values=0; i_values < u_octet4_loop_values; i_values++) {

            /*  Begin struct "Tango_AttributeValue"  */

            

            decode_Tango_AttributeValue_st(tvb, pinfo, tree, offset, header, operation);

            /*  End struct "Tango_AttributeValue"  */

        }

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            /* Function returns void */

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device_3/read_attribute_history_3:1.0
 */

static void decode_Tango_Device_3_read_attribute_history_3(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    gint32    s_octet4;
    guint32   u_octet4_loop_DevAttrHistoryList_3;
    guint32   i_DevAttrHistoryList_3;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"name (%u) = %s",
              u_octet4, (u_octet4 > 0) ? seq : "");
        }

        g_free(seq);          /*  free buffer  */
        seq = NULL;

        s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-4,4,"n = %i",s_octet4);
        }

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            u_octet4_loop_DevAttrHistoryList_3 = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            if (tree) {
               proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of DevAttrHistoryList_3 = %u",u_octet4_loop_DevAttrHistoryList_3);
            }

            for (i_DevAttrHistoryList_3=0; i_DevAttrHistoryList_3 < u_octet4_loop_DevAttrHistoryList_3; i_DevAttrHistoryList_3++) {

                /*  Begin struct "Tango_DevAttrHistory_3"  */

                

                decode_Tango_DevAttrHistory_3_st(tvb, pinfo, tree, offset, header, operation);

                /*  End struct "Tango_DevAttrHistory_3"  */

            }

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device_3/info_3:1.0
 */

static void decode_Tango_Device_3_info_3(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            /*  Begin struct "Tango_DevInfo_3"  */

            

            decode_Tango_DevInfo_3_st(tvb, pinfo, tree, offset, header, operation);

            /*  End struct "Tango_DevInfo_3"  */

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device_3/get_attribute_config_3:1.0
 */

static void decode_Tango_Device_3_get_attribute_config_3(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4_loop_names;
    guint32   i_names;
    guint32   u_octet4;
    gchar   *seq = NULL;
    guint32   u_octet4_loop_AttributeConfigList_3;
    guint32   i_AttributeConfigList_3;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        u_octet4_loop_names = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of names = %u",u_octet4_loop_names);
        }

        for (i_names=0; i_names < u_octet4_loop_names; i_names++) {

            u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
            if (tree) {
               proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"names (%u) = %s",
                  u_octet4, (u_octet4 > 0) ? seq : "");
            }

            g_free(seq);          /*  free buffer  */
            seq = NULL;

        }

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            u_octet4_loop_AttributeConfigList_3 = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            if (tree) {
               proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of AttributeConfigList_3 = %u",u_octet4_loop_AttributeConfigList_3);
            }

            for (i_AttributeConfigList_3=0; i_AttributeConfigList_3 < u_octet4_loop_AttributeConfigList_3; i_AttributeConfigList_3++) {

                /*  Begin struct "Tango_AttributeConfig_3"  */

                

                decode_Tango_AttributeConfig_3_st(tvb, pinfo, tree, offset, header, operation);

                /*  End struct "Tango_AttributeConfig_3"  */

            }

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/*
 * IDL:Tango/Device_3/set_attribute_config_3:1.0
 */

static void decode_Tango_Device_3_set_attribute_config_3(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4_loop_new_conf;
    guint32   i_new_conf;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);

    switch(header->message_type) {

    case Request:

        u_octet4_loop_new_conf = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of new_conf = %u",u_octet4_loop_new_conf);
        }

        for (i_new_conf=0; i_new_conf < u_octet4_loop_new_conf; i_new_conf++) {

            /*  Begin struct "Tango_AttributeConfig_3"  */

            

            decode_Tango_AttributeConfig_3_st(tvb, pinfo, tree, offset, header, operation);

            /*  End struct "Tango_AttributeConfig_3"  */

        }

        break;

    case Reply:

        switch(header->rep_status) {

        case NO_EXCEPTION:

            /* Function returns void */

            break;

        case USER_EXCEPTION:

            break;

        default:

            /* Unknown Exception */

            g_warning("Unknown Exception ");

            break;

        
        }   /* switch(header->message_type) */

        break;

    default:

        /* Unknown GIOP Message */

        g_warning("Unknown GIOP Message");

        break;

    } /* switch(header->message_type) */

}

/* Struct = IDL:Tango/DevVarLongStringArray:1.0 */

static void decode_Tango_DevVarLongStringArray_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4_loop_DevVarLongStringArray_lvalue;
    guint32   i_DevVarLongStringArray_lvalue;
    gint32    s_octet4;
    guint32   u_octet4_loop_DevVarLongStringArray_svalue;
    guint32   i_DevVarLongStringArray_svalue;
    guint32   u_octet4;
    gchar   *seq = NULL;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4_loop_DevVarLongStringArray_lvalue = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of DevVarLongStringArray_lvalue = %u",u_octet4_loop_DevVarLongStringArray_lvalue);
    }

    for (i_DevVarLongStringArray_lvalue=0; i_DevVarLongStringArray_lvalue < u_octet4_loop_DevVarLongStringArray_lvalue; i_DevVarLongStringArray_lvalue++) {

        s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-4,4,"DevVarLongStringArray_lvalue = %i",s_octet4);
        }

    }

    u_octet4_loop_DevVarLongStringArray_svalue = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of DevVarLongStringArray_svalue = %u",u_octet4_loop_DevVarLongStringArray_svalue);
    }

    for (i_DevVarLongStringArray_svalue=0; i_DevVarLongStringArray_svalue < u_octet4_loop_DevVarLongStringArray_svalue; i_DevVarLongStringArray_svalue++) {

        u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevVarLongStringArray_svalue (%u) = %s",
              u_octet4, (u_octet4 > 0) ? seq : "");
        }

        g_free(seq);          /*  free buffer  */
        seq = NULL;

    }

}

/* Struct = IDL:Tango/DevVarDoubleStringArray:1.0 */

static void decode_Tango_DevVarDoubleStringArray_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4_loop_DevVarDoubleStringArray_dvalue;
    guint32   i_DevVarDoubleStringArray_dvalue;
    gdouble   my_double;
    guint32   u_octet4_loop_DevVarDoubleStringArray_svalue;
    guint32   i_DevVarDoubleStringArray_svalue;
    guint32   u_octet4;
    gchar   *seq = NULL;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4_loop_DevVarDoubleStringArray_dvalue = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of DevVarDoubleStringArray_dvalue = %u",u_octet4_loop_DevVarDoubleStringArray_dvalue);
    }

    for (i_DevVarDoubleStringArray_dvalue=0; i_DevVarDoubleStringArray_dvalue < u_octet4_loop_DevVarDoubleStringArray_dvalue; i_DevVarDoubleStringArray_dvalue++) {

        my_double = get_CDR_double(tvb,offset,stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-8,8,"DevVarDoubleStringArray_dvalue = %.15e",my_double);
        }

    }

    u_octet4_loop_DevVarDoubleStringArray_svalue = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of DevVarDoubleStringArray_svalue = %u",u_octet4_loop_DevVarDoubleStringArray_svalue);
    }

    for (i_DevVarDoubleStringArray_svalue=0; i_DevVarDoubleStringArray_svalue < u_octet4_loop_DevVarDoubleStringArray_svalue; i_DevVarDoubleStringArray_svalue++) {

        u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevVarDoubleStringArray_svalue (%u) = %s",
              u_octet4, (u_octet4 > 0) ? seq : "");
        }

        g_free(seq);          /*  free buffer  */
        seq = NULL;

    }

}

/* Struct = IDL:Tango/TimeVal:1.0 */

static void decode_Tango_TimeVal_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    gint32    s_octet4;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"TimeVal_tv_sec = %i",s_octet4);
    }

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"TimeVal_tv_usec = %i",s_octet4);
    }

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"TimeVal_tv_nsec = %i",s_octet4);
    }

}

/* Struct = IDL:Tango/DevCmdInfo:1.0 */

static void decode_Tango_DevCmdInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    gint32    s_octet4;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevCmdInfo_cmd_name (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"DevCmdInfo_cmd_tag = %i",s_octet4);
    }

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"DevCmdInfo_in_type = %i",s_octet4);
    }

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"DevCmdInfo_out_type = %i",s_octet4);
    }

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevCmdInfo_in_type_desc (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevCmdInfo_out_type_desc (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

}

/* Struct = IDL:Tango/DevCmdInfo_2:1.0 */

static void decode_Tango_DevCmdInfo_2_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    gint32    s_octet4;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevCmdInfo_2_cmd_name (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    
    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"Enum value = %u (%s)",u_octet4,val_to_str(u_octet4,Tango_DispLevel,"Unknown Enum Value"));
    }

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"DevCmdInfo_2_cmd_tag = %i",s_octet4);
    }

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"DevCmdInfo_2_in_type = %i",s_octet4);
    }

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"DevCmdInfo_2_out_type = %i",s_octet4);
    }

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevCmdInfo_2_in_type_desc (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevCmdInfo_2_out_type_desc (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

}

/* Struct = IDL:Tango/DevError:1.0 */

static void decode_Tango_DevError_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevError_reason (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    
    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"Enum value = %u (%s)",u_octet4,val_to_str(u_octet4,Tango_ErrSeverity,"Unknown Enum Value"));
    }

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevError_desc (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevError_origin (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

}

/* Struct = IDL:Tango/NamedDevError:1.0 */

static void decode_Tango_NamedDevError_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    gint32    s_octet4;
    guint32   u_octet4_loop_NamedDevError_err_list;
    guint32   i_NamedDevError_err_list;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"NamedDevError_name (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"NamedDevError_index_in_call = %i",s_octet4);
    }

    u_octet4_loop_NamedDevError_err_list = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of NamedDevError_err_list = %u",u_octet4_loop_NamedDevError_err_list);
    }

    for (i_NamedDevError_err_list=0; i_NamedDevError_err_list < u_octet4_loop_NamedDevError_err_list; i_NamedDevError_err_list++) {

        /*  Begin struct "Tango_DevError"  */

        

        decode_Tango_DevError_st(tvb, pinfo, tree, offset, header, operation);

        /*  End struct "Tango_DevError"  */

    }

}

/* Struct = IDL:Tango/AttributeConfig:1.0 */

static void decode_Tango_AttributeConfig_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    gint32    s_octet4;
    guint32   u_octet4_loop_AttributeConfig_extensions;
    guint32   i_AttributeConfig_extensions;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_name (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    
    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"Enum value = %u (%s)",u_octet4,val_to_str(u_octet4,Tango_AttrWriteType,"Unknown Enum Value"));
    }

    
    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"Enum value = %u (%s)",u_octet4,val_to_str(u_octet4,Tango_AttrDataFormat,"Unknown Enum Value"));
    }

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"AttributeConfig_data_type = %i",s_octet4);
    }

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"AttributeConfig_max_dim_x = %i",s_octet4);
    }

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"AttributeConfig_max_dim_y = %i",s_octet4);
    }

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_description (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_label (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_unit (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_standard_unit (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_display_unit (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_format (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_min_value (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_max_value (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_min_alarm (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_max_alarm (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_writable_attr_name (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4_loop_AttributeConfig_extensions = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of AttributeConfig_extensions = %u",u_octet4_loop_AttributeConfig_extensions);
    }

    for (i_AttributeConfig_extensions=0; i_AttributeConfig_extensions < u_octet4_loop_AttributeConfig_extensions; i_AttributeConfig_extensions++) {

        u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_extensions (%u) = %s",
              u_octet4, (u_octet4 > 0) ? seq : "");
        }

        g_free(seq);          /*  free buffer  */
        seq = NULL;

    }

}

/* Struct = IDL:Tango/AttributeConfig_2:1.0 */

static void decode_Tango_AttributeConfig_2_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    gint32    s_octet4;
    guint32   u_octet4_loop_AttributeConfig_2_extensions;
    guint32   i_AttributeConfig_2_extensions;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_2_name (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    
    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"Enum value = %u (%s)",u_octet4,val_to_str(u_octet4,Tango_AttrWriteType,"Unknown Enum Value"));
    }

    
    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"Enum value = %u (%s)",u_octet4,val_to_str(u_octet4,Tango_AttrDataFormat,"Unknown Enum Value"));
    }

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"AttributeConfig_2_data_type = %i",s_octet4);
    }

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"AttributeConfig_2_max_dim_x = %i",s_octet4);
    }

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"AttributeConfig_2_max_dim_y = %i",s_octet4);
    }

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_2_description (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_2_label (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_2_unit (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_2_standard_unit (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_2_display_unit (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_2_format (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_2_min_value (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_2_max_value (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_2_min_alarm (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_2_max_alarm (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_2_writable_attr_name (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    
    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"Enum value = %u (%s)",u_octet4,val_to_str(u_octet4,Tango_DispLevel,"Unknown Enum Value"));
    }

    u_octet4_loop_AttributeConfig_2_extensions = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of AttributeConfig_2_extensions = %u",u_octet4_loop_AttributeConfig_2_extensions);
    }

    for (i_AttributeConfig_2_extensions=0; i_AttributeConfig_2_extensions < u_octet4_loop_AttributeConfig_2_extensions; i_AttributeConfig_2_extensions++) {

        u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_2_extensions (%u) = %s",
              u_octet4, (u_octet4 > 0) ? seq : "");
        }

        g_free(seq);          /*  free buffer  */
        seq = NULL;

    }

}

/* Struct = IDL:Tango/AttributeValue:1.0 */

static void decode_Tango_AttributeValue_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    gint32    s_octet4;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    get_CDR_any(tvb,tree,offset,stream_is_big_endian, boundary, header);

    
    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"Enum value = %u (%s)",u_octet4,val_to_str(u_octet4,Tango_AttrQuality,"Unknown Enum Value"));
    }

    /*  Begin struct "Tango_TimeVal"  */

    

    decode_Tango_TimeVal_st(tvb, pinfo, tree, offset, header, operation);

    /*  End struct "Tango_TimeVal"  */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeValue_name (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"AttributeValue_dim_x = %i",s_octet4);
    }

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"AttributeValue_dim_y = %i",s_octet4);
    }

}

/* Struct = IDL:Tango/AttributeDim:1.0 */

static void decode_Tango_AttributeDim_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    gint32    s_octet4;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"AttributeDim_dim_x = %i",s_octet4);
    }

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"AttributeDim_dim_y = %i",s_octet4);
    }

}

/* Struct = IDL:Tango/AttributeValue_3:1.0 */

static void decode_Tango_AttributeValue_3_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    guint32   u_octet4_loop_AttributeValue_3_err_list;
    guint32   i_AttributeValue_3_err_list;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    get_CDR_any(tvb,tree,offset,stream_is_big_endian, boundary, header);

    
    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"Enum value = %u (%s)",u_octet4,val_to_str(u_octet4,Tango_AttrQuality,"Unknown Enum Value"));
    }

    /*  Begin struct "Tango_TimeVal"  */

    

    decode_Tango_TimeVal_st(tvb, pinfo, tree, offset, header, operation);

    /*  End struct "Tango_TimeVal"  */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeValue_3_name (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    /*  Begin struct "Tango_AttributeDim"  */

    

    decode_Tango_AttributeDim_st(tvb, pinfo, tree, offset, header, operation);

    /*  End struct "Tango_AttributeDim"  */

    /*  Begin struct "Tango_AttributeDim"  */

    

    decode_Tango_AttributeDim_st(tvb, pinfo, tree, offset, header, operation);

    /*  End struct "Tango_AttributeDim"  */

    u_octet4_loop_AttributeValue_3_err_list = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of AttributeValue_3_err_list = %u",u_octet4_loop_AttributeValue_3_err_list);
    }

    for (i_AttributeValue_3_err_list=0; i_AttributeValue_3_err_list < u_octet4_loop_AttributeValue_3_err_list; i_AttributeValue_3_err_list++) {

        /*  Begin struct "Tango_DevError"  */

        

        decode_Tango_DevError_st(tvb, pinfo, tree, offset, header, operation);

        /*  End struct "Tango_DevError"  */

    }

}

/* Struct = IDL:Tango/ChangeEventProp:1.0 */

static void decode_Tango_ChangeEventProp_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    guint32   u_octet4_loop_ChangeEventProp_extensions;
    guint32   i_ChangeEventProp_extensions;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"ChangeEventProp_rel_change (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"ChangeEventProp_abs_change (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4_loop_ChangeEventProp_extensions = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of ChangeEventProp_extensions = %u",u_octet4_loop_ChangeEventProp_extensions);
    }

    for (i_ChangeEventProp_extensions=0; i_ChangeEventProp_extensions < u_octet4_loop_ChangeEventProp_extensions; i_ChangeEventProp_extensions++) {

        u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"ChangeEventProp_extensions (%u) = %s",
              u_octet4, (u_octet4 > 0) ? seq : "");
        }

        g_free(seq);          /*  free buffer  */
        seq = NULL;

    }

}

/* Struct = IDL:Tango/PeriodicEventProp:1.0 */

static void decode_Tango_PeriodicEventProp_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    guint32   u_octet4_loop_PeriodicEventProp_extensions;
    guint32   i_PeriodicEventProp_extensions;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"PeriodicEventProp_period (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4_loop_PeriodicEventProp_extensions = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of PeriodicEventProp_extensions = %u",u_octet4_loop_PeriodicEventProp_extensions);
    }

    for (i_PeriodicEventProp_extensions=0; i_PeriodicEventProp_extensions < u_octet4_loop_PeriodicEventProp_extensions; i_PeriodicEventProp_extensions++) {

        u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"PeriodicEventProp_extensions (%u) = %s",
              u_octet4, (u_octet4 > 0) ? seq : "");
        }

        g_free(seq);          /*  free buffer  */
        seq = NULL;

    }

}

/* Struct = IDL:Tango/ArchiveEventProp:1.0 */

static void decode_Tango_ArchiveEventProp_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    guint32   u_octet4_loop_ArchiveEventProp_extensions;
    guint32   i_ArchiveEventProp_extensions;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"ArchiveEventProp_rel_change (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"ArchiveEventProp_abs_change (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"ArchiveEventProp_period (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4_loop_ArchiveEventProp_extensions = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of ArchiveEventProp_extensions = %u",u_octet4_loop_ArchiveEventProp_extensions);
    }

    for (i_ArchiveEventProp_extensions=0; i_ArchiveEventProp_extensions < u_octet4_loop_ArchiveEventProp_extensions; i_ArchiveEventProp_extensions++) {

        u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"ArchiveEventProp_extensions (%u) = %s",
              u_octet4, (u_octet4 > 0) ? seq : "");
        }

        g_free(seq);          /*  free buffer  */
        seq = NULL;

    }

}

/* Struct = IDL:Tango/EventProperties:1.0 */

static void decode_Tango_EventProperties_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    /*  Begin struct "Tango_ChangeEventProp"  */

    

    decode_Tango_ChangeEventProp_st(tvb, pinfo, tree, offset, header, operation);

    /*  End struct "Tango_ChangeEventProp"  */

    /*  Begin struct "Tango_PeriodicEventProp"  */

    

    decode_Tango_PeriodicEventProp_st(tvb, pinfo, tree, offset, header, operation);

    /*  End struct "Tango_PeriodicEventProp"  */

    /*  Begin struct "Tango_ArchiveEventProp"  */

    

    decode_Tango_ArchiveEventProp_st(tvb, pinfo, tree, offset, header, operation);

    /*  End struct "Tango_ArchiveEventProp"  */

}

/* Struct = IDL:Tango/AttributeAlarm:1.0 */

static void decode_Tango_AttributeAlarm_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    guint32   u_octet4_loop_AttributeAlarm_extensions;
    guint32   i_AttributeAlarm_extensions;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeAlarm_min_alarm (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeAlarm_max_alarm (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeAlarm_min_warning (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeAlarm_max_warning (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeAlarm_delta_t (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeAlarm_delta_val (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4_loop_AttributeAlarm_extensions = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of AttributeAlarm_extensions = %u",u_octet4_loop_AttributeAlarm_extensions);
    }

    for (i_AttributeAlarm_extensions=0; i_AttributeAlarm_extensions < u_octet4_loop_AttributeAlarm_extensions; i_AttributeAlarm_extensions++) {

        u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeAlarm_extensions (%u) = %s",
              u_octet4, (u_octet4 > 0) ? seq : "");
        }

        g_free(seq);          /*  free buffer  */
        seq = NULL;

    }

}

/* Struct = IDL:Tango/AttributeConfig_3:1.0 */

static void decode_Tango_AttributeConfig_3_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    gint32    s_octet4;
    guint32   u_octet4_loop_AttributeConfig_3_extensions;
    guint32   i_AttributeConfig_3_extensions;
    guint32   u_octet4_loop_AttributeConfig_3_sys_extensions;
    guint32   i_AttributeConfig_3_sys_extensions;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_3_name (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    
    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"Enum value = %u (%s)",u_octet4,val_to_str(u_octet4,Tango_AttrWriteType,"Unknown Enum Value"));
    }

    
    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"Enum value = %u (%s)",u_octet4,val_to_str(u_octet4,Tango_AttrDataFormat,"Unknown Enum Value"));
    }

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"AttributeConfig_3_data_type = %i",s_octet4);
    }

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"AttributeConfig_3_max_dim_x = %i",s_octet4);
    }

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"AttributeConfig_3_max_dim_y = %i",s_octet4);
    }

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_3_description (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_3_label (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_3_unit (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_3_standard_unit (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_3_display_unit (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_3_format (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_3_min_value (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_3_max_value (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_3_writable_attr_name (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    
    u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"Enum value = %u (%s)",u_octet4,val_to_str(u_octet4,Tango_DispLevel,"Unknown Enum Value"));
    }

    /*  Begin struct "Tango_AttributeAlarm"  */

    

    decode_Tango_AttributeAlarm_st(tvb, pinfo, tree, offset, header, operation);

    /*  End struct "Tango_AttributeAlarm"  */

    /*  Begin struct "Tango_EventProperties"  */

    

    decode_Tango_EventProperties_st(tvb, pinfo, tree, offset, header, operation);

    /*  End struct "Tango_EventProperties"  */

    u_octet4_loop_AttributeConfig_3_extensions = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of AttributeConfig_3_extensions = %u",u_octet4_loop_AttributeConfig_3_extensions);
    }

    for (i_AttributeConfig_3_extensions=0; i_AttributeConfig_3_extensions < u_octet4_loop_AttributeConfig_3_extensions; i_AttributeConfig_3_extensions++) {

        u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_3_extensions (%u) = %s",
              u_octet4, (u_octet4 > 0) ? seq : "");
        }

        g_free(seq);          /*  free buffer  */
        seq = NULL;

    }

    u_octet4_loop_AttributeConfig_3_sys_extensions = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of AttributeConfig_3_sys_extensions = %u",u_octet4_loop_AttributeConfig_3_sys_extensions);
    }

    for (i_AttributeConfig_3_sys_extensions=0; i_AttributeConfig_3_sys_extensions < u_octet4_loop_AttributeConfig_3_sys_extensions; i_AttributeConfig_3_sys_extensions++) {

        u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
        if (tree) {
           proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"AttributeConfig_3_sys_extensions (%u) = %s",
              u_octet4, (u_octet4 > 0) ? seq : "");
        }

        g_free(seq);          /*  free buffer  */
        seq = NULL;

    }

}

/* Struct = IDL:Tango/DevInfo:1.0 */

static void decode_Tango_DevInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    gint32    s_octet4;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevInfo_dev_class (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevInfo_server_id (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevInfo_server_host (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"DevInfo_server_version = %i",s_octet4);
    }

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevInfo_doc_url (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

}

/* Struct = IDL:Tango/DevInfo_3:1.0 */

static void decode_Tango_DevInfo_3_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint32   u_octet4;
    gchar   *seq = NULL;
    gint32    s_octet4;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevInfo_3_dev_class (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevInfo_3_server_id (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevInfo_3_server_host (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    s_octet4 = get_CDR_long(tvb,offset,stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4,4,"DevInfo_3_server_version = %i",s_octet4);
    }

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevInfo_3_doc_url (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

    u_octet4 = get_CDR_string(tvb, &seq, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-u_octet4,u_octet4,"DevInfo_3_dev_type (%u) = %s",
          u_octet4, (u_octet4 > 0) ? seq : "");
    }

    g_free(seq);          /*  free buffer  */
    seq = NULL;

}

/* Struct = IDL:Tango/DevCmdHistory:1.0 */

static void decode_Tango_DevCmdHistory_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint8    u_octet1;
    guint32   u_octet4_loop_DevCmdHistory_errors;
    guint32   i_DevCmdHistory_errors;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    /*  Begin struct "Tango_TimeVal"  */

    

    decode_Tango_TimeVal_st(tvb, pinfo, tree, offset, header, operation);

    /*  End struct "Tango_TimeVal"  */

    u_octet1 = get_CDR_boolean(tvb,offset);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-1,1,"DevCmdHistory_cmd_failed = %u",u_octet1);
    }

    get_CDR_any(tvb,tree,offset,stream_is_big_endian, boundary, header);

    u_octet4_loop_DevCmdHistory_errors = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of DevCmdHistory_errors = %u",u_octet4_loop_DevCmdHistory_errors);
    }

    for (i_DevCmdHistory_errors=0; i_DevCmdHistory_errors < u_octet4_loop_DevCmdHistory_errors; i_DevCmdHistory_errors++) {

        /*  Begin struct "Tango_DevError"  */

        

        decode_Tango_DevError_st(tvb, pinfo, tree, offset, header, operation);

        /*  End struct "Tango_DevError"  */

    }

}

/* Struct = IDL:Tango/DevAttrHistory:1.0 */

static void decode_Tango_DevAttrHistory_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint8    u_octet1;
    guint32   u_octet4_loop_DevAttrHistory_errors;
    guint32   i_DevAttrHistory_errors;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet1 = get_CDR_boolean(tvb,offset);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-1,1,"DevAttrHistory_attr_failed = %u",u_octet1);
    }

    /*  Begin struct "Tango_AttributeValue"  */

    

    decode_Tango_AttributeValue_st(tvb, pinfo, tree, offset, header, operation);

    /*  End struct "Tango_AttributeValue"  */

    u_octet4_loop_DevAttrHistory_errors = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-4, 4 ,"Seq length of DevAttrHistory_errors = %u",u_octet4_loop_DevAttrHistory_errors);
    }

    for (i_DevAttrHistory_errors=0; i_DevAttrHistory_errors < u_octet4_loop_DevAttrHistory_errors; i_DevAttrHistory_errors++) {

        /*  Begin struct "Tango_DevError"  */

        

        decode_Tango_DevError_st(tvb, pinfo, tree, offset, header, operation);

        /*  End struct "Tango_DevError"  */

    }

}

/* Struct = IDL:Tango/DevAttrHistory_3:1.0 */

static void decode_Tango_DevAttrHistory_3_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, gchar *operation _U_) {

    gboolean stream_is_big_endian;          /* big endianess */

    
    /* Operation specific Variable declarations Begin */

    guint8    u_octet1;
    
    /* Operation specific Variable declarations End */

    stream_is_big_endian = is_big_endian(header);  /* get stream endianess */

    u_octet1 = get_CDR_boolean(tvb,offset);
    if (tree) {
       proto_tree_add_text(tree,tvb,*offset-1,1,"DevAttrHistory_3_attr_failed = %u",u_octet1);
    }

    /*  Begin struct "Tango_AttributeValue_3"  */

    

    decode_Tango_AttributeValue_3_st(tvb, pinfo, tree, offset, header, operation);

    /*  End struct "Tango_AttributeValue_3"  */

}

/*
 * Called once we accept the packet as being for us; it sets the
 * Protocol and Info columns and creates the top-level protocol
 * tree item.
 */
static proto_tree *start_dissecting(tvbuff_t *tvb, packet_info *pinfo, proto_tree *ptree, int *offset) {

    proto_item *ti = NULL;
    proto_tree *tree = NULL;            /* init later, inside if(tree) */

    if (check_col(pinfo->cinfo, COL_PROTOCOL))
        col_set_str(pinfo->cinfo, COL_PROTOCOL, "TANGO");

    /*
     * Do not clear COL_INFO, as nothing is being written there by
     * this dissector yet. So leave it as is from the GIOP dissector.
     * TODO: add something useful to COL_INFO
     *  if (check_col(pinfo->cinfo, COL_INFO))
     *     col_clear(pinfo->cinfo, COL_INFO);
     */

    if (ptree) {
        ti = proto_tree_add_item(ptree, proto_tango, tvb, *offset, -1, FALSE);
        tree = proto_item_add_subtree(ti, ett_tango);
    }
    return tree;
}

static gboolean dissect_tango(tvbuff_t *tvb, packet_info *pinfo, proto_tree *ptree, int *offset, MessageHeader *header, gchar *operation, gchar *idlname) {

    gboolean be;                        /* big endianess */
    proto_tree *tree _U_;

    be = is_big_endian(header);         /* get endianess - TODO use passed in stream_is_big_endian instead ? */

    /* If we have a USER Exception, then decode it and return */

    if ((header->message_type == Reply) && (header->rep_status == USER_EXCEPTION)) {

       return decode_user_exception(tvb, pinfo, ptree, offset, header, operation);

    }

    switch(header->message_type) {

    case Request:
    case Reply:

        if (strcmp(operation, Tango_Device_command_inout_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_command_inout(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_get_attribute_config_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_get_attribute_config(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_set_attribute_config_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_set_attribute_config(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_read_attributes_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_read_attributes(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_write_attributes_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_write_attributes(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_ping_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_ping(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_black_box_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_black_box(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_info_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_info(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_command_list_query_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_command_list_query(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_command_query_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_command_query(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_2_command_inout_2_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device_2") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_2_command_inout_2(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_2_read_attributes_2_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device_2") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_2_read_attributes_2(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_2_get_attribute_config_2_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device_2") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_2_get_attribute_config_2(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_2_command_list_query_2_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device_2") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_2_command_list_query_2(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_2_command_query_2_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device_2") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_2_command_query_2(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_2_command_inout_history_2_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device_2") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_2_command_inout_history_2(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_2_read_attribute_history_2_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device_2") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_2_read_attribute_history_2(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_3_read_attributes_3_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device_3") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_3_read_attributes_3(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_3_write_attributes_3_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device_3") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_3_write_attributes_3(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_3_read_attribute_history_3_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device_3") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_3_read_attribute_history_3(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_3_info_3_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device_3") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_3_info_3(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_3_get_attribute_config_3_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device_3") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_3_get_attribute_config_3(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, Tango_Device_3_set_attribute_config_3_op) == 0
            && (!idlname || strcmp(idlname, "Tango/Device_3") == 0)) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_Tango_Device_3_set_attribute_config_3(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, get_Tango_Device_name_at) == 0 && (header->message_type == Reply) && (header->rep_status == NO_EXCEPTION) ) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_get_Tango_Device_name_at(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, get_Tango_Device_description_at) == 0 && (header->message_type == Reply) && (header->rep_status == NO_EXCEPTION) ) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_get_Tango_Device_description_at(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, get_Tango_Device_state_at) == 0 && (header->message_type == Reply) && (header->rep_status == NO_EXCEPTION) ) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_get_Tango_Device_state_at(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, get_Tango_Device_status_at) == 0 && (header->message_type == Reply) && (header->rep_status == NO_EXCEPTION) ) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_get_Tango_Device_status_at(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        if (strcmp(operation, get_Tango_Device_adm_name_at) == 0 && (header->message_type == Reply) && (header->rep_status == NO_EXCEPTION) ) {
           tree = start_dissecting(tvb, pinfo, ptree, offset);
           decode_get_Tango_Device_adm_name_at(tvb, pinfo, tree, offset, header, operation);
           return TRUE;
        }

        
        break;

    case CancelRequest:
    case LocateRequest:
    case LocateReply:
    case CloseConnection:
    case MessageError:
    case Fragment:
       return FALSE;      /* not handled yet */

    default:
       return FALSE;      /* not handled yet */

    }   /* switch */


    return FALSE;

}  /* End of main dissector  */



/* Register the protocol with Wireshark */

void proto_register_giop_tango(void) {

   /* setup list of header fields */

#if 0
   static hf_register_info hf[] = {

      /* no fields yet */

   };
#endif

   /* setup protocol subtree array */

   static gint *ett[] = {
      &ett_tango,
   };

   /* Register the protocol name and description */

   proto_tango = proto_register_protocol("Tango Dissector Using GIOP API" , "TANGO", "giop-tango" );

#if 0
   proto_register_field_array(proto_tango, hf, array_length(hf));
#endif
   proto_register_subtree_array(ett,array_length(ett));

}


/* register me as handler for these interfaces */

void proto_register_handoff_giop_tango(void) {


    
    /* Register for Explicit Dissection */

    register_giop_user_module(dissect_tango, "TANGO", "Tango/Device", proto_tango );     /* explicit dissector */

    
    /* Register for Explicit Dissection */

    register_giop_user_module(dissect_tango, "TANGO", "Tango/Device_2", proto_tango );     /* explicit dissector */

    
    /* Register for Explicit Dissection */

    register_giop_user_module(dissect_tango, "TANGO", "Tango/Device_3", proto_tango );     /* explicit dissector */

    
    /* Register for Heuristic Dissection */

    register_giop_user(dissect_tango, "TANGO" ,proto_tango);     /* heuristic dissector */


}


#ifndef ENABLE_STATIC

G_MODULE_EXPORT void
plugin_register(void)
{
   if (proto_tango == -1) {
     proto_register_giop_tango();
   }
}

G_MODULE_EXPORT void
plugin_reg_handoff(void){
   proto_register_handoff_giop_tango();
}
#endif

