#!/usr/bin/python

################################################################################
# Copyright (c) 2004-2005 Christoph Wegscheider <cw@wegi.net>                  #
#                                                                              #
# Permission is hereby granted, free of charge, to any person obtaining a copy #
# of this software and associated documentation files (the "Software"), to     #
# deal in the Software without restriction, including without limitation the   #
# rights to use, copy, modify, merge, publish, distribute, sublicense, and/or  #
# sell copies of the Software, and to permit persons to whom the Software is   #
# furnished to do so, subject to the following conditions:                     #
#                                                                              #
# The above copyright notice and this permission notice shall be included in   #
# all copies or substantial portions of the Software.                          #
#                                                                              #
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR   #
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,     #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE  #
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER       #
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING      #
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS #
# IN THE SOFTWARE.                                                             #
################################################################################

import sys
import os
import time
import signal
import ixplib


default_sockfile = os.environ['HOME'] + '/.wmii/ixp/testserver.py-' + os.environ['DISPLAY']
server = ixplib.Server(default_sockfile)

pid = os.fork()
if pid == None:
	print "can't fork"
elif pid > 0:
	server.addfile('/hello_world')
	print "server starting ..."
	server.start()
else:
	try:
		while True:
			time.sleep(1)
	except:
		print "server stopping ..."
		os.kill(pid, signal.SIGTERM)
