#!/bin/sh

DELAY=2
MYPID=$$

remove_own_pidfile() {
    [ -f "$STATUS_PIDFILE" ] && \
        [ "`cat \"$STATUS_PIDFILE\"`" -eq $MYPID ] && \
        rm "$STATUS_PIDFILE"
}

#-----------------------------------------------------------------------

if [ -r "$HOME/.wmii/rc.conf" ]; then
    . "$HOME/.wmii/rc.conf"
elif [ -r "$WMII_CONFDIR/rc.conf" ]; then
    . "$WMII_CONFDIR/rc.conf"
else
    echo "`basename $0`: error: couldn't read rc.conf" >&2
    exit 1
fi

if [ -f "$STATUS_PIDFILE" ]; then
    # another status.sh may still be running; try to kill it
    kill "`cat \"$STATUS_PIDFILE\"`" >/dev/null 2>&1
fi
echo $MYPID > "$STATUS_PIDFILE"
trap "remove_own_pidfile; exit" TERM

while true; do
    if $READ /bar >/dev/null 2>&1; then
        text="`date` `uptime | sed -e 's/.*://' -e 's/,//g'`"
        $WRITE /bar/default/70_status/label/text "$text" 2>/dev/null
        sleep $DELAY
    else
        # exit if wmibar or wmifs aren't running
        remove_own_pidfile
        break
    fi
done
