#include <gtk/gtk.h>
#include <gnome.h>

GtkWidget *window, *edit_window, *new_window;
GtkWidget *vbox;
GtkWidget *vbox_notebook;
GtkWidget *notebook;
GtkWidget *label;
GtkWidget *frame;
GtkWidget *radio_cs, *radio_as, *radio_ss;
GtkWidget *vbox_tab_1, *vbox_tab_2;
GtkWidget *flag_pixmap_entry, *initials_pixmap_entry, *alternate_pixmap_entry, *name_entry;
GtkWidget *hbox;
GtkWidget *combo_default, *combo_alternate;
GtkWidget *button;
GtkWidget *clist;
gchar *clist_titles[4]={ "Keymap", "KC", "KS per KC", "Total KS" };
GSList *group;
GList *available_keymaps;
int selected_row=51;
char FlagIcon_filename_temp[200];
char Alternate_filename_temp[200];
char Initials_filename_temp[200];
GtkWidget *entry_pass;
GtkWidget *entry_1, *entry_2, *entry_3, *entry_4;
int hex=0;
int base_keymap=0;
long int key_op[4];
int keysym_num;
int keysym_num1;
int category;
int categorykeysym;
char *font_name;
GtkStyle *modstyle = NULL;

struct KeyboardButton {
	char keysym[4][3];
	int keycode;
	int hex[4];
	int changed[4];
};

KeyboardButton kb_button[134];
KeyboardButton *kbb_ptr;

static void CloseWindow( GtkWidget *widget, gpointer *data );
void NewKeymapMain( void );
void set_combos( void );

void ErrorOk( GtkWidget *widget )
{
	gtk_widget_destroy( widget );
	widget = NULL;
	gtk_widget_set_sensitive( window, TRUE );
}

void DisplayError( char *error )
{
	gtk_widget_set_sensitive( window, FALSE );
	
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *label;
	GtkWidget *button;

	window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_container_set_border_width( GTK_CONTAINER( window ), 5 );
	gtk_widget_set_usize( window, 200, 80 );
	gtk_window_set_title( GTK_WINDOW( window ), "Error" );
	gtk_signal_connect_object( GTK_OBJECT( window ), "delete_event",
			GTK_SIGNAL_FUNC( ErrorOk ), GTK_OBJECT( window ));

	vbox = gtk_vbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( window ), vbox );
	gtk_widget_show( vbox );

	label = gtk_label_new( error );
	gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, TRUE, 0 );
	gtk_widget_show( label );

	button = gtk_button_new_with_label( "Ok" );
	gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, TRUE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked", 
			GTK_SIGNAL_FUNC( ErrorOk ), GTK_OBJECT( window ));
	gtk_widget_show( button );
	
	GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
	gtk_widget_grab_default( button );
	
	gtk_widget_show( window );
}

void font_selected( GtkWidget *widget, GtkWidget *gfsd )
{
	GtkFontSelectionDialog *fsd = GTK_FONT_SELECTION_DIALOG( gfsd );

	font_name = gtk_font_selection_dialog_get_font_name( fsd );

	gtk_widget_destroy( gfsd );
}

gchar *select_font( void )
{
	GtkWidget *widget;
	GtkFontSelectionDialog *gfsd;
	font_name = NULL;
	
	widget = gtk_font_selection_dialog_new( "Select Font" );
	gfsd = GTK_FONT_SELECTION_DIALOG( widget );
	gtk_signal_connect( GTK_OBJECT( gfsd ), "destroy",
		  GTK_SIGNAL_FUNC( gtk_main_quit ), NULL );
	
	gtk_signal_connect( GTK_OBJECT( gfsd->ok_button ), "clicked",
		  GTK_SIGNAL_FUNC( font_selected ), gfsd );
	
	gtk_signal_connect_object( GTK_OBJECT( gfsd->cancel_button ), "clicked",
		  GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( gfsd ));

	gtk_widget_show( widget );

	gtk_main();

	return(font_name);
}

void set_font( GtkWidget *widget, gpointer data )
{
	GtkStyle *style;

	style = (GtkStyle *)data;
	gtk_widget_set_style( widget, style );

	if( GTK_IS_CONTAINER( widget ) )
	   gtk_container_foreach( GTK_CONTAINER( widget ), set_font, style );
}

GtkStyle *create_new_style( GdkFont *font )
{
	GtkStyle *style;
	GtkStyle *newstyle;
	int i;

	style = gtk_widget_get_default_style();

	newstyle = gtk_style_copy( style );
	newstyle->font = font;

	return(newstyle);
}

void menu_font( GtkWidget *widget, gpointer data )
{
   	GtkStyle *style;
	GdkFont *font;
	char *fn;

	fn = select_font();
	if( fn!=NULL )
	{
		font = gdk_font_load( fn );
		g_free( fn );

		font_name = NULL;

		style = create_new_style( font );

		modstyle = style;

		set_font( widget, (gpointer)style );
	}
}

void set_keysym_num( GtkWidget *widget, gpointer num )
{
	keysym_num = (int)num;
}

void set_keysym_num1( GtkWidget *widget, gpointer num )
{
	keysym_num1 = (int)num;
}

void set_kbb_edit( KeyboardButton *kbb )
{
	kbb_ptr = kbb;
}

void About( void )
{
	GtkWidget *window;
	const char *authors[] = { "Dimitris Economou <trackman@mfa.gr>", NULL };
	
	window = gnome_about_new(_("WMKeyboard"), VERSION, 
		  _("Copyright (C) 2000 Dimitris Economou"), authors, _("Released under the terms of the GNU General Public License"), NULL );

	gtk_widget_show( window );
}

void set_switchmethod_1( GtkWidget *widget, gpointer *data )
{
	SwitchMethod=1;
}

void set_switchmethod_2( GtkWidget *widget, gpointer *data )
{
	SwitchMethod=2;
}

void set_switchmethod_3( GtkWidget *widget, gpointer *data )
{
	SwitchMethod=3;
}

static void CloseWindow( GtkWidget *widget, gpointer *data )
{
	gtk_widget_destroy( GTK_WIDGET( window ));
	
	selected_row=51;
	
	gtk_main_quit();
}

void load_clist_data( int clear )
{
	gchar *loaded_keymaps[num_of_keymaps][4];
	
	if( clear==1 )
		gtk_clist_clear( GTK_CLIST( clist ));
	
	for( i=0; i<num_of_keymaps; i++ )
	{
		loaded_keymaps[i][0]=keymaps[i].name;
		loaded_keymaps[i][1]=(gchar *) "134";
		loaded_keymaps[i][2]=NULL;//(gchar *) keymaps[i].keysyms_per_keycode;
		loaded_keymaps[i][3]=NULL;//(gchar *) "134*KS_p_KC"; 
		gtk_clist_append( GTK_CLIST( clist ), loaded_keymaps[i] );
	}
	gtk_widget_show( clist );
}

void clist_select_update( GtkWidget *widget, gint row, gint column, 
	GdkEventButton *event, gpointer data )
{
	selected_row=row;
}

void clist_select_update_1( GtkWidget *widget, gint row, gint column, 
	GdkEventButton *event, gpointer data )
{
	base_keymap=row;
}

void PleaseSelectKeymap( void )
{
	GtkWidget *pwindow;
	GtkWidget *vbox;
	GtkWidget *label;
	GtkWidget *button;
	GtkWidget *frame;
	
	gtk_widget_set_sensitive( window, FALSE );
	
	pwindow = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_widget_set_usize( GTK_WIDGET( pwindow ), 250, 100 );
	gtk_window_set_title( GTK_WINDOW( pwindow ), "Error" );
	gtk_container_border_width( GTK_CONTAINER( pwindow ), 5 );
	
	vbox = gtk_vbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( pwindow ), vbox );
	gtk_widget_show( vbox );
	
	frame = gtk_frame_new( "WMKeyboard: Options -> Keymaps" );
	gtk_box_pack_start( GTK_BOX( vbox ), frame, TRUE, TRUE, 0 );
	gtk_widget_show( frame );
	
	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox );
	gtk_widget_show( vbox );
	
	label = gtk_label_new( "Please select a keymap first." );	
	gtk_box_pack_start( GTK_BOX( vbox ), label, TRUE, TRUE, 0 );
	gtk_widget_show( label );
	
	button = gtk_button_new_with_label( "Ok" );
	gtk_box_pack_start( GTK_BOX( vbox ), button, TRUE, TRUE, 0 );
	GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
	gtk_widget_grab_default( button );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( ErrorOk ), GTK_OBJECT( pwindow ));
	gtk_widget_show( button );
	
	gtk_widget_show( pwindow );
}

void Edit_SaveKeymapOptions( GtkWidget *widget )
{
	sprintf( keymaps[selected_row].name, "%s", gtk_entry_get_text( GTK_ENTRY( name_entry )));
	load_clist_data( 1 );
	sprintf( keymaps[selected_row].FlagIcon_filename, "%s", gtk_entry_get_text( 
			GTK_ENTRY( flag_pixmap_entry )));
	sprintf( keymaps[selected_row].Alternate_filename, "%s", gtk_entry_get_text( 
			GTK_ENTRY( alternate_pixmap_entry )));
	sprintf( keymaps[selected_row].Initials_filename, "%s",gtk_entry_get_text( 
			GTK_ENTRY( initials_pixmap_entry )));
	gtk_widget_destroy( widget );	
	gtk_widget_set_sensitive( window , TRUE );
	modstyle = NULL;
}

void New_SaveKeymapOptions( GtkWidget *widget )
{
	sprintf( keymaps[num_of_keymaps].name, "%s", gtk_entry_get_text( GTK_ENTRY( name_entry )));
	sprintf( keymaps[num_of_keymaps].FlagIcon_filename, "%s", gtk_entry_get_text( 
			GTK_ENTRY( flag_pixmap_entry )));
	sprintf( keymaps[num_of_keymaps].Alternate_filename, "%s", gtk_entry_get_text( 
			GTK_ENTRY( alternate_pixmap_entry )));
	sprintf( keymaps[num_of_keymaps].Initials_filename, "%s",gtk_entry_get_text( 
			GTK_ENTRY( initials_pixmap_entry )));
	num_of_keymaps++;
	load_clist_data( 1 );
	set_combos();
	gtk_widget_destroy( widget );	
	gtk_widget_set_sensitive( window , TRUE );
	modstyle = NULL;
}

void CancelEditKeymap( GtkWidget *widget )
{
	gtk_widget_destroy( widget );
	widget = NULL;
	gtk_widget_set_sensitive( window, TRUE );
	modstyle = NULL;
}

void CancelFileSelect( GtkWidget *widget )
{
	gtk_widget_destroy( widget );
	widget = NULL;
	gtk_widget_set_sensitive( edit_window, TRUE );
}

void FileSelect_Flag( GtkWidget *widget )
{
	sprintf( FlagIcon_filename_temp, "%s", gtk_file_selection_get_filename( 
			(GtkFileSelection *) widget ));
	gtk_entry_set_text( GTK_ENTRY( flag_pixmap_entry ), FlagIcon_filename_temp );
	CancelFileSelect( widget );
}

void FileSelect_Alternate( GtkWidget *widget )
{
	sprintf( Alternate_filename_temp, "%s", gtk_file_selection_get_filename( 
			(GtkFileSelection *) widget ));
	gtk_entry_set_text( GTK_ENTRY( alternate_pixmap_entry ), Alternate_filename_temp );
	CancelFileSelect( widget );
}

void FileSelect_Initials( GtkWidget *widget )
{
	sprintf( Initials_filename_temp, "%s", gtk_file_selection_get_filename( 
			(GtkFileSelection *) widget ));
	gtk_entry_set_text( GTK_ENTRY( initials_pixmap_entry ), Initials_filename_temp );
	CancelFileSelect( widget );
}

void Browse_Flag( GtkWidget *entry )
{
	GtkWidget *file_select;
	
	gtk_widget_set_sensitive( edit_window, FALSE );
	
	file_select = gtk_file_selection_new( "Select Flag Pixmap" );
	gtk_file_selection_set_filename( GTK_FILE_SELECTION( file_select ),
		(gtk_entry_get_text( GTK_ENTRY( entry ))));
	gtk_signal_connect_object( GTK_OBJECT( GTK_FILE_SELECTION( file_select )->cancel_button ), "clicked", 
		GTK_SIGNAL_FUNC( CancelFileSelect ), GTK_OBJECT( file_select ));
	gtk_signal_connect_object( GTK_OBJECT( GTK_FILE_SELECTION( file_select )->ok_button ), "clicked",
		GTK_SIGNAL_FUNC( FileSelect_Flag ), GTK_OBJECT( file_select ));
	
	gtk_widget_show( file_select );
}

void Browse_Initials( GtkWidget *entry )
{
	GtkWidget *file_select;
	
	gtk_widget_set_sensitive( edit_window, FALSE );
	
	file_select = gtk_file_selection_new( "Select Initials Pixmap" );
	gtk_file_selection_set_filename( GTK_FILE_SELECTION( file_select ),
		(gtk_entry_get_text( GTK_ENTRY( entry ))));
	gtk_signal_connect_object( GTK_OBJECT( GTK_FILE_SELECTION( file_select )->cancel_button ), "clicked", 
		GTK_SIGNAL_FUNC( CancelFileSelect ), GTK_OBJECT( file_select ));
	gtk_signal_connect_object( GTK_OBJECT( GTK_FILE_SELECTION( file_select )->ok_button ), "clicked",
		GTK_SIGNAL_FUNC( FileSelect_Initials ), GTK_OBJECT( file_select ));
	
	gtk_widget_show( file_select );
}

void Browse_Alternate( GtkWidget *entry )
{
	GtkWidget *file_select;
	
	gtk_widget_set_sensitive( edit_window, FALSE );
	
	file_select = gtk_file_selection_new( "Select Alternate Pixmap" );
	gtk_file_selection_set_filename( GTK_FILE_SELECTION( file_select ),
		(gtk_entry_get_text( GTK_ENTRY( entry ))));
	gtk_signal_connect_object( GTK_OBJECT( GTK_FILE_SELECTION( file_select )->cancel_button ), "clicked", 
		GTK_SIGNAL_FUNC( CancelFileSelect ), GTK_OBJECT( file_select ));
	gtk_signal_connect_object( GTK_OBJECT( GTK_FILE_SELECTION( file_select )->ok_button ), "clicked",
		GTK_SIGNAL_FUNC( FileSelect_Alternate ), GTK_OBJECT( file_select ));
	
	gtk_widget_show( file_select );
}

void close_edit_keycode( GtkWidget *widget )
{
	gtk_widget_destroy( widget );
	widget = NULL;
	gtk_widget_set_sensitive( edit_window, TRUE );
}

void close_edit_keysym( GtkWidget *widget )
{
	gtk_widget_destroy( widget );
	widget = NULL;
}

void set_keysym( GtkWidget *widget )
{
	char *entry_text;
	char entry_char[3];
	
	if( hex==1 )
	{
		entry_text = gtk_entry_get_text( GTK_ENTRY( widget ));
		sprintf( entry_char, "%c", strtol( entry_text, NULL, 0 ));
		key_op[keysym_num] = strtol( entry_text, NULL, 16 );
		kbb_ptr->hex[keysym_num]=1;
		kbb_ptr->changed[keysym_num]=1;
		
		// Binary viewer
		/*
		for( i=128; i>0;  i=i/2 )
		{
			if( key_op[0] & i ) printf( "1 " );
			else printf( "0 " );
			
			printf( "%i", key_op[0] );
			printf( "\n" );
			
			if(((char)keymaps[1].keysym_array[30][0]) & i ) printf( "1 " );
			else printf( "0 " );
		}
		printf( "\n" );
		*/
		gtk_entry_set_text( GTK_ENTRY( entry_pass ), entry_char );
	}
	else
	{
		entry_text = gtk_entry_get_text( GTK_ENTRY( widget ));
		kbb_ptr->changed[keysym_num]=1;
		kbb_ptr->hex[keysym_num]=0;
		gtk_entry_set_text( GTK_ENTRY( entry_pass ), entry_text );
	}
	hex=0;
}

void set_inputmethod_1( GtkWidget *widget )
{
	(GTK_ENTRY( widget ))->text_max_length = 1;
	hex=0;
}

void set_inputmethod_2( GtkWidget *widget )
{
	(GTK_ENTRY( widget ))->text_max_length = 10;
	hex=1;
}

void custom_keysym_def( GtkWidget *widget )
{
	GtkWidget *window;
	GtkWidget *button;
	GtkWidget *hbox, *hbox_button, *vbox;
	GtkWidget *frame;
	GtkWidget *label;
	GtkWidget *entry;
	char WindowTitle[30];
	gchar *entry_text;
	GSList *group = 0;
	GtkWidget *radio_1, *radio_2;
	GtkStyle *style;

	style = gtk_widget_get_style( widget );
	
	entry_pass = widget;
	
	entry_text = gtk_entry_get_text( GTK_ENTRY( widget ) );
	
	sprintf( WindowTitle, "Edit '%s'", entry_text );
	
	window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_widget_set_usize( GTK_WIDGET( window ), 150, 100 );
	gtk_window_set_title( GTK_WINDOW( window ), WindowTitle );
	gtk_container_set_border_width( GTK_CONTAINER( window ), 5 );
	gtk_signal_connect_object( GTK_OBJECT( window ), "destroy",
		GTK_SIGNAL_FUNC( close_edit_keysym ), GTK_OBJECT( window ));
	gtk_signal_connect_object( GTK_OBJECT( window ), "delete_event",
		GTK_SIGNAL_FUNC( close_edit_keysym ), GTK_OBJECT( window ));
	
	vbox = gtk_vbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( window ), vbox );
	gtk_widget_show( vbox );
	
	frame = gtk_frame_new( "Set Keysym" );
	gtk_box_pack_start( GTK_BOX( vbox ), frame, TRUE, TRUE, 0 );
	gtk_widget_show( frame );
	
	hbox_button = gtk_hbox_new( TRUE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox_button, TRUE, TRUE, 0 );
	gtk_widget_show( hbox_button );
	
	vbox = gtk_vbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox );
	gtk_widget_show( vbox );
	
	hbox = gtk_hbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 0 );
	gtk_widget_show( hbox );
	
	label = gtk_label_new( "Keysym:" );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 0 );
	gtk_widget_show( label );
	
	entry = gtk_entry_new_with_max_length( 1 );
	gtk_box_pack_start( GTK_BOX( hbox ), entry, FALSE, TRUE, 0 );
	gtk_entry_set_text( GTK_ENTRY( entry ), entry_text );
	gtk_widget_set_usize( entry, 50, 19 );
	gtk_widget_show( entry );
	gtk_widget_set_style( widget, style );
	
	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 0 );
	
	radio_1 = gtk_radio_button_new_with_label( group, "Char" );
	gtk_box_pack_start( GTK_BOX( hbox ), radio_1, FALSE, FALSE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( radio_1 ), "clicked",
		GTK_SIGNAL_FUNC( set_inputmethod_1 ), GTK_OBJECT( entry ));
	gtk_widget_show( radio_1 );
	
	group = gtk_radio_button_group( GTK_RADIO_BUTTON( radio_1 ));
	radio_2 = gtk_radio_button_new_with_label( group, "Hex" );
	gtk_box_pack_start( GTK_BOX( hbox ), radio_2, FALSE, FALSE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( radio_2 ), "clicked",
		GTK_SIGNAL_FUNC( set_inputmethod_2 ), GTK_OBJECT( entry ));
	gtk_widget_show( radio_2 );
	
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( radio_1 ), TRUE );
	
	gtk_widget_show( hbox );
	
	button = gtk_button_new_with_label( "Ok" );
	gtk_box_pack_start( GTK_BOX( hbox_button ), button, FALSE, TRUE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( set_keysym ), GTK_OBJECT( entry ));
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( close_edit_keysym ), GTK_OBJECT( window ));
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "Cancel" );
	gtk_box_pack_start( GTK_BOX( hbox_button ), button, FALSE, TRUE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( close_edit_keysym ), GTK_OBJECT( window ));
	gtk_widget_show( button );
	
	gtk_widget_show( window );
	//printf( "custom_keysym_def();\n" );
}

void save_keysym_def( GtkWidget *widget, gpointer kbb )
{
	char *entry;
	
	entry = gtk_entry_get_text( GTK_ENTRY( entry_1 ));
	
	if( kbb_ptr->changed[0]==1 )
	{
		if( kbb_ptr->hex[0]==1 )
			keymaps[selected_row].keysym_array[((KeyboardButton *)kbb)->keycode-8][0]=(char *)key_op[0];
		else
			keymaps[selected_row].keysym_array[((KeyboardButton *)kbb)->keycode-8][0]=(char *)entry[0];
	}
	
	entry = gtk_entry_get_text( GTK_ENTRY( entry_2 ));
	
	if( kbb_ptr->changed[1]==1 )
	{
		if( kbb_ptr->hex[1]==1 )
			keymaps[selected_row].keysym_array[((KeyboardButton *)kbb)->keycode-8][1]=(char *)key_op[1];
		else
			keymaps[selected_row].keysym_array[((KeyboardButton *)kbb)->keycode-8][1]=(char *)entry[0];
	}
	
	entry = gtk_entry_get_text( GTK_ENTRY( entry_3 ));
	
	if( kbb_ptr->changed[2]==1 )
	{
		if( kbb_ptr->hex[2]==1 )
			keymaps[selected_row].keysym_array[((KeyboardButton *)kbb)->keycode-8][2]=(char *)key_op[2];
		else
			keymaps[selected_row].keysym_array[((KeyboardButton *)kbb)->keycode-8][2]=(char *)entry[0];
	}

	entry = gtk_entry_get_text( GTK_ENTRY( entry_4 ));
	
	if( kbb_ptr->changed[3]==1 )
	{
		if( kbb_ptr->hex[3]==1 )
			keymaps[selected_row].keysym_array[((KeyboardButton *)kbb)->keycode-8][3]=(char *)key_op[3];
		else
			keymaps[selected_row].keysym_array[((KeyboardButton *)kbb)->keycode-8][3]=(char *)entry[0];
	}
}

void clist_category_select( GtkWidget *widget, gint row, gint column, 
	  GdkEventButton *event, gpointer data )
{
   gtk_clist_clear( GTK_CLIST( data ));
   char character[2];

   category = row;
   
   gchar *clist_item[2];
   for( i=0; i<keysymdb[row].size; i++ )
   {
	  sprintf( character, "%c", keysymdb[row].keysyms[i][1]);
	  clist_item[0] = keysymdb[row].keysyms[i][0];
	  clist_item[1] = character;
	  gtk_clist_append( GTK_CLIST( data ), clist_item );
   }									       
}

void clist_categorykeysym_select( GtkWidget *widget, gint row, gint column,
	  GdkEventButton *event, gpointer data )
{
   categorykeysym = row;
}

void set_keysym_from_db( GtkWidget *widget, gpointer kbb )
{
   char character[2];

   sprintf( character, "%c", keysymdb[category].keysyms[categorykeysym][1] );

   kbb_ptr->changed[keysym_num1-1] = 1;

   gtk_entry_set_text( GTK_ENTRY( entry_pass ), character );
}

void select_keysym( GtkWidget *widget, gpointer kbb )
{
    init_keysym_db();
   
	GtkWidget *window;
	GtkWidget *hbox, *vbox;
	GtkWidget *vbox_frame, *hbox_clists, *hbox_info;
	GtkWidget *frame;
	GtkWidget *button;
	GtkWidget *clist_categories, *clist_keysyms;
	GtkWidget *arrow;
	GtkWidget *scrolled_window, *scrolled_window1;;
	gchar *category_title[2] = { "Category", "Keysyms" };
	gchar *keysyms_title[2] = { "Name", "KS" };
	char label[25];
	GtkStyle *style;

	window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_window_set_title( GTK_WINDOW( window ), "Select Keysym" );
	gtk_widget_set_usize( window, 510, 400 );
	gtk_container_set_border_width( GTK_CONTAINER( window ), 5 );
	gtk_signal_connect_object( GTK_OBJECT( window ), "destroy",
		  GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ));
	gtk_signal_connect_object( GTK_OBJECT( window ), "delete_event",
		  GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ));

	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( window ), vbox );
	
	sprintf( label, "KeyCode %i, KeySym %i", ((KeyboardButton *)kbb)->keycode, keysym_num1 );
	
	switch( keysym_num1 )
	{
		case 1:
		  entry_pass = entry_1;
		  break;
		case 2:
		  entry_pass = entry_2;
		  break;
		case 3:
		  entry_pass = entry_3;
		  break;
		case 4:
		  entry_pass = entry_4;
		  break;
		default:
		  printf( "Error\n" );
		  break;
	}
	
	frame = gtk_frame_new( label );
	gtk_box_pack_start( GTK_BOX( vbox ), frame, TRUE, TRUE, 5 );

	hbox = gtk_hbox_new( TRUE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 0 );

	// Ok Button
	button = gtk_button_new_with_label( "Ok" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		  GTK_SIGNAL_FUNC( set_keysym_from_db ), kbb );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		  GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ));
	
	// Cancel Button
	button = gtk_button_new_with_label( "Cancel" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		   GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ));

	vbox_frame = gtk_vbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox_frame );

	hbox_clists = gtk_hbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox_frame ), hbox_clists, TRUE, TRUE, 0 );

	scrolled_window = gtk_scrolled_window_new( NULL, NULL );
	gtk_box_pack_start( GTK_BOX( hbox_clists ), scrolled_window, TRUE, TRUE, 0 );
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( scrolled_window ),
		              GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS );
	
	clist_categories = gtk_clist_new_with_titles( 2, category_title );
	gtk_container_add( GTK_CONTAINER( scrolled_window ), clist_categories );
	gtk_clist_set_column_width( GTK_CLIST( clist_categories ), 0, 150 );
	gtk_clist_set_column_width( GTK_CLIST( clist_categories ), 1, 30 );
	
	gchar *clist_item[2];
	for( i=0; i<NUMBER_OF_KEYSYM_DB; i++ )
	{
	    clist_item[0] = keysymdb[i].name;
		clist_item[1] = NULL;
		gtk_clist_append( GTK_CLIST( clist_categories ), clist_item );
	}

	arrow = gtk_label_new( "->" );
	gtk_box_pack_start( GTK_BOX( hbox_clists ), arrow, FALSE, TRUE, 0 );

	scrolled_window1 = gtk_scrolled_window_new( NULL, NULL );
	gtk_box_pack_start( GTK_BOX( hbox_clists ), scrolled_window1, TRUE, TRUE, 0 );
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( scrolled_window1 ),
					GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS );
	
	clist_keysyms = gtk_clist_new_with_titles( 2, keysyms_title );
	gtk_container_add( GTK_CONTAINER( scrolled_window1 ), clist_keysyms );
	gtk_clist_set_column_width( GTK_CLIST( clist_keysyms ), 0, 184 );
	gtk_clist_set_column_width( GTK_CLIST( clist_keysyms ), 1, 10 );

	style = gtk_widget_get_style( entry_pass );
	gtk_widget_set_style( clist_keysyms, style );

	gtk_signal_connect( GTK_OBJECT( clist_categories ), "select_row",
		  GTK_SIGNAL_FUNC( clist_category_select ), clist_keysyms );
	gtk_signal_connect( GTK_OBJECT( clist_keysyms ), "select_row",
		  GTK_SIGNAL_FUNC( clist_categorykeysym_select ), NULL );
	
	gtk_widget_show_all( window );
}

void change_keysym_def( GtkWidget *widget, gpointer kbb )
{
	GtkWidget *window;
	GtkWidget *frame;
	GtkWidget *vbox, *vbox_1, *hbox;
	GtkWidget *button;
	GtkWidget *notebook;
	GtkWidget *label;
	char WindowTitle[40];
	GtkStyle *localstyle;
	
	localstyle = modstyle;
	
	//(KeyboardButton *)kbb->changed={ 0, 0, 0, 0 };
	//(KeyboardButton *)kbb->hex={ 0, 0, 0, 0 };
	
	// Seg-fault protection...
	if( (((KeyboardButton *)kbb)->keysym[0][0])=='\0' )
	{	
		((KeyboardButton *)kbb)->keysym[0][0] = ' ';
	}
	
	sprintf( WindowTitle, "Edit Keysym '%c', KeyCode %d", ((KeyboardButton *)kbb)->keysym[0][0], 
		((KeyboardButton *)kbb)->keycode ); 
	
	set_kbb_edit( (KeyboardButton *)kbb );
	
	window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_window_set_title( GTK_WINDOW( window ), WindowTitle );
	gtk_widget_set_usize( window, 365, 325 );
	gtk_container_set_border_width( GTK_CONTAINER( window ), 5 );
	gtk_signal_connect_object( GTK_OBJECT( window ), "destroy",
		GTK_SIGNAL_FUNC( close_edit_keycode ), GTK_OBJECT( window ));
	gtk_signal_connect_object( GTK_OBJECT( window ), "delete_event",
		GTK_SIGNAL_FUNC( close_edit_keycode ), GTK_OBJECT( window ));
	
	vbox = gtk_vbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( window ), vbox );
	gtk_widget_show( vbox );
	
	notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos( GTK_NOTEBOOK( notebook ), GTK_POS_TOP );
	gtk_box_pack_start( GTK_BOX( vbox ), notebook, TRUE, TRUE, 0 );
	gtk_widget_show( notebook );
	
	hbox = gtk_hbox_new( TRUE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );
	
	button = gtk_button_new_with_label( "Ok" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( save_keysym_def ), kbb );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( close_edit_keycode ), GTK_OBJECT( window ));
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "Cancel" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( close_edit_keycode ), GTK_OBJECT( window ));
	gtk_widget_show( button );
	
	// Main Keysyms Edit Panel
	label = gtk_label_new( "Main Keysyms (1&2)" );
	gtk_widget_show( label );
	frame = gtk_frame_new( "Main Keysym Options" );
	gtk_container_border_width( GTK_CONTAINER( frame ), 5 );	
	gtk_widget_show( frame );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), frame, label );
	
	vbox_1 = gtk_vbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox_1 );
	gtk_widget_show( vbox_1 );
	
	frame = gtk_frame_new( "Keysym 1" );
	gtk_box_pack_start( GTK_BOX( vbox_1 ), frame, TRUE, TRUE, 0 );
	gtk_container_border_width( GTK_CONTAINER( frame ), 5 );
	gtk_widget_show( frame );
	
	vbox = gtk_vbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox );
	gtk_widget_show( vbox );
	
	label = gtk_label_new( "The character that you set to keysym 1 will appear\n when you simply press the selected button." );
	gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	hbox = gtk_hbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );
	
	label = gtk_label_new( "Mapped Character:" );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	entry_1 = gtk_entry_new_with_max_length( 1 );
	gtk_box_pack_start( GTK_BOX( hbox ), entry_1, FALSE, FALSE, 0 );
	gtk_entry_set_text( GTK_ENTRY( entry_1 ), ((KeyboardButton *)kbb)->keysym[0] );
	gtk_entry_set_editable( GTK_ENTRY( entry_1 ), FALSE );
	gtk_widget_show( entry_1 );
	if( localstyle!=NULL )
	   gtk_widget_set_style( entry_1, localstyle );
	
	hbox = gtk_hbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );
	
	button = gtk_button_new_with_label( "Custom..." );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( custom_keysym_def ), GTK_OBJECT( entry_1 ));
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
			GTK_SIGNAL_FUNC( set_keysym_num ), (gpointer)0 );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "Select Keysym" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		  GTK_SIGNAL_FUNC( set_keysym_num1 ), (gpointer) 1 );
	gtk_signal_connect( GTK_OBJECT(button), "clicked",
		  GTK_SIGNAL_FUNC( select_keysym ), kbb );
	gtk_widget_show( button );
	
	frame = gtk_frame_new( "Keysym 2" );
	gtk_box_pack_start( GTK_BOX( vbox_1 ), frame, TRUE, TRUE, 0 );
	gtk_container_border_width( GTK_CONTAINER( frame ), 5 );
	gtk_widget_show( frame );
	
	vbox = gtk_vbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox );
	gtk_widget_show( vbox );
	
	label = gtk_label_new( "The character that you set to keysym 2 will appear when\n you hold down SHIFT and press the selected button." );
	gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	hbox = gtk_hbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );
	
	label = gtk_label_new( "Mapped Character:" );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	entry_2 = gtk_entry_new_with_max_length( 1 );
	gtk_box_pack_start( GTK_BOX( hbox ), entry_2, FALSE, FALSE, 0 );
	gtk_entry_set_text( GTK_ENTRY( entry_2 ), ((KeyboardButton *)kbb)->keysym[1] );
	gtk_entry_set_editable( GTK_ENTRY( entry_2 ), FALSE );
	gtk_widget_show( entry_2 );
	if( localstyle!=NULL )
	   gtk_widget_set_style( entry_2, localstyle );
	
	hbox = gtk_hbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );
	
	button = gtk_button_new_with_label( "Custom..." );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( custom_keysym_def ), GTK_OBJECT( entry_2 ));
	gtk_signal_connect( GTK_OBJECT( button ), "clicked", 
			GTK_SIGNAL_FUNC( set_keysym_num ), (gpointer)1 );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "Select Keysym" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		  GTK_SIGNAL_FUNC( set_keysym_num1 ), (gpointer) 2 );
	gtk_signal_connect( GTK_OBJECT(button), "clicked",
		  GTK_SIGNAL_FUNC( select_keysym ), kbb );
	gtk_widget_show( button );
	
	// Second Level Keysyms Edit Panel
	label = gtk_label_new( "Second Level Keysyms (3&4)" );
	gtk_widget_show( label );
	frame = gtk_frame_new( "Second Level Keysym Options" );
	gtk_container_border_width( GTK_CONTAINER( frame ), 5 );	
	gtk_widget_show( frame );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), frame, label );
	
	vbox_1 = gtk_vbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox_1 );
	gtk_widget_show( vbox_1 );
	
	frame = gtk_frame_new( "Keysym 3" );
	gtk_box_pack_start( GTK_BOX( vbox_1 ), frame, TRUE, TRUE, 0 );
	gtk_container_border_width( GTK_CONTAINER( frame ), 5 );
	gtk_widget_show( frame );
	
	vbox = gtk_vbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox );
	gtk_widget_show( vbox );
	
	label = gtk_label_new( "This is similar to Keysym 1, only that it's in the second\n level which can be accessed by a modifier key." );
	gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	hbox = gtk_hbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );
	
	label = gtk_label_new( "Mapped Character:" );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	entry_3 = gtk_entry_new_with_max_length( 1 );
	gtk_box_pack_start( GTK_BOX( hbox ), entry_3, FALSE, FALSE, 0 );
	gtk_entry_set_text( GTK_ENTRY( entry_3 ), ((KeyboardButton *)kbb)->keysym[2] );
	gtk_entry_set_editable( GTK_ENTRY( entry_3 ), FALSE );
	gtk_widget_show( entry_3 );
	if( localstyle!=NULL )
	   gtk_widget_set_style( entry_3, localstyle );
	
	hbox = gtk_hbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );
	
	button = gtk_button_new_with_label( "Custom..." );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( custom_keysym_def ), GTK_OBJECT( entry_3 ));
	gtk_signal_connect( GTK_OBJECT( button ), "clicked", 
			GTK_SIGNAL_FUNC( set_keysym_num ), (gpointer)2 );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "Select Keysym" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		  GTK_SIGNAL_FUNC( set_keysym_num1 ), (gpointer) 3 );
	gtk_signal_connect( GTK_OBJECT(button), "clicked",
		  GTK_SIGNAL_FUNC(select_keysym), kbb );
	gtk_widget_show( button );
	
	frame = gtk_frame_new( "Keysym 4" );
	gtk_box_pack_start( GTK_BOX( vbox_1 ), frame, TRUE, TRUE, 0 );
	gtk_container_border_width( GTK_CONTAINER( frame ), 5 );
	gtk_widget_show( frame );
	
	vbox = gtk_vbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox );
	gtk_widget_show( vbox );
	
	label = gtk_label_new( "This is similar to Keysym 2, only that it's in the second\n level which can be accessed by a modifier key." );
	gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	hbox = gtk_hbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );
	
	label = gtk_label_new( "Mapped Character:" );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	entry_4 = gtk_entry_new_with_max_length( 1 );
	gtk_box_pack_start( GTK_BOX( hbox ), entry_4, FALSE, FALSE, 0 );
	gtk_entry_set_text( GTK_ENTRY( entry_4 ), ((KeyboardButton *)kbb)->keysym[3] );
	gtk_entry_set_editable( GTK_ENTRY( entry_4 ), FALSE );
	gtk_widget_show( entry_4 );
	if( localstyle!=NULL )
	   gtk_widget_set_style( entry_4, localstyle );
	
	hbox = gtk_hbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );
	
	button = gtk_button_new_with_label( "Custom..." );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( custom_keysym_def ), GTK_OBJECT( entry_4 ));
	gtk_signal_connect( GTK_OBJECT( button ), "clicked", 
			GTK_SIGNAL_FUNC( set_keysym_num ), (gpointer)3 );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "Select Keysym" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		  GTK_SIGNAL_FUNC( set_keysym_num1 ), (gpointer) 4 );
	gtk_signal_connect( GTK_OBJECT(button), "clicked",
		  GTK_SIGNAL_FUNC(select_keysym), kbb );
	gtk_widget_show( button );
	
	gtk_widget_set_sensitive( edit_window, FALSE );
	gtk_widget_show( window );
}

void load_keymap_editor( GtkWidget *box, int row )
{
	GtkWidget *button;
	GtkWidget *hbox_main, *hbox;
	GtkWidget *vbox;
	int i, j;
	
	for( i=0; i<134; i++ )
	{
		j=i;
		kb_button[i].keycode = j+8;
	}
	
	for( i=0; i<134; i++ )
	{
		for( j=0; j<4; j++ )
		{
			sprintf( kb_button[i].keysym[j], "%c", keymaps[selected_row].keysym_array[i][j] );
		}
	}
	
	if( row==1 )
	{
		keymaps[num_of_keymaps].keysym_array = keymaps[selected_row].keysym_array;
		selected_row = num_of_keymaps;
		row=0;
	}
	
	hbox_main = gtk_hbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( box ), hbox_main, FALSE, FALSE, 0 );
	gtk_widget_show( hbox_main );
	
	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( hbox_main ), vbox, FALSE, FALSE, 0 );
	gtk_widget_show( vbox );
	
	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );
	
	button = gtk_button_new_with_label( "" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_widget_set_sensitive( button, FALSE );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[2].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[2] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[3].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), &kb_button[3] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[4].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[4] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[5].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[5] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[6].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[6] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[7].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[7] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[8].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[8] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[9].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[9] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[10].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[10] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[11].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[11] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[12].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[12] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[13].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[13] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 50, 25 );
	gtk_widget_set_sensitive( button, FALSE );
	gtk_widget_show( button );
	
	// Second Row of buttons
	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );
	
	button = gtk_button_new_with_label( "" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 50, 25 );
	gtk_widget_set_sensitive( button, FALSE );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[16].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[16] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[17].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[17] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[18].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[18] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[19].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[19] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[20].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[20] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[21].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[21] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[22].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[22] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[23].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[23] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[24].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[24] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[25].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[25] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[26].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[26] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[27].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[27] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[43].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[43] );
	gtk_widget_show( button );
	
	//Third Row of buttons
	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );
	
	button = gtk_button_new_with_label( "" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 52, 25 );
	gtk_widget_set_sensitive( button, FALSE );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[30].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[30] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[31].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[31] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[32].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[32] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[33].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[33] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[34].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[34] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[35].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[35] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[36].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[36] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[37].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[37] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[38].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[38] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[39].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[39] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[40].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[40] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 48, 25 );
	gtk_widget_set_sensitive( button, FALSE );
	gtk_widget_show( button );
	
	//Fourth Row of buttons
	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );
	
	button = gtk_button_new_with_label( "" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 62, 25 );
	gtk_widget_set_sensitive( button, FALSE );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[44].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[44] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[45].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[45] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[46].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[46] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[47].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[47] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[48].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[48] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[49].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[49] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[50].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[50] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[51].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[51] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[52].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[52] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( kb_button[53].keysym[0] );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 25, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[53] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 63, 25 );
	gtk_widget_set_sensitive( button, FALSE );
	gtk_widget_show( button );
	
	//Fifth Row of buttons
	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );
	
	button = gtk_button_new_with_label( "" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 32, 25 );
	gtk_widget_set_sensitive( button, FALSE );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "Win" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 32, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[107] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 32, 25 );
	gtk_widget_set_sensitive( button, FALSE );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 147, 25 );
	gtk_widget_set_sensitive( button, FALSE );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 32, 25 );
	gtk_widget_set_sensitive( button, FALSE );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "Win" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 32, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[108] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "Menu" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 36, 25 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( change_keysym_def ), (gpointer) &kb_button[109] );
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_widget_set_usize( button, 32, 25 );
	gtk_widget_set_sensitive( button, FALSE );
	gtk_widget_show( button );
}
	
void EditKeymap( void )
{
	if( selected_row==51 )
	{
		PleaseSelectKeymap();
		return;
	}
	
	GtkWidget *vbox, *vbox_frame;
	GtkWidget *hbox, *hbox_pixmap;
	GtkWidget *label;
	GtkWidget *button;
	GtkWidget *frame;
	char WindowTitle[30];
	
	sprintf( WindowTitle, "Edit Keymap: %s", keymaps[selected_row].name );
	
	edit_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_window_set_title( GTK_WINDOW( edit_window ), WindowTitle );
	gtk_widget_set_usize( GTK_WIDGET( edit_window ), 402, 406/*388*/ );
	gtk_widget_set_sensitive( window, FALSE );
	gtk_signal_connect_object( GTK_OBJECT( edit_window ), "delete_event",
		GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( edit_window ));
	gtk_signal_connect_object( GTK_OBJECT( edit_window ), "destroy",
		GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( edit_window ));
	gtk_container_border_width( GTK_CONTAINER( edit_window ), 5 );
	
	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( edit_window ), vbox );
	gtk_widget_show( vbox );
	
	frame = gtk_frame_new( "Edit Keymap" );
	gtk_box_pack_start( GTK_BOX( vbox ), frame, TRUE, TRUE, 5 );
	gtk_widget_show( frame );
	
	hbox = gtk_hbox_new( TRUE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 5 );
	gtk_widget_show( hbox );
	
	button = gtk_button_new_with_label( "Ok" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( Edit_SaveKeymapOptions ), GTK_OBJECT( edit_window ));
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "Cancel" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( CancelEditKeymap ), GTK_OBJECT( edit_window ));
	gtk_widget_show( button );
	
	vbox_frame = gtk_vbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox_frame );
	gtk_widget_show( vbox_frame );
	
	frame = gtk_frame_new( "Keymap Name" );
	gtk_box_pack_start( GTK_BOX( vbox_frame ), frame, FALSE, FALSE, 0 );
	gtk_container_border_width( GTK_CONTAINER( frame ), 5 );
	gtk_widget_show( frame );
	
	hbox = gtk_hbox_new( FALSE, 10 );
	gtk_container_add( GTK_CONTAINER( frame ), hbox );
	gtk_widget_show( hbox );
	
	label = gtk_label_new( "Name:" );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 0 );
	gtk_widget_show( label );
	
	name_entry = gtk_entry_new();
	gtk_box_pack_start( GTK_BOX( hbox ), name_entry, FALSE, TRUE, 0 );
	gtk_entry_set_text( GTK_ENTRY( name_entry ), keymaps[selected_row].name );
	gtk_widget_show( name_entry );
	
	frame = gtk_frame_new( "Pixmaps" );
	gtk_box_pack_start( GTK_BOX( vbox_frame ), frame, FALSE, FALSE, 0 );
	gtk_container_border_width( GTK_CONTAINER( frame ), 5 );
	gtk_widget_show( frame );
	
	hbox_pixmap = gtk_hbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( frame ), hbox_pixmap );
	gtk_widget_show( hbox_pixmap );
	
	vbox = gtk_vbox_new( FALSE, 12 );
	gtk_box_pack_start( GTK_BOX( hbox_pixmap ), vbox, FALSE, FALSE, 0 );
	
	label = gtk_label_new( "Flag:" );
	gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	label = gtk_label_new( "Initials:" );
	gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	label = gtk_label_new( "Alternate:" );
	gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	gtk_widget_show( vbox );
	
	vbox = gtk_vbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( hbox_pixmap ), vbox, TRUE, TRUE, 0 );
	
	hbox = gtk_hbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, FALSE, 0 );
	gtk_widget_show( hbox );
	
	flag_pixmap_entry = gtk_entry_new();
	gtk_box_pack_start( GTK_BOX( hbox ), flag_pixmap_entry, TRUE, TRUE, 0 );
	FlagIcon_filename_temp = keymaps[selected_row].FlagIcon_filename;
	gtk_entry_set_text( GTK_ENTRY( flag_pixmap_entry ), FlagIcon_filename_temp );
	gtk_widget_show( flag_pixmap_entry );
	
	button = gtk_button_new_with_label( "Browse" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( Browse_Flag ), 
		GTK_OBJECT( flag_pixmap_entry ));
	gtk_widget_show( button );
	
	hbox = gtk_hbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, FALSE, 0 );
	
	initials_pixmap_entry = gtk_entry_new();
	gtk_box_pack_start( GTK_BOX( hbox ), initials_pixmap_entry, TRUE, TRUE, 0 );
	Initials_filename_temp = keymaps[selected_row].Initials_filename;
	gtk_entry_set_text( GTK_ENTRY( initials_pixmap_entry ), Initials_filename_temp );
	gtk_widget_show( initials_pixmap_entry );
	
	button = gtk_button_new_with_label( "Browse" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( Browse_Initials ),
		GTK_OBJECT( initials_pixmap_entry ));
	gtk_widget_show( button );
	
	gtk_widget_show( hbox );
	
	hbox = gtk_hbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, FALSE, 0 );
	
	alternate_pixmap_entry = gtk_entry_new();
	gtk_box_pack_start( GTK_BOX( hbox ), alternate_pixmap_entry, TRUE, TRUE, 0 );
	Alternate_filename_temp = keymaps[selected_row].Alternate_filename;
	gtk_entry_set_text( GTK_ENTRY( alternate_pixmap_entry ), Alternate_filename_temp );
	gtk_widget_show( alternate_pixmap_entry );
	
	button = gtk_button_new_with_label( "Browse" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( Browse_Alternate ),
		GTK_OBJECT( alternate_pixmap_entry ));
	gtk_widget_show( button );
	
	gtk_widget_show( hbox );
	
	gtk_widget_show( vbox );
	
	frame = gtk_frame_new( "Keymap" );
	gtk_box_pack_start( GTK_BOX( vbox_frame ), frame, TRUE, TRUE, 0 );
	gtk_container_border_width( GTK_CONTAINER( frame ), 5 );
	gtk_widget_show( frame );
	
	vbox = gtk_vbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox );
	gtk_widget_show( vbox );
	
	load_keymap_editor( vbox, 0 );
	
	button = gtk_button_new_with_label( "Set Font" );
	gtk_box_pack_start( GTK_BOX( vbox_frame ), button, TRUE, TRUE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		  GTK_SIGNAL_FUNC( menu_font ), GTK_OBJECT( vbox ));
	gtk_widget_show( button );
	
	gtk_widget_show( edit_window );
}

void NewKeymap( void )
{
	gtk_widget_set_sensitive( window, FALSE );
	GtkWidget *window;
	GtkWidget *clist;
	GtkWidget *button;
	GtkWidget *hbox, *vbox;
	gchar *loaded_keymaps[num_of_keymaps][4];
	
	window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_window_set_title( GTK_WINDOW( window ), "Base Keymap" );
	gtk_widget_set_usize( window, 320, 250 );
	gtk_container_set_border_width( GTK_CONTAINER( window ), 5 );
	gtk_signal_connect_object( GTK_OBJECT( window ), "delete_event",
		GTK_SIGNAL_FUNC( ErrorOk ), GTK_OBJECT( window ));
	
	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( window ), vbox );
	gtk_widget_show( vbox );
	
	clist = gtk_clist_new_with_titles( 4, clist_titles );
	gtk_box_pack_start( GTK_BOX( vbox ), clist, TRUE, TRUE, 5 );
	gtk_clist_set_column_width( GTK_CLIST( clist ), 0, 95 );
	gtk_clist_set_column_width( GTK_CLIST( clist ), 1, 25 );
	gtk_clist_set_column_width( GTK_CLIST( clist ), 2, 60 );
	gtk_clist_set_column_width( GTK_CLIST( clist ), 3, 50 );
	gtk_signal_connect( GTK_OBJECT( clist ), "select_row",
		GTK_SIGNAL_FUNC( clist_select_update_1 ), NULL );
	gtk_widget_show( clist );
	
	hbox = gtk_hbox_new( TRUE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 0 );
	gtk_widget_show( hbox );
	
	button = gtk_button_new_with_label( "Ok" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( NewKeymapMain ), NULL );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ));
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "Cancel" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( ErrorOk ), GTK_OBJECT( window ));
	gtk_widget_show( button );
	
	for( i=0; i<num_of_keymaps; i++ )
	{
		loaded_keymaps[i][0]=keymaps[i].name;
		loaded_keymaps[i][1]=(gchar *) "134";
		loaded_keymaps[i][2]=NULL;//(gchar *) keymaps[i].keysyms_per_keycode;
		loaded_keymaps[i][3]=NULL;//(gchar *) "134*KS_p_KC"; 
		gtk_clist_append( GTK_CLIST( clist ), loaded_keymaps[i] );
	}
	gtk_widget_show( clist );
	gtk_clist_select_row( GTK_CLIST( clist ), 0, 0 );
	
	gtk_widget_show( window );
}

void NewKeymapMain( void )
{
	GtkWidget *vbox, *vbox_frame;
	GtkWidget *hbox, *hbox_pixmap;
	GtkWidget *label;
	GtkWidget *button;
	GtkWidget *frame;
	
	selected_row = base_keymap;
	
	edit_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_window_set_title( GTK_WINDOW( edit_window ), "New Keymap" );
	gtk_widget_set_usize( GTK_WIDGET( edit_window ), 402, 388 );
	gtk_signal_connect_object( GTK_OBJECT( edit_window ), "delete_event",
		GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( edit_window ));
	gtk_signal_connect_object( GTK_OBJECT( edit_window ), "destroy",
		GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( edit_window ));
	gtk_container_border_width( GTK_CONTAINER( edit_window ), 5 );
	
	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( edit_window ), vbox );
	gtk_widget_show( vbox );
	
	frame = gtk_frame_new( "New Keymap" );
	gtk_box_pack_start( GTK_BOX( vbox ), frame, TRUE, TRUE, 5 );
	gtk_widget_show( frame );
	
	hbox = gtk_hbox_new( TRUE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, FALSE, 5 );
	gtk_widget_show( hbox );
	
	button = gtk_button_new_with_label( "Ok" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( New_SaveKeymapOptions ), GTK_OBJECT( edit_window ));
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "Cancel" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( CancelEditKeymap ), GTK_OBJECT( edit_window ));
	gtk_widget_show( button );
	
	vbox_frame = gtk_vbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox_frame );
	gtk_widget_show( vbox_frame );
	
	frame = gtk_frame_new( "Keymap Name" );
	gtk_box_pack_start( GTK_BOX( vbox_frame ), frame, FALSE, FALSE, 0 );
	gtk_container_border_width( GTK_CONTAINER( frame ), 5 );
	gtk_widget_show( frame );
	
	hbox = gtk_hbox_new( FALSE, 10 );
	gtk_container_add( GTK_CONTAINER( frame ), hbox );
	gtk_widget_show( hbox );
	
	label = gtk_label_new( "Name:" );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 0 );
	gtk_widget_show( label );
	
	name_entry = gtk_entry_new();
	gtk_box_pack_start( GTK_BOX( hbox ), name_entry, FALSE, TRUE, 0 );
	gtk_entry_set_text( GTK_ENTRY( name_entry ), keymaps[num_of_keymaps].name );
	gtk_widget_show( name_entry );
	
	frame = gtk_frame_new( "Pixmaps" );
	gtk_box_pack_start( GTK_BOX( vbox_frame ), frame, FALSE, FALSE, 0 );
	gtk_container_border_width( GTK_CONTAINER( frame ), 5 );
	gtk_widget_show( frame );
	
	hbox_pixmap = gtk_hbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( frame ), hbox_pixmap );
	gtk_widget_show( hbox_pixmap );
	
	vbox = gtk_vbox_new( FALSE, 12 );
	gtk_box_pack_start( GTK_BOX( hbox_pixmap ), vbox, FALSE, FALSE, 0 );
	
	label = gtk_label_new( "Flag:" );
	gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	label = gtk_label_new( "Initials:" );
	gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	label = gtk_label_new( "Alternate:" );
	gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 0 );
	gtk_widget_show( label );
	
	gtk_widget_show( vbox );
	
	vbox = gtk_vbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( hbox_pixmap ), vbox, TRUE, TRUE, 0 );
	
	hbox = gtk_hbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, FALSE, 0 );
	gtk_widget_show( hbox );
	
	flag_pixmap_entry = gtk_entry_new();
	gtk_box_pack_start( GTK_BOX( hbox ), flag_pixmap_entry, TRUE, TRUE, 0 );
	FlagIcon_filename_temp = keymaps[num_of_keymaps].FlagIcon_filename;
	gtk_entry_set_text( GTK_ENTRY( flag_pixmap_entry ), FlagIcon_filename_temp );
	gtk_widget_show( flag_pixmap_entry );
	
	button = gtk_button_new_with_label( "Browse" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( Browse_Flag ), 
		GTK_OBJECT( flag_pixmap_entry ));
	gtk_widget_show( button );
	
	hbox = gtk_hbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, FALSE, 0 );
	
	initials_pixmap_entry = gtk_entry_new();
	gtk_box_pack_start( GTK_BOX( hbox ), initials_pixmap_entry, TRUE, TRUE, 0 );
	Initials_filename_temp = keymaps[num_of_keymaps].Initials_filename;
	gtk_entry_set_text( GTK_ENTRY( initials_pixmap_entry ), Initials_filename_temp );
	gtk_widget_show( initials_pixmap_entry );
	
	button = gtk_button_new_with_label( "Browse" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( Browse_Initials ),
		GTK_OBJECT( initials_pixmap_entry ));
	gtk_widget_show( button );
	
	gtk_widget_show( hbox );
	
	hbox = gtk_hbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, FALSE, 0 );
	
	alternate_pixmap_entry = gtk_entry_new();
	gtk_box_pack_start( GTK_BOX( hbox ), alternate_pixmap_entry, TRUE, TRUE, 0 );
	Alternate_filename_temp = keymaps[num_of_keymaps].Alternate_filename;
	gtk_entry_set_text( GTK_ENTRY( alternate_pixmap_entry ), Alternate_filename_temp );
	gtk_widget_show( alternate_pixmap_entry );
	
	button = gtk_button_new_with_label( "Browse" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( Browse_Alternate ),
		GTK_OBJECT( alternate_pixmap_entry ));
	gtk_widget_show( button );
	
	gtk_widget_show( hbox );
	
	gtk_widget_show( vbox );
	
	frame = gtk_frame_new( "Keymap" );
	gtk_box_pack_start( GTK_BOX( vbox_frame ), frame, TRUE, TRUE, 0 );
	gtk_container_border_width( GTK_CONTAINER( frame ), 5 );
	gtk_widget_show( frame );
	
	vbox = gtk_vbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox );
	gtk_widget_show( vbox );
	
	load_keymap_editor( vbox, 1 );
	
	button = gtk_button_new_with_label( "Set Font" );
	gtk_box_pack_start( GTK_BOX( vbox_frame ), button, TRUE, TRUE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		  GTK_SIGNAL_FUNC( menu_font ), GTK_OBJECT( vbox ));
	gtk_widget_show( button );
	
	gtk_widget_show( edit_window );
}

void delete_keymap( GtkWidget *widget )
{
	if( num_of_keymaps-selected_row==0 )
	{
		gtk_clist_remove( GTK_CLIST( clist ), selected_row );
		num_of_keymaps--;
	}
	else
	{
		gtk_clist_remove( GTK_CLIST( clist ), selected_row );
		for( i=0; i<num_of_keymaps-selected_row; i++ )
		{
			keymaps[selected_row]=keymaps[selected_row+1];
		}
		num_of_keymaps--;
	}
	CancelEditKeymap( widget );
	set_combos();
}

void delete_keymap_yn( void )
{
	if( selected_row==51 )
	{
		PleaseSelectKeymap();
		return;
	}
	
	GtkWidget *yn, *vbox, *hbox, *label, *button;
	char WindowTitle[40];
	char Question[50];
	
	sprintf( WindowTitle, "Delete Keymap: %s", keymaps[selected_row].name );
	
	gtk_widget_set_sensitive( GTK_WIDGET( window ), FALSE );
	
	yn = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_widget_set_usize( GTK_WIDGET( yn ), 200, 65 );
	gtk_window_set_title( GTK_WINDOW( yn ), WindowTitle );
	gtk_container_border_width( GTK_CONTAINER( yn ), 5 );
	
	vbox = gtk_vbox_new( FALSE, 5 );
	gtk_container_add( GTK_CONTAINER( yn ), vbox );
	gtk_widget_show( vbox );
	
	sprintf( Question, "Delete %s Keymap?", keymaps[selected_row].name );
	
	label = gtk_label_new( Question );
	gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, TRUE, 0 );
	gtk_widget_show( label );
	
	hbox = gtk_hbox_new( TRUE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 0 );
	gtk_widget_show( hbox );
	
	button = gtk_button_new_with_label( "Yes" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( delete_keymap ), GTK_OBJECT( yn ));
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "No" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
	GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
	gtk_widget_grab_default( button );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( CancelEditKeymap ), GTK_OBJECT( yn ));
	gtk_widget_show( button );
	
	gtk_widget_show( yn );
}

void FileSelect_LoadKeymap( GtkWidget *widget )
{
	FILE *load_file;
	char LoadFile[200];
	
	sprintf( LoadFile, "%s", gtk_file_selection_get_filename( (GtkFileSelection *) widget ));
	if( ( load_file = fopen( LoadFile, "rb" )) == NULL )
	{
		fprintf( stderr, "Error opening %s\n", LoadFile );
		exit(1);
	}
	
	if(( fread( &keymaps[num_of_keymaps], sizeof( Keymap ), 1, load_file )) != 1 )
	{
		fprintf( stderr, "Error reading from file: %s\n", LoadFile );
		exit(1);
	}
	num_of_keymaps++;
	fclose( load_file );
	load_clist_data( 1 );
	gtk_widget_set_sensitive( window, TRUE );
	CancelFileSelect( widget );
}

void File_Load( void )
{
	GtkWidget *file_select;
	
	file_select = gtk_file_selection_new( "Load Keymap From File" );
	gtk_signal_connect_object( GTK_OBJECT( GTK_FILE_SELECTION( file_select )->cancel_button ), "clicked", 
		GTK_SIGNAL_FUNC( CancelFileSelect ), GTK_OBJECT( file_select ));
	gtk_signal_connect_object( GTK_OBJECT( GTK_FILE_SELECTION( file_select )->ok_button ), "clicked",
		GTK_SIGNAL_FUNC( FileSelect_LoadKeymap ), GTK_OBJECT( file_select ));
	
	gtk_widget_show( file_select );
}

void FileSelect_SaveKeymap( GtkWidget *widget )
{
	FILE *save_file;
	char SaveFile[200];
	
	sprintf( SaveFile, "%s", gtk_file_selection_get_filename( (GtkFileSelection *) widget ));
	if( ( save_file = fopen( SaveFile, "wb" )) == NULL )
	{
		fprintf( stderr, "Error opening %s\n", SaveFile );
		exit(1);
	}
	
	if(( fwrite( &keymaps[base_keymap], sizeof( Keymap ), 1, save_file )) != 1 )
	{
		fprintf( stderr, "Error writing to file: %s\n", SaveFile );
		exit(1);
	}
	
	fclose( save_file );
	gtk_widget_set_sensitive( window, TRUE );
	CancelFileSelect( widget );
}

void File_Save_FileSelect( void )
{
	GtkWidget *file_select;
	
	file_select = gtk_file_selection_new( "Save Keymap To File" );
	gtk_signal_connect_object( GTK_OBJECT( GTK_FILE_SELECTION( file_select )->cancel_button ), "clicked", 
		GTK_SIGNAL_FUNC( CancelFileSelect ), GTK_OBJECT( file_select ));
	gtk_signal_connect_object( GTK_OBJECT( GTK_FILE_SELECTION( file_select )->ok_button ), "clicked",
		GTK_SIGNAL_FUNC( FileSelect_SaveKeymap ), GTK_OBJECT( file_select ));
	
	gtk_widget_show( file_select );
}

void File_Save( void )
{
	gtk_widget_set_sensitive( window, FALSE );
	GtkWidget *window;
	GtkWidget *clist;
	GtkWidget *button;
	GtkWidget *hbox, *vbox;
	gchar *loaded_keymaps[num_of_keymaps][4];
	GtkWidget *scrolled_window;
	
	window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_window_set_title( GTK_WINDOW( window ), "Select Keymap" );
	gtk_widget_set_usize( window, 320, 250 );
	gtk_container_set_border_width( GTK_CONTAINER( window ), 5 );
	gtk_signal_connect_object( GTK_OBJECT( window ), "delete_event",
		GTK_SIGNAL_FUNC( ErrorOk ), GTK_OBJECT( window ));
	
	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( window ), vbox );
	gtk_widget_show( vbox );
	
	scrolled_window = gtk_scrolled_window_new( NULL, NULL );
	gtk_box_pack_start( GTK_BOX( vbox ), scrolled_window, TRUE, TRUE, 0 );
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( scrolled_window ),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS );
	gtk_widget_show( scrolled_window );
	
	clist = gtk_clist_new_with_titles( 4, clist_titles );
	gtk_container_add( GTK_CONTAINER( scrolled_window ), clist );
	gtk_clist_set_column_width( GTK_CLIST( clist ), 0, 95 );
	gtk_clist_set_column_width( GTK_CLIST( clist ), 1, 25 );
	gtk_clist_set_column_width( GTK_CLIST( clist ), 2, 60 );
	gtk_clist_set_column_width( GTK_CLIST( clist ), 3, 50 );
	gtk_signal_connect( GTK_OBJECT( clist ), "select_row",
		GTK_SIGNAL_FUNC( clist_select_update_1 ), NULL );
	gtk_widget_show( clist );
	
	hbox = gtk_hbox_new( TRUE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 0 );
	gtk_widget_show( hbox );
	
	button = gtk_button_new_with_label( "Save To..." );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( File_Save_FileSelect ), NULL );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ));
	gtk_widget_show( button );
	
	button = gtk_button_new_with_label( "Cancel" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 0 );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( ErrorOk ), GTK_OBJECT( window ));
	gtk_widget_show( button );
	
	for( i=0; i<num_of_keymaps; i++ )
	{
		loaded_keymaps[i][0]=keymaps[i].name;
		loaded_keymaps[i][1]=(gchar *) "134";
		loaded_keymaps[i][2]=NULL;//(gchar *) keymaps[i].keysyms_per_keycode;
		loaded_keymaps[i][3]=NULL;//(gchar *) "134*KS_p_KC"; 
		gtk_clist_append( GTK_CLIST( clist ), loaded_keymaps[i] );
	}
	gtk_widget_show( clist );
	gtk_clist_select_row( GTK_CLIST( clist ), 0, 0 );
	
	gtk_widget_show( window );
}

void set_combos( void )
{
	available_keymaps = NULL;
	for( i=0; i<num_of_keymaps; i++ )
		available_keymaps = g_list_append( available_keymaps, (void *) keymaps[i].name );

	gtk_combo_set_popdown_strings( GTK_COMBO( combo_default ), available_keymaps );
	gtk_combo_set_popdown_strings( GTK_COMBO( combo_alternate ), available_keymaps );
	
	for( i=0; i<num_of_keymaps; i++ )
	{
		if( strncmp( DefaultKeymap, keymaps[i].name, strlen( keymaps[i].name ))==0)
		{
			gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( combo_default )->entry ), keymaps[i].name );
		}
	}
	
	for( i=0; i<num_of_keymaps; i++ )
	{
		if( strncmp( AlternateKeymap, keymaps[i].name, strlen( keymaps[i].name ))==0 )
		{
			gtk_entry_set_text( GTK_ENTRY( GTK_COMBO( combo_alternate )->entry ), keymaps[i].name );
		}
	}
}

#include "menus.h"

void OptionsWindow( void )
{
	GtkTooltips *tooltips;
	GtkWidget *scrolled_window;
	int argc=1;
	char *argv[1]={ "wmkbd" };
	
	gnome_init( "WMKeyboard", VERSION, argc, argv );
	
	window = gnome_app_new( "wmkbd", _("WMKeyboard"));
	gtk_window_set_title( GTK_WINDOW( window ), "WMKeyboard: Options" );
	gtk_widget_set_usize( window, 314, 290 );
	//gtk_container_border_width( GTK_CONTAINER( window ), 5 );
	gtk_signal_connect( GTK_OBJECT( window ), "delete_event",
		GTK_SIGNAL_FUNC( CloseWindow ), NULL );
	gtk_signal_connect( GTK_OBJECT( window ), "destroy",
		GTK_SIGNAL_FUNC( CloseWindow ), NULL );
	gtk_window_set_wmclass( GTK_WINDOW( window ), "options", "WMKeyboard" );

	// Create Menus
	gnome_app_create_menus( GNOME_APP( window ), wmkbd_menu );
	
	vbox = gtk_vbox_new( FALSE, 0 );
	gnome_app_set_contents( GNOME_APP( window ), vbox );
	
	// Initialize tooltips
	tooltips = gtk_tooltips_new();
	
	// Create Notebook
	vbox_notebook = gtk_vbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( vbox ), vbox_notebook, TRUE, TRUE, 0 );
	
	hbox = gtk_hbox_new( TRUE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 5 );
	
	button = gtk_button_new_with_label( "Ok" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( save_options ), NULL );
	
	button = gtk_button_new_with_label( "Cancel" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( CloseWindow ), NULL );
	
	notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos( GTK_NOTEBOOK( notebook ), GTK_POS_TOP );
	gtk_box_pack_start( GTK_BOX( vbox_notebook ), notebook, TRUE, TRUE, 0 );
	
	// Notebook Page 1
	label = gtk_label_new( "Main" );
	frame = gtk_frame_new( "Main Options" );
	gtk_container_border_width( GTK_CONTAINER( frame ), 5 );	
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), 
		frame, label );
	
	vbox_tab_1 = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox_tab_1 );
	
	frame = gtk_frame_new( "Shortcut" );
	gtk_box_pack_start( GTK_BOX( vbox_tab_1 ), frame, TRUE, TRUE, 0 );
	gtk_container_border_width( GTK_CONTAINER( frame ), 5 );
	
	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox );
	
	radio_as = gtk_radio_button_new_with_label( NULL, "Alt+Shift" );
	gtk_box_pack_start( GTK_BOX( vbox ), radio_as, FALSE, FALSE, 0 );
	gtk_signal_connect( GTK_OBJECT( radio_as ), "clicked",
		GTK_SIGNAL_FUNC( set_switchmethod_1 ), NULL );
	
	group = gtk_radio_button_group( GTK_RADIO_BUTTON( radio_as ));
	radio_cs = gtk_radio_button_new_with_label( group, "Ctrl+Shift" );
	gtk_box_pack_start( GTK_BOX( vbox ), radio_cs, FALSE, FALSE, 0 );
	gtk_signal_connect( GTK_OBJECT( radio_cs ), "clicked",
		GTK_SIGNAL_FUNC( set_switchmethod_2 ), NULL );
	
	group = gtk_radio_button_group( GTK_RADIO_BUTTON( radio_cs ));
	radio_ss = gtk_radio_button_new_with_label( group, "Shift+Shift" );
	gtk_signal_connect( GTK_OBJECT( radio_ss ), "clicked",
		GTK_SIGNAL_FUNC( set_switchmethod_3 ), NULL );
	gtk_box_pack_start( GTK_BOX( vbox ), radio_ss, FALSE, FALSE, 0 );
	
	switch( SwitchMethod )
	{
		case 1:
			gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( radio_as ), TRUE);
			break;
		case 2:
			gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( radio_cs ), TRUE);
			break;
		case 3:
			gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( radio_ss ), TRUE);
			break;
		default:
			gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( radio_as ), TRUE);
			break;
	}
	
	frame = gtk_frame_new( "Keymaps" );
	gtk_box_pack_start( GTK_BOX( vbox_tab_1 ), frame, TRUE, TRUE, 0 );
	gtk_container_border_width( GTK_CONTAINER( frame ), 5 );
	
	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), hbox );
	
	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( hbox ), vbox, FALSE, TRUE, 5 );
	
	label = gtk_label_new( "Default:" );
	gtk_box_pack_start( GTK_BOX( vbox ), label, TRUE, TRUE, 0 );
	
	label = gtk_label_new( "Alternate:" );
	gtk_box_pack_start( GTK_BOX( vbox ), label, TRUE, TRUE, 0 );
	
	vbox = gtk_vbox_new( FALSE, 5 );
	gtk_box_pack_start( GTK_BOX( hbox ), vbox, FALSE, TRUE, 5 );
	
	combo_default = gtk_combo_new();
	gtk_box_pack_start( GTK_BOX( vbox ), combo_default, TRUE, TRUE, 0 );
	gtk_entry_set_editable( GTK_ENTRY( GTK_COMBO( combo_default )->entry ),FALSE );
	
	combo_alternate = gtk_combo_new();
	gtk_box_pack_start( GTK_BOX( vbox ), combo_alternate, TRUE, TRUE, 0 );
	gtk_entry_set_editable( GTK_ENTRY( GTK_COMBO( combo_alternate )->entry ), FALSE );

	set_combos();

	// Notebook Page 2
	label = gtk_label_new( "Keymap Management" );
	frame = gtk_frame_new( "Keymaps" );
	gtk_container_border_width( GTK_CONTAINER( frame ), 5 );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), frame, label );
	
	vbox_tab_2 = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), vbox_tab_2 );
	
	scrolled_window = gtk_scrolled_window_new( NULL, NULL );
	gtk_box_pack_start( GTK_BOX( vbox_tab_2 ), scrolled_window, TRUE, TRUE, 0 );
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( scrolled_window ),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS );
	
	clist = gtk_clist_new_with_titles( 4, clist_titles );
	gtk_container_add( GTK_CONTAINER( scrolled_window ), clist );
	gtk_clist_set_column_width( GTK_CLIST( clist ), 0, 95 );
	gtk_clist_set_column_width( GTK_CLIST( clist ), 1, 25 );
	gtk_clist_set_column_width( GTK_CLIST( clist ), 2, 60 );
	gtk_clist_set_column_width( GTK_CLIST( clist ), 3, 50 );
	gtk_signal_connect( GTK_OBJECT( clist ), "select_row",
		GTK_SIGNAL_FUNC( clist_select_update ), NULL );
	
	load_clist_data( 0 );
	
	hbox = gtk_hbox_new( TRUE, 5 );
	gtk_box_pack_start( GTK_BOX( vbox_tab_2 ), hbox, FALSE, FALSE, 5 );
	
	button = gtk_button_new_with_label( "Edit" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( EditKeymap ), NULL );
	gtk_tooltips_set_tip( tooltips, button, "Edit Selected Keymap", NULL );
	
	button = gtk_button_new_with_label( "New" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( NewKeymap ), NULL );
	gtk_tooltips_set_tip( tooltips, button, "Create A New Keymap", NULL );
	
	button = gtk_button_new_with_label( "Delete" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 0 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
		GTK_SIGNAL_FUNC( delete_keymap_yn ), NULL );
	gtk_tooltips_set_tip( tooltips, button, "Delete Selected Keymap", NULL );

	gtk_widget_show_all( window );

	gtk_main();
}
