/*
 * popedit.
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <gtk/gtk.h>
#include "defines.h"


void pop_edit(const char *title, const char *bsrv, const char *user, const char *pass, const char *fold, void *ok_cb)
{
        GtkWidget *dialog;
        GtkWidget *bouton;
        GtkWidget *label;
        GtkWidget *entry;
        GtkWidget *vbox;
        char field[MAXSTRLEN + 1];

        dialog = gtk_dialog_new();
        gtk_window_set_title(GTK_WINDOW(dialog), title);
        gtk_signal_connect(GTK_OBJECT(dialog), "delete_event",
                           GTK_SIGNAL_FUNC(gtk_widget_destroy),
                           NULL);
        gtk_signal_connect(GTK_OBJECT(dialog), "destroy",
                           GTK_SIGNAL_FUNC(gtk_widget_destroy),
                           NULL);

        vbox = GTK_DIALOG(dialog)->vbox;
        gtk_container_set_border_width(GTK_CONTAINER(vbox), 6);

        snprintf(field, MAXSTRLEN, "%s %s %s %s",
                 bsrv ? bsrv : "server",
                 user ? user : "username",
                 pass ? pass : "password",
                 fold ? fold : "[folder]");

        label = gtk_label_new("Enter box informations : ");
        gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 1);
        gtk_widget_show(label);

        entry = gtk_entry_new();
        gtk_entry_set_text(GTK_ENTRY(entry), field);
        gtk_box_pack_start(GTK_BOX(vbox), entry, FALSE, FALSE, 1);
        gtk_widget_show(entry);

        label = gtk_label_new("You should enter the following space-separated informations :");
        gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 1);
        gtk_widget_show(label);

        label = gtk_label_new("server username password");
        gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 1);
        gtk_widget_show(label);

        /* Commandes */
        bouton = gtk_button_new_with_label("OK");
        if (ok_cb != NULL)
                gtk_signal_connect(GTK_OBJECT(bouton), "clicked",
                                   GTK_SIGNAL_FUNC(ok_cb),
                                   entry);
        gtk_signal_connect_object(GTK_OBJECT(bouton), "clicked",
                                  GTK_SIGNAL_FUNC(gtk_widget_destroy),
                                  GTK_OBJECT(dialog));
        gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
                           bouton, TRUE, TRUE, 0);
        GTK_WIDGET_SET_FLAGS(GTK_WIDGET(bouton), GTK_CAN_DEFAULT);
        gtk_widget_grab_default(GTK_WIDGET(bouton));
        gtk_widget_draw_default(GTK_WIDGET(bouton));
        gtk_widget_show(bouton);

        bouton = gtk_button_new_with_label("Cancel");
        gtk_signal_connect_object(GTK_OBJECT(bouton), "clicked",
                                  GTK_SIGNAL_FUNC(gtk_widget_destroy),
                                  GTK_OBJECT(dialog));
        gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
                           bouton, TRUE, TRUE, 0);
        GTK_WIDGET_SET_FLAGS(GTK_WIDGET(bouton), GTK_CAN_DEFAULT);
        gtk_widget_show(bouton);

        gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
        gtk_widget_show(dialog);
}
