//  Copyright (C) 1999 by
//  id Software, Chi Hoang, Lee Killough, Jim Flynn, Rand Phares, Ty Halderman
//  Copyright (C) 2021 by Ryan Krafnick
//  Copyright (C) 2023 liPillON
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
// DESCRIPTION:
//      bargraph patches, smaller digit patches, full new smaller hud font

// jff 02/16/98 HUD bargraph patches
//  The HUD uses vertical stripe characters to make up the bars in
//  view during play, and those are made up here at various stages
//  of "fullness".  Note that all HUD elements can be recolored
//  dynamically in the code, so only the shapes are defined here.

static const unsigned char stbr123[] = {
    // full
    8,   0,   8,   0,   0,   0,   0,   0,   40,  0,   0,   0,   51,  0,   0,
    0,   52,  0,   0,   0,   63,  0,   0,   0,   64,  0,   0,   0,   75,  0,
    0,   0,   76,  0,   0,   0,   87,  0,   0,   0,   1,   6,   185, 185, 180,
    176, 180, 185, 0,   0,   255, 255, 1,   6,   185, 185, 180, 176, 180, 185,
    0,   0,   255, 255, 1,   6,   185, 185, 180, 176, 180, 185, 0,   0,   255,
    255, 1,   6,   185, 185, 180, 176, 180, 185, 0,   0,   255, 255,
};

static const unsigned char stbr124[] = {
    // 3/4 full
    8,  0, 8,   0,   0,   0,   0,   0,   40,  0,   0,   0,   51,  0,   0,   0,
    52, 0, 0,   0,   63,  0,   0,   0,   64,  0,   0,   0,   75,  0,   0,   0,
    76, 0, 0,   0,   77,  0,   0,   0,   1,   6,   185, 185, 180, 176, 180, 185,
    0,  0, 255, 255, 1,   6,   185, 185, 180, 176, 180, 185, 0,   0,   255, 255,
    1,  6, 185, 185, 180, 176, 180, 185, 0,   0,   255, 255, 255, 255,
};

static const unsigned char stbr125[] = {
    // half full
    8,   0,   8,   0,   0,   0,   0,   0,   40,  0,   0,   0,   51,  0,
    0,   0,   52,  0,   0,   0,   63,  0,   0,   0,   64,  0,   0,   0,
    65,  0,   0,   0,   66,  0,   0,   0,   67,  0,   0,   0,   1,   6,
    185, 185, 180, 176, 180, 185, 0,   0,   255, 255, 1,   6,   185, 185,
    180, 176, 180, 185, 0,   0,   255, 255, 255, 255, 255, 255,
};

static const unsigned char stbr126[] = {
    // quarter full
    8,   0,   8,   0, 0, 0,   0,   0,   40,  0,   0,   0,   51,  0,   0,
    0,   52,  0,   0, 0, 53,  0,   0,   0,   54,  0,   0,   0,   55,  0,
    0,   0,   56,  0, 0, 0,   57,  0,   0,   0,   1,   6,   185, 185, 180,
    176, 180, 185, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
};

static const unsigned char stbr127[] = {
    // empty block
    8,  0, 8, 0, 0,  0, 0, 0, 40,  0,   0,   0,   41,  0,   0,   0,
    42, 0, 0, 0, 43, 0, 0, 0, 44,  0,   0,   0,   45,  0,   0,   0,
    46, 0, 0, 0, 47, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
};

// The digits themselves that are used in the HUD

static const unsigned char dig0[] = {
    // zero
    5,   0,   7, 0,   0,   0, 0, 0,   28, 0, 0,   0,   38, 0, 0,   0,   49,
    0,   0,   0, 62,  0,   0, 0, 73,  0,  0, 0,   1,   5,  0, 176, 176, 176,
    176, 176, 0, 255, 1,   6, 0, 176, 0,  0, 0,   176, 0,  0, 255, 1,   2,
    0,   176, 0, 0,   5,   2, 0, 176, 0,  0, 255, 1,   6,  0, 176, 176, 176,
    176, 176, 0, 0,   255, 2, 5, 0,   0,  0, 0,   0,   0,  0, 255,
};

static const unsigned char dig1[] = {
    // one
    5,   0,   7,   0,   0,   0,   0,   0,   28,  0,  0, 0,   34,  0, 0,
    0,   46,  0,   0,   0,   57,  0,   0,   0,   67, 0, 0,   0,   5, 1,
    176, 176, 176, 255, 1,   1,   176, 176, 176, 5,  2, 176, 176, 0, 0,
    255, 1,   6,   176, 176, 176, 176, 176, 176, 0,  0, 255, 2,   5, 0,
    0,   0,   0,   176, 0,   0,   255, 6,   1,   0,  0, 0,   255,
};

static const unsigned char dig2[] = {
    // two
    5, 0,   7,   0,   0, 0,  0,   0,   28,  0,  0,   0,   41,  0,   0,
    0, 52,  0,   0,   0, 63, 0,   0,   0,   74, 0,   0,   0,   1,   1,
    0, 176, 0,   3,   3, 0,  176, 176, 176, 0,  255, 1,   6,   0,   176,
    0, 176, 0,   176, 0, 0,  255, 1,   6,   0,  176, 0,   176, 0,   176,
    0, 0,   255, 1,   6, 0,  176, 176, 176, 0,  176, 0,   0,   255, 2,
    3, 0,   0,   0,   0, 0,  6,   1,   0,   0,  0,   255,
};

static const unsigned char dig3[] = {
    // three
    5,   0,   7,   0, 0,   0,   0,   0,   28,  0,   0,   0, 41,  0,   0,
    0,   55,  0,   0, 0,   69,  0,   0,   0,   80,  0,   0, 0,   1,   2,
    0,   176, 176, 0, 4,   2,   0,   176, 176, 0,   255, 1, 3,   0,   176,
    0,   0,   0,   5, 2,   0,   176, 0,   0,   255, 1,   3, 0,   176, 0,
    176, 0,   5,   2, 0,   176, 0,   0,   255, 1,   6,   0, 176, 176, 176,
    176, 176, 0,   0, 255, 2,   5,   0,   0,   0,   0,   0, 0,   0,   255,
};

static const unsigned char dig4[] = {
    // four
    5,   0,   7,   0,   0,   0,   0,   0,   28,  0,   0,   0,   37,  0, 0,
    0,   46,  0,   0,   0,   56,  0,   0,   0,   66,  0,   0,   0,   1, 4,
    176, 176, 176, 176, 176, 176, 255, 2,   4,   0,   0,   0,   176, 0, 0,
    255, 1,   5,   176, 176, 176, 176, 176, 176, 176, 255, 2,   5,   0, 0,
    0,   176, 0,   0,   0,   255, 5,   1,   0,   0,   0,   255,
};

static const unsigned char dig5[] = {
    // five
    5,   0,   7,   0,   0,   0,   0,   0,   28,  0,   0,   0,   41,  0,   0,
    0,   52,  0,   0,   0,   63,  0,   0,   0,   74,  0,   0,   0,   1,   3,
    176, 176, 176, 176, 176, 5,   1,   176, 176, 176, 255, 1,   6,   176, 176,
    0,   176, 0,   176, 0,   0,   255, 1,   6,   176, 176, 0,   176, 0,   176,
    0,   0,   255, 1,   6,   176, 176, 0,   176, 176, 176, 0,   0,   255, 2,
    1,   0,   0,   0,   4,   3,   0,   0,   0,   0,   0,   255,
};

static const unsigned char dig6[] = {
    // six
    5,   0,   7,   0,   0,   0,   0,   0,   28,  0,   0,   0,   38,  0,
    0,   0,   49,  0,   0,   0,   60,  0,   0,   0,   71,  0,   0,   0,
    1,   5,   176, 176, 176, 176, 176, 176, 176, 255, 1,   6,   176, 176,
    0,   176, 0,   176, 0,   0,   255, 1,   6,   176, 176, 0,   176, 0,
    176, 0,   0,   255, 1,   6,   176, 176, 0,   176, 176, 176, 0,   0,
    255, 2,   1,   0,   0,   0,   4,   3,   0,   0,   0,   0,   0,   255,
};

static const unsigned char dig7[] = {
    // seven
    5,   0,   7,   0,   0,   0,   0,   0,   28,  0,   0,   0,   34, 0,   0,
    0,   41,  0,   0,   0,   51,  0,   0,   0,   65,  0,   0,   0,  1,   1,
    176, 176, 176, 255, 1,   2,   176, 176, 0,   0,   255, 1,   5,  176, 176,
    0,   176, 176, 176, 176, 255, 1,   2,   176, 176, 176, 176, 4,  3,   0,
    0,   0,   0,   0,   255, 2,   2,   0,   0,   0,   0,   255,
};

static const unsigned char dig8[] = {
    // eight
    5,   0,   7,  0,   0,   0,   0,   0,   28,  0,   0,   0,   38,  0,
    0,   0,   49, 0,   0,   0,   60,  0,   0,   0,   71,  0,   0,   0,
    1,   5,   0,  176, 176, 176, 176, 176, 0,   255, 1,   6,   0,   176,
    0,   176, 0,  176, 0,   0,   255, 1,   6,   0,   176, 0,   176, 0,
    176, 0,   0,  255, 1,   6,   0,   176, 176, 176, 176, 176, 0,   0,
    255, 2,   5,  0,   0,   0,   0,   0,   0,   0,   255,
};

static const unsigned char dig9[] = {
    // nine
    5,   0,   7,   0,   0,   0,   0,   0, 28, 0,   0,   0,   41,  0,
    0,   0,   52,  0,   0,   0,   63,  0, 0,  0,   74,  0,   0,   0,
    1,   3,   0,   176, 176, 176, 0,   5, 1,  0,   176, 0,   255, 1,
    6,   0,   176, 0,   176, 0,   176, 0, 0,  255, 1,   6,   0,   176,
    0,   176, 0,   176, 0,   0,   255, 1, 6,  0,   176, 176, 176, 176,
    176, 0,   0,   255, 2,   5,   0,   0, 0,  0,   0,   0,   0,   255,
};

static const unsigned char dig37[] = {
    // percent '%'
    0x05, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00,
    0x00, 0x1d, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x00, 0x00, 0x31, 0x00,
    0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0xff, 0x01, 0x02, 0x00, 0xb0,
    0x00, 0x00, 0x04, 0x02, 0x00, 0xb0, 0x00, 0x00, 0xff, 0x03, 0x02,
    0x00, 0xb0, 0x00, 0x00, 0xff, 0x02, 0x02, 0x00, 0xb0, 0x00, 0x00,
    0x05, 0x02, 0x00, 0xb0, 0x00, 0x00, 0xff, 0xff
};

static const unsigned char dig43[] = {
    // plus '+'
    0x05, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00,
    0x1d, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00, 0x2b, 0x00, 0x00, 0x00,
    0x33, 0x00, 0x00, 0x00, 0xff, 0x03, 0x01, 0x00, 0xb0, 0x00, 0xff, 0x02,
    0x03, 0x00, 0xb0, 0xb0, 0xb0, 0x00, 0xff, 0x03, 0x03, 0x00, 0xb0, 0x00,
    0x00, 0x00, 0xff, 0x04, 0x01, 0x00, 0x00, 0x00, 0xff
};

static const unsigned char dig45[] = {
    // minus '-'
    5,   0, 7,  0,   0,   0, 0,   0, 28, 0, 0,   0, 29,  0,
    0,   0, 35, 0,   0,   0, 42,  0, 0,  0, 49,  0, 0,   0,
    255, 3, 1,  0,   176, 0, 255, 3, 2,  0, 176, 0, 0,   255,
    3,   2, 0,  176, 0,   0, 255, 4, 1,  0, 0,   0, 255,
};

static const unsigned char dig46[] = {
    // '.'
    0x05, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,
    0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00,
    0x25, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00, 0xff, 0xff,
    0x05, 0x02, 0x00, 0xb0, 0x00, 0x00, 0xff, 0xff, 0xff
};

static const unsigned char dig47[] = {
    // slash '/'
    5, 0,   7, 0,  0, 0,   0, 0,  28,  0, 0, 0,   29,  0, 0, 0,   36,
    0, 0,   0, 43, 0, 0,   0, 50, 0,   0, 0, 255, 4,   2, 0, 176, 0,
    0, 255, 3, 2,  0, 176, 0, 0,  255, 2, 2, 0,   176, 0, 0, 255, 255,
};

static const unsigned char dig58[] = {
    // colon ':'
    5, 0, 7,   0, 0,   0, 0,  0, 28, 0, 0,   0,   29, 0, 0, 0,   30,  0,
    0, 0, 41,  0, 0,   0, 52, 0, 0,  0, 255, 255, 2,  1, 0, 176, 0,   4,
    1, 0, 176, 0, 255, 3, 1,  0, 0,  0, 5,   1,   0,  0, 0, 255, 255,
};

static const unsigned char dig91[] = {
    // open bracket '['
    5,   0,   7,   0,   0,   0, 0,   0, 28, 0, 0,   0, 29,  0,   0,   0,
    39,  0,   0,   0,   50,  0, 0,   0, 61, 0, 0,   0, 255, 1,   5,   0,
    176, 176, 176, 176, 176, 0, 255, 1, 6,  0, 176, 0, 0,   0,   176, 0,
    0,   255, 2,   1,   0,   0, 0,   6, 1,  0, 0,   0, 255, 255,
};

static const unsigned char dig93[] = {
    // close bracket ']'
    5,   0, 7,   0, 0,  0,   0, 0,   28, 0, 0, 0,   29,  0,   0,   0,
    40,  0, 0,   0, 51, 0,   0, 0,   61, 0, 0, 0,   255, 1,   1,   0,
    176, 0, 5,   1, 0,  176, 0, 255, 1,  6, 0, 176, 176, 176, 176, 176,
    0,   0, 255, 2, 5,  0,   0, 0,   0,  0, 0, 0,   255, 255,
};

// these are the letters A-Z

static const unsigned char diga[] = {
    5,   0, 7,   0,  0,   0,   0,   0,   28,  0,   0,   0,   38,
    0,   0, 0,   49, 0,   0,   0,   58,  0,   0,   0,   68,  0,
    0,   0, 1,   5,  0,   176, 176, 176, 176, 176, 0,   255, 1,
    6,   0, 176, 0,  176, 0,   0,   0,   0,   255, 1,   4,   0,
    176, 0, 176, 0,  0,   255, 1,   5,   0,   176, 176, 176, 176,
    176, 0, 255, 2,  5,   0,   0,   0,   0,   0,   0,   0,   255,
};

static const unsigned char digb[] = {
    5,   0,   7,   0,   0,   0,   0,   0, 28,  0,   0, 0,   38, 0,   0,   0,
    49,  0,   0,   0,   60,  0,   0,   0, 70,  0,   0, 0,   1,  5,   176, 176,
    176, 176, 176, 176, 176, 255, 1,   6, 176, 176, 0, 176, 0,  176, 0,   0,
    255, 1,   6,   176, 176, 176, 176, 0, 176, 0,   0, 255, 2,  5,   0,   0,
    176, 176, 176, 0,   0,   255, 3,   4, 0,   0,   0, 0,   0,  0,   255,
};

static const unsigned char digc[] = {
    5,   0,   7,   0,   0,   0,   0, 0,   28, 0,  0,   0,   38, 0,   0,
    0,   49,  0,   0,   0,   62,  0, 0,   0,  75, 0,   0,   0,  1,   5,
    0,   176, 176, 176, 176, 176, 0, 255, 1,  6,  0,   176, 0,  0,   0,
    176, 0,   0,   255, 1,   2,   0, 176, 0,  0,  5,   2,   0,  176, 0,
    0,   255, 1,   2,   0,   176, 0, 0,   5,  2,  0,   176, 0,  0,   255,
    2,   1,   0,   0,   0,   6,   1, 0,   0,  0,  255,
};

static const unsigned char digd[] = {
    5,   0,   7,   0,   0,   0,   0, 0,   28, 0,   0,   0, 38, 0,   0, 0,
    49,  0,   0,   0,   62,  0,   0, 0,   72, 0,   0,   0, 1,  5,   0, 176,
    176, 176, 176, 176, 0,   255, 1, 6,   0,  176, 0,   0, 0,  176, 0, 0,
    255, 1,   2,   0,   176, 0,   0, 5,   2,  0,   176, 0, 0,  255, 2, 5,
    0,   176, 176, 176, 0,   0,   0, 255, 3,  3,   0,   0, 0,  0,   0, 255,
};

static const unsigned char dige[] = {
    5,   0,   7,   0,   0, 0,   0, 0,   28,  0,   0, 0,   38,  0, 0,   0,   49,
    0,   0,   0,   60,  0, 0,   0, 74,  0,   0,   0, 1,   5,   0, 176, 176, 176,
    176, 176, 0,   255, 1, 6,   0, 176, 0,   176, 0, 176, 0,   0, 255, 1,   6,
    0,   176, 0,   176, 0, 176, 0, 0,   255, 1,   2, 0,   176, 0, 0,   4,   3,
    0,   0,   176, 0,   0, 255, 2, 1,   0,   0,   0, 6,   1,   0, 0,   0,   255,
};

static const unsigned char digf[] = {
    5,   0,   7,   0,   0,   0,   0,   0, 28, 0,   0, 0,   38, 0,   0, 0,
    49,  0,   0,   0,   58,  0,   0,   0, 70, 0,   0, 0,   1,  5,   0, 176,
    176, 176, 176, 176, 0,   255, 1,   6, 0,  176, 0, 176, 0,  0,   0, 0,
    255, 1,   4,   0,   176, 0,   176, 0, 0,  255, 1, 2,   0,  176, 0, 0,
    4,   1,   0,   0,   0,   255, 2,   1, 0,  0,   0, 255,
};

static const unsigned char digg[] = {
    5,   0,   7,   0,   0,   0,   0,   0,   28,  0,   0,   0,   38, 0,   0,
    0,   49,  0,   0,   0,   63,  0,   0,   0,   74,  0,   0,   0,  1,   5,
    0,   176, 176, 176, 176, 176, 0,   255, 1,   6,   0,   176, 0,  0,   0,
    176, 0,   0,   255, 1,   3,   0,   176, 0,   176, 0,   5,   2,  0,   176,
    0,   0,   255, 1,   6,   0,   176, 0,   176, 176, 176, 0,   0,  255, 2,
    1,   0,   0,   0,   4,   3,   0,   0,   0,   0,   0,   255,
};

static const unsigned char digh[] = {
    5,   0,   7,   0,   0,   0,   0,   0,   28, 0,   0, 0, 38,  0,   0,
    0,   48,  0,   0,   0,   55,  0,   0,   0,  65,  0, 0, 0,   1,   5,
    0,   176, 176, 176, 176, 176, 0,   255, 2,  5,   0, 0, 176, 0,   0,
    0,   0,   255, 3,   2,   0,   176, 0,   0,  255, 1, 5, 0,   176, 176,
    176, 176, 176, 0,   255, 2,   5,   0,   0,  0,   0, 0, 0,   0,   255,
};

static const unsigned char digi[] = {
    5,   0,   7,   0,   0, 0,   0,   0,   28,  0,   0, 0, 29,  0,   0,
    0,   40,  0,   0,   0, 51,  0,   0,   0,   62,  0, 0, 0,   255, 1,
    1,   176, 176, 176, 5, 1,   176, 176, 176, 255, 1, 6, 176, 176, 176,
    176, 176, 176, 0,   0, 255, 1,   6,   176, 176, 0, 0, 0,   176, 0,
    0,   255, 2,   1,   0, 0,   0,   6,   1,   0,   0, 0, 255,
};

static const unsigned char digj[] = {
    5, 0,   7,   0,   0, 0,   0,   0,   28,  0,   0, 0, 40,  0, 0,   0,   53,
    0, 0,   0,   64,  0, 0,   0,   75,  0,   0,   0, 1, 1,   0, 176, 0,   4,
    2, 0,   176, 176, 0, 255, 1,   2,   0,   176, 0, 0, 5,   2, 0,   176, 0,
    0, 255, 1,   6,   0, 176, 176, 176, 176, 176, 0, 0, 255, 1, 6,   0,   176,
    0, 0,   0,   0,   0, 0,   255, 2,   1,   0,   0, 0, 255,
};

static const unsigned char digk[] = {
    5,   0,   7,   0,   0,   0,   0, 0, 28,  0, 0,   0,   38,  0, 0,   0,
    48,  0,   0,   0,   57,  0,   0, 0, 67,  0, 0,   0,   1,   5, 176, 176,
    176, 176, 176, 176, 176, 255, 2, 5, 0,   0, 176, 0,   0,   0, 0,   255,
    1,   4,   176, 176, 176, 176, 0, 0, 255, 1, 5,   176, 176, 0, 176, 176,
    176, 176, 255, 2,   1,   0,   0, 0, 4,   3, 0,   0,   0,   0, 0,   255,
};

static const unsigned char digl[] = {
    5,   0,   7, 0,   0, 0, 0, 0,   28, 0, 0,   0, 38, 0,   0,   0,   48,
    0,   0,   0, 55,  0, 0, 0, 62,  0,  0, 0,   1, 5,  0,   176, 176, 176,
    176, 176, 0, 255, 2, 5, 0, 0,   0,  0, 176, 0, 0,  255, 5,   2,   0,
    176, 0,   0, 255, 5, 2, 0, 176, 0,  0, 255, 6, 1,  0,   0,   0,   255,
};

static const unsigned char digm[] = {
    5,   0,   7,   0,   0,   0,   0, 0,   28, 0,   0,   0,   38,  0,   0,   0,
    48,  0,   0,   0,   56,  0,   0, 0,   66, 0,   0,   0,   1,   5,   0,   176,
    176, 176, 176, 176, 0,   255, 2, 5,   0,  176, 176, 0,   0,   0,   0,   255,
    2,   3,   0,   176, 176, 0,   0, 255, 1,  5,   0,   176, 176, 176, 176, 176,
    0,   255, 2,   5,   0,   0,   0, 0,   0,  0,   0,   255,
};

static const unsigned char dign[] = {
    5,   0,   7,   0,   0,   0,   0,   0,   28, 0,   0, 0,   38,  0,   0,
    0,   48,  0,   0,   0,   55,  0,   0,   0,  65,  0, 0,   0,   1,   5,
    0,   176, 176, 176, 176, 176, 0,   255, 2,  5,   0, 176, 176, 0,   0,
    0,   0,   255, 3,   2,   0,   176, 176, 0,  255, 1, 5,   0,   176, 176,
    176, 176, 176, 0,   255, 2,   5,   0,   0,  0,   0, 0,   0,   0,   255,
};

static const unsigned char digo[] = {
    5,   0,   7, 0,   0,   0, 0, 0,   28, 0, 0,   0,   38, 0, 0,   0,   49,
    0,   0,   0, 62,  0,   0, 0, 73,  0,  0, 0,   1,   5,  0, 176, 176, 176,
    176, 176, 0, 255, 1,   6, 0, 176, 0,  0, 0,   176, 0,  0, 255, 1,   2,
    0,   176, 0, 0,   5,   2, 0, 176, 0,  0, 255, 1,   6,  0, 176, 176, 176,
    176, 176, 0, 0,   255, 2, 5, 0,   0,  0, 0,   0,   0,  0, 255,
};

static const unsigned char digp[] = {
    5, 0,   7,   0,   0,   0,   0,   0,   28, 0,   0, 0,   38,  0,   0,
    0, 49,  0,   0,   0,   58,  0,   0,   0,  67,  0, 0,   0,   1,   5,
    0, 176, 176, 176, 176, 176, 0,   255, 1,  6,   0, 176, 0,   176, 0,
    0, 0,   0,   255, 1,   4,   0,   176, 0,  176, 0, 0,   255, 1,   4,
    0, 176, 176, 176, 0,   0,   255, 2,   3,  0,   0, 0,   0,   0,   255,
};

static const unsigned char digq[] = {
    5, 0,   7,   0,   0,   0,   0,   0,   28,  0,   0,   0,   38,  0,
    0, 0,   49,  0,   0,   0,   62,  0,   0,   0,   73,  0,   0,   0,
    1, 5,   176, 176, 176, 176, 176, 176, 176, 255, 1,   6,   176, 176,
    0, 0,   176, 176, 0,   0,   255, 1,   2,   176, 176, 0,   0,   5,
    2, 176, 176, 176, 176, 255, 1,   6,   176, 176, 176, 176, 176, 176,
    0, 0,   255, 2,   5,   0,   0,   0,   0,   0,   0,   0,   255,
};

static const unsigned char digr[] = {
    5,   0,   7,   0,   0,   0,   0,   0,   28,  0,   0,   0,   38,  0,   0,
    0,   49,  0,   0,   0,   58,  0,   0,   0,   67,  0,   0,   0,   1,   5,
    176, 176, 176, 176, 176, 176, 176, 255, 1,   6,   176, 176, 0,   176, 0,
    0,   0,   0,   255, 1,   4,   176, 176, 176, 176, 0,   0,   255, 2,   4,
    0,   0,   176, 176, 176, 176, 255, 4,   3,   0,   0,   0,   0,   0,   255,
};

static const unsigned char digs[] = {
    5,   0,   7,   0,   0,   0,   0,   0,   28,  0,   0,   0,   41,  0,   0,
    0,   52,  0,   0,   0,   63,  0,   0,   0,   74,  0,   0,   0,   1,   3,
    176, 176, 176, 176, 176, 5,   1,   176, 176, 176, 255, 1,   6,   176, 176,
    0,   176, 0,   176, 0,   0,   255, 1,   6,   176, 176, 0,   176, 0,   176,
    0,   0,   255, 1,   6,   176, 176, 0,   176, 176, 176, 0,   0,   255, 2,
    1,   0,   0,   0,   4,   3,   0,   0,   0,   0,   0,   255,
};

static const unsigned char digt[] = {
    5, 0, 7, 0,   0, 0, 0,   0,  28, 0, 0,   0,   34,  0,   0,   0, 41,
    0, 0, 0, 51,  0, 0, 0,   62, 0,  0, 0,   1,   1,   0,   176, 0, 255,
    1, 2, 0, 176, 0, 0, 255, 1,  5,  0, 176, 176, 176, 176, 176, 0, 255,
    1, 6, 0, 176, 0, 0, 0,   0,  0,  0, 255, 2,   1,   0,   0,   0, 255,
};

static const unsigned char digu[] = {
    5,   0,   7,   0,   0,  0,   0,   0, 28, 0, 0,   0,   38,  0,   0,   0,
    48,  0,   0,   0,   55, 0,   0,   0, 66, 0, 0,   0,   1,   5,   0,   176,
    176, 176, 176, 176, 0,  255, 2,   5, 0,  0, 0,   0,   176, 0,   0,   255,
    5,   2,   0,   176, 0,  0,   255, 1, 6,  0, 176, 176, 176, 176, 176, 0,
    0,   255, 2,   5,   0,  0,   0,   0, 0,  0, 0,   255,
};

static const unsigned char digv[] = {
    5,   0,   7,   0,   0,   0,   0,   0,   28, 0,  0,   0,   36,  0,   0,
    0,   45,  0,   0,   0,   53,  0,   0,   0,  67, 0,   0,   0,   1,   3,
    176, 176, 176, 176, 176, 255, 2,   4,   0,  0,  0,   176, 176, 176, 255,
    4,   3,   176, 176, 176, 0,   0,   255, 1,  3,  176, 176, 176, 176, 176,
    5,   2,   0,   0,   0,   0,   255, 2,   3,  0,  0,   0,   0,   0,   255,
};

static const unsigned char digw[] = {
    5,   0,   7,   0,   0,   0,   0,   0,   28, 0,   0,   0,   38,  0,   0,
    0,   47,  0,   0,   0,   55,  0,   0,   0,  65,  0,   0,   0,   1,   5,
    176, 176, 176, 176, 176, 176, 176, 255, 3,  4,   176, 176, 176, 0,   0,
    0,   255, 3,   3,   176, 176, 176, 0,   0,  255, 1,   5,   176, 176, 176,
    176, 176, 176, 176, 255, 2,   5,   0,   0,  0,   0,   0,   0,   0,   255,
};

static const unsigned char digx[] = {
    5,   0,   7,   0,   0,   0,   0,   0,   28,  0,   0,   0,   41,  0,
    0,   0,   51,  0,   0,   0,   60,  0,   0,   0,   70,  0,   0,   0,
    1,   2,   176, 176, 176, 176, 4,   2,   176, 176, 176, 176, 255, 2,
    5,   176, 176, 176, 176, 0,   0,   0,   255, 2,   4,   176, 176, 176,
    176, 0,   0,   255, 1,   5,   176, 176, 176, 0,   176, 176, 176, 255,
    2,   2,   0,   0,   0,   0,   5,   2,   0,   0,   0,   0,   255,
};

static const unsigned char digy[] = {
    5,   0, 7,   0,   0,   0,   0,   0,   28,  0,   0,   0,   41,  0,
    0,   0, 51,  0,   0,   0,   60,  0,   0,   0,   71,  0,   0,   0,
    1,   3, 176, 176, 176, 176, 176, 5,   1,   176, 176, 176, 255, 2,
    5,   0, 0,   176, 0,   176, 0,   0,   255, 3,   4,   176, 176, 0,
    176, 0, 0,   255, 1,   6,   176, 176, 176, 176, 176, 176, 0,   0,
    255, 2, 5,   0,   0,   0,   0,   0,   0,   0,   255,
};

static const unsigned char digz[] = {
    5,   0,   7,   0, 0, 0,   0,   0,   28, 0,   0,   0,   40,  0,   0,
    0,   51,  0,   0, 0, 62,  0,   0,   0,  73,  0,   0,   0,   1,   1,
    0,   176, 0,   4, 2, 0,   176, 176, 0,  255, 1,   6,   0,   176, 0,
    176, 176, 176, 0, 0, 255, 1,   6,   0,  176, 176, 176, 0,   176, 0,
    0,   255, 1,   6, 0, 176, 176, 0,   0,  176, 0,   0,   255, 2,   2,
    0,   0,   0,   0, 6, 1,   0,   0,   0,  255,
};

// end of letters A-Z
