/* textstoragefile.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: textstoragefile.h,v 1.1 2005/05/19 19:53:42 ralf Exp $ */

#ifndef TEXTSTORAGEFILE_H
#define TEXTSTORAGEFILE_H

#include <aguix/textstorage.h>

class TextStorageFile : public TextStorage
{
 public:
  TextStorageFile( std::string filename );
  int getNrOfLines() const;
  int getLine( int line_nr, unsigned int offset, int len, std::string &return_line ) const;
  int getLine( int line_nr, unsigned int offset, std::string &return_line ) const;
  int getMaxLineLen() const;
  int getLineLen( int line_nr ) const;
  void setLineLimit( int new_limit );
 private:
  TextStorageString tss;
};

#endif
