/* dirsortsettings.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2007 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "dirsortsettings.hh"
#include "verzeichnis.hh"

DirSortSettings::DirSortSettings() : _serial_nr( 0 ),
                                     _sort_mode( SORT_NAME )
{
}

DirSortSettings::~DirSortSettings()
{
}
    
bool DirSortSettings::check( Verzeichnis &v )
{
    v.sort( _sort_mode );
    return true;
}

void DirSortSettings::setSortMode( int sort_mode )
{
    _sort_mode = sort_mode;
    _serial_nr++;
}

int DirSortSettings::getSortMode() const
{
    return _sort_mode;
}

int DirSortSettings::getSerialNr() const
{
    return _serial_nr;
}
