/* createsymlinkop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/* $Id: createsymlinkop.cc,v 1.28 2005/10/19 18:06:38 ralf Exp $ */

#include "createsymlinkop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

const char *CreateSymlinkOp::name="CreateSymlinkOp";

CreateSymlinkOp::CreateSymlinkOp() : FunctionProto()
{
  same_dir=false;
  local=false;
  requestflags=false;
  hasConfigure = true;
}

CreateSymlinkOp::~CreateSymlinkOp()
{
}

CreateSymlinkOp*
CreateSymlinkOp::duplicate() const
{
  CreateSymlinkOp *ta=new CreateSymlinkOp();
  ta->same_dir=same_dir;
  ta->local=local;
  ta->requestflags=requestflags;
  return ta;
}

bool
CreateSymlinkOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
CreateSymlinkOp::getName()
{
  return name;
}

int
CreateSymlinkOp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      endlister = msg->getWorker()->getOtherLister(startlister);
      lm1=startlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodecreatesl( msg );
    }
  } else normalmodecreatesl( msg );
  return 0;
}

bool
CreateSymlinkOp::save(Datei *fh)
{
  if ( fh == NULL ) return false;
  fh->configPutPairBool( "samedir", same_dir );
  fh->configPutPairBool( "relative", local );
  fh->configPutPairBool( "requestflags", requestflags );
  return true;
}

const char *
CreateSymlinkOp::getDescription()
{
  return catalog.getLocaleCom(36);
}

int
CreateSymlinkOp::normalmodecreatesl( ActionMessage *am )
{
  NormalMode *nm1=NULL,
             *nm2=NULL;
  ListerMode *lm1=NULL;
  NM_specialsourceExt *specialsource=NULL;
  bool cont=true;
  char *dest=NULL;
  struct NM_createsymlinkorder cslorder;
  bool takesamedir;
  
  if(am->mode==am->AM_MODE_DNDACTION) {
    lm1 = am->dndmsg->getSourceMode();
    if(lm1==NULL) return 1;
    if(lm1->isType("NormalMode")!=true) return 1;
    nm1=(NormalMode*)lm1;
    lm1 = am->dndmsg->getDestMode();
    if(lm1!=NULL)
      if(lm1->isType("NormalMode")==true)
        nm2=(NormalMode*)lm1;
  } else {
    if(startlister==NULL) return 1;
    lm1=startlister->getActiveMode();
    if(lm1==NULL) return 1;
    if(lm1->isType("NormalMode")!=true) return 1;
    nm1=(NormalMode*)lm1;
    if(endlister!=NULL) {
      lm1=endlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          nm2=(NormalMode*)lm1;
    }
  }

  if(requestflags==true) {
    if(doconfigure(1)!=0) cont=false;
  } else {
    // set values in t* variables
    tsame_dir=same_dir;
    tlocal=local;
  }
  
  if(cont==true) {
    memset( &cslorder, 0, sizeof( cslorder ) );
    // detect what to copy
    if(am->mode==am->AM_MODE_ONLYACTIVE)
      cslorder.source=cslorder.NM_ONLYACTIVE;
    else if(am->mode==am->AM_MODE_DNDACTION) {
      // insert DND-element into list
      cslorder.source=cslorder.NM_SPECIAL;
      cslorder.sources=new std::list<NM_specialsourceExt*>;
      specialsource = new NM_specialsourceExt( am->dndmsg->getFE() );
      cslorder.sources->push_back(specialsource);
    } else if(am->mode==am->AM_MODE_SPECIAL) {
      cslorder.source=cslorder.NM_SPECIAL;
      cslorder.sources=new std::list<NM_specialsourceExt*>;
      specialsource = new NM_specialsourceExt( am->getFE() );
      cslorder.sources->push_back(specialsource);
    } else
      cslorder.source=cslorder.NM_ALLENTRIES;

    takesamedir=true;
    if(am->mode==am->AM_MODE_DNDACTION) {
      const char *ddstr = am->dndmsg->getDestDir();
      if(ddstr!=NULL) dest=dupstring(ddstr);
      else dest=NULL;
      takesamedir=false;
    } else if(tsame_dir==false) {
      if(nm2!=NULL) {
        const char *tstr = nm2->getCurrentDir();
        if(tstr!=NULL) {
          dest=dupstring(tstr);
          takesamedir=false;
        }
      }
    }

    if(takesamedir==true) {
      const char *tstr = nm1->getCurrentDir();
      if(tstr!=NULL)
        dest=dupstring(tstr);
    }
    
    if(dest!=NULL) {
      cslorder.local=tlocal;
      cslorder.destdir=dest;
      // now start copy process
      nm1->createsymlink(&cslorder);
    }
    if(dest!=NULL) _freesafe(dest);
    if(cslorder.source==cslorder.NM_SPECIAL) {
      if ( specialsource != NULL ) delete specialsource;
      delete cslorder.sources;
    }
  }
  return 0;
}

int
CreateSymlinkOp::configure()
{
  return doconfigure(0);
}

int
CreateSymlinkOp::doconfigure(int mode)
{
  AGUIX *aguix = Worker::getAGUIX();
  AWindow *win;
  ChooseButton *sdcb,*gcb,*rfcb=NULL;
  AGMessage *msg;
  int endmode=-1;
  char *tstr;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;

  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(36))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(36));
  win = new AWindow( aguix, 10, 10, 10, 10, 0, tstr );
  win->create();
  _freesafe(tstr);

  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 5 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  ac1->add( new Text( aguix, 0, 0, catalog.getLocaleCom( 36 ), 1 ), 0, 0, cincwnr );

  sdcb = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, 20, 20, ( same_dir == true ) ? 1 : 0,
						    catalog.getLocale( 315 ), LABEL_RIGHT, 1, 0 ), 0, 1, cincwnr );

  gcb = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, 20, 20, ( local == true ) ? 1 : 0,
						   catalog.getLocale( 533 ), LABEL_RIGHT, 1, 0 ), 0, 2, cincwnr );

  if(mode==0) {
    rfcb = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, 20, 20, ( requestflags == true ) ? 1 : 0,
						      catalog.getLocale( 294 ), LABEL_RIGHT, 1, 0 ), 0, 3, cincwnr );
  }

  AContainer *ac1_1 = ac1->add( new AContainer( win, 2, 1 ), 0, 4 );
  ac1_1->setMinSpace( 5 );
  ac1_1->setMaxSpace( -1 );
  ac1_1->setBorderWidth( 0 );
  Button *okb =(Button*)ac1_1->add( new Button( aguix,
                                                0,
                                                0,
                                                catalog.getLocale( 11 ),
                                                1,
                                                0,
                                                0 ), 0, 0, cfix );
  Button *cb = (Button*)ac1_1->add( new Button( aguix,
						0,
						0,
						catalog.getLocale( 8 ),
						1,
						0,
						0 ), 1, 0, cfix );
  
  okb->takeFocus();
  win->setDoTabCycling( true );
  win->contMaximize( true );
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) endmode=0;
          else if(msg->button.button==cb) endmode=1;
          break;
        case AG_KEYPRESSED:
          if(win->isParent(msg->key.window,false)==true) {
            switch(msg->key.key) {
              case XK_1:
                sdcb->setState((sdcb->getState() == true ) ? false : true );
                break;
              case XK_2:
                gcb->setState((gcb->getState() == true ) ? false : true );
                break;
              case XK_Return:
                if ( cb->getHasFocus() == false ) {
                  endmode=0;
                }
                break;
              case XK_Escape:
                endmode=1;
                break;
            }
          }
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    if(mode==1) {
      tsame_dir = sdcb->getState();
      tlocal = gcb->getState();
    } else {
      same_dir = sdcb->getState();
      local = gcb->getState();
      requestflags = rfcb->getState();
    }
  }
  
  delete win;

  return endmode;
}

void CreateSymlinkOp::setSameDir(bool nv)
{
  same_dir=nv;
}

void CreateSymlinkOp::setLocal(bool nv)
{
  local=nv;
}

void CreateSymlinkOp::setRequestFlags(bool nv)
{
  requestflags=nv;
}

