/* nwc_path.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2009 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "nwc_os.hh"
#include "datei.h"
#include <aguix/lowlevelfunc.h>

namespace NWC {
    namespace OS {
        std::string getCWD()
        {
            char *buf = NULL;
            int size = 1024;
            std::string s;

            for(;;) {
                buf = (char*)_allocsafe( size );
                if ( getcwd( buf, size ) != NULL ) break;
                else if ( errno != ERANGE ) {
                    strcpy( buf, "/" );  // use the root in case of error
                    break;
                }
                _freesafe( buf );
                size *= 2;
            }
            if ( buf == NULL || buf[0] != '/' ) {
                // no result or no absolute path
                // according to man page it should return absolute paths
                // but it does happen that there will be only a relative path
                // (like for stale nfs home directories)
                s = "/";
            } else {
                s = buf;
            }
            if ( buf != NULL ) _freesafe( buf );
            return s;
        }
    }
}
