/* message.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: message.cc,v 1.6 2003/11/06 21:38:43 ralf Exp $ */

#include "message.h"
#include "lowlevelfunc.h"
#include "fieldlvrowdata.h"

Message *AGUIX_allocMessage()
{
  Message *msg;

  msg = (Message*)_allocsafe( sizeof( Message ) );
  memset( msg, 0, sizeof( Message ) );
  msg->specialType = Message::NONE;
  msg->lockElement = NULL;
  msg->ack = false;
  msg->loop = 0;
  msg->keybuf = NULL;
  return msg;
}

void AGUIX_freeMessage( Message *msg )
{
  if ( msg != NULL ) {
    if ( msg->keybuf != NULL ) _freesafe( msg->keybuf );
    _freesafe( msg );
  }
}

AGMessage *AGUIX_allocAGMessage()
{
  AGMessage *agmsg;

  agmsg = (AGMessage*)_allocsafe( sizeof( AGMessage ) );
  agmsg->type = AG_NONE;
  agmsg->key.keybuf = NULL;
  return agmsg;
}

void AGUIX_freeAGMessage( AGMessage *agmsg )
{
  if ( agmsg != NULL ) {
    if ( ( agmsg->type == AG_KEYPRESSED ) || ( agmsg->type == AG_KEYRELEASED ) ) {
      if ( agmsg->key.keybuf != NULL ) _freesafe( agmsg->key.keybuf );
    }
    if ( ( agmsg->type == AG_DND_START ) ||
	 ( agmsg->type == AG_DND_END ) ||
	 ( agmsg->type == AG_DND_CANCEL ) ){
      if ( agmsg->dnd.specialinfo.rowDataP != NULL )
	delete (agmsg->dnd.specialinfo.rowDataP);
    }
    _freesafe( agmsg );
  }
}
