/* cursorops.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: cursorops.h,v 1.8 2003/05/04 00:46:00 ralf Exp $ */

#ifndef CURSOROPS_H
#define CURSOROPS_H

#include "wdefines.h"
#include "functionproto.h"
class Worker;

class RowUp:public FunctionProto
{
public:
  RowUp();
  virtual ~RowUp();
  virtual RowUp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class RowDown:public FunctionProto
{
public:
  RowDown();
  virtual ~RowDown();
  virtual RowDown *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class FirstRow:public FunctionProto
{
public:
  FirstRow();
  virtual ~FirstRow();
  virtual FirstRow *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class LastRow:public FunctionProto
{
public:
  LastRow();
  virtual ~LastRow();
  virtual LastRow *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class PageUp:public FunctionProto
{
public:
  PageUp();
  virtual ~PageUp();
  virtual PageUp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class PageDown:public FunctionProto
{
public:
  PageDown();
  virtual ~PageDown();
  virtual PageDown *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class SelectOp:public FunctionProto
{
public:
  SelectOp();
  virtual ~SelectOp();
  virtual SelectOp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class SelectAllOp:public FunctionProto
{
public:
  SelectAllOp();
  virtual ~SelectAllOp();
  virtual SelectAllOp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class SelectNoneOp:public FunctionProto
{
public:
  SelectNoneOp();
  virtual ~SelectNoneOp();
  virtual SelectNoneOp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class InvertAllOp:public FunctionProto
{
public:
  InvertAllOp();
  virtual ~InvertAllOp();
  virtual InvertAllOp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class ParentDirOp:public FunctionProto
{
public:
  ParentDirOp();
  virtual ~ParentDirOp();
  virtual ParentDirOp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
};

class EnterDirOp:public FunctionProto
{
public:
  EnterDirOp();
  virtual ~EnterDirOp();
  virtual EnterDirOp *duplicate() const;
  virtual int configure();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run( WPUContext *, ActionMessage* );
  virtual const char *getDescription();
  virtual bool save(Datei *);

  typedef enum {ENTERDIROP_ACTIVE=0,
                ENTERDIROP_ACTIVE2OTHER,
                ENTERDIROP_SPECIAL,
                ENTERDIROP_REQUEST} enterdir_t;
  void setMode(enterdir_t);
  void setDir(const char*);
protected:
  static const char *name;
  // Infos to save
  enterdir_t enterdirmode;
  char *dir;
};

#endif

