/* pdatei.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2002 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: pdatei.h,v 1.3 2002/07/09 16:26:32 ralf Exp $ */

#ifndef PDATEI_H
#define PDATEI_H

#include "wdefines.h"

#ifdef HAVE_LIBXPKMASTER
extern "C" {
#include <xpk/xpk.h>
#include <xpk/amigalibs.h>
}
#endif

class PDatei
{
 public:
  PDatei();
  ~PDatei();
  enum pdatei_handler { PDATEI_UNKNOWN, PDATEI_NORMAL, PDATEI_GZIP, PDATEI_BZIP2, PDATEI_XPK };
  int open( const char *filename );
  int read( void *buf, int size );
  void close();
  static enum pdatei_handler getCruncher( const char *filename );
  enum pdatei_handler getHandler();
 protected:
  enum pdatei_handler type;
  char *name;

#ifdef HAVE_LIBZ
  gzFile gzfp;
#endif

  FILE *fp;

#ifdef HAVE_LIBBZ2
  BZFILE *bzfp;
#endif

#ifdef HAVE_LIBXPKMASTER
  struct XpkFib *xpkfp;
  char *xpkbuf;
#endif
  
  char *readbuf;
  int readbuf_size, readbuf_used, readbuf_start;
  bool fileend;
};

#endif
