/* setsortmodeop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: setsortmodeop.cc,v 1.11 2003/07/03 20:26:23 ralf Exp $ */

#include "setsortmodeop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

/*****************
 SetSortmodeOp
******************/

const char *SetSortmodeOp::name="SetSortmodeOp";

SetSortmodeOp::SetSortmodeOp() : FunctionProto()
{
  mode=SORT_NAME;
  hasConfigure = true;
}

SetSortmodeOp::~SetSortmodeOp()
{
}

SetSortmodeOp *SetSortmodeOp::duplicate() const
{
  SetSortmodeOp *ta=new SetSortmodeOp();
  ta->mode=mode;
  return ta;
}

bool SetSortmodeOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *SetSortmodeOp::getName()
{
  return name;
}

int SetSortmodeOp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  NormalMode *nm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->setSortmode(mode);
        }
      }
    }
  }
  return 0;
}

bool SetSortmodeOp::save(Datei *fh)
{
  if ( fh == NULL ) return false;
  switch ( mode & 0xff ) {
    case SORT_SIZE:
      WConfig::configPutPair( fh, "sortby", "size" );
      break;
    case SORT_ACCTIME:
      WConfig::configPutPair( fh, "sortby", "acctime" );
      break;
    case SORT_MODTIME:
      WConfig::configPutPair( fh, "sortby", "modtime" );
      break;
    case SORT_CHGTIME:
      WConfig::configPutPair( fh, "sortby", "chgtime" );
      break;
    case SORT_TYPE:
      WConfig::configPutPair( fh, "sortby", "type" );
      break;
    case SORT_OWNER:
      WConfig::configPutPair( fh, "sortby", "owner" );
      break;
    case SORT_INODE:
      WConfig::configPutPair( fh, "sortby", "inode" );
      break;
    case SORT_NLINK:
      WConfig::configPutPair( fh, "sortby", "nlink" );
      break;
    default:
      WConfig::configPutPair( fh, "sortby", "name" );
      break;
  }
  if ( ( mode & SORT_REVERSE ) != 0 ) WConfig::configPutPair( fh, "sortflag", "reverse" );
  if ( ( mode & SORT_DIRLAST ) != 0 ) WConfig::configPutPair( fh, "sortflag", "dirlast" );
  else if ( ( mode & SORT_DIRMIXED ) != 0 ) WConfig::configPutPair( fh, "sortflag", "dirmixed" );
  return true;
}

const char *SetSortmodeOp::getDescription()
{
  return catalog.getLocaleCom(40);
}

int SetSortmodeOp::configure()
{
  AGUIX *aguix = Worker::getAGUIX();
  Button *okb,*cb;
  AWindow *win;
  CycleButton *cyb[2];
  ChooseButton *chb;
  Text *ttext;
  int tw,ttw,tth,ttx,tty,t1,t2;
  AGMessage *msg;
  int endmode=-1;
  char *tstr;
  
  ttw=tth=10;
  ttx=tty=5;
  win=new AWindow(aguix);

  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(getName())+1);
  sprintf(tstr,catalog.getLocale(293),getName());
  win->create(NULL,10,10,ttw,tth,0,tstr);
  _freesafe(tstr);

  ttext=(Text*)win->add(new Text(aguix,ttx,tty,catalog.getLocale(158),1));
  ttx+=ttext->getWidth()+5;
  cyb[0]=(CycleButton*)win->add(new CycleButton(aguix,ttx,tty,100,1,0,0));
  cyb[0]->addOption(catalog.getLocale(160));
  cyb[0]->addOption(catalog.getLocale(161));
  cyb[0]->addOption(catalog.getLocale(162));
  cyb[0]->addOption(catalog.getLocale(163));
  cyb[0]->addOption(catalog.getLocale(164));
  cyb[0]->addOption(catalog.getLocale( 432 ));
  cyb[0]->addOption(catalog.getLocale( 433 ));
  cyb[0]->addOption(catalog.getLocale( 552 ));
  cyb[0]->addOption(catalog.getLocale( 553 ));
  cyb[0]->resize(cyb[0]->getMaxSize(),cyb[0]->getHeight());
  if((mode&0xff)==SORT_SIZE) cyb[0]->setOption(1);
  else if((mode&0xff)==SORT_ACCTIME) cyb[0]->setOption(2);
  else if((mode&0xff)==SORT_MODTIME) cyb[0]->setOption(3);
  else if((mode&0xff)==SORT_CHGTIME) cyb[0]->setOption(4);
  else if((mode&0xff)==SORT_TYPE) cyb[0]->setOption(5);
  else if((mode&0xff)==SORT_OWNER) cyb[0]->setOption(6);
  else if ( ( mode & 0xff ) == SORT_INODE ) cyb[0]->setOption( 7 );
  else if ( ( mode & 0xff ) == SORT_NLINK ) cyb[0]->setOption( 8 );
  else cyb[0]->setOption(0);

  tty+=cyb[0]->getHeight()+5;
  tw=ttx+cyb[0]->getWidth()+5;
  if(tw>ttw) ttw=tw;
  ttx=5;

  chb=(ChooseButton*)win->add(new ChooseButton(aguix,ttx,tty,20,20,
                                              ((mode&SORT_REVERSE)==SORT_REVERSE)?1:0,
                                              catalog.getLocale(165),LABEL_RIGHT,1,0));
  tty+=chb->getHeight()+5;

  ttext=(Text*)win->add(new Text(aguix,ttx,tty,catalog.getLocale(353),1));
  ttx+=ttext->getWidth()+5;
  cyb[1]=(CycleButton*)win->add(new CycleButton(aguix,ttx,tty,100,1,0,0));
  cyb[1]->addOption(catalog.getLocale(354));
  cyb[1]->addOption(catalog.getLocale(355));
  cyb[1]->addOption(catalog.getLocale(356));
  cyb[1]->resize(cyb[1]->getMaxSize(),cyb[1]->getHeight());
  if((mode&SORT_DIRLAST)==SORT_DIRLAST) cyb[1]->setOption(1);
  else if((mode&SORT_DIRMIXED)==SORT_DIRMIXED) cyb[1]->setOption(2);
  else cyb[1]->setOption(0);

  tty+=cyb[1]->getHeight()+5;
  tw=ttx+cyb[1]->getWidth()+5;
  if(tw>ttw) ttw=tw;
  ttx=5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>ttw) ttw=tw;
  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   tty,
                                   t1,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  ttw-5-t2,
                                  tty,
                                  t2,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  tty+=okb->getHeight()+5;
  
  tth=tty;
  
  win->setDoTabCycling( true );
  win->resize(ttw,tth);
  win->setMaxSize(ttw,tth);
  win->setMinSize(ttw,tth);
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) endmode=0;
          else if(msg->button.button==cb) endmode=1;
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    int tsortmode=0;
    switch(cyb[0]->getSelectedOption()) {
      case 1:
        tsortmode=SORT_SIZE;
        break;
      case 2:
        tsortmode=SORT_ACCTIME;
        break;
      case 3:
        tsortmode=SORT_MODTIME;
        break;
      case 4:
        tsortmode=SORT_CHGTIME;
        break;
      case 5:
        tsortmode=SORT_TYPE;
        break;
      case 6:
        tsortmode=SORT_OWNER;
        break;
      case 7:
        tsortmode=SORT_INODE;
        break;
      case 8:
        tsortmode=SORT_NLINK;
        break;
      default:
        tsortmode=SORT_NAME;
        break;
    }
    if(chb->getState()==1) tsortmode|=SORT_REVERSE;
    switch(cyb[1]->getSelectedOption()) {
      case 1:
        tsortmode|=SORT_DIRLAST;
        break;
      case 2:
        tsortmode|=SORT_DIRMIXED;
        break;
      default:
        break;
    }
    mode=tsortmode;
  }
  win->close();
  delete win;

  return endmode;
}

void SetSortmodeOp::setMode( int nv )
{
  if ( ISVALID_SORTMODE( nv ) ) mode = nv & ( 0xff | SORT_REVERSE | SORT_DIRLAST | SORT_DIRMIXED );
  else mode = SORT_NAME;
}

int SetSortmodeOp::getMode() const
{
  return mode;
}

void SetSortmodeOp::setSortby( int m )
{
  int usem;
  
  if ( ISVALID_SORTMODE( m ) ) usem = m & 0xff;
  else usem = SORT_NAME;
  
  mode = usem | ( mode & ( ~ 0xff ) );
}

void SetSortmodeOp::setSortFlag( int f )
{
  if ( ( f & SORT_REVERSE ) != 0 ) mode |= SORT_REVERSE;
  if ( ( f & SORT_DIRLAST ) != 0 ) {
    mode |= SORT_DIRLAST;
    mode &= ~SORT_DIRMIXED;
  } else if ( ( f & SORT_DIRMIXED ) != 0 ) {
    mode |= SORT_DIRMIXED;
    mode &= ~SORT_DIRLAST;
  }
}

/**********************
 Ende SetSortmodeOp
***********************/

