/* wconfig.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: wconfig.cc,v 1.110 2004/03/10 22:35:13 ralf Exp $ */

#include "wconfig.h"
#include "worker.h"
#include "filereq.h"
#include "fontreq.h"
#include <string>
#include "pdatei.h"
#include "configheader.h"
#include <aguix/acontainer.h>
#include <aguix/acontainerbb.h>

#define DEFAULT_TIME_STRING "%H:%M:%S"
#define DEFAULT_DATE_STRING "%d %b %Y"

const char * predefined_dates[] = { "%d %b %Y",
                                    "%m/%d/%y",
                                    "%d.%m.%Y" };
const char * predefined_times[] = { "%H:%M:%S",
                                    "%H:%M" };

WConfig *wconfig;
WConfig *lconfig;

int WConfig::sectiondepth = 0;

bool WConfig::configure()
{
  AGUIX *aguix=worker->getAGUIX();
  WConfig *config_bak=duplicate();
  int w,h,ty,i;
  Button *buts[20];
  bool changed = false;

  w = h = 10;
  AWindow *cwin=new AWindow(aguix);
  cwin->create(NULL,10,10,w,h,0,catalog.getLocale(0));
  ty=5;
  buts[0]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(1),1,0,1));
  int dh=buts[0]->getHeight()+2;
  ty+=dh;
  buts[1]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(2),1,0,2));
  ty+=dh;
  buts[2]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(3),1,0,3));
  ty+=dh;
  buts[3]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(4),1,0,4));
  ty+=dh;
  buts[4]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(5),1,0,5));
  ty+=dh;
  buts[5]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(6),1,0,6));
  ty+=dh;
  buts[6]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(91),1,0,7));
  ty+=dh;
  buts[7]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(209),1,0,8));
  ty+=dh;
  buts[8]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(368),1,0,13));
  ty+=dh;
  buts[9] = (Button*)cwin->add( new Button( aguix, 5, ty, catalog.getLocale(396),1,0,14));
  ty+=dh+5;
//  b1=(Button*)cwin->add(new Button(aguix,5,ty,w-10,catalog.getLocale(231),1,0,9));
//  ty+=dh;
  buts[10]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(7),1,0,10));
  ty+=dh;
//  b1=(Button*)cwin->add(new Button(aguix,5,ty,w-10,catalog.getLocale(232),1,0,11));
//  ty+=dh;
  buts[11]=(Button*)cwin->add(new Button(aguix,5,ty,catalog.getLocale(8),1,0,12));
  ty+=dh;
  Text *ttext=(Text*)cwin->add(new Text(aguix,5,ty,"Worker Configuration",1));
  ty+=ttext->getHeight()+5;
  cwin->add(new Text(aguix,5,ty,"Copyright by Ralf Hoffmann",1));
  ty+=ttext->getHeight()+5;
  h=ty;
  cwin->setDoTabCycling( true );
  cwin->resize(w,h);
  cwin->maximizeX();
  w = cwin->getWidth();
  cwin->setMaxSize(w,h);
  cwin->setMinSize(w,h);
  
  for ( i = 0; i < 12; i++ )
    buts[i]->resize( w - 10, buts[i]->getHeight() );
  
  cwin->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(cwin);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==cwin->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if ( msg->button.button == buts[0] ) {
          cwin->hide();
          if ( changeGlobal() == true ) changed = true;
          cwin->show();
        } else if ( msg->button.button == buts[1] ) {
          cwin->hide();
          if ( changeColorDefs() == true ) changed = true;
          cwin->show();
        } else if ( msg->button.button == buts[2] ) {
          cwin->hide();
          if ( changeStartup() == true ) changed = true;
          cwin->show();
        } else if ( msg->button.button == buts[3] ) {
          cwin->hide();
          if ( changeButtons() == true ) changed = true;
          cwin->show();
        } else if ( msg->button.button == buts[4] ) {
          cwin->hide();
          if ( changePaths() == true ) changed = true;
          cwin->show();
        } else if ( msg->button.button == buts[5] ) {
          cwin->hide();
          if ( changeTypes() == true ) changed = true;
          cwin->show();
        } else if ( msg->button.button == buts[6] ) {
          cwin->hide();
          if ( changeHotkeys() == true ) changed = true;
          cwin->show();
        } else if ( msg->button.button == buts[7] ) {
          cwin->hide();
          if ( changeFont() == true ) changed = true;
          cwin->show();
        } else if ( msg->button.button == buts[8] ) {
          cwin->hide();
          if ( changeClockbarSets() == true ) changed = true;
          cwin->show();
        } else if ( msg->button.button == buts[9] ) {
          cwin->hide();
          if ( im_export() == 1 ) changed = true;
          cwin->show();
        } else if ( msg->button.button == buts[10] ) {
          save();
          ende=1;
        } else if ( msg->button.button == buts[11] ) {
          ende=-1;
        }
      }
      aguix->ReplyMessage(msg);
    }
    if ( ( ende == -1 ) && ( changed == true ) ) {
      // cancel but changed config, ask to continue
      std::string str1;
      
      str1 = catalog.getLocale( 11 );
      str1 += "|";
      str1 += catalog.getLocale( 8 );
      i = Worker::getRequester()->request( catalog.getLocale( 123 ),
                                           catalog.getLocale( 538 ),
                                           str1.c_str(),
                                           cwin,
                                           Requester::REQUEST_NONE );
      if ( i == 1 ) {
        ende = 0;
      }
    }
  }
  cwin->close();
  delete cwin;
  if(ende==-1) {
    setLang(config_bak->getLang());
    setTerminalBin(config_bak->getTerminalBin());
    setRows(config_bak->getRows());
    setColumns(config_bak->getColumns());
    setCacheSize(config_bak->getCacheSize());
    for(i=0;i<2;i++) {
      setHBarTop(i,config_bak->getHBarTop(i));
      setVBarLeft(i,config_bak->getVBarLeft(i));
      setHBarHeight(i,config_bak->getHBarHeight(i));
      setVBarWidth(i,config_bak->getVBarWidth(i));
      setVisCols( i, config_bak->getVisCols( i ) );
      setShowHeader( i, config_bak->getShowHeader( i ) );
      setStatusbar(i,config_bak->getStatusbar(i));
      setSelLVB(i,config_bak->getSelLVB(i));
      setUnselLVB(i,config_bak->getUnselLVB(i));
      setSelDir(i,config_bak->getSelDir(i));
      setUnselDir(i,config_bak->getUnselDir(i));
      setSelFile(i,config_bak->getSelFile(i));
      setUnselFile(i,config_bak->getUnselFile(i));
      setSelDirAct(i,config_bak->getSelDirAct(i));
      setUnselDirAct(i,config_bak->getUnselDirAct(i));
      setSelFileAct(i,config_bak->getSelFileAct(i));
      setUnselFileAct(i,config_bak->getUnselFileAct(i));
      setClockbar(i,config_bak->getClockbar(i));
      setRequest(i,config_bak->getRequest(i));
      setLVHeader( i, config_bak->getLVHeader( i ) );
      setStartDir(i,config_bak->getStartDir(i));
    }
    for(i=0;i<4;i++) setFont(i,config_bak->getFont(i));
    setPaths(config_bak->getPaths());
    setFiletypes(config_bak->getFiletypes());
    setHotkeys(config_bak->getHotkeys());
    setButtons(config_bak->getButtons());
    setColors(config_bak->getColors());
    setOwnerstringtype(config_bak->getOwnerstringtype());
    applyColorList(getColors());
    setClockbarMode(config_bak->getClockbarMode());
    setClockbarUpdatetime(config_bak->getClockbarUpdatetime());
    setClockbarCommand(config_bak->getClockbarCommand());
    setDontCheckDirs(config_bak->getDontCheckDirs());
    setListerBG(config_bak->getListerBG());
    setShowStringForDirSize(config_bak->getShowStringForDirSize());
    setStringForDirSize(config_bak->getStringForDirSize());
    setLayoutOrders( config_bak->getLayoutOrders() );
    setLayoutButtonVert( config_bak->getLayoutButtonVert() );
    setLayoutListviewVert( config_bak->getLayoutListviewVert() );
  }
  delete config_bak;
  initFixTypes();
  if(ende==1) {
    applyLanguage();
  }
  return (ende==1)?true:false;
}

bool WConfig::changeTypes()
{
  return changeTypes( false );
}

bool WConfig::changeTypes( bool onlyFiletypes )
{
  return changeTypes( onlyFiletypes, false );
}

#define RESCALE_CHANGETYPES( w, h ) { \
  AGUIX::scaleElementsW( w, 5, 10, -1, false, false, (GUIElement**)b2, NULL, 2 ); \
  AGUIX::scaleElementsW( w, 5, 0, 0, true, true, (GUIElement**)b, minw, 4 ); \
  if ( dcdb != NULL ) \
    AGUIX::scaleElementsW( w, 5, 0, 0, true, true, (GUIElement**)&dcdb, NULL, 1 ); \
   \
  for ( i = 0; i < 2; i++ ) { \
    b2[i]->move( b2[i]->getX(), h - 5 - b2[i]->getHeight() ); \
  } \
  ty = b2[0]->getY(); \
  if ( dcdb != NULL ) { \
    dcdb->move( dcdb->getX(), ty - 5 - dcdb->getHeight() ); \
    ty = dcdb->getY(); \
  } \
  for ( i = 0; i < 4; i++ ) { \
    b[i]->move( b[i]->getX(), ty - 5 - b[i]->getHeight() ); \
  } \
  ty = b[0]->getY(); \
  lv->resize( w - 10, ty - 5 - lv->getY() ); \
}

/*
 * configures the filetypes
 *
 * args:
 *   bool onlyFiletypes
 *     when true only allow configure of the filetypes
 *     not any other option (currently the "dontcheck"-dirs)
 *   bool allowRemoveUnique
 *     when true allow to remove the unique types (dir, notyet,...)
 *     mainly used for export
 *
 * returnvalues:
 *   bool:  true when okay was choosen
 *          false otherwise
 */
bool WConfig::changeTypes( bool onlyFiletypes, bool allowRemoveUnique )
{
  WConfig *twconfig=duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1, i;
  Button *dcdb, *b2[2], *b[4];
  int minw[4];
  int row, id;
  WCFiletype *f1;

  w=100;
  h=50;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(6));
  t1=(strlen(catalog.getLocale(85))+2);
  t1*=aguix->getCharWidth();
  w=t1;
  t1=(strlen(catalog.getLocale(86))+2);
  t1*=aguix->getCharWidth();
  w+=t1;
  t1=(strlen(catalog.getLocale(87))+2);
  t1*=aguix->getCharWidth();
  w+=t1;
  t1=(strlen(catalog.getLocale(88))+2);
  t1*=aguix->getCharWidth();
  w+=t1;
  w+=10;
  
  ty=5;
  FieldListView *lv = (FieldListView*)win->add(new FieldListView(aguix,5,ty,w-10,150,0));
  lv->setHBarState(2);
  lv->setVBarState(2);
  lv->setAcceptFocus( true );
  lv->setDisplayFocus( true );
  ty+=lv->getHeight()+5;
  t1=(strlen(catalog.getLocale(85))+2);
  t1*=aguix->getCharWidth();
  Button *newb=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(85),1,0,0));
  t1=(strlen(catalog.getLocale(86))+2);
  t1*=aguix->getCharWidth();
  Button *dupb=(Button*)win->add(new Button(aguix,newb->getX()+newb->getWidth(),ty,t1,
                                            catalog.getLocale(86),1,0,0));
  t1=(strlen(catalog.getLocale(87))+2);
  t1*=aguix->getCharWidth();
  Button *delb=(Button*)win->add(new Button(aguix,dupb->getX()+dupb->getWidth(),ty,t1,
                                            catalog.getLocale(87),1,0,0));
  t1=(strlen(catalog.getLocale(88))+2);
  t1*=aguix->getCharWidth();
  Button *editb=(Button*)win->add(new Button(aguix,delb->getX()+delb->getWidth(),ty,t1,
                                            catalog.getLocale(88),1,0,0));
  ty+=newb->getHeight()+5;
  b[0] = newb;
  b[1] = dupb;
  b[2] = delb;
  b[3] = editb;
  for ( i = 0; i < 4; i++ )
    minw[i] = b[i]->getWidth();

  if ( onlyFiletypes == false ) {
    // only add this button when in normal mode
    // this way the user can't choose this button and so can't configure other things
    // then the filetypes
    dcdb=(Button*)win->add(new Button(aguix,5,ty,w-10,
                                      catalog.getLocale(144),1,0,0));
    ty+=dcdb->getHeight()+5;
  } else {
    dcdb = NULL;
  }

  b2[0] = (Button*)win->add( new Button( aguix,
                                         0,
                                         ty,
                                         catalog.getLocale( 11 ),
                                         1,
                                         0,
                                         0 ) );
  b2[1] =(Button*)win->add( new Button( aguix,
                                        0,
                                        ty,
                                        catalog.getLocale( 8 ),
                                        1,
                                        0,
                                        0 ) );
  tw = AGUIX::scaleElementsW( w, 5, 10, -1, false, false, (GUIElement**)b2, NULL, 2 );
  if ( tw > w ) w = tw;
  h=b2[0]->getY()+b2[0]->getHeight()+5;
  
  filetypes->sort( WCFiletype::sortfunction, 0 );

  id=filetypes->initEnum();
  f1=(WCFiletype*)filetypes->getFirstElement(id);
  while(f1!=NULL) {
    row = lv->addRow();
    lv->setText( row, 0, f1->getName() );
    lv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
    f1=(WCFiletype*)filetypes->getNextElement(id);
  }
  lv->redraw();
  filetypes->closeEnum(id);
  
  win->setDoTabCycling( true );
  win->resize(w,h);
  //win->setMaxSize(w,h);
  win->setMinSize(w,h);

  if ( ( changeTypesSize[0] >= w ) && ( changeTypesSize[1] >= h ) ) {
    win->resize( changeTypesSize[0], changeTypesSize[1] );
  }

  w = win->getWidth();
  h = win->getHeight();
  RESCALE_CHANGETYPES( w, h );

  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==b2[0]) ende=1;
        else if(msg->button.button==b2[1]) ende=-1;
        else if(msg->button.button==newb) {
          WCFiletype *tf1=new WCFiletype();
          win->hide();
          if(configureFiletype(tf1)==true) {
            filetypes->addElement( tf1 );
            filetypes->sort( WCFiletype::sortfunction, 0 );

            // read comment below if you don't like this method
            row = lv->addRow();
            lv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
            id = filetypes->initEnum();
            f1 = (WCFiletype*)filetypes->getFirstElement( id );
            row = 0;
            while ( f1 != NULL ) {
              lv->setText( row, 0, f1->getName() );
              
              if ( f1 == tf1 ) lv->setActiveRow( row );
              
              f1 = (WCFiletype*)filetypes->getNextElement( id );
              row ++;
            }
            filetypes->closeEnum(id);

            lv->showActive();
            lv->redraw();
          } else {
            delete tf1;
          }
          win->show();
        } else if(msg->button.button==dupb) {
          row = lv->getActiveRow();
          if ( lv->isValidRow( row ) == true ) {
            WCFiletype *tf1=(WCFiletype*)filetypes->getElementAt(row);
            if(tf1!=NULL) {
              WCFiletype *tf2=tf1->duplicate();
              tf2->setinternID(NORMALTYPE);
              filetypes->addElement(tf2);

              filetypes->sort( WCFiletype::sortfunction, 0 );

              // read comment below if you don't like this method
              row = lv->addRow();
              lv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
              id = filetypes->initEnum();
              f1 = (WCFiletype*)filetypes->getFirstElement( id );
              row = 0;
              while ( f1 != NULL ) {
                lv->setText( row, 0, f1->getName() );
                
                if ( f1 == tf2 ) lv->setActiveRow( row );
                
                f1 = (WCFiletype*)filetypes->getNextElement( id );
                row ++;
              }
              filetypes->closeEnum(id);

              lv->showActive();
              lv->redraw();
            }
          }
        } else if(msg->button.button==delb) {
          row = lv->getActiveRow();
          if ( lv->isValidRow( row ) == true ) {
            WCFiletype *tf1=(WCFiletype*)filetypes->getElementAt(row);
            if(tf1!=NULL) {
              if( ( tf1->getinternID() == NORMALTYPE ) ||
                  ( allowRemoveUnique == true ) ) {
                delete tf1;
                filetypes->removeElementAt(row);
                lv->deleteRow(row);
                lv->redraw();
              }
            }
          }
        } else if(msg->button.button==editb) {
          row = lv->getActiveRow();
          if ( lv->isValidRow( row ) == true ) {
            WCFiletype *tf1=(WCFiletype*)filetypes->getElementAt(row);
            if(tf1!=NULL) {
              win->hide();
              if(configureFiletype(tf1)==true) {
                // update lv
                // why do I use not this method:
                //   deleteRow( row )
                //   sort
                //   search for new row
                //   insertRow( newrow )
                // because same name for different type is allowed
                // and sortfunction can sort an entry to a different
                // position
                filetypes->sort( WCFiletype::sortfunction, 0 );
                id = filetypes->initEnum();
                f1 = (WCFiletype*)filetypes->getFirstElement( id );
                row = 0;
                while ( f1 != NULL ) {
                  lv->setText( row, 0, f1->getName() );
                  
                  if ( f1 == tf1 ) lv->setActiveRow( row );
                  
                  f1 = (WCFiletype*)filetypes->getNextElement( id );
                  row ++;
                }
                filetypes->closeEnum(id);
                lv->showActive();
                lv->redraw();
              }
              win->show();
            }
          }
        } else if(msg->button.button==dcdb) {
          configureDCD(dontcheckdirs);
        }
      } else if ( msg->type == AG_SIZECHANGED ) {
        RESCALE_CHANGETYPES( msg->size.neww, msg->size.newh );
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    // Wiederherstellen
    setFiletypes(twconfig->getFiletypes());
    setDontCheckDirs(twconfig->getDontCheckDirs());
  }
  changeTypesSize[0] = win->getWidth();
  changeTypesSize[1] = win->getHeight();
  win->close();
  delete win;
  delete twconfig;
  return (ende==-1)?false:true;
}

#define RESCALE_CHANGEHOTKEYS( w, h ) { \
  AGUIX::scaleElementsW( w, 5, 10, -1, false, false, (GUIElement**)b2, NULL, 2 ); \
  AGUIX::scaleElementsW( w, 5, 0, 0, true, true, (GUIElement**)b, minw, 4 ); \
   \
  for ( i = 0; i < 2; i++ ) { \
    b2[i]->move( b2[i]->getX(), h - 5 - b2[i]->getHeight() ); \
  } \
  ty = b2[0]->getY(); \
  for ( i = 0; i < 4; i++ ) { \
    b[i]->move( b[i]->getX(), ty - 5 - b[i]->getHeight() ); \
  } \
  ty = b[0]->getY(); \
  lv->resize( w - 10, ty - 5 - lv->getY() ); \
}

bool WConfig::changeHotkeys()
{
  WConfig *twconfig=duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1, i;
  Button *b2[2], *b[4];
  int minw[4];
  int row;

  w=150;
  h=50;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(91));
  t1=(strlen(catalog.getLocale(154))+2);
  t1*=aguix->getCharWidth();
  w=t1;
  t1=(strlen(catalog.getLocale(155))+2);
  t1*=aguix->getCharWidth();
  w+=t1;
  t1=(strlen(catalog.getLocale(156))+2);
  t1*=aguix->getCharWidth();
  w+=t1;
  t1=(strlen(catalog.getLocale(157))+2);
  t1*=aguix->getCharWidth();
  w+=t1;
  w+=10;
  
  ty=5;
  FieldListView *lv = (FieldListView*)win->add( new FieldListView( aguix, 5, ty, w - 10, 150, 0 ) );
  lv->setHBarState(2);
  lv->setVBarState(2);
  ty+=lv->getHeight()+5;
  t1=(strlen(catalog.getLocale(154))+2);
  t1*=aguix->getCharWidth();
  Button *newb=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(154),1,0,0));
  t1=(strlen(catalog.getLocale(155))+2);
  t1*=aguix->getCharWidth();
  Button *dupb=(Button*)win->add(new Button(aguix,newb->getX()+newb->getWidth(),ty,t1,
                                            catalog.getLocale(155),1,0,0));
  t1=(strlen(catalog.getLocale(156))+2);
  t1*=aguix->getCharWidth();
  Button *delb=(Button*)win->add(new Button(aguix,dupb->getX()+dupb->getWidth(),ty,t1,
                                            catalog.getLocale(156),1,0,0));
  t1=(strlen(catalog.getLocale(157))+2);
  t1*=aguix->getCharWidth();
  Button *editb=(Button*)win->add(new Button(aguix,delb->getX()+delb->getWidth(),ty,t1,
                                            catalog.getLocale(157),1,0,0));
  ty+=newb->getHeight()+5;
  
  b[0] = newb;
  b[1] = dupb;
  b[2] = delb;
  b[3] = editb;

  for ( i = 0; i < 4; i++ )
    minw[i] = b[i]->getWidth();

  b2[0] = (Button*)win->add( new Button( aguix,
                                         0,
                                         ty,
                                         catalog.getLocale( 11 ),
                                         1,
                                         0,
                                         0 ) );
  b2[1] = (Button*)win->add( new Button( aguix,
                                         0,
                                         ty,
                                         catalog.getLocale( 8 ),
                                         1,
                                         0,
                                         0 ) );
  tw = AGUIX::scaleElementsW( w, 5, 10, -1, false, false, (GUIElement**)b2, NULL, 2 );
  if ( tw > w ) w = tw;
  h = b2[0]->getY() + b2[0]->getHeight() + 5;
  
  int id=hotkeys->initEnum();
  WCHotkey *h1=(WCHotkey*)hotkeys->getFirstElement(id);
  while(h1!=NULL) {
    row = lv->addRow();
    lv->setText( row, 0, h1->getName() );
    lv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
    h1=(WCHotkey*)hotkeys->getNextElement(id);
  }
  lv->redraw();
  hotkeys->closeEnum(id);
  
  win->setDoTabCycling( true );
  win->resize(w,h);
  win->setMinSize(w,h);

  if ( ( changeHotkeysSize[0] >= w ) && ( changeHotkeysSize[1] >= h ) ) {
    win->resize( changeHotkeysSize[0], changeHotkeysSize[1] );
  }

  w = win->getWidth();
  h = win->getHeight();
  RESCALE_CHANGEHOTKEYS( w, h );

  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  int trow;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==b2[0]) ende=1;
        else if(msg->button.button==b2[1]) ende=-1;
        else if(msg->button.button==newb) {
          WCHotkey *th1=new WCHotkey();
          hotkeys->addElement(th1);
          trow = lv->addRow();
          lv->setText( trow, 0, th1->getName() );
          lv->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
          lv->setActiveRow( trow );
          lv->showActive();
          win->hide();
          if(configureHotkey(th1)==true) {
            lv->setText( trow, 0, th1->getName() );
            lv->redraw();
          }
          win->show();
        } else if(msg->button.button==dupb) {
          trow = lv->getActiveRow();
          if ( lv->isValidRow( trow ) == true ) {
            int pos = trow;
            WCHotkey *th1=(WCHotkey*)hotkeys->getElementAt(pos);
            if(th1!=NULL) {
              WCHotkey *th2=th1->duplicate();
              // reset shortkey to avoid duplicates
              th2->setKey( NULL );
              th2->setDoubleKeys( NULL );
              
              hotkeys->addElement(th2);
              trow = lv->addRow();
              lv->setText( trow, 0, th2->getName() );
              lv->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
              lv->setActiveRow( trow );
              lv->showActive();
              lv->redraw();
            }
          }
        } else if(msg->button.button==delb) {
          trow = lv->getActiveRow();
          if ( lv->isValidRow( trow ) == true ) {
            int pos = trow;
            WCHotkey *th1=(WCHotkey*)hotkeys->getElementAt(pos);
            if(th1!=NULL) {
              delete th1;
              hotkeys->removeElementAt(pos);
              lv->deleteRow(pos);
              lv->redraw();
            }
          }
        } else if(msg->button.button==editb) {
          trow = lv->getActiveRow();
          if ( lv->isValidRow( trow ) == true ) {
            int pos = trow;
            WCHotkey *th1=(WCHotkey*)hotkeys->getElementAt(pos);
            if(th1!=NULL) {
              win->hide();
              if(configureHotkey(th1)==true) {
                lv->setText( trow, 0, th1->getName() );
                lv->redraw();
              }
              win->show();
            }
          }
        }
      } else if ( msg->type == AG_SIZECHANGED ) {
        RESCALE_CHANGEHOTKEYS( msg->size.neww, msg->size.newh );
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    // Wiederherstellen
    setHotkeys(twconfig->getHotkeys());
    // also restore buttons and paths (for the case the user entered a shortkey from one of this
    setButtons(twconfig->getButtons());
    setPaths(twconfig->getPaths());
  }
  changeHotkeysSize[0] = win->getWidth();
  changeHotkeysSize[1] = win->getHeight();
  win->close();
  delete win;
  delete twconfig;
  return (ende==-1)?false:true;
}

bool WConfig::changeFont()
{
//  WConfig *twconfig=duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1,t2;
  int erg,i,j;
  char *tstr;
  Requester *req=new Requester(aguix);
  FontRequester *freq=new FontRequester(aguix);
  
  w=100;
  h=50;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(209));
  Text *ts[4];
  Button *bs[4];
  t1=(strlen(catalog.getLocale(241))+2);
  t1*=aguix->getCharWidth();
  bs[0]=(Button*)win->add(new Button(aguix,5,5,t1,catalog.getLocale(241),1,0,0));
  ty=bs[0]->getY()+bs[0]->getHeight()+5;
  ts[0]=(Text*)win->add(new Text(aguix,10,ty,fonts[0],1));
  ts[0]->setFont(fonts[0]);
  ty=ts[0]->getY()+ts[0]->getHeight()+5;
  t1=(strlen(catalog.getLocale(242))+2);
  t1*=aguix->getCharWidth();
  bs[1]=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(242),1,0,0));
  ty=bs[1]->getY()+bs[1]->getHeight()+5;
  ts[1]=(Text*)win->add(new Text(aguix,10,ty,fonts[1],1));
  ts[1]->setFont(fonts[1]);
  ty=ts[1]->getY()+ts[1]->getHeight()+5;
  t1=(strlen(catalog.getLocale(243))+2);
  t1*=aguix->getCharWidth();
  bs[2]=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(243),1,0,0));
  ty=bs[2]->getY()+bs[2]->getHeight()+5;
  ts[2]=(Text*)win->add(new Text(aguix,10,ty,fonts[2],1));
  ts[2]->setFont(fonts[2]);
  ty=ts[2]->getY()+ts[2]->getHeight()+5;
  t1=(strlen(catalog.getLocale(244))+2);
  t1*=aguix->getCharWidth();
  bs[3]=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(244),1,0,0));
  ty=bs[3]->getY()+bs[3]->getHeight()+5;
  ts[3]=(Text*)win->add(new Text(aguix,10,ty,fonts[3],1));
  ts[3]->setFont(fonts[3]);
  ty=ts[3]->getY()+ts[3]->getHeight()+5;

  for(i=0;i<4;i++) {
    tw=ts[i]->getX()+ts[i]->getWidth()+10;
    if(tw>w) w=tw;
    tw=bs[i]->getX()+bs[i]->getWidth()+10;
    if(tw>w) w=tw;
  }

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->setDoTabCycling( true );
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else {
          for(i=0;i<4;i++) {
            if(msg->button.button==bs[i]) {
              tstr=NULL;
              erg=freq->request(fonts[i],&tstr);
              if(erg==0) {
                if(aguix->getFont(tstr)!=NULL) {
                  ts[i]->setText(tstr);
                  ts[i]->setFont(tstr);
                  for(j=0;j<4;j++) {
                    tw=ts[j]->getX()+ts[j]->getWidth()+10;
                    if(tw>w) w=tw;
                  }
                  for(j=1;j<4;j++) {
                    bs[j]->move(bs[j]->getX(),ts[j-1]->getY()+ts[j-1]->getHeight()+5);
                    ts[j]->move(ts[j]->getX(),bs[j]->getY()+bs[j]->getHeight()+5);
                  }
                  okb->move(okb->getX(),ts[3]->getY()+ts[3]->getHeight()+5);
                  cancelb->move(w-5-cancelb->getWidth(),okb->getY());
                  h=okb->getY()+okb->getHeight()+5;
                  win->setMinSize(w,h);
                  win->setMaxSize(w,h);
                  win->resize(w,h);
                } else {
                  req->request(catalog.getLocale(124),catalog.getLocale(365),catalog.getLocale(11));
                }
                _freesafe(tstr);
              }
            }
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
/*  if(ende==-1) {
    // Wiederherstellen
    setFont(0,twconfig->getFont(0));
    setFont(1,twconfig->getFont(1));
    setFont(2,twconfig->getFont(2));
    setFont(3,twconfig->getFont(3));
  }*/
  if(ende==1) {
    setFont(0,ts[0]->getText());
    setFont(1,ts[1]->getText());
    setFont(2,ts[2]->getText());
    setFont(3,ts[3]->getText());
    req->request(catalog.getLocale(124),catalog.getLocale(234),catalog.getLocale(11));
  }
  delete req;
  delete freq;
  win->close();
  delete win;
//  delete twconfig;
  return (ende==-1)?false:true;
}

bool WConfig::changeColorDefs()
{
  WConfig *twconfig=duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ttw,ty;
  int vw, hw, t1, t2, i, j;
  int trow;
  
  vw=strlen(catalog.getLocale(32))+2;
  vw*=aguix->getCharWidth();
  hw=strlen(catalog.getLocale(33))+2;
  hw*=aguix->getCharWidth();
  w=100;
  h=100;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(2));

  tw=strlen(catalog.getLocale(31))+2;
  tw*=aguix->getCharWidth();
  SolidButton *sbsb=(SolidButton*)win->add(new SolidButton(aguix,5,5,tw,catalog.getLocale(31),
                                           statusbar[0],statusbar[1],false));
  Button *sbvb=(Button*)win->add(new Button(aguix,sbsb->getX()+sbsb->getWidth()+5,5,vw,
                                            catalog.getLocale(32),1,0,0));
  Button *sbhb=(Button*)win->add(new Button(aguix,sbvb->getX()+sbvb->getWidth()+5,5,hw,
                                            catalog.getLocale(33),1,0,0));
  tw=sbhb->getX()+sbhb->getWidth()+5;
  if(tw>w) w=tw;
  ty=sbsb->getY()+sbsb->getHeight()+5;
  BevelBox *bb1=(BevelBox*)win->add(new BevelBox(aguix,5,ty,10,2,0));
  ty=bb1->getY()+bb1->getHeight()+5;
  tw=strlen(catalog.getLocale(34))+2;
  tw*=aguix->getCharWidth();
  SolidButton *slvbsb=(SolidButton*)win->add(new SolidButton(aguix,5,ty,tw,catalog.getLocale(34),
                                           sel_lvb[0],sel_lvb[1],false));
  Button *slvbvb=(Button*)win->add(new Button(aguix,slvbsb->getX()+slvbsb->getWidth()+5,ty,vw,
                                            catalog.getLocale(32),1,0,0));
  Button *slvbhb=(Button*)win->add(new Button(aguix,slvbvb->getX()+slvbvb->getWidth()+5,ty,hw,
                                            catalog.getLocale(33),1,0,0));
  tw=slvbhb->getX()+slvbhb->getWidth()+5;
  if(tw>w) w=tw;
  ty=slvbsb->getY()+slvbsb->getHeight()+5;
  tw=strlen(catalog.getLocale(35))+2;
  tw*=aguix->getCharWidth();
  SolidButton *ulvbsb=(SolidButton*)win->add(new SolidButton(aguix,5,ty,tw,catalog.getLocale(35),
                                           unsel_lvb[0],unsel_lvb[1],false));
  Button *ulvbvb=(Button*)win->add(new Button(aguix,ulvbsb->getX()+ulvbsb->getWidth()+5,ty,vw,
                                            catalog.getLocale(32),1,0,0));
  Button *ulvbhb=(Button*)win->add(new Button(aguix,ulvbvb->getX()+ulvbvb->getWidth()+5,ty,hw,
                                            catalog.getLocale(33),1,0,0));
  tw=ulvbhb->getX()+ulvbhb->getWidth()+5;
  if(tw>w) w=tw;
  ty=ulvbsb->getY()+ulvbsb->getHeight()+5;
  BevelBox *bb2=(BevelBox*)win->add(new BevelBox(aguix,5,ty,10,2,0));
  ty=bb2->getY()+bb2->getHeight()+5;
  tw=strlen(catalog.getLocale(36))+2;
  for(i=37;i<40;i++) {
    ttw=strlen(catalog.getLocale(i))+2;
    if(ttw>tw) tw=ttw;
  }
  for(i=375;i<379;i++) {
    ttw=strlen(catalog.getLocale(i))+2;
    if(ttw>tw) tw=ttw;
  }
  tw*=aguix->getCharWidth();
  FieldListView *lv = (FieldListView*)win->add( new FieldListView( aguix, 5, ty, tw, 8 * ulvbvb->getHeight(), 0 ) );
  lv->setHBarState(0);
  lv->setVBarState(0);
  lv->setShowHeader( true );
  lv->setFieldText( 0, catalog.getLocale( 555 ) );
  lv->setHeaderFG( lvheader[0] );
  lv->setHeaderBG( lvheader[1] );
  int fg,bg;
  fg=unsel_dir[0];
  bg=unsel_dir[1];
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale( 36 ) );
  lv->setFG( trow, FieldListView::CC_NORMAL, fg );
  lv->setFG( trow, FieldListView::CC_SELECT, fg );
  lv->setFG( trow, FieldListView::CC_ACTIVE, fg );
  lv->setFG( trow, FieldListView::CC_SELACT, fg );
  lv->setBG( trow, FieldListView::CC_NORMAL, bg );
  lv->setBG( trow, FieldListView::CC_SELECT, bg );
  lv->setBG( trow, FieldListView::CC_ACTIVE, bg );
  lv->setBG( trow, FieldListView::CC_SELACT, bg );

  fg=sel_dir[0];
  bg=sel_dir[1];
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale( 37 ) );
  lv->setFG( trow, FieldListView::CC_NORMAL, fg );
  lv->setFG( trow, FieldListView::CC_SELECT, fg );
  lv->setFG( trow, FieldListView::CC_ACTIVE, fg );
  lv->setFG( trow, FieldListView::CC_SELACT, fg );
  lv->setBG( trow, FieldListView::CC_NORMAL, bg );
  lv->setBG( trow, FieldListView::CC_SELECT, bg );
  lv->setBG( trow, FieldListView::CC_ACTIVE, bg );
  lv->setBG( trow, FieldListView::CC_SELACT, bg );

  fg=unsel_file[0];
  bg=unsel_file[1];
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale( 38 ) );
  lv->setFG( trow, FieldListView::CC_NORMAL, fg );
  lv->setFG( trow, FieldListView::CC_SELECT, fg );
  lv->setFG( trow, FieldListView::CC_ACTIVE, fg );
  lv->setFG( trow, FieldListView::CC_SELACT, fg );
  lv->setBG( trow, FieldListView::CC_NORMAL, bg );
  lv->setBG( trow, FieldListView::CC_SELECT, bg );
  lv->setBG( trow, FieldListView::CC_ACTIVE, bg );
  lv->setBG( trow, FieldListView::CC_SELACT, bg );

  fg=sel_file[0];
  bg=sel_file[1];
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale( 39 ) );
  lv->setFG( trow, FieldListView::CC_NORMAL, fg );
  lv->setFG( trow, FieldListView::CC_SELECT, fg );
  lv->setFG( trow, FieldListView::CC_ACTIVE, fg );
  lv->setFG( trow, FieldListView::CC_SELACT, fg );
  lv->setBG( trow, FieldListView::CC_NORMAL, bg );
  lv->setBG( trow, FieldListView::CC_SELECT, bg );
  lv->setBG( trow, FieldListView::CC_ACTIVE, bg );
  lv->setBG( trow, FieldListView::CC_SELACT, bg );

  fg=unsel_dir_act[0];
  bg=unsel_dir_act[1];
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale( 375 ) );
  lv->setFG( trow, FieldListView::CC_NORMAL, fg );
  lv->setFG( trow, FieldListView::CC_SELECT, fg );
  lv->setFG( trow, FieldListView::CC_ACTIVE, fg );
  lv->setFG( trow, FieldListView::CC_SELACT, fg );
  lv->setBG( trow, FieldListView::CC_NORMAL, bg );
  lv->setBG( trow, FieldListView::CC_SELECT, bg );
  lv->setBG( trow, FieldListView::CC_ACTIVE, bg );
  lv->setBG( trow, FieldListView::CC_SELACT, bg );

  fg=sel_dir_act[0];
  bg=sel_dir_act[1];
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale( 376 ) );
  lv->setFG( trow, FieldListView::CC_NORMAL, fg );
  lv->setFG( trow, FieldListView::CC_SELECT, fg );
  lv->setFG( trow, FieldListView::CC_ACTIVE, fg );
  lv->setFG( trow, FieldListView::CC_SELACT, fg );
  lv->setBG( trow, FieldListView::CC_NORMAL, bg );
  lv->setBG( trow, FieldListView::CC_SELECT, bg );
  lv->setBG( trow, FieldListView::CC_ACTIVE, bg );
  lv->setBG( trow, FieldListView::CC_SELACT, bg );

  fg=unsel_file_act[0];
  bg=unsel_file_act[1];
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale( 377 ) );
  lv->setFG( trow, FieldListView::CC_NORMAL, fg );
  lv->setFG( trow, FieldListView::CC_SELECT, fg );
  lv->setFG( trow, FieldListView::CC_ACTIVE, fg );
  lv->setFG( trow, FieldListView::CC_SELACT, fg );
  lv->setBG( trow, FieldListView::CC_NORMAL, bg );
  lv->setBG( trow, FieldListView::CC_SELECT, bg );
  lv->setBG( trow, FieldListView::CC_ACTIVE, bg );
  lv->setBG( trow, FieldListView::CC_SELACT, bg );

  fg=sel_file_act[0];
  bg=sel_file_act[1];
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale( 378 ) );
  lv->setFG( trow, FieldListView::CC_NORMAL, fg );
  lv->setFG( trow, FieldListView::CC_SELECT, fg );
  lv->setFG( trow, FieldListView::CC_ACTIVE, fg );
  lv->setFG( trow, FieldListView::CC_SELACT, fg );
  lv->setBG( trow, FieldListView::CC_NORMAL, bg );
  lv->setBG( trow, FieldListView::CC_SELECT, bg );
  lv->setBG( trow, FieldListView::CC_ACTIVE, bg );
  lv->setBG( trow, FieldListView::CC_SELACT, bg );

  fg=1;
  bg=listerbg;
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale( 379 ) );
  lv->setFG( trow, FieldListView::CC_NORMAL, fg );
  lv->setFG( trow, FieldListView::CC_SELECT, fg );
  lv->setFG( trow, FieldListView::CC_ACTIVE, fg );
  lv->setFG( trow, FieldListView::CC_SELACT, fg );
  lv->setBG( trow, FieldListView::CC_NORMAL, bg );
  lv->setBG( trow, FieldListView::CC_SELECT, bg );
  lv->setBG( trow, FieldListView::CC_ACTIVE, bg );
  lv->setBG( trow, FieldListView::CC_SELACT, bg );
  
  lv->maximizeY();
  lv->redraw();

  Button *b[10][2];
  b[0][0]=(Button*)win->add(new Button(aguix,lv->getX()+lv->getWidth()+5,ty,vw,aguix->getCharHeight(),
                                       catalog.getLocale(32),1,0,0));
  b[0][1]=(Button*)win->add(new Button(aguix,b[0][0]->getX()+b[0][0]->getWidth(),ty,hw,aguix->getCharHeight(),
                                       catalog.getLocale(33),1,0,0));
  ty+=b[0][0]->getHeight();
  b[1][0]=(Button*)win->add(new Button(aguix,lv->getX()+lv->getWidth()+5,ty,vw,aguix->getCharHeight(),
                                       catalog.getLocale(32),1,0,0));
  b[1][1]=(Button*)win->add(new Button(aguix,b[1][0]->getX()+b[1][0]->getWidth(),ty,hw,aguix->getCharHeight(),
                                       catalog.getLocale(33),1,0,0));
  ty+=b[1][0]->getHeight();
  b[2][0]=(Button*)win->add(new Button(aguix,lv->getX()+lv->getWidth()+5,ty,vw,aguix->getCharHeight(),
                                       catalog.getLocale(32),1,0,0));
  b[2][1]=(Button*)win->add(new Button(aguix,b[2][0]->getX()+b[1][0]->getWidth(),ty,hw,aguix->getCharHeight(),
                                       catalog.getLocale(33),1,0,0));
  ty+=b[2][0]->getHeight();
  b[3][0]=(Button*)win->add(new Button(aguix,lv->getX()+lv->getWidth()+5,ty,vw,aguix->getCharHeight(),
                                       catalog.getLocale(32),1,0,0));
  b[3][1]=(Button*)win->add(new Button(aguix,b[1][0]->getX()+b[3][0]->getWidth(),ty,hw,aguix->getCharHeight(),
                                       catalog.getLocale(33),1,0,0));
  ty+=b[3][0]->getHeight();
  b[4][0]=(Button*)win->add(new Button(aguix,lv->getX()+lv->getWidth()+5,ty,vw,aguix->getCharHeight(),
                                       catalog.getLocale(32),1,0,0));
  b[4][1]=(Button*)win->add(new Button(aguix,b[4][0]->getX()+b[4][0]->getWidth(),ty,hw,aguix->getCharHeight(),
                                       catalog.getLocale(33),1,0,0));
  ty+=b[4][0]->getHeight();
  b[5][0]=(Button*)win->add(new Button(aguix,lv->getX()+lv->getWidth()+5,ty,vw,aguix->getCharHeight(),
                                       catalog.getLocale(32),1,0,0));
  b[5][1]=(Button*)win->add(new Button(aguix,b[5][0]->getX()+b[5][0]->getWidth(),ty,hw,aguix->getCharHeight(),
                                       catalog.getLocale(33),1,0,0));
  ty+=b[5][0]->getHeight();
  b[6][0]=(Button*)win->add(new Button(aguix,lv->getX()+lv->getWidth()+5,ty,vw,aguix->getCharHeight(),
                                       catalog.getLocale(32),1,0,0));
  b[6][1]=(Button*)win->add(new Button(aguix,b[6][0]->getX()+b[6][0]->getWidth(),ty,hw,aguix->getCharHeight(),
                                       catalog.getLocale(33),1,0,0));
  ty+=b[6][0]->getHeight();
  b[7][0]=(Button*)win->add(new Button(aguix,lv->getX()+lv->getWidth()+5,ty,vw,aguix->getCharHeight(),
                                       catalog.getLocale(32),1,0,0));
  b[7][1]=(Button*)win->add(new Button(aguix,b[7][0]->getX()+b[7][0]->getWidth(),ty,hw,aguix->getCharHeight(),
                                       catalog.getLocale(33),1,0,0));
  ty+=b[7][0]->getHeight();
  b[8][0]=NULL;
  b[8][1]=(Button*)win->add(new Button(aguix,b[7][0]->getX()+b[7][0]->getWidth(),ty,hw,aguix->getCharHeight(),
                                       catalog.getLocale(33),1,0,0));
  tw=b[7][1]->getX()+b[7][1]->getWidth()+5;
  if(tw>w) w=tw;

  ty=lv->getY()+lv->getHeight();
  for ( i = 8; i >= 0; i-- ) {
    for ( j = 0; j < 2; j++ ) {
      if ( b[i][j] != NULL )
        b[i][j]->move( b[i][j]->getX(), ty - b[i][j]->getHeight() );
    }
    ty -= ( b[i][0] != NULL ) ? b[i][0]->getHeight() : b[i][1]->getHeight();
  }
  b[9][0] = (Button*)win->add( new Button( aguix,
                                           lv->getX() + lv->getWidth() + 5,
                                           lv->getY(),
                                           vw,
                                           ty - lv->getY(),
                                           catalog.getLocale( 32 ), 1, 0, 0 ) );
  b[9][1] = (Button*)win->add( new Button( aguix,
                                           b[9][0]->getX() + b[9][0]->getWidth(),
                                           b[9][0]->getY(),
                                           hw,
                                           b[9][0]->getHeight(),
                                           catalog.getLocale( 33 ), 1, 0, 0 ) );

  ty=lv->getY()+lv->getHeight()+5;
  BevelBox *bb3=(BevelBox*)win->add(new BevelBox(aguix,5,ty,10,2,0));
  ty=bb3->getY()+bb3->getHeight()+5;
  tw=strlen(catalog.getLocale(43))+2;
  tw*=aguix->getCharWidth();
  SolidButton *cbsb=(SolidButton*)win->add(new SolidButton(aguix,5,ty,tw,catalog.getLocale(43),
                                           clockbar[0],clockbar[1],false));
  Button *cbvb=(Button*)win->add(new Button(aguix,cbsb->getX()+cbsb->getWidth()+5,ty,vw,
                                            catalog.getLocale(32),1,0,0));
  Button *cbhb=(Button*)win->add(new Button(aguix,cbvb->getX()+cbvb->getWidth()+5,ty,hw,
                                            catalog.getLocale(33),1,0,0));
  tw=cbhb->getX()+cbhb->getWidth()+5;
  if(tw>w) w=tw;
  ty=cbsb->getY()+cbsb->getHeight()+5;
  BevelBox *bb4=(BevelBox*)win->add(new BevelBox(aguix,5,ty,10,2,0));
  ty=bb4->getY()+bb4->getHeight()+5;
  tw=strlen(catalog.getLocale(44))+2;
  tw*=aguix->getCharWidth();
  SolidButton *rsb=(SolidButton*)win->add(new SolidButton(aguix,5,ty,tw,catalog.getLocale(44),
                                           request[0],request[1],false));
  Button *rvb=(Button*)win->add(new Button(aguix,rsb->getX()+rsb->getWidth()+5,ty,vw,
                                            catalog.getLocale(32),1,0,0));
  Button *rhb=(Button*)win->add(new Button(aguix,rvb->getX()+rvb->getWidth()+5,ty,hw,
                                            catalog.getLocale(33),1,0,0));
  tw=rhb->getX()+rhb->getWidth()+5;
  if(tw>w) w=tw;
  ty=rsb->getY()+rsb->getHeight()+5;
  BevelBox *bb5=(BevelBox*)win->add(new BevelBox(aguix,5,ty,10,2,0));
  ty=bb5->getY()+bb5->getHeight()+5;  
  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->setDoTabCycling( true );
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  bb1->resize(w-10,2);
  bb2->resize(w-10,2);
  bb3->resize(w-10,2);
  bb4->resize(w-10,2);
  bb5->resize(w-10,2);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0,col;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==sbvb) {
          col=palette(statusbar[0]);
          if(col>=0) {
            statusbar[0]=col;
            sbsb->setFG(col);
          }
        } else if(msg->button.button==sbhb) {
          col=palette(statusbar[1]);
          if(col>=0) {
            statusbar[1]=col;
            sbsb->setBG(col);
          }
        } else if(msg->button.button==slvbvb) {
          col=palette(sel_lvb[0]);
          if(col>=0) {
            sel_lvb[0]=col;
            slvbsb->setFG(col);
          }
        } else if(msg->button.button==slvbhb) {
          col=palette(sel_lvb[1]);
          if(col>=0) {
            sel_lvb[1]=col;
            slvbsb->setBG(col);
          }
        } else if(msg->button.button==ulvbvb) {
          col=palette(unsel_lvb[0]);
          if(col>=0) {
            unsel_lvb[0]=col;
            ulvbsb->setFG(col);
          }
        } else if(msg->button.button==ulvbhb) {
          col=palette(unsel_lvb[1]);
          if(col>=0) {
            unsel_lvb[1]=col;
            ulvbsb->setBG(col);
          }
        } else if(msg->button.button==cbvb) {
          col=palette(clockbar[0]);
          if(col>=0) {
            clockbar[0]=col;
            cbsb->setFG(col);
          }
        } else if(msg->button.button==cbhb) {
          col=palette(clockbar[1]);
          if(col>=0) {
            clockbar[1]=col;
            cbsb->setBG(col);
          }
        } else if(msg->button.button==rvb) {
          col=palette(request[0]);
          if(col>=0) {
            request[0]=col;
            rsb->setFG(col);
          }
        } else if(msg->button.button==rhb) {
          col=palette(request[1]);
          if(col>=0) {
            request[1]=col;
            rsb->setBG(col);
          }
        } else {
          for(i=0;i<10;i++) {
            if(msg->button.button==b[i][0]) {
              switch(i) {
                case 1:
                  col=palette(sel_dir[0]);
                  if(col>=0) {
                    sel_dir[0]=col;
                    lv->setFG( i, FieldListView::CC_NORMAL, col );
                    lv->setFG( i, FieldListView::CC_SELECT, col );
                    lv->setFG( i, FieldListView::CC_ACTIVE, col );
                    lv->setFG( i, FieldListView::CC_SELACT, col );
                  }
                  break;
                case 2:
                  col=palette(unsel_file[0]);
                  if(col>=0) {
                    unsel_file[0]=col;
                    lv->setFG( i, FieldListView::CC_NORMAL, col );
                    lv->setFG( i, FieldListView::CC_SELECT, col );
                    lv->setFG( i, FieldListView::CC_ACTIVE, col );
                    lv->setFG( i, FieldListView::CC_SELACT, col );
                  }
                  break;
                case 3:
                  col=palette(sel_file[0]);
                  if(col>=0) {
                    sel_file[0]=col;
                    lv->setFG( i, FieldListView::CC_NORMAL, col );
                    lv->setFG( i, FieldListView::CC_SELECT, col );
                    lv->setFG( i, FieldListView::CC_ACTIVE, col );
                    lv->setFG( i, FieldListView::CC_SELACT, col );
                  }
                  break;
                case 4:
                  col=palette(unsel_dir_act[0]);
                  if(col>=0) {
                    unsel_dir_act[0]=col;
                    lv->setFG( i, FieldListView::CC_NORMAL, col );
                    lv->setFG( i, FieldListView::CC_SELECT, col );
                    lv->setFG( i, FieldListView::CC_ACTIVE, col );
                    lv->setFG( i, FieldListView::CC_SELACT, col );
                  }
                  break;
                case 5:
                  col=palette(sel_dir_act[0]);
                  if(col>=0) {
                    sel_dir_act[0]=col;
                    lv->setFG( i, FieldListView::CC_NORMAL, col );
                    lv->setFG( i, FieldListView::CC_SELECT, col );
                    lv->setFG( i, FieldListView::CC_ACTIVE, col );
                    lv->setFG( i, FieldListView::CC_SELACT, col );
                  }
                  break;
                case 6:
                  col=palette(unsel_file_act[0]);
                  if(col>=0) {
                    unsel_file_act[0]=col;
                    lv->setFG( i, FieldListView::CC_NORMAL, col );
                    lv->setFG( i, FieldListView::CC_SELECT, col );
                    lv->setFG( i, FieldListView::CC_ACTIVE, col );
                    lv->setFG( i, FieldListView::CC_SELACT, col );
                  }
                  break;
                case 7:
                  col=palette(sel_file_act[0]);
                  if(col>=0) {
                    sel_file_act[0]=col;
                    lv->setFG( i, FieldListView::CC_NORMAL, col );
                    lv->setFG( i, FieldListView::CC_SELECT, col );
                    lv->setFG( i, FieldListView::CC_ACTIVE, col );
                    lv->setFG( i, FieldListView::CC_SELACT, col );
                  }
                  break;
                case 8:
                  break;
                case 9:
                  col = palette( lvheader[0] );
                  if ( col >= 0 ) {
                    lvheader[0] = col;
                    lv->setHeaderFG( col );
                  }
                  break;
                default:
                  col=palette(unsel_dir[0]);
                  if(col>=0) {
                    unsel_dir[0]=col;
                    lv->setFG( i, FieldListView::CC_NORMAL, col );
                    lv->setFG( i, FieldListView::CC_SELECT, col );
                    lv->setFG( i, FieldListView::CC_ACTIVE, col );
                    lv->setFG( i, FieldListView::CC_SELACT, col );
                  }
                  break;
              }
            } else if(msg->button.button==b[i][1]) {
              switch(i) {
                case 1:
                  col=palette(sel_dir[1]);
                  if(col>=0) {
                    sel_dir[1]=col;
                    lv->setBG( i, FieldListView::CC_NORMAL, col );
                    lv->setBG( i, FieldListView::CC_SELECT, col );
                    lv->setBG( i, FieldListView::CC_ACTIVE, col );
                    lv->setBG( i, FieldListView::CC_SELACT, col );
                  }
                  break;
                case 2:
                  col=palette(unsel_file[1]);
                  if(col>=0) {
                    unsel_file[1]=col;
                    lv->setBG( i, FieldListView::CC_NORMAL, col );
                    lv->setBG( i, FieldListView::CC_SELECT, col );
                    lv->setBG( i, FieldListView::CC_ACTIVE, col );
                    lv->setBG( i, FieldListView::CC_SELACT, col );
                  }
                  break;
                case 3:
                  col=palette(sel_file[1]);
                  if(col>=0) {
                    sel_file[1]=col;
                    lv->setBG( i, FieldListView::CC_NORMAL, col );
                    lv->setBG( i, FieldListView::CC_SELECT, col );
                    lv->setBG( i, FieldListView::CC_ACTIVE, col );
                    lv->setBG( i, FieldListView::CC_SELACT, col );
                  }
                  break;
                case 4:
                  col=palette(unsel_dir_act[1]);
                  if(col>=0) {
                    unsel_dir_act[1]=col;
                    lv->setBG( i, FieldListView::CC_NORMAL, col );
                    lv->setBG( i, FieldListView::CC_SELECT, col );
                    lv->setBG( i, FieldListView::CC_ACTIVE, col );
                    lv->setBG( i, FieldListView::CC_SELACT, col );
                  }
                  break;
                case 5:
                  col=palette(sel_dir_act[1]);
                  if(col>=0) {
                    sel_dir_act[1]=col;
                    lv->setBG( i, FieldListView::CC_NORMAL, col );
                    lv->setBG( i, FieldListView::CC_SELECT, col );
                    lv->setBG( i, FieldListView::CC_ACTIVE, col );
                    lv->setBG( i, FieldListView::CC_SELACT, col );
                  }
                  break;
                case 6:
                  col=palette(unsel_file_act[1]);
                  if(col>=0) {
                    unsel_file_act[1]=col;
                    lv->setBG( i, FieldListView::CC_NORMAL, col );
                    lv->setBG( i, FieldListView::CC_SELECT, col );
                    lv->setBG( i, FieldListView::CC_ACTIVE, col );
                    lv->setBG( i, FieldListView::CC_SELACT, col );
                  }
                  break;
                case 7:
                  col=palette(sel_file_act[1]);
                  if(col>=0) {
                    sel_file_act[1]=col;
                    lv->setBG( i, FieldListView::CC_NORMAL, col );
                    lv->setBG( i, FieldListView::CC_SELECT, col );
                    lv->setBG( i, FieldListView::CC_ACTIVE, col );
                    lv->setBG( i, FieldListView::CC_SELACT, col );
                  }
                  break;
                case 8:
                  col=palette(listerbg);
                  if(col>=0) {
                    listerbg=col;
                    lv->setBG( i, FieldListView::CC_NORMAL, col );
                    lv->setBG( i, FieldListView::CC_SELECT, col );
                    lv->setBG( i, FieldListView::CC_ACTIVE, col );
                    lv->setBG( i, FieldListView::CC_SELACT, col );
                  }
                  break;
                case 9:
                  col = palette( lvheader[1] );
                  if ( col >= 0 ) {
                    lvheader[1] = col;
                    lv->setHeaderBG( col );
                  }
                  break;
                default:
                  col=palette(unsel_dir[1]);
                  if(col>=0) {
                    unsel_dir[1]=col;
                    lv->setBG( i, FieldListView::CC_NORMAL, col );
                    lv->setBG( i, FieldListView::CC_SELECT, col );
                    lv->setBG( i, FieldListView::CC_ACTIVE, col );
                    lv->setBG( i, FieldListView::CC_SELACT, col );
                  }
                  break;
              }
            }
          }
          lv->redraw();
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    // Wiederherstellen
    statusbar[0]=twconfig->getStatusbar(0);
    statusbar[1]=twconfig->getStatusbar(1);
    sel_lvb[0]=twconfig->getSelLVB(0);
    sel_lvb[1]=twconfig->getSelLVB(1);
    unsel_lvb[0]=twconfig->getUnselLVB(0);
    unsel_lvb[1]=twconfig->getUnselLVB(1);
    sel_dir[0]=twconfig->getSelDir(0);
    sel_dir[1]=twconfig->getSelDir(1);
    unsel_dir[0]=twconfig->getUnselDir(0);
    unsel_dir[1]=twconfig->getUnselDir(1);
    sel_file[0]=twconfig->getSelFile(0);
    sel_file[1]=twconfig->getSelFile(1);
    unsel_file[0]=twconfig->getUnselFile(0);
    unsel_file[1]=twconfig->getUnselFile(1);
    sel_dir_act[0]=twconfig->getSelDirAct(0);
    sel_dir_act[1]=twconfig->getSelDirAct(1);
    unsel_dir_act[0]=twconfig->getUnselDirAct(0);
    unsel_dir_act[1]=twconfig->getUnselDirAct(1);
    sel_file_act[0]=twconfig->getSelFileAct(0);
    sel_file_act[1]=twconfig->getSelFileAct(1);
    unsel_file_act[0]=twconfig->getUnselFileAct(0);
    unsel_file_act[1]=twconfig->getUnselFileAct(1);
    clockbar[0]=twconfig->getClockbar(0);
    clockbar[1]=twconfig->getClockbar(1);
    request[0]=twconfig->getRequest(0);
    request[1]=twconfig->getRequest(1);
    lvheader[0] = twconfig->getLVHeader( 0 );
    lvheader[1] = twconfig->getLVHeader( 1 );
    listerbg=twconfig->getListerBG();
  }
  delete twconfig;
  win->close();
  delete win;
  return (ende==-1)?false:true;
}

bool WConfig::changeStartup()
{
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1,t2;
  w=100;
  h=50;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(3));
  Text *tt1=(Text*)win->add(new Text(aguix,5,5,catalog.getLocale(46),1));
  StringGadget *sg1=(StringGadget*)win->add(new StringGadget(aguix,10,
                                            tt1->getY()+tt1->getHeight()+5,tt1->getWidth(),
                                            dir[0],0));
  ty=sg1->getY()+sg1->getHeight()+5;
  tw=sg1->getX()+sg1->getWidth()+15;
  if(tw>w) w=tw;
  tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(47),1));
  StringGadget *sg2=(StringGadget*)win->add(new StringGadget(aguix,10,
                                            tt1->getY()+tt1->getHeight()+5,tt1->getWidth(),
                                            dir[1],0));
  ty=sg2->getY()+sg2->getHeight()+5;
  tw=sg2->getX()+sg2->getWidth()+15;
  if(tw>w) w=tw;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  sg1->resize(w-15,sg1->getHeight());
  sg2->resize(w-15,sg2->getHeight());
  h=okb->getY()+okb->getHeight()+5;
  win->setDoTabCycling( true );
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    setStartDir(0,sg1->getText());
    setStartDir(1,sg2->getText());
  }
  win->close();
  delete win;
  return (ende==-1)?false:true;
}

bool WConfig::changeButtons()
{
  WConfig *twconfig=duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int t1,t2,t3;
  char bankstr[ A_BYTESFORNUMBER( int ) ];
  int banknr=0,i;
  unsigned int i2;
  bool extmode=false;
  CycleButton *cyb;
  Text *mtext;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;
  const int cmin = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW;
  
  AWindow *win=new AWindow(aguix);
  win->create( NULL, 10, 10, 10, 10, 0, catalog.getLocale( 4 ) );

  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 6 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );
  
  AContainerBB *ac1_1[2];
  AContainer *ac1_1_1[2];
  
  sprintf(bankstr,"%d",banknr);
  Button ***bbs;
  
  bbs = new Button**[rows*columns];
  for ( i = 0; i < (int)( rows * columns ); i++ ) {
    bbs[i] = new Button*[2];
  }
  Text *tt1;
  for(int k=0;k<2;k++) {
    ac1_1[k] = static_cast<AContainerBB*>( ac1->add( new AContainerBB( win, 1, 2 ), 0, k ) );
    ac1_1[k]->setMinSpace( 5 );
    ac1_1[k]->setMaxSpace( 5 );
    tt1 = (Text*)ac1_1[k]->add( new Text( aguix, 0, 0, catalog.getLocale( 51 + k ), 1 ),
                                0, 0, cincwnr );
    ac1_1_1[k] = ac1_1[k]->add( new AContainer( win, columns, rows ), 0, 1 );
    ac1_1_1[k]->setMinSpace( 0 );
    ac1_1_1[k]->setMaxSpace( 0 );
    ac1_1_1[k]->setBorderWidth( 0 );
    for(i2=0;i2<rows;i2++) {
      for(unsigned int j=0;j<columns;j++) {
        bbs[i2*columns+j][k] = (Button*)ac1_1_1[k]->add( new Button( aguix,
                                                                     0,
                                                                     0,
                                                                     20,
                                                                     "",
                                                                     1,
                                                                     0,
                                                                     2 * ( i2 * columns + j ) + k ),
                                                         j, i2, cmin );
      }
    }
  }

  AContainer *ac1_2 = ac1->add( new AContainer( win, 8, 1 ), 0, 2 );
  ac1_2->setMinSpace( 5 );
  ac1_2->setMaxSpace( 5 );
  ac1_2->setBorderWidth( 0 );

  tt1 = (Text*)ac1_2->add( new Text( aguix, 0, 0, catalog.getLocale( 68 ), 1 ), 0, 0, cfix );
  Text *bnrt = (Text*)ac1_2->add( new Text( aguix, 0, 0, "   ", 1 ), 1, 0, cfix );
  Button *nextbb = (Button*)ac1_2->add( new Button( aguix, 0, 0,
                                                    catalog.getLocale( 69 ), 1, 0, 0 ),
                                        2, 0, cincw );
  Button *prevbb = (Button*)ac1_2->add( new Button( aguix, 0, 0,
                                                    catalog.getLocale( 70 ), 1, 0, 0 ),
                                        3, 0, cincw );
  Button *newbb = (Button*)ac1_2->add( new Button( aguix, 0, 0,
                                                   catalog.getLocale( 71 ), 1, 0, 0 ),
                                       4, 0, cincw );
  Button *delbb = (Button*)ac1_2->add( new Button( aguix, 0, 0,
                                                   catalog.getLocale( 72 ), 1, 0, 0 ),
                                       5, 0, cincw );
  Button *swapnextb = (Button*)ac1_2->add( new Button( aguix, 0, 0,
                                                       catalog.getLocale( 571 ), 1, 0, 0 ),
                                       6, 0, cincw );
  Button *swapprevb = (Button*)ac1_2->add( new Button( aguix, 0, 0,
                                                       catalog.getLocale( 572 ), 1, 0, 0 ),
                                       7, 0, cincw );
  SolidButton *sbsb = (SolidButton*)ac1->add( new SolidButton( aguix,
                                                               0,
                                                               0,
                                                               10,
                                                               "",
                                                               2,
                                                               3,
                                                               false ),
                                              0, 3, cincw );

  AContainer *ac1_3 = ac1->add( new AContainer( win, 2, 1 ), 0, 4 );
  ac1_3->setMinSpace( 5 );
  ac1_3->setMaxSpace( 5 );
  ac1_3->setBorderWidth( 0 );
  mtext = (Text*)ac1_3->add( new Text( aguix, 0, 0, catalog.getLocale( 227 ), 1 ), 0, 0, cfix );
  cyb = new CycleButton( aguix, 0, 0, 100, 1, 0, 0 );
  cyb->addOption( catalog.getLocale( 228 ) );
  cyb->addOption( catalog.getLocale( 229 ) );
  cyb->resize( cyb->getMaxSize(), cyb->getHeight() );

  ac1_3->add( cyb, 1, 0, cincw );
  if ( extmode == true ) cyb->setOption( 1 );
  else cyb->setOption( 0 );

  AContainer *ac1_4 = ac1->add( new AContainer( win, 5, 1 ), 0, 5 );
  ac1_4->setMinSpace( 0 );
  ac1_4->setMaxSpace( 0 );
  ac1_4->setBorderWidth( 0 );
  Button *copyb = (Button*)ac1_4->add( new Button( aguix, 0, 0, catalog.getLocale( 48 ), 1, 0, 0 ),
                                       0, 0, cincw );
  Button *swapb = (Button*)ac1_4->add( new Button( aguix, 0,
                                                   0, catalog.getLocale( 49 ), 1, 0, 0 ),
                                       1, 0, cincw );
  Button *delb = (Button*)ac1_4->add( new Button( aguix, 0,
                                                  0, catalog.getLocale( 50 ), 1, 0, 0 ),
                                      2, 0, cincw );
  Button *okb = (Button*)ac1_4->add( new Button( aguix,
                                                 0,
                                                 0,
                                                 catalog.getLocale( 11 ),
                                                 1,
                                                 0,
                                                 0 ),
                                     3, 0, cincw );
  Button *cancelb = (Button*)ac1_4->add( new Button( aguix,
                                                     0,
                                                     0,
                                                     catalog.getLocale( 8 ),
                                                     1,
                                                     0,
                                                     0 ),
                                         4, 0, cincw );
  win->setDoTabCycling( true );
  win->contMaximize( true );
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  int banksize=rows*columns*2;
  int maxbank=buttons->size()/banksize;
  int mode=0;
  int selindex=-1;
  bnrt->setText(bankstr);
  sbsb->setText(catalog.getLocale(53));
  showButtonBank(banknr,bbs);
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==nextbb) {
          if((banknr+1)<maxbank) {
            banknr++;
            showButtonBank(banknr,bbs);
            sprintf(bankstr,"%d",banknr);
            bnrt->setText(bankstr);
          }
        } else if(msg->button.button==prevbb) {
          if(banknr>0) {
            banknr--;
            showButtonBank(banknr,bbs);
            sprintf(bankstr,"%d",banknr);
            bnrt->setText(bankstr);
          }
        } else if(msg->button.button==newbb) {
          int s2=(banknr+1)*banksize;
          for(i=0;i<banksize;i++) {
            buttons->addElementAt(s2,new WCButton());
          }
          maxbank++;
          banknr++;
          showButtonBank(banknr,bbs);
          sprintf(bankstr,"%d",banknr);
          bnrt->setText(bankstr);
        } else if(msg->button.button==delbb) {
          if(maxbank>1) {
            int s2=banknr*banksize;
            WCButton *b1;
            for(i=0;i<banksize;i++) {
              b1=(WCButton*)buttons->getElementAt(s2);
              delete b1;
              buttons->removeElementAt(s2);
            }
            maxbank--;
            if(banknr>=maxbank) {
              banknr--;
              sprintf(bankstr,"%d",banknr);
              bnrt->setText(bankstr);
            }
            showButtonBank(banknr,bbs);
          }
        } else if ( msg->button.button == swapnextb ) {
          if ( ( banknr + 1 ) < maxbank ) {
            int delpos = ( banknr + 1 ) * banksize;
            int delta = ( - banksize );
            WCButton *b1;

            for ( i = 0; i < banksize; i++ ) {
              b1 = (WCButton*)buttons->getElementAt( delpos + i );
              if ( b1 == NULL ) break;
              buttons->removeElementAt( delpos + i );
              buttons->addElementAt( delpos + i + delta, b1 );
            }
            banknr++;
            showButtonBank( banknr, bbs );
            sprintf( bankstr, "%d", banknr );
            bnrt->setText( bankstr );
          }
        } else if ( msg->button.button == swapprevb ) {
          if ( banknr > 0 ) {
            int delpos = banknr * banksize;
            int delta = ( - banksize );
            WCButton *b1;

            for ( i = 0; i < banksize; i++ ) {
              b1 = (WCButton*)buttons->getElementAt( delpos + i );
              if ( b1 == NULL ) break;
              buttons->removeElementAt( delpos + i );
              buttons->addElementAt( delpos + i + delta, b1 );
            }
            banknr--;
            showButtonBank( banknr, bbs );
            sprintf( bankstr, "%d", banknr );
            bnrt->setText( bankstr );
          }
        } else if(msg->button.button==copyb) {
          if((mode==1)||(mode==2)) {
            sbsb->setText(catalog.getLocale(53));
            mode=0;
          } else {
            sbsb->setText(catalog.getLocale(54));
            mode=1;
          }
        } else if(msg->button.button==swapb) {
          if((mode==3)||(mode==4)) {
            sbsb->setText(catalog.getLocale(53));
            mode=0;
          } else {
            sbsb->setText(catalog.getLocale(56));
            mode=3;
          }
        } else if(msg->button.button==delb) {
          if(mode==5) {
            sbsb->setText(catalog.getLocale(53));
            mode=0;
          } else {
            sbsb->setText(catalog.getLocale(58));
            mode=5;
          }
        } else {
          t1=msg->button.button->getData();
          if(t1>=0) {
            t2=t1&1;
            t3=t1/2;
            if(bbs[t3][t2]==msg->button.button) {
              int s1=t1+banknr*banksize;
              WCButton *b1,*b2;
              switch(mode) {
                case 1:
                  selindex=s1;
                  sbsb->setText(catalog.getLocale(55));
                  mode=2;
                  break;
                case 2:
                  // copy selindex -> s1
                  b1=(WCButton*)buttons->getElementAt(selindex);
                  b2=b1->duplicate();
                  // reset shortkey to avoid duplicates
                  b2->setDoubleKeys( NULL );
                  
                  b1=(WCButton*)buttons->exchangeElement(s1,b2);
                  if(b1!=NULL) delete b1;
                  showButtonBank(banknr,bbs);
                  if(extmode==true) {
                    sbsb->setText(catalog.getLocale(54));
                    mode=1;
                  } else {
                    sbsb->setText(catalog.getLocale(53));
                    mode=0;
                  }
                  break;
                case 3:
                  selindex=s1;
                  sbsb->setText(catalog.getLocale(57));
                  mode=4;
                  break;
                case 4:
                  // swap s1 <-> selindex
                  b1=(WCButton*)buttons->getElementAt(selindex);
                  b2=(WCButton*)buttons->exchangeElement(s1,b1);
                  buttons->exchangeElement(selindex,b2);
                  showButtonBank(banknr,bbs);
                  if(extmode==true) {
                    sbsb->setText(catalog.getLocale(56));
                    mode=3;
                  } else {
                    sbsb->setText(catalog.getLocale(53));
                    mode=0;
                  }
                  break;
                case 5:
                  // del s1
                  b1=new WCButton();
                  b2=(WCButton*)buttons->exchangeElement(s1,b1);
                  if(b2!=NULL) delete b2;
                  showButtonBank(banknr,bbs);
                  if(extmode==false) {
                    sbsb->setText(catalog.getLocale(53));
                    mode=0;
                  }
                  break;
                default:
                  // configure s1
                  b1=(WCButton*)buttons->getElementAt(s1);
                  if(b1!=NULL) {
                    win->hide();
                    if(configureButton(b1)==true) {
                      msg->button.button->setText(0,b1->getText());
                      msg->button.button->setFG(0,b1->getFG());
                      msg->button.button->setBG(0,b1->getBG());
                    }
                    win->show();
                  }
              }
            }
          }
        }
      } else if(msg->type==AG_CYCLEBUTTONCLICKED) {
        if(msg->cyclebutton.cyclebutton==cyb) {
          if(msg->cyclebutton.option==1) extmode=true;
          else extmode=false;
        }
      } else if(msg->type==AG_KEYPRESSED) {
        if(msg->key.key==XK_Escape) {
          sbsb->setText(catalog.getLocale(53));
          mode=0;
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    // Wiederherstellen
    setButtons(twconfig->getButtons());
    // also restore paths and hotkeys (for the case the user entered a shortkey from one of this
    setPaths(twconfig->getPaths());
    setHotkeys(twconfig->getHotkeys());
  } else cleanUpButtons();
  win->close();
  delete win;
  delete twconfig;
  for ( i = 0; i < (int)( rows * columns ); i++ ) {
    delete [] bbs[i];
  }
  delete [] bbs;
  return (ende==-1)?false:true;
}

bool WConfig::changePaths()
{
  WConfig *twconfig=duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1,t2,t3,tt,tx;
  char bankstr[ A_BYTESFORNUMBER( int ) ];
  int banknr=0,i;
  unsigned int i2;
  bool extmode=false;
  CycleButton *cyb;
  Text *mtext; 

  t1=(strlen(catalog.getLocale(73))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(74))+2);
  t2*=aguix->getCharWidth();
  t1+=t2;
  t2=(strlen(catalog.getLocale(75))+2);
  t2*=aguix->getCharWidth();
  t1+=t2;
  w=t1;
  for(i=76;i<82;i++) {
    t1=(strlen(catalog.getLocale(i))+2);
    t1*=aguix->getCharWidth();
    if(t1>w) w=t1;
  }
  t2=0;
  for(i=69;i<73;i++) {
    t1=(strlen(catalog.getLocale(i))+2);
    t1*=aguix->getCharWidth();
    if(t1>t2) t2=t1;
    t1+=150+10;
    if(t1>w) w=t1;
  }
  t1=(strlen(catalog.getLocale(68))+5);
  t1*=aguix->getCharWidth();
  if(t1>t2) t2=t1;
  t1+=150+10;
  if(t1>w) w=t1;
  w+=10;

  mtext=new Text(aguix,0,0,catalog.getLocale(227),1);
  cyb=new CycleButton(aguix,0,0,100,1,0,0);
  cyb->addOption(catalog.getLocale(228));
  cyb->addOption(catalog.getLocale(229));
  cyb->resize(cyb->getMaxSize(),cyb->getHeight());
  t1=5+mtext->getWidth()+5+cyb->getWidth()+5;
  if(t1>w) w=t1;

  h=50;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(5));
  ty=5;

  sprintf(bankstr,"%d",banknr);
  Button **pbs;
  
  pbs = new Button*[rows];
  for(i2=0;i2<rows;i2++) {
    pbs[i2]=(Button*)win->add(new Button(aguix,5,ty+((i2==0)?0:(pbs[i2-1]->getHeight()*i2)),
                                        w-5-t2-5-5,"",1,0,0));
  }
  Text *tt1=(Text*)win->add(new Text(aguix,w-5-t2,ty,catalog.getLocale(68),1));
  Text *bnrt=(Text*)win->add(new Text(aguix,tt1->getX()+tt1->getWidth()+5,ty,
                                      bankstr,1));
  ty+=pbs[0]->getHeight();
  Button *nextbb=(Button*)win->add(new Button(aguix,w-5-t2,ty,t2,
                                              catalog.getLocale(69),1,0,0));
  ty+=nextbb->getHeight();
  Button *prevbb=(Button*)win->add(new Button(aguix,w-5-t2,ty,t2,
                                              catalog.getLocale(70),1,0,0));
  ty+=prevbb->getHeight();
  Button *newbb=(Button*)win->add(new Button(aguix,w-5-t2,ty,t2,
                                             catalog.getLocale(71),1,0,0));
  ty+=newbb->getHeight();
  Button *delbb=(Button*)win->add(new Button(aguix,w-5-t2,ty,t2,
                                             catalog.getLocale(72),1,0,0));
  ty=delbb->getY()+delbb->getHeight()+5;
  t2=pbs[rows-1]->getY()+pbs[rows-1]->getHeight()+5;
  if(t2>ty) ty=t2;

  t1=(strlen(catalog.getLocale(73))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(74))+2);
  t2*=aguix->getCharWidth();
  t3=(strlen(catalog.getLocale(75))+2);
  t3*=aguix->getCharWidth();
  double d1=w-10;
  d1/=3;
  tt=w-10-t2-t3;
  if(tt>d1) t1=(int)d1; else t1=tt;
  tt=w-10-t1-t3;
  if(tt>d1) t2=(int)d1; else t2=tt;
  tt=w-10-t1-t2;
  if(tt>d1) t3=(int)d1; else t3=tt;
  
  Button *copyb=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(73),1,0,0));
  Button *swapb=(Button*)win->add(new Button(aguix,copyb->getX()+copyb->getWidth(),
                                             ty,t2,catalog.getLocale(74),1,0,0));
  Button *delb=(Button*)win->add(new Button(aguix,swapb->getX()+swapb->getWidth(),
                                            ty,t3,catalog.getLocale(75),1,0,0));
  ty+=delb->getHeight()+5;
  SolidButton *sbsb=(SolidButton*)win->add(new SolidButton(aguix,5,ty,w-10,"",2,3,false));
  ty+=sbsb->getHeight()+5;

  tx=5;
  mtext->move(5,ty);
  win->add(mtext);
  tx+=mtext->getWidth()+5;
  cyb->move(tx,ty);
  win->add(cyb);
  if(extmode==true) cyb->setOption(1);
  else cyb->setOption(0);

  ty+=cyb->getHeight()+5;
  tw=tx+cyb->getWidth()+5;
  if(tw>w) w=tw;
  tx=5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->setDoTabCycling( true );
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  int maxbank=paths->size()/rows;
  int mode=0;
  int selindex=-1;
  sbsb->setText(catalog.getLocale(76));
  showPathBank(banknr,pbs);
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==nextbb) {
          if((banknr+1)<maxbank) {
            banknr++;
            showPathBank(banknr,pbs);
            sprintf(bankstr,"%d",banknr);
            bnrt->setText(bankstr);
          }
        } else if(msg->button.button==prevbb) {
          if(banknr>0) {
            banknr--;
            showPathBank(banknr,pbs);
            sprintf(bankstr,"%d",banknr);
            bnrt->setText(bankstr);
          }
        } else if(msg->button.button==newbb) {
          int s2=(banknr+1)*rows;
          for(i2=0;i2<rows;i2++) {
            paths->addElementAt(s2,new WCPath());
          }
          maxbank++;
          banknr++;
          showPathBank(banknr,pbs);
          sprintf(bankstr,"%d",banknr);
          bnrt->setText(bankstr);
        } else if(msg->button.button==delbb) {
          if(maxbank>1) {
            int s2=banknr*rows;
            WCPath *p1;
            for(i2=0;i2<rows;i2++) {
              p1=(WCPath*)paths->getElementAt(s2);
              delete p1;
              paths->removeElementAt(s2);
            }
            maxbank--;
            if(banknr>=maxbank) {
              banknr--;
              sprintf(bankstr,"%d",banknr);
              bnrt->setText(bankstr);
            }
            showPathBank(banknr,pbs);
          }
        } else if(msg->button.button==copyb) {
          if((mode==1)||(mode==2)) {
            sbsb->setText(catalog.getLocale(76));
            mode=0;
          } else {
            sbsb->setText(catalog.getLocale(77));
            mode=1;
          }
        } else if(msg->button.button==swapb) {
          if((mode==3)||(mode==4)) {
            sbsb->setText(catalog.getLocale(76));
            mode=0;
          } else {
            sbsb->setText(catalog.getLocale(79));
            mode=3;
          }
        } else if(msg->button.button==delb) {
          if(mode==5) {
            sbsb->setText(catalog.getLocale(76));
            mode=0;
          } else {
            sbsb->setText(catalog.getLocale(81));
            mode=5;
          }
        } else {
          for(i2=0;i2<rows;i2++) {
            if(msg->button.button==pbs[i2]) {
              int s1=i2+banknr*rows;
              WCPath *p1,*p2;
              switch(mode) {
                case 1:
                  selindex=s1;
                  sbsb->setText(catalog.getLocale(78));
                  mode=2;
                  break;
                case 2:
                  // copy selindex -> s1
                  p1=(WCPath*)paths->getElementAt(selindex);
                  p2=p1->duplicate();
                  // reset shortkey to avoid duplicates
                  p2->setDoubleKeys( NULL );
                  
                  p1=(WCPath*)paths->exchangeElement(s1,p2);
                  if(p1!=NULL) delete p1;
                  showPathBank(banknr,pbs);
                  if(extmode==true) {
                    sbsb->setText(catalog.getLocale(77));
                    mode=1;
                  } else {
                    sbsb->setText(catalog.getLocale(76));
                    mode=0;
                  }
                  break;
                case 3:
                  selindex=s1;
                  sbsb->setText(catalog.getLocale(80));
                  mode=4;
                  break;
                case 4:
                  // swap s1 <-> selindex
                  p1=(WCPath*)paths->getElementAt(selindex);
                  p2=(WCPath*)paths->exchangeElement(s1,p1);
                  paths->exchangeElement(selindex,p2);
                  showPathBank(banknr,pbs);
                  if(extmode==true) {
                    sbsb->setText(catalog.getLocale(79));
                    mode=3;
                  } else {
                    sbsb->setText(catalog.getLocale(76));
                    mode=0;
                  }
                  break;
                case 5:
                  // del s1
                  p1=new WCPath();
                  p2=(WCPath*)paths->exchangeElement(s1,p1);
                  if(p2!=NULL) delete p2;
                  showPathBank(banknr,pbs);
                  if(extmode==false) {
                    sbsb->setText(catalog.getLocale(76));
                    mode=0;
                  }
                  break;
                default:
                  // configure s1
                  p1=(WCPath*)paths->getElementAt(s1);
                  if(p1!=NULL) {
                    win->hide();
                    if(configurePath(p1)==true) {
                      showPathBank(banknr,pbs);
                    }
                    win->show();
                  }
              }
              break;
            }
          }
        }
      } else if(msg->type==AG_CYCLEBUTTONCLICKED) {
        if(msg->cyclebutton.cyclebutton==cyb) {
          if(msg->cyclebutton.option==1) extmode=true;
          else extmode=false;
        }
      } else if(msg->type==AG_KEYPRESSED) {
        if(msg->key.key==XK_Escape) {
          sbsb->setText(catalog.getLocale(76));
          mode=0;
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    // restore paths
    setPaths(twconfig->getPaths());
    // also restore buttons and hotkeys (for the case the user entered a shortkey from one of this
    setButtons(twconfig->getButtons());
    setHotkeys(twconfig->getHotkeys());
  } else cleanUpPaths();
  win->close();
  delete win;
  delete twconfig;
  delete [] pbs;
  return (ende==-1)?false:true;
}

void WConfig::showPathBank(int nr,Button **pbs)
{
  WCPath *p1;
  int id=paths->initEnum();
  if((nr>=0)&&(nr<(paths->size()/(int)rows))) {
    for(unsigned int i=0;i<rows;i++) {
      p1=(WCPath*)paths->getElementAt(id,i+nr*rows);
      if((p1!=NULL)&&(p1->getCheck()==true)) {
        pbs[i]->setText(0,p1->getName());
        pbs[i]->setFG(0,p1->getFG());
        pbs[i]->setBG(0,p1->getBG());
      } else {
        pbs[i]->setText(0,"");
        pbs[i]->setFG(0,1);
        pbs[i]->setBG(0,0);
      }
    }
  }
  paths->closeEnum(id);
}

void WConfig::showButtonBank( int nr, Button ***bbs)
{
  WCButton *b1;
  int id=buttons->initEnum();
  int banksize=rows*columns;
  if((nr>=0)&&(nr<(buttons->size()/(banksize*2)))) {
    for(unsigned int i=0;i<rows;i++) {
      for(unsigned int j=0;j<columns;j++) {
        b1=(WCButton*)buttons->getElementAt(id,nr*banksize*2+i*columns*2+j*2);
        if((b1!=NULL)&&(b1->getCheck()==true)) {
          bbs[i*columns+j][0]->setText(0,b1->getText());
          bbs[i*columns+j][0]->setFG(0,b1->getFG());
          bbs[i*columns+j][0]->setBG(0,b1->getBG());
        } else {
          bbs[i*columns+j][0]->setText(0,"");
          bbs[i*columns+j][0]->setFG(0,1);
          bbs[i*columns+j][0]->setBG(0,0);
        }
        b1=(WCButton*)buttons->getNextElement(id);
        if((b1!=NULL)&&(b1->getCheck()==true)) {
          bbs[i*columns+j][1]->setText(0,b1->getText());
          bbs[i*columns+j][1]->setFG(0,b1->getFG());
          bbs[i*columns+j][1]->setBG(0,b1->getBG());
        } else {
          bbs[i*columns+j][1]->setText(0,"");
          bbs[i*columns+j][1]->setFG(0,1);
          bbs[i*columns+j][1]->setBG(0,0);
        }
      }
    }
  }
  buttons->closeEnum(id);
}

WC_Color::WC_Color()
{
  red=0;
  green=0;
  blue=0;
}

WC_Color::WC_Color(int r,int g,int b)
{
  setRed( r );
  setGreen( g );
  setBlue( b );
}

WC_Color *WC_Color::duplicate()
{
  return (new WC_Color(red,green,blue));
}

int WC_Color::getRed() const
{
  return red;
}

int WC_Color::getGreen() const
{
  return green;
}

int WC_Color::getBlue() const
{
  return blue;
}

void WC_Color::setRed( int r )
{
  red = r;
  if ( red < 0 ) red = 0;
  if ( red > 255 ) red = 255;
}

void WC_Color::setGreen( int g )
{
  green = g;
  if ( green < 0 ) green = 0;
  if ( green > 255 ) green = 255;
}

void WC_Color::setBlue( int b )
{
  blue = b;
  if ( blue < 0 ) blue = 0;
  if ( blue > 255 ) blue = 255;
}

bool WConfig::changePalette()
{
  WConfig *twconfig=duplicate();
  Button *colbs[256];
  AGUIX *aguix=worker->getAGUIX();
  int w,h;
  w=5+256+10+5;
  h=5+256+10+5+aguix->getCharHeight()+4+5;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(15));
  int sx = (int)sqrt( (double)( colors->size() ) );
  if((sx*sx)<colors->size()) sx++;
  int tw=w-10-10;
  int th=256/sx;
  for(int i=0;i<colors->size();i++) {
    colbs[i]=(Button*)win->add(new Button(aguix,
                        10+(i%sx)*th,
                        10+(i/sx)*th,
                        th,
                        th,
                        "",
                        0,
                        i,
                        i+1));
  }
  ((BevelBox*)win->add(new BevelBox(aguix,
                                    5,
                                    5,
                                    256+10,
                                    256+10,
                                    1)))->toBack();
  int dy=5;
  Text *label1=(Text*)win->add(new Text(aguix,
                                        256+20,
                                        5,
                                        catalog.getLocale(27),
                                        1));
  Text *palentryt=(Text*)win->add(new Text(aguix,
                                           256+20+label1->getWidth()+5,
                                           5,
                                           "   ",
                                           1));
  int labelindex=-1;
  int ttx,tty,tx,ty;
  palentryt->getPos(&ttx,&tty);
  tw=ttx+palentryt->getWidth()+5;
  if(tw>w) w=tw;
  dy+=label1->getHeight()+5;

  int t1=strlen(catalog.getLocale(28));
  int t2=strlen(catalog.getLocale(29));
  if(t2>t1) t1=t2;
  t2=strlen(catalog.getLocale(30));
  if(t2>t1) t1=t2;
  t1++;
  t1*=aguix->getCharWidth();
  label1=(Text*)win->add(new Text(aguix,
                                  256+20,
                                  dy+2,
                                  catalog.getLocale(28),
                                  1));
  ttx=3*aguix->getCharWidth();
  StringGadget *redsg=(StringGadget*)win->add(new StringGadget(aguix,
                                                               256+20+t1+ttx+5,
                                                               dy,
                                                               6*aguix->getCharWidth(),
                                                               "",
                                                               1));
  tty=redsg->getHeight();
  redsg->getPos(&tx,&ty);
  Button *redl=(Button*)win->add(new Button(aguix,
                                            256+20+t1,
                                            dy,
                                            ttx,
                                            tty,
                                            "<",
                                            1,
                                            0,
                                            0));
  Button *redr=(Button*)win->add(new Button(aguix,
                                            tx+redsg->getWidth()+5,
                                            dy,
                                            ttx,
                                            tty,
                                            ">",
                                            1,
                                            0,
                                            0));
  tw=tx+redsg->getWidth()+5+ttx+5;
  if(tw>w) w=tw;
  dy+=tty+5;
  label1=(Text*)win->add(new Text(aguix,
                                  256+20,
                                  dy+2,
                                  catalog.getLocale(29),
                                  1));
  StringGadget *greensg=(StringGadget*)win->add(new StringGadget(aguix,
                                                               256+20+t1+ttx+5,
                                                               dy,
                                                               6*aguix->getCharWidth(),
                                                               "",
                                                               1));
  Button *greenl=(Button*)win->add(new Button(aguix,
                                            256+20+t1,
                                            dy,
                                            ttx,
                                            tty,
                                            "<",
                                            1,
                                            0,
                                            0));
  Button *greenr=(Button*)win->add(new Button(aguix,
                                            tx+redsg->getWidth()+5,
                                            dy,
                                            ttx,
                                            tty,
                                            ">",
                                            1,
                                            0,
                                            0));
  dy+=tty+5;
  label1=(Text*)win->add(new Text(aguix,
                                  256+20,
                                  dy+2,
                                  catalog.getLocale(30),
                                  1));
  StringGadget *bluesg=(StringGadget*)win->add(new StringGadget(aguix,
                                                               256+20+t1+ttx+5,
                                                               dy,
                                                               6*aguix->getCharWidth(),
                                                               "",
                                                               1));
  Button *bluel=(Button*)win->add(new Button(aguix,
                                            256+20+t1,
                                            dy,
                                            ttx,
                                            tty,
                                            "<",
                                            1,
                                            0,
                                            0));
  Button *bluer=(Button*)win->add(new Button(aguix,
                                            tx+redsg->getWidth()+5,
                                            dy,
                                            ttx,
                                            tty,
                                            ">",
                                            1,
                                            0,
                                            0));
  dy+=tty+5;
  SolidButton *editcolsb=(SolidButton*)win->add(new SolidButton(aguix,
                                                256+20,
                                                dy,
                                                32,
                                                32,
                                                "",
                                                0,
                                                0,
                                                false));
  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  Button *okb=(Button*)win->add(new Button(aguix,
                                           5,
                                           h-5-aguix->getCharHeight()-2,
                                           t1,
                                           catalog.getLocale(11),
                                           1,
                                           0,
                                           0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                               w-5-t2,
                                               h-5-aguix->getCharHeight()-2,
                                               t2,
                                               catalog.getLocale(8),
                                               1,
                                               0,
                                               0));  
  win->setDoTabCycling( true );
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  char *tstr;
  WC_Color *tc1;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button->getData()>0) {
          // ein Eintrag wurde ausgewhlt
          labelindex=msg->button.button->getData()-1;
          editcolsb->setBG(labelindex);
          tc1=(WC_Color*)colors->getElementAt(labelindex);
          tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
          sprintf( tstr, "%d", tc1->getRed() );
          redsg->setText(tstr);
          sprintf( tstr, "%d", tc1->getGreen() );
          greensg->setText(tstr);
          sprintf( tstr, "%d", tc1->getBlue() );
          bluesg->setText(tstr);
          sprintf(tstr,"%d",labelindex);
          palentryt->setText(tstr);
          _freesafe(tstr);
        } else if(msg->button.button==redl) {
          if(labelindex>=0) {
            int val=0;
            sscanf(redsg->getText(),"%d",&val);
            if(val>0) val--;
            tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
            sprintf(tstr,"%d",val);
            redsg->setText(tstr);
            _freesafe(tstr);
            tc1=(WC_Color*)colors->getElementAt(labelindex);
            tc1->setRed( val );
            aguix->changeColor( labelindex, tc1->getRed(), tc1->getGreen(), tc1->getBlue() );
            if(labelindex>3) {
              editcolsb->redraw();
              colbs[labelindex]->redraw();
            } else win->redraw();
          }
        } else if(msg->button.button==redr) {
          if(labelindex>=0) {
            int val=0;
            sscanf(redsg->getText(),"%d",&val);
            if(val<255) val++;
            tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
            sprintf(tstr,"%d",val);
            redsg->setText(tstr);
            _freesafe(tstr);
            tc1=(WC_Color*)colors->getElementAt(labelindex);
            tc1->setRed( val );
            aguix->changeColor( labelindex, tc1->getRed(), tc1->getGreen(), tc1->getBlue() );
            if(labelindex>3) {
              editcolsb->redraw();
              colbs[labelindex]->redraw();
            } else win->redraw();
          }
        } else if(msg->button.button==greenl) {
          if(labelindex>=0) {
            int val=0;
            sscanf(greensg->getText(),"%d",&val);
            if(val>0) val--;
            tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
            sprintf(tstr,"%d",val);
            greensg->setText(tstr);
            _freesafe(tstr);
            tc1=(WC_Color*)colors->getElementAt(labelindex);
            tc1->setGreen( val );
            aguix->changeColor( labelindex, tc1->getRed(), tc1->getGreen(), tc1->getBlue() );
            if(labelindex>3) {
              editcolsb->redraw();
              colbs[labelindex]->redraw();
            } else win->redraw();
          }
        } else if(msg->button.button==greenr) {
          if(labelindex>=0) {
            int val=0;
            sscanf(greensg->getText(),"%d",&val);
            if(val<255) val++;
            tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
            sprintf(tstr,"%d",val);
            greensg->setText(tstr);
            _freesafe(tstr);
            tc1=(WC_Color*)colors->getElementAt(labelindex);
            tc1->setGreen( val );
            aguix->changeColor( labelindex, tc1->getRed(), tc1->getGreen(), tc1->getBlue() );
            if(labelindex>3) {
              editcolsb->redraw();
              colbs[labelindex]->redraw();
            } else win->redraw();
          }
        } else if(msg->button.button==bluel) {
          if(labelindex>=0) {
            int val=0;
            sscanf(bluesg->getText(),"%d",&val);
            if(val>0) val--;
            tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
            sprintf(tstr,"%d",val);
            bluesg->setText(tstr);
            _freesafe(tstr);
            tc1=(WC_Color*)colors->getElementAt(labelindex);
            tc1->setBlue( val );
            aguix->changeColor( labelindex, tc1->getRed(), tc1->getGreen(), tc1->getBlue() );
            if(labelindex>3) {
              editcolsb->redraw();
              colbs[labelindex]->redraw();
            } else win->redraw();
          }
        } else if(msg->button.button==bluer) {
          if(labelindex>=0) {
            int val=0;
            sscanf(bluesg->getText(),"%d",&val);
            if(val<255) val++;
            tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
            sprintf(tstr,"%d",val);
            bluesg->setText(tstr);
            _freesafe(tstr);
            tc1=(WC_Color*)colors->getElementAt(labelindex);
            tc1->setBlue( val );
            aguix->changeColor( labelindex, tc1->getRed(), tc1->getGreen(), tc1->getBlue() );
            if(labelindex>3) {
              editcolsb->redraw();
              colbs[labelindex]->redraw();
            } else win->redraw();
          }
        }
      } else if(msg->type==AG_STRINGGADGET_DEACTIVATE) {
        if(labelindex>=0) {
          if(msg->stringgadget.sg==redsg) {
            int val=0;
            sscanf(redsg->getText(),"%d",&val);
            if(val<0) val=0;
            if(val>255) val=255;
            tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
            sprintf(tstr,"%d",val);
            redsg->setText(tstr);
            _freesafe(tstr);
            tc1=(WC_Color*)colors->getElementAt(labelindex);
            tc1->setRed( val );
            aguix->changeColor( labelindex, tc1->getRed(), tc1->getGreen(), tc1->getBlue() );
            if(labelindex>3) {
              editcolsb->redraw();
              colbs[labelindex]->redraw();
            } else win->redraw();
          } else if(msg->stringgadget.sg==greensg) {
            int val=0;
            sscanf(greensg->getText(),"%d",&val);
            if(val<0) val=0;
            if(val>255) val=255;
            tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
            sprintf(tstr,"%d",val);
            greensg->setText(tstr);
            _freesafe(tstr);
            tc1=(WC_Color*)colors->getElementAt(labelindex);
            tc1->setGreen( val );
            aguix->changeColor( labelindex, tc1->getRed(), tc1->getGreen(), tc1->getBlue() );
            if(labelindex>3) {
              editcolsb->redraw();
              colbs[labelindex]->redraw();
            } else win->redraw();
          } else if(msg->stringgadget.sg==bluesg) {
            int val=0;
            sscanf(bluesg->getText(),"%d",&val);
            if(val<0) val=0;
            if(val>255) val=255;
            tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
            sprintf(tstr,"%d",val);
            bluesg->setText(tstr);
            _freesafe(tstr);
            tc1=(WC_Color*)colors->getElementAt(labelindex);
            tc1->setBlue( val );
            aguix->changeColor( labelindex, tc1->getRed(), tc1->getGreen(), tc1->getBlue() );
            if(labelindex>3) {
              editcolsb->redraw();
              colbs[labelindex]->redraw();
            } else win->redraw();
          }
        } else {
          if(msg->stringgadget.sg==redsg) {
            redsg->setText("");
          } else if(msg->stringgadget.sg==greensg) {
            greensg->setText("");
          } else if(msg->stringgadget.sg==bluesg) {
            bluesg->setText("");
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    // Wiederherstellen
    setColors(twconfig->getColors());
    applyColorList(colors);
  }
  win->close();
  delete win;
  delete twconfig;
  return (ende==-1)?false:true;
}

int WConfig::palette()
{
  return palette(-1);
}

int WConfig::palette(int startcol)
{
  Button *colbs[256];
  AGUIX *aguix=worker->getAGUIX();
  int w,h;
  w=5+256+10+5;
  h=5+256+10+5+aguix->getCharHeight()+4+5;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(45));
  int sx = (int)sqrt( (double)( colors->size() ) );
  if((sx*sx)<colors->size()) sx++;
  int th=256/sx;
  for(int i=0;i<colors->size();i++) {
    colbs[i]=(Button*)win->add(new Button(aguix,
                        10+(i%sx)*th,
                        10+(i/sx)*th,
                        th,
                        th,
                        "",
                        0,
                        i,
                        i+1));
  }
  ((BevelBox*)win->add(new BevelBox(aguix,
                                    5,
                                    5,
                                    256+10,
                                    256+10,
                                    1)))->toBack();
  int t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  int t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  Button *okb=(Button*)win->add(new Button(aguix,
                                           5,
                                           256+20,
                                           t1,
                                           catalog.getLocale(11),
                                           1,
                                           0,
                                           0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                               w-5-t2,
                                               256+20,
                                               t2,
                                               catalog.getLocale(8),
                                               1,
                                               0,
                                               0));  
  SolidButton *editcolsb=(SolidButton*)win->add(new SolidButton(aguix,
                                                5+t1+5,
                                                256+20,
                                                w-5-5-10-t1-t2,
                                                "",
                                                0,
                                                (startcol>=0)?startcol:0,
                                                false));
  win->setDoTabCycling( true );
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0,selcol=(startcol>=0)?startcol:-1;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button->getData()>0) {
          // ein Eintrag wurde ausgewhlt
          selcol=msg->button.button->getData()-1;
          editcolsb->setBG(selcol);
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  win->close();
  delete win;
  return (ende==-1)?-1:selcol;
}

bool WConfig::changeLanguage()
{
  worker_struct_dirent *namelist;
  DIR *dir2;
  bool ok;
  AGUIX *aguix=worker->getAGUIX();
  char *tstr;
  std::string catdir;
  int w,h;
  int trow;
  
  w=300;
  h=200;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(9));
  FieldListView *lv = (FieldListView*)win->add( new FieldListView( aguix,
                                                                   5,
                                                                   5,
                                                                   w - 10,
                                                                   h - 5 - aguix->getCharHeight() - 2 - 10,
                                                                   0 ) );
  lv->setHBarState(2);
  lv->setVBarState(2);
  trow = lv->addRow();
  lv->setText( trow, 0, catalog.getLocale(10) );
  lv->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
  lv->setData( trow, 0 );
  int x=1;
  if ( ( strcmp( lang, "builtin" ) == 0 ) || ( strlen( lang ) < 1 ) ) lv->setActiveRow( trow );
  if ( Worker::getDataDir().length() > 0 ) {
    catdir = Worker::getDataDir();
    catdir += "/catalogs";
    dir2 = opendir( catdir.c_str() );
    if(dir2!=NULL) {
      while ( ( namelist = worker_readdir( dir2 ) ) != NULL ) {
        if(strlen(namelist->d_name)>8) {
          if(strcmp(".catalog",(namelist->d_name)+strlen(namelist->d_name)-8)==0) {
            // Dies ist ein Katalog
            tstr=namelist->d_name;
            tstr[strlen(tstr)-8]=0;
            trow = lv->addRow();
            lv->setText( trow, 0, tstr );
            lv->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
            lv->setData( trow, x++ );
            if ( strcmp( lang, tstr ) == 0 ) lv->setActiveRow( trow );
          }
        }
      }
      closedir(dir2);
    }
  }
  catdir = home;
  catdir += "/catalogs";
  dir2 = opendir( catdir.c_str() );
  if(dir2!=NULL) {
    while ( ( namelist = worker_readdir( dir2 ) ) != NULL ) {
      if(strlen(namelist->d_name)>8) {
        if(strcmp(".catalog",(namelist->d_name)+strlen(namelist->d_name)-8)==0) {
          // Dies ist ein Katalog
          tstr=namelist->d_name;
          tstr[strlen(tstr)-8]=0;
          trow = 1;
          while ( lv->isValidRow( trow ) == true ) {
            if ( strcmp( lv->getText( trow, 0 ).c_str(), tstr ) == 0 ) break;
            trow++;
          }
          if ( lv->isValidRow( trow ) == false ) {
            // only add if it doesn't have already is inserted
            trow = lv->addRow();
            lv->setText( trow, 0, tstr );
            lv->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
            lv->setData( trow, x++ );
            if ( strcmp( lang, tstr ) == 0 ) lv->setActiveRow( trow );
          }
        }
      }
    }
    closedir(dir2);
  }
  lv->redraw();

  int t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  int t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  Button *okb=(Button*)win->add(new Button(aguix,
                                           5,
                                           h-5-aguix->getCharHeight()-2,
                                           t1,
                                           catalog.getLocale(11),
                                           1,
                                           0,
                                           0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                               w-5-t2,
                                               h-5-aguix->getCharHeight()-2,
                                               t2,
                                               catalog.getLocale(8),
                                               1,
                                               0,
                                               0));
  win->setDoTabCycling( true );
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
      }
      aguix->ReplyMessage(msg);
    }
  }
  ok=false;
  if(ende==1) {
    trow = lv->getActiveRow();
    if ( lv->isValidRow( trow ) == true ) {
      if ( strcmp( lv->getText( trow, 0 ).c_str(), catalog.getLocale( 10 ) ) == 0 ) setLang( "builtin" );
      else setLang( lv->getText( trow, 0 ).c_str() );
      Requester *req=new Requester(aguix);
      req->request(catalog.getLocale(124),catalog.getLocale(234),catalog.getLocale(11));
      delete req;
      ok=true;
    }
  }
  win->close();
  delete win;
  return ok;
}

void WConfig::applyColorList(List *cols)
{
  AGUIX *aguix=worker->getAGUIX();
  while(aguix->getMaxCols()>0) aguix->removeLastColor();
  int id=cols->initEnum();
  WC_Color *tc1=(WC_Color*)cols->getFirstElement();
  while(tc1!=NULL) {
    if ( aguix->AddColor( tc1->getRed(), tc1->getGreen(), tc1->getBlue() ) < 0 ) {
      fprintf( stderr, "Worker: Can't allocate color %d,%d,%d!\n", tc1->getRed(), tc1->getGreen(), tc1->getBlue() );
    }
    tc1=(WC_Color*)cols->getNextElement();
  }
  cols->closeEnum(id);
}

bool WConfig::changeFileSets()
{
  WConfig *twconfig = duplicate();
  char tstr[ A_BYTESFORNUMBER( int ) ];
  AGUIX *aguix = worker->getAGUIX();
  AWindow *win = new AWindow( aguix );
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  const int cmwmh = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW;
  AGMessage *msg;
  int ende;
  
  win->create( NULL, 10, 10, 100, 100, 0, catalog.getLocale( 16 ) ); // Groesse wird spaeter angepasst
  
  // global container 1x3
  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 2 ), true );
  ac1->setMaxSpace( 5 );
  ac1->setBorderWidth( 5 );

  // sub container 2x2 for lister config
  AContainer *ac2 = ac1->add( new AContainer( win, 2, 2 ), 0, 0 );
  ac2->setMaxSpace( 5 );
  ac2->setBorderWidth( 0 );
  
  ac2->add( new Text( aguix, 0, 0, catalog.getLocale( 19 ), 1 ), 0, 0, cincwnr );
  ac2->add( new Text( aguix, 0, 0, catalog.getLocale( 20 ), 1 ), 1, 0, cincwnr );

  AContainerBB *ac21 = (AContainerBB*)ac2->add( new AContainerBB( win, 1, 7 ), 0, 1 );
  AContainerBB *ac22 = (AContainerBB*)ac2->add( new AContainerBB( win, 1, 7 ), 1, 1 );
  
  ac21->setMaxSpace( 5 );
  ac22->setMaxSpace( 5 );
  
  FieldListView *lv1 = (FieldListView*)ac21->add( new FieldListView( aguix,
                                                                     0,
                                                                     0,
                                                                     100,
                                                                     80,
                                                                     0 ), 0, 0, cmwmh );
  ac21->add( new Text( aguix, 0, 0, catalog.getLocale( 21 ), 1 ), 0, 1, cincwnr );

  AContainer *ac21a = ac21->add( new AContainer( win, 1, 2 ), 0, 2 );
  ac21a->setMaxSpace( 5 );

  ChooseButton *cb1 = (ChooseButton*)ac21a->add( new ChooseButton( aguix,
                                                                   0,
                                                                   0,
                                                                   20,
                                                                   20,
                                                                   ( hbar_top[0] == true ) ? 1 : 0,
                                                                   catalog.getLocale( 22 ),
                                                                   LABEL_LEFT,
                                                                   1,
                                                                   0 ), 0, 0, cincwnr );
  AContainer *ac211 = ac21a->add( new AContainer( win, 2, 1 ), 0, 1 );
  ac211->add( new Text( aguix, 0, 0, catalog.getLocale( 23 ), 1 ), 0, 0, cfix );
  sprintf( tstr, "%d", (int)hbar_height[0] );
  StringGadget *sg1 = (StringGadget*)ac211->add( new StringGadget( aguix,
                                                                   0,
                                                                   0,
                                                                   50,
                                                                   tstr,
                                                                   0 ), 1, 0, cincw );
  ac211->setBorderWidth( 0 );
  ac211->setMaxSpace( 5 );

  ac21->add( new Text( aguix, 0, 0, catalog.getLocale( 24 ), 1 ), 0, 3, cincwnr );

  AContainer *ac21b = ac21->add( new AContainer( win, 1, 2 ), 0, 4 );
  ac21b->setMaxSpace( 5 );

  ChooseButton *cb2 = (ChooseButton*)ac21b->add( new ChooseButton( aguix,
                                                                   0,
                                                                   0,
                                                                   20,
                                                                   20,
                                                                   ( vbar_left[0] == true ) ? 1 : 0,
                                                                   catalog.getLocale( 25 ),
                                                                   LABEL_LEFT,
                                                                   1,
                                                                   0 ), 0, 0, cincwnr );
  AContainer *ac212 = ac21b->add( new AContainer( win, 2, 1 ), 0, 1 );
  ac212->add( new Text( aguix, 0, 0, catalog.getLocale( 26 ), 1 ), 0, 0, cfix );
  sprintf( tstr, "%d", (int)vbar_width[0] );
  StringGadget *sg2 = (StringGadget*)ac212->add( new StringGadget( aguix,
                                                                   0,
                                                                   0,
                                                                   50,
                                                                   tstr,
                                                                   0 ), 1, 0, cincw );
  ac212->setBorderWidth( 0 );
  ac212->setMaxSpace( 5 );

  ChooseButton *cb13 = (ChooseButton*)ac21->add( new ChooseButton( aguix,
                                                                   0,
                                                                   0,
                                                                   20,
                                                                   20,
                                                                   ( showHeader[0] == true ) ? 1 : 0,
                                                                   catalog.getLocale( 554 ),
                                                                   LABEL_LEFT,
                                                                   1,
                                                                   0 ), 0, 5, cincwnr );
  Button *dis1 = (Button*)ac21->add( new Button( aguix,
                                                 0,
                                                 0,
                                                 catalog.getLocale( 235 ),
                                                 1,
                                                 0,
                                                 0 ), 0, 6, cincw );

  FieldListView *lv2 = (FieldListView*)ac22->add( new FieldListView( aguix,
                                                                     0,
                                                                     0,
                                                                     100,
                                                                     80,
                                                                     0 ), 0, 0, cmwmh );
  ac22->add( new Text( aguix, 0, 0, catalog.getLocale( 21 ), 1 ), 0, 1, cincwnr );

  AContainer *ac22a = ac22->add( new AContainer( win, 1, 2 ), 0, 2 );
  ac22a->setMaxSpace( 5 );

  ChooseButton *cb3 = (ChooseButton*)ac22a->add( new ChooseButton( aguix,
                                                                   0,
                                                                   0,
                                                                   20,
                                                                   20,
                                                                   ( hbar_top[1] == true ) ? 1 : 0,
                                                                   catalog.getLocale( 22 ),
                                                                   LABEL_LEFT,
                                                                   1,
                                                                   0 ), 0, 0, cincwnr );
  AContainer *ac221 = ac22a->add( new AContainer( win, 2, 1 ), 0, 1 );
  ac221->add( new Text( aguix, 0, 0, catalog.getLocale( 23 ), 1 ), 0, 0, cfix );
  sprintf( tstr, "%d", (int)hbar_height[1] );
  StringGadget *sg3 = (StringGadget*)ac221->add( new StringGadget( aguix,
                                                                   0,
                                                                   0,
                                                                   50,
                                                                   tstr,
                                                                   0 ), 1, 0, cincw );
  ac221->setBorderWidth( 0 );
  ac221->setMaxSpace( 5 );

  ac22->add( new Text( aguix, 0, 0, catalog.getLocale( 24 ), 1 ), 0, 3, cincwnr );

  AContainer *ac22b = ac22->add( new AContainer( win, 1, 2 ), 0, 4 );
  ac22b->setMaxSpace( 5 );

  ChooseButton *cb4 = (ChooseButton*)ac22b->add( new ChooseButton( aguix,
                                                                   0,
                                                                   0,
                                                                   20,
                                                                   20,
                                                                   ( vbar_left[1] == true ) ? 1 : 0,
                                                                   catalog.getLocale( 25 ),
                                                                   LABEL_LEFT,
                                                                   1,
                                                                   0 ), 0, 0, cincwnr );
  AContainer *ac222 = ac22b->add( new AContainer( win, 2, 1 ), 0, 1 );
  ac222->add( new Text( aguix, 0, 0, catalog.getLocale( 26 ), 1 ), 0, 0, cfix );
  sprintf( tstr, "%d", (int)vbar_width[1] );
  StringGadget *sg4 = (StringGadget*)ac222->add( new StringGadget( aguix,
                                                                   0,
                                                                   0,
                                                                   50,
                                                                   tstr,
                                                                   0 ), 1, 0, cincw );
  ac222->setBorderWidth( 0 );
  ac222->setMaxSpace( 5 );

  ChooseButton *cb23 = (ChooseButton*)ac22->add( new ChooseButton( aguix,
                                                                   0,
                                                                   0,
                                                                   20,
                                                                   20,
                                                                   ( showHeader[1] == true ) ? 1 : 0,
                                                                   catalog.getLocale( 554 ),
                                                                   LABEL_LEFT,
                                                                   1,
                                                                   0 ), 0, 5, cincwnr );
  Button *dis2 = (Button*)ac22->add( new Button( aguix,
                                                 0,
                                                 0,
                                                 catalog.getLocale( 235 ),
                                                 1,
                                                 0,
                                                 0 ), 0, 6, cincw );

  // sub container 1x2 for ok/cancel
  AContainer *ac3 = ac1->add( new AContainer( win, 2, 1 ), 0, 1 );
  ac3->setBorderWidth( 0 );
  Button *okb = (Button*)ac3->add( new Button( aguix,
                                               0,
                                               0,
                                               catalog.getLocale( 11 ),
                                               1,
                                               0,
                                               0 ), 0, 0, cincw );
  Button *cancelb = (Button*)ac3->add( new Button( aguix,
                                                   0,
                                                   0,
                                                   catalog.getLocale( 8 ),
                                                   1,
                                                   0,
                                                   0 ), 1, 0, cincw );

  lv1->setHBarState( ( hbar_top[0] == true ) ? 1 : 2 );
  lv1->setVBarState( ( vbar_left[0] == true ) ? 1 : 2 );
  lv1->setHBarHeight( hbar_height[0] );
  lv1->setVBarWidth( vbar_width[0] );
  lv1->setShowHeader( showHeader[0] );
  lv1->setFieldText( 0, "Header" );
  lv1->addRow();
  lv1->setText( 0, 0, "                    " );
  lv1->redraw();

  lv2->setHBarState( ( hbar_top[1] == true ) ? 1 : 2 );
  lv2->setVBarState( ( vbar_left[1] == true ) ? 1 : 2 );
  lv2->setHBarHeight( hbar_height[1] );
  lv2->setVBarWidth( vbar_width[1] );
  lv2->setShowHeader( showHeader[1] );
  lv2->setFieldText( 0, "Header" );
  lv2->addRow();
  lv2->setText( 0, 0, "                    " );
  lv2->redraw();

  win->setDoTabCycling( true );
  win->contMaximize( true );
  win->show();

  while ( ( msg = aguix->GetMessage( NULL ) ) != NULL ) aguix->ReplyMessage( msg );
  ende = 0;
  while ( ende == 0 ) {
    msg = aguix->WaitMessage( win );
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==dis1) {
          win->hide();
          changeDisplaySets(0);
          win->show();
        } else if(msg->button.button==dis2) {
          win->hide();
          changeDisplaySets(1);
          win->show();
        }
      } else if(msg->type==AG_CHOOSECLICKED) {
        if(msg->choose.button==cb1) {
          if(msg->choose.state==true) lv1->setHBarState(1);
          else lv1->setHBarState(2);
        } else if(msg->choose.button==cb2) {
          if(msg->choose.state==true) lv1->setVBarState(1);
          else lv1->setVBarState(2);
        } else if(msg->choose.button==cb3) {
          if(msg->choose.state==true) lv2->setHBarState(1);
          else lv2->setHBarState(2);
        } else if(msg->choose.button==cb4) {
          if(msg->choose.state==true) lv2->setVBarState(1);
          else lv2->setVBarState(2);
        } else if ( msg->choose.button == cb13 ) {
          if ( msg->choose.state == true ) lv1->setShowHeader( true );
          else lv1->setShowHeader( false );
        } else if ( msg->choose.button == cb23 ) {
          if ( msg->choose.state == true ) lv2->setShowHeader( true );
          else lv2->setShowHeader( false );
        }
      } else if(msg->type==AG_STRINGGADGET_DEACTIVATE) {
        int i=0;
        if(msg->stringgadget.sg==sg1) {
          sscanf(sg1->getText(),"%d",&i);
          if(i<5) {
            i=5;
            sprintf(tstr,"%d",i);
            sg1->setText(tstr);
          }
          lv1->setHBarHeight(i);
        } else if(msg->stringgadget.sg==sg2) {
          sscanf(sg2->getText(),"%d",&i);
          if(i<5) {
            i=5;
            sprintf(tstr,"%d",i);
            sg2->setText(tstr);
          }
          lv1->setVBarWidth(i);
        } else if(msg->stringgadget.sg==sg3) {
          sscanf(sg3->getText(),"%d",&i);
          if(i<5) {
            i=5;
            sprintf(tstr,"%d",i);
            sg3->setText(tstr);
          }
          lv2->setHBarHeight(i);
        } else if(msg->stringgadget.sg==sg4) {
          sscanf(sg4->getText(),"%d",&i);
          if(i<5) {
            i=5;
            sprintf(tstr,"%d",i);
            sg4->setText(tstr);
          }
          lv2->setVBarWidth(i);
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    // Wiederherstellen
    setVisCols( 0, twconfig->getVisCols( 0 ) );
    setVisCols( 1, twconfig->getVisCols( 1 ) );
  } else {
    // Werte bernehmen
    setHBarTop(0,cb1->getState());
    setVBarLeft(0,cb2->getState());
    setHBarTop(1,cb3->getState());
    setVBarLeft(1,cb4->getState());
    setShowHeader( 0, cb13->getState() );
    setShowHeader( 1, cb23->getState() );
    int i=0;
    sscanf(sg1->getText(),"%d",&i);
    if(i<5) i=5;
    setHBarHeight(0,i);
    sscanf(sg2->getText(),"%d",&i);
    if(i<5) i=5;
    setVBarWidth(0,i);
    sscanf(sg3->getText(),"%d",&i);
    if(i<5) i=5;
    setHBarHeight(1,i);
    sscanf(sg4->getText(),"%d",&i);
    if(i<5) i=5;
    setVBarWidth(1,i);
  }
  win->close();
  delete win;
  delete twconfig;
  return (ende==-1)?false:true;
}

bool WConfig::changeDisplaySets(int side)
{
  bool *sels;
  AGUIX *aguix=worker->getAGUIX();
  int w,h,tx,ty;
  AWindow *win=new AWindow(aguix);
  unsigned int j, ui;
  int trow;
  
  win->create(NULL,10,10,100,100,0,catalog.getLocale(235));
  w=0;
  h=0;
  tx=5;
  ty=5;
  Text *t1=(Text*)win->add(new Text(aguix,tx,ty,catalog.getLocale(238),1));
  ty=t1->getY()+t1->getHeight()+5;
  int i1=(strlen(catalog.getLocale(236))+2);
  i1*=aguix->getCharWidth();
  int i2=(strlen(catalog.getLocale(237))+2);
  i2*=aguix->getCharWidth();
  if((i1+i2)<100) {
    int x=100-i1-i2;
    i1+=x/2;
    i2+=x/2;
  }
  Button *upb=(Button*)win->add(new Button(aguix,
                                           tx,
                                           ty+100,
                                           i1,
                                           catalog.getLocale(236),
                                           1,
                                           0,
                                           0));
  Button *downb=(Button*)win->add(new Button(aguix,
                                             tx+i1,
                                             ty+100,
                                             i2,
                                             catalog.getLocale(237),
                                             1,
                                             0,
                                             0));
  FieldListView *lv1 = (FieldListView*)win->add( new FieldListView( aguix,
                                                                    tx,
                                                                    ty,
                                                                    i1 + i2,
                                                                    upb->getY() - ty,
                                                                    0 ) );
  lv1->setHBarState(2);
  lv1->setVBarState(2);
  tx=lv1->getX()+lv1->getWidth()+5;

  i1=(strlen(catalog.getLocale(239))+2);
  i1*=aguix->getCharWidth();
  i2=(strlen(catalog.getLocale(240))+2);
  i2*=aguix->getCharWidth();
  int i=(i1>i2)?i1:i2;
  double b=lv1->getHeight()-upb->getHeight();
  b/=3;
  Button *delb=(Button*)win->add(new Button(aguix,
                                            tx,
                                            ty+(int)b,
                                            i,
                                            catalog.getLocale(239),
                                            1,
                                            0,
                                            0));
  Button *insb=(Button*)win->add(new Button(aguix,
                                            tx,
                                            ty+(int)b+delb->getHeight()+(int)b,
                                            i,
                                            catalog.getLocale(240),
                                            1,
                                            0,
                                            0));
  tx+=i+5;
  FieldListView *lv2 = (FieldListView*)win->add(new FieldListView( aguix,
                                                                   tx,
                                                                   ty,
                                                                   lv1->getWidth(),
                                                                   lv1->getHeight() + upb->getHeight(),
                                                                   0 ) );
  lv2->setHBarState(2);
  lv2->setVBarState(2);
  w=lv2->getX()+lv2->getWidth()+5;
  ty=upb->getY()+upb->getHeight()+5;

  i1=(strlen(catalog.getLocale(11))+2);
  i1*=aguix->getCharWidth();
  i2=(strlen(catalog.getLocale(8))+2);
  i2*=aguix->getCharWidth();
  Button *okb=(Button*)win->add(new Button(aguix,
                                           5,
                                           ty,
                                           i1,
                                           catalog.getLocale(11),
                                           1,
                                           0,
                                           0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                               w-5-i2,
                                               ty,
                                               i2,
                                               catalog.getLocale(8),
                                               1,
                                               0,
                                               0));
  h=okb->getY()+okb->getHeight()+5;
  win->setDoTabCycling( true );
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  sels = new bool[WorkerTypes::getAvailListColsSize()];
  for ( j = 0; j < WorkerTypes::getAvailListColsSize(); j++ ) {
    sels[j] = false;
  }
  for ( ui = 0; ui < viscols[side].size(); ui++ ) {
    for ( j = 0; j < WorkerTypes::getAvailListColsSize(); j++ ) {
      if ( WorkerTypes::availListCols[j].type == viscols[side][ui] ) break;
    }
    if ( j < WorkerTypes::getAvailListColsSize() ) {
      trow = lv1->addRow();
      lv1->setText( trow, 0, catalog.getLocale( WorkerTypes::availListCols[j].catalogid ) );
      lv1->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
      sels[j]=true;
    }
  }
  for ( j = 0; j < WorkerTypes::getAvailListColsSize(); j++ ) {
    if ( sels[j] == false ) {
      trow = lv2->addRow();
      lv2->setText( trow, 0, catalog.getLocale( WorkerTypes::availListCols[j].catalogid ) );
      lv2->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
    }
  }
  lv1->redraw();
  lv2->redraw();
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==upb) {
          int trow = lv1->getActiveRow();
          if ( lv1->isValidRow( trow ) == true ) {
            if ( trow > 0) {
              lv1->swapRows( trow, trow - 1 );
              lv1->redraw();
              lv1->showActive();
            }
          }
        } else if(msg->button.button==downb) {
          int trow = lv1->getActiveRow();
          if ( lv1->isValidRow( trow ) == true ) {
            if ( trow < ( lv1->getElements() - 1 ) ) {
              lv1->swapRows( trow, trow + 1 );
              lv1->redraw();
              lv1->showActive();
            }
          }
        } else if(msg->button.button==delb) {
          int trow = lv1->getActiveRow(), trow2, trow3;
          if ( lv1->isValidRow( trow ) == true ) {
            for ( j = 0, i1 = -1; j < WorkerTypes::getAvailListColsSize(); j++ ) {
              if ( strcmp( catalog.getLocale( WorkerTypes::availListCols[j].catalogid ), lv1->getText( trow, 0 ).c_str() ) == 0 ) i1 = (int)j;
            }
            trow2 = 0;
            i2=0;
            int i3;
            while ( lv2->isValidRow( trow2 ) == true ) {
              for ( j = 0, i3 = -1; j < WorkerTypes::getAvailListColsSize(); j++ ) {
                if ( strcmp( catalog.getLocale( WorkerTypes::availListCols[j].catalogid ), lv2->getText( trow2, 0 ).c_str() ) == 0 ) i3 = (int)j;
              }
              if(i3<i1) i2++;
              trow2++;
            }
            trow3 = lv2->addRow();
            lv2->setText( trow3, 0, lv1->getText( trow, 0 ) );
            lv2->setPreColors( trow3, FieldListView::PRECOLOR_ONLYACTIVE );
            lv1->deleteRow( trow );
            lv1->redraw();
            lv2->redraw();
          }
        } else if(msg->button.button==insb) {
          int trow = lv2->getActiveRow(), trow2;
          if ( lv2->isValidRow( trow ) == true ) {
            trow2 = lv1->addRow();
            lv1->setText( trow2, 0, lv2->getText( trow, 0 ) );
            lv1->setPreColors( trow2, FieldListView::PRECOLOR_ONLYACTIVE );
            lv2->deleteRow( trow );
            lv1->redraw();
            lv2->redraw();
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    int trow2;
    trow2 = 0;
    viscols[side].clear();
    while ( lv1->isValidRow( trow2 ) == true ) {
      for ( j = 0; j < WorkerTypes::getAvailListColsSize(); j++ ) {
        if ( strcmp( catalog.getLocale( WorkerTypes::availListCols[j].catalogid ), lv1->getText( trow2, 0 ).c_str() ) == 0 ) {
          viscols[side].push_back( WorkerTypes::availListCols[j].type );
        }
      }
      trow2++;
    }
  }
  win->close();
  delete win;
  delete [] sels;
  return (ende==-1)?false:true;
}

void WConfig::setLang( const char *nlang )
{
  if(lang!=NULL) _freesafe(lang);
  if(nlang==NULL) lang=dupstring("builtin");
  else lang=dupstring(nlang);
}

void WConfig::setTerminalBin(const char *ntb)
{
  if(isCorrectTerminalBin(ntb)==true) {
    if(terminalbin!=NULL) _freesafe(terminalbin);
    if(ntb==NULL) terminalbin=dupstring(TERMINAL_BIN);
    else terminalbin=dupstring(ntb);
  }
}

void WConfig::setRows(unsigned int nrows)
{
  if((nrows<1)||(nrows>10)) return;
  rows=nrows;
  cleanUpPaths();
  cleanUpButtons();
}

void WConfig::setColumns(unsigned int ncols)
{
  if((ncols<1)||(ncols>20)) return;
  columns=ncols;
  cleanUpPaths();
  cleanUpButtons();
}

void WConfig::setCacheSize(unsigned int ncs)
{
  if(ncs<1) return;
  cachesize=ncs;
}

void WConfig::setHBarTop(int index2,bool val)
{
  if((index2<0)||(index2>1)) return;
  hbar_top[index2]=val;
}

void WConfig::setVBarLeft(int index2,bool val)
{
  if((index2<0)||(index2>1)) return;
  vbar_left[index2]=val;
}

void WConfig::setHBarHeight(int index2,unsigned int nh)
{
  if((index2<0)||(index2>1)) return;
  if(nh<5) return;
  hbar_height[index2]=nh;
}

void WConfig::setVBarWidth(int index2,unsigned int nw)
{
  if((index2<0)||(index2>1)) return;
  if(nw<5) return;
  vbar_width[index2]=nw;
}

void WConfig::setVisCols( int side, const std::vector<WorkerTypes::listcol_t> *nv )
{
  if ( ( side < 0 ) || ( side > 1 ) ) return;
  if ( nv == NULL ) return;
  
  viscols[side] = *nv;
}

char *WConfig::getLang()
{
  return lang;
}

char *WConfig::getTerminalBin()
{
  return terminalbin;
}

unsigned int WConfig::getRows()
{
  return rows;
}

unsigned int WConfig::getColumns()
{
  return columns;
}

unsigned int WConfig::getCacheSize()
{
  return cachesize;
}

bool WConfig::getHBarTop(int index2)
{
  if((index2<0)||(index2>1)) return false;
  return hbar_top[index2];
}

bool WConfig::getVBarLeft(int index2)
{
  if((index2<0)||(index2>1)) return false;
  return vbar_left[index2];
}

unsigned int WConfig::getHBarHeight(int index2)
{
  if((index2<0)||(index2>1)) return 10;
  return hbar_height[index2];
}

unsigned int WConfig::getVBarWidth(int index2)
{
  if((index2<0)||(index2>1)) return 10;
  return vbar_width[index2];
}

const std::vector<WorkerTypes::listcol_t> *WConfig::getVisCols( int side ) const
{
  return &( viscols[ ( side == 1 ) ? 1 : 0 ] );
}

void WConfig::clearVisCols( int side )
{
  if ( ( side < 0 ) || ( side > 1 ) ) return;
  
  viscols[side].clear();
}

void WConfig::addListCol( int side, WorkerTypes::listcol_t nv )
{
  unsigned int ui;
  bool found = false;

  if ( ( side < 0 ) || ( side > 1 ) ) return;

  for ( ui = 0; ui < viscols[side].size(); ui++ ) {
    if ( viscols[side][ui] == nv ) {
      found = true;
      break;
    }
  }
  if ( found == false ) {
    viscols[side].push_back( nv );
  }
}

void WConfig::setStatusbar(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  statusbar[index2]=col;
}

void WConfig::setSelLVB(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  sel_lvb[index2]=col;
}

void WConfig::setUnselLVB(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  unsel_lvb[index2]=col;
}

void WConfig::setSelDir(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  sel_dir[index2]=col;
}

void WConfig::setUnselDir(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  unsel_dir[index2]=col;
}

void WConfig::setSelFile(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  sel_file[index2]=col;
}

void WConfig::setUnselFile(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  unsel_file[index2]=col;
}

void WConfig::setSelDirAct(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  sel_dir_act[index2]=col;
}

void WConfig::setUnselDirAct(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  unsel_dir_act[index2]=col;
}

void WConfig::setSelFileAct(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  sel_file_act[index2]=col;
}

void WConfig::setUnselFileAct(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  unsel_file_act[index2]=col;
}

void WConfig::setClockbar(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  clockbar[index2]=col;
}

void WConfig::setRequest(int index2,int col)
{
  if((index2<0)||(index2>1)) return;
  request[index2]=col;
}

void WConfig::setLVHeader( int index2, int col )
{
  if ( ( index2 < 0 ) || ( index2 > 1 ) ) return;
  lvheader[index2] = col;
}

int WConfig::getStatusbar( int index2 ) const
{
  if((index2<0)||(index2>1)) return 0;
  return statusbar[index2];
}

int WConfig::getSelLVB( int index2 ) const
{
  if((index2<0)||(index2>1)) return 0;
  return sel_lvb[index2];
}

int WConfig::getUnselLVB( int index2 ) const
{
  if((index2<0)||(index2>1)) return 0;
  return unsel_lvb[index2];
}

int WConfig::getSelDir( int index2 ) const
{
  if((index2<0)||(index2>1)) return 0;
  return sel_dir[index2];
}

int WConfig::getUnselDir( int index2 ) const
{
  if((index2<0)||(index2>1)) return 0;
  return unsel_dir[index2];
}

int WConfig::getSelFile( int index2 ) const
{
  if((index2<0)||(index2>1)) return 0;
  return sel_file[index2];
}

int WConfig::getUnselFile( int index2 ) const
{
  if((index2<0)||(index2>1)) return 0;
  return unsel_file[index2];
}

int WConfig::getSelDirAct( int index2 ) const
{
  if((index2<0)||(index2>1)) return 0;
  return sel_dir_act[index2];
}

int WConfig::getUnselDirAct( int index2 ) const
{
  if((index2<0)||(index2>1)) return 0;
  return unsel_dir_act[index2];
}

int WConfig::getSelFileAct( int index2 ) const
{
  if((index2<0)||(index2>1)) return 0;
  return sel_file_act[index2];
}

int WConfig::getUnselFileAct( int index2 ) const
{
  if((index2<0)||(index2>1)) return 0;
  return unsel_file_act[index2];
}

int WConfig::getClockbar( int index2 ) const
{
  if((index2<0)||(index2>1)) return 0;
  return clockbar[index2];
}

int WConfig::getRequest( int index2 ) const
{
  if((index2<0)||(index2>1)) return 0;
  return request[index2];
}

int WConfig::getLVHeader( int index2 ) const
{
  if ( ( index2 < 0 ) || ( index2 > 1 ) ) return 0;
  return lvheader[index2];
}

void WConfig::setStartDir(int index2,const char *ndir)
{
  if((index2<0)||(index2>1)) return;
  if(dir[index2]!=NULL) _freesafe(dir[index2]);
  if(ndir==NULL) dir[index2]=dupstring("");
  else dir[index2]=dupstring(ndir);
}

char *WConfig::getStartDir(int index2)
{
  if((index2<0)||(index2>1)) return NULL;
  return dir[index2];
}

void WConfig::setFont(int index2,const char *nfont)
{
  if((index2<0)||(index2>3)) return;
  if(fonts[index2]!=NULL) _freesafe(fonts[index2]);
  if(nfont==NULL) fonts[index2]=dupstring("");
  else fonts[index2]=dupstring(nfont);
}

char *WConfig::getFont(int index2)
{
  if((index2<0)||(index2>3)) return NULL;
  return fonts[index2];
}

void WConfig::setPaths(List *npaths)
{
  WCPath *tp;
  int id=paths->initEnum();
  tp=(WCPath*)paths->getFirstElement(id);
  while(tp!=NULL) {
    delete tp;
    tp=(WCPath*)paths->getNextElement(id);
  }
  paths->closeEnum(id);
  paths->removeAllElements();
  id=npaths->initEnum();
  tp=(WCPath*)npaths->getFirstElement(id);
  while(tp!=NULL) {
    paths->addElement(tp->duplicate());
    tp=(WCPath*)npaths->getNextElement(id);
  }
  npaths->closeEnum(id);
  cleanUpPaths();
}

List *WConfig::getPaths()
{
  return paths;
}

void WConfig::setFiletypes(List *nfts)
{
  WCFiletype *tft;
  int id=filetypes->initEnum();
  tft=(WCFiletype*)filetypes->getFirstElement(id);
  while(tft!=NULL) {
    delete tft;
    tft=(WCFiletype*)filetypes->getNextElement(id);
  }
  filetypes->closeEnum(id);
  filetypes->removeAllElements();
  id=nfts->initEnum();
  tft=(WCFiletype*)nfts->getFirstElement(id);
  while(tft!=NULL) {
    filetypes->addElement(tft->duplicate());
    tft=(WCFiletype*)nfts->getNextElement(id);
  }
  nfts->closeEnum(id);
  
  /* clear special type pointers for fast lookup
   * I could do initFixTypes
   * but this is not so good for importing because
   * there would be always the fixtypes
   * this method should just take the list and not more
   * all this initFixType-stuff is for worker and not needed
   * in configuration
   * but (TODO) it's better code when this pointers are always
   * correct */
  notyettype = NULL;
  unknowntype = NULL;
  dirtype = NULL;
  voidtype = NULL;
}

List *WConfig::getFiletypes()
{
  return filetypes;
}

void WConfig::setHotkeys(List *nhks)
{
  WCHotkey *thk;
  int id=hotkeys->initEnum();
  thk=(WCHotkey*)hotkeys->getFirstElement(id);
  while(thk!=NULL) {
    delete thk;
    thk=(WCHotkey*)hotkeys->getNextElement(id);
  }
  hotkeys->closeEnum(id);
  hotkeys->removeAllElements();
  id=nhks->initEnum();
  thk=(WCHotkey*)nhks->getFirstElement(id);
  while(thk!=NULL) {
    hotkeys->addElement(thk->duplicate());
    thk=(WCHotkey*)nhks->getNextElement(id);
  }
  nhks->closeEnum(id);
}

List *WConfig::getHotkeys()
{
  return hotkeys;
}

void WConfig::setButtons(List *nbs)
{
  WCButton *tb;
  int id=buttons->initEnum();
  tb=(WCButton*)buttons->getFirstElement(id);
  while(tb!=NULL) {
    delete tb;
    tb=(WCButton*)buttons->getNextElement(id);
  }
  buttons->closeEnum(id);
  buttons->removeAllElements();
  id=nbs->initEnum();
  tb=(WCButton*)nbs->getFirstElement(id);
  while(tb!=NULL) {
    buttons->addElement(tb->duplicate());
    tb=(WCButton*)nbs->getNextElement(id);
  }
  nbs->closeEnum(id);
  cleanUpButtons();
}

List *WConfig::getButtons()
{
  return buttons;
}

void WConfig::cleanUpPaths()
{
  int id=paths->initEnum();
  WCPath *tp=(WCPath*)paths->getLastElement(id);
  while(tp!=NULL) {
    // Alle leeren am Ende entfernen
    if(tp->getCheck()==false) {
      delete tp;
      paths->removeLastElement();
    } else break;
    tp=(WCPath*)paths->getLastElement(id);
  }
  // Und nun noch auf Bankgroesse auffuellen
  paths->closeEnum(id);
  while((((paths->size())%rows)!=0)||(paths->size()==0)) {
    paths->addElement(new WCPath());
  }
}

void WConfig::cleanUpButtons()
{
  int banksize=rows*columns*2;
  int id=buttons->initEnum();
  WCButton *tb=(WCButton*)buttons->getLastElement(id);
  while(tb!=NULL) {
    // Alle leeren am Ende entfernen
    if(tb->getCheck()==false) {
      delete tb;
      buttons->removeLastElement();
    } else break;
    tb=(WCButton*)buttons->getLastElement(id);
  }
  // Und nun noch auf Bankgroesse auffuellen
  buttons->closeEnum(id);
  while((((buttons->size())%banksize)!=0)||(buttons->size()==0)) {
    buttons->addElement(new WCButton());
  }
}

WConfig::WConfig(Worker *tworker)
{
  unsigned int i;
  this->worker=tworker;
  lang=dupstring("");
  terminalbin=dupstring(TERMINAL_BIN);
  rows=1;
  columns=1;
  cachesize=10;
  colors=new List();
  colors->addElement(new WC_Color(160,160,160));
  colors->addElement(new WC_Color(0,0,0));
  colors->addElement(new WC_Color(255,255,255));
  colors->addElement(new WC_Color(0,85,187));
  colors->addElement(new WC_Color(204,34,0));
  colors->addElement(new WC_Color(50,180,20));
  colors->addElement(new WC_Color(119,0,119));
  colors->addElement(new WC_Color(238,170,68));
  hbar_top[0]=false;
  hbar_top[1]=false;
  vbar_left[0]=false;
  vbar_left[1]=true;
  hbar_height[0]=10;
  hbar_height[1]=10;
  vbar_width[0]=10;
  vbar_width[1]=10;
  for ( i = 0; i < 2; i++ ) {
    viscols[i].push_back( WorkerTypes::LISTCOL_PERM );
    viscols[i].push_back( WorkerTypes::LISTCOL_SIZE );
    viscols[i].push_back( WorkerTypes::LISTCOL_NAME );
    viscols[i].push_back( WorkerTypes::LISTCOL_TYPE );
  }
  showHeader[0] = true;
  showHeader[1] = true;
  statusbar[0]=2;
  statusbar[1]=3;
  sel_lvb[0]=2;
  sel_lvb[1]=4;
  unsel_lvb[0]=1;
  unsel_lvb[1]=0;
  sel_dir[0]=2;
  sel_dir[1]=3;
  unsel_dir[0]=3;
  unsel_dir[1]=0;
  sel_file[0]=2;
  sel_file[1]=1;
  unsel_file[0]=1;
  unsel_file[1]=0;
  sel_dir_act[0]=2;
  sel_dir_act[1]=7;
  unsel_dir_act[0]=1;
  unsel_dir_act[1]=7;
  sel_file_act[0]=2;
  sel_file_act[1]=7;
  unsel_file_act[0]=1;
  unsel_file_act[1]=7;
  clockbar[0]=2;
  clockbar[1]=6;
  request[0]=1;
  request[1]=0;
  lvheader[0] = 1;
  lvheader[1] = 0;
  dir[0]=dupstring("");
  dir[1]=dupstring("");
  fonts[0]=dupstring("fixed");
  fonts[1]=dupstring("fixed");
  fonts[2]=dupstring("fixed");
  fonts[3]=dupstring("fixed");
  paths=new List();
  for(i=0;i<rows;i++) {
    paths->addElement(new WCPath());
  }
  filetypes=new List();
  hotkeys=new List();
  buttons=new List();
  for(i=0;i<(rows*columns);i++) {
    buttons->addElement(new WCButton());
    buttons->addElement(new WCButton());
  }
  notyettype=NULL;
  dirtype=NULL;
  voidtype = NULL;
  unknowntype = NULL;
  initFixTypes();
  char *file=(char*)getenv("HOME");
  if(file==NULL) {
    fprintf( stderr, "Worker: There is no HOME-Variable, please set it to your home-directory!\n" );
    fprintf( stderr, "Worker: Cannot continue!\n" );
    // this is a very unusual situation and because I don't know where to store the information
    // in this case I will quit here
    exit ( 20 );
  } else {
    home=(char*)_allocsafe(strlen(file)+1+8);
    strcpy(home,file);
    strcat(home,"/.worker");
  }
  ownerstringtype=0;

  clockbar_mode=CLOCKBAR_MODE_TIMERAM;
  clockbar_updatetime=1;
  clockbar_command=dupstring("");
  dontcheckdirs=new List();
  
  listerbg=0;
  
  showStringForDirSize=false;
  stringForDirSize=dupstring("<DIR>");
  stringForDirSizeLen=strlen(stringForDirSize);
  
  setDateFormat( 0 );
  date_formatstring = dupstring( "" );
  setDateFormatString( NULL );
  setDateSubst( true );
  
  setTimeFormat( 0 );
  time_formatstring = dupstring( "" );
  setTimeFormatString( NULL );
  
  setDateBeforeTime( false );

  layoutConf.buttonVert = false;
  layoutConf.listviewVert = false; 
  setDefaultConfig();
  
  configureButtonSize[0] = -1;
  configureButtonSize[1] = -1;
  changeTypesSize[0] = -1;
  changeTypesSize[1] = -1;
  changeHotkeysSize[0] = -1;
  changeHotkeysSize[1] = -1;
  configureFiletypeSize[0] = -1;
  configureFiletypeSize[1] = -1;
  configureHotkeySize[0] = -1;
  configureHotkeySize[1] = -1;
  lastRequestCommand = NULL;

  currentConfigTime = 0;
}

WConfig::~WConfig()
{
  if(lang!=NULL) _freesafe(lang);
  if(terminalbin!=NULL) _freesafe(terminalbin);
  int id=colors->initEnum();
  WC_Color *tcol=(WC_Color*)colors->getFirstElement(id);
  while(tcol!=NULL) {
    delete tcol;
    tcol=(WC_Color*)colors->getNextElement(id);
  }
  colors->closeEnum(id);
  delete colors;
  if(dir[0]!=NULL) _freesafe(dir[0]);
  if(dir[1]!=NULL) _freesafe(dir[1]);
  if(fonts[0]!=NULL) _freesafe(fonts[0]);
  if(fonts[1]!=NULL) _freesafe(fonts[1]);
  if(fonts[2]!=NULL) _freesafe(fonts[2]);
  if(fonts[3]!=NULL) _freesafe(fonts[3]);
  id=paths->initEnum();
  WCPath *tp=(WCPath*)paths->getFirstElement(id);
  while(tp!=NULL) {
    delete tp;
    tp=(WCPath*)paths->getNextElement(id);
  }
  paths->closeEnum(id);
  delete paths;
  id=filetypes->initEnum();
  WCFiletype *tft=(WCFiletype*)filetypes->getFirstElement(id);
  while(tft!=NULL) {
    delete tft;
    tft=(WCFiletype*)filetypes->getNextElement(id);
  }
  filetypes->closeEnum(id);
  delete filetypes;
  id=hotkeys->initEnum();
  WCHotkey *thk=(WCHotkey*)hotkeys->getFirstElement(id);
  while(thk!=NULL) {
    delete thk;
    thk=(WCHotkey*)hotkeys->getNextElement(id);
  }
  hotkeys->closeEnum(id);
  delete hotkeys;
  id=buttons->initEnum();
  WCButton *tb=(WCButton*)buttons->getFirstElement(id);
  while(tb!=NULL) {
    delete tb;
    tb=(WCButton*)buttons->getNextElement(id);
  }
  buttons->closeEnum(id);
  delete buttons;

  if(home!=NULL) _freesafe(home);
  
  _freesafe(clockbar_command);
  id=dontcheckdirs->initEnum();
  char *tstr=(char*)dontcheckdirs->getFirstElement(id);
  while(tstr!=NULL) {
    _freesafe(tstr);
    tstr=(char*)dontcheckdirs->getNextElement(id);
  }
  dontcheckdirs->closeEnum(id);
  delete dontcheckdirs;
  _freesafe(stringForDirSize);
  
  _freesafe( date_formatstring );
  _freesafe( time_formatstring );
  if ( lastRequestCommand != NULL ) _freesafe( lastRequestCommand );
}

WConfig *WConfig::duplicate()
{
  WConfig *twc=new WConfig(worker);
  twc->setLang(lang);
  twc->setTerminalBin(terminalbin);
  twc->setRows(rows);
  twc->setColumns(columns);
  twc->setCacheSize(cachesize);
  twc->setHBarTop(0,hbar_top[0]);
  twc->setHBarTop(1,hbar_top[1]);
  twc->setVBarLeft(0,vbar_left[0]);
  twc->setVBarLeft(1,vbar_left[1]);
  twc->setHBarHeight(0,hbar_height[0]);
  twc->setHBarHeight(1,hbar_height[1]);
  twc->setVBarWidth(0,vbar_width[0]);
  twc->setVBarWidth(1,vbar_width[1]);
  twc->setVisCols( 0, &viscols[0] );
  twc->setVisCols( 1, &viscols[1] );
  twc->setStatusbar(0,statusbar[0]);
  twc->setStatusbar(1,statusbar[1]);
  twc->setSelLVB(0,sel_lvb[0]);
  twc->setSelLVB(1,sel_lvb[1]);
  twc->setUnselLVB(0,unsel_lvb[0]);
  twc->setUnselLVB(1,unsel_lvb[1]);
  twc->setSelDir(0,sel_dir[0]);
  twc->setSelDir(1,sel_dir[1]);
  twc->setUnselDir(0,unsel_dir[0]);
  twc->setUnselDir(1,unsel_dir[1]);
  twc->setSelFile(0,sel_file[0]);
  twc->setSelFile(1,sel_file[1]);
  twc->setUnselFile(0,unsel_file[0]);
  twc->setUnselFile(1,unsel_file[1]);
  twc->setSelDirAct(0,sel_dir_act[0]);
  twc->setSelDirAct(1,sel_dir_act[1]);
  twc->setUnselDirAct(0,unsel_dir_act[0]);
  twc->setUnselDirAct(1,unsel_dir_act[1]);
  twc->setSelFileAct(0,sel_file_act[0]);
  twc->setSelFileAct(1,sel_file_act[1]);
  twc->setUnselFileAct(0,unsel_file_act[0]);
  twc->setUnselFileAct(1,unsel_file_act[1]);
  twc->setClockbar(0,clockbar[0]);
  twc->setClockbar(1,clockbar[1]);
  twc->setRequest(0,request[0]);
  twc->setRequest(1,request[1]);
  twc->setLVHeader( 0, lvheader[0] );
  twc->setLVHeader( 1, lvheader[1] );
  twc->setStartDir(0,dir[0]);
  twc->setStartDir(1,dir[1]);
  twc->setFont(0,fonts[0]);
  twc->setFont(1,fonts[1]);
  twc->setFont(2,fonts[2]);
  twc->setFont(3,fonts[3]);
  twc->setPaths(paths);
  twc->setFiletypes(filetypes);
  twc->setHotkeys(hotkeys);
  twc->setButtons(buttons);
  twc->setColors(colors);
  twc->setOwnerstringtype(ownerstringtype);
  twc->setClockbarMode(clockbar_mode);
  twc->setClockbarUpdatetime(clockbar_updatetime);
  twc->setClockbarCommand(clockbar_command);
  twc->setDontCheckDirs(dontcheckdirs);
  twc->setListerBG(listerbg);
  twc->setShowStringForDirSize(showStringForDirSize);
  twc->setStringForDirSize(stringForDirSize);
  
  twc->setDateFormat( date_format );
  twc->setDateFormatString( date_formatstring );
  twc->setDateSubst( date_subst );
  twc->setTimeFormat( time_format );
  twc->setTimeFormatString( time_formatstring );
  twc->setDateBeforeTime( date_before_time );
  
  twc->setShowHeader( 0, showHeader[0] );
  twc->setShowHeader( 1, showHeader[1] );
  
  twc->setLayoutOrders( getLayoutOrders() );
  twc->setLayoutButtonVert( getLayoutButtonVert() );
  twc->setLayoutListviewVert( getLayoutListviewVert() );
  return twc;
}

void WConfig::setColors(List *ncolors)
{
  WC_Color *tc;
  int id=colors->initEnum();
  tc=(WC_Color*)colors->getFirstElement(id);
  while(tc!=NULL) {
    delete tc;
    tc=(WC_Color*)colors->getNextElement(id);
  }
  colors->closeEnum(id);
  colors->removeAllElements();
  id=ncolors->initEnum();
  tc=(WC_Color*)ncolors->getFirstElement(id);
  while(tc!=NULL) {
    colors->addElement(tc->duplicate());
    tc=(WC_Color*)ncolors->getNextElement(id);
  }
  ncolors->closeEnum(id);
}

List *WConfig::getColors()
{
  return colors;
}

void WConfig::resetColors()
{
  WC_Color *tc;
  int id = colors->initEnum();

  tc = (WC_Color*)colors->getFirstElement( id );
  while ( tc != NULL ) {
    delete tc;
    tc = (WC_Color*)colors->getNextElement( id );
  }
  colors->closeEnum( id );
  colors->removeAllElements();
  colors->addElement( new WC_Color( 160, 160, 160 ) );
  colors->addElement( new WC_Color( 0, 0, 0 ) );
  colors->addElement( new WC_Color( 255, 255, 255 ) );
  colors->addElement( new WC_Color( 0, 85, 187 ) );
  colors->addElement( new WC_Color( 204, 34, 0 ) );
  colors->addElement( new WC_Color( 50, 180, 20 ) );
  colors->addElement( new WC_Color( 119, 0, 119 ) );
  colors->addElement( new WC_Color( 238, 170, 68 ) );
}

void WConfig::setColor( int nr, int red, int green, int blue )
{
  WC_Color *tc;

  if ( ( nr < 0 ) || ( nr > 255 ) ) return;
  while ( colors->size() < ( nr + 1 ) ) colors->addElement( new WC_Color() );
  tc = (WC_Color*)colors->getElementAt( nr );
  if ( tc != NULL ) {
    tc->setRed( red );
    tc->setGreen( green );
    tc->setBlue( blue );
  }
}

/**************************************
 Definition WCButton
**************************************/

WCButton::WCButton()
{
  text=dupstring("");
  fg=1;
  bg=0;
  com=new List();
  check=false;
  flags=new WCGlobalFlags();
}

WCButton::~WCButton()
{
  if(text!=NULL) _freesafe(text);
  freecoms(com);
  delete com;
  delete flags;
}

WCButton *WCButton::duplicate()
{
  WCButton *tbut=new WCButton();
  tbut->setText(text);
  tbut->setFG(fg);
  tbut->setBG(bg);
  tbut->setComs(com);
  tbut->setCheck(check);
  tbut->setComsGF(flags);
  tbut->setDoubleKeys( dkeys );
  return tbut;
}

void WCButton::setText(const char *ntext)
{
  if(text!=NULL) _freesafe(text);
  if(ntext==NULL) {
    text=dupstring("");
  } else {
    text=dupstring(ntext);
  }
}

void WCButton::setFG(int nfg)
{
  fg=nfg;
}

void WCButton::setBG(int nbg)
{
  bg=nbg;
}

char *WCButton::getText()
{
  return text;
}

int WCButton::getFG()
{
  return fg;
}

int WCButton::getBG()
{
  return bg;
}

List *WCButton::getComs()
{
  return com;
}

void WCButton::setComs(List *ncom)
{
  freecoms(com);
  FunctionProto *fp;
  int id=ncom->initEnum();
  fp=(FunctionProto*)ncom->getFirstElement(id);
  while(fp!=NULL) {
    com->addElement(fp->duplicate());
    fp=(FunctionProto*)ncom->getNextElement(id);
  }
  com->closeEnum(id);  
}

void WCButton::addCom( const FunctionProto *fp )
{
  if ( fp == NULL ) return;
  com->addElement( fp->duplicate() );
}

void WCButton::setCheck(bool ncheck)
{
  check=ncheck;
}

bool WCButton::getCheck()
{
  return check;
}

WCGlobalFlags *WCButton::getComsGF()
{
  return flags;
}

void WCButton::setComsGF(WCGlobalFlags *nf)
{
  if(nf==NULL) flags->setFlags(0);
  else flags->setFlags(nf->getFlags());
}

/**************************************
 Ende Definition WCButton
**************************************/

void freecoms(List *com)
{
  FunctionProto *fp;
  int id=com->initEnum();
  fp=(FunctionProto*)com->getFirstElement(id);
  while(fp!=NULL) {
    delete fp;
    fp=(FunctionProto*)com->getNextElement(id);
  }
  com->removeAllElements();
  com->closeEnum(id);
}

/**************************************
 Definition WCHotkey
**************************************/

WCHotkey::WCHotkey()
{
  name=dupstring("");
  key=new WCShortkey();
  com=new List();
  flags=new WCGlobalFlags();
}

WCHotkey::~WCHotkey()
{
  if(name!=NULL) _freesafe(name);
  delete key;
  freecoms(com);
  delete com;
  delete flags;
}

WCHotkey *WCHotkey::duplicate()
{
  WCHotkey *thot=new WCHotkey();
  thot->setName(name);
  thot->setKey(key);
  thot->setComs(com);
  thot->setComsGF(flags);
  thot->setDoubleKeys( dkeys );
  return thot;
}

void WCHotkey::setName(const char *nname)
{
  if(name!=NULL) _freesafe(name);
  if(nname==NULL) {
    name=dupstring("");
  } else {
    name=dupstring(nname);
  }
}

char *WCHotkey::getName()
{
  return name;
}

WCShortkey *WCHotkey::getKey()
{
  return key;
}

List *WCHotkey::getComs()
{
  return com;
}

void WCHotkey::setKey(WCShortkey *nkey)
{
  if(key!=NULL) delete key;
  if(nkey==NULL) {
    key=new WCShortkey();
  } else {
    key=nkey->duplicate();
  }
}

void WCHotkey::setComs(List *ncom)
{
  freecoms(com);
  FunctionProto *fp;
  int id=ncom->initEnum();
  fp=(FunctionProto*)ncom->getFirstElement(id);
  while(fp!=NULL) {
    com->addElement(fp->duplicate());
    fp=(FunctionProto*)ncom->getNextElement(id);
  }
  com->closeEnum(id);  
}

void WCHotkey::addCom( const FunctionProto *fp )
{
  if ( fp == NULL ) return;
  com->addElement( fp->duplicate() );
}

WCGlobalFlags *WCHotkey::getComsGF()
{
  return flags;
}

void WCHotkey::setComsGF(WCGlobalFlags *nf)
{
  if(nf==NULL) flags->setFlags(0);
  else flags->setFlags(nf->getFlags());
}

/**************************************
 Ende Definition WCHotkey
**************************************/

/**************************************
 Definition WCPath
**************************************/

WCPath::WCPath()
{
  name=dupstring("");
  path=dupstring("");
  fg=1;
  bg=0;
  check=false;
}

WCPath::~WCPath()
{
  if(name!=NULL) _freesafe(name);
  if(path!=NULL) _freesafe(path);
}

WCPath *WCPath::duplicate()
{
  WCPath *tpath=new WCPath();
  tpath->setName(name);
  tpath->setPath(path);
  tpath->setFG(fg);
  tpath->setBG(bg);
  tpath->setCheck(check);
  tpath->setDoubleKeys( dkeys );
  return tpath;
}

void WCPath::setName(const char *nname)
{
  if(name!=NULL) _freesafe(name);
  if(nname==NULL) {
    name=dupstring("");
  } else {
    name=dupstring(nname);
  }
}

void WCPath::setPath(const char *npath)
{
  if(path!=NULL) _freesafe(path);
  if(npath==NULL) {
    path=dupstring("");
  } else {
    path=dupstring(npath);
  }
}

void WCPath::setFG(int nfg)
{
  fg=nfg;
}

void WCPath::setBG(int nbg)
{
  bg=nbg;
}

char *WCPath::getName()
{
  return name;
}

char *WCPath::getPath()
{
  return path;
}

int WCPath::getFG()
{
  return fg;
}

int WCPath::getBG()
{
  return bg;
}

void WCPath::setCheck(bool ncheck)
{
  check=ncheck;
}

bool WCPath::getCheck()
{
  return check;
}

bool WCPath::configure(AGUIX *aguix)
{
  return false;
}

/**************************************
 Ende Definition WCPath
**************************************/

/**************************************
 Definition WCFiletype
**************************************/

WCFiletype::WCFiletype()
{
  int i;
  name=dupstring("");
  namelen=0;
  pattern=dupstring("");
  usepattern=false;
  usefiledesc=false;
  for(i=1;i<64;i++) filedesc[i]=-1;
  filedesc[0]=-2;
  dndaction=new List();
  doubleclickaction=new List();
  showaction=new List();
  rawshowaction=new List();
  for(i=0;i<10;i++) useraction[i]=new List();
  dndactiongf=new WCGlobalFlags();
  doubleclickactiongf=new WCGlobalFlags();
  showactiongf=new WCGlobalFlags();
  rawshowactiongf=new WCGlobalFlags();
  for(i=0;i<10;i++) useractiongf[i]=new WCGlobalFlags();
  internID = NORMALTYPE;

  usefileexp = false;
  fileexp = dupstring( "" );
#if 0  // for filetype checking with file
  regex_compiled = false;
#endif

  patternIgnoreCase = false;
  patternUseRegExp = false;
  patternUseFullname = false;
#ifdef HAVE_REGEX
  patternRegCompiled = false;
#endif
}

int WCFiletype::getinternID()
{
  return internID;
}

void WCFiletype::setinternID(int newid)
{
  if((newid<NORMALTYPE)||(newid>DIRTYPE)) return;
  internID=newid;
}

WCFiletype::~WCFiletype()
{
  int i;
  if(name!=NULL) _freesafe(name);

#ifdef HAVE_REGEX
  freeCompPatternReg();
#endif
  if(pattern!=NULL) _freesafe(pattern);
  freecoms(dndaction);
  freecoms(doubleclickaction);
  freecoms(showaction);
  freecoms(rawshowaction);
  for(i=0;i<10;i++) freecoms(useraction[i]);
  delete dndaction;
  delete doubleclickaction;
  delete showaction;
  delete rawshowaction;
  for(i=0;i<10;i++) delete useraction[i];
  delete dndactiongf;
  delete doubleclickactiongf;
  delete showactiongf;
  delete rawshowactiongf;
  for(i=0;i<10;i++) delete useractiongf[i];

#if 0  // for filetype checking with file
  free_compexp();
#endif
  _freesafe( fileexp );
}

WCFiletype *WCFiletype::duplicate()
{
  int i;
  WCFiletype *tft=new WCFiletype();
  tft->setName(name);
  tft->setPattern(pattern);
  tft->setUsePattern(usepattern);
  tft->setFiledesc(filedesc);
  tft->setUseFiledesc(usefiledesc);
  tft->setDNDActions(dndaction);
  tft->setDoubleClickActions(doubleclickaction);
  tft->setShowActions(showaction);
  tft->setRawShowActions(rawshowaction);
  for(i=0;i<10;i++) tft->setUserActions(i,useraction[i]);
  tft->setDNDActionsGF(dndactiongf);
  tft->setDoubleClickActionsGF(doubleclickactiongf);
  tft->setShowActionsGF(showactiongf);
  tft->setRawShowActionsGF(rawshowactiongf);
  for(i=0;i<10;i++) tft->setUserActionsGF(i,useractiongf[i]);
  tft->setinternID(internID);
  tft->setUseFileExp( usefileexp );
  tft->setFileExp( fileexp );
  tft->setPatternIgnoreCase( patternIgnoreCase );
  tft->setPatternUseRegExp( patternUseRegExp );
  tft->setPatternUseFullname( patternUseFullname );
  
  return tft;
}

void WCFiletype::setName(const char *nname)
{
  if(name!=NULL) _freesafe(name);
  if(nname==NULL) {
    name=dupstring("");
    namelen=0;
  } else {
    name=dupstring(nname);
    namelen=strlen(name);
  }
}

void WCFiletype::setPattern(const char *npattern)
{
  if(pattern!=NULL) _freesafe(pattern);
#ifdef HAVE_REGEX
  freeCompPatternReg();
#endif
  if(npattern==NULL) {
    pattern=dupstring("");
  } else {
    pattern=dupstring(npattern);
  }
}

char *WCFiletype::getName()
{
  return name;
}

char *WCFiletype::getPattern()
{
  return pattern;
}

void WCFiletype::setUsePattern(bool nup)
{
  usepattern=nup;
}

bool WCFiletype::getUsePattern()
{
  return usepattern;
}

void WCFiletype::setUseFiledesc(bool nufd)
{
  usefiledesc=nufd;
}

bool WCFiletype::getUseFiledesc()
{
  return usefiledesc;
}

void WCFiletype::setFiledesc(short *nfd)
{
  for(int i=0;i<64;i++) filedesc[i]=nfd[i];
}

short *WCFiletype::getFiledesc()
{
  return filedesc;
}

List *WCFiletype::getDNDActions()
{
  return dndaction;
}

List *WCFiletype::getDoubleClickActions()
{
  return doubleclickaction;
}

List *WCFiletype::getShowActions()
{
  return showaction;
}

List *WCFiletype::getRawShowActions()
{
  return rawshowaction;
}

List *WCFiletype::getUserActions(int id)
{
  if((id<0)||(id>9)) return NULL;
  return useraction[id];
}

void WCFiletype::setDNDActions(List *ndnda)
{
  freecoms(dndaction);
  FunctionProto *fp;
  int id=ndnda->initEnum();
  fp=(FunctionProto*)ndnda->getFirstElement(id);
  while(fp!=NULL) {
    dndaction->addElement(fp->duplicate());
    fp=(FunctionProto*)ndnda->getNextElement(id);
  }
  ndnda->closeEnum(id);
}

void WCFiletype::addComDNDAction( const FunctionProto *fp )
{
  if ( fp == NULL ) return;
  dndaction->addElement( fp->duplicate() );
}

void WCFiletype::setDoubleClickActions(List *ndca)
{
  freecoms(doubleclickaction);
  FunctionProto *fp;
  int id=ndca->initEnum();
  fp=(FunctionProto*)ndca->getFirstElement(id);
  while(fp!=NULL) {
    doubleclickaction->addElement(fp->duplicate());
    fp=(FunctionProto*)ndca->getNextElement(id);
  }
  ndca->closeEnum(id);
}

void WCFiletype::addComDoubleClickAction( const FunctionProto *fp )
{
  if ( fp == NULL ) return;
  doubleclickaction->addElement( fp->duplicate() );
}

void WCFiletype::setShowActions(List *nsa)
{
  freecoms(showaction);
  FunctionProto *fp;
  int id=nsa->initEnum();
  fp=(FunctionProto*)nsa->getFirstElement(id);
  while(fp!=NULL) {
    showaction->addElement(fp->duplicate());
    fp=(FunctionProto*)nsa->getNextElement(id);
  }
  nsa->closeEnum(id);
}

void WCFiletype::addComShowAction( const FunctionProto *fp )
{
  if ( fp == NULL ) return;
  showaction->addElement( fp->duplicate() );
}

void WCFiletype::setRawShowActions(List *nrsa)
{
  freecoms(rawshowaction);
  FunctionProto *fp;
  int id=nrsa->initEnum();
  fp=(FunctionProto*)nrsa->getFirstElement(id);
  while(fp!=NULL) {
    rawshowaction->addElement(fp->duplicate());
    fp=(FunctionProto*)nrsa->getNextElement(id);
  }
  nrsa->closeEnum(id);
}

void WCFiletype::addComRawShowAction( const FunctionProto *fp )
{
  if ( fp == NULL ) return;
  rawshowaction->addElement( fp->duplicate() );
}

void WCFiletype::setUserActions(int uid,List *nua)
{
  if((uid<0)||(uid>9)) return;
  freecoms(useraction[uid]);
  FunctionProto *fp;
  int id=nua->initEnum();
  fp=(FunctionProto*)nua->getFirstElement(id);
  while(fp!=NULL) {
    useraction[uid]->addElement(fp->duplicate());
    fp=(FunctionProto*)nua->getNextElement(id);
  }
  nua->closeEnum(id);
}

void WCFiletype::addComUserAction( int i, const FunctionProto * fp )
{
  if ( fp == NULL ) return;
  if ( ( i < 0 ) || ( i > 9 ) ) return;
  useraction[i]->addElement( fp->duplicate() );
}

WCGlobalFlags *WCFiletype::getDNDActionsGF()
{
  return dndactiongf;
}

WCGlobalFlags *WCFiletype::getDoubleClickActionsGF()
{
  return doubleclickactiongf;
}

WCGlobalFlags *WCFiletype::getShowActionsGF()
{
  return showactiongf;
}

WCGlobalFlags *WCFiletype::getRawShowActionsGF()
{
  return rawshowactiongf;
}

WCGlobalFlags *WCFiletype::getUserActionsGF(int index2)
{
  if((index2<0)||(index2>9)) return NULL;
  return useractiongf[index2];
}

void WCFiletype::setDNDActionsGF(WCGlobalFlags *nf)
{
  if(nf==NULL) dndactiongf->setFlags(0);
  else dndactiongf->setFlags(nf->getFlags());
}

void WCFiletype::setDoubleClickActionsGF(WCGlobalFlags *nf)
{
  if(nf==NULL) doubleclickactiongf->setFlags(0);
  else doubleclickactiongf->setFlags(nf->getFlags());
}

void WCFiletype::setShowActionsGF(WCGlobalFlags *nf)
{
  if(nf==NULL) showactiongf->setFlags(0);
  else showactiongf->setFlags(nf->getFlags());
}

void WCFiletype::setRawShowActionsGF(WCGlobalFlags *nf)
{
  if(nf==NULL) rawshowactiongf->setFlags(0);
  else rawshowactiongf->setFlags(nf->getFlags());
}

void WCFiletype::setUserActionsGF(int index2,WCGlobalFlags *nf)
{
  if((index2<0)||(index2>9)) return;
  if(nf==NULL) useractiongf[index2]->setFlags(0);
  else useractiongf[index2]->setFlags(nf->getFlags());
}

void WCFiletype::setPatternIgnoreCase( bool nv )
{
#ifdef HAVE_REGEX
  freeCompPatternReg();
#endif
  patternIgnoreCase = nv;
}

bool WCFiletype::getPatternIgnoreCase()
{
  return patternIgnoreCase;
}

void WCFiletype::setPatternUseRegExp( bool nv )
{
  patternUseRegExp = nv;
}

bool WCFiletype::getPatternUseRegExp()
{
  return patternUseRegExp;
}

void WCFiletype::setFileExp( const char* nv )
{
  if ( nv == NULL ) return;
#if 0  // for filetype checking with file
  free_compexp();
#endif
  _freesafe( fileexp );
  fileexp = dupstring( nv );
}

const char *WCFiletype::getFileExp()
{
  return fileexp;
}

void WCFiletype::setUseFileExp( bool nv )
{
  usefileexp = nv;
}

bool WCFiletype::getUseFileExp()
{
  return usefileexp;
}

#if 0  // for filetype checking with file
void WCFiletype::free_compexp()
{
  if ( regex_compiled == true ) {
    regfree( &preg );
    regex_compiled = false;
  }
}

void WCFiletype::compile_exp()
{
  int erg;

  if ( regex_compiled == false ) {
    erg = regcomp( &preg, fileexp, REG_NOSUB );
    if ( erg == 0 ) {
      regex_compiled = true;
    } else {
      // error
    }
  }
}
#endif

//TODO: wenn es regex nicht gibt strstr benutzen
bool WCFiletype::fileExpMatchString( const char *mstr )
{
  bool matched = false;
#if 0  // for filetype checking with file
  int erg;
#endif

  if ( strlen( fileexp ) < 1 ) return false;
  if ( mstr == NULL ) return false;
  if ( strlen( mstr ) < 1 ) return false;
#if 0  // for filetype checking with file
  compile_exp();
  if ( regex_compiled == true ) {
    erg = regexec( &preg, mstr, 0, NULL, 0 );
    if ( erg == 0 ) matched = true;
  }
#endif
  return matched;
}

#ifdef HAVE_REGEX
void WCFiletype::freeCompPatternReg()
{
  if ( patternRegCompiled == true ) {
    regfree( &patternReg );
    patternRegCompiled = false;
  }
}

void WCFiletype::compilePatternReg()
{
  int erg;

  if ( patternRegCompiled == false ) {
    erg = regcomp( &patternReg, pattern, REG_NOSUB | ( ( patternIgnoreCase == true ) ? REG_ICASE : 0 ) );
    if ( erg == 0 ) {
      patternRegCompiled = true;
    } else {
      // error
    }
  }
}
#endif

bool WCFiletype::patternMatchString( const char *mstr )
{
  bool matched = false;
#ifdef HAVE_REGEX
  int erg;
#endif
  char *lstr, *pstr;
  int i;

  if ( strlen( pattern ) < 1 ) return false;
  if ( mstr == NULL ) return false;
  if ( strlen( mstr ) < 1 ) return false;
  
#ifdef HAVE_REGEX
  if ( patternUseRegExp == false ) {
#else
  if ( 1 ) {
#endif
    lstr = dupstring( mstr );
    if ( patternIgnoreCase == true ) {
      for ( i = 0; lstr[i] != '\0'; i++ )
        lstr[i] = tolower( lstr[i] );
    }
    pstr = dupstring( pattern );
    if ( patternIgnoreCase == true ) {
      for ( i = 0; pstr[i] != '\0'; i++ )
        pstr[i] = tolower( pstr[i] );
    }
    
    if ( fnmatch( pstr, lstr, 0 ) == 0 ) matched = true;
    _freesafe( lstr );
    _freesafe( pstr );
  } else {
#ifdef HAVE_REGEX
    compilePatternReg();
    if ( patternRegCompiled == true ) {
      erg = regexec( &patternReg, mstr, 0, NULL, 0 );
      if ( erg == 0 ) matched = true;
    }
#endif
  }
  return matched;
}

int WCFiletype::sortfunction( void *p1, void *p2, int mode )
{
  WCFiletype *ft1, *ft2;
  int erg = 0;
  
  if ( ( p1 == NULL ) || ( p2 == NULL ) ) return 0;
  
  ft1 = (WCFiletype*)p1;
  ft2 = (WCFiletype*)p2;

  switch ( mode ) {
    default:
      erg = strcasecmp( ft1->getName(), ft2->getName() );
      break;
  }

  return erg;
}

void WCFiletype::clearFiledesc()
{
  int i;
  
  for ( i = 1; i < 64; i++ ) filedesc[i] = -1;
  filedesc[0] = -2;
}

void WCFiletype::setFiledesc( int pos, short v )
{
  int i;

  if ( ( pos < 0 ) || ( pos > 63 ) ) return;
  if ( ( v < -2 ) || ( v > 255 ) ) return;
  
  for ( i = 0; i < pos; i++ ) {
    if ( filedesc[i] == -2 ) filedesc[i] = -1;
  }
  filedesc[pos] = v;
  for ( i = 63; i >= 0; i-- ) {
    if ( filedesc[i] >= 0 ) {
      if ( i < 63 ) filedesc[i + 1] = -2;
      break;
    }
  }
  if ( i < 0 ) if ( filedesc[0] < 0 ) filedesc[0] = -2;
}

void WCFiletype::setPatternUseFullname( bool nv )
{
  patternUseFullname = nv;
}

bool WCFiletype::getPatternUseFullname() const
{
  return patternUseFullname;
}

/**************************************
 Ende Definition WCFiletype
**************************************/

/**************************************
 Definition WCShortkey
**************************************/

WCShortkey::WCShortkey()
{
  shortkey=0;
  mod=0;
}

WCShortkey::~WCShortkey()
{
}

WCShortkey *WCShortkey::duplicate()
{
  WCShortkey *tsh=new WCShortkey();
  tsh->setMod(mod);
  tsh->setShortkey(shortkey);
  return tsh;
}

void WCShortkey::setShortkey(KeySym nkey)
{
  shortkey=nkey;
}

void WCShortkey::setMod(unsigned int nmod)
{
  mod=nmod;
}

KeySym WCShortkey::getShortkey()
{
  return shortkey;
}

unsigned int WCShortkey::getMod()
{
  return mod;
}

bool WCShortkey::isShortkey(KeySym tkey,unsigned int tmod)
{
  if((tkey==shortkey)&&(tmod==mod)) return true;
  return false;
}

bool WCShortkey::isReal()
{
  if ( shortkey != 0 ) return true;
  return false;
}

/**************************************
 Ende Definition WCShortkey
**************************************/

/**************************************
 Definition WCDoubleShortkey
**************************************/

WCDoubleShortkey::WCDoubleShortkey()
{
  key[0] = 0;
  key[1] = 0;
  mod[0] = 0;
  mod[1] = 0;
  type = WCDS_NORMAL;
}

WCDoubleShortkey::~WCDoubleShortkey()
{
}

WCDoubleShortkey *WCDoubleShortkey::duplicate() const
{
  WCDoubleShortkey *tsh=new WCDoubleShortkey();
  tsh->setMod( mod[0], 0 );
  tsh->setMod( mod[1], 1 );
  tsh->setKeySym( key[0], 0 );
  tsh->setKeySym( key[1], 1 );
  tsh->setType( type );
  return tsh;
}

void WCDoubleShortkey::setKeySym( KeySym k, int pos )
{
  if ( ( pos < 0 ) || ( pos > 1 ) ) return;
  key[pos] = k;
}

void WCDoubleShortkey::setMod( unsigned int m, int pos )
{
  if ( ( pos < 0 ) || ( pos > 1 ) ) return;
  mod[pos] = m;
}

KeySym WCDoubleShortkey::getKeySym( int pos )
{
  if ( pos != 1 ) return key[0];
  return key[1];
}

unsigned int WCDoubleShortkey::getMod( int pos )
{
  if ( pos != 1 ) return mod[0];
  return mod[1];
}

bool WCDoubleShortkey::isShortkey( KeySym k, unsigned int m )
{
  if ( type == WCDS_DOUBLE ) return false;
  if ( ( k == key[0] ) && ( m == mod[0] ) ) return true;
  return false;
}

bool WCDoubleShortkey::isShortkey( KeySym k1, unsigned int m1, KeySym k2, unsigned int m2 )
{
  if ( type == WCDS_NORMAL ) return false;
  if ( ( k1 == key[0] ) && ( m1 == mod[0] ) &&
       ( k2 == key[1] ) && ( m2 == mod[1] ) ) return true;
  return false;
}

bool WCDoubleShortkey::isReal()
{
  if ( ( type == WCDS_NORMAL ) && ( key[0] != 0 ) ) return true;
  if ( ( type == WCDS_DOUBLE ) && ( key[0] != 0 ) && ( key[1] != 0 ) ) return true;
  return false;
}

void WCDoubleShortkey::setType( enum shortkey_type nv )
{
  type = nv;
}

enum WCDoubleShortkey::shortkey_type WCDoubleShortkey::getType()
{
  return type;
}

bool WCDoubleShortkey::save( Datei *fh )
{
  if ( fh == NULL ) return false;
  char *kstr1, *kstr2;

  kstr1 = AGUIX::getStringForKeySym( key[0] );
  kstr2 = AGUIX::getStringForKeySym( key[1] );

  if ( type == WCDS_DOUBLE ) {
    WConfig::configOpenSection( fh, "double" );
  } else {
    WConfig::configOpenSection( fh, "normal" );
  }
  if ( kstr1 != NULL ) {
    WConfig::configPutPairString( fh, "key", kstr1 );
  } else {
    WConfig::configPutPairString( fh, "key", "NoSymbol" );
  }
  if ( ( mod[0] & ControlMask ) != 0 ) WConfig::configPutPair( fh, "mod", "control" );
  if ( ( mod[0] & ShiftMask ) != 0 ) WConfig::configPutPair( fh, "mod", "shift" );
  if ( ( mod[0] & LockMask ) != 0 ) WConfig::configPutPair( fh, "mod", "lock" );
  if ( ( mod[0] & Mod1Mask ) != 0 ) WConfig::configPutPair( fh, "mod", "mod1" );
  if ( ( mod[0] & Mod2Mask ) != 0 ) WConfig::configPutPair( fh, "mod", "mod2" );
  if ( ( mod[0] & Mod3Mask ) != 0 ) WConfig::configPutPair( fh, "mod", "mod3" );
  if ( ( mod[0] & Mod4Mask ) != 0 ) WConfig::configPutPair( fh, "mod", "mod4" );
  if ( ( mod[0] & Mod5Mask ) != 0 ) WConfig::configPutPair( fh, "mod", "mod5" );

  if ( type == WCDS_DOUBLE ) {
    if ( kstr2 != NULL ) {
      WConfig::configPutPairString( fh, "key", kstr2 );
    } else {
      WConfig::configPutPairString( fh, "key", "NoSymbol" );
    }
    if ( ( mod[1] & ControlMask ) != 0 ) WConfig::configPutPair( fh, "mod", "control" );
    if ( ( mod[1] & ShiftMask ) != 0 ) WConfig::configPutPair( fh, "mod", "shift" );
    if ( ( mod[1] & LockMask ) != 0 ) WConfig::configPutPair( fh, "mod", "lock" );
    if ( ( mod[1] & Mod1Mask ) != 0 ) WConfig::configPutPair( fh, "mod", "mod1" );
    if ( ( mod[1] & Mod2Mask ) != 0 ) WConfig::configPutPair( fh, "mod", "mod2" );
    if ( ( mod[1] & Mod3Mask ) != 0 ) WConfig::configPutPair( fh, "mod", "mod3" );
    if ( ( mod[1] & Mod4Mask ) != 0 ) WConfig::configPutPair( fh, "mod", "mod4" );
    if ( ( mod[1] & Mod5Mask ) != 0 ) WConfig::configPutPair( fh, "mod", "mod5" );
  }

  WConfig::configCloseSection( fh );
  if ( kstr1 != NULL ) _freesafe( kstr1 );
  if ( kstr2 != NULL ) _freesafe( kstr2 );
  return true;
}

/**************************************
 Ende Definition WCDoubleShortkey
**************************************/

/**************************************
 Definition WCGlobalFlags
**************************************/

WCGlobalFlags::WCGlobalFlags()
{
  flags=0;
}

WCGlobalFlags::~WCGlobalFlags()
{
}

WCGlobalFlags *WCGlobalFlags::duplicate()
{
  WCGlobalFlags *tf=new WCGlobalFlags();
  tf->setFlags(flags);
  return tf;
}

unsigned long WCGlobalFlags::getFlags()
{
  return flags;
}

void WCGlobalFlags::setFlags(unsigned long nf)
{
  flags=nf;
}

/**************************************
 Ende Definition WCGlobalFlags
**************************************/

bool WConfig::configurePath(WCPath *p1)
{
  WCPath *p1_bak = p1->duplicate();
  WCPath *p1_bak2 = p1->duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty,tx;
  int t1,t2;
  WCDoubleShortkey *dk;
  List *dkeys;
  int id, row, erg;
  AWindow *win=new AWindow(aguix);
  char *tstr;
  Requester *req = new Requester( aguix );
  std::string str1;
  bool acceptkey;

  w=10;
  h=10;
  win->create(NULL,10,10,w,h,0,catalog.getLocale(82));
  ty=5;
  Text *tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(83),1));
  StringGadget *sg1=(StringGadget*)win->add(new StringGadget(aguix,5+tt1->getWidth()+5,
                                                             ty,100,p1->getName(),0));
  w=sg1->getX()+sg1->getWidth()+5;
  ty+=sg1->getHeight()+5;
  
  t1=5*aguix->getCharWidth();
  SolidButton *sb1=(SolidButton*)win->add(new SolidButton(aguix,5,ty,t1,"Test",
                                                          p1->getFG(),p1->getBG(),false));
  tx=sb1->getX()+sb1->getWidth()+5;
  t1=strlen(catalog.getLocale(32))+2;
  t1*=aguix->getCharWidth();
  Button *b1=(Button*)win->add(new Button(aguix,tx,ty,t1,catalog.getLocale(32),1,0,0));
  tx+=b1->getWidth()+5;
  t1=strlen(catalog.getLocale(33))+2;
  t1*=aguix->getCharWidth();
  Button *b2=(Button*)win->add(new Button(aguix,tx,ty,t1,catalog.getLocale(33),1,0,0));
  tw=tx+b2->getWidth()+5;
  if(tw>w) w=tw;
  ty+=b2->getHeight()+5;
  t1=strlen(catalog.getLocale(61))+2;
  t1*=aguix->getCharWidth();
  t2=strlen(catalog.getLocale(62))+2;
  t2*=aguix->getCharWidth();
  tw=(t1>t2)?t1:t2;

  tt1 = (Text*)win->add( new Text( aguix, 5, ty, catalog.getLocale( 449 ), 1 ) );
  ty += tt1->getHeight() + 5;
  FieldListView *sklv = (FieldListView*)win->add( new FieldListView( aguix,
                                                                     5,
                                                                     ty,
                                                                     30 * aguix->getCharWidth(),
                                                                     6 * aguix->getCharHeight(),
                                                                     0 ) );
  sklv->setNrOfFields( 3 );
  sklv->setFieldWidth( 1, 1 );
  sklv->setHBarState( 2 );
  sklv->setVBarState( 2 );
  
  dkeys = p1_bak2->getDoubleKeys();
  id = dkeys->initEnum();
  dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
  while ( dk != NULL ) {
    row = sklv->addRow();
    sklv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
    tstr = aguix->getNameOfKey( dk->getKeySym( 0 ), dk->getMod( 0 ) );
    if ( tstr != NULL ) {
      sklv->setText( row, 0, tstr );
      _freesafe( tstr );
    } else {
      sklv->setText( row, 0, "???" );
    }
    if ( dk->getType() == WCDoubleShortkey::WCDS_DOUBLE ) {
      tstr = aguix->getNameOfKey( dk->getKeySym( 1 ), dk->getMod( 1 ) );
      if ( tstr != NULL ) {
        sklv->setText( row, 2, tstr );
        _freesafe( tstr );
      } else {
        sklv->setText( row, 2, "???" );
      }
    }
    dk = (WCDoubleShortkey*)dkeys->getNextElement( id );
  }
  dkeys->closeEnum( id );
  sklv->redraw();
  
  tw = sklv->getWidth() + 10;
  if ( tw > w ) w = tw;
  ty += sklv->getHeight();
  
  GUIElement *skbs[2];
  skbs[0] = (Button*)win->add( new Button( aguix, 5, ty, catalog.getLocale( 450 ), 1, 0, 0 ) );
  skbs[1] = (Button*)win->add( new Button( aguix, 5, ty, catalog.getLocale( 451 ), 1, 0, 0 ) );

  ty += skbs[0]->getHeight() + 5;

  tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(84),1));
  StringGadget *sg2=(StringGadget*)win->add(new StringGadget(aguix,5+tt1->getWidth()+5,ty,100,
                                                             p1->getPath(),0));
  tw=sg2->getX()+sg2->getWidth()+5;
  if(tw>w) w=tw;
  ty+=sg2->getHeight()+5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;

  t1 = AGUIX::scaleElementsW( w, 5, 0, 0, false, true, skbs, NULL, 2 );
  if ( t1 > w ) {
    w = t1;
  }
  sklv->resize( w - 2 * 5, sklv->getHeight() );
  cancelb->move( w - 5 - cancelb->getWidth(), cancelb->getY() );

  win->setDoTabCycling( true );
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  sg1->resize(w-5-sg1->getX(),sg1->getHeight());
  sg2->resize(w-5-sg2->getX(),sg2->getHeight());
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  
  p1->setDoubleKeys( NULL );  // clear list to avoid conflicts
  
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==b1) {
          int col=palette(sb1->getFG());
          if(col>=0) sb1->setFG(col);
        } else if(msg->button.button==b2) {
          int col=palette(sb1->getBG());
          if(col>=0) sb1->setBG(col);
        } else if ( msg->button.button == skbs[0] ) {
          // add shortkey
          // 1.Ask for normal or double shortkey
          str1 = catalog.getLocale( 453 );
          str1 += "|";
          str1 += catalog.getLocale( 454 );
          erg = req->request( catalog.getLocale( 123 ),
                              catalog.getLocale( 452 ),
                              str1.c_str() );
          if ( erg == 1 ) {
            // double
            getDoubleShortkey( true, NULL, NULL, p1, &dk );
          } else {
            // normal
            getDoubleShortkey( false, NULL, NULL, p1, &dk );
          }
          if ( dk != NULL ) {
            // if getDoubleShortkey returns a key then
            // it's not used or the user want it to be used here
            // so add it and after okay remove all other conflicts
            acceptkey = false;
            if ( p1_bak2->conflictKey( dk ) == true ) {
              // conflicts with current list
              // inform the user but do not use it
              req->request( catalog.getLocale( 347 ),
                            catalog.getLocale( 457 ),
                            catalog.getLocale( 11 ) );
            } else {
              // doesn't conflict with current list
              acceptkey = true;
            }
            if ( acceptkey == true ) {
              dkeys->addElement( dk );
              row = sklv->addRow();
              sklv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
              tstr = aguix->getNameOfKey( dk->getKeySym( 0 ), dk->getMod( 0 ) );
              if ( tstr != NULL ) {
                sklv->setText( row, 0, tstr );
                _freesafe( tstr );
              } else {
                sklv->setText( row, 0, "???" );
              }
              if ( dk->getType() == WCDoubleShortkey::WCDS_DOUBLE ) {
                tstr = aguix->getNameOfKey( dk->getKeySym( 1 ), dk->getMod( 1 ) );
                if ( tstr != NULL ) {
                  sklv->setText( row, 2, tstr );
                  _freesafe( tstr );
                } else {
                  sklv->setText( row, 2, "???" );
                }
              }
            } else {
              delete dk;
            }
            sklv->redraw();
          }
        } else if ( msg->button.button == skbs[1] ) {
          // delete shortkey
          row = sklv->getActiveRow();
          if ( sklv->isValidRow( row ) == true ) {
            dkeys->removeElementAt( row );
            sklv->deleteRow( row );
            sklv->redraw();
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    // Ubernehmen
    p1->setName(sg1->getText());
    p1->setPath(sg2->getText());

    WCButton *twcb;
    WCHotkey *twch;
    WCPath *twcp;

    // search for existing shortkey and remove it
    id = dkeys->initEnum();
    dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
    while ( dk != NULL ) {
      if ( findDoubleShortkey( dk, &twcb, &twcp, &twch ) != 0 ) {
        if ( twcb != NULL ) {
          twcb->removeKey( dk );
        } else if ( ( twcp != NULL ) && ( twcp != p1 ) ) {
          twcp->removeKey( dk );
        } else if ( twch != NULL ) {
          twch->removeKey( dk );
        }
      }
      dk = (WCDoubleShortkey*)dkeys->getNextElement( id );
    }
    dkeys->closeEnum( id );
    p1->setCheck(true);
    p1->setFG(sb1->getFG());
    p1->setBG(sb1->getBG());
    p1->setDoubleKeys( dkeys );
  } else {
    p1->setDoubleKeys( p1_bak->getDoubleKeys() );
  }
  delete p1_bak;
  delete p1_bak2;
  win->close();
  delete win;
  delete req;
  return (ende==-1)?false:true;
}

#define RESCALE_CONFIGUREHOTKEY( w, h ) { \
  AGUIX::scaleElementsW( w, 5, 0, 0, true, true, skbs, NULL, 2 ); \
  AGUIX::scaleElementsW( w, 5, 10, -1, false, false, bs2, NULL, 2 ); \
  AGUIX::scaleElementsW( h, 5, 30, -1, false, false, bs3, NULL, 4 ); \
   \
  sg1->resize( w - sg1->getX() - 5, sg1->getHeight() ); \
  okb->move( okb->getX(), h - 5 - okb->getHeight() ); \
  cancelb->move( cancelb->getX(), h - 5 - cancelb->getHeight() ); \
   \
  sklv->resize( w - sklv->getX() - 5, \
                bs3[1]->getX() - bs3[0]->getX() - bs3[0]->getWidth() ); \
  sklv->move( sklv->getX(), bs3[0]->getX() + bs3[0]->getWidth() ); \
  lv->resize( w - lv->getX() - 5, \
              bs3[2]->getX() - bs3[1]->getX() - bs3[1]->getWidth() ); \
  lv->move( lv->getX(), bs3[1]->getX() + bs3[1]->getWidth() ); \
  lv2->resize( w - lv2->getX() - 5, \
               bs3[3]->getX() - bs3[2]->getX() - bs3[2]->getWidth() ); \
  lv2->move( lv2->getX(), bs3[2]->getX() + bs3[2]->getWidth() ); \
  skbs[0]->move( skbs[0]->getX(), sklv->getY() + sklv->getHeight() ); \
  skbs[1]->move( skbs[1]->getX(), sklv->getY() + sklv->getHeight() ); \
  text1->move( text1->getX(), skbs[0]->getY() + skbs[0]->getHeight() + 5 ); \
   \
  { \
    int myh = lv->getHeight(); \
    b2->resize( b2->getWidth(), myh / 5 ); \
    myh -= b2->getHeight(); \
    b3->resize( b3->getWidth(), myh / 4 ); \
    myh -= b3->getHeight(); \
    b4->resize( b4->getWidth(), myh / 3 ); \
    myh -= b4->getHeight(); \
    b5->resize( b5->getWidth(), myh / 2 ); \
    myh -= b5->getHeight(); \
    b6->resize( b6->getWidth(), myh ); \
  } \
   \
  b2->move( b2->getX(), lv->getY() ); \
  b3->move( b3->getX(), b2->getY() + b2->getHeight() ); \
  b4->move( b4->getX(), b3->getY() + b3->getHeight() ); \
  b5->move( b5->getX(), b4->getY() + b4->getHeight() ); \
  b6->move( b6->getX(), b5->getY() + b5->getHeight() ); \
  text2->move( text2->getX(), lv->getY() + lv->getHeight() + 5 ); \
}

bool WConfig::configureHotkey(WCHotkey *h1)
{
  WCHotkey *h1_bak=h1->duplicate();
  WCHotkey *h1_bak2=h1->duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1,t2,t3;
  WCDoubleShortkey *dk;
  List *dkeys;
  int id, row, erg;
  AWindow *win=new AWindow(aguix);
  char *tstr;
  Requester *req = new Requester( aguix );
  std::string str1;
  bool acceptkey;
  GUIElement *bs2[2], *bs3[4];
  Text *text1, *text2;
  int lastrow;
  struct timeval tv1, tv2;

  w=10;
  h=10;
  win->create(NULL,10,10,w,h,0,catalog.getLocale(91));
  ty=5;
  Text *tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(92),1));
  StringGadget *sg1=(StringGadget*)win->add(new StringGadget(aguix,5+tt1->getWidth()+5,
                                                             ty,100,h1->getName(),0));
  w=sg1->getX()+sg1->getWidth()+5;
  ty+=sg1->getHeight()+5;
  
  t1=strlen(catalog.getLocale(61))+2;
  t1*=aguix->getCharWidth();
  t2=strlen(catalog.getLocale(62))+2;
  t2*=aguix->getCharWidth();
  tw=(t1>t2)?t1:t2;

  tt1 = (Text*)win->add( new Text( aguix, 5, ty, catalog.getLocale( 449 ), 1 ) );
  ty += tt1->getHeight() + 5;
  FieldListView *sklv = (FieldListView*)win->add( new FieldListView( aguix,
                                                                     5,
                                                                     ty,
                                                                     30 * aguix->getCharWidth(),
                                                                     6 * aguix->getCharHeight(),
                                                                     0 ) );
  sklv->setNrOfFields( 3 );
  sklv->setFieldWidth( 1, 1 );
  sklv->setHBarState( 2 );
  sklv->setVBarState( 2 );
  
  dkeys = h1_bak2->getDoubleKeys();
  id = dkeys->initEnum();
  dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
  while ( dk != NULL ) {
    row = sklv->addRow();
    sklv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
    tstr = aguix->getNameOfKey( dk->getKeySym( 0 ), dk->getMod( 0 ) );
    if ( tstr != NULL ) {
      sklv->setText( row, 0, tstr );
      _freesafe( tstr );
    } else {
      sklv->setText( row, 0, "???" );
    }
    if ( dk->getType() == WCDoubleShortkey::WCDS_DOUBLE ) {
      tstr = aguix->getNameOfKey( dk->getKeySym( 1 ), dk->getMod( 1 ) );
      if ( tstr != NULL ) {
        sklv->setText( row, 2, tstr );
        _freesafe( tstr );
      } else {
        sklv->setText( row, 2, "???" );
      }
    }
    dk = (WCDoubleShortkey*)dkeys->getNextElement( id );
  }
  dkeys->closeEnum( id );
  sklv->redraw();
  
  tw = sklv->getWidth() + 10;
  if ( tw > w ) w = tw;
  ty += sklv->getHeight();
  
  GUIElement *skbs[2];
  skbs[0] = (Button*)win->add( new Button( aguix, 5, ty, catalog.getLocale( 450 ), 1, 0, 0 ) );
  skbs[1] = (Button*)win->add( new Button( aguix, 5, ty, catalog.getLocale( 451 ), 1, 0, 0 ) );

  ty += skbs[0]->getHeight() + 5;

  tt1 = text1 =(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(245),1));
  ty+=tt1->getHeight()+5;

  t1=strlen(catalog.getLocale(246))+2;
  t1*=aguix->getCharWidth();
  Button *b2=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(246),1,0,0));
  t2=b2->getWidth();
  ty+=b2->getHeight();
  t1=strlen(catalog.getLocale(247))+2;
  t1*=aguix->getCharWidth();
  Button *b3=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(247),1,0,0));
  t3=b3->getWidth();
  if(t3>t2) t2=t3;
  ty+=b3->getHeight();
  t1=strlen(catalog.getLocale(248))+2;
  t1*=aguix->getCharWidth();
  Button *b4=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(248),2,3,0));
  t3=b4->getWidth();
  if(t3>t2) t2=t3;
  ty+=b4->getHeight();
  t1=strlen(catalog.getLocale(236))+2;
  t1*=aguix->getCharWidth();
  Button *b5=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(236),1,0,0));
  t3=b5->getWidth();
  if(t3>t2) t2=t3;
  ty+=b5->getHeight();
  t1=strlen(catalog.getLocale(237))+2;
  t1*=aguix->getCharWidth();
  Button *b6=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(237),1,0,0));
  t3=b6->getWidth();
  if(t3>t2) t2=t3;
  ty+=b6->getHeight()+5;
  b2->resize(t2,b2->getHeight());
  b3->resize(t2,b3->getHeight());
  b4->resize(t2,b4->getHeight());
  b5->resize(t2,b5->getHeight());
  b6->resize(t2,b6->getHeight());
  FieldListView *lv = (FieldListView*)win->add( new FieldListView( aguix,
                                                                   b2->getX() + b2->getWidth(),
                                                                   b2->getY(),
                                                                   a_max( w - 5 - b2->getX() - b2->getWidth(),
                                                                          20 * aguix->getCharWidth() ),
                                                                   b6->getY() + b6->getHeight() - b2->getY(),
                                                                   0 ) );
  lv->setHBarState(2);
  lv->setVBarState(2);
  lv->setAcceptFocus( true );
  lv->setDisplayFocus( true );
  List *coms=h1->getComs();
  id=coms->initEnum();
  FunctionProto *fpr=(FunctionProto*)coms->getFirstElement(id);
  while(fpr!=NULL) {
    row = lv->addRow();
    lv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
    lv->setText( row, 0, fpr->getDescription() );
    fpr=(FunctionProto*)coms->getNextElement(id);
  }
  lv->redraw();
  coms->closeEnum(id);

  tw = lv->getX() + lv->getWidth() + 5;
  if ( tw > w ) w = tw;

  tt1 = text2 =(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(64),1));
  ty+=tt1->getHeight()+5;
  FieldListView *lv2 = (FieldListView*)win->add( new FieldListView( aguix, 5, ty, w - 10, 75, 0 ) );
  lv2->setHBarState(2);
  lv2->setVBarState(2);
  ty+=lv2->getHeight()+5;
  List *fns=WCGlobalFlags::getNameOfFlags();
  unsigned long flags=h1->getComsGF()->getFlags(),tp;
  char *str=(char*)fns->getFirstElement();
  t1=0;
  int trow;
  while(str!=NULL) {
    trow = lv2->addRow();
    lv2->setPreColors( trow, FieldListView::PRECOLOR_ONLYSELECT );
    lv2->setText( trow, 0, str );
    tp = (unsigned long)pow( (double)2, (double)t1 );
    if((flags&tp)==tp) {
      lv2->setSelect( trow, true );
    }
    str=(char*)fns->getNextElement();
    t1++;
  }
  lv2->redraw();

  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                               5,
                                               ty,
                                               catalog.getLocale(8),
                                               1,
                                               0,
                                               0));
  bs2[0] = okb;
  bs2[1] = cancelb;
  tw = AGUIX::scaleElementsW( w, 5, 10, -1, false, false, bs2, NULL, 2 );
  if ( tw > w ) w = tw;
  h=okb->getY()+okb->getHeight()+5;

  t1 = AGUIX::scaleElementsW( w, 5, 0, 0, false, true, skbs, NULL, 2 );
  if ( t1 > w ) {
    w = t1;
  }
  sklv->resize( w - 2 * 5, sklv->getHeight() );
  cancelb->move( w - 5 - cancelb->getWidth(), cancelb->getY() );

  win->setDoTabCycling( true );
  win->resize(w,h);
  //win->setMaxSize(w,h);
  win->setMinSize(w,h);
  sg1->resize(w-5-sg1->getX(),sg1->getHeight());

  /* these elements will not be added to the window, they are just used to help
     scaling the window vertically */
  bs3[0] = new BevelBox( aguix, 10, 10, 10, 10, 0 );
  bs3[1] = new BevelBox( aguix, 10, 10, 10, 10, 0 );
  bs3[2] = new BevelBox( aguix, 10, 10, 10, 10, 0 );
  bs3[3] = new BevelBox( aguix, 10, 10, 10, 10, 0 );
  bs3[0]->resize( sklv->getY() - 5, 10 );
  bs3[1]->resize( lv->getY() - sklv->getY() - sklv->getHeight(), 10 );
  bs3[2]->resize( lv2->getY() - lv->getY() - lv->getHeight(), 10 );
  bs3[3]->resize( win->getHeight() - lv2->getY() - lv2->getHeight() - 5, 10 );

  if ( ( configureHotkeySize[0] >= w ) && ( configureHotkeySize[1] >= h ) ) {
    win->resize( configureHotkeySize[0], configureHotkeySize[1] );
  }

  w = win->getWidth();
  h = win->getHeight();
  RESCALE_CONFIGUREHOTKEY( w, h );

  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  FunctionProto *fpr2;
  
  h1->setDoubleKeys( NULL );  // clear list to avoid conflicts
  
  lastrow = -1;
  timerclear( &tv1 );
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==b2) {
          fpr=requestCommand();
          if(fpr!=NULL) {
            coms->addElement(fpr);
            fpr->configureWhenAvail();
            row = lv->addRow();
            lv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
            lv->setText( row, 0, fpr->getDescription() );
            lv->setActiveRow( row );
            lv->showActive();
            lv->redraw();
          }
        } else if(msg->button.button==b3) {
          row = lv->getActiveRow();
          if ( lv->isValidRow( row ) == true ) {
            fpr=(FunctionProto*)coms->getElementAt( row );
            delete fpr;
            coms->removeElementAt( row );
            lv->deleteRow( row );
            if ( lv->isValidRow( row ) == true )
              lv->setActiveRow( row );
            else
              lv->setActiveRow( row - 1 );
            lv->showActive();
            lv->redraw();
          }
        } else if(msg->button.button==b4) {
          row = lv->getActiveRow();
          if ( lv->isValidRow( row ) == true ) {
            fpr=(FunctionProto*)coms->getElementAt( row );
            fpr->configure();
            lv->setText( row, 0, fpr->getDescription() );
            lv->redraw();
          }
        } else if(msg->button.button==b5) {
          row = lv->getActiveRow();
          if ( lv->isValidRow( row ) == true ) {
            if ( row > 0 ) {
              fpr = (FunctionProto*)coms->getElementAt( row );
              fpr2 = (FunctionProto*)coms->exchangeElement( row - 1, fpr );
              coms->exchangeElement( row, fpr2 );
              lv->swapRows( row, row - 1 );
              lv->showActive();
              lv->redraw();
            }
          }
        } else if(msg->button.button==b6) {
          row = lv->getActiveRow();
          if ( lv->isValidRow( row ) == true ) {
            if ( row < ( lv->getElements() - 1 ) ) {
              fpr = (FunctionProto*)coms->getElementAt( row );
              fpr2 = (FunctionProto*)coms->exchangeElement( row + 1, fpr );
              coms->exchangeElement( row, fpr2 );
              lv->swapRows( row, row + 1 );
              lv->showActive();
              lv->redraw();
            }
          }
        } else if ( msg->button.button == skbs[0] ) {
          // add shortkey
          // 1.Ask for normal or double shortkey
          str1 = catalog.getLocale( 453 );
          str1 += "|";
          str1 += catalog.getLocale( 454 );
          erg = req->request( catalog.getLocale( 123 ),
                              catalog.getLocale( 452 ),
                              str1.c_str() );
          if ( erg == 1 ) {
            // double
            getDoubleShortkey( true, NULL, h1, NULL, &dk );
          } else {
            // normal
            getDoubleShortkey( false, NULL, h1, NULL, &dk );
          }
          if ( dk != NULL ) {
            // if getDoubleShortkey returns a key then
            // it's not used or the user want it to be used here
            // so add it and after okay remove all other conflicts
            acceptkey = false;
            if ( h1_bak2->conflictKey( dk ) == true ) {
              // conflicts with current list
              // inform the user but do not use it
              req->request( catalog.getLocale( 347 ),
                            catalog.getLocale( 457 ),
                            catalog.getLocale( 11 ) );
            } else {
              // doesn't conflict with current list
              acceptkey = true;
            }
            if ( acceptkey == true ) {
              dkeys->addElement( dk );
              row = sklv->addRow();
              sklv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
              tstr = aguix->getNameOfKey( dk->getKeySym( 0 ), dk->getMod( 0 ) );
              if ( tstr != NULL ) {
                sklv->setText( row, 0, tstr );
                _freesafe( tstr );
              } else {
                sklv->setText( row, 0, "???" );
              }
              if ( dk->getType() == WCDoubleShortkey::WCDS_DOUBLE ) {
                tstr = aguix->getNameOfKey( dk->getKeySym( 1 ), dk->getMod( 1 ) );
                if ( tstr != NULL ) {
                  sklv->setText( row, 2, tstr );
                  _freesafe( tstr );
                } else {
                  sklv->setText( row, 2, "???" );
                }
              }
            } else {
              delete dk;
            }
            sklv->redraw();
          }
        } else if ( msg->button.button == skbs[1] ) {
          // delete shortkey
          row = sklv->getActiveRow();
          if ( sklv->isValidRow( row ) == true ) {
            dkeys->removeElementAt( row );
            sklv->deleteRow( row );
            sklv->redraw();
          }
        }
      } else if ( msg->type == AG_SIZECHANGED ) {
        if ( msg->size.window == win->getWindow() ) {
          RESCALE_CONFIGUREHOTKEY( msg->size.neww, msg->size.newh );
        }
      } else if ( msg->type == AG_FIELDLV_ONESELECT ) {
        if ( ( msg->fieldlv.lv == lv ) && ( msg->fieldlv.mouse == true ) ) {
          gettimeofday( &tv2, NULL );
          if ( lastrow < 0 ) {
            lastrow = msg->fieldlv.row;
            tv1 = tv2;
          } else {
            if  ( ( msg->fieldlv.row == lastrow ) &&
                  ( aguix->isDoubleClick( &tv2, &tv1 ) == true ) ) {
              if ( lv->isValidRow( lastrow ) == true ) {
                fpr=(FunctionProto*)coms->getElementAt( lastrow );
                fpr->configure();
                lv->setText( lastrow, 0, fpr->getDescription() );
                lv->redraw();
              }
              lastrow = -1;
            } else {
              lastrow = msg->fieldlv.row;
              tv1 = tv2;
            }
          }
        }
      } else if ( msg->type == AG_FIELDLV_MULTISELECT ) {
        lastrow = -1;
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    // Ubernehmen
    h1->setName(sg1->getText());

    WCButton *twcb;
    WCHotkey *twch;
    WCPath *twcp;

    // search for existing shortkey and remove it
    id = dkeys->initEnum();
    dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
    while ( dk != NULL ) {
      if ( findDoubleShortkey( dk, &twcb, &twcp, &twch ) != 0 ) {
        if ( twcb != NULL ) {
          twcb->removeKey( dk );
        } else if ( twcp != NULL ) {
          twcp->removeKey( dk );
        } else if ( ( twch != NULL ) && ( twch != h1 ) ) {
          twch->removeKey( dk );
        }
      }
      dk = (WCDoubleShortkey*)dkeys->getNextElement( id );
    }
    dkeys->closeEnum( id );
    for(t1=0,flags=0;t1<fns->size();t1++) {
      if ( lv2->getSelect( t1 ) == true ) {
        tp = (unsigned long)pow( (double)2, (double)t1 );
        flags+=tp;
      }
    }
    h1->getComsGF()->setFlags(flags);
    h1->setDoubleKeys( dkeys );
  } else {
    h1->setComs(h1_bak->getComs());
    h1->setDoubleKeys( h1_bak->getDoubleKeys() );
  }
  WCGlobalFlags::freeNameOfFlags(fns);
  delete h1_bak;
  delete h1_bak2;
  configureHotkeySize[0] = win->getWidth();
  configureHotkeySize[1] = win->getHeight();
  win->close();
  delete win;
  delete req;

  delete bs3[0];
  delete bs3[1];
  delete bs3[2];
  delete bs3[3];
  
  return (ende==-1)?false:true;
}

List* WCGlobalFlags::getNameOfFlags()
{
  List *names=new List();
//  names->addElement(dupstring("All in one shell"));
  return names;
}

void WCGlobalFlags::freeNameOfFlags(List *names)
{
  while(names->size()>0) {
    _freesafe(names->getFirstElement());
    names->removeFirstElement();
  }
  delete names;
}

struct requestCommand_str {
  char *str;
  int id;
};

int WConfig::requestCommand_sf(void *p1,void *p2)
{
  return strcasecmp(((struct requestCommand_str*)p1)->str,((struct requestCommand_str*)p2)->str);
}

FunctionProto *WConfig::requestCommand()
{
  AGUIX *aguix=worker->getAGUIX();
  FunctionProto *fpr=NULL;
  int tw,w,h,ty;
  int t1,t2;
  AWindow *win=new AWindow(aguix);
  List *tlist;
  struct requestCommand_str *ts;
  int id;
  int trow;
  
  w=200;
  h=10;
  win->create(NULL,10,10,w,h,0,catalog.getLocale(249));
  ty=5;
  FieldListView *lv = (FieldListView*)win->add( new FieldListView( aguix, 5,
                                                                   ty,
                                                                   w - 10,
                                                                   200,
                                                                   0 ) );
  lv->setHBarState(2);
  lv->setVBarState(2);
  
  tlist=new List();
  FunctionProto *tfpr;
  for(int i=0;i<worker->getNrOfCommands();i++) {
    tfpr=worker->getCommand4ID(i);
    ts=(struct requestCommand_str*)_allocsafe(sizeof(struct requestCommand_str));
    ts->id=i;
    ts->str=dupstring(tfpr->getDescription());
    tlist->addElement(ts);
    delete tfpr;
  }
  tlist->sort(requestCommand_sf);

  id=tlist->initEnum();
  ts=(struct requestCommand_str*)tlist->getFirstElement(id);
  while(ts!=NULL) {
    trow = lv->addRow();
    lv->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
    lv->setText( trow, 0, ts->str );
    if ( lastRequestCommand != NULL ) {
      if ( strcmp( ts->str, lastRequestCommand ) == 0 )
        lv->setActiveRow( trow );
    }
    ts=(struct requestCommand_str*)tlist->getNextElement(id);
  }
  lv->redraw();
  lv->centerActive();

  ty+=lv->getHeight()+5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->setDoTabCycling( true );
  win->resize(w,h);
//  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
      } else if(msg->type==AG_SIZECHANGED) {
        if(msg->size.window==win->getWindow()) {
          w=msg->size.neww;
          h=msg->size.newh;
          okb->move(okb->getX(),h-5-okb->getHeight());
          cancelb->move(w-5-cancelb->getWidth(),h-5-cancelb->getHeight());
          lv->resize(w-10,okb->getY()-10);
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    trow = lv->getActiveRow();
    if ( lv->isValidRow( trow ) == true ) {
      ts = (struct requestCommand_str*)tlist->getElementAt( trow );
      fpr=worker->getCommand4ID(ts->id);
      if ( lastRequestCommand != NULL ) _freesafe( lastRequestCommand );
      lastRequestCommand = dupstring( ts->str );
    }
  }
  win->close();
  delete win;

  ts=(struct requestCommand_str*)tlist->getFirstElement(id);
  while(ts!=NULL) {
    _freesafe(ts->str);
    _freesafe(ts);
    ts=(struct requestCommand_str*)tlist->getNextElement(id);
  }
  tlist->closeEnum(id);
  delete tlist;

  return fpr;
}

#define RESCALE_CONFIGUREBUTTON( w, h ) { \
  AGUIX::scaleElementsW( w, 5, 0, 0, true, true, skbs, NULL, 2 ); \
  AGUIX::scaleElementsW( w, 5, 10, -1, false, false, bs2, NULL, 2 ); \
  AGUIX::scaleElementsW( h, 5, 30, -1, false, false, bs3, NULL, 4 ); \
   \
  sg1->resize( w - sg1->getX() - 5, sg1->getHeight() ); \
  okb->move( okb->getX(), h - 5 - okb->getHeight() ); \
  cancelb->move( cancelb->getX(), h - 5 - cancelb->getHeight() ); \
   \
  sklv->resize( w - sklv->getX() - 5, \
                bs3[1]->getX() - bs3[0]->getX() - bs3[0]->getWidth() ); \
  sklv->move( sklv->getX(), bs3[0]->getX() + bs3[0]->getWidth() ); \
  lv->resize( w - lv->getX() - 5, \
              bs3[2]->getX() - bs3[1]->getX() - bs3[1]->getWidth() ); \
  lv->move( lv->getX(), bs3[1]->getX() + bs3[1]->getWidth() ); \
  lv2->resize( w - lv2->getX() - 5, \
               bs3[3]->getX() - bs3[2]->getX() - bs3[2]->getWidth() ); \
  lv2->move( lv2->getX(), bs3[2]->getX() + bs3[2]->getWidth() ); \
  skbs[0]->move( skbs[0]->getX(), sklv->getY() + sklv->getHeight() ); \
  skbs[1]->move( skbs[1]->getX(), sklv->getY() + sklv->getHeight() ); \
  text1->move( text1->getX(), skbs[0]->getY() + skbs[0]->getHeight() + 5 ); \
   \
  { \
    int myh = lv->getHeight(); \
    b2->resize( b2->getWidth(), myh / 5 ); \
    myh -= b2->getHeight(); \
    b3->resize( b3->getWidth(), myh / 4 ); \
    myh -= b3->getHeight(); \
    b4->resize( b4->getWidth(), myh / 3 ); \
    myh -= b4->getHeight(); \
    b5->resize( b5->getWidth(), myh / 2 ); \
    myh -= b5->getHeight(); \
    b6->resize( b6->getWidth(), myh ); \
  } \
   \
  b2->move( b2->getX(), lv->getY() ); \
  b3->move( b3->getX(), b2->getY() + b2->getHeight() ); \
  b4->move( b4->getX(), b3->getY() + b3->getHeight() ); \
  b5->move( b5->getX(), b4->getY() + b4->getHeight() ); \
  b6->move( b6->getX(), b5->getY() + b5->getHeight() ); \
  text2->move( text2->getX(), lv->getY() + lv->getHeight() + 5 ); \
}

bool WConfig::configureButton(WCButton *wcb1)
{
  /*
   * I will clear the doublekey list for wcb1
   * _bak is used to restore keys when canceled
   * changes will be done to
   */
  WCButton *wcb1_bak=wcb1->duplicate();
  WCButton *wcb1_bak2=wcb1->duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1,t2,t3;
  WCDoubleShortkey *dk;
  List *dkeys;
  int id, row, erg;
  AWindow *win=new AWindow(aguix);
  char *tstr;
  Requester *req = new Requester( aguix );
  std::string str1;
  bool acceptkey;
  GUIElement *bs2[2], *bs3[4];
  Text *text1, *text2;
  int lastrow;
  struct timeval tv1, tv2;

  w = 10;
  h = 10;
  win->create(NULL,10,10,w,h,0,catalog.getLocale(59));
  ty=5;
  Text *tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(60),1));
  StringGadget *sg1=(StringGadget*)win->add(new StringGadget(aguix,5+tt1->getWidth()+5,
                                                             ty,100,wcb1->getText(),0));
  w=sg1->getX()+sg1->getWidth()+5;
  ty+=sg1->getHeight()+5;
  t1=6*aguix->getCharWidth();
  t2=strlen(catalog.getLocale(32))+2;
  t2*=aguix->getCharWidth();
  t3=strlen(catalog.getLocale(33))+2;
  t3*=aguix->getCharWidth();
  SolidButton *tsb=(SolidButton*)win->add(new SolidButton(aguix,5,ty,t1,"Test",wcb1->getFG(),
                                                          wcb1->getBG(),false));
  Button *fgb=(Button*)win->add(new Button(aguix,5+t1+5,ty,t2,catalog.getLocale(32),1,0,0));
  Button *bgb=(Button*)win->add(new Button(aguix,5+t1+5+t2+5,ty,t3,catalog.getLocale(33),1,0,0));
  tw=bgb->getX()+bgb->getWidth()+5;
  if(tw>w) w=tw;
  ty+=fgb->getHeight()+5;
  
  tt1 = (Text*)win->add( new Text( aguix, 5, ty, catalog.getLocale( 449 ), 1 ) );
  ty += tt1->getHeight() + 5;
  FieldListView *sklv = (FieldListView*)win->add( new FieldListView( aguix,
                                                                     5,
                                                                     ty,
                                                                     30 * aguix->getCharWidth(),
                                                                     6 * aguix->getCharHeight(),
                                                                     0 ) );
  sklv->setNrOfFields( 3 );
  sklv->setFieldWidth( 1, 1 );
  sklv->setHBarState( 2 );
  sklv->setVBarState( 2 );
  
  // make all key changes to the second copy
  dkeys = wcb1_bak2->getDoubleKeys();
  id = dkeys->initEnum();
  dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
  while ( dk != NULL ) {
    row = sklv->addRow();
    sklv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
    tstr = aguix->getNameOfKey( dk->getKeySym( 0 ), dk->getMod( 0 ) );
    if ( tstr != NULL ) {
      sklv->setText( row, 0, tstr );
      _freesafe( tstr );
    } else {
      sklv->setText( row, 0, "???" );
    }
    if ( dk->getType() == WCDoubleShortkey::WCDS_DOUBLE ) {
      tstr = aguix->getNameOfKey( dk->getKeySym( 1 ), dk->getMod( 1 ) );
      if ( tstr != NULL ) {
        sklv->setText( row, 2, tstr );
        _freesafe( tstr );
      } else {
        sklv->setText( row, 2, "???" );
      }
    }
    dk = (WCDoubleShortkey*)dkeys->getNextElement( id );
  }
  dkeys->closeEnum( id );
  sklv->redraw();
  
  tw = sklv->getWidth() + 10;
  if ( tw > w ) w = tw;
  ty += sklv->getHeight();
  
  GUIElement *skbs[2];
  skbs[0] = (Button*)win->add( new Button( aguix, 5, ty, catalog.getLocale( 450 ), 1, 0, 0 ) );
  skbs[1] = (Button*)win->add( new Button( aguix, 5, ty, catalog.getLocale( 451 ), 1, 0, 0 ) );

  ty += skbs[0]->getHeight() + 5;

  tt1 = text1 = (Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(245),1));
  ty+=tt1->getHeight()+5;

  t1=strlen(catalog.getLocale(246))+2;
  t1*=aguix->getCharWidth();
  Button *b2=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(246),1,0,0));
  t2=b2->getWidth();
  ty+=b2->getHeight();
  t1=strlen(catalog.getLocale(247))+2;
  t1*=aguix->getCharWidth();
  Button *b3=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(247),1,0,0));
  t3=b3->getWidth();
  if(t3>t2) t2=t3;
  ty+=b3->getHeight();
  t1=strlen(catalog.getLocale(248))+2;
  t1*=aguix->getCharWidth();
  Button *b4=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(248),2,3,0));
  t3=b4->getWidth();
  if(t3>t2) t2=t3;
  ty+=b4->getHeight();
  t1=strlen(catalog.getLocale(236))+2;
  t1*=aguix->getCharWidth();
  Button *b5=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(236),1,0,0));
  t3=b5->getWidth();
  if(t3>t2) t2=t3;
  ty+=b5->getHeight();
  t1=strlen(catalog.getLocale(237))+2;
  t1*=aguix->getCharWidth();
  Button *b6=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(237),1,0,0));
  t3=b6->getWidth();
  if(t3>t2) t2=t3;
  ty+=b6->getHeight()+5;
  b2->resize(t2,b2->getHeight());
  b3->resize(t2,b3->getHeight());
  b4->resize(t2,b4->getHeight());
  b5->resize(t2,b5->getHeight());
  b6->resize(t2,b6->getHeight());
  FieldListView *lv = (FieldListView*)win->add( new FieldListView( aguix,
                                                                   b2->getX() + b2->getWidth(),
                                                                   b2->getY(),
                                                                   a_max( w - 5 - b2->getX() - b2->getWidth(),
                                                                          40 * aguix->getCharWidth() ),
                                                                   b6->getY() + b6->getHeight() - b2->getY(),
                                                                   0 ) );
  lv->setHBarState(2);
  lv->setVBarState(2);
  lv->setAcceptFocus( true );
  lv->setDisplayFocus( true );
  List *coms=wcb1->getComs();
  id=coms->initEnum();
  FunctionProto *fpr=(FunctionProto*)coms->getFirstElement(id);
  while(fpr!=NULL) {
    row = lv->addRow();
    lv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
    lv->setText( row, 0, fpr->getDescription() );
    fpr=(FunctionProto*)coms->getNextElement(id);
  }
  lv->redraw();
  coms->closeEnum(id);

  tw = lv->getX() + lv->getWidth() + 5;
  if ( tw > w ) w = tw;

  tt1 = text2 = (Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(64),1));
  ty+=tt1->getHeight()+5;
  FieldListView *lv2 = (FieldListView*)win->add( new FieldListView( aguix, 5, ty, w - 10, 75, 0 ) );
  lv2->setHBarState(2);
  lv2->setVBarState(2);
  ty+=lv2->getHeight()+5;
  List *fns=WCGlobalFlags::getNameOfFlags();
  unsigned long flags=wcb1->getComsGF()->getFlags(),tp;
  char *str=(char*)fns->getFirstElement();
  t1=0;
  int trow;
  while(str!=NULL) {
    trow = lv2->addRow();
    lv2->setPreColors( trow, FieldListView::PRECOLOR_ONLYSELECT );
    lv2->setText( trow, 0, str );
    tp = (unsigned long)pow( (double)2, (double)t1 );
    if((flags&tp)==tp) {
      lv2->setSelect( trow, true );
    }
    str=(char*)fns->getNextElement();
    t1++;
  }
  lv2->redraw();

  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                               5,
                                               ty,
                                               catalog.getLocale(8),
                                               1,
                                               0,
                                               0));
  bs2[0] = okb;
  bs2[1] = cancelb;
  tw = AGUIX::scaleElementsW( w, 5, 10, -1, false, false, bs2, NULL, 2 );
  if ( tw > w ) w = tw;
  h=okb->getY()+okb->getHeight()+5;

  t1 = AGUIX::scaleElementsW( w, 5, 0, 0, false, true, skbs, NULL, 2 );
  if ( t1 > w ) {
    w = t1;
  }
  sklv->resize( w - 2 * 5, sklv->getHeight() );
  cancelb->move( w - 5 - cancelb->getWidth(), cancelb->getY() );

  win->setDoTabCycling( true );
  win->resize(w,h);
  //win->setMaxSize(w,h);
  win->setMinSize(w,h);
  sg1->resize(w-5-sg1->getX(),sg1->getHeight());
  sklv->resize( w - 2 * 5, sklv->getHeight() );

  /* these elements will not be added to the window, they are just used to help
     scaling the window vertically */
  bs3[0] = new BevelBox( aguix, 10, 10, 10, 10, 0 );
  bs3[1] = new BevelBox( aguix, 10, 10, 10, 10, 0 );
  bs3[2] = new BevelBox( aguix, 10, 10, 10, 10, 0 );
  bs3[3] = new BevelBox( aguix, 10, 10, 10, 10, 0 );
  bs3[0]->resize( sklv->getY() - 5, 10 );
  bs3[1]->resize( lv->getY() - sklv->getY() - sklv->getHeight(), 10 );
  bs3[2]->resize( lv2->getY() - lv->getY() - lv->getHeight(), 10 );
  bs3[3]->resize( win->getHeight() - lv2->getY() - lv2->getHeight() - 5, 10 );

  if ( ( configureButtonSize[0] >= w ) && ( configureButtonSize[1] >= h ) ) {
    win->resize( configureButtonSize[0], configureButtonSize[1] );
  }

  w = win->getWidth();
  h = win->getHeight();
  RESCALE_CONFIGUREBUTTON( w, h );

  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  FunctionProto *fpr2;
  
  wcb1->setDoubleKeys( NULL );  // clear list to avoid conflicts
  
  lastrow = -1;
  timerclear( &tv1 );
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==b2) {
          fpr=requestCommand();
          if(fpr!=NULL) {
            coms->addElement(fpr);
            fpr->configureWhenAvail();
            row = lv->addRow();
            lv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
            lv->setText( row, 0, fpr->getDescription() );
            lv->setActiveRow( row );
            lv->showActive();
            lv->redraw();
          }
        } else if(msg->button.button==b3) {
          row = lv->getActiveRow();
          if( lv->isValidRow( row ) == true ) {
            fpr=(FunctionProto*)coms->getElementAt( row );
            delete fpr;
            coms->removeElementAt( row);
            lv->deleteRow( row );
            if ( lv->isValidRow( row ) == true )
              lv->setActiveRow( row );
            else
              lv->setActiveRow( row - 1 );
            lv->showActive();
            lv->redraw();
          }
        } else if(msg->button.button==b4) {
          row = lv->getActiveRow();
          if( lv->isValidRow( row ) == true ) {
            fpr=(FunctionProto*)coms->getElementAt( row );
            fpr->configure();
            lv->setText( row, 0, fpr->getDescription() );
            lv->redraw();
          }
        } else if(msg->button.button==b5) {
          row = lv->getActiveRow();
          if ( lv->isValidRow( row ) == true ) {
            if ( row > 0 ) {
              fpr = (FunctionProto*)coms->getElementAt( row );
              fpr2 = (FunctionProto*)coms->exchangeElement( row - 1, fpr );
              coms->exchangeElement( row, fpr2 );
              lv->swapRows( row, row - 1 );
              lv->showActive();
              lv->redraw();
            }
          }
        } else if(msg->button.button==b6) {
          row = lv->getActiveRow();
          if ( lv->isValidRow( row ) == true ) {
            if ( row < ( lv->getElements() - 1 ) ) {
              fpr = (FunctionProto*)coms->getElementAt( row );
              fpr2 = (FunctionProto*)coms->exchangeElement( row + 1, fpr );
              coms->exchangeElement( row, fpr2 );
              lv->swapRows( row, row + 1 );
              lv->showActive();
              lv->redraw();
            }
          }
        } else if(msg->button.button==fgb) {
          t1=palette(tsb->getFG());
          if(t1>=0) {
            tsb->setFG(t1);
          }
        } else if(msg->button.button==bgb) {
          t1=palette(tsb->getBG());
          if(t1>=0) {
            tsb->setBG(t1);
          }
        } else if ( msg->button.button == skbs[0] ) {
          // add shortkey
          // 1.Ask for normal or double shortkey
          str1 = catalog.getLocale( 453 );
          str1 += "|";
          str1 += catalog.getLocale( 454 );
          erg = req->request( catalog.getLocale( 123 ),
                              catalog.getLocale( 452 ),
                              str1.c_str() );
          if ( erg == 1 ) {
            // double
            getDoubleShortkey( true, wcb1, NULL, NULL, &dk );
          } else {
            // normal
            getDoubleShortkey( false, wcb1, NULL, NULL, &dk );
          }
          if ( dk != NULL ) {
            // if getDoubleShortkey returns a key then
            // it's not used or the user want it to be used here
            // so add it and after okay remove all other conflicts
            acceptkey = false;
            if ( wcb1_bak2->conflictKey( dk ) == true ) {
              // conflicts with current list
              // inform the user but do not use it
              req->request( catalog.getLocale( 347 ),
                            catalog.getLocale( 457 ),
                            catalog.getLocale( 11 ) );
            } else {
              // doesn't conflict with current list
              acceptkey = true;
            }
            if ( acceptkey == true ) {
              dkeys->addElement( dk );
              row = sklv->addRow();
              sklv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
              tstr = aguix->getNameOfKey( dk->getKeySym( 0 ), dk->getMod( 0 ) );
              if ( tstr != NULL ) {
                sklv->setText( row, 0, tstr );
                _freesafe( tstr );
              } else {
                sklv->setText( row, 0, "???" );
              }
              if ( dk->getType() == WCDoubleShortkey::WCDS_DOUBLE ) {
                tstr = aguix->getNameOfKey( dk->getKeySym( 1 ), dk->getMod( 1 ) );
                if ( tstr != NULL ) {
                  sklv->setText( row, 2, tstr );
                  _freesafe( tstr );
                } else {
                  sklv->setText( row, 2, "???" );
                }
              }
            } else {
              delete dk;
            }
            sklv->redraw();
          }
        } else if ( msg->button.button == skbs[1] ) {
          // delete shortkey
          row = sklv->getActiveRow();
          if ( sklv->isValidRow( row ) == true ) {
            dkeys->removeElementAt( row );
            sklv->deleteRow( row );
            sklv->redraw();
          }
        }
      } else if ( msg->type == AG_SIZECHANGED ) {
        if ( msg->size.window == win->getWindow() ) {
          RESCALE_CONFIGUREBUTTON( msg->size.neww, msg->size.newh );
        }
      } else if ( msg->type == AG_FIELDLV_ONESELECT ) {
        if ( ( msg->fieldlv.lv == lv ) && ( msg->fieldlv.mouse == true ) ) {
          gettimeofday( &tv2, NULL );
          if ( lastrow < 0 ) {
            lastrow = msg->fieldlv.row;
            tv1 = tv2;
          } else {
            if  ( ( msg->fieldlv.row == lastrow ) &&
                  ( aguix->isDoubleClick( &tv2, &tv1 ) == true ) ) {
              if ( lv->isValidRow( lastrow ) == true ) {
                fpr=(FunctionProto*)coms->getElementAt( lastrow );
                fpr->configure();
                lv->setText( lastrow, 0, fpr->getDescription() );
                lv->redraw();
              }
              lastrow = -1;
            } else {
              lastrow = msg->fieldlv.row;
              tv1 = tv2;
            }
          }
        }
      } else if ( msg->type == AG_FIELDLV_MULTISELECT ) {
        lastrow = -1;
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    // Ubernehmen
    wcb1->setText(sg1->getText());
    wcb1->setFG(tsb->getFG());
    wcb1->setBG(tsb->getBG());
    wcb1->setCheck(true);

    WCButton *twcb;
    WCHotkey *twch;
    WCPath *twcp;

    // search for existing shortkey and remove it
    id = dkeys->initEnum();
    dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
    while ( dk != NULL ) {
      if ( findDoubleShortkey( dk, &twcb, &twcp, &twch ) != 0 ) {
        if ( ( twcb != NULL ) && ( twcb != wcb1 ) ) {
          twcb->removeKey( dk );
        } else if ( twcp != NULL ) {
          twcp->removeKey( dk );
        } else if ( twch != NULL ) {
          twch->removeKey( dk );
        }
      }
      dk = (WCDoubleShortkey*)dkeys->getNextElement( id );
    }
    dkeys->closeEnum( id );
    for(t1=0,flags=0;t1<fns->size();t1++) {
      if ( lv2->getSelect( t1 ) == true ) {
        tp = (unsigned long)pow( (double)2, (double)t1 );
        flags+=tp;
      }
    }
    wcb1->getComsGF()->setFlags(flags);
    wcb1->setDoubleKeys( dkeys );
  } else {
    wcb1->setComs(wcb1_bak->getComs());
    wcb1->setDoubleKeys( wcb1_bak->getDoubleKeys() );
  }
  WCGlobalFlags::freeNameOfFlags(fns);
  delete wcb1_bak;
  delete wcb1_bak2;
  configureButtonSize[0] = win->getWidth();
  configureButtonSize[1] = win->getHeight();
  win->close();
  delete win;
  delete req;
  
  delete bs3[0];
  delete bs3[1];
  delete bs3[2];
  delete bs3[3];
  
  return (ende==-1)?false:true;
}

bool WConfig::configureFiletype(WCFiletype *ft1)
{
  WCFiletype *ft1_bak=ft1->duplicate();
  AGUIX *aguix=worker->getAGUIX();
  int w,h,ty;
  int t1;
  AWindow *win=new AWindow(aguix);
  int lastrow, row;
  struct timeval tv1, tv2;
  int trow;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;
  const int cfixnr = cfix +
                     AContainer::ACONT_NORESIZE;
  const int cfixwminh = AContainer::ACONT_MINH +
                        AContainer::ACONT_MINW +
                        AContainer::ACONT_MAXW;
  const int cmin = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW;

  w=10;
  h=10;
  win->create(NULL,10,10,w,h,0,catalog.getLocale(88));
  ty=5;

  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 10 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );
  
  AContainer *ac1_1 = ac1->add( new AContainer( win, 2, 1 ), 0, 0 );
  ac1_1->setMinSpace( 5 );
  ac1_1->setMaxSpace( 5 );
  ac1_1->setBorderWidth( 0 );

  ac1_1->add( new Text( aguix, 0, 0, catalog.getLocale( 89 ), 1 ), 0, 0, cfix );
  StringGadget *sg1 = (StringGadget*)ac1_1->add( new StringGadget( aguix, 0,
                                                                   0, 100, ft1->getName(), 0 ), 1, 0, cincw );

  ac1->add( new Text( aguix, 0, 0, catalog.getLocale( 250 ), 1 ), 0, 1, cincwnr );
  FieldListView *lv0 = (FieldListView*)ac1->add( new FieldListView( aguix, 0, 0, 100, 80, 0 ), 0, 2, cmin );
  lv0->setHBarState(2);
  lv0->setVBarState(2);
  for ( t1 = 0; t1 < 14; t1++ ) {
    trow = lv0->addRow();
    lv0->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
    lv0->setText( trow, 0, catalog.getLocale( 251 + t1 ) );
  }
  lv0->redraw();
  lv0->setActiveRow( 1 );
  
  ac1->add( new Text( aguix, 0, 0, catalog.getLocale( 245 ), 1 ), 0, 3, cincwnr );

  AContainer *ac1_2 = ac1->add( new AContainer( win, 2, 1 ), 0, 4 );
  ac1_2->setMinSpace( 0 );
  ac1_2->setMaxSpace( 0 );
  ac1_2->setBorderWidth( 0 );
  AContainer *ac1_2_1 = ac1_2->add( new AContainer( win, 1, 5 ), 0, 0 );
  ac1_2_1->setMinSpace( 0 );
  ac1_2_1->setMaxSpace( 0 );
  ac1_2_1->setBorderWidth( 0 );
  Button *b2 = (Button*)ac1_2_1->add( new Button( aguix, 0, 0, catalog.getLocale( 246 ), 1, 0, 0 ), 0, 0, cfixwminh );
  Button *b3 = (Button*)ac1_2_1->add( new Button( aguix, 0, 0, catalog.getLocale( 247 ), 1, 0, 0 ), 0, 1, cfixwminh );
  Button *b4 = (Button*)ac1_2_1->add( new Button( aguix, 0, 0, catalog.getLocale( 248 ), 2, 3, 0 ), 0, 2, cfixwminh );
  Button *b5 = (Button*)ac1_2_1->add( new Button( aguix, 0, 0, catalog.getLocale( 236 ), 1, 0, 0 ), 0, 3, cfixwminh );
  Button *b6 = (Button*)ac1_2_1->add( new Button( aguix, 0, 0, catalog.getLocale( 237 ), 1, 0, 0 ), 0, 4, cfixwminh );
  FieldListView *lv = (FieldListView*)ac1_2->add( new FieldListView( aguix,
                                                                     0,
                                                                     0,
                                                                     50,
                                                                     20,
                                                                     0 ), 1, 0, cmin );
  lv->setHBarState(2);
  lv->setVBarState(2);
  lv->setAcceptFocus( true );
  lv->setDisplayFocus( true );

  ac1->add( new Text( aguix, 0, 0, catalog.getLocale( 64 ), 1 ), 0, 5, cincwnr );
  FieldListView *lv2 = (FieldListView*)ac1->add( new FieldListView( aguix, 0, 0, 100, 75, 0 ), 0, 6, cmin );
  lv2->setHBarState(2);
  lv2->setVBarState(2);

  List *fns=WCGlobalFlags::getNameOfFlags();
  char *str=(char*)fns->getFirstElement();
  while(str!=NULL) {
    trow = lv2->addRow();
    lv2->setPreColors( trow, FieldListView::PRECOLOR_ONLYSELECT );
    lv2->setText( trow, 0, str );
    str=(char*)fns->getNextElement();
  }
  lv2->redraw();
  WCGlobalFlags::freeNameOfFlags(fns);

  AContainerBB *ac1_3 = static_cast<AContainerBB*>( ac1->add( new AContainerBB( win, 1, 4 ), 0, 7 ) );
  ac1_3->setMinSpace( 5 );
  ac1_3->setMaxSpace( 5 );
  AContainer *ac1_3_1 = ac1_3->add( new AContainer( win, 3, 1 ), 0, 0 );
  ac1_3_1->setMinSpace( 5 );
  ac1_3_1->setMaxSpace( 5 );
  ac1_3_1->setBorderWidth( 0 );
  ac1_3_1->add( new Text( aguix, 0, 0, catalog.getLocale( 93 ), 1 ), 0, 0, cfix );
  StringGadget *sg2=(StringGadget*)ac1_3_1->add( new StringGadget( aguix, 0,
                                                                   0,
                                                                   100,
                                                                   ft1->getPattern(), 0 ), 1, 0, cincw );
  ChooseButton *cb1 = (ChooseButton*)ac1_3_1->add( new ChooseButton( aguix, 0,
                                                                     0, ft1->getUsePattern(),
                                                                     catalog.getLocale( 94 ), LABEL_LEFT, 1, 1 ), 2, 0,
                                                                     cfixnr );
  
  ChooseButton *cb11 = (ChooseButton*)ac1_3->add( new ChooseButton( aguix,
                                                                    0,
                                                                    0,
                                                                    ft1->getPatternIgnoreCase(),
                                                                    catalog.getLocale( 501 ),
                                                                    LABEL_RIGHT,
                                                                    1,
                                                                    1 ), 0, 1, cincwnr );
  
  ChooseButton *cb12 = (ChooseButton*)ac1_3->add( new ChooseButton( aguix,
                                                                    0,
                                                                    0,
                                                                    ft1->getPatternUseRegExp(),
                                                                    catalog.getLocale( 502 ),
                                                                    LABEL_RIGHT,
                                                                    1,
                                                                    1 ), 0, 2, cincwnr );

  ChooseButton *cb13 = (ChooseButton*)ac1_3->add( new ChooseButton( aguix,
                                                                    0,
                                                                    0,
                                                                    ft1->getPatternUseFullname(),
                                                                    catalog.getLocale( 570 ),
                                                                    LABEL_RIGHT,
                                                                    1,
                                                                    1 ), 0, 3, cincwnr );

  AContainer *ac1_4 = ac1->add( new AContainer( win, 2, 1 ), 0, 8 ); 
  ac1_4->setMinSpace( 5 );
  ac1_4->setMaxSpace( 5 );
  ac1_4->setBorderWidth( 0 );
  Button *b7 = (Button*)ac1_4->add( new Button( aguix, 0, 0, catalog.getLocale( 95 ), 1, 0, 0 ), 0, 0, cincw );
  ChooseButton *cb2 = (ChooseButton*)ac1_4->add( new ChooseButton( aguix, 0,
                                                                   0, ft1->getUseFiledesc(),
                                                                   catalog.getLocale( 96 ), LABEL_LEFT, 1, 1 ), 1, 0,
                                                                   cfixnr );

#if 0  // for filetype checking with file
  //TODO
  tt1 = (Text*)win->add( new Text( aguix,
                                   5,
                                   ty,
                                   /*catalog.getLocale(93)*/"file-output (regular expression or substring):",
                                   1 ) );
  StringGadget *sg3 = (StringGadget*)win->add( new StringGadget( aguix,
                                                                 tt1->getX() + tt1->getWidth() + 5,
                                                                 ty,
                                                                 100,
                                                                 ft1->getFileExp(),
                                                                 0 ) );
  ChooseButton *cb3 = (ChooseButton*)win->add( new ChooseButton( aguix,
                                                                 sg3->getX() + sg3->getWidth() + 5,
                                                                 ty,
                                                                 ft1->getUseFileExp(),
                                                                 /*catalog.getLocale(94)*/"Use file-output",
                                                                 LABEL_LEFT,
                                                                 1,
                                                                 1 ) );
  tw=cb3->getX()+cb3->getWidth()+5;
  if(tw>w) w=tw;
  ty+=sg3->getHeight()+5;
  AGUIX::centerElementsY( tt1, sg3 );
#endif

  AContainer *ac1_5 = ac1->add( new AContainer( win, 2, 1 ), 0, 9 );
  ac1_5->setMinSpace( 5 );
  ac1_5->setMaxSpace( -1 );
  ac1_5->setBorderWidth( 0 );
  Button *okb =(Button*)ac1_5->add( new Button( aguix,
                                                0,
                                                0,
                                                catalog.getLocale( 11 ),
                                                1,
                                                0,
                                                0 ), 0, 0, cfix );
  Button *cancelb = (Button*)ac1_5->add( new Button( aguix,
                                                     0,
                                                     0,
                                                     catalog.getLocale( 8 ),
                                                     1,
                                                     0,
                                                     0 ), 1, 0, cfix );
  win->setDoTabCycling( true );
  win->contMaximize( true );

  if ( ( configureFiletypeSize[0] >= w ) && ( configureFiletypeSize[1] >= h ) ) {
    win->resize( configureFiletypeSize[0], configureFiletypeSize[1] );
  }

  w = win->getWidth();
  h = win->getHeight();

  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  FunctionProto *fpr2,*fpr;
  List *coms=NULL;
  WCGlobalFlags *gf=NULL;
  
  trow = lv0->getActiveRow();
  if ( lv0->isValidRow( trow ) == true ) {
    if(gf!=NULL) {
      applyGlobalFlags(lv2,gf);
    }
    showFTActions( lv0->getText( trow, 0 ).c_str(), ft1, lv, lv2, &coms, &gf );
  }

  lastrow = -1;
  timerclear( &tv1 );
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==b2) {
          if(coms!=NULL) {
            fpr=requestCommand();
            if(fpr!=NULL) {
              coms->addElement(fpr);
              fpr->configureWhenAvail();
              row = lv->addRow();
              lv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
              lv->setText( row, 0, fpr->getDescription() );
              lv->setActiveRow( row );
              lv->showActive();
              lv->redraw();
            }
          }
        } else if(msg->button.button==b3) {
          if(coms!=NULL) {
            row = lv->getActiveRow();
            if ( lv->isValidRow( row ) == true ) {
              fpr=(FunctionProto*)coms->getElementAt( row );
              delete fpr;
              coms->removeElementAt( row );
              lv->deleteRow( row );
              if ( lv->isValidRow( row ) == true )
                lv->setActiveRow( row );
              else
                lv->setActiveRow( row - 1 );
              lv->showActive();
              lv->redraw();
            }
          }
        } else if(msg->button.button==b4) {
          if(coms!=NULL) {
            row = lv->getActiveRow();
            if ( lv->isValidRow( row ) == true ) {
              fpr=(FunctionProto*)coms->getElementAt( row );
              fpr->configure();
              lv->setText( row, 0, fpr->getDescription() );
              lv->redraw();
            }
          }
        } else if(msg->button.button==b5) {
          if(coms!=NULL) {
            row = lv->getActiveRow();
            if ( lv->isValidRow( row ) == true ) {
              if ( row > 0 ) {
                fpr = (FunctionProto*)coms->getElementAt( row );
                fpr2 = (FunctionProto*)coms->exchangeElement( row - 1, fpr );
                coms->exchangeElement( row, fpr2 );
                lv->swapRows( row, row - 1 );
                lv->showActive();
                lv->redraw();
              }
            }
          }
        } else if(msg->button.button==b6) {
          if(coms!=NULL) {
            row = lv->getActiveRow();
            if ( lv->isValidRow( row ) == true ) {
              if ( row < ( lv->getElements() - 1 ) ) {
                fpr = (FunctionProto*)coms->getElementAt( row );
                fpr2 = (FunctionProto*)coms->exchangeElement( row + 1, fpr );
                coms->exchangeElement( row, fpr2 );
                lv->swapRows( row, row + 1 );
                lv->showActive();
                lv->redraw();
              }
            }
          }
        } else if(msg->button.button==b7) {
          if(changeFiledesc(ft1)==true) {
            cb2->setState(1);
          }
        }
      } else if(msg->type==AG_STRINGGADGET_DEACTIVATE) {
        if(msg->stringgadget.sg==sg2) cb1->setState(1);
#if 0  // for filetype checking with file
        else if ( msg->stringgadget.sg == sg3 ) cb3->setState( 1 );
#endif
      } else if ( msg->type == AG_SIZECHANGED ) {
      } else if ( ( msg->type == AG_FIELDLV_ONESELECT ) || ( msg->type == AG_FIELDLV_MULTISELECT ) ) {
        if ( ( msg->type == AG_FIELDLV_ONESELECT ) &&
	     ( msg->fieldlv.lv == lv ) &&
	     ( msg->fieldlv.mouse == true ) ) {
          gettimeofday( &tv2, NULL );
          if ( lastrow < 0 ) {
            lastrow = msg->fieldlv.row;
            tv1 = tv2;
          } else {
            if(coms!=NULL) {
              if  ( ( msg->fieldlv.row == lastrow ) &&
                    ( aguix->isDoubleClick( &tv2, &tv1 ) == true ) ) {
                if ( lv->isValidRow( lastrow ) == true ) {
                  fpr=(FunctionProto*)coms->getElementAt( lastrow );
                  fpr->configure();
                  lv->setText( lastrow, 0, fpr->getDescription() );
                  lv->redraw();
                }
                lastrow = -1;
              } else {
                lastrow = msg->fieldlv.row;
                tv1 = tv2;
              }
            }
          }
        } else if ( msg->fieldlv.lv == lv0 ) {
          // Nur das Aktions-LV interessiert
          trow = lv0->getActiveRow();
          if ( lv0->isValidRow( trow ) == true ) {
            if(gf!=NULL) {
              applyGlobalFlags(lv2,gf);
            }
            showFTActions( lv0->getText( trow, 0 ).c_str(), ft1, lv, lv2, &coms, &gf );
          }
        }
      } else if ( msg->type == AG_FIELDLV_MULTISELECT ) {
        lastrow = -1;
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    // Uebernehmen
    if(gf!=NULL) {
      applyGlobalFlags(lv2,gf);
    }
    ft1->setName(sg1->getText());
    ft1->setPattern(sg2->getText());
    ft1->setUsePattern((cb1->getState()==0)?false:true);
    ft1->setPatternIgnoreCase( ( cb11->getState() == 0 ) ? false : true );
    ft1->setPatternUseRegExp( ( cb12->getState() == 0 ) ? false : true );
    ft1->setPatternUseFullname( ( cb13->getState() == 0 ) ? false : true );
    ft1->setUseFiledesc((cb2->getState()==0)?false:true);
#if 0  // for filetype checking with file
    ft1->setUseFileExp( ( cb3->getState() == 0 ) ? false : true );
    ft1->setFileExp( sg3->getText() );
#endif
  } else {
    ft1->setDNDActions(ft1_bak->getDNDActions());
    ft1->setDoubleClickActions(ft1_bak->getDoubleClickActions());
    ft1->setShowActions(ft1_bak->getShowActions());
    ft1->setRawShowActions(ft1_bak->getRawShowActions());
    ft1->setUserActions(0,ft1_bak->getUserActions(0));
    ft1->setUserActions(1,ft1_bak->getUserActions(1));
    ft1->setUserActions(2,ft1_bak->getUserActions(2));
    ft1->setUserActions(3,ft1_bak->getUserActions(3));
    ft1->setUserActions(4,ft1_bak->getUserActions(4));
    ft1->setUserActions(5,ft1_bak->getUserActions(5));
    ft1->setUserActions(6,ft1_bak->getUserActions(6));
    ft1->setUserActions(7,ft1_bak->getUserActions(7));
    ft1->setUserActions(8,ft1_bak->getUserActions(8));
    ft1->setUserActions(9,ft1_bak->getUserActions(9));
    ft1->setFiledesc(ft1_bak->getFiledesc());
  }
  delete ft1_bak;
  configureFiletypeSize[0] = win->getWidth();
  configureFiletypeSize[1] = win->getHeight();
  win->close();
  delete win;

  return (ende==-1)?false:true;
}

void WConfig::showFTActions( const char *actionname,
                             WCFiletype *ft,
                             FieldListView *lv1,
                             FieldListView *lv2,
                             List **return_list,
                             WCGlobalFlags **return_flags)
{
  List *l1=NULL;
  WCGlobalFlags *gf1=NULL;
  int row;
  
  if(strcmp(actionname,catalog.getLocale(251))==0) {
    // DND
    l1=ft->getDNDActions();
    gf1=ft->getDNDActionsGF();
  } else if(strcmp(actionname,catalog.getLocale(252))==0) {
    // DoubleClick
    l1=ft->getDoubleClickActions();
    gf1=ft->getDoubleClickActionsGF();
  } else if(strcmp(actionname,catalog.getLocale(253))==0) {
    // Show
    l1=ft->getShowActions();
    gf1=ft->getShowActionsGF();
  } else if(strcmp(actionname,catalog.getLocale(254))==0) {
    // RawShow
    l1=ft->getRawShowActions();
    gf1=ft->getRawShowActionsGF();
  } else if(strcmp(actionname,catalog.getLocale(255))==0) {
    // User0
    l1=ft->getUserActions(0);
    gf1=ft->getUserActionsGF(0);
  } else if(strcmp(actionname,catalog.getLocale(256))==0) {
    // User1
    l1=ft->getUserActions(1);
    gf1=ft->getUserActionsGF(1);
  } else if(strcmp(actionname,catalog.getLocale(257))==0) {
    // User2
    l1=ft->getUserActions(2);
    gf1=ft->getUserActionsGF(2);
  } else if(strcmp(actionname,catalog.getLocale(258))==0) {
    // User3
    l1=ft->getUserActions(3);
    gf1=ft->getUserActionsGF(3);
  } else if(strcmp(actionname,catalog.getLocale(259))==0) {
    // User4
    l1=ft->getUserActions(4);
    gf1=ft->getUserActionsGF(4);
  } else if(strcmp(actionname,catalog.getLocale(260))==0) {
    // User5
    l1=ft->getUserActions(5);
    gf1=ft->getUserActionsGF(5);
  } else if(strcmp(actionname,catalog.getLocale(261))==0) {
    // User6
    l1=ft->getUserActions(6);
    gf1=ft->getUserActionsGF(6);
  } else if(strcmp(actionname,catalog.getLocale(262))==0) {
    // User7
    l1=ft->getUserActions(7);
    gf1=ft->getUserActionsGF(7);
  } else if(strcmp(actionname,catalog.getLocale(263))==0) {
    // User8
    l1=ft->getUserActions(8);
    gf1=ft->getUserActionsGF(8);
  } else if(strcmp(actionname,catalog.getLocale(264))==0) {
    // User9
    l1=ft->getUserActions(9);
    gf1=ft->getUserActionsGF(9);
  }
  int id=l1->initEnum();
  FunctionProto *fpr=(FunctionProto*)l1->getFirstElement(id);
  lv1->setSize( 0 );
  while(fpr!=NULL) {
    row = lv1->addRow();
    lv1->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
    lv1->setText( row, 0, fpr->getDescription() );
    fpr=(FunctionProto*)l1->getNextElement(id);
  }
  l1->closeEnum(id);
  lv1->redraw();

  unsigned long flags=gf1->getFlags(),tp;
  int t1;
  t1=0;
  List *fns=WCGlobalFlags::getNameOfFlags();
  for(t1=0;t1<fns->size();t1++) {
    tp = (unsigned long)pow( (double)2, (double)t1 );
    if((flags&tp)==tp) {
      lv2->setSelect( t1, true );
    } else lv2->setSelect( t1, false );
    t1++;
  }
  WCGlobalFlags::freeNameOfFlags(fns);

  if(return_list!=NULL) *return_list=l1;
  if(return_flags!=NULL) *return_flags=gf1;
}

void WConfig::applyGlobalFlags( FieldListView *lv, WCGlobalFlags *gf )
{
  unsigned long flags=0,tp;
  List *fns=WCGlobalFlags::getNameOfFlags();
  for(int t1=0;t1<fns->size();t1++) {
    if ( lv->getSelect( t1 ) == true ) {
      tp = (unsigned long)pow( (double)2, (double)t1 );
      flags+=tp;
    }
  }
  gf->setFlags(flags);
  WCGlobalFlags::freeNameOfFlags(fns);
}

bool WConfig::changeFiledesc(WCFiletype *ft)
{
  WCFiletype *ft_bak=ft->duplicate();
  AGUIX *aguix=worker->getAGUIX();
  short *filedesc=ft->getFiledesc();
  int tw,w,h,ty;
  int t1,t2;
  char *str;
  AWindow *win=new AWindow(aguix);
  int trow;
  
  w=100;
  h=10;
  win->create(NULL,10,10,w,h,0,catalog.getLocale(101));
  ty=5;
  FieldListView *lv = (FieldListView*)win->add( new FieldListView( aguix, 5, ty, w - 10, 150, 0 ) );
  lv->setHBarState(2);
  lv->setVBarState(2);
  for(t1=0;t1<64;t1++) {
    str=getStr4Char(t1,filedesc[t1]);
    trow = lv->addRow();
    lv->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
    lv->setText( trow, 0, str );
    _freesafe(str);
  }
  lv->redraw();
  ty+=lv->getHeight()+5;
  
  t1=strlen(catalog.getLocale(98))+2;
  t1*=aguix->getCharWidth();
  Button *b1=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(98),1,0,0));
  t2=b1->getWidth();
  t1=strlen(catalog.getLocale(99))+2;
  t1*=aguix->getCharWidth();
  Button *b2=(Button*)win->add(new Button(aguix,5+t2+5,ty,t1,catalog.getLocale(99),1,0,0));
  tw=b2->getX()+b2->getWidth()+5;
  if(tw>w) w=tw;
  ty+=b2->getHeight()+5;
  t1=strlen(catalog.getLocale(100))+2;
  t1*=aguix->getCharWidth();
  if((t1+10)<w) t1=w-10;
  Button *b3=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(100),1,0,0));
  tw=b3->getX()+b3->getWidth()+5;
  if(tw>w) w=tw;
  ty+=b3->getHeight()+5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->setDoTabCycling( true );
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  lv->resize(w-10,lv->getHeight());
  b2->move(w-5-b2->getWidth(),b2->getY());
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==b1) {
          trow = lv->getActiveRow();
          if ( lv->isValidRow( trow ) == true ) {
            t2 = WCEditByte( filedesc[trow] );
            if(t2>=0) {
              filedesc[trow] = t2;
              str=getStr4Char( trow,t2);
              lv->setText( trow, 0, str );
              _freesafe(str);
              lv->redraw();
            }
          }
        } else if(msg->button.button==b2) {
          trow = lv->getActiveRow();
          if ( lv->isValidRow( trow ) == true ) {
            t2=-1;
            filedesc[trow] = t2;
            str = getStr4Char( trow, t2 );
            lv->setText( trow, 0, str );
            _freesafe(str);
            lv->redraw();
          }
        } else if(msg->button.button==b3) {
          win->hide();
          if(FTautocreate(ft)==true) {
            for(t1=0;t1<64;t1++) {
              str=getStr4Char(t1,filedesc[t1]);
              lv->setText( t1, 0, str );
              _freesafe(str);
            }
          }
          win->show();
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    ft->setFiledesc(ft_bak->getFiledesc());
  } else {
    for(t1=63;t1>=0;t1--) {
      if(filedesc[t1]>=0) {
        if(t1<63) filedesc[t1+1]=-2;
        break;
      }
    }
    if(t1<1) if(filedesc[t1]<0) filedesc[t1]=-2;
  }
  delete ft_bak;
  win->close();
  delete win;
  return (ende==-1)?false:true;
}

char *WConfig::getStr4Char(int index2,short ch)
{
  char *str = (char*)_allocsafe( A_BYTESFORNUMBER( index2 ) + 1 + strlen( catalog.getLocale( 97 ) ) + 2 + 1 );
  char buf[ A_BYTESFORNUMBER( int ) + 1 + A_BYTESFORNUMBER( char ) ];
  std::string str1;
  
  sprintf(str,"%2d.%s: ",index2,catalog.getLocale(97));
  str1 = str;
  _freesafe( str );
  if(ch>=0) {
    sprintf(buf,"%3d %c",ch,ch);
    str1 += buf;
  }
  return dupstring( str1.c_str() );
}

int WConfig::WCEditByte(int ch)
{
  int return_byte;
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1,t2;
  char buf[ A_BYTESFORNUMBER( int ) ];
  AWindow *win=new AWindow(aguix);
  w=100;
  h=10;
  win->create(NULL,10,10,w,h,0,catalog.getLocale(98));
  ty=5;
  Text *tt1=(Text*)win->add(new Text(aguix,5,ty,catalog.getLocale(102),1));
  ty+=tt1->getHeight()+5;
  tw=tt1->getWidth()+10;
  if(tw>w) w=tw;
  if(ch>=0) sprintf(buf,"%d",ch); else buf[0]=0;
  t1=6*aguix->getCharWidth();
  StringGadget *sg=(StringGadget*)win->add(new StringGadget(aguix,5,ty,t1,buf,0));
  if(ch>=0) sprintf(buf,"%c",ch); else buf[0]=0;
  tt1=(Text*)win->add(new Text(aguix,sg->getX()+sg->getWidth()+5,ty,buf,1));
  tw=tt1->getX()+tt1->getWidth()+5;
  if(tw>w) w=tw;
  ty+=sg->getHeight()+5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  win->setDoTabCycling( true );
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  return_byte=ch;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
      } else if(msg->type==AG_STRINGGADGET_DEACTIVATE) {
        t1=-1;
        sscanf(sg->getText(),"%d",&t1);
        if(t1<0) t1=0;
        else if(t1>255) t1=255;
        sprintf(buf,"%d",t1);
        sg->setText(buf);
        sprintf(buf,"%c",t1);
        tt1->setText(buf);
        return_byte=t1;
      } else if(msg->type==AG_KEYPRESSED) {
        if(sg->isActive()==false) {
          t1=msg->key.key;
          if(t1<=0xff) {
            sprintf(buf,"%d",t1);
            sg->setText(buf);
            sprintf(buf,"%c",t1);
            tt1->setText(buf);
            return_byte=t1;
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  win->close();
  delete win;
  return (ende==-1)?-1:return_byte;
}

bool WConfig::FTautocreate(WCFiletype *ft)
{
  AGUIX *aguix=worker->getAGUIX();
  int tw,w,h,ty;
  int t1,t2,i;
  char *str;
  Text *tt[3];
  StringGadget *sg[3];
  Button *fb[3];
  AWindow *win=new AWindow(aguix);
  FileRequester *frq=new FileRequester(aguix);
  bool dirSet = false;
  GUIElement *bs[2];

  w=100;
  h=10;
  win->create(NULL,10,10,w,h,0,catalog.getLocale(100));
  ty=5;
  str = (char*)_allocsafe( strlen( catalog.getLocale( 103 ) ) + 1 + A_BYTESFORNUMBER( int ) + 1 );
  for(i=0;i<3;i++) {
    sprintf(str,"%s %d",catalog.getLocale(103),i+1);
    tt[i]=(Text*)win->add(new Text(aguix,5,ty,str,1));
    sg[i]=(StringGadget*)win->add(new StringGadget(aguix,tt[i]->getX()+tt[i]->getWidth()+5,
                                                   ty,100,"",0));
    fb[i]=(Button*)win->add(new Button(aguix,sg[i]->getX()+sg[i]->getWidth(),ty,
                                       sg[i]->getHeight(),sg[i]->getHeight(),"",1,0,0));
    tw=fb[i]->getX()+fb[i]->getWidth()+5;
    if(tw>w) w=tw;
    ty+=sg[i]->getHeight()+5;
  }
  _freesafe(str);

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 w-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h=okb->getY()+okb->getHeight()+5;
  
  bs[0] = okb;
  bs[1] = cancelb;
  
  win->setDoTabCycling( true );
  win->resize(w,h);
  for(i=0;i<3;i++) {
    fb[i]->move(w-5-fb[i]->getWidth(),fb[i]->getY());
    sg[i]->resize(fb[i]->getX()-sg[i]->getX(),sg[i]->getHeight());
  }
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else {
          for(t1=0;t1<3;t1++) {
            if(msg->button.button==fb[t1]) {
              if ( dirSet == false ) {
                str=ParentDir(home,NULL);
                dirSet = true;
              } else {
                str = dupstring("");
              }
              if(frq->request(catalog.getLocale(265),str,catalog.getLocale(11),catalog.getLocale(8),catalog.getLocale(266))!=0) {
                FileEntry *fe=frq->getFirstFE();
                if(fe!=NULL) sg[t1]->setText(fe->fullname);
              }
              _freesafe(str);
            }
          }
        }
      } else if ( msg->type == AG_SIZECHANGED ) {
        if ( msg->size.window == win->getWindow() ) {
          AGUIX::scaleElementsW( msg->size.neww, 5, 10, -1, false, false, bs, NULL, 2 );
          okb->move( okb->getX(), msg->size.newh - 5 - okb->getHeight() );
          cancelb->move( cancelb->getX(), msg->size.newh - 5 - cancelb->getHeight() );
          for ( i = 0; i < 3; i++ ) {
            fb[i]->move( msg->size.neww - 5 - fb[i]->getWidth(), fb[i]->getY() );
            sg[i]->resize( fb[i]->getX() - sg[i]->getX(), sg[i]->getHeight() );
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
    if(ende==1) {
      // Pruefen, ob Dateien existieren
      if(Datei::fileExists(sg[0]->getText())==false) ende=0;
      if(Datei::fileExists(sg[1]->getText())==false) ende=0;
      if(Datei::fileExists(sg[2]->getText())==false) ende=0;
      if(ende==0) {
        // Hinweis
        Requester *req=new Requester(aguix);
        req->request(catalog.getLocale(124),catalog.getLocale(267),catalog.getLocale(11));
        delete req;
      }
    }
  }
  if(ende==1) {
    PDatei *fh[3];
    for(t1=0,t2=0;t1<3;t1++) {
      fh[t1] = new PDatei();
      if ( fh[t1]->open( sg[t1]->getText() ) == 0 ) t2++;
    }
    if(t2==3) {
      unsigned char buffer[3][64],c1,c2,c3;
      short int filedesc[64];
      for(t1=0;t1<3;t1++) {
        fh[t1]->read( buffer[t1], 64 );
      }
      for(t1=0;t1<64;t1++) {
        c1=buffer[0][t1];
        c2=buffer[1][t1];
        c3=buffer[2][t1];
        if((c1==c2)&&(c2==c3)&&(c1!=0)) {
          filedesc[t1]=c1;
        } else {
          filedesc[t1]=-1;
        } 
      }
      ft->setFiledesc(filedesc);
    }
    for(t1=0;t1<3;t1++) fh[t1]->close();
  }
  win->close();
  delete win;
  delete frq;
  return (ende==-1)?false:true;
}

bool WConfig::save()
{
  int len=strlen(home);
  bool ret;
  
  if(len<1) return false;
  char *textstr;

  char *str=(char*)_allocsafe((len+1+8+2)*sizeof(char));
  strcpy(str,home);
  if(len>1) if(home[len-1]!='/') strcat(str,"/");
#ifdef USEOWNCONFIGFILES
  strcat(str,"wconfig2");
#else
  strcat(str,"config");
#endif
  if(Datei::lfileExistsExt(home)!=Datei::D_FE_DIR) {
    // no home dir, try to create one
    if(mkdir(home,S_IRUSR|S_IXUSR|S_IWUSR)!=0) {
      Requester *req=new Requester(worker->getAGUIX());
      textstr=(char*)_allocsafe(strlen(catalog.getLocale(127))+strlen(home)+1);
      sprintf(textstr,catalog.getLocale(127),home);
      req->request(catalog.getLocale(347),textstr,catalog.getLocale(11));
      _freesafe(textstr);
      delete req;
    }
  }
  ret=saveas(str);
  _freesafe(str);

  currentConfigTime = time( NULL );
  return ret;
}

bool WConfig::saveas(char *file)
{
  int id;
  char *tstr;
  char buf[3 * A_BYTESFORNUMBER( int ) + 3 ];
  std::string str1;
  int i;
  unsigned int j;
  std::list<layoutID_t>::iterator it1;
  
  Datei *fh = new Datei();
  if ( fh->open( file, "w" ) == 0 ) {
    sectiondepth = 0;
    sprintf( buf, "%d.%d.%d", WORKER_MAJOR, WORKER_MINOR, WORKER_PATCH );
    str1 = "workerconfig ";
    str1 += buf;
    str1 += ";";
    fh->putLine( str1.c_str() );
    configOpenSection( fh, "global" );
    configPutPairString( fh, "lang", lang );
    configPutPairNum( fh, "rows", rows );
    configPutPairNum( fh, "columns", columns );
    configPutPairNum( fh, "cachesize", cachesize );
    configOpenSection( fh, "listersets" );
    configOpenSection( fh, "left" );
    configPutPairBool( fh, "hbartop", hbar_top[0] );
    configPutPairNum( fh, "hbarheight", hbar_height[0] );
    configPutPairBool( fh, "vbarleft", vbar_left[0] );
    configPutPairNum( fh, "vbarwidth", vbar_width[0] );
    configPutPairBool( fh, "showheader", showHeader[0] );
    configOpenSection( fh, "displaysets" );
    for ( j = 0; j < viscols[0].size(); j++ ) {
      switch ( viscols[0][j] ) {
        case WorkerTypes::LISTCOL_SIZE:
          configPutInfo( fh, "size", true );
          break;
        case WorkerTypes::LISTCOL_TYPE:
          configPutInfo( fh, "type", true );
          break;
        case WorkerTypes::LISTCOL_PERM:
          configPutInfo( fh, "permission", true );
          break;
        case WorkerTypes::LISTCOL_OWNER:
          configPutInfo( fh, "owner", true );
          break;
        case WorkerTypes::LISTCOL_DEST:
          configPutInfo( fh, "destination", true );
          break;
        case WorkerTypes::LISTCOL_MOD:
          configPutInfo( fh, "modtime", true );
          break;
        case WorkerTypes::LISTCOL_ACC:
          configPutInfo( fh, "acctime", true );
          break;
        case WorkerTypes::LISTCOL_CHANGE:
          configPutInfo( fh, "chgtime", true );
          break;
        case WorkerTypes::LISTCOL_INODE:
          configPutInfo( fh, "inode", true );
          break;
        case WorkerTypes::LISTCOL_NLINK:
          configPutInfo( fh, "nlink", true );
          break;
        case WorkerTypes::LISTCOL_BLOCKS:
          configPutInfo( fh, "blocks", true );
          break;
        default:
          configPutInfo( fh, "name", true );
          break;
      }
    }
    configCloseSection( fh ); //displaysets
    configCloseSection( fh ); //left
    configOpenSection( fh, "right" );
    configPutPairBool( fh, "hbartop", hbar_top[1] );
    configPutPairNum( fh, "hbarheight", hbar_height[1] );
    configPutPairBool( fh, "vbarleft", vbar_left[1] );
    configPutPairNum( fh, "vbarwidth", vbar_width[1] );
    configPutPairBool( fh, "showheader", showHeader[1] );
    configOpenSection( fh, "displaysets" );
    for ( j = 0; j < viscols[1].size(); j++ ) {
      switch ( viscols[1][j] ) {
        case WorkerTypes::LISTCOL_SIZE:
          configPutInfo( fh, "size", true );
          break;
        case WorkerTypes::LISTCOL_TYPE:
          configPutInfo( fh, "type", true );
          break;
        case WorkerTypes::LISTCOL_PERM:
          configPutInfo( fh, "permission", true );
          break;
        case WorkerTypes::LISTCOL_OWNER:
          configPutInfo( fh, "owner", true );
          break;
        case WorkerTypes::LISTCOL_DEST:
          configPutInfo( fh, "destination", true );
          break;
        case WorkerTypes::LISTCOL_MOD:
          configPutInfo( fh, "modtime", true );
          break;
        case WorkerTypes::LISTCOL_ACC:
          configPutInfo( fh, "acctime", true );
          break;
        case WorkerTypes::LISTCOL_CHANGE:
          configPutInfo( fh, "chgtime", true );
          break;
        case WorkerTypes::LISTCOL_INODE:
          configPutInfo( fh, "inode", true );
          break;
        case WorkerTypes::LISTCOL_NLINK:
          configPutInfo( fh, "nlink", true );
          break;
        case WorkerTypes::LISTCOL_BLOCKS:
          configPutInfo( fh, "blocks", true );
          break;
        default:
          configPutInfo( fh, "name", true );
          break;
      }
    }
    configCloseSection( fh );//displaysets
    configCloseSection( fh );//right
    configCloseSection( fh );//listersets
    
    configPutPairString( fh, "terminal", terminalbin );
    if ( ownerstringtype == 1 ) configPutPair( fh, "ownerstyle", "style2" );
    else configPutPair( fh, "ownerstyle", "style1" );

    configPutPairBool( fh, "usestringfordirsize", showStringForDirSize );
    //configPutPairString( fh, "stringfordirsize", stringForDirSize );

    configOpenSection( fh, "timesets" );
    if ( date_format == 1 ) configPutPair( fh, "date", "style2" );
    else if ( date_format == 2 ) configPutPair( fh, "date", "style3" );
    else if ( date_format == -1 ) configPutPair( fh, "date", "userstyle" );
    else configPutPair( fh, "date", "style1" );
    configPutPairString( fh, "datestring", date_formatstring );
    configPutPairBool( fh, "datesubstitution", date_subst );
    if ( time_format == 1 ) configPutPair( fh, "time", "style2" );
    else if ( time_format == -1 ) configPutPair( fh, "time", "userstyle" );
    else configPutPair( fh, "time", "style1" );
    configPutPairString( fh, "timestring", time_formatstring );
    configPutPairBool( fh, "datebeforetime", date_before_time );
    configCloseSection( fh ); //timesets

    configOpenSection( fh, "palette" );
    i = 0;
    id = colors->initEnum();
    WC_Color *col = (WC_Color*)colors->getFirstElement( id );
    while ( col != NULL ) {
      sprintf( buf, "%d", i );
      str1 = buf;
      str1 += " = ";
      sprintf( buf, "%d", col->getRed() );
      str1 += buf;
      str1 += ",";
      sprintf( buf, "%d", col->getGreen() );
      str1 += buf;
      str1 += ",";
      sprintf( buf, "%d", col->getBlue() );
      str1 += buf;
      str1 += ";";
      configPutInfo( fh, str1.c_str(), false );
      col = (WC_Color*)colors->getNextElement( id );
      i++;
    }
    colors->closeEnum( id );
    configCloseSection( fh ); //palette

    configOpenSection( fh, "layout" );
    configPutPairBool( fh, "buttonsvertical", layoutConf.buttonVert );
    configPutPairBool( fh, "listviewsvertical", layoutConf.listviewVert );
    for ( it1 = layoutConf.orders.begin(); it1 != layoutConf.orders.end(); it1++ ) {
      switch ( *it1 ) {
        case LO_STATEBAR:
          configPutInfo( fh, "statebar", true );
          break;
        case LO_CLOCKBAR:
          configPutInfo( fh, "clockbar", true );
          break;
        case LO_BUTTONS:
          configPutInfo( fh, "buttons", true );
          break;
        case LO_LISTVIEWS:
          configPutInfo( fh, "listviews", true );
          break;
        case LO_BLL:
          configPutInfo( fh, "bll", true );
          break;
        case LO_LBL:
          configPutInfo( fh, "lbl", true );
          break;
        case LO_LLB:
          configPutInfo( fh, "llb", true );
          break;
        case LO_BL:
          configPutInfo( fh, "bl", true );
          break;
        case LO_LB:
          configPutInfo( fh, "lb", true );
          break;
        default:
          break;
      }
    }
    configCloseSection( fh ); //layout

    configCloseSection( fh );//global

    configOpenSection( fh, "colors" );
    configPutPairNum( fh, "statebar", statusbar[0], statusbar[1] );
    configPutPairNum( fh, "sellvbar", sel_lvb[0], sel_lvb[1] );
    configPutPairNum( fh, "unsellvbar", unsel_lvb[0], unsel_lvb[1] );
    configPutPairNum( fh, "seldir", sel_dir[0], sel_dir[1] );
    configPutPairNum( fh, "unseldir", unsel_dir[0], unsel_dir[1] );
    configPutPairNum( fh, "selfile", sel_file[0], sel_file[1] );
    configPutPairNum( fh, "unselfile", unsel_file[0], unsel_file[1] );
    configPutPairNum( fh, "clockbar", clockbar[0], clockbar[1] );
    configPutPairNum( fh, "selactdir", sel_dir_act[0], sel_dir_act[1] );
    configPutPairNum( fh, "unselactdir", unsel_dir_act[0], unsel_dir_act[1] );
    configPutPairNum( fh, "selactfile", sel_file_act[0], sel_file_act[1] );
    configPutPairNum( fh, "unselactfile", unsel_file_act[0], unsel_file_act[1] );
    configPutPairNum( fh, "requester", request[0], request[1] );
    configPutPairNum( fh, "lvheader", lvheader[0], lvheader[1] );
    configPutPairNum( fh, "lvbg", listerbg );
    configCloseSection( fh ); //colors

    configOpenSection( fh, "startup" );
    configPutPairString( fh, "left", dir[0] );
    configPutPairString( fh, "right", dir[1] );
    configCloseSection( fh ); //startup

    configOpenSection( fh, "fonts" );
    configPutPairString( fh, "globalfont", fonts[0] );
    configPutPairString( fh, "buttonfont", fonts[1] );
    configPutPairString( fh, "leftfont", fonts[2] );
    configPutPairString( fh, "rightfont", fonts[3] );
    configCloseSection( fh ); //fonts
    
    configOpenSection( fh, "clockbarsets" );
    switch(clockbar_mode) {
      case CLOCKBAR_MODE_TIME:
        configPutPair( fh, "modus", "time" );
        break;
      case CLOCKBAR_MODE_VERSION:
        configPutPair( fh, "modus", "version" );
        break;
      case CLOCKBAR_MODE_EXTERN:
        configPutPair( fh, "modus", "extern" );
        break;
      default:
        configPutPair( fh, "modus", "timespace" );
        break;
    }
    configPutPairNum( fh, "updatetime", clockbar_updatetime );
    configPutPairString( fh, "program", clockbar_command );
    configCloseSection( fh ); //clockbarsets
    
    configOpenSection( fh, "paths" );
    i = 0;
    id = paths->initEnum();
    WCPath *p1 = (WCPath*)paths->getFirstElement( id );
    while ( p1 != NULL ) {
      if ( p1->getCheck() != false ) {
        configOpenSection( fh, "path" );
        configPutPairNum( fh, "position", i );
        p1->save( fh );
        configCloseSection( fh ); //path
      }
      p1 = (WCPath*)paths->getNextElement( id );
      i++;
    }
    paths->closeEnum( id );
    configCloseSection( fh ); //paths

    configOpenSection( fh, "hotkeys" );
    id = hotkeys->initEnum();
    WCHotkey *h1 = (WCHotkey*)hotkeys->getFirstElement( id );
    while(h1!=NULL) {
      configOpenSection( fh, "hotkey" );
      h1->save( fh );
      configCloseSection( fh ); //hotkey
      h1 = (WCHotkey*)hotkeys->getNextElement( id );
    }
    hotkeys->closeEnum( id );
    configCloseSection( fh ); //hotkeys

    configOpenSection( fh, "buttons" );
    i = 0;
    id = buttons->initEnum();
    WCButton *b1 = (WCButton*)buttons->getFirstElement( id );
    while ( b1 != NULL ) {
      if ( b1->getCheck() != false ) {
        configOpenSection( fh, "button" );
        configPutPairNum( fh, "position", i );
        b1->save( fh );
        configCloseSection( fh ); //button
      }
      b1 = (WCButton*)buttons->getNextElement( id );
      i++;
    }
    buttons->closeEnum( id );
    configCloseSection( fh ); //buttons

    configOpenSection( fh, "filetypes" );
    id = filetypes->initEnum();
    WCFiletype *f1 = (WCFiletype*)filetypes->getFirstElement( id );
    while ( f1 != NULL ) {
      configOpenSection( fh, "filetype" );
      f1->save( fh );
      configCloseSection( fh ); //filetype
      f1 = (WCFiletype*)filetypes->getNextElement( id );
    }
    filetypes->closeEnum( id );

    configOpenSection( fh, "ignoredirs" );
    id = dontcheckdirs->initEnum();
    tstr = (char*)dontcheckdirs->getFirstElement( id );
    while ( tstr != NULL ) {
      configPutString( fh, tstr, true );
      tstr = (char*)dontcheckdirs->getNextElement( id );
    }
    dontcheckdirs->closeEnum( id );
    configCloseSection( fh ); //ignoredirs

    configCloseSection( fh ); //filetypes

    fh->close();
    delete fh;
  } else {
    Requester *req=new Requester(worker->getAGUIX());
    char *textstr;
    textstr=(char*)_allocsafe(strlen(catalog.getLocale(40))+strlen(file)+1);
    sprintf(textstr,catalog.getLocale(40),file);
    req->request(catalog.getLocale(347),textstr,catalog.getLocale(11));
    _freesafe(textstr);
    delete req;
    delete fh;
    return false;
  }
  return true;
}

bool WConfig::load()
{
  int len=strlen(home);
  bool ret=false;
  if(len<1) return false;
  
  if(Datei::lfileExistsExt(home)==Datei::D_FE_NOFILE) {
    // no .worker so show an hint for starting "worker.inst"
    const char *buttonstr;
    const char *textstr;
    Requester *req;
    
    buttonstr=catalog.getLocale(11);
    textstr="There is no Worker configuration directory.|Worker will continue and use an intern configuration!";
    req=new Requester(worker->getAGUIX());
    req->request(catalog.getLocale(124),textstr,buttonstr);
    delete req;
  } else {
    char *str=(char*)_allocsafe((len+1+8+2)*sizeof(char));
    strcpy(str,home);
    if(len>1) if(home[len-1]!='/') strcat(str,"/");
#ifdef USEOWNCONFIGFILES
    strcat(str,"wconfig2");
#else
    strcat(str,"config");
#endif
    ret=loadfrom(str);
    _freesafe(str);

    currentConfigTime = time( NULL );
  }
  return ret;
}

bool WConfig::loadfrom(char *file)
{
  Datei *fh;
  char buf[5];
  FILE *fp;
  char *tstr;
  
  if ( file == NULL ) return false;
  fh = new Datei();
  if ( fh->open( file, "r" ) == 0 ) {
    fh->getString( buf, 4 );
    fh->close();
    delete fh;
    if ( strcmp( buf, "FORM" ) == 0 ) {
      // 2er binary config
      return loadBinConfig( file );
    } else {
      // looks like new textconfig
      lconfig = this;
      fp = fopen( file, "r" );
      if ( fp != NULL ) {
        yyrestart( fp );
        if ( yymyparse() != 0 ) {
          // there was an error but after the requester I will
          // continue with the partly read config
          tstr = (char*)_allocsafe( strlen( catalog.getLocale( 539 ) ) +
                                    A_BYTESFORNUMBER(int) +
                                    strlen( lconfig_error ) + 1 );
          sprintf( tstr, catalog.getLocale( 539 ), lconfig_linenr + 1,
                   lconfig_error );
          Worker::getRequester()->request( catalog.getLocale( 347 ),
                                           tstr,
                                           catalog.getLocale( 11 ) );
          _freesafe( tstr );
        }
        applyColorList( colors );
        initFixTypes();
        fclose( fp );
      }
    }
  }
  return false;
}

bool WCPath::save(Datei *fh)
{
  int id;
  WCDoubleShortkey *dk;

  if(fh==NULL) return false;

  WConfig::configPutPairString( fh, "title", name );
  WConfig::configPutPairNum( fh, "color", fg, bg );
  WConfig::configPutPairString( fh, "path", path );

  WConfig::configOpenSection( fh, "shortkeys" );
  id = dkeys->initEnum();
  dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
  while ( dk != NULL ) {
    dk->save( fh );
    dk = (WCDoubleShortkey*)dkeys->getNextElement( id );
  }
  dkeys->closeEnum( id );
  WConfig::configCloseSection( fh ); //shortkeys

  return true;
}

bool WCGlobalFlags::save(Datei *fh)
{
  if ( fh == NULL ) return false;
  // I don't use any flags at the moment
  return true;
}

bool WCFiletype::save(Datei *fh)
{
  int i;
  std::string str1;
  char buf[A_BYTESFORNUMBER(int)];
  if(fh==NULL) return false;

  WConfig::configPutPairString( fh, "title", name );
  WConfig::configPutPairString( fh, "pattern", pattern );
  WConfig::configPutPairBool( fh, "usepattern", usepattern );
  WConfig::configPutPairBool( fh, "usecontent", usefiledesc );
  
  WConfig::configOpenSection( fh, "content" );
  for ( i = 0; i < 64; i++ ) {
    if ( filedesc[i] >= 0 ) {
      sprintf( buf, "%d", i );
      str1 = buf;
      str1 += " = ";
      sprintf( buf, "%d", filedesc[i] );
      str1 += buf;
      str1 += ";";
      WConfig::configPutInfo( fh, str1.c_str(), false );
    }
  }
  WConfig::configCloseSection( fh ); //content

  switch ( internID ) {
    case NOTYETTYPE:
      WConfig::configPutPair( fh, "type", "notyetchecked" );
      break;
    case UNKNOWNTYPE:
      WConfig::configPutPair( fh, "type", "unknown" );
      break;
    case VOIDTYPE:
      WConfig::configPutPair( fh, "type", "noselect" );
      break;
    case DIRTYPE:
      WConfig::configPutPair( fh, "type", "dir" );
      break;
    default:
      WConfig::configPutPair( fh, "type", "normal" );
      break;
  }

  //WConfig::configPutPairString( fh, "fileexp", fileexp );
  //WConfig::configPutPairBool( fh, "usefileexp", usefileexp );

  WConfig::configPutPairBool( fh, "patternignorecase", patternIgnoreCase );
  WConfig::configPutPairBool( fh, "patternuseregexp", patternUseRegExp );
  WConfig::configPutPairBool( fh, "patternusefullname", patternUseFullname );

  //TODO: Aus Platzgruenden nur die nicht-leeren speichern?
  //      Aber was ist, wenn es mal Flags gibt und der User trotz
  //      leerer Liste (wo ja dann flags keinen Einflu haben)
  //      etwas auswhlt, sollte dann trotzdem gespeichert werden
  WConfig::configOpenSection( fh, "ftcommands" );

  WConfig::configOpenSection( fh, "dnd" );
  int id = dndaction->initEnum();
  FunctionProto *f1 = (FunctionProto*)dndaction->getFirstElement( id );
  while ( f1 != NULL ) {
    FunctionProto::presave( fh, f1 );
    f1 = (FunctionProto*)dndaction->getNextElement( id );
  }
  dndaction->closeEnum( id );
  WConfig::configOpenSection( fh, "flags" );
  dndactiongf->save( fh );
  WConfig::configCloseSection( fh ); //flags
  WConfig::configCloseSection( fh ); //dnd

  WConfig::configOpenSection( fh, "doubleclick" );
  id = doubleclickaction->initEnum();
  f1 = (FunctionProto*)doubleclickaction->getFirstElement( id );
  while ( f1 != NULL ) {
    FunctionProto::presave( fh, f1 );
    f1 = (FunctionProto*)doubleclickaction->getNextElement( id );
  }
  doubleclickaction->closeEnum( id );
  WConfig::configOpenSection( fh, "flags" );
  doubleclickactiongf->save( fh );
  WConfig::configCloseSection( fh ); //flags
  WConfig::configCloseSection( fh ); //doubleclick

  WConfig::configOpenSection( fh, "show" );
  id = showaction->initEnum();
  f1 = (FunctionProto*)showaction->getFirstElement( id );
  while ( f1 != NULL ) {
    FunctionProto::presave( fh, f1 );
    f1 = (FunctionProto*)showaction->getNextElement( id );
  }
  showaction->closeEnum( id );
  WConfig::configOpenSection( fh, "flags" );
  showactiongf->save( fh );
  WConfig::configCloseSection( fh ); //flags
  WConfig::configCloseSection( fh ); //show

  WConfig::configOpenSection( fh, "rawshow" );
  id = rawshowaction->initEnum();
  f1 = (FunctionProto*)rawshowaction->getFirstElement( id );
  while ( f1 != NULL ) {
    FunctionProto::presave( fh, f1 );
    f1 = (FunctionProto*)rawshowaction->getNextElement( id );
  }
  rawshowaction->closeEnum( id );
  WConfig::configOpenSection( fh, "flags" );
  rawshowactiongf->save( fh );
  WConfig::configCloseSection( fh ); //flags
  WConfig::configCloseSection( fh ); //rawshow

  for ( i = 0; i < 10; i++ ) {
    sprintf( buf, "%d", i );
    str1 = "user ";
    str1 += buf;
    WConfig::configOpenSection( fh, str1.c_str() );
    id = useraction[i]->initEnum();
    f1 = (FunctionProto*)useraction[i]->getFirstElement( id );
    while ( f1 != NULL ) {
      FunctionProto::presave( fh, f1 );
      f1 = (FunctionProto*)useraction[i]->getNextElement( id );
    }
    useraction[i]->closeEnum( id );
    WConfig::configOpenSection( fh, "flags" );
    useractiongf[i]->save( fh );
    WConfig::configCloseSection( fh ); //flags
    WConfig::configCloseSection( fh ); //user x
  }

  WConfig::configCloseSection( fh ); //ftcommands

  return true;
}

bool WCHotkey::save(Datei *fh)
{
  int id;
  WCDoubleShortkey *dk;

  if(fh==NULL) return false;

  id = dkeys->initEnum();

  WConfig::configPutPairString( fh, "title", name );
  WConfig::configOpenSection( fh, "shortkeys" );
  dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
  while ( dk != NULL ) {
    dk->save( fh );
    dk = (WCDoubleShortkey*)dkeys->getNextElement( id );
  }
  dkeys->closeEnum( id );
  WConfig::configCloseSection( fh ); //shortkeys

  WConfig::configOpenSection( fh, "commands" );
  id = com->initEnum();
  FunctionProto *f1 = (FunctionProto*)com->getFirstElement( id );
  while ( f1 != NULL ) {
    FunctionProto::presave( fh, f1 );
    f1 = (FunctionProto*)com->getNextElement( id );
  }
  com->closeEnum( id );
  WConfig::configOpenSection( fh, "flags" );
  flags->save( fh );
  WConfig::configCloseSection( fh ); //flags
  WConfig::configCloseSection( fh ); //commands
  return true;
}

bool WCButton::save(Datei *fh)
{
  int id;
  WCDoubleShortkey *dk;

  if ( fh == NULL ) return false;
  WConfig::configPutPairString( fh, "title", text );
  WConfig::configPutPairNum( fh, "color", fg, bg );

  WConfig::configOpenSection( fh, "shortkeys" );
  id = dkeys->initEnum();
  dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
  while ( dk != NULL ) {
    dk->save( fh );
    dk = (WCDoubleShortkey*)dkeys->getNextElement( id );
  }
  dkeys->closeEnum( id );
  WConfig::configCloseSection( fh ); //shortkeys

  WConfig::configOpenSection( fh, "commands" );
  id = com->initEnum();
  FunctionProto *f1 = (FunctionProto*)com->getFirstElement( id );
  while ( f1 != NULL ) {
    FunctionProto::presave( fh, f1 );
    f1 = (FunctionProto*)com->getNextElement( id );
  }
  com->closeEnum( id );
  WConfig::configOpenSection( fh, "flags" );
  flags->save( fh );
  WConfig::configCloseSection( fh ); //flags
  WConfig::configCloseSection( fh ); //commands
  return true;
}

const char *WConfig::getHome()
{
  return home;
}

void WConfig::initFixTypes()
{
  WCFiletype *ft;
  // Pruefen, welche feste Type vorhanden sind (per Bitmaske)
  int id;

  notyettype = NULL;
  unknowntype = NULL;
  voidtype = NULL;
  dirtype = NULL;

  id = filetypes->initEnum();
  ft = (WCFiletype*)filetypes->getFirstElement( id );
  while ( ft != NULL ) {
    switch ( ft->getinternID() ) {
      case NOTYETTYPE:
        if ( notyettype != NULL ) {
          // there is already one special type, reset this
          ft->setinternID( NORMALTYPE );
        } else {
          notyettype = ft;
        }
        break;
      case UNKNOWNTYPE:
        if ( unknowntype != NULL ) {
          // there is already one special type, reset this
          ft->setinternID( NORMALTYPE );
        } else {
          unknowntype = ft;
        }
        break;
      case VOIDTYPE:
        if ( voidtype != NULL ) {
          // there is already one special type, reset this
          ft->setinternID( NORMALTYPE );
        } else {
          voidtype = ft;
        }
        break;
      case DIRTYPE:
        if ( dirtype != NULL ) {
          // there is already one special type, reset this
          ft->setinternID( NORMALTYPE );
        } else {
          dirtype = ft;
        }
        break;
    }
    ft = (WCFiletype*)filetypes->getNextElement( id );
  }
  filetypes->closeEnum( id );
  
  if ( notyettype == NULL ) {
    // NotYet voreinstellen
    debugmsg("Notyet erstellen\n"); //TODO: Diese Zeile entfernen
    ft=new WCFiletype();
    ft->setName(catalog.getLocale(344));
    ft->setinternID(NOTYETTYPE);
    // Reicht vorerst, denn irgendwelche Patterns oder so sind (im jetztigen Stadium des
    // Programms) nicht sinnvoll
    notyettype=ft;
    filetypes->addElementAt(NOTYETTYPE-1,ft);
  }

  if (  unknowntype == NULL ) {
    // Unknown voreinstellen
    debugmsg("Unknown erstellen\n"); //TODO: Diese Zeile entfernen
    ft=new WCFiletype();
    ft->setName(catalog.getLocale(345));
    ft->setinternID(UNKNOWNTYPE);
    unknowntype = ft;
    filetypes->addElementAt(UNKNOWNTYPE-1,ft);
  }
  
  if ( voidtype == NULL ) {
    // Void voreinstellen (der wird nie im Lister angezeigt)
    debugmsg("void erstellen\n"); //TODO: Diese Zeile entfernen
    ft=new WCFiletype();
    ft->setName(catalog.getLocale(346));
    ft->setinternID(VOIDTYPE);
    voidtype = ft;
    filetypes->addElementAt(VOIDTYPE-1,ft);
  }
  
  if ( dirtype == NULL ) {
    // Dir voreinstellen
    debugmsg("dir erstellen\n"); //TODO: Diese Zeile entfernen
    ft=new WCFiletype();
    ft->setName(catalog.getLocale(109));
    ft->setinternID(DIRTYPE);
    dirtype=ft;
    filetypes->addElementAt(DIRTYPE-1,ft);
  }
}

WCFiletype *WConfig::getnotyettype()
{
  return notyettype;
}

WCFiletype *WConfig::getdirtype()
{
  return dirtype;
}

WCFiletype *WConfig::getvoidtype()
{
  return voidtype;
}

WCFiletype *WConfig::getunknowntype()
{
  return unknowntype;
}

int WCFiletype::getNameLen()
{
  return namelen;
}

void WConfig::applyLanguage()
{
  if((strcmp(lang,"builtin")==0)||(strlen(lang)<1)) catalog.resetLanguage();
  else catalog.loadLanguage(lang);
}

int WConfig::savesize(int w,int h)
{
  Datei *fp;
  char *file;
  long error;
  AGUIX *aguix = worker->getAGUIX();
  int scrnum = aguix->getScreen();
  
  file = (char*)_allocsafe( strlen( home ) +
                            strlen( "/lastsize." ) +
                            A_BYTESFORNUMBER( scrnum ) + 1 );
  sprintf( file, "%s/lastsize.%d", home, scrnum );
  fp=new Datei();
  if(fp!=NULL) {
    if(fp->open(file,"w")==0) {
      fp->putUShort(w);
      fp->putUShort(h);
      error=fp->errors();
      fp->close();
    } else error=1;
    delete fp;
  } else error=1;
  _freesafe(file);
  return (int)error;
}

int WConfig::loadsize(int *w,int *h)
{
  Datei *fp;
  char *file;
  long error;
  AGUIX *aguix = worker->getAGUIX();
  int scrnum = aguix->getScreen();
  
  file = (char*)_allocsafe( strlen( home ) +
                            strlen( "/lastsize." ) +
                            A_BYTESFORNUMBER( scrnum ) + 1 );
  sprintf( file, "%s/lastsize.%d", home, scrnum );
  fp=new Datei();
  if(fp!=NULL) {
    if(fp->open(file,"r")==0) {
      *w=fp->getUShort();
      *h=fp->getUShort();
      error=fp->errors();
      fp->close();
    } else error=1;
    delete fp;
  } else error=1;
  _freesafe(file);
  return (int)error;
}

void WConfig::setOwnerstringtype(int nv)
{
  ownerstringtype=nv;
  if(ownerstringtype<0) ownerstringtype=0;
  else if(ownerstringtype>1) ownerstringtype=1;
}

int WConfig::getOwnerstringtype()
{
  return ownerstringtype;
}

bool WConfig::isCorrectTerminalBin(const char *tstr)
{
  const char *pos;
  if(strlen(tstr)<1) return true;
  pos=strstr(tstr,"%s");
  if(pos!=NULL) return true;
  return false;
}

const char *WConfig::getTerminalStr()
{
  if(strlen(terminalbin)<1) return TERMINAL_BIN;
  else if(isCorrectTerminalBin(terminalbin)==false) return TERMINAL_BIN;
  return terminalbin;
}

void WConfig::setClockbarMode(WConfig::clockbar_mode_t nm)
{
  clockbar_mode=nm;
}

WConfig::clockbar_mode_t WConfig::getClockbarMode()
{
  return clockbar_mode;
}

void WConfig::setClockbarUpdatetime(int nv)
{
  clockbar_updatetime=nv;
  if(clockbar_updatetime<1) clockbar_updatetime=1;
}

int WConfig::getClockbarUpdatetime()
{
  return clockbar_updatetime;
}

void WConfig::setShowStringForDirSize(bool nv)
{
  showStringForDirSize=nv;
}

bool WConfig::getShowStringForDirSize()
{
  return showStringForDirSize;
}

void WConfig::setStringForDirSize(const char *nv)
{
  _freesafe(stringForDirSize);
  if(nv!=NULL) stringForDirSize=dupstring(nv);
  else stringForDirSize=dupstring("<DIR>");
  stringForDirSizeLen=strlen(stringForDirSize);
}

const char *WConfig::getStringForDirSize()
{
  return stringForDirSize;
}

void WConfig::setClockbarCommand(const char *nv)
{
  _freesafe(clockbar_command);
  if(nv!=NULL) clockbar_command=dupstring(nv);
  else clockbar_command=dupstring("");
}

const char *WConfig::getClockbarCommand()
{
  return clockbar_command;
}

bool WConfig::changeClockbarSets()
{
  AGUIX *aguix=worker->getAGUIX();
  StringGadget *ccsg,*cusg;
  CycleButton *cyb;
  Text *cctext,*cutext,*ttext;
  Button *okb,*cb;
  AWindow *cuwin,*ccwin;
  int tw,ttw,tth,ttx,tty;
  int t1,t2;
  char *tstr;

  ttw=200;
  tth=10;
  ttx=tty=5;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,ttw,tth,0,catalog.getLocale(368));

  ttext=(Text*)win->add(new Text(aguix,ttx,tty,catalog.getLocale(369),1));
  ttx+=ttext->getWidth()+5;
  cyb=(CycleButton*)win->add(new CycleButton(aguix,ttx,tty,100,1,0,0));
  cyb->addOption(catalog.getLocale(370));
  cyb->addOption(catalog.getLocale(371));
  cyb->addOption(catalog.getLocale(372));
  cyb->addOption(catalog.getLocale(373));
  cyb->resize(cyb->getMaxSize(),cyb->getHeight());
  switch(clockbar_mode) {
    case CLOCKBAR_MODE_TIME:
      cyb->setOption(1);
      break;
    case CLOCKBAR_MODE_VERSION:
      cyb->setOption(2);
      break;
    case CLOCKBAR_MODE_EXTERN:
      cyb->setOption(3);
      break;
    default:
      cyb->setOption(0);
      break;
  }

  tty+=cyb->getHeight()+5;
  tw=ttx+cyb->getWidth()+5;
  if(tw>ttw) ttw=tw;
  ttx=5;

  cuwin=new AWindow(aguix);
  cuwin->create(win,0,tty,ttw,5,0,"");
  cutext=(Text*)cuwin->add(new Text(aguix,ttx,0,catalog.getLocale(129),1));
  ttx+=cutext->getWidth()+5;
  tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
  sprintf(tstr,"%d",clockbar_updatetime);
  cusg=(StringGadget*)cuwin->add(new StringGadget(aguix,ttx,0,ttw-ttx-5,tstr,0));
  _freesafe(tstr);
  tty+=cusg->getHeight()+5;
  ttx=5;

  ccwin=new AWindow(aguix);
  ccwin->create(win,0,tty,ttw,5,0,"");
  cctext=(Text*)ccwin->add(new Text(aguix,ttx,0,catalog.getLocale(374),1));
  ttx+=cctext->getWidth()+5;
  ccsg=(StringGadget*)ccwin->add(new StringGadget(aguix,ttx,0,ttw-ttx-5,clockbar_command,0));
  tty+=ccsg->getHeight()+5;
  ttx=5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>ttw) ttw=tw;
  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   tty,
                                   t1,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  ttw-5-t2,
                                  tty,
                                  t2,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  tty+=okb->getHeight()+5;
  
  tth=tty;
  
  cusg->resize(ttw-5-cusg->getX(),cusg->getHeight());
  cuwin->resize(ttw,cusg->getHeight()+5);
  cuwin->show();
  ccsg->resize(ttw-5-ccsg->getX(),ccsg->getHeight());
  ccwin->resize(ttw,ccsg->getHeight()+5);
  ccwin->show();

  // now check which extra fields are visible
  if(clockbar_mode!=CLOCKBAR_MODE_EXTERN) {
    ccwin->hide();
  }
  switch(clockbar_mode) {
    case CLOCKBAR_MODE_VERSION:
      cuwin->hide();
      break;
    case CLOCKBAR_MODE_TIME:
    case CLOCKBAR_MODE_EXTERN:
    default:
      break;
  }

  win->setDoTabCycling( true );
  win->resize(ttw,tth);
  win->setMaxSize(ttw,tth);
  win->setMinSize(ttw,tth);
  win->show();

  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cb) ende=-1;
      } else if(msg->type==AG_CYCLEBUTTONCLICKED) {
        if(msg->cyclebutton.cyclebutton==cyb) {
          if(msg->cyclebutton.option==3) ccwin->show();
          else ccwin->hide();
          switch(msg->cyclebutton.option) {
            case CLOCKBAR_MODE_VERSION:
              cuwin->hide();
              break;
            case CLOCKBAR_MODE_TIME:
            case CLOCKBAR_MODE_EXTERN:
            default:
              cuwin->show();
              break;
           }
        }
      } else if(msg->type==AG_STRINGGADGET_DEACTIVATE) {
        if(msg->stringgadget.sg==cusg) {
          int val=atoi(cusg->getText());
          if(val<1) cusg->setText("1");
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    switch(cyb->getSelectedOption()) {
      case 1:
        setClockbarMode(CLOCKBAR_MODE_TIME);
        break;
      case 2:
        setClockbarMode(CLOCKBAR_MODE_VERSION);
        break;
      case 3:
        setClockbarMode(CLOCKBAR_MODE_EXTERN);
        break;
      default:
        setClockbarMode(CLOCKBAR_MODE_TIMERAM);
        break;
    }
    setClockbarUpdatetime(atoi(cusg->getText()));
    setClockbarCommand(ccsg->getText());
  }
  cuwin->close();
  delete cuwin;
  ccwin->close();
  delete ccwin;
  win->close();
  delete win;
  return (ende==-1)?false:true;
}

void WConfig::setDontCheckDirs(List *ndcd)
{
  char *tstr;
  int id=dontcheckdirs->initEnum();
  tstr=(char*)dontcheckdirs->getFirstElement(id);
  while(tstr!=NULL) {
    _freesafe(tstr);
    tstr=(char*)dontcheckdirs->getNextElement(id);
  }
  dontcheckdirs->closeEnum(id);
  dontcheckdirs->removeAllElements();
  id=ndcd->initEnum();
  tstr=(char*)ndcd->getFirstElement(id);
  while(tstr!=NULL) {
    dontcheckdirs->addElement(dupstring(tstr));
    tstr=(char*)ndcd->getNextElement(id);
  }
  ndcd->closeEnum(id);
}

List *WConfig::getDontCheckDirs()
{
  return dontcheckdirs;
}

int WConfig::configureDCD(List *tdcd)
{
  AGUIX *aguix=worker->getAGUIX();
  int tw,ttw,tth,ty;
  int t1,t2;
  int trow, trow2;
  int pos;
  int id;
  char *tstr,*buttonstr,*tstr2;
  const char *textstr;
  Requester *req;
  bool found;

  ttw=10;
  tth=50;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,ttw,tth,0,catalog.getLocale(144));

  ty=5;
  FieldListView *filv =(FieldListView*)win->add( new FieldListView( aguix, 5, ty, ttw, 100, 0 ) );
  filv->setHBarState(2);
  filv->setVBarState(2);
  ty+=filv->getHeight()+5;
  t1=(strlen(catalog.getLocale(181))+2);
  t1*=aguix->getCharWidth();
  Button *newb=(Button*)win->add(new Button(aguix,5,ty,t1,catalog.getLocale(181),1,0,0));
  t1=(strlen(catalog.getLocale(183))+2);
  t1*=aguix->getCharWidth();
  Button *delb=(Button*)win->add(new Button(aguix,newb->getX()+newb->getWidth(),ty,t1,
                                            catalog.getLocale(183),1,0,0));
  t1=(strlen(catalog.getLocale(182))+2);
  t1*=aguix->getCharWidth();
  Button *editb=(Button*)win->add(new Button(aguix,delb->getX()+delb->getWidth(),ty,t1,
                                            catalog.getLocale(182),1,0,0));
  ty+=newb->getHeight()+5;
  ttw=editb->getX()+editb->getWidth()+5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>ttw) ttw=tw;
  Button *okb=(Button*)win->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win->add(new Button(aguix,
                                                 ttw-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  filv->resize(ttw-10,filv->getHeight());
  editb->resize(ttw-5-editb->getX(),editb->getHeight());
  tth=okb->getY()+okb->getHeight()+5;
  
  id=tdcd->initEnum();
  tstr=(char*)tdcd->getFirstElement(id);
  pos=0;
  while(tstr!=NULL) {
    trow = filv->addRow();
    filv->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
    filv->setText( trow, 0, tstr );
    filv->setData( trow, pos++ );
    tstr=(char*)tdcd->getNextElement(id);
  }
  filv->redraw();
  tdcd->closeEnum(id);
  
  win->setDoTabCycling( true );
  win->resize(ttw,tth);
  win->setMaxSize(ttw,tth);
  win->setMinSize(ttw,tth);
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  
  req=new Requester(aguix);
  
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==newb) {
          textstr=catalog.getLocale(199);
          buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(11))+1+
                                      strlen(catalog.getLocale(8))+1);
          sprintf(buttonstr,"%s|%s",catalog.getLocale(11),
                                    catalog.getLocale(8));
          if(req->string_request(catalog.getLocale(123),textstr,"",buttonstr,&tstr)==0) {
            if(strlen(tstr)>0) {
              if(tstr[0]=='/') {
                tstr2=HandlePath(tstr);
                
                found=false;
                trow = 0;
                while ( filv->isValidRow( trow ) == true ) {
                  if ( strcmp( filv->getText( trow, 0 ).c_str(), tstr2 ) == 0 ) {
                    found = true;
                    break;
                  }
                  trow++;
                }
                if(found==false) {
                  trow = filv->addRow();
                  filv->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
                  filv->setText( trow, 0, tstr2 );
                  filv->setActiveRow( trow );
                  filv->showActive();
                  filv->redraw();
                }
                _freesafe(tstr2);
              }
            }
            _freesafe(tstr);
          } else _freesafe(tstr);
          _freesafe(buttonstr);
        } else if(msg->button.button==delb) {
          trow = filv->getActiveRow();
          if ( filv->isValidRow( trow ) == true ) {
            filv->deleteRow( trow );
            filv->redraw();
          }
        } else if(msg->button.button==editb) {
          trow = filv->getActiveRow();
          if ( filv->isValidRow( trow ) == true ) {
            textstr=catalog.getLocale(199);
            buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(11))+1+
                                        strlen(catalog.getLocale(8))+1);
            sprintf(buttonstr,"%s|%s",catalog.getLocale(11),
                                      catalog.getLocale(8));
            if ( req->string_request( catalog.getLocale( 123 ),
                                      textstr,
                                      filv->getText( trow, 0 ).c_str(),
                                      buttonstr,
                                      &tstr ) == 0 ) {
              if(strlen(tstr)>0) {
                if(tstr[0]=='/') {
                  tstr2=HandlePath(tstr);

                  found=false;
                  trow2 = 0;
                  while ( filv->isValidRow( trow2 ) == true ) {
                    if ( strcmp( filv->getText( trow2, 0 ).c_str(), tstr2 ) == 0 ) {
                      found=true;
                      break;
                    }
                    trow2++;
                  }
                  if(found==false) {
                    filv->setText( trow, 0, tstr2 );
                    filv->redraw();
                  }
                  _freesafe(tstr2);
                }
              }
              _freesafe(tstr);
            } else _freesafe(tstr);
            _freesafe(buttonstr);
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    // insert in tdcd
    id=tdcd->initEnum();
    tstr=(char*)tdcd->getFirstElement(id);
    while(tstr!=NULL) {
      _freesafe(tstr);
      tstr=(char*)tdcd->getNextElement(id);
    }
    tdcd->closeEnum(id);
    tdcd->removeAllElements();

    trow = 0;
    while ( filv->isValidRow( trow ) == true ) {
      tdcd->addElement( dupstring( filv->getText( trow, 0 ).c_str() ) );
      trow++;
    }
  }
  
  win->close();
  delete win;
  delete req;
  return (ende==1)?0:1;
}

void WConfig::setListerBG(int color)
{
  listerbg=color;
}

int WConfig::getListerBG()
{
  return listerbg;
}

int WConfig::getStringForDirSizeLen()
{
  return stringForDirSizeLen;
}

int WConfig::im_export()
{
  AWindow *win;
  AGUIX *aguix = worker->getAGUIX();
  int w, h, ende, ty;
  AGMessage *msg;
  Button *b[3];
  
  w = h = 10;
  win = new AWindow(aguix);
  win->create( NULL, 10, 10, w, h, 0, catalog.getLocale( 396 ) );

  ty = 5;
  b[0] = (Button*)win->add( new Button( aguix, 5, ty, catalog.getLocale( 397 ), 1, 0, 0 ) );
  ty += b[0]->getHeight() + 5;

  b[1] = (Button*)win->add( new Button( aguix, 5, ty, catalog.getLocale( 398 ), 1, 0, 0 ) );
  ty += b[1]->getHeight() + 5;

  b[2] = (Button*)win->add( new Button( aguix, 5, ty, catalog.getLocale( 8 ), 1, 0, 0 ) );
  ty += b[2]->getHeight() + 5;

  win->maximizeX();
  w = win->getWidth();
  b[0]->resize( w - 10, b[0]->getHeight() );
  b[1]->resize( w - 10, b[1]->getHeight() );
  b[2]->resize( w - 10, b[2]->getHeight() );
  
  h = ty;
  win->setDoTabCycling( true );
  win->resize( w, h );
  win->setMinSize( w, h );
  win->setMaxSize( w, h );
  win->show();
  
  ende = 0;
  while ( ende == 0 ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      if ( msg->type == AG_CLOSEWINDOW ) {
        if ( msg->closewindow.window == win->getWindow() )
          ende = -1;
      } else if (msg->type == AG_BUTTONCLICKED ) {
        if ( msg->button.button == b[0] ) {
          // import
          win->hide();
          if ( cfg_import1() == 0 )
            ende = 1;
          else
            ende = -1;
        } else if ( msg->button.button == b[1] ) {
          // export
          win->hide();
          if ( cfg_export() == 0 )
            ende = 2;
          else
            ende = -1;
        } else if ( msg->button.button == b[2] ) {
          // Cancel
          ende = -1;
        }
      }

      aguix->ReplyMessage( msg );
    }
  }
  
  win->close();
  delete win;

  if ( ende == 2 ) {
    // export didn't changed anything so report 0
    return 0;
  } else if ( ende == 1 ) {
    // import changed config, report 1
    return 1;
  }
  // cancel
  return -1;
}

int WConfig::cfg_export()
{
  AWindow *win;
  AGUIX *aguix = worker->getAGUIX();
  int w, h, ende, ty, tw, tx;
  AGMessage *msg;
  ChooseButton *cb[3];
  Button *b[3],*b2[2],*b3;
  WConfig *exportconfig;
  Text *ttext;
  StringGadget *sg;
  char *cur_name;
  FileRequester *freq;
  std::string str1;
  Requester *req;
  
  w = h = 10;
  win = new AWindow(aguix);
  win->create( NULL, 10, 10, w, h, 0, catalog.getLocale( 398 ) );

  ty = 5;
  
  win->addTextFromString( catalog.getLocale( 399 ), 5, ty, 5, NULL, NULL, &ty );
  ty += 5;
  
  cb[0] = (ChooseButton*)win->add( new ChooseButton( aguix, 5, ty, false, "", LABEL_RIGHT, 0, 0 ) );
  b[0] = (Button*)win->add( new Button( aguix, cb[0]->getX() + cb[0]->getWidth() + 5,
                                        ty, catalog.getLocale( 401 ), 1, 0, 0 ) );
  b[0]->resize( b[0]->getWidth(), cb[0]->getHeight() );
  ty += cb[0]->getHeight() + 5;

  cb[1] = (ChooseButton*)win->add( new ChooseButton( aguix, 5, ty, false, "", LABEL_RIGHT, 0, 0 ) );
  b[1] = (Button*)win->add( new Button( aguix, cb[1]->getX() + cb[1]->getWidth() + 5,
                                        ty, catalog.getLocale( 402 ), 1, 0, 0 ) );
  b[1]->resize( b[1]->getWidth(), cb[1]->getHeight() );
  ty += cb[1]->getHeight() + 5;

  cb[2] = (ChooseButton*)win->add( new ChooseButton( aguix, 5, ty, false, "", LABEL_RIGHT, 0, 0 ) );
  b[2] = (Button*)win->add( new Button( aguix, cb[2]->getX() + cb[2]->getWidth() + 5,
                                        ty, catalog.getLocale( 403 ), 1, 0, 0 ) );
  b[2]->resize( b[2]->getWidth(), cb[2]->getHeight() );
  ty += cb[2]->getHeight() + 5;
  
  win->maximizeX();
  w = win->getWidth();
  
  cur_name = dupstring( "" );

  ttext = (Text*)win->add( new Text( aguix, 5, ty, catalog.getLocale( 404 ), 1 ) );
  tx = ttext->getX() + ttext->getWidth() + 5;
  tw = w_max( w, 20 * aguix->getCharWidth() );
  sg = (StringGadget*)win->add( new StringGadget( aguix, tx, ty, tw, cur_name, 0 ) );
  tx += sg->getWidth();
  b3 = (Button*)win->add( new Button( aguix, tx, ty, catalog.getLocale( 405 ), 1, 0, 0 ) );
  b3->resize( b3->getWidth(), sg->getHeight() );

  AGUIX::centerElementsY( ttext, sg );  
  
  ty += b3->getHeight() + 5;
  
  win->maximizeX();
  w = win->getWidth();
  
  b2[0] = (Button*)win->add( new Button( aguix, 0, ty, catalog.getLocale( 398 ), 1, 0, 0 ) );
  b2[1] = (Button*)win->add( new Button( aguix, 0, ty, catalog.getLocale( 8 ), 1, 0, 0 ) );
  tw = AGUIX::scaleElementsW( w, win->getBorderWidth(), 10, -1, false, false, (GUIElement**)b2, NULL, 2 );
  if ( tw > w ) w = tw;
  
  ty += b2[0]->getHeight() + 5;
  
  h = ty;
  win->setDoTabCycling( true );
  win->resize( w, h );
  win->setMinSize( w, h );
  win->setMaxSize( w, h );
  win->show();
  
  exportconfig = duplicate();
  
  freq = new FileRequester( aguix );
  req = new Requester( aguix );
  
  ende = 0;
  while ( ende == 0 ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      if ( msg->type == AG_CLOSEWINDOW ) {
        if ( msg->closewindow.window == win->getWindow() )
          ende = -1;
      } else if ( msg->type == AG_BUTTONCLICKED ) {
        if ( msg->button.button == b2[0] ) {
          // Okay
          ende = 1;
        } else if ( msg->button.button == b2[1] ) {
          // Cancel
          ende = -1;
        } else if ( msg->button.button == b[0] ) {
          exportconfig->changeButtons();
        } else if ( msg->button.button == b[1] ) {
          exportconfig->changeHotkeys();
        } else if ( msg->button.button == b[2] ) {
          exportconfig->changeTypes( true, true );
        } else if ( msg->button.button == b3 ) {
          // choose file with requester
          if ( freq->request_entry( catalog.getLocale( 265 ),
                                    NULL,
                                    catalog.getLocale( 11 ),
                                    catalog.getLocale( 8 ),
                                    catalog.getLocale( 406 ),
                                    true ) > 0 ) {
            str1 = freq->getLastEntryStr();
            if ( str1.length() > 0 ) {
              sg->setText( str1.c_str() );
            }
          }
        }
      } else if ( msg->type == AG_STRINGGADGET_DEACTIVATE ) {
      }

      aguix->ReplyMessage( msg );
    }
    if ( ende == 1 ) {
      // try to export
      // in case of failure keep this window so we do this
      // inside the loop
      // export the exportconfig according to choosebuttons

      if ( ( ( cb[0]->getState() == true ) ||
             ( cb[1]->getState() == true ) ||
             ( cb[2]->getState() == true ) ) &&
           ( strlen( sg->getText() ) > 0 ) ) {
        // something to export
        // when export failed set ende back to 0

        if ( exportconfig->export2file( cb[0]->getState(),
                                        cb[1]->getState(),
                                        cb[2]->getState(),
                                        sg->getText() ) != 0 ) {
          ende = 0;
        }
      } else {
        req->request( catalog.getLocale( 124 ), catalog.getLocale( 407 ),
                      catalog.getLocale( 11 ) );
        ende = 0;
      }
    }
  }
  
  _freesafe( cur_name );
  win->close();
  delete win;
  
  delete exportconfig;
  delete freq;
  delete req;

  return ( ende == -1 ) ? 1 : 0;
}

int WConfig::export2file( bool export_buttons,
                          bool export_hotkeys,
                          bool export_types,
                          const char *filename )
{
  Datei fh;
  Datei::d_fe_t e;
  int erg, ret;
  Requester req( worker->getAGUIX() );
  char *tstr;
  std::string s1;
  int id;
  WCButton *b1;
  WCHotkey *h1;
  WCFiletype *f1;
  char buf[3 * A_BYTESFORNUMBER( int ) + 3 ];
  std::string str1;
  int i;
  
  ret = 0;
  
  if ( filename == NULL ) return 1;

  e = Datei::fileExistsExt( filename );
  if ( e != Datei::D_FE_NOFILE ) {
    // something exists with this name!
    if ( e == Datei::D_FE_DIR ) {
      // dir -> show request and exit
      tstr = (char*)_allocsafe( strlen( catalog.getLocale( 408 ) ) + strlen( filename ) + 1 );
      sprintf( tstr, catalog.getLocale( 408 ), filename );
      req.request( catalog.getLocale( 124 ), tstr, catalog.getLocale( 11 ) );
      _freesafe( tstr );
      return 1;
    }
    // ask for overwriting this file
    // otherwise return
    tstr = (char*)_allocsafe( strlen( catalog.getLocale( 409 ) ) + strlen( filename ) + 1 );
    sprintf( tstr, catalog.getLocale( 409 ), filename );
    s1 = catalog.getLocale( 11 );
    s1 += "|";
    s1 += catalog.getLocale( 8 );
    erg = req.request( catalog.getLocale( 123 ), tstr, s1.c_str() );
    _freesafe( tstr );
    
    if ( erg == 1 )
      return 1;
    
  }

  if ( fh.open( filename, "w" ) == 0 ) {
    sectiondepth = 0;
    sprintf( buf, "%d.%d.%d", WORKER_MAJOR, WORKER_MINOR, WORKER_PATCH );
    str1 = "workerconfig ";
    str1 += buf;
    str1 += ";";
    fh.putLine( str1.c_str() );

    if ( export_buttons == true ) {
      configOpenSection( &fh, "buttons" );
      i = 0;
      id = buttons->initEnum();
      b1 = (WCButton*)buttons->getFirstElement( id );
      while ( b1 != NULL ) {
        if ( b1->getCheck() != false ) {
          configOpenSection( &fh, "button" );
          configPutPairNum( &fh, "position", i );
          b1->save( &fh );
          configCloseSection( &fh ); //button
        }
        b1 = (WCButton*)buttons->getNextElement( id );
        i++;
      }
      buttons->closeEnum( id );

      configCloseSection( &fh ); //buttons
    }
    
    if ( export_hotkeys == true ) {
      configOpenSection( &fh, "hotkeys" );
      id = hotkeys->initEnum();
      h1 = (WCHotkey*)hotkeys->getFirstElement( id );
      while ( h1 != NULL ) {
        configOpenSection( &fh, "hotkey" );
        h1->save( &fh );
        configCloseSection( &fh ); //hotkey
        h1 = (WCHotkey*)hotkeys->getNextElement( id );
      }
      hotkeys->closeEnum( id );
      configCloseSection( &fh ); //hotkeys
    }
    
    if ( export_types == true ) {
      configOpenSection( &fh, "filetypes" );
      id = filetypes->initEnum();
      f1 = (WCFiletype*)filetypes->getFirstElement( id );
      while ( f1 != NULL ) {
        configOpenSection( &fh, "filetype" );
        f1->save( &fh );
        configCloseSection( &fh ); //filetype
        f1 = (WCFiletype*)filetypes->getNextElement( id );
      }
      filetypes->closeEnum( id );
      configCloseSection( &fh ); //filetypes
    }
    
    fh.close();
    tstr = (char*)_allocsafe( strlen( catalog.getLocale( 410 ) ) + strlen( filename ) + 1 );
    sprintf( tstr, catalog.getLocale( 410 ), filename );
    req.request( catalog.getLocale( 124 ), tstr, catalog.getLocale( 11 ) );
    _freesafe( tstr );
  } else {
    tstr = (char*)_allocsafe( strlen( catalog.getLocale( 411 ) ) + strlen( filename ) + 1 );
    sprintf( tstr, catalog.getLocale( 411 ), filename );
    req.request( catalog.getLocale( 124 ), tstr, catalog.getLocale( 11 ) );
    _freesafe( tstr );
    ret = 1;
  }

  return ret;
}

/*
 * Step 1 of import
 * asks for filename and calls cfg_import2 with this name
 *
 */
int WConfig::cfg_import1()
{
  AWindow *win;
  AGUIX *aguix = worker->getAGUIX();
  int w, h, ende, ty, tw, tx;
  AGMessage *msg;
  Button *b2[2],*b3;
  Text *ttext;
  StringGadget *sg;
  FileRequester *freq;
  std::string str1;
  Requester *req;
  
  w = h = 10;
  win = new AWindow(aguix);
  win->create( NULL, 10, 10, w, h, 0, catalog.getLocale( 397 ) );

  ty = 5;
  
  win->addTextFromString( catalog.getLocale( 415 ), 5, ty, 5, NULL, NULL, &ty );
  ty += 5;
  
  win->maximizeX();
  w = win->getWidth();
  
  ttext = (Text*)win->add( new Text( aguix, 5, ty, catalog.getLocale( 404 ), 1 ) );
  tx = ttext->getX() + ttext->getWidth() + 5;
  tw = w_max( w, 20 * aguix->getCharWidth() );
  sg = (StringGadget*)win->add( new StringGadget( aguix, tx, ty, tw, "", 0 ) );
  tx += sg->getWidth();
  b3 = (Button*)win->add( new Button( aguix, tx, ty, catalog.getLocale( 405 ), 1, 0, 0 ) );
  b3->resize( b3->getWidth(), sg->getHeight() );

  AGUIX::centerElementsY( ttext, sg );  
  
  ty += b3->getHeight() + 5;
  
  win->maximizeX();
  w = win->getWidth();
  
  b2[0] = (Button*)win->add( new Button( aguix, 0, ty, catalog.getLocale( 11 ), 1, 0, 0 ) );//TODO: Vielleicht als Text continue
  b2[1] = (Button*)win->add( new Button( aguix, 0, ty, catalog.getLocale( 8 ), 1, 0, 0 ) );
  tw = AGUIX::scaleElementsW( w, win->getBorderWidth(), 10, -1, false, false, (GUIElement**)b2, NULL, 2 );
  if ( tw > w ) w = tw;
  
  ty += b2[0]->getHeight() + 5;
  
  h = ty;
  win->setDoTabCycling( true );
  win->resize( w, h );
  win->setMinSize( w, h );
  win->setMaxSize( w, h );
  win->show();
  
  freq = new FileRequester( aguix );
  req = new Requester( aguix );
  
  ende = 0;
  while ( ende == 0 ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      if ( msg->type == AG_CLOSEWINDOW ) {
        if ( msg->closewindow.window == win->getWindow() )
          ende = -1;
      } else if ( msg->type == AG_BUTTONCLICKED ) {
        if ( msg->button.button == b2[0] ) {
          // Okay
          ende = 1;
        } else if ( msg->button.button == b2[1] ) {
          // Cancel
          ende = -1;
        } else if ( msg->button.button == b3 ) {
          // choose file with requester
          if ( freq->request_entry( catalog.getLocale( 265 ),
                                    NULL,
                                    catalog.getLocale( 11 ),
                                    catalog.getLocale( 8 ),
                                    catalog.getLocale( 265 ),
                                    false ) > 0 ) {
            str1 = freq->getLastEntryStr();
            if ( str1.length() > 0 ) {
              sg->setText( str1.c_str() );
            }
          }
        }
      } else if ( msg->type == AG_STRINGGADGET_DEACTIVATE ) {
      }

      aguix->ReplyMessage( msg );
    }
    if ( ende == 1 ) {
      // try to import
      // in case of failure keep this window so we do this
      // inside the loop

      if ( strlen( sg->getText() ) > 0 ) {
        win->hide();

        if ( cfg_import2( sg->getText() ) != 0 ) {
          win->show();
          ende = 0;
        }
      } else {
        req->request( catalog.getLocale( 124 ), catalog.getLocale( 415 ),
                      catalog.getLocale( 11 ) );
        ende = 0;
      }
    }
  }
  
  win->close();
  delete win;
  
  delete freq;
  delete req;

  return ( ende == -1 ) ? 1 : 0;
}

/*
 * Step 2 of import
 * loads the file in a temp. config and calls cfg_import3 with it
 */
int WConfig::cfg_import2( const char *filename )
{
  AGUIX *aguix = worker->getAGUIX();
  WConfig *importconfig;
  Requester req( aguix );
  Datei fh;
  char buf[5];
  int erg = 0;
  List *bl, *hl, *fl;
  unsigned long chunksize;
  int wma, wmi, wp, nr_of_b, nr_of_h, nr_of_f, id, nrb;
  char *tstr;
  WCButton *b1;
  WCHotkey *h1;
  WCFiletype *f1;
  FILE *fp;

  // first try to load the config
  if ( Datei::fileExistsExt( filename ) == Datei::D_FE_FILE ) {
    if ( fh.open( filename, "r" ) == 0 ) {
      importconfig = duplicate();
      
      fh.getString( buf, 4 );
      if ( strcmp( buf, "FORM" ) == 0 ) {
        bl = new List();
        hl = new List();
        fl = new List();

        fh.getULong();
        fh.getString( buf, 4 );
        if ( strcmp( buf, "WEXP" ) == 0 ) {
          fh.getString( buf, 4 );
          if ( strcmp( buf, "DATA" ) == 0 ) {
            chunksize = fh.getULong();
            if ( chunksize >= (unsigned long)( 6 * Datei::getIntSize() ) ) {
              wma = fh.getInt();
              wmi = fh.getInt();
              wp = fh.getInt();
              chunksize -= 3 * Datei::getIntSize();
              
              nr_of_b = fh.getInt();
              nr_of_h = fh.getInt();
              nr_of_f = fh.getInt();
              chunksize -= 3 * Datei::getIntSize();
              
              nrb = nr_of_b; // because nr_of_b gets changed below we need this for cfg_import3
              
              if ( ( ( wma == WORKER_MAJOR ) && ( wmi > WORKER_MINOR ) ) ||
                   ( ( wma == WORKER_MAJOR ) && ( wmi == WORKER_MINOR ) && ( wp > WORKER_PATCH ) ) ) {
                // from newer version
                tstr = (char*)_allocsafe( strlen( catalog.getLocale( 413 ) ) + ( 3 * A_BYTESFORNUMBER( int ) ) + 1 );
                sprintf( tstr, catalog.getLocale( 413 ), wma, wmi, wp );
                req.request( catalog.getLocale( 124 ),
                             tstr,
                             catalog.getLocale( 11 ) );
                _freesafe( tstr );
                erg = 1;
              } else {
                while ( chunksize > 0 ) {
                  fh.getUChar();
                  chunksize--;
                }
                
                while ( nr_of_b > 0 ) {
                  b1 = new WCButton();
                  loadBinButton( &fh, b1 );
                  bl->addElement( b1 );
                  nr_of_b--;
                }
                while ( nr_of_h > 0 ) {
                  h1 = new WCHotkey();
                  loadBinHotkey( &fh, h1 );
                  hl->addElement( h1 );
                  nr_of_h--;
                }
                while ( nr_of_f > 0 ) {
                  f1 = new WCFiletype();
                  loadBinFiletype( &fh, f1 );
                  fl->addElement( f1 );
                  nr_of_f--;
                }
                
                importconfig->setButtons( bl );
                importconfig->setHotkeys( hl );
                importconfig->setFiletypes( fl );
                
                id = bl->initEnum();
                b1 = (WCButton*)bl->getFirstElement( id );
                while ( b1 != NULL ) {
                  delete b1;
                  bl->removeFirstElement();
                  b1 = (WCButton*)bl->getFirstElement( id );
                }
                bl->closeEnum( id );
  
                id = hl->initEnum();
                h1 = (WCHotkey*)hl->getFirstElement( id );
                while ( h1 != NULL ) {
                  delete h1;
                  hl->removeFirstElement();
                  h1 = (WCHotkey*)hl->getFirstElement( id );
                }
                hl->closeEnum( id );
  
                id = fl->initEnum();
                f1 = (WCFiletype*)fl->getFirstElement( id );
                while ( f1 != NULL ) {
                  delete f1;
                  fl->removeFirstElement();
                  f1 = (WCFiletype*)fl->getFirstElement( id );
                }
                fl->closeEnum( id );
                
                // everything is now in importconfig
                // now let the user decide...
                erg = cfg_import3( importconfig, nrb );
              }
            } else {
              tstr = (char*)_allocsafe( strlen( catalog.getLocale( 400 ) ) + strlen( filename ) + 1 );
              sprintf( tstr, catalog.getLocale( 400 ), filename );
              req.request( catalog.getLocale( 124 ),
                           tstr,
                           catalog.getLocale( 11 ) );
              _freesafe( tstr );
              erg = 1;
            }
          } else {
            // wrong file
            tstr = (char*)_allocsafe( strlen( catalog.getLocale( 400 ) ) + strlen( filename ) + 1 );
            sprintf( tstr, catalog.getLocale( 400 ), filename );
            req.request( catalog.getLocale( 124 ),
                         tstr,
                         catalog.getLocale( 11 ) );
            _freesafe( tstr );
            erg = 1;
          }
        } else {
          // no export file
          tstr = (char*)_allocsafe( strlen( catalog.getLocale( 400 ) ) + strlen( filename ) + 1 );
          sprintf( tstr, catalog.getLocale( 400 ), filename );
          req.request( catalog.getLocale( 124 ),
                       tstr,
                       catalog.getLocale( 11 ) );
          _freesafe( tstr );
          erg = 1;
        }
        delete bl;
        delete hl;
        delete fl;
      } else {
        lconfig = importconfig;
        bl = new List();
        lconfig->setButtons( bl );
        lconfig->setHotkeys( bl );
        lconfig->setFiletypes( bl );
        delete bl;
        fp = fopen( filename, "r" );
        if ( fp != NULL ) {
          yyrestart( fp );
          if ( yymyparse() != 0 ) {
            // there was an error but after the requester I will
            // continue with the partly read config
            tstr = (char*)_allocsafe( strlen( catalog.getLocale( 539 ) ) +
                                      A_BYTESFORNUMBER(int) +
                                      strlen( lconfig_error ) + 1 );
            sprintf( tstr, catalog.getLocale( 539 ), lconfig_linenr + 1,
                     lconfig_error );
            Worker::getRequester()->request( catalog.getLocale( 347 ),
                                             tstr,
                                             catalog.getLocale( 11 ) );
            _freesafe( tstr );
          } else {
            // config load successful
            // now let the user decide...
            erg = cfg_import3( importconfig, 1 );
          }
          fclose( fp );
        } else {
          // can't open for reading
          tstr = (char*)_allocsafe( strlen( catalog.getLocale( 281 ) ) + strlen( filename ) + 1 );
          sprintf( tstr, catalog.getLocale( 281 ), filename );
          req.request( catalog.getLocale( 124 ),
                       tstr,
                       catalog.getLocale( 11 ) );
          _freesafe( tstr );
          erg = 1;
        }
      }
      fh.close();
      delete importconfig;
    } else {
      // can't open for reading
      tstr = (char*)_allocsafe( strlen( catalog.getLocale( 281 ) ) + strlen( filename ) + 1 );
      sprintf( tstr, catalog.getLocale( 281 ), filename );
      req.request( catalog.getLocale( 124 ),
                   tstr,
                   catalog.getLocale( 11 ) );
      _freesafe( tstr );
      erg = 1;
    }
  } else {
    // not a file
    tstr = (char*)_allocsafe( strlen( catalog.getLocale( 412 ) ) + strlen( filename ) + 1 );
    sprintf( tstr, catalog.getLocale( 412 ), filename );
    req.request( catalog.getLocale( 124 ),
                 tstr,
                 catalog.getLocale( 11 ) );
    _freesafe( tstr );
    erg = 1;
  }
  
  return erg;
}

/*
 * Step 3 of import
 * show the users a similar window to export
 * user can choose which part (buttons/hotkeys/filetypes) he want to import
 * and can configure them before import
 */
int WConfig::cfg_import3( WConfig *importconfig, int nrb )
{
  AWindow *win;
  AGUIX *aguix = worker->getAGUIX();
  int w, h, ende, ty, tw;
  AGMessage *msg;
  ChooseButton *cb[3];
  Button *b[3],*b2[2];
  Requester req( aguix );
  int nr_of_b, nr_of_h, nr_of_f;
  char *tstr;
  bool apply_b, apply_h, apply_f;
  List *l1;
  WCButton *b1;
  int id, i, banksize;

  if ( nrb < 1 ) {
    nr_of_b = 0;
  } else {
    l1 = importconfig->getButtons();
    nr_of_b = 0;
    i = 0;
    id = l1->initEnum();
    b1 = (WCButton*)l1->getFirstElement( id );
    while ( b1 != NULL ) {
      if ( b1->getCheck() == true ) {
        nr_of_b = i + 1;
      }
      b1 = (WCButton*)l1->getNextElement( id );
      i++;
    }
    l1->closeEnum( id );
    banksize = ( importconfig->getRows() * importconfig->getColumns() * 2 );
    nr_of_b += ( banksize - ( nr_of_b % banksize ) ) % banksize;
    nr_of_b /= banksize;
  }
  
  nr_of_h = importconfig->getHotkeys()->size();
  nr_of_f = importconfig->getFiletypes()->size();
  
  if ( ( nr_of_b == 0 ) && ( nr_of_h == 0 ) && ( nr_of_f == 0 ) ) {
    req.request( catalog.getLocale( 124 ), catalog.getLocale( 418 ), catalog.getLocale( 11 ) );
    return 1;
  }
  
  tstr = (char*)_allocsafe( strlen( catalog.getLocale( 414 ) ) + ( 3 * A_BYTESFORNUMBER( int ) ) + 1 );
  sprintf( tstr, catalog.getLocale( 414 ), nr_of_b, nr_of_h, nr_of_f );
  req.request( catalog.getLocale( 124 ),
               tstr,
               catalog.getLocale( 11 ) );
  _freesafe( tstr );

  w = h = 10;
  win = new AWindow(aguix);
  win->create( NULL, 10, 10, w, h, 0, catalog.getLocale( 397 ) );

  ty = 5;
  
  win->addTextFromString( catalog.getLocale( 416 ), 5, ty, 5, NULL, NULL, &ty );
  ty += 5;
  
  if ( nr_of_b > 0 ) {
    cb[0] = (ChooseButton*)win->add( new ChooseButton( aguix, 5, ty, false, "", LABEL_RIGHT, 0, 0 ) );
    b[0] = (Button*)win->add( new Button( aguix, cb[0]->getX() + cb[0]->getWidth() + 5,
                                          ty, catalog.getLocale( 540 ), 1, 0, 0 ) );
    b[0]->resize( b[0]->getWidth(), cb[0]->getHeight() );
    ty += cb[0]->getHeight() + 5;
  } else {
    cb[0] = NULL;
    b[0] = NULL;
  }

  if ( nr_of_h > 0 ) {
    cb[1] = (ChooseButton*)win->add( new ChooseButton( aguix, 5, ty, false, "", LABEL_RIGHT, 0, 0 ) );
    b[1] = (Button*)win->add( new Button( aguix, cb[1]->getX() + cb[1]->getWidth() + 5,
                                          ty, catalog.getLocale( 541 ), 1, 0, 0 ) );
    b[1]->resize( b[1]->getWidth(), cb[1]->getHeight() );
    ty += cb[1]->getHeight() + 5;
  } else {
    cb[1] = NULL;
    b[1] = NULL;
  }

  if ( nr_of_f > 0 ) {
    cb[2] = (ChooseButton*)win->add( new ChooseButton( aguix, 5, ty, false, "", LABEL_RIGHT, 0, 0 ) );
    b[2] = (Button*)win->add( new Button( aguix, cb[2]->getX() + cb[2]->getWidth() + 5,
                                          ty, catalog.getLocale( 542 ), 1, 0, 0 ) );
    b[2]->resize( b[2]->getWidth(), cb[2]->getHeight() );
    ty += cb[2]->getHeight() + 5;
  } else {
    cb[2] = NULL;
    b[2] = NULL;
  }
  
  win->maximizeX();
  w = win->getWidth();
  
  win->maximizeX();
  w = win->getWidth();
  
  b2[0] = (Button*)win->add( new Button( aguix, 0, ty, catalog.getLocale( 397 ), 1, 0, 0 ) );
  b2[1] = (Button*)win->add( new Button( aguix, 0, ty, catalog.getLocale( 8 ), 1, 0, 0 ) );
  tw = AGUIX::scaleElementsW( w, win->getBorderWidth(), 10, -1, false, false, (GUIElement**)b2, NULL, 2 );
  if ( tw > w ) w = tw;
  
  ty += b2[0]->getHeight() + 5;
  
  h = ty;
  win->setDoTabCycling( true );
  win->resize( w, h );
  win->setMinSize( w, h );
  win->setMaxSize( w, h );
  win->show();
  
  ende = 0;
  while ( ende == 0 ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      if ( msg->type == AG_CLOSEWINDOW ) {
        if ( msg->closewindow.window == win->getWindow() )
          ende = -1;
      } else if ( msg->type == AG_BUTTONCLICKED ) {
        if ( msg->button.button == b2[0] ) {
          // Okay
          ende = 1;
        } else if ( msg->button.button == b2[1] ) {
          // Cancel
          ende = -1;
        } else if ( ( msg->button.button == b[0] ) && ( b[0] != NULL ) ) {
          importconfig->changeButtons();
        } else if ( ( msg->button.button == b[1] ) && ( b[1] != NULL ) )  {
          importconfig->changeHotkeys();
        } else if ( ( msg->button.button == b[2] ) && ( b[2] != NULL ) )  {
          importconfig->changeTypes( true, true );
        }
      } else if ( msg->type == AG_STRINGGADGET_DEACTIVATE ) {
      }

      aguix->ReplyMessage( msg );
    }
    if ( ende == 1 ) {
      // now try to import
      // in case of failure keep this window so we do this
      // inside the loop
      
      if ( cb[0] != NULL ) {
        apply_b = cb[0]->getState() ;
      } else apply_b = false;

      if ( cb[1] != NULL ) {
        apply_h = cb[1]->getState() ;
      } else apply_h = false;

      if ( cb[2] != NULL ) {
        apply_f = cb[2]->getState() ;
      } else apply_f = false;

      if ( ( apply_b == true ) ||
           ( apply_h == true ) ||
           ( apply_f == true ) ) {
        // something to import
        // when import failed set ende back to 0
        if ( cfg_import4( importconfig, apply_b, apply_h, apply_f ) != 0 ) {
          ende = 0;
        }
      } else {
        req.request( catalog.getLocale( 124 ), catalog.getLocale( 417 ),
                      catalog.getLocale( 11 ) );
        ende = 0;
      }
    }
  }
  
  win->close();
  delete win;
  
  return ( ende == -1 ) ? 1 : 0;
}

/*
 * Step 4 of import
 * now import the config
 *
 */
int WConfig::cfg_import4( WConfig *importconfig, bool apply_b, bool apply_h, bool apply_f )
{
  List *bl, *hl, *fl, l1, *im_fl;
  WCButton *im_b1, *b1;
  WCHotkey *im_h1, *h1;
  WCFiletype *im_f1, *f1;
  WCPath *p1;
  char *textstr;
  WCShortkey *tsk;
  int ende = 0, erg, id, im_id, maxcols;
  std::string str1;
  Requester req( worker->getAGUIX() );
  bool always_keep;
  WCDoubleShortkey *dk;
  List *dkeys;

  /* 1.resolve any shortkey problem
   * 2.add buttons banks to this config
   *   colors could be wrong for the imported buttons!
   * 3.add hotkeys to this config
   * 4.add normal filetypes to this config
   * 5.ask for the special types (if any)
   *   leave the current
   *   or take the new
   */

  maxcols = getColors()->size();

  if ( apply_b == true ) {
    always_keep = false;

    bl = importconfig->getButtons();
    id = bl->initEnum();
    im_b1 = (WCButton*)bl->getFirstElement( id );
    while ( ( im_b1 != NULL ) && ( ende == 0 ) ) {
      dkeys = im_b1->getDoubleKeys();

      id = dkeys->initEnum();
      dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
      while ( dk != NULL ) {
        if ( findDoubleShortkey( dk, &b1, &p1, &h1 ) != 0 ) {
          // there is already an element with this shortkey
          if ( always_keep == true ) {
            im_b1->removeKey( dk );
          } else {
            if ( b1 != NULL ) {
              // "The new button %s uses the same shortkey as the button %s!"
              textstr = (char*)_allocsafe( strlen( catalog.getLocale( 419 ) ) +
                                           strlen( im_b1->getText() ) +
                                           strlen( b1->getText() ) + 1 );
              sprintf( textstr, catalog.getLocale( 419 ), im_b1->getText(), b1->getText() );
  
              str1 = catalog.getLocale( 425 );
              str1 += "|";
              str1 += catalog.getLocale( 431 );
              str1 += "|";
              str1 += catalog.getLocale( 426 );
              str1 += "|";
              str1 += catalog.getLocale( 8 );
              erg = req.request( catalog.getLocale( 123 ), textstr, str1.c_str() );
              _freesafe(textstr);
  
              if ( erg == 2 ) {
                // use new
                b1->removeKey( dk );
              } else if ( erg == 1 ) {
                im_b1->removeKey( dk );
                always_keep = true;
              } else if ( erg == 0 ) {
                // leave original
                im_b1->removeKey( dk );
              } else ende = -1;
            } else if ( p1 != NULL ) {
              // "The new button %s uses the same shortkey as the path %s!"
              textstr = (char*)_allocsafe( strlen( catalog.getLocale( 423 ) ) +
                                           strlen( im_b1->getText() ) +
                                           strlen( p1->getName() ) + 1 );
              sprintf( textstr, catalog.getLocale( 423 ), im_b1->getText(), p1->getName() );
  
              str1 = catalog.getLocale( 425 );
              str1 += "|";
              str1 += catalog.getLocale( 431 );
              str1 += "|";
              str1 += catalog.getLocale( 426 );
              str1 += "|";
              str1 += catalog.getLocale( 8 );
              erg = req.request( catalog.getLocale( 123 ), textstr, str1.c_str() );
              _freesafe(textstr);
  
              if ( erg == 2 ) {
                // use new
                p1->removeKey( dk );
              } else if ( erg == 1 ) {
                im_b1->removeKey( dk );
                always_keep = true;
              } else if ( erg == 0 )  {
                // leave original
                im_b1->removeKey( dk );
              } else ende = -1;
            } else if ( h1 != NULL ) {
              // "The new button %s uses the same shortkey as the hotkey %s!"
              textstr = (char*)_allocsafe( strlen( catalog.getLocale( 421 ) ) +
                                           strlen( im_b1->getText() ) +
                                           strlen( h1->getName() ) + 1 );
              sprintf( textstr, catalog.getLocale( 421 ), im_b1->getText(), h1->getName() );
  
              str1 = catalog.getLocale( 425 );
              str1 += "|";
              str1 += catalog.getLocale( 431 );
              str1 += "|";
              str1 += catalog.getLocale( 426 );
              str1 += "|";
              str1 += catalog.getLocale( 8 );
              erg = req.request( catalog.getLocale( 123 ), textstr, str1.c_str() );
              _freesafe(textstr);
  
              if ( erg == 2 ) {
                // use new
                h1->removeKey( dk );
              } else if ( erg == 1 ) {
                im_b1->removeKey( dk );
                always_keep = true;
              } else if ( erg == 0 )  {
                // leave original
                im_b1->removeKey( dk );
              } else ende = -1;
            }
          }
        }
        dk = (WCDoubleShortkey*)dkeys->getNextElement( id );
      }
      dkeys->closeEnum( id );
      if ( im_b1->getFG() >= maxcols ) im_b1->setFG( maxcols - 1 );
      if ( im_b1->getBG() >= maxcols ) im_b1->setBG( maxcols - 1 );
      im_b1 = (WCButton*)bl->getNextElement( id );
    }
    bl->closeEnum( id );
  }

  if ( ende != 0 ) return 1;

  if ( apply_h == true ) {
    always_keep = false;

    hl = importconfig->getHotkeys();
    id = hl->initEnum();
    im_h1 = (WCHotkey*)hl->getFirstElement( id );
    while ( ( im_h1 != NULL ) && ( ende == 0 ) ) {
      dkeys = im_h1->getDoubleKeys();

      tsk = im_h1->getKey();
      if ( tsk != NULL ) {
        if ( ( tsk->isReal() == true ) && ( im_h1->hasKey( tsk->getShortkey(), tsk->getMod() ) == false ) ) {
          dk = new WCDoubleShortkey();
          dk->setType( WCDoubleShortkey::WCDS_NORMAL );
          dk->setKeySym( tsk->getShortkey(), 0 );
          dk->setMod( tsk->getMod(), 0 );
          dkeys->addElement( dk );
        }
        im_h1->setKey( NULL );
      }
      id = dkeys->initEnum();
      dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
      while ( dk != NULL ) {
        if ( findDoubleShortkey( dk, &b1, &p1, &h1 ) != 0 ) {
          if ( always_keep == true ) {
            im_h1->removeKey( dk );
          } else {
            // there is already an element with this shortkey
            if ( b1 != NULL ) {
              // "The new hotkey %s uses the same shortkey as the button %s!"
              textstr = (char*)_allocsafe( strlen( catalog.getLocale( 420 ) ) +
                                           strlen( im_h1->getName() ) +
                                           strlen( b1->getText() ) + 1 );
              sprintf( textstr, catalog.getLocale( 420 ), im_h1->getName(), b1->getText() );
  
              str1 = catalog.getLocale( 425 );
              str1 += "|";
              str1 += catalog.getLocale( 431 );
              str1 += "|";
              str1 += catalog.getLocale( 426 );
              str1 += "|";
              str1 += catalog.getLocale( 8 );
              erg = req.request( catalog.getLocale( 123 ), textstr, str1.c_str() );
              _freesafe(textstr);
  
              if ( erg == 2 ) {
                // use new
                b1->removeKey( dk );
              } else if ( erg == 1 ) {
                im_h1->removeKey( dk );
                always_keep = true;
              } else if ( erg == 0 )  {
                // leave original
                im_h1->removeKey( dk );
              } else ende = -1;
            } else if ( p1 != NULL ) {
              // "The new hotkey %s uses the same shortkey as the path %s!"
              textstr = (char*)_allocsafe( strlen( catalog.getLocale( 424 ) ) +
                                           strlen( im_h1->getName() ) +
                                           strlen( p1->getName() ) + 1 );
              sprintf( textstr, catalog.getLocale( 424 ), im_h1->getName(), p1->getName() );
  
              str1 = catalog.getLocale( 425 );
              str1 += "|";
              str1 += catalog.getLocale( 431 );
              str1 += "|";
              str1 += catalog.getLocale( 426 );
              str1 += "|";
              str1 += catalog.getLocale( 8 );
              erg = req.request( catalog.getLocale( 123 ), textstr, str1.c_str() );
              _freesafe(textstr);
  
              if ( erg == 2 ) {
                // use new
                p1->removeKey( dk );
              } else if ( erg == 1 ) {
                im_h1->removeKey( dk );
                always_keep = true;
              } else if ( erg == 0 )  {
                // leave original
                im_h1->removeKey( dk );
              } else ende = -1;
            } else if ( h1 != NULL ) {
              // "The new hotkey %s uses the same shortkey as the hotkey %s!"
              textstr = (char*)_allocsafe( strlen( catalog.getLocale( 422 ) ) +
                                           strlen( im_h1->getName() ) +
                                           strlen( h1->getName() ) + 1 );
              sprintf( textstr, catalog.getLocale( 422 ), im_h1->getName(), h1->getName() );
  
              str1 = catalog.getLocale( 425 );
              str1 += "|";
              str1 += catalog.getLocale( 431 );
              str1 += "|";
              str1 += catalog.getLocale( 426 );
              str1 += "|";
              str1 += catalog.getLocale( 8 );
              erg = req.request( catalog.getLocale( 123 ), textstr, str1.c_str() );
              _freesafe(textstr);

             if ( erg == 2 ) {
                // use new
                h1->removeKey( dk );
              } else if ( erg == 1 ) {
                im_h1->removeKey( dk );
                always_keep = true;
              } else if ( erg == 0 )  {
                // leave original
                im_h1->removeKey( dk );
              } else ende = -1;
            }
          }
        }
        dk = (WCDoubleShortkey*)dkeys->getNextElement( id );
      }
      dkeys->closeEnum( id );
      im_h1 = (WCHotkey*)hl->getNextElement( id );
    }
    hl->closeEnum( id );
  }

  if ( ende != 0 ) return 1;

  // now all shortkey conflicts are resolved
  
  // now add buttons, hotkeys and normal filetypes
  // put original and new buttons in a list and call setButtons
  // so if I change something later in setButtons, I don't have to do it here too
  if ( apply_b == true ) {
    bl = getButtons();
    id = bl->initEnum();
    b1 = (WCButton*)bl->getFirstElement( id );
    while ( b1 != NULL ) {
      l1.addElement( b1->duplicate() );
      b1 = (WCButton*)bl->getNextElement( id );
    }
    bl->closeEnum( id );

    bl = importconfig->getButtons();
    id = bl->initEnum();
    im_b1 = (WCButton*)bl->getFirstElement( id );
    while ( im_b1 != NULL ) {
      l1.addElement( im_b1->duplicate() );
      im_b1 = (WCButton*)bl->getNextElement( id );
    }
    bl->closeEnum( id );
    
    setButtons( &l1 );
    
    b1 = (WCButton*)l1.getFirstElement();
    while ( b1 != NULL ) {
      delete b1;
      l1.removeFirstElement();
      b1 = (WCButton*)l1.getFirstElement();
    }
  }
  // like buttons
  if ( apply_h == true ) {
    hl = getHotkeys();
    id = hl->initEnum();
    h1 = (WCHotkey*)hl->getFirstElement( id );
    while ( h1 != NULL ) {
      l1.addElement( h1->duplicate() );
      h1 = (WCHotkey*)hl->getNextElement( id );
    }
    hl->closeEnum( id );

    hl = importconfig->getHotkeys();
    id = hl->initEnum();
    im_h1 = (WCHotkey*)hl->getFirstElement( id );
    while ( im_h1 != NULL ) {
      l1.addElement( im_h1->duplicate() );
      im_h1 = (WCHotkey*)hl->getNextElement( id );
    }
    hl->closeEnum( id );
    
    setHotkeys( &l1 );
    
    h1 = (WCHotkey*)l1.getFirstElement();
    while ( h1 != NULL ) {
      delete h1;
      l1.removeFirstElement();
      h1 = (WCHotkey*)l1.getFirstElement();
    }
  }
  if ( apply_f == true ) {
    // here we need a two-pass-run over the types
    // 1.For each unique type in importconfig
    //   find equal unique
    //   Ask which should be used and add it
    // 2.add all normal types from current config and then from importconfig
    fl = getFiletypes();
    im_fl = importconfig->getFiletypes();

    id = fl->initEnum();
    im_id = im_fl->initEnum();

    f1 = (WCFiletype*)fl->getFirstElement( id );
    while ( f1 != NULL ) {
      if ( f1->getinternID() != NORMALTYPE ) {
        // not a normal type
        // because special types are unique, ask the user
        // which should be used

        // find new type for this id
        im_f1 = (WCFiletype*)im_fl->getFirstElement( im_id );
        while ( im_f1 != NULL ) {
          if ( im_f1->getinternID() == f1->getinternID() ) break;
          im_f1 = (WCFiletype*)im_fl->getNextElement( im_id );
        }

        if ( im_f1 != NULL ) {
          // same unique type found
          textstr = (char*)_allocsafe( strlen( catalog.getLocale( 429 ) ) +
                                       strlen( im_f1->getName() ) +
                                       strlen( f1->getName() ) + 1 );
          sprintf( textstr, catalog.getLocale( 429 ), im_f1->getName(), f1->getName() );

          str1 = catalog.getLocale( 427 );
          str1 += "|";
          str1 += catalog.getLocale( 428 );
          erg = req.request( catalog.getLocale( 123 ), textstr, str1.c_str() );
          _freesafe( textstr );
          if ( erg == 0 ) {
            l1.addElement( f1->duplicate() );
          } else {
            l1.addElement( im_f1->duplicate() );            
          }
        } else {
          l1.addElement( f1->duplicate() );
        }
      }
      f1 = (WCFiletype*)fl->getNextElement( id );
    }
    fl->closeEnum( id );
    im_fl->closeEnum( im_id );
    
    // now add all normal types beginning in fl, then in im_fl
    fl = getFiletypes();
    id = fl->initEnum();
    f1 = (WCFiletype*)fl->getFirstElement( id );
    while ( f1 != NULL ) {
      if ( f1->getinternID() == NORMALTYPE )
        l1.addElement( f1->duplicate() );
      f1 = (WCFiletype*)fl->getNextElement( id );
    }
    fl->closeEnum( id );

    fl = importconfig->getFiletypes();
    id = fl->initEnum();
    im_f1 = (WCFiletype*)fl->getFirstElement( id );
    while ( im_f1 != NULL ) {
      if ( im_f1->getinternID() == NORMALTYPE )
        l1.addElement( im_f1->duplicate() );
      im_f1 = (WCFiletype*)fl->getNextElement( id );
    }
    fl->closeEnum( id );
    
    setFiletypes( &l1 );
    
    f1 = (WCFiletype*)l1.getFirstElement();
    while ( f1 != NULL ) {
      delete f1;
      l1.removeFirstElement();
      f1 = (WCFiletype*)l1.getFirstElement();
    }
  }
  req.request( catalog.getLocale( 124 ), catalog.getLocale( 430 ), catalog.getLocale( 11 ) );
  return 0;
}

void WConfig::setDateFormat( int nv )
{
  date_format = nv;
  if ( date_format < -1 ) date_format = 0;
}

int WConfig::getDateFormat()
{
  return date_format;
}

void WConfig::setDateFormatString( const char *nv )
{
  _freesafe( date_formatstring );
  if ( nv == NULL ) {
    date_formatstring = dupstring( DEFAULT_DATE_STRING );
  } else {
    date_formatstring = dupstring( nv );
  }
}

const char *WConfig::getDateFormatString()
{
  return date_formatstring;
}

void WConfig::setDateSubst( bool nv )
{
  date_subst = nv;
}

bool WConfig::getDateSubst()
{
  return date_subst;
}

void WConfig::setTimeFormat( int nv )
{
  time_format = nv;
  if ( time_format < -1 ) time_format = 0;
}

int WConfig::getTimeFormat()
{
  return time_format;
}

void WConfig::setTimeFormatString( const char *nv )
{
  _freesafe( time_formatstring );
  if ( nv == NULL ) {
    time_formatstring = dupstring( DEFAULT_TIME_STRING );
  } else {
    time_formatstring = dupstring( nv );
  }
}

const char *WConfig::getTimeFormatString()
{
  return time_formatstring;
}

void WConfig::setDateBeforeTime( bool nv )
{
  date_before_time = nv;
}

bool WConfig::getDateBeforeTime()
{
  return date_before_time;
}

int WConfig::configureDateTime()
{
  AWindow *win,*swin1, *swin2;
  AGUIX *aguix = worker->getAGUIX();
  int w, h, ende, ty, tw, tx;
  AGMessage *msg;
  ChooseButton *cb1,*cb2;
  Button *b2[2];
  Text *ttext,*text1,*text2;
  StringGadget *sg1,*sg2;
  BevelBox *bb1,*bb2;
  CycleButton *cyc1,*cyc2;
  int nr_of_predates, nr_of_pretimes, i;
  char buf[128];
  time_t curtime;
  struct tm *loctime;
  
  w = h = 10;
  win = new AWindow(aguix);
  win->create( NULL, 10, 10, w, h, 0, catalog.getLocale( 439 ) );

  ty = 5;
  
  ttext = (Text*)win->add( new Text( aguix, 5, ty, catalog.getLocale( 440 ), 1 ) );
  ty += ttext->getHeight() + 5;
  
  bb1 = (BevelBox*)win->add( new BevelBox( aguix, 5, ty, w, h, 1 ) );
  ty += 5;
  tx = 10;
  
  cyc1 = (CycleButton*)win->add( new CycleButton( aguix, tx, ty, 100, 1, 0, 0 ) );
  ty+= cyc1->getHeight() + 5;
  
  swin1 = new AWindow( aguix );
  swin1->create( win, tx, ty, 10, 10, 0, "" );
  text1 = (Text*)swin1->add( new Text( aguix, 0, 0, catalog.getLocale( 441 ), 1 ) );
  sg1 = (StringGadget*)swin1->add( new StringGadget( aguix, text1->getWidth() + 5, 0, 200, date_formatstring, 0 ) );
  AGUIX::centerElementsY( text1, sg1 );

  swin1->setBorderWidth( 0 );  
  swin1->maximizeY();
  swin1->maximizeX();
  
  ty += swin1->getHeight() + 5;
  swin1->show();
  
  cb1 = (ChooseButton*)win->add( new ChooseButton( aguix,
                                                   tx,
                                                   ty,
                                                   date_subst,
                                                   catalog.getLocale( 442 ),
                                                   LABEL_LEFT,
                                                   1,
                                                   0 ) );
  ty += cb1->getHeight() + 10;
  
  curtime = time( NULL );
  loctime = localtime( &curtime );
  nr_of_predates = sizeof( predefined_dates ) / sizeof( predefined_dates[0] );
  for ( i = 0; i < nr_of_predates; i++ ) {
    strftime( buf, 127, predefined_dates[i], loctime );
    cyc1->addOption( buf );
  }
  cyc1->addOption( catalog.getLocale( 443 ) );
  
  bb1->resize( bb1->getWidth(), cb1->getY() + cb1->getHeight() + 5 - bb1->getY() );
  tx = 5;

  // time
  ttext = (Text*)win->add( new Text( aguix, 5, ty, catalog.getLocale( 444 ), 1 ) );
  ty += ttext->getHeight() + 5;
  
  bb2 = (BevelBox*)win->add( new BevelBox( aguix, 5, ty, w, h, 1 ) );
  ty += 5;
  tx = 10;
  
  cyc2 = (CycleButton*)win->add( new CycleButton( aguix, tx, ty, 100, 1, 0, 0 ) );
  ty+= cyc2->getHeight() + 5;
  
  swin2 = new AWindow( aguix );
  swin2->create( win, tx, ty, 10, 10, 0, "" );
  text2 = (Text*)swin2->add( new Text( aguix, 0, 0, catalog.getLocale( 441 ), 1 ) );
  sg2 = (StringGadget*)swin2->add( new StringGadget( aguix, text2->getWidth() + 5, 0, 200, time_formatstring, 0 ) );
  AGUIX::centerElementsY( text2, sg2 );

  swin2->setBorderWidth( 0 );
  swin2->maximizeY();
  swin2->maximizeX();
  
  ty += swin2->getHeight() + 10;
  swin2->show();
  
  nr_of_pretimes = sizeof( predefined_times ) / sizeof( predefined_times[0] );
  for ( i = 0; i < nr_of_pretimes; i++ ) {
    strftime( buf, 127, predefined_times[i], loctime );
    cyc2->addOption( buf );
  }
  cyc2->addOption( catalog.getLocale( 443 ) );
  
  bb2->resize( bb2->getWidth(), swin2->getY() + swin2->getHeight() + 5 - bb2->getY() );

  tx = 5;
  cb2 = (ChooseButton*)win->add( new ChooseButton( aguix,
                                                   tx,
                                                   ty,
                                                   date_before_time,
                                                   catalog.getLocale( 445),
                                                   LABEL_LEFT,
                                                   1,
                                                   0 ) );
  ty += cb2->getHeight() + 10;

  cyc1->resize( cyc1->getMaxSize(), cyc1->getHeight() );
  cyc2->resize( cyc2->getMaxSize(), cyc2->getHeight() );
  
  win->maximizeX();
  w = win->getWidth() + 5;
  
  bb1->resize( w - 10, bb1->getHeight() );
  bb2->resize( w - 10, bb2->getHeight() );
  
  b2[0] = (Button*)win->add( new Button( aguix, 0, ty, catalog.getLocale( 11 ), 1, 0, 0 ) );
  b2[1] = (Button*)win->add( new Button( aguix, 0, ty, catalog.getLocale( 8 ), 1, 0, 0 ) );
  tw = AGUIX::scaleElementsW( w, win->getBorderWidth(), 10, -1, false, false, (GUIElement**)b2, NULL, 2 );
  if ( tw > w ) w = tw;
  
  ty += b2[0]->getHeight() + 5;
  
  h = ty;

  if ( date_format == -1 ) {
    cyc1->setOption( nr_of_predates );
  } else {
    if ( ( date_format >= 0 ) && ( date_format < nr_of_predates ) ) {
      cyc1->setOption( date_format );
    } else {
      cyc1->setOption( 0 );
    }
    swin1->hide();
  }
  if ( time_format == -1 ) {
    cyc2->setOption( nr_of_pretimes );
  } else {
    if ( ( time_format >= 0 ) && ( time_format < nr_of_pretimes ) ) {
      cyc2->setOption( time_format );
    } else {
      cyc2->setOption( 0 );
    }
    swin2->hide();
  }

  win->setDoTabCycling( true );
  win->resize( w, h );
  win->setMinSize( w, h );
  win->setMaxSize( w, h );
  win->show();
  
  ende = 0;
  while ( ende == 0 ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      if ( msg->type == AG_CLOSEWINDOW ) {
        if ( msg->closewindow.window == win->getWindow() )
          ende = -1;
      } else if ( msg->type == AG_BUTTONCLICKED ) {
        if ( msg->button.button == b2[0] ) {
          // Okay
          ende = 1;
        } else if ( msg->button.button == b2[1] ) {
          // Cancel
          ende = -1;
        }
      } else if ( msg->type == AG_CYCLEBUTTONCLICKED ) {
        if ( msg->cyclebutton.cyclebutton == cyc1 ) {
          if ( msg->cyclebutton.option == nr_of_predates )
            swin1->show();
          else
            swin1->hide();
        } else if ( msg->cyclebutton.cyclebutton == cyc2 ) {
          if ( msg->cyclebutton.option == nr_of_pretimes )
            swin2->show();
          else
            swin2->hide();
        }
      }

      aguix->ReplyMessage( msg );
    }
    if ( ende == 1 ) {
      i = cyc1->getSelectedOption();
      if ( i == nr_of_predates ) {
        setDateFormat( -1 );
        setDateFormatString( sg1->getText() );
      } else {
        setDateFormat( i );
      }
      setDateSubst( ( cb1->getState() == 1 ) ? true : false );

      i = cyc2->getSelectedOption();
      if ( i == nr_of_pretimes ) {
        setTimeFormat( -1 );
        setTimeFormatString( sg2->getText() );
      } else {
        setTimeFormat( i );
      }
      setDateBeforeTime( ( cb2->getState() == 1 ) ? true : false );     
    }
  }
  
  swin1->close();
  delete swin1;
  swin2->close();
  delete swin2;
  win->close();
  delete win;
  
  return ( ende == -1 ) ? 1 : 0;
}

int WConfig::getDatelen( const struct tm *timeptr )
{
  char buf[512];
  const char *format;
  int i, nr_of_predates, nr_of_pretimes, x, len, tlen;
  int datestrlen;
  
  if ( timeptr == NULL ) return 512;  // max length we will allow

  nr_of_predates = sizeof( predefined_dates ) / sizeof( predefined_dates[0] );
  nr_of_pretimes = sizeof( predefined_times ) / sizeof( predefined_times[0] );

  if ( date_format == -1 ) {
    format = date_formatstring;
  } else {
    i = 0;
    if ( ( date_format >= 0 ) && ( date_format < nr_of_predates ) ) {
      i = date_format;
    }
    format = predefined_dates[i];
  }
  
  len = strftime( buf, 511, format, timeptr );
  if ( date_subst == true ) {
    tlen = strlen( catalog.getLocale(436) );
    if ( tlen > len ) len = tlen;
    tlen = strlen( catalog.getLocale(437) );
    if ( tlen > len ) len = tlen;
    tlen = strlen( catalog.getLocale(438) );
    if ( tlen > len ) len = tlen;
  }
  
  datestrlen = len;
  
  // now for the time
  if ( time_format == -1 ) {
    format = time_formatstring;
  } else {
    i = 0;
    if ( ( time_format >= 0 ) && ( time_format < nr_of_pretimes ) ) {
      i = time_format;
    }
    format = predefined_times[i];
  }
  
  x = strftime( buf, 511, format, timeptr );
  return x + 1 + datestrlen;
}

int WConfig::writeDateToString( char *buf, int maxlen , struct tm *tptr )
{
  const char *tformat, *dformat;
  int i, nr_of_predates, nr_of_pretimes, len, offset;
  time_t now;
  struct tm *timeptr, todaytime, yesterdaytime, tomorrowtime, curtime;
  bool istoday = false, isyesterday = false, istomorrow = false;
  int ylen, tolen, tomlen, dlen;
  char tbuf[512];
  
  if ( tptr == NULL ) return 0;
  if ( buf == NULL ) return 0;
  if ( maxlen < 1 ) return 0;
  
  curtime = *tptr;

  now = time( NULL );
  timeptr = localtime( &now );
  todaytime = *timeptr;
  now -= 24*60*60;  // this is yesterday
  timeptr = localtime( &now );
  yesterdaytime = *timeptr;
  now += 2*24*60*60; // this is tomorrow
  timeptr = localtime( &now );
  tomorrowtime = *timeptr;
  
  if ( ( curtime.tm_mday == todaytime.tm_mday ) &&
       ( curtime.tm_mon == todaytime.tm_mon ) &&
       ( curtime.tm_year == todaytime.tm_year ) ) {
    istoday = true;
  } else {
    if ( ( curtime.tm_mday == yesterdaytime.tm_mday ) &&
         ( curtime.tm_mon == yesterdaytime.tm_mon ) &&
         ( curtime.tm_year == yesterdaytime.tm_year ) ) {
      isyesterday = true;
    } else {
      if ( ( curtime.tm_mday == tomorrowtime.tm_mday ) &&
           ( curtime.tm_mon == tomorrowtime.tm_mon ) &&
           ( curtime.tm_year == tomorrowtime.tm_year ) ) {
        istomorrow = true;
      }
    }
  }

  nr_of_predates = sizeof( predefined_dates ) / sizeof( predefined_dates[0] );
  nr_of_pretimes = sizeof( predefined_times ) / sizeof( predefined_times[0] );

  if ( date_format == -1 ) {
    dformat = date_formatstring;
  } else {
    i = 0;
    if ( ( date_format >= 0 ) && ( date_format < nr_of_predates ) ) {
      i = date_format;
    }
    dformat = predefined_dates[i];
  }

  dlen = strftime( tbuf, 511, dformat, &curtime );
  len = dlen;
  if ( date_subst == true ) {
    ylen = strlen( catalog.getLocale(436) );
    if ( ylen > len ) len = ylen;
    tolen = strlen( catalog.getLocale(437) );
    if ( tolen > len ) len = tolen;
    tomlen = strlen( catalog.getLocale(438) );
    if ( tomlen > len ) len = tomlen;
  }
  datelen = len;

  if ( time_format == -1 ) {
    tformat = time_formatstring;
  } else {
    i = 0;
    if ( ( time_format >= 0 ) && ( time_format < nr_of_pretimes ) ) {
      i = time_format;
    }
    tformat = predefined_times[i];
  }
  
  offset = 0;
  for ( i = 0; i < 2; i++ ) {
    if ( ( ( date_before_time == true ) && ( i == 0 ) ) ||
         ( ( date_before_time == false ) && ( i == 1 ) ) ) {
      if ( ( date_subst == true ) && ( istoday == true ) ) {
        len = strlen( catalog.getLocale(437) );
        len = w_min( len, maxlen - offset );
        strncpy( buf + offset, catalog.getLocale(437), len );
      } else if ( ( date_subst == true ) && ( isyesterday == true ) ) {
        len = strlen( catalog.getLocale(436) );
        len = w_min( len, maxlen - offset );
        strncpy( buf + offset, catalog.getLocale(436), len );
      } else if ( ( date_subst == true ) && ( istomorrow == true ) ) {
        len = strlen( catalog.getLocale(438) );
        len = w_min( len, maxlen - offset );
        strncpy( buf + offset, catalog.getLocale(438), len );
      } else {
//        len = strftime( buf + offset, maxlen - offset, dformat, timeptr );
        len = w_min( dlen, maxlen - offset );
        strncpy( buf + offset, tbuf, len );
      }
      buf[ offset + len ] = ' ';
      offset += datelen + 1;
    } else {
      len = strftime( buf + offset, maxlen - offset, tformat, &curtime );
      buf[ offset + len ] = ' ';
      offset += len + 1;
    }
  }
  return offset - 1;
}

/*
 * just grabs a key without checking for other uses
 *
 * returns:
 *   0 no error
 *  -1 error
 */
int WConfig::grabKey( const char *title, const char *text, KeySym *return_key, unsigned int *return_mod )
{
  AGUIX *aguix = worker->getAGUIX();
  int w, h;
  int returnvalue = -1;
  
  if ( ( title == NULL ) || ( text == NULL ) || ( return_key == NULL ) || ( return_mod == NULL ) ) return -1;

  AWindow *win = new AWindow( aguix );
  w = 10;
  h = 10;
  win->create( NULL, 10, 10, w, h, 0, title );
  win->addTextFromString( text, 5, 5, 5, NULL, NULL, NULL );
  win->maximizeX();
  win->maximizeY();
  win->centerScreen();
  w = win->getWidth();
  h = win->getHeight();
  win->setMaxSize( w, h );
  win->setMinSize( w, h );
  win->show();
  AGMessage *msg;
  while ( ( msg = aguix->GetMessage( NULL ) ) != NULL ) aguix->ReplyMessage( msg );
  int ende = 0;
  
  while ( ende == 0 ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      if ( msg->type == AG_CLOSEWINDOW ) {
        if ( msg->closewindow.window == win->getWindow() ) ende = -1;
      } else if ( msg->type == AG_KEYPRESSED ) {
        if ( AGUIX::isModifier( msg->key.key ) == false ) {
          *return_key = msg->key.key;
          *return_mod = KEYSTATEMASK( msg->key.keystate );
          returnvalue = 0;
          ende = 1;
        }
      }
      aguix->ReplyMessage( msg );
    }
  }
  win->close();
  delete win;

  if ( ende < 0 ) returnvalue = -1;  
  return returnvalue;
}

/*
 * getDoubleShortkey
 * Returnvalue:
 * -1 Cancel, null in return_dk
 * 0 Okay, no collision, DoubleShortkey in return_dk
 * 1 Okay, collision with ignore_?, null in return_dk
 * 2 Okay, collision with some other, DoubleShortkey in return_dk
 */
int WConfig::getDoubleShortkey( bool doublek,
                                const WCButton *ignore_b,
                                const WCHotkey *ignore_h,
                                const WCPath *ignore_p,
                                WCDoubleShortkey **return_dk)
{
  WCDoubleShortkey *tsk = NULL;
  AGUIX *aguix = worker->getAGUIX();
  WCButton *b1;
  WCPath *p1;
  WCHotkey *h1;
  char *textstr, *buttonstr;
  Requester *req = new Requester( aguix );
  int erg;
  int returnvalue = -1;
  KeySym key1 = 0, key2 = 0;
  unsigned int mod1 = 0, mod2 = 0;
  
  tsk = new WCDoubleShortkey();
  int ende = 0;
  while ( ende == 0 ) {
    if ( doublek == true ) {
      erg = grabKey( catalog.getLocale( 66 ), catalog.getLocale( 455 ), &key1, &mod1 );
      if ( erg == 0 ) {
        erg = grabKey( catalog.getLocale( 66 ), catalog.getLocale( 456 ), &key2, &mod2 );
      }
      if ( erg == 0 ) {
      } else {
        // user aborted
        ende = -1;
      }
    } else {
      erg = grabKey( catalog.getLocale( 66 ), catalog.getLocale( 66 ), &key1, &mod1 );
      if ( erg != 0 ) ende = -1;
    }
    if ( ende == 0 ) {
      tsk->setType( doublek == true ? WCDoubleShortkey::WCDS_DOUBLE : WCDoubleShortkey::WCDS_NORMAL );
      tsk->setKeySym( key1, 0 );
      tsk->setMod( mod1, 0 );
      if ( doublek == true ) {
        tsk->setKeySym( key2, 1 );
        tsk->setMod( mod2, 1 );
      }
      // search for other reference
      if ( findDoubleShortkey( tsk, &b1, &p1, &h1 ) != 0 ) {
        if ( b1 != NULL ) {
          if ( b1 == ignore_b ) {
            returnvalue = 1;
            ende = 1;
          } else {
            textstr = (char*)_allocsafe( strlen( catalog.getLocale( 42 ) ) + strlen( b1->getText() ) + 1 );
            sprintf( textstr, catalog.getLocale( 42 ), b1->getText() );
            buttonstr = (char*)_allocsafe( strlen( catalog.getLocale( 41 ) ) + 1 +
                                           strlen( catalog.getLocale( 11 ) ) + 1 +
                                           strlen( catalog.getLocale( 8 ) ) + 1 );
            sprintf( buttonstr, "%s|%s|%s", catalog.getLocale( 41 ),
                                            catalog.getLocale( 11 ),
                                            catalog.getLocale( 8 ) );
            erg = req->request( catalog.getLocale( 125 ), textstr, buttonstr );
            _freesafe( textstr );
            _freesafe( buttonstr );
            if ( erg == 2 ) ende = -1;
            else if ( erg == 1 ) {
              returnvalue = 2;
              ende = 1;
            }
          }
        } else if ( p1 != NULL ) {
          if ( p1 == ignore_p ) {
            returnvalue = 1;
            ende = 1;
          } else {
            textstr = (char*)_allocsafe( strlen( catalog.getLocale( 63 ) ) + strlen( p1->getName() ) + 1 );
            sprintf( textstr, catalog.getLocale( 63 ), p1->getName() );
            buttonstr = (char*)_allocsafe( strlen( catalog.getLocale( 41 ) ) + 1 +
                                           strlen( catalog.getLocale( 11 ) ) + 1 +
                                           strlen( catalog.getLocale( 8 ) ) + 1 );
            sprintf( buttonstr, "%s|%s|%s", catalog.getLocale( 41 ),
                                            catalog.getLocale( 11 ),
                                            catalog.getLocale( 8 ) );
            erg = req->request( catalog.getLocale( 125 ), textstr, buttonstr );
            _freesafe( textstr );
            _freesafe( buttonstr );
            if ( erg == 2 ) ende = -1;
            else if ( erg == 1 ) {
              returnvalue = 2;
              ende = 1;
            }
          }
        } else if ( h1 != NULL ) {
          if ( h1 == ignore_h ) {
            returnvalue = 1;
            ende = 1;
          } else {
            textstr = (char*)_allocsafe( strlen( catalog.getLocale( 65 ) ) + strlen( h1->getName() ) + 1 );
            sprintf( textstr, catalog.getLocale( 65 ), h1->getName() );
            buttonstr = (char*)_allocsafe( strlen( catalog.getLocale( 41 ) ) + 1 +
                                           strlen( catalog.getLocale( 11 ) ) + 1 +
                                           strlen( catalog.getLocale( 8 ) ) + 1 );
            sprintf( buttonstr, "%s|%s|%s", catalog.getLocale( 41 ),
                                            catalog.getLocale( 11 ),
                                            catalog.getLocale( 8 ) );
            erg = req->request( catalog.getLocale( 125 ), textstr, buttonstr );
            _freesafe( textstr );
            _freesafe( buttonstr );
            if ( erg == 2 ) ende = -1;
            else if ( erg == 1 ) {
              returnvalue = 2;
              ende = 1;
            }
          }
        }
      } else {
        returnvalue = 0;
        ende = 1;
      }
    }
  }
  delete req;

  if ( ende < 0 ) returnvalue = -1;  
  if( ( ( returnvalue == 2 ) ||
        ( returnvalue == 0 ) ) &&
      ( return_dk != NULL ) ) {
    *return_dk = tsk;
  } else {
    if ( return_dk != NULL )
      *return_dk = NULL;
    if ( tsk != NULL )
      delete tsk;
  }
  return returnvalue;
}

int WConfig::findDoubleShortkey( WCDoubleShortkey *dk,
                                 WCButton **return_button,
                                 WCPath **return_path,
                                 WCHotkey **return_hotkey )
{
  int id;
  WCHotkey *h1;
  WCButton *b1;
  WCPath *p1;
  
  // search for a hotkey
  id = hotkeys->initEnum();
  h1 = (WCHotkey*)hotkeys->getFirstElement( id );
  while ( h1 != NULL ) {
    if ( h1->conflictKey( dk ) == true )
      break;
    h1 = (WCHotkey*)hotkeys->getNextElement( id );
  }
  hotkeys->closeEnum( id );
  if ( h1 != NULL ) {
    *return_button = NULL;
    *return_path = NULL;
    *return_hotkey = h1;
    return 1;
  }
  
  // search for a path
  id = paths->initEnum();
  p1 = (WCPath*)paths->getFirstElement( id );
  while ( p1 != NULL ) {
    if ( p1->conflictKey( dk ) == true )
      break;
    p1 = (WCPath*)paths->getNextElement( id );
  }
  paths->closeEnum( id );
  if ( p1 != NULL ) {
    *return_button = NULL;
    *return_path = p1;
    *return_hotkey = NULL;
    return 2;
  }

  // search for a button
  id = buttons->initEnum();
  b1 = (WCButton*)buttons->getFirstElement( id );
  while ( b1 != NULL ) {
    if ( b1->conflictKey( dk ) == true )
      break;
    b1 = (WCButton*)buttons->getNextElement( id );
  }
  buttons->closeEnum( id );
  if ( b1 != NULL ) {
    *return_button = b1;
    *return_path = NULL;
    *return_hotkey = NULL;
    return 3;
  }
  *return_button = NULL;
  *return_path = NULL;
  *return_hotkey = NULL;
  return 0;
}

/****************************
 * class WKey begin
 ****************************/
WCKey::WCKey()
{
  dkeys = new List();
}

WCKey::~WCKey()
{
  removeAllKeys();
  delete dkeys;
}

List *WCKey::getDoubleKeys()
{
  return dkeys;
}

void WCKey::setDoubleKeys( List *dklist )
{
  int id;
  WCDoubleShortkey *dk;

  removeAllKeys();
  
  if ( dklist == NULL ) return;  // check after removeAll is not a bug but a feature
  
  id = dklist->initEnum();
  dk = (WCDoubleShortkey*)dklist->getFirstElement( id );
  while ( dk != NULL ) {
    dkeys->addElement( dk->duplicate() );
    dk = (WCDoubleShortkey*)dklist->getNextElement( id );
  }
  dklist->closeEnum( id );
}

bool WCKey::hasKey( KeySym k, unsigned int m )
{
  int id;
  WCDoubleShortkey *dk;
  bool found = false;

  id = dkeys->initEnum();
  dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
  while ( dk != NULL ) {
    if ( dk->getType() == WCDoubleShortkey::WCDS_NORMAL ) {
      if ( dk->isShortkey( k, m ) == true ) {
        found = true;
        break;
      }
    }
    dk = (WCDoubleShortkey*)dkeys->getNextElement( id );
  }
  dkeys->closeEnum( id );
  return found;
}

bool WCKey::hasKey( KeySym k1, unsigned int m1, KeySym k2, unsigned int m2 )
{
  int id;
  WCDoubleShortkey *dk;
  bool found = false;

  id = dkeys->initEnum();
  dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
  while ( dk != NULL ) {
    if ( dk->getType() == WCDoubleShortkey::WCDS_DOUBLE ) {
      if ( dk->isShortkey( k1, m1, k2, m2 ) == true ) {
        found = true;
        break;
      }
    }
    dk = (WCDoubleShortkey*)dkeys->getNextElement( id );
  }
  dkeys->closeEnum( id );
  return found;
}

/*
 * removes all matching single keys
 * and all double keys which begin with given key
 */
void WCKey::removeKey( KeySym k, unsigned int m )
{
  int id;
  WCDoubleShortkey *dk;
  int pos = 0;

  id = dkeys->initEnum();
  dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
  while ( dk != NULL ) {
    if ( dk->getType() == WCDoubleShortkey::WCDS_NORMAL ) {
      if ( dk->isShortkey( k, m ) == true ) {
        dkeys->removeElementAt( pos );
        pos--;
        delete dk;
      }
    } else if ( dk->getType() == WCDoubleShortkey::WCDS_DOUBLE ) {
      if ( ( dk->getKeySym( 0 ) == k ) &&
           ( dk->getMod( 0 ) == m ) ) {
        dkeys->removeElementAt( pos );
        pos--;
        delete dk;
      }
    }
    dk = (WCDoubleShortkey*)dkeys->getElementAt( id, ++pos );
  }
  dkeys->closeEnum( id );
}

/*
 * removes all matching double keys
 * and all single keys matching the k1/m1
 */
void WCKey::removeKey( KeySym k1, unsigned int m1, KeySym k2, unsigned int m2 )
{
  int id;
  WCDoubleShortkey *dk;
  int pos = 0;

  id = dkeys->initEnum();
  dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
  while ( dk != NULL ) {
    if ( dk->getType() == WCDoubleShortkey::WCDS_NORMAL ) {
      if ( dk->isShortkey( k1, m1 ) == true ) {
        dkeys->removeElementAt( pos );
        pos--;
        delete dk;
      }
    } else if ( dk->getType() == WCDoubleShortkey::WCDS_DOUBLE ) {
      if ( dk->isShortkey( k1, m1, k2, m2 ) == true ) {
        dkeys->removeElementAt( pos );
        pos--;
        delete dk;
      }
    }
    dk = (WCDoubleShortkey*)dkeys->getElementAt( id, ++pos );
  }
  dkeys->closeEnum( id );
}

void WCKey::removeKey( WCDoubleShortkey *dk )
{
  if ( dk == NULL ) return;
  if ( dk->getType() == WCDoubleShortkey::WCDS_DOUBLE ) {
    removeKey( dk->getKeySym( 0 ), dk->getMod( 0 ), dk->getKeySym( 1 ), dk->getMod( 1 ) );
  } else {
    removeKey( dk->getKeySym( 0 ), dk->getMod( 0 ) );
  }
}

void WCKey::removeAllKeys()
{
  int id;
  WCDoubleShortkey *dk;
  
  id = dkeys->initEnum();
  dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
  while ( dk != NULL ) {
    delete dk;
    dkeys->removeFirstElement();
    dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
  }
  dkeys->closeEnum( id );
}

bool WCKey::conflictKey( KeySym k, unsigned int m )
{
  int id;
  WCDoubleShortkey *dk;
  bool found = false;

  id = dkeys->initEnum();
  dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
  while ( dk != NULL ) {
    if ( dk->getType() == WCDoubleShortkey::WCDS_NORMAL ) {
      if ( dk->isShortkey( k, m ) == true ) {
        found = true;
        break;
      }
    } else if ( dk->getType() == WCDoubleShortkey::WCDS_DOUBLE ) {
      if ( ( dk->getKeySym( 0 ) == k ) &&
           ( dk->getMod( 0 ) == m ) ) {
        found = true;
        break;
      }
    }
    dk = (WCDoubleShortkey*)dkeys->getNextElement( id );
  }
  dkeys->closeEnum( id );
  
  return found;
}

bool WCKey::conflictKey( KeySym k1, unsigned int m1, KeySym k2, unsigned int m2 )
{
  int id;
  WCDoubleShortkey *dk;
  bool found = false;

  id = dkeys->initEnum();
  dk = (WCDoubleShortkey*)dkeys->getFirstElement( id );
  while ( dk != NULL ) {
    if ( dk->getType() == WCDoubleShortkey::WCDS_NORMAL ) {
      if ( dk->isShortkey( k1, m1 ) == true ) {
        found = true;
        break;
      }
    } else if ( dk->getType() == WCDoubleShortkey::WCDS_DOUBLE ) {
      if ( dk->isShortkey( k1, m1, k2, m2 ) == true ) {
        found = true;
        break;
      }
    }
    dk = (WCDoubleShortkey*)dkeys->getNextElement( id );
  }
  dkeys->closeEnum( id );
  
  return found;
}

bool WCKey::conflictKey( WCDoubleShortkey *dk )
{
  if ( dk == NULL ) return false;
  if ( dk->getType() == WCDoubleShortkey::WCDS_DOUBLE ) {
    return conflictKey( dk->getKeySym( 0 ), dk->getMod( 0 ), dk->getKeySym( 1 ), dk->getMod( 1 ) );
  } else {
    return conflictKey( dk->getKeySym( 0 ), dk->getMod( 0 ) );
  }
}

void WCKey::addKey( const KeySym k, const unsigned int m )
{
  WCDoubleShortkey *dk;
  
  dk = new WCDoubleShortkey();
  dk->setKeySym( k, 0 );
  dk->setMod( m, 0 );
  dk->setType( WCDoubleShortkey::WCDS_NORMAL );
  dkeys->addElement( dk );
}

void WCKey::addKey( const KeySym k1, const unsigned int m1, const KeySym k2, const unsigned int m2 )
{
  WCDoubleShortkey *dk;
  
  dk = new WCDoubleShortkey();
  dk->setKeySym( k1, 0 );
  dk->setMod( m1, 0 );
  dk->setKeySym( k2, 1 );
  dk->setMod( m2, 1 );
  dk->setType( WCDoubleShortkey::WCDS_DOUBLE );
  dkeys->addElement( dk );
}

void WCKey::addKey( const WCDoubleShortkey *dk )
{
  if ( dk == NULL ) return;
  dkeys->addElement( dk->duplicate() );
}

/****************************
 * class WKey end
 ****************************/

bool WConfig::checkForNewerConfig()
{
  if ( difftime( getFileConfigMod(), currentConfigTime ) > 0 ) return true;
  return false;
}

time_t WConfig::getFileConfigMod()
{
  struct stat buf;
  std::string str1;

  str1 = home;
  if ( strlen( home ) > 1 )
    if ( home[ strlen( home ) - 1 ] != '/' )
      str1 += "/";
#ifdef USEOWNCONFIGFILES
  str1 += "wconfig2";
#else
  str1 += "config";
#endif
  if ( stat( str1.c_str(), &buf ) == 0 ) {
    return buf.st_mtime;
  }
  return 0;
}

void WConfig::configPutPair( Datei *fh, const char *id, const char *info )
{
  std::string str1;
  int x;

  if ( ( fh == NULL ) || ( id == NULL ) || ( info == NULL ) ) return;
  str1 = "";
  for ( x = 0; x < sectiondepth; x++ ) str1 += "\t";
  str1 += id;
  str1 += " = ";
  str1 += info;
  str1 += ";";
  fh->putLine( str1.c_str() );
}

void WConfig::configPutPairNum( Datei *fh, const char *id, int num )
{
  std::string str1;
  char buf[A_BYTESFORNUMBER( int )];
  int x;

  if ( ( fh == NULL ) || ( id == NULL ) ) return;
  str1 = "";
  for ( x = 0; x < sectiondepth; x++ ) str1 += "\t";
  sprintf( buf, "%d", num );
  str1 += id;
  str1 += " = ";
  str1 += buf;
  str1 += ";";
  fh->putLine( str1.c_str() );
}

void WConfig::configPutPairNum( Datei *fh, const char *id, int num1, int num2 )
{
  std::string str1;
  char buf[A_BYTESFORNUMBER( int )];
  int x;

  if ( ( fh == NULL ) || ( id == NULL ) ) return;
  str1 = "";
  for ( x = 0; x < sectiondepth; x++ ) str1 += "\t";
  sprintf( buf, "%d", num1 );
  str1 += id;
  str1 += " = ";
  str1 += buf;
  str1 += ",";
  sprintf( buf, "%d", num2 );
  str1 += buf;
  str1 += ";";
  fh->putLine( str1.c_str() );
}

void WConfig::configPutPairString( Datei *fh, const char *id, const char *str )
{
  std::string str1;
  char *buf;
  int i, o;
  int x;

  if ( ( fh == NULL ) || ( id == NULL ) || ( str == NULL ) ) return;
  str1 = "";
  for ( x = 0; x < sectiondepth; x++ ) str1 += "\t";

  buf = (char*)_allocsafe( strlen( str ) * 2 + 1 );
  for ( i = 0, o = 0; i < (int)strlen( str ); i++ ) {
    if ( str[i] == '"' ) {
      buf[o++] = '\\';
      buf[o++] = '"';
    } else if ( str[i] == '\\' ) {
      buf[o++] = '\\';
      buf[o++] = '\\';
    } else {
      buf[o++] = str[i];
    }
  }
  buf[o] = '\0';
  str1 += id;
  str1 += " = \"";
  str1 += buf;
  str1 += "\";";
  _freesafe( buf );
  fh->putLine( str1.c_str() ); 
}

void WConfig::configPutPairBool( Datei *fh, const char *id, bool val )
{
  std::string str1;
  int x;

  if ( ( fh == NULL ) || ( id == NULL ) ) return;
  str1 = "";
  for ( x = 0; x < sectiondepth; x++ ) str1 += "\t";

  str1 += id;
  str1 += " = ";
  str1 += ( ( val == true ) ? "true" : "false" );
  str1 += ";";
  fh->putLine( str1.c_str() );
}

void WConfig::configPutInfo( Datei *fh, const char *str, bool semicolon )
{
  std::string str1;
  int x;

  if ( ( fh == NULL ) || ( str == NULL ) ) return;
  str1 = "";
  for ( x = 0; x < sectiondepth; x++ ) str1 += "\t";

  str1 += str;
  if ( semicolon == true ) str1 += ";";
  fh->putLine( str1.c_str() );
}

void WConfig::configPutString( Datei *fh, const char *str, bool semicolon )
{
  std::string str1;
  char *buf;
  int i, o;
  int x;

  if ( ( fh == NULL ) || ( str == NULL ) ) return;
  str1 = "";
  for ( x = 0; x < sectiondepth; x++ ) str1 += "\t";

  buf = (char*)_allocsafe( strlen( str ) * 2 + 1 );
  for ( i = 0, o = 0; i < (int)strlen( str ); i++ ) {
    if ( str[i] == '"' ) {
      buf[o++] = '\\';
      buf[o++] = '"';
    } else if ( str[i] == '\\' ) {
      buf[o++] = '\\';
      buf[o++] = '\\';
    } else {
      buf[o++] = str[i];
    }
  }
  buf[o] = '\0';
  str1 += "\"";
  str1 += buf;
  str1 += "\";";
  _freesafe( buf );
  fh->putLine( str1.c_str() ); 
}

void WConfig::configOpenSection( Datei *fh, const char *sectioname )
{
  int x;
  std::string str1;

  if ( ( fh == NULL ) || ( sectioname == NULL ) ) return;
  if ( ( sectiondepth < 0 ) || ( sectiondepth > 100 ) ) sectiondepth = 0;

  str1 = "";
  for ( x = 0; x < sectiondepth; x++ ) str1 += "\t";

  str1 += sectioname;
  str1 += " {";
  fh->putLine( str1.c_str() );
  sectiondepth++;
}

void WConfig::configCloseSection( Datei *fh )
{
  int x;
  std::string str1;

  if ( fh == NULL ) return;

  sectiondepth--;
  if ( ( sectiondepth < 0 ) || ( sectiondepth > 100 ) ) sectiondepth = 0;

  str1 = "";
  for ( x = 0; x < sectiondepth; x++ ) str1 += "\t";

  str1 += "}";
  fh->putLine( str1.c_str() );
}

void WConfig::setShowHeader( int side, bool nv )
{
  if ( ( side < 0 ) || ( side > 1 ) ) return;
  showHeader[side] = nv;
}

bool WConfig::getShowHeader( int side ) const
{
  return showHeader[ ( side == 1 ) ? 1 : 0 ];
}

void WConfig::setLayoutOrders( std::list<layoutID_t> &nl )
{
  std::list<layoutID_t>::iterator it1;
  
  layoutConf.orders.clear();
  for ( it1 = nl.begin(); it1 != nl.end(); it1++ ) {
    layoutConf.orders.push_back( *it1 );
  }
}

std::list<WConfig::layoutID_t> &WConfig::getLayoutOrders()
{
  return layoutConf.orders;
}

void WConfig::setLayoutButtonVert( bool nv )
{
  layoutConf.buttonVert = nv;
}

bool WConfig::getLayoutButtonVert() const
{
  return layoutConf.buttonVert;
}

void WConfig::setLayoutListviewVert( bool nv )
{
  layoutConf.listviewVert = nv;
}

bool WConfig::getLayoutListviewVert() const
{
  return layoutConf.listviewVert;
}

void WConfig::clearLayoutOrders()
{
  layoutConf.orders.clear();
}

void WConfig::layoutAddEntry( layoutID_t nv )
{
  layoutConf.orders.push_back( nv );
}

