/* acontainer.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2004 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: acontainer.h,v 1.3 2004/03/18 06:55:57 ralf Exp $ */

#ifndef ACONTAINER_H
#define ACONTAINER_H

#include "aguixdefs.h"

class AContainer
{
public:
  AContainer( class AWindow *twin, int txelems = 1, int tyelems = 1 );
  virtual ~AContainer();
  AContainer( const AContainer &other );
  AContainer &operator=( const AContainer &other );

  enum { ACONT_NONE = 0,
	 ACONT_MAXW = 1,
	 ACONT_MAXH = 2,
	 ACONT_MINW = 4,
	 ACONT_MINH = 8,
	 ACONT_NORESIZE = 16 };
  class GUIElement *add( class GUIElement *newelement, int tx = 0, int ty = 0, int tautosizeMode = ACONT_NONE );
  AContainer *add( AContainer *newcont, int tx = 0, int ty = 0 );
  class AWindow *add( class AWindow *newwin, int tx = 0, int ty = 0, int tautosizeMode = ACONT_NONE );

  void setParent( AContainer *nv );
  int remove( const AContainer *v );
  virtual int remove( const GUIElement *v );
  int remove( const AWindow *v );

  enum { ACONT_ONLYH = 1, ACONT_ONLYV };
  int resize( int nw, int nh );
  int move( int nx, int ny );
  virtual int rearrange( int vhmode = 0 );

  void setBorderWidth( int nv );
  int getBorderWidth() const;
  void setMinSpace( int nv );
  int getMinSpace() const;
  void setMaxSpace( int nv );
  int getMaxSpace() const;
  void setMinWidth( int nv, int tx = 0, int ty = 0 );
  int getMinWidth( int tx = 0, int ty = 0 ) const;
  void setMaxWidth( int nv, int tx = 0, int ty = 0 );
  int getMaxWidth( int tx = 0, int ty = 0 ) const;
  void setMinHeight( int nv, int tx = 0, int ty = 0 );
  int getMinHeight( int tx = 0, int ty = 0 ) const;
  void setMaxHeight( int nv, int tx = 0, int ty = 0 );
  int getMaxHeight( int tx = 0, int ty = 0 ) const;
  void setWWeight( int nv, int tx = 0, int ty = 0 );
  int getWWeight( int tx = 0, int ty = 0 ) const;
  void setHWeight( int nv, int tx = 0, int ty = 0 );
  int getHWeight( int tx = 0, int ty = 0 ) const;
  int getX() const;
  int getY() const;

  void readLimits();

  int getWidth() const;
  int getHeight() const;
 private:
  class AWindow *win;
  AContainer *parent;
  int xelems, yelems;

  class AContElem {
  public:
    AContElem();
    AContElem( const AContElem &other );
    AContElem &operator=( const AContElem &other );

    class GUIElement *guielem() const;
    AContainer *cont() const;
    class AWindow *win() const;
    void guielem( class GUIElement *newelem );
    void cont( AContainer *newcont );
    void win( class AWindow *newwin );
    int width() const;
    void width( int nv );
    int height() const;
    void height( int nv );
    int minWidth() const;
    void minWidth( int nv );
    int maxWidth() const;
    void maxWidth( int nv );
    int minHeight() const;
    void minHeight( int nv );
    int maxHeight() const;
    void maxHeight( int nv );
    int autosizeMode() const;
    void autosizeMode( int nv );
    int wWeight() const;
    void wWeight( int nv );
    int hWeight() const;
    void hWeight( int nv );

    int noResize() const;
    void noResize( bool nv );
  private:
    class GUIElement *Guielem;
    AContainer *Cont;
    class AWindow *Win;
    int Width, Height;

    int MinWidth, MaxWidth, MinHeight, MaxHeight;
    int AutosizeMode;
    int WWeight, HWeight;
    bool NoResize;
  };

  AContElem *elements;
  int *ergWidths, *ergHeights;

  int width, height, x, y;
  int BorderWidth, MinSpace, MaxSpace;
};

#endif
