/* dndtext.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: dndtext.cc,v 1.7 2004/03/18 06:59:42 ralf Exp $ */

#include "dndtext.h"
#include "aguix.h"
#include "guielement.h"
#include "awindow.h"

DNDText::DNDText( AGUIX *parent, char *ttext, int tfg, int tbg, AGUIXFont *tfont ) : DNDElement( parent )
{
  this->text=dupstring(ttext);
  this->fg=tfg;
  this->bg=tbg;
  this->font=tfont;
  if(tfont!=NULL) {
    dely=-(tfont->getCharHeight());
    delx=-(tfont->getCharWidth()*strlen(ttext));
  } else {
    dely=-(aguix->getCharHeight());
    delx=-(aguix->getCharWidth()*strlen(ttext));
  }
  dely/=2;
  delx/=2;
}

DNDText::~DNDText()
{
  _freesafe(text);
}

void DNDText::redraw()
{
  aguix->ClearWin(win);
  if(font==NULL) {
    aguix->setFG(fg);
    aguix->DrawText(win,text,0,0);
  } else {
    aguix->setFG(font->getGC(),fg);
    aguix->DrawText(win,font,text,0,0);
  }
}

void DNDText::close()
{
  if(win!=0) XDestroyWindow(aguix->getDisplay(),win);
  win=0;
}

void DNDText::create()
{
  int w,h;
  Display *dsp=aguix->getDisplay();
  if(font!=NULL) h=font->getCharHeight();
  else h=aguix->getCharHeight();
  if(font!=NULL) w=font->getCharWidth();
  else w=aguix->getCharWidth();
  w*=strlen(text);
  w+=1;
  aguix->SetWindowBG(win,bg);
  XResizeWindow(dsp,win,w,h);

  int xw,yw,xr,yr;
  Window root,child;
  unsigned int keys_button;
  XQueryPointer(dsp,RootWindow(dsp,aguix->getScreen()),&root,&child,&xr,&yr,&xw,&yw,&keys_button);

  XMoveWindow(dsp,win,delx+xr,dely+yr);

  XMapRaised(dsp,win);
  redraw();
  grabbed=XGrabPointer(aguix->getDisplay(),
                       RootWindow(aguix->getDisplay(),aguix->getScreen()),
		       True,
		       ButtonMotionMask|ButtonReleaseMask|ButtonPressMask,
		       GrabModeAsync,
		       GrabModeAsync,
		       None,
		       None,
		       CurrentTime);
  created = true;
}
