/* guielement.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: guielement.h,v 1.16 2004/03/18 07:01:16 ralf Exp $ */

#ifndef GUIELEMENT_H
#define GUIELEMENT_H

#include "aguixdefs.h"
#include "message.h"

class AGUIX;
class AWindow;

class GUIElement {
public:
  GUIElement(AGUIX *aguix);
  virtual ~GUIElement();
  GUIElement( const GUIElement &other );
  GUIElement &operator=( const GUIElement &other );

  virtual void move(int x,int y);
  virtual void resize(int w,int h);
  virtual void redraw();
  virtual void flush();
  virtual const char *getType() const;
  virtual bool isType(const char *type) const;
  virtual bool handleMessage(XEvent *E,Message *msg);
  virtual void getPos(int*,int*) const;
  virtual void getSize(int*,int*) const;
  virtual int getWidth() const;
  virtual int getHeight() const;
  virtual int getX() const;
  virtual int getY() const;
  void setParent(AWindow *parent);
  virtual void toBack();
  virtual void toFront();
  bool hasWin(Window win) const;
  Window getWindow() const;
  virtual bool isParent(Window) const;
  virtual void paste(unsigned char*);
  virtual void cancelpaste();
  virtual void cancelcut();
  virtual void takeFocus();
  virtual void leaveFocus();
  bool hasFocus() const;
  virtual void hide();
  virtual void show();
  void setAcceptFocus( bool nv );
  bool getAcceptFocus() const;
  bool isVisible() const;
  virtual int handleMessageLock( XEvent *E, Message *msg );
protected:
  int x,y;
  int w,h;
  AGUIX *aguix;
  AWindow *parent;
  Window win;
  static const char *type;
  bool focus;

  virtual void doCreateStuff();
  virtual void doDestroyStuff();
  bool canHandleFocus;  // indicates that this element can handle a focus
  bool acceptFocus;  // this indicates that this element actual want to handle a focus
  void registerFocusElement();
  void unregisterFocusElement();
  bool visible;
};

#endif

