/* kartei.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2004 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: kartei.cc,v 1.2 2004/07/19 16:37:27 ralf Exp $ */

#include "kartei.h"
#include "acontainer.h"
#include "karteibutton.h"

Kartei::Kartei( AGUIX *parent ) : AWindow( parent )
{
  cont = new AContainer( this, 1, 2 );
  cont->setMinSpace( 0 );
  cont->setMaxSpace( 0 );
  cont->setBorderWidth( 1 );
  setContainer( cont, true );
  optionkb = NULL;
  curOption = 0;
}

Kartei::~Kartei()
{
  setContainer( NULL );
  delete cont;
}

int Kartei::create( AWindow *parent,
		    int x,
		    int y,
		    int width,
		    int height,
		    int bg,
		    const char *title )
{
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  int erg;

  erg = AWindow::create( parent, x, y, width, height, bg, title );
  if ( erg != 0 ) return erg;

  optionkb = new KarteiButton( aguix, 0, 0, 100, 1, 0, 0 );
  cont->add( optionkb, 0, 0, cincw );
  optionkb->setOptionChangeCallback( optionChangeCallback, this );
  return 0;
}

void Kartei::setOption( AWindow *win, unsigned int option, const char *optionname )
{
  if ( win == NULL ) return;
  if ( optionname == NULL ) return;
  
  if ( option > options.size() ) option = options.size();
  if ( option == options.size() ) options.resize( option + 1 );
  options[option] = win;

  while ( optionkb->setOption( option, optionname ) < 0 ) optionkb->addOption( "" );
  optionkb->resize( optionkb->getMaxSize(), optionkb->getHeight() );
  cont->readLimits();
  if ( curOption == option ) showCurOption();
  redraw();
}

void Kartei::showCurOption()
{
  AWindow *win, *twin;
  unsigned int i;

  if ( curOption >= options.size() ) return;
  win = options[curOption];
  if ( subawins->getIndex( win ) < 0 ) return;
  
  for ( i = 0; i < options.size(); i++ ) {
    if ( i == curOption ) continue;
    twin = options[i];
    if ( subawins->getIndex( twin ) < 0 ) continue;
    twin->hide();
  }
  win->show();
  cont->add( win, 0, 1 );
  cont->rearrange();
}

void Kartei::maximize()
{
  AWindow *twin;
  unsigned int i;
  int tw = 0, th = 0;

  for ( i = 0; i < options.size(); i++ ) {
    twin = options[i];
    if ( subawins->getIndex( twin ) < 0 ) continue;
    twin->contMaximize();
    if ( twin->getWidth() > tw ) tw = twin->getWidth();
    if ( twin->getHeight() > th ) th = twin->getHeight();
  }
  cont->setMinWidth( tw, 0, 1 );
  cont->setMinHeight( th, 0, 1 );
}

void Kartei::optionChangeCallback( Kartei *k1, unsigned int option )
{
  if ( k1 == NULL ) return;
  k1->optionChange( option );
}

void Kartei::optionChange( unsigned int option )
{
  if ( curOption != option ) {
    curOption = option;
    if ( curOption >= options.size() ) curOption = 0;
    showCurOption();
    boxRedraw();
  }
}

void Kartei::boxRedraw()
{
  int ty;

  if ( optionkb != NULL ) ty = optionkb->getY() + optionkb->getHeight();
  else ty = 0;
  aguix->setFG( 0, 2 );
  aguix->DrawLine( win, 0, 0, ty, 0, h - 1 );
  aguix->setFG( 0, 1 );
  aguix->DrawLine( win, 0, 0, h - 1, w - 1, h - 1 );
  aguix->DrawLine( win, 0, w - 1, h - 1, w - 1, ty - 1 );
}

bool Kartei::handleMessage(XEvent *E,Message *msg)
{
  if ( ( msg->type == Expose ) &&
       ( msg->window == win ) ) {
    boxRedraw();
  }

  return AWindow::handleMessage( E, msg );
}

void Kartei::close()
{
  AWindow::close();
  optionkb = NULL;
  options.clear();
  curOption = 0;
}
