/* karteicyclebutton.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2004 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: karteibutton.cc,v 1.1 2004/06/13 19:46:27 ralf Exp $ */

#include "karteibutton.h"
#include "awindow.h"
#include "guielement.h"
#include "kartei.h"

const char *KarteiButton::type="KarteiButton";

KarteiButton::~KarteiButton()
{
}

KarteiButton::KarteiButton( AGUIX *taguix ) : CycleButton( taguix )
{
  optionChangeCallback = NULL;
  k2 = NULL;
  focusPos = 0;
}

KarteiButton::KarteiButton( AGUIX *taguix,
			    int tx,
			    int ty,
			    int width,
			    int tfg,
			    int tbg,
			    int tdata ) : CycleButton( taguix,
						       tx,
						       ty,
						       width,
						       tfg,
						       tbg,
						       tdata )
{
  optionChangeCallback = NULL;
  k2 = NULL;
  focusPos = 0;
}

KarteiButton::KarteiButton( AGUIX *taguix,
			    int tx,
			    int ty,
			    int width,
			    int height,
			    int tfg,
			    int tbg,
			    int tdata ) : CycleButton( taguix,
						       tx,
						       ty,
						       width,
						       height,
						       tfg,
						       tbg,
						       tdata )
{
  optionChangeCallback = NULL;
  k2 = NULL;
  focusPos = 0;
}

void KarteiButton::redraw()
{
  GC usegc;
  char *tstr;
  int ch,cw;
  int basex, basey, midy, delx, i, dx, dx2, sx, sy, ex, ey;
  int act_x1 = -1, act_x2 = -1;

  if ( parent == NULL ) return;
  if ( win == 0 ) return;
  if ( bg != lastbg ) {
    aguix->SetWindowBG( win, bg );
    lastbg = bg;
  }
  aguix->ClearWin( win );
  if ( font == NULL ) usegc = 0; else usegc = font->getGC();

  basex = 0;
  basey = h - 1;
  midy = h / 2 - 1;
  delx = h / 4;

  if ( font == NULL ) {
    ch = aguix->getCharHeight();
    cw = aguix->getCharWidth();
  } else {
    ch = font->getCharHeight();
    cw = font->getCharWidth();
  }

  for ( i = 0; i < options->size(); i++ ) {
    sx = basex;
    dx = 2 * delx;
    if ( ( i != 0 ) && ( i != act_opt ) ) {
      sx += delx + 1;
      dx = delx - 1;
    }

    if ( ( i == 0 ) ||
	 ( i == act_opt ) ) {
      sy = basey;
    } else {
      sy = midy;
    }
    aguix->setFG( usegc, 2 );
    aguix->DrawLine( win, usegc,
		     sx, sy,
		     sx + dx, 0 );
    tstr = dupstring((char*)options->getElementAt( i ) );

    dx2 = strlen( tstr ) * cw;
    dx2 += 2 * delx;
    aguix->DrawLine( win, usegc,
		     sx + dx, 0,
		     sx + dx + dx2, 0 );
    if ( ( i + 1 ) == act_opt ) {
      ex = sx + dx + dx2 + delx;
      ey = midy;
    } else {
      ex = sx + dx + dx2 + 2 * delx;
      ey = basey;
    }
    aguix->setFG( usegc, 1 );
    aguix->DrawLine( win, usegc,
		     sx + dx + dx2, 0,
		     ex, ey );
    
    if ( i == act_opt ) {
      act_x1 = basex;
      act_x2 = ex;
    }

    if ( font == NULL ) {
      aguix->DrawText( win, tstr, sx + dx + delx, 2 );
    } else {
      aguix->DrawText( win, font, tstr, sx + dx + delx, 1 );
    }
    _freesafe( tstr );

    if ( ( getAcceptFocus() == true ) &&
	 ( hasFocus() == true ) &&
	 ( focusPos == i ) ) {
      aguix->setDottedFG( 1 );
      aguix->DrawDottedRectangle( win, sx + dx + delx - 2, 1, dx2 - 2 * delx + 4, 1 + ch + 1 );
    }

    basex = sx + dx + dx2;
  }
  if ( ( act_x1 >= 0 ) && ( act_x2 > act_x1 ) ) {
    aguix->setFG( usegc, 2 );
    aguix->DrawLine( win, usegc, 0, basey, act_x1, basey );
    aguix->DrawLine( win, usegc, act_x2 + 1, basey, w, basey );
  }

  aguix->Flush();
}

void KarteiButton::flush()
{
}

bool KarteiButton::handleMessage(XEvent *E,Message *msg)
{
  bool returnvalue;
  AGMessage *agmsg;
  
  if ( parent == NULL ) return false;

  returnvalue = false;

  if ( ( msg->type == ButtonPress ) ||
       ( msg->type == ButtonRelease ) ) {
    if ( msg->window == win ) {
      int mx, my, opt;

      takeFocus();

      mx = msg->mousex;
      my = msg->mousey;
      opt = findClickedOption( mx );
      if(msg->type==ButtonPress) {
	if ( opt >= 0 ) {
	  focusPos = opt;
	  //redraw();
	}
	setState( 1 );
	instate = 1;
	returnvalue = true;
      } else {
	if ( ( state != 0 ) &&
	     ( instate != 0 ) &&
	     ( opt >= 0 ) ) {
	  if ( options->size() > 0 ) {
	    if ( msg->button == Button1 ) {
	      act_opt = opt;
	      if ( act_opt >= options->size() ) act_opt = 0;
	    }
	  }
	  
	  agmsg = AGUIX_allocAGMessage();
	  agmsg->type=AG_KARTEIBUTTONCLICKED;
	  agmsg->karteibutton.karteibutton=this;
	  agmsg->karteibutton.option=act_opt;
	  aguix->putAGMsg(agmsg);

	  if ( ( optionChangeCallback != NULL ) && ( act_opt >= 0 ) ) {
	    optionChangeCallback( k2, (unsigned int)act_opt );
	  }
	}
	if ( instate != 0 ) {
	  setState( 0 );
	  instate = 0;
	  returnvalue = true;
	}
      }
    }
  } else if ( msg->type == EnterNotify ) {
    // alles hier und alles mit instate wird benutzt, damit Button sich anpat, wenn
    // Mauszeiger im Button oder auerhalb des Buttons ist
    if ( msg->window == win ) {
      if ( instate != 0 ) {
	if ( state != instate ) {
	  setState( instate );
	}
      }
    }
  } else if ( msg->type == LeaveNotify ) {
    // alles hier und alles mit instate wird benutzt, damit Button sich anpat, wenn
    // Mauszeiger im Button oder auerhalb des Buttons ist
    if ( msg->window == win ) {
      if ( instate != 0 ) {
	setState( 0 );
      }
    }
  } else if ( msg->type == Expose ) {
    if ( msg->window == win ) {
      redraw();
    }
  } else if ( msg->type == KeyPress ) {
    if ( ( getAcceptFocus() == true ) && ( hasFocus() == true ) ) {
      if ( options->size() > 0 ) {
	if ( isVisible() == true ) {
	  if ( parent->isTopParent( msg->window ) == true ) {
	    switch ( msg->key ) {
	    case XK_space:
	      if ( act_opt != focusPos ) {
		act_opt = focusPos;
		if ( act_opt >= options->size() ) act_opt = 0;
		
		agmsg = AGUIX_allocAGMessage();
		agmsg->type=AG_KARTEIBUTTONCLICKED;
		agmsg->karteibutton.karteibutton=this;
		agmsg->karteibutton.option=act_opt;
		aguix->putAGMsg(agmsg);

                if ( ( optionChangeCallback != NULL ) && ( act_opt >= 0 ) ) {
                  optionChangeCallback( k2, (unsigned int)act_opt );
                }
		if ( instate != 0 ) {
		  setState( 0 );
		  instate = 0;
		  returnvalue = true;
		} else redraw();  // setState will make this so just in the else-case
	      }
	      break;
	    case XK_Left:
	      if ( focusPos > 0 ) {
		focusPos--;
		redraw();
	      }
	      break;
	    case XK_Right:
	      if ( ( focusPos + 1 ) < options->size() ) {
		focusPos++;
		redraw();
	      }
	      break;
	    }
	  }
	}
      }
    }
  }
  if ( returnvalue == true ) {
    // jetzt noch die Message mit den Werten fllen
    msg->gadget = this;
    msg->gadgettype = BUTTON_GADGET;
  }
//  return returnvalue;
  return false;  // we return false because an other element can take use of
                 // this message (f.e. StringGagdet for deactivating)
}

const char *KarteiButton::getType() const
{
  return type;
}

bool KarteiButton::isType(const char *qtype) const
{
  if(strcmp(type,qtype)==0) return true;
  return false;
}

int KarteiButton::getMaxSize() const
{
  char *tstr;
  int cw;
  int delx, i, dx2, tw;

  delx = h / 4;
  tw = 2 * delx;
  
  if ( font == NULL ) {
    cw = aguix->getCharWidth();
  } else {
    cw = font->getCharWidth();
  }
  for ( i = 0; i < options->size(); i++ ) {
    tstr = (char*)options->getElementAt( i );
    dx2 = strlen( tstr ) * cw;
    dx2 += 2 * delx;
    
    tw += dx2 + 2 * delx;
  }
  return tw + 1;
}

void KarteiButton::setOptionChangeCallback( void (*optionChangeCallback_arg)( class Kartei *k1,
									      unsigned int option ),
				            Kartei *k2_arg )
{
  optionChangeCallback = optionChangeCallback_arg;
  k2 = k2_arg;
}

int KarteiButton::findClickedOption( int mx )
{
  char *tstr;
  int cw;
  int delx, i, dx2, tw, basex;
  int opt = -1;

  delx = h / 4;
  basex = 0;

  if ( font == NULL ) {
    cw = aguix->getCharWidth();
  } else {
    cw = font->getCharWidth();
  }
  for ( i = 0; i < options->size(); i++ ) {
    tstr = (char*)options->getElementAt( i );
    dx2 = strlen( tstr ) * cw;
    dx2 += 2 * delx;
    
    tw = dx2 + 2 * delx;
    if ( ( i == 0 ) || ( i == options->size() - 1 ) ) {
      tw += delx;
    }

    if ( ( mx >= basex ) &&
	 ( mx < ( basex + tw ) ) ) {
      opt = i;
      break;
    }

    basex += tw;
  }
  return opt;
}
