// DBus-template.hh --- DBUS template
//
// Copyright (C) 2007, 2008 Rob Caelers <robc@krandor.nl>
// All rights reserved.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// $Id: DBus.hh 1404 2008-01-07 20:48:30Z rcaelers $
//

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string>
#include <list>
#include <map>
#include <deque>

#include "DBus.hh"
#include "DBusBinding.hh"
#include "DBusException.hh"
#include "DBusGUI.hh"

using namespace std;




#include "Menus.hh"

class org_workrave_ControlInterface_Stub : public DBusBindingBase, public org_workrave_ControlInterface
{
private:
  typedef DBusMessage * (org_workrave_ControlInterface_Stub::*DBusMethod)(void *object, DBusMessage *message);

  virtual DBusMessage *call(int method_num, void *object, DBusMessage *message);
   
  virtual DBusIntrospect *get_method_introspect()
  {
    return method_introspect;
  }

  virtual DBusIntrospect *get_signal_introspect()
  {
    return signal_introspect;
  }

public:
  org_workrave_ControlInterface_Stub(DBus *dbus);
  ~org_workrave_ControlInterface_Stub();
  

  
private:
  DBusMessage *OpenMain(void *object, DBusMessage *message);
  DBusMessage *Preferences(void *object, DBusMessage *message);
  DBusMessage *NetworkConnect(void *object, DBusMessage *message);
  DBusMessage *NetworkLog(void *object, DBusMessage *message);
  DBusMessage *NetworkReconnect(void *object, DBusMessage *message);
  DBusMessage *NetworkDisconnect(void *object, DBusMessage *message);
  DBusMessage *Statistics(void *object, DBusMessage *message);
  DBusMessage *Exercises(void *object, DBusMessage *message);
  DBusMessage *RestBreak(void *object, DBusMessage *message);
  DBusMessage *Quit(void *object, DBusMessage *message);
  DBusMessage *About(void *object, DBusMessage *message);




  
  static DBusMethod method_table[];
  static DBusIntrospect method_introspect[];
  static DBusIntrospect signal_introspect[];
};


org_workrave_ControlInterface *org_workrave_ControlInterface::instance(const DBus *dbus)
{
  org_workrave_ControlInterface_Stub *iface = NULL;
  DBusBindingBase *binding = dbus->find_binding("org.workrave.ControlInterface");
  
  if (binding != NULL)
    {
      iface = dynamic_cast<org_workrave_ControlInterface_Stub *>(binding);
    }

  return iface;
}

org_workrave_ControlInterface_Stub::org_workrave_ControlInterface_Stub(DBus *dbus)
  : DBusBindingBase(dbus)
{
}


org_workrave_ControlInterface_Stub::~org_workrave_ControlInterface_Stub()
{
}

DBusMessage *
org_workrave_ControlInterface_Stub::call(int method_num, void *object, DBusMessage *message)
{
  DBusMessage *ret = NULL;
  
  if (method_num >=0 && method_num < 11 )
    {
      DBusMethod m = method_table[method_num];
      if (m != NULL)
        {
          ret = (this->*m)(object, message);
        }
    }
  
  return ret;
}
 






DBusMessage *
org_workrave_ControlInterface_Stub::OpenMain(void *object, DBusMessage *message)
{
  DBusMessage *reply = NULL;

  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  try
    {
      Menus *dbus_object = (Menus *) object;
      
      
      ok = dbus_message_iter_init(message, &reader);
        

      dbus_object->on_menu_open_main_window(       );
                                                              
      reply = dbus_message_new_method_return(message);
      if (reply == NULL)
        {
          throw DBusSystemException("Internal error");
        }
                                                              
      dbus_message_iter_init_append(reply, &writer);
      
  }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      throw;
    }
                                                          
  return reply;

}

  

DBusMessage *
org_workrave_ControlInterface_Stub::Preferences(void *object, DBusMessage *message)
{
  DBusMessage *reply = NULL;

  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  try
    {
      Menus *dbus_object = (Menus *) object;
      
      
      ok = dbus_message_iter_init(message, &reader);
        

      dbus_object->on_menu_preferences(       );
                                                              
      reply = dbus_message_new_method_return(message);
      if (reply == NULL)
        {
          throw DBusSystemException("Internal error");
        }
                                                              
      dbus_message_iter_init_append(reply, &writer);
      
  }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      throw;
    }
                                                          
  return reply;

}

  

DBusMessage *
org_workrave_ControlInterface_Stub::NetworkConnect(void *object, DBusMessage *message)
{
  DBusMessage *reply = NULL;

  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  try
    {
      Menus *dbus_object = (Menus *) object;
      
      
      ok = dbus_message_iter_init(message, &reader);
        

      dbus_object->on_menu_network_join(       );
                                                              
      reply = dbus_message_new_method_return(message);
      if (reply == NULL)
        {
          throw DBusSystemException("Internal error");
        }
                                                              
      dbus_message_iter_init_append(reply, &writer);
      
  }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      throw;
    }
                                                          
  return reply;

}

  

DBusMessage *
org_workrave_ControlInterface_Stub::NetworkLog(void *object, DBusMessage *message)
{
  DBusMessage *reply = NULL;

  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  try
    {
      Menus *dbus_object = (Menus *) object;
      
      bool show;
      
      ok = dbus_message_iter_init(message, &reader);
      if (!ok)
        {
          throw DBusSystemException("No parameters");
        }
        
      get_bool(&reader, &show);

      dbus_object->on_menu_network_log(        show      );
                                                              
      reply = dbus_message_new_method_return(message);
      if (reply == NULL)
        {
          throw DBusSystemException("Internal error");
        }
                                                              
      dbus_message_iter_init_append(reply, &writer);
      
  }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      throw;
    }
                                                          
  return reply;

}

  

DBusMessage *
org_workrave_ControlInterface_Stub::NetworkReconnect(void *object, DBusMessage *message)
{
  DBusMessage *reply = NULL;

  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  try
    {
      Menus *dbus_object = (Menus *) object;
      
      
      ok = dbus_message_iter_init(message, &reader);
        

      dbus_object->on_menu_network_reconnect(       );
                                                              
      reply = dbus_message_new_method_return(message);
      if (reply == NULL)
        {
          throw DBusSystemException("Internal error");
        }
                                                              
      dbus_message_iter_init_append(reply, &writer);
      
  }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      throw;
    }
                                                          
  return reply;

}

  

DBusMessage *
org_workrave_ControlInterface_Stub::NetworkDisconnect(void *object, DBusMessage *message)
{
  DBusMessage *reply = NULL;

  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  try
    {
      Menus *dbus_object = (Menus *) object;
      
      
      ok = dbus_message_iter_init(message, &reader);
        

      dbus_object->on_menu_network_leave(       );
                                                              
      reply = dbus_message_new_method_return(message);
      if (reply == NULL)
        {
          throw DBusSystemException("Internal error");
        }
                                                              
      dbus_message_iter_init_append(reply, &writer);
      
  }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      throw;
    }
                                                          
  return reply;

}

  

DBusMessage *
org_workrave_ControlInterface_Stub::Statistics(void *object, DBusMessage *message)
{
  DBusMessage *reply = NULL;

  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  try
    {
      Menus *dbus_object = (Menus *) object;
      
      
      ok = dbus_message_iter_init(message, &reader);
        

      dbus_object->on_menu_statistics(       );
                                                              
      reply = dbus_message_new_method_return(message);
      if (reply == NULL)
        {
          throw DBusSystemException("Internal error");
        }
                                                              
      dbus_message_iter_init_append(reply, &writer);
      
  }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      throw;
    }
                                                          
  return reply;

}

  

DBusMessage *
org_workrave_ControlInterface_Stub::Exercises(void *object, DBusMessage *message)
{
  DBusMessage *reply = NULL;

#if defined(HAVE_EXERCISES)
  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  try
    {
      Menus *dbus_object = (Menus *) object;
      
      
      ok = dbus_message_iter_init(message, &reader);
        

      dbus_object->on_menu_exercises(       );
                                                              
      reply = dbus_message_new_method_return(message);
      if (reply == NULL)
        {
          throw DBusSystemException("Internal error");
        }
                                                              
      dbus_message_iter_init_append(reply, &writer);
      
  }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      throw;
    }
                                                          
#else
 (void) object;

 reply = dbus_message_new_error(message,
                                "org.workrave.NotImplemented",
                                "This method is unavailable in current configuration");
#endif
  return reply;

}

  

DBusMessage *
org_workrave_ControlInterface_Stub::RestBreak(void *object, DBusMessage *message)
{
  DBusMessage *reply = NULL;

  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  try
    {
      Menus *dbus_object = (Menus *) object;
      
      
      ok = dbus_message_iter_init(message, &reader);
        

      dbus_object->on_menu_restbreak_now(       );
                                                              
      reply = dbus_message_new_method_return(message);
      if (reply == NULL)
        {
          throw DBusSystemException("Internal error");
        }
                                                              
      dbus_message_iter_init_append(reply, &writer);
      
  }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      throw;
    }
                                                          
  return reply;

}

  

DBusMessage *
org_workrave_ControlInterface_Stub::Quit(void *object, DBusMessage *message)
{
  DBusMessage *reply = NULL;

  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  try
    {
      Menus *dbus_object = (Menus *) object;
      
      
      ok = dbus_message_iter_init(message, &reader);
        

      dbus_object->on_menu_quit(       );
                                                              
      reply = dbus_message_new_method_return(message);
      if (reply == NULL)
        {
          throw DBusSystemException("Internal error");
        }
                                                              
      dbus_message_iter_init_append(reply, &writer);
      
  }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      throw;
    }
                                                          
  return reply;

}

  

DBusMessage *
org_workrave_ControlInterface_Stub::About(void *object, DBusMessage *message)
{
  DBusMessage *reply = NULL;

  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  try
    {
      Menus *dbus_object = (Menus *) object;
      
      
      ok = dbus_message_iter_init(message, &reader);
        

      dbus_object->on_menu_about(       );
                                                              
      reply = dbus_message_new_method_return(message);
      if (reply == NULL)
        {
          throw DBusSystemException("Internal error");
        }
                                                              
      dbus_message_iter_init_append(reply, &writer);
      
  }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      throw;
    }
                                                          
  return reply;

}

  

  
org_workrave_ControlInterface_Stub::DBusMethod org_workrave_ControlInterface_Stub::method_table[] = {
  &org_workrave_ControlInterface_Stub::OpenMain,
  &org_workrave_ControlInterface_Stub::Preferences,
  &org_workrave_ControlInterface_Stub::NetworkConnect,
  &org_workrave_ControlInterface_Stub::NetworkLog,
  &org_workrave_ControlInterface_Stub::NetworkReconnect,
  &org_workrave_ControlInterface_Stub::NetworkDisconnect,
  &org_workrave_ControlInterface_Stub::Statistics,
  &org_workrave_ControlInterface_Stub::Exercises,
  &org_workrave_ControlInterface_Stub::RestBreak,
  &org_workrave_ControlInterface_Stub::Quit,
  &org_workrave_ControlInterface_Stub::About,
};

DBusIntrospect org_workrave_ControlInterface_Stub::method_introspect[] = {
  { "OpenMain",
    ""
  },
  { "Preferences",
    ""
  },
  { "NetworkConnect",
    ""
  },
  { "NetworkLog",
    "in\0b\0show\0"
  },
  { "NetworkReconnect",
    ""
  },
  { "NetworkDisconnect",
    ""
  },
  { "Statistics",
    ""
  },
  { "Exercises",
    ""
  },
  { "RestBreak",
    ""
  },
  { "Quit",
    ""
  },
  { "About",
    ""
  },
  { NULL,
    NULL
  }
};
  
DBusIntrospect org_workrave_ControlInterface_Stub::signal_introspect[] = {
  { NULL,
    NULL
  }
};

 

#if defined(HAVE_GNOME)


#include "gdk/gdkcolor.h"
#include "GnomeAppletWindow.hh"
#include "Orientation.hh"

class org_workrave_GnomeAppletSupportInterface_Stub : public DBusBindingBase, public org_workrave_GnomeAppletSupportInterface
{
private:
  typedef DBusMessage * (org_workrave_GnomeAppletSupportInterface_Stub::*DBusMethod)(void *object, DBusMessage *message);

  virtual DBusMessage *call(int method_num, void *object, DBusMessage *message);
   
  virtual DBusIntrospect *get_method_introspect()
  {
    return method_introspect;
  }

  virtual DBusIntrospect *get_signal_introspect()
  {
    return signal_introspect;
  }

public:
  org_workrave_GnomeAppletSupportInterface_Stub(DBus *dbus);
  ~org_workrave_GnomeAppletSupportInterface_Stub();
  

  
private:
  DBusMessage *SetOrientation(void *object, DBusMessage *message);
  DBusMessage *SetSize(void *object, DBusMessage *message);
  DBusMessage *SetBackground(void *object, DBusMessage *message);
  DBusMessage *ButtonClicked(void *object, DBusMessage *message);
  DBusMessage *EmbedRequest(void *object, DBusMessage *message);

  void get_Orientation(DBusMessageIter *reader, Orientation *result);
  void put_Orientation(DBusMessageIter *writer, const Orientation *result);

  void get_Color(DBusMessageIter *reader, GdkColor *result);
  void put_Color(DBusMessageIter *writer, const GdkColor *result);


  
  static DBusMethod method_table[];
  static DBusIntrospect method_introspect[];
  static DBusIntrospect signal_introspect[];
};


org_workrave_GnomeAppletSupportInterface *org_workrave_GnomeAppletSupportInterface::instance(const DBus *dbus)
{
  org_workrave_GnomeAppletSupportInterface_Stub *iface = NULL;
  DBusBindingBase *binding = dbus->find_binding("org.workrave.GnomeAppletSupportInterface");
  
  if (binding != NULL)
    {
      iface = dynamic_cast<org_workrave_GnomeAppletSupportInterface_Stub *>(binding);
    }

  return iface;
}

org_workrave_GnomeAppletSupportInterface_Stub::org_workrave_GnomeAppletSupportInterface_Stub(DBus *dbus)
  : DBusBindingBase(dbus)
{
}


org_workrave_GnomeAppletSupportInterface_Stub::~org_workrave_GnomeAppletSupportInterface_Stub()
{
}

DBusMessage *
org_workrave_GnomeAppletSupportInterface_Stub::call(int method_num, void *object, DBusMessage *message)
{
  DBusMessage *ret = NULL;
  
  if (method_num >=0 && method_num < 5 )
    {
      DBusMethod m = method_table[method_num];
      if (m != NULL)
        {
          ret = (this->*m)(object, message);
        }
    }
  
  return ret;
}
 

void
org_workrave_GnomeAppletSupportInterface_Stub::get_Orientation(DBusMessageIter *reader, Orientation *result)
{
  std::string value;
	int argtype = dbus_message_iter_get_arg_type(reader);

  if (argtype != DBUS_TYPE_STRING)
		throw DBusTypeException("Type mismatch. Excepted string");

  get_string(reader, &value);
  
  if ("up" == value)
    {
      *result = ORIENTATION_UP;
    }
  else if ("right" == value)
    {
      *result = ORIENTATION_RIGHT;
    }
  else if ("down" == value)
    {
      *result = ORIENTATION_DOWN;
    }
  else if ("left" == value)
    {
      *result = ORIENTATION_LEFT;
    }
  else
    {
      throw DBusTypeException("Illegal enum value");
    }
}

void
org_workrave_GnomeAppletSupportInterface_Stub::put_Orientation(DBusMessageIter *writer, const Orientation *result)
{
  string value;
  switch (*result)
    {
    case ORIENTATION_UP:
      value = "up";
      break;
    case ORIENTATION_RIGHT:
      value = "right";
      break;
    case ORIENTATION_DOWN:
      value = "down";
      break;
    case ORIENTATION_LEFT:
      value = "left";
      break;
    default:
      throw DBusTypeException("Illegal enum value");
    }
        	
  put_string(writer, &value);
}



void
org_workrave_GnomeAppletSupportInterface_Stub::get_Color(DBusMessageIter *reader, GdkColor *result)
{
  DBusMessageIter it;
  dbus_message_iter_recurse(reader, &it);

  
    get_uint32(&it, (guint32 *) &(result->pixel));
    get_uint32(&it, (guint32 *) &(result->red));
    get_uint32(&it, (guint32 *) &(result->green));
    get_uint32(&it, (guint32 *) &(result->blue));

    
  dbus_message_iter_next(reader);
}

void
org_workrave_GnomeAppletSupportInterface_Stub::put_Color(DBusMessageIter *writer, const GdkColor *result)
{
  DBusMessageIter it;
  dbus_bool_t ok;
  
  ok = dbus_message_iter_open_container(writer, DBUS_TYPE_STRUCT, NULL, &it);
  if (!ok)
    {
      throw DBusSystemException("Internal error");
    }

  put_uint32(&it, (guint32 *) &(result->pixel));
  put_uint32(&it, (guint32 *) &(result->red));
  put_uint32(&it, (guint32 *) &(result->green));
  put_uint32(&it, (guint32 *) &(result->blue));

  ok = dbus_message_iter_close_container(writer, &it);
  if (!ok)
    {
      throw DBusSystemException("Internal error");
    }
}






DBusMessage *
org_workrave_GnomeAppletSupportInterface_Stub::SetOrientation(void *object, DBusMessage *message)
{
  DBusMessage *reply = NULL;

  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  try
    {
      GnomeAppletWindow *dbus_object = (GnomeAppletWindow *) object;
      
      Orientation orientation;
      
      ok = dbus_message_iter_init(message, &reader);
      if (!ok)
        {
          throw DBusSystemException("No parameters");
        }
        
      get_Orientation(&reader, &orientation);

      dbus_object->set_applet_orientation(        orientation      );
                                                              
      reply = dbus_message_new_method_return(message);
      if (reply == NULL)
        {
          throw DBusSystemException("Internal error");
        }
                                                              
      dbus_message_iter_init_append(reply, &writer);
      
  }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      throw;
    }
                                                          
  return reply;

}

  

DBusMessage *
org_workrave_GnomeAppletSupportInterface_Stub::SetSize(void *object, DBusMessage *message)
{
  DBusMessage *reply = NULL;

  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  try
    {
      GnomeAppletWindow *dbus_object = (GnomeAppletWindow *) object;
      
      guint32 size;
      
      ok = dbus_message_iter_init(message, &reader);
      if (!ok)
        {
          throw DBusSystemException("No parameters");
        }
        
      get_uint32(&reader, &size);

      dbus_object->set_applet_size(        size      );
                                                              
      reply = dbus_message_new_method_return(message);
      if (reply == NULL)
        {
          throw DBusSystemException("Internal error");
        }
                                                              
      dbus_message_iter_init_append(reply, &writer);
      
  }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      throw;
    }
                                                          
  return reply;

}

  

DBusMessage *
org_workrave_GnomeAppletSupportInterface_Stub::SetBackground(void *object, DBusMessage *message)
{
  DBusMessage *reply = NULL;

  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  try
    {
      GnomeAppletWindow *dbus_object = (GnomeAppletWindow *) object;
      
      guint32 type;
      GdkColor color;
      guint32 xid;
      
      ok = dbus_message_iter_init(message, &reader);
      if (!ok)
        {
          throw DBusSystemException("No parameters");
        }
        
      get_uint32(&reader, &type);
      get_Color(&reader, &color);
      get_uint32(&reader, &xid);

      dbus_object->set_applet_background(        type      , color      , xid      );
                                                              
      reply = dbus_message_new_method_return(message);
      if (reply == NULL)
        {
          throw DBusSystemException("Internal error");
        }
                                                              
      dbus_message_iter_init_append(reply, &writer);
      
  }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      throw;
    }
                                                          
  return reply;

}

  

DBusMessage *
org_workrave_GnomeAppletSupportInterface_Stub::ButtonClicked(void *object, DBusMessage *message)
{
  DBusMessage *reply = NULL;

  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  try
    {
      GnomeAppletWindow *dbus_object = (GnomeAppletWindow *) object;
      
      guint32 button;
      
      ok = dbus_message_iter_init(message, &reader);
      if (!ok)
        {
          throw DBusSystemException("No parameters");
        }
        
      get_uint32(&reader, &button);

      dbus_object->button_clicked(        button      );
                                                              
      reply = dbus_message_new_method_return(message);
      if (reply == NULL)
        {
          throw DBusSystemException("Internal error");
        }
                                                              
      dbus_message_iter_init_append(reply, &writer);
      
  }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      throw;
    }
                                                          
  return reply;

}

  

DBusMessage *
org_workrave_GnomeAppletSupportInterface_Stub::EmbedRequest(void *object, DBusMessage *message)
{
  DBusMessage *reply = NULL;

  DBusMessageIter reader;
  DBusMessageIter writer;
  dbus_bool_t ok;

  try
    {
      GnomeAppletWindow *dbus_object = (GnomeAppletWindow *) object;
      
      
      ok = dbus_message_iter_init(message, &reader);
        

      dbus_object->fire_gnome_applet(       );
                                                              
      reply = dbus_message_new_method_return(message);
      if (reply == NULL)
        {
          throw DBusSystemException("Internal error");
        }
                                                              
      dbus_message_iter_init_append(reply, &writer);
      
  }
  catch (DBusException)
    {
      if (reply != NULL)
        {
          dbus_message_unref(reply);
        }

      throw;
    }
                                                          
  return reply;

}

  

  
org_workrave_GnomeAppletSupportInterface_Stub::DBusMethod org_workrave_GnomeAppletSupportInterface_Stub::method_table[] = {
  &org_workrave_GnomeAppletSupportInterface_Stub::SetOrientation,
  &org_workrave_GnomeAppletSupportInterface_Stub::SetSize,
  &org_workrave_GnomeAppletSupportInterface_Stub::SetBackground,
  &org_workrave_GnomeAppletSupportInterface_Stub::ButtonClicked,
  &org_workrave_GnomeAppletSupportInterface_Stub::EmbedRequest,
};

DBusIntrospect org_workrave_GnomeAppletSupportInterface_Stub::method_introspect[] = {
  { "SetOrientation",
    "in\0s\0orientation\0"
  },
  { "SetSize",
    "in\0u\0size\0"
  },
  { "SetBackground",
    "in\0u\0type\0in\0(uuuu)\0color\0in\0u\0xid\0"
  },
  { "ButtonClicked",
    "in\0u\0button\0"
  },
  { "EmbedRequest",
    ""
  },
  { NULL,
    NULL
  }
};
  
DBusIntrospect org_workrave_GnomeAppletSupportInterface_Stub::signal_introspect[] = {
  { NULL,
    NULL
  }
};

 #endif // defined(HAVE_GNOME)
 

void init_DBusGUI(DBus *dbus)
{
  dbus->register_binding("org.workrave.ControlInterface", new org_workrave_ControlInterface_Stub(dbus));
#if defined(HAVE_GNOME)
  dbus->register_binding("org.workrave.GnomeAppletSupportInterface", new org_workrave_GnomeAppletSupportInterface_Stub(dbus));
#endif // defined(HAVE_GNOME)
}
