// $Id: HFEOffset.cpp,v 1.5 2003/02/27 23:43:40 zongo Exp $

#include "HFEOffset.h"
#include "HeightFieldCommand.h"


// ========================================================================
// ========================================================================
// ========================================================================

/// Create a command with a correct state.
Command* 
HFEOffset::CreateCommand()
{
    if (!m_State) return 0;

    const unsigned int size = m_World->m_SizeX * m_World->m_SizeZ;
    HeightFieldCommand* command = new HFEHCommand(m_World, "Offset change");

    for (unsigned int i=0 ; i<size ; ++i)
    {
	const short state = m_State[i];
	if (state)
	{
	    const short before = m_World->ArrayY(i) - state;
	    command->AddState(i, before);
	}
    }

    return command;
}


void 
HFEOffset::ApplyAtPoint(int x, int z, float factor)
{
    InitState( 0 );

    short& state = GetState(x,z);
    const int offset = ComputeOffset(state, factor);

    // Sets the world with the value
    Ark::Height world = m_World->Y(x,z);
    short after = m_World->Y(x, z) = Clamp255( world + offset );

    // Sets the state with a valid offset
    state += after - world;
}

// ========================================================================
// ========================================================================
// ========================================================================

int 
HFENoise::ComputeOffset(int before, float factor)
{
  const float rnd = ( float( rand() ) / float(RAND_MAX) - 0.5f);
  const int offset = int( rnd * ComputeOffsetAttenuation(factor) );
  
  return offset;
}

HFEditHeight* 
HFENoise::CreateNew(World* w, int t, int s, float a, float h) const
{
  return new HFENoise(w, t, s, a, h);
}

// ========================================================================
// ========================================================================
// ========================================================================

int 
HFEHigher::ComputeOffset(int before, float factor)
{
  const int offset = static_cast<int>( ComputeOffsetAttenuation(factor) );
  return (before < offset) ? (offset - before) : 0;
}

HFEditHeight* HFEHigher::CreateNew(World* w, int t, int s, float a, float h) const
{
  return new HFEHigher(w, t, s, a, h);
}

// ========================================================================
// ========================================================================
// ========================================================================

int 
HFELower::ComputeOffset(int before, float factor)
{
  const int offset = - static_cast<int>( ComputeOffsetAttenuation(factor) );
  return (offset < before) ? (offset - before) : 0;
}

HFEditHeight* HFELower::CreateNew(World* w, int t, int s, float a, float h) const
{
  return new HFELower(w, t, s, a, h);
}

// ========================================================================
// ========================================================================
// ========================================================================

