/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.ListStyleConverter;
import writer2latex.latex.util.Context;
import writer2latex.latex.util.HeadingMap;
import writer2latex.office.OfficeReader;
import writer2latex.util.CSVList;
import writer2latex.util.Config;
import writer2latex.util.ExportNameCollection;
import writer2latex.util.Misc;

public class FieldConverter
extends ConverterHelper {
    private ExportNameCollection targets = new ExportNameCollection(true);
    private ExportNameCollection refnames = new ExportNameCollection(true);
    private ExportNameCollection bookmarknames = new ExportNameCollection(true);
    private ExportNameCollection seqnames = new ExportNameCollection(true);
    private ExportNameCollection seqrefnames = new ExportNameCollection(true);
    private Hashtable seqDecl = new Hashtable();
    private Hashtable seqFirst = new Hashtable();
    private Vector postponedReferenceMarks = new Vector();
    private Vector postponedBookmarks = new Vector();
    private boolean bUseHyperref = false;
    private boolean bUsesPageCount = false;
    private boolean bUsesTitleref = false;
    private boolean bUsesOooref = false;

    public FieldConverter(OfficeReader ofr, Config config, ConverterPalette palette) {
        super(ofr, config, palette);
        this.bUseHyperref = config.useHyperref() && !config.useTitleref() && !config.useOooref();
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bUsesPageCount) {
            pack.append("\\usepackage{lastpage}").nl();
        }
        if (this.bUsesTitleref) {
            pack.append("\\usepackage{titleref}").nl();
        }
        if (this.bUsesOooref) {
            pack.append("\\usepackage[");
            HeadingMap hm = this.config.getHeadingMap();
            CSVList opt = new CSVList(",");
            int i = 0;
            while (i <= hm.getMaxLevel()) {
                opt.addValue(hm.getName(i));
                ++i;
            }
            pack.append(opt.toString()).append("]{oooref}").nl();
        }
        if (this.bUseHyperref) {
            pack.append("\\usepackage{hyperref}").nl();
            pack.append("\\hypersetup{");
            if (this.config.getBackend() == 2) {
                pack.append("pdftex, ");
            } else if (this.config.getBackend() == 1) {
                pack.append("dvips, ");
            }
            pack.append("colorlinks=true, linkcolor=blue, citecolor=blue, filecolor=blue, pagecolor=blue, urlcolor=blue");
            if (this.config.getBackend() == 2) {
                pack.append(this.createPdfMeta("pdftitle", this.palette.getMetaData().getTitle())).append(this.createPdfMeta("pdfauthor", this.palette.getMetaData().getCreator())).append(this.createPdfMeta("pdfsubject", this.palette.getMetaData().getSubject())).append(this.createPdfMeta("pdfkeywords", this.palette.getMetaData().getKeywords()));
            }
            pack.append("}").nl();
        }
        Enumeration names = this.seqFirst.keys();
        while (names.hasMoreElements()) {
            String sName = (String)names.nextElement();
            Element first = (Element)this.seqFirst.get(sName);
            String sNumFormat = Misc.getAttribute(first, "style:num-format");
            if (sNumFormat == null) {
                sNumFormat = "1";
            }
            int nLevel = 0;
            String sSepChar = ".";
            if (this.seqDecl.containsKey(sName)) {
                Element sdecl = (Element)this.seqDecl.get(sName);
                nLevel = Misc.getPosInteger(sdecl.getAttribute("text:display-outline-level"), 0);
                if (sdecl.hasAttribute("text:separation-character")) {
                    sSepChar = this.palette.getI18n().convert(sdecl.getAttribute("text:separation-character"), false, this.palette.getMainContext().getLang());
                }
            }
            decl.append("\\newcounter{").append(this.seqnames.getExportName(sName)).append("}");
            String sPrefix = "";
            if (nLevel > 0) {
                int nUsedLevel;
                HeadingMap hm = this.config.getHeadingMap();
                int n = nUsedLevel = nLevel <= hm.getMaxLevel() ? nLevel : hm.getMaxLevel();
                if (nUsedLevel > 0) {
                    decl.append("[").append(hm.getName(nUsedLevel)).append("]");
                    sPrefix = "\\the" + hm.getName(nUsedLevel) + sSepChar;
                }
            }
            LaTeXDocumentPortion laTeXDocumentPortion = decl.nl().append("\\renewcommand\\the").append(this.seqnames.getExportName(sName)).append("{").append(sPrefix);
            this.palette.getListSc();
            laTeXDocumentPortion.append(ListStyleConverter.numFormat(sNumFormat)).append("{").append(this.seqnames.getExportName(sName)).append("}}").nl();
        }
    }

    public void handleSequenceDecls(Element node) {
        Node child = node.getFirstChild();
        while (child != null) {
            if (Misc.isElement(child, "text:sequence-decl")) {
                this.seqDecl.put(((Element)child).getAttribute("text:name"), child);
            }
            child = child.getNextSibling();
        }
    }

    public void handleSequence(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sName = Misc.getAttribute(node, "text:name");
        String sRefName = Misc.getAttribute(node, "text:ref-name");
        if (sName != null) {
            if (this.ofr.isFigureSequenceName(sName) || this.ofr.isTableSequenceName(sName)) {
                if (sRefName != null && this.ofr.hasSequenceRefTo(sRefName)) {
                    ldp.append("\\label{seq:").append(this.seqrefnames.getExportName(sRefName)).append("}");
                }
            } else {
                if (!this.seqFirst.containsKey(sName)) {
                    this.seqFirst.put(sName, node);
                }
                if (sRefName != null && this.ofr.hasSequenceRefTo(sRefName)) {
                    ldp.append("{\\refstepcounter{").append(this.seqnames.getExportName(sName)).append("}\\the").append(this.seqnames.getExportName(sName)).append("\\label{seq:").append(this.seqrefnames.getExportName(sRefName)).append("}}");
                } else {
                    ldp.append("\\stepcounter{").append(this.seqnames.getExportName(sName)).append("}{\\the").append(this.seqnames.getExportName(sName)).append("}");
                }
            }
        }
    }

    public void handleSequenceRef(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sRefName = Misc.getAttribute(node, "text:ref-name");
        String sFormat = Misc.getAttribute(node, "text:reference-format");
        String sName = this.ofr.getSequenceFromRef(sRefName);
        if (sRefName != null) {
            if (sFormat == null || "page".equals(sFormat)) {
                ldp.append("\\pageref{seq:").append(this.seqrefnames.getExportName(sRefName)).append("}");
            } else if ("value".equals(sFormat)) {
                ldp.append("\\ref{seq:").append(this.seqrefnames.getExportName(sRefName)).append("}");
            } else if ("category-and-value".equals(sFormat)) {
                if (sName != null) {
                    if (this.ofr.isFigureSequenceName(sName)) {
                        ldp.append("\\figurename~");
                    } else if (this.ofr.isTableSequenceName(sName)) {
                        ldp.append("\\tablename~");
                    } else {
                        ldp.append(sName).append("~");
                    }
                }
                ldp.append("\\ref{seq:").append(this.seqrefnames.getExportName(sRefName)).append("}");
            } else if ("chapter".equals(sFormat) && this.config.useOooref()) {
                ldp.append("\\chapterref{seq:").append(this.seqrefnames.getExportName(sRefName)).append("}");
                this.bUsesOooref = true;
            } else if ("caption".equals(sFormat) && this.config.useTitleref() && (this.ofr.isFigureSequenceName(sName) || this.ofr.isTableSequenceName(sName))) {
                ldp.append("\\titleref{seq:").append(this.seqrefnames.getExportName(sRefName)).append("}");
                this.bUsesTitleref = true;
            } else if ("text".equals(sFormat) && this.config.useTitleref() && (this.ofr.isFigureSequenceName(sName) || this.ofr.isTableSequenceName(sName))) {
                if (this.ofr.isFigureSequenceName(sName)) {
                    ldp.append("\\figurename");
                } else if (this.ofr.isTableSequenceName(sName)) {
                    ldp.append("\\tablename");
                }
                ldp.append("~\\ref{seq:").append(this.seqrefnames.getExportName(sRefName)).append("}:~\\titleref{").append(this.seqrefnames.getExportName(sRefName)).append("}");
                this.bUsesTitleref = true;
            } else {
                this.palette.getInlineCv().traversePCDATA(node, ldp, oc);
            }
        }
    }

    public void handleReferenceMark(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (!(oc.isInSection() || oc.isInCaption() || oc.isVerbatim())) {
            String sName = node.getAttribute("text:name");
            if (sName != null) {
                ldp.append("\\label{ref:" + this.refnames.getExportName(sName) + "}");
            }
        } else {
            this.postponedReferenceMarks.add(node);
        }
    }

    public void handleReferenceRef(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sFormat = node.getAttribute("text:reference-format");
        String sName = node.getAttribute("text:ref-name");
        if (("page".equals(sFormat) || "".equals(sFormat)) && sName != null) {
            ldp.append("\\pageref{ref:" + this.refnames.getExportName(sName) + "}");
        } else {
            this.palette.getInlineCv().traversePCDATA(node, ldp, oc);
        }
    }

    public void handleBookmark(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (!(oc.isInSection() || oc.isInCaption() || oc.isVerbatim())) {
            String sName = node.getAttribute("text:name");
            if (sName != null) {
                this.addTarget(node, "", ldp);
                if (this.ofr.hasBookmarkRefTo(sName)) {
                    ldp.append("\\label{bkm:" + this.bookmarknames.getExportName(sName) + "}");
                }
            }
        } else {
            this.postponedBookmarks.add(node);
        }
    }

    public void handleBookmarkRef(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sFormat = node.getAttribute("text:reference-format");
        String sName = node.getAttribute("text:ref-name");
        if (("page".equals(sFormat) || "".equals(sFormat)) && sName != null) {
            ldp.append("\\pageref{bkm:" + this.bookmarknames.getExportName(sName) + "}");
        } else {
            this.palette.getInlineCv().traversePCDATA(node, ldp, oc);
        }
    }

    public void flushReferenceMarks(LaTeXDocumentPortion ldp, Context oc) {
        if (!(oc.isInSection() || oc.isInCaption() || oc.isVerbatim())) {
            int n = this.postponedReferenceMarks.size();
            int i = 0;
            while (i < n) {
                this.handleReferenceMark((Element)this.postponedReferenceMarks.get(i), ldp, oc);
                ++i;
            }
            this.postponedReferenceMarks.clear();
            n = this.postponedBookmarks.size();
            int i2 = 0;
            while (i2 < n) {
                this.handleBookmark((Element)this.postponedBookmarks.get(i2), ldp, oc);
                ++i2;
            }
            this.postponedBookmarks.clear();
        }
    }

    public void handleAnchor(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sHref = node.getAttribute("xlink:href");
        if (sHref != null) {
            if (sHref.startsWith("#")) {
                if (this.bUseHyperref) {
                    ldp.append("\\hyperlink{").append(this.targets.getExportName(this.urlDecode(sHref.substring(1)))).append("}{");
                    this.palette.getInlineCv().traverseInlineText(node, ldp, oc, false);
                    ldp.append("}");
                } else {
                    this.palette.getInlineCv().traverseInlineText(node, ldp, oc, true);
                }
            } else if (this.bUseHyperref) {
                if (this.ofr.getTextContent(node).trim().equals(sHref)) {
                    ldp.append("\\url{").append(oc.isInFootnote() ? this.escapeHref(this.urlDecode(sHref)) : this.urlDecode(sHref)).append("}");
                } else {
                    ldp.append("\\href{").append(oc.isInFootnote() ? this.escapeHref(this.urlDecode(sHref)) : this.urlDecode(sHref)).append("}{");
                    this.palette.getInlineCv().traverseInlineText(node, ldp, oc, false);
                    ldp.append("}");
                }
            } else {
                this.palette.getInlineCv().traverseInlineText(node, ldp, oc, true);
            }
        } else {
            this.palette.getInlineCv().traverseInlineText(node, ldp, oc, true);
        }
    }

    public void addTarget(Element node, String sSuffix, LaTeXDocumentPortion ldp) {
        String sName = node.getAttribute("text:name");
        if (sName == null) {
            sName = node.getAttribute("table:name");
        }
        if (sName == null || !this.bUseHyperref) {
            return;
        }
        if (!this.ofr.hasLinkTo(sName + sSuffix)) {
            return;
        }
        ldp.append("\\hypertarget{").append(this.targets.getExportName(sName + sSuffix)).append("}{}");
    }

    public void addTarget(String sName, String sSuffix, LaTeXDocumentPortion ldp) {
        if (sName != null && this.bUseHyperref && this.ofr.hasLinkTo(sName + sSuffix)) {
            ldp.append("\\hypertarget{").append(this.targets.getExportName(sName + sSuffix)).append("}{}");
        }
    }

    public void handlePageNumber(Element node, LaTeXDocumentPortion ldp, Context oc) {
        ldp.append("\\thepage{}");
    }

    public void handlePageCount(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (this.config.useLastpage()) {
            this.bUsesPageCount = true;
            ldp.append("\\pageref{LastPage}");
        } else {
            ldp.append("?");
        }
    }

    private String createPdfMeta(String sName, String sValue) {
        if (sValue == null) {
            return "";
        }
        sValue = sValue.replace(',', ';');
        return ", " + sName + "=" + this.palette.getI18n().convert(sValue, false, this.palette.getMainContext().getLang());
    }

    private String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    private String escapeHref(String s) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '#') {
                buf.append("\\#");
            } else {
                buf.append(s.charAt(i));
            }
            ++i;
        }
        return buf.toString();
    }
}

