/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import writer2latex.api.ConverterFactory;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.ConverterBase;
import writer2latex.util.ExportNameCollection;
import writer2latex.util.L10n;
import writer2latex.util.Misc;
import writer2latex.xhtml.DrawConverter;
import writer2latex.xhtml.LinkDescriptor;
import writer2latex.xhtml.MathConverter;
import writer2latex.xhtml.StyleConverter;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.TableConverter;
import writer2latex.xhtml.TextConverter;
import writer2latex.xhtml.XhtmlDocument;

public class Converter
extends ConverterBase {
    private L10n l10n;
    private StyleConverter styleCv;
    private TextConverter textCv;
    private TableConverter tableCv;
    private DrawConverter drawCv;
    private MathConverter mathCv;
    private XhtmlDocument template = null;
    Vector outFiles = new Vector();
    protected int nType = 0;
    private int nOutFileIndex = -1;
    private XhtmlDocument htmlDoc;
    private Document htmlDOM;
    private boolean bNeedHeaderFooter = false;
    Hashtable targets = new Hashtable();
    LinkedList links = new LinkedList();
    private ExportNameCollection targetNames = new ExportNameCollection(true);

    public Converter(int nType) {
        this.nType = nType;
    }

    public void readTemplate(InputStream is) throws IOException {
        this.template = new XhtmlDocument("Template", this.nType);
    }

    protected StyleConverter getStyleCv() {
        return this.styleCv;
    }

    protected TextConverter getTextCv() {
        return this.textCv;
    }

    protected TableConverter getTableCv() {
        return this.tableCv;
    }

    protected DrawConverter getDrawCv() {
        return this.drawCv;
    }

    protected MathConverter getMathCv() {
        return this.mathCv;
    }

    protected int getType() {
        return this.nType;
    }

    protected int getOutFileIndex() {
        return this.nOutFileIndex;
    }

    protected Element createElement(String s) {
        return this.htmlDOM.createElement(s);
    }

    protected Text createTextNode(String s) {
        return this.htmlDOM.createTextNode(s);
    }

    protected Node importNode(Node node, boolean bDeep) {
        return this.htmlDOM.importNode(node, bDeep);
    }

    public void convertInner() throws IOException {
        block25: {
            Document dom;
            block26: {
                block24: {
                    StyleWithProperties style;
                    this.sTargetFileName = Misc.trimDocumentName(this.sTargetFileName, XhtmlDocument.getExtension(this.nType));
                    this.bNeedHeaderFooter = this.ofr.isSpreadsheet() || this.ofr.isPresentation() || this.config.getXhtmlSplitLevel() > 0 || this.config.getXhtmlUplink().length() > 0;
                    this.l10n = new L10n();
                    this.imageLoader.setDefaultFormat("image/png");
                    this.imageLoader.addAcceptedFormat("image/jpeg");
                    this.imageLoader.addAcceptedFormat("image/gif");
                    this.styleCv = new StyleConverter(this.ofr, this.config, this, this.nType);
                    this.textCv = new TextConverter(this.ofr, this.config, this);
                    this.tableCv = new TableConverter(this.ofr, this.config, this);
                    this.drawCv = new DrawConverter(this.ofr, this.config, this);
                    this.mathCv = new MathConverter(this.ofr, this.config, this, this.nType != 0);
                    StyleWithProperties styleWithProperties = style = this.ofr.isSpreadsheet() ? this.ofr.getDefaultCellStyle() : this.ofr.getDefaultParStyle();
                    if (style != null) {
                        String sLang = style.getProperty("fo:language");
                        String sCountry = style.getProperty("fo:country");
                        if (sLang != null) {
                            if (sCountry == null) {
                                this.l10n.setLocale(sLang);
                            } else {
                                this.l10n.setLocale(sLang + "-" + sCountry);
                            }
                        }
                    }
                    Element body = this.ofr.getContent();
                    if (this.ofr.isSpreadsheet()) {
                        this.tableCv.convertTableContent(body);
                    } else if (this.ofr.isPresentation()) {
                        this.drawCv.convertDrawContent(body);
                    } else {
                        this.textCv.convertTextContent(body);
                    }
                    this.textCv.insertFootnotes(this.htmlDoc.getContentNode());
                    this.textCv.insertEndnotes(this.htmlDoc.getContentNode());
                    ListIterator iter = this.links.listIterator();
                    while (iter.hasNext()) {
                        LinkDescriptor ld = (LinkDescriptor)iter.next();
                        Integer targetIndex = (Integer)this.targets.get(ld.sId);
                        if (targetIndex == null) continue;
                        int nTargetIndex = targetIndex;
                        if (nTargetIndex == ld.nIndex) {
                            ld.element.setAttribute("href", "#" + this.targetNames.getExportName(ld.sId));
                            continue;
                        }
                        ld.element.setAttribute("href", this.getOutFileName(nTargetIndex, true) + "#" + this.targetNames.getExportName(ld.sId));
                    }
                    int i = 0;
                    while (i <= this.nOutFileIndex) {
                        Document dom2 = ((XhtmlDocument)this.outFiles.get(i)).getContentDOM();
                        NodeList hlist = dom2.getElementsByTagName("head");
                        Node styles = this.styleCv.exportStyles(dom2);
                        if (styles != null) {
                            hlist.item(0).appendChild(styles);
                        }
                        ++i;
                    }
                    if (!this.ofr.isSpreadsheet()) break block24;
                    int i2 = 0;
                    while (i2 <= this.nOutFileIndex) {
                        XhtmlDocument doc = (XhtmlDocument)this.outFiles.get(i2);
                        dom = doc.getContentDOM();
                        Element header = doc.getHeaderNode();
                        Element footer = doc.getFooterNode();
                        Element headerPar = dom.createElement("p");
                        header.appendChild(headerPar);
                        header.appendChild(dom.createElement("hr"));
                        Element hr = dom.createElement("hr");
                        hr.setAttribute("style", "clear:both");
                        footer.appendChild(hr);
                        Element footerPar = dom.createElement("p");
                        footer.appendChild(footerPar);
                        int nSheets = this.tableCv.sheetNames.size();
                        int j = 0;
                        while (j < nSheets) {
                            if (this.config.xhtmlCalcSplit()) {
                                this.addNavigationLink(dom, headerPar, (String)this.tableCv.sheetNames.get(j), j);
                                this.addNavigationLink(dom, footerPar, (String)this.tableCv.sheetNames.get(j), j);
                            } else {
                                this.addInternalNavigationLink(dom, headerPar, (String)this.tableCv.sheetNames.get(j), "tableheading" + j);
                                this.addInternalNavigationLink(dom, footerPar, (String)this.tableCv.sheetNames.get(j), "tableheading" + j);
                            }
                            ++j;
                        }
                        ++i2;
                    }
                    break block25;
                }
                if (!this.ofr.isPresentation() && this.config.getXhtmlSplitLevel() <= 0) break block26;
                int i = 0;
                while (i <= this.nOutFileIndex) {
                    XhtmlDocument doc = (XhtmlDocument)this.outFiles.get(i);
                    dom = doc.getContentDOM();
                    Element header = doc.getHeaderNode();
                    Element footer = doc.getFooterNode();
                    Element content = doc.getContentNode();
                    if (this.config.getXhtmlUplink().length() > 0) {
                        Element a = dom.createElement("a");
                        a.setAttribute("href", this.config.getXhtmlUplink());
                        a.appendChild(dom.createTextNode(this.l10n.get(0)));
                        header.appendChild(dom.createTextNode("["));
                        header.appendChild(a);
                        header.appendChild(dom.createTextNode("] "));
                    }
                    this.addNavigationLink(dom, header, this.l10n.get(1), 0);
                    this.addNavigationLink(dom, header, this.l10n.get(2), i - 1);
                    this.addNavigationLink(dom, header, this.l10n.get(3), i + 1);
                    this.addNavigationLink(dom, header, this.l10n.get(4), this.nOutFileIndex);
                    if (this.textCv.getTocIndex() >= 0) {
                        this.addNavigationLink(dom, header, this.l10n.get(5), this.textCv.getTocIndex());
                    }
                    if (this.textCv.getAlphabeticalIndex() >= 0) {
                        this.addNavigationLink(dom, header, this.l10n.get(6), this.textCv.getAlphabeticalIndex());
                    }
                    header.appendChild(dom.createElement("hr"));
                    Element hr = dom.createElement("hr");
                    hr.setAttribute("style", "clear:both");
                    footer.appendChild(hr);
                    if (this.config.getXhtmlUplink().length() > 0) {
                        Element a = dom.createElement("a");
                        a.setAttribute("href", this.config.getXhtmlUplink());
                        a.appendChild(dom.createTextNode(this.l10n.get(0)));
                        footer.appendChild(dom.createTextNode("["));
                        footer.appendChild(a);
                        footer.appendChild(dom.createTextNode("] "));
                    }
                    this.addNavigationLink(dom, footer, this.l10n.get(1), 0);
                    this.addNavigationLink(dom, footer, this.l10n.get(2), i - 1);
                    this.addNavigationLink(dom, footer, this.l10n.get(3), i + 1);
                    this.addNavigationLink(dom, footer, this.l10n.get(4), this.nOutFileIndex);
                    if (this.textCv.getTocIndex() >= 0) {
                        this.addNavigationLink(dom, footer, this.l10n.get(5), this.textCv.getTocIndex());
                    }
                    if (this.textCv.getAlphabeticalIndex() >= 0) {
                        this.addNavigationLink(dom, footer, this.l10n.get(6), this.textCv.getAlphabeticalIndex());
                    }
                    ++i;
                }
                break block25;
            }
            if (this.config.getXhtmlUplink().length() <= 0) break block25;
            int i = 0;
            while (i <= this.nOutFileIndex) {
                XhtmlDocument doc = (XhtmlDocument)this.outFiles.get(i);
                dom = doc.getContentDOM();
                Element header = doc.getHeaderNode();
                Element footer = doc.getFooterNode();
                Element content = doc.getContentNode();
                Element a = dom.createElement("a");
                a.setAttribute("href", this.config.getXhtmlUplink());
                a.appendChild(dom.createTextNode(this.l10n.get(0)));
                header.appendChild(dom.createTextNode("["));
                header.appendChild(a);
                header.appendChild(dom.createTextNode("] "));
                header.appendChild(dom.createElement("hr"));
                Element hr = dom.createElement("hr");
                hr.setAttribute("style", "clear:both");
                footer.appendChild(hr);
                a = dom.createElement("a");
                a.setAttribute("href", this.config.getXhtmlUplink());
                a.appendChild(dom.createTextNode(this.l10n.get(0)));
                footer.appendChild(dom.createTextNode("["));
                footer.appendChild(a);
                footer.appendChild(dom.createTextNode("] "));
                ++i;
            }
        }
    }

    private void addNavigationLink(Document dom, Node node, String s, int nIndex) {
        if (nIndex >= 0 && nIndex <= this.nOutFileIndex) {
            Element a = dom.createElement("a");
            a.setAttribute("href", Misc.makeHref(this.getOutFileName(nIndex, true)));
            a.appendChild(dom.createTextNode(s));
            node.appendChild(dom.createTextNode("["));
            node.appendChild(a);
            node.appendChild(dom.createTextNode("] "));
        } else {
            node.appendChild(dom.createTextNode("[" + s + "] "));
        }
    }

    private void addInternalNavigationLink(Document dom, Node node, String s, String sLink) {
        Element a = dom.createElement("a");
        a.setAttribute("href", "#" + sLink);
        a.appendChild(dom.createTextNode(s));
        node.appendChild(dom.createTextNode("["));
        node.appendChild(a);
        node.appendChild(dom.createTextNode("] "));
    }

    public void handleOfficeAnnotation(Node onode, Node hnode) {
        Element paragraph = Misc.getChildByTagName(onode, "text:p");
        if (paragraph != null && paragraph.hasChildNodes()) {
            StringBuffer buf = new StringBuffer();
            NodeList nl = paragraph.getChildNodes();
            int nLen = nl.getLength();
            int i = 0;
            while (i < nLen) {
                if (nl.item(i).getNodeType() == 3) {
                    buf.append(nl.item(i).getNodeValue());
                }
                ++i;
            }
            Comment commentNode = this.htmlDOM.createComment(buf.toString());
            hnode.appendChild(commentNode);
        }
    }

    private String getOutFileName(int nIndex, boolean bWithExt) {
        return this.sTargetFileName + (nIndex > 0 ? Integer.toString(nIndex) : "") + (bWithExt ? this.htmlDoc.getFileExtension() : "");
    }

    public boolean outFileHasContent() {
        return this.htmlDoc.getContentNode().hasChildNodes();
    }

    public void changeOutFile(int nIndex) {
        this.nOutFileIndex = nIndex;
        this.htmlDoc = (XhtmlDocument)this.outFiles.get(nIndex);
        this.htmlDOM = this.htmlDoc.getContentDOM();
    }

    public Element nextOutFile() {
        String sTitle;
        if (this.nOutFileIndex >= 0) {
            this.textCv.insertFootnotes(this.htmlDoc.getContentNode());
        }
        this.htmlDoc = new XhtmlDocument(this.getOutFileName(++this.nOutFileIndex, false), this.nType);
        this.htmlDoc.setEncoding(this.config.xhtmlEncoding());
        this.htmlDoc.setNoDoctype(this.config.xhtmlNoDoctype());
        if (this.template != null) {
            this.htmlDoc.readFromTemplate(this.template);
        } else if (this.bNeedHeaderFooter) {
            this.htmlDoc.createHeaderFooter();
        }
        this.outFiles.add(this.nOutFileIndex, this.htmlDoc);
        this.convertData.addDocument(this.htmlDoc);
        this.htmlDOM = this.htmlDoc.getContentDOM();
        Element rootElement = this.htmlDOM.getDocumentElement();
        this.styleCv.applyDefaultLanguage(rootElement);
        rootElement.insertBefore(this.htmlDOM.createComment("This file was converted to xhtml by " + (this.ofr.isText() ? "Writer" : (this.ofr.isSpreadsheet() ? "Calc" : "Impress")) + "2xhtml ver. " + ConverterFactory.getVersion() + ". See http://www.hj-gym.dk/~hj/writer2latex for more info."), rootElement.getFirstChild());
        if (this.ofr.getFirstMasterPage() != null && !this.ofr.isPresentation()) {
            StyleInfo pageInfo = new StyleInfo();
            this.styleCv.getPageSc().applyStyle(this.ofr.getFirstMasterPage().getName(), pageInfo);
            this.styleCv.getPageSc().applyStyle(pageInfo, this.htmlDoc.getContentNode());
        }
        if ((sTitle = this.metaData.getTitle()) == null) {
            sTitle = this.htmlDoc.getFileName();
        }
        this.htmlDoc.getTitleNode().appendChild(this.htmlDOM.createTextNode(sTitle));
        if (this.nType == 0) {
            Element meta = this.htmlDOM.createElement("meta");
            meta.setAttribute("http-equiv", "Content-Type");
            meta.setAttribute("content", "text/html; charset=" + this.htmlDoc.getEncoding().toLowerCase());
            this.htmlDoc.getHeadNode().appendChild(meta);
        }
        this.createMeta("description", this.metaData.getDescription());
        this.createMeta("keywords", this.metaData.getKeywords());
        if (this.config.xhtmlUseDublinCore()) {
            this.htmlDoc.getHeadNode().setAttribute("profile", "http://dublincore.org/documents/dcq-html/");
            Element dclink = this.htmlDOM.createElement("link");
            dclink.setAttribute("rel", "schema.DC");
            dclink.setAttribute("href", "http://purl.org/dc/elements/1.1/");
            this.htmlDoc.getHeadNode().appendChild(dclink);
            this.createMeta("DC.title", this.metaData.getTitle());
            String sDCSubject = this.metaData.getSubject();
            if (this.metaData.getSubject().length() > 0 && this.metaData.getKeywords().length() > 0) {
                sDCSubject = sDCSubject + ", ";
            }
            sDCSubject = sDCSubject + this.metaData.getKeywords();
            this.createMeta("DC.subject", sDCSubject);
            this.createMeta("DC.description", this.metaData.getDescription());
            this.createMeta("DC.creator", this.metaData.getCreator());
            this.createMeta("DC.date", this.metaData.getDate());
            this.createMeta("DC.language", this.metaData.getLanguage());
        }
        if (this.config.xhtmlCustomStylesheet().length() > 0) {
            Element htmlStyle = this.htmlDOM.createElement("link");
            htmlStyle.setAttribute("rel", "stylesheet");
            htmlStyle.setAttribute("type", "text/css");
            htmlStyle.setAttribute("media", "all");
            htmlStyle.setAttribute("href", this.config.xhtmlCustomStylesheet());
            this.htmlDoc.getHeadNode().appendChild(htmlStyle);
        }
        if (!this.textCv.sections.isEmpty()) {
            Iterator iter = this.textCv.sections.iterator();
            while (iter.hasNext()) {
                Element section = (Element)iter.next();
                String sStyleName = Misc.getAttribute(section, "text:style-name");
                Element div = this.htmlDOM.createElement("div");
                this.htmlDoc.getContentNode().appendChild(div);
                this.htmlDoc.setContentNode(div);
                StyleInfo sectionInfo = new StyleInfo();
                this.styleCv.getSectionSc().applyStyle(sStyleName, sectionInfo);
                this.styleCv.getSectionSc().applyStyle(sectionInfo, div);
            }
        }
        return this.htmlDoc.getContentNode();
    }

    public Element createTarget(String sId) {
        Element a = this.htmlDOM.createElement("a");
        a.setAttribute("id", this.targetNames.getExportName(sId));
        this.targets.put(sId, new Integer(this.nOutFileIndex));
        return a;
    }

    public void addTarget(Element node, String sId) {
        node.setAttribute("id", this.targetNames.getExportName(sId));
        this.targets.put(sId, new Integer(this.nOutFileIndex));
    }

    public Element createLink(String sId) {
        Element a = this.htmlDOM.createElement("a");
        LinkDescriptor ld = new LinkDescriptor();
        ld.element = a;
        ld.sId = sId;
        ld.nIndex = this.nOutFileIndex;
        this.links.add(ld);
        return a;
    }

    public Element createLink(Element onode) {
        Element anchor;
        String sHref = onode.getAttribute("xlink:href");
        if (sHref.startsWith("#")) {
            anchor = this.createLink(sHref.substring(1));
        } else {
            String sTarget;
            int n3F;
            anchor = this.htmlDOM.createElement("a");
            if (sHref.indexOf("?") == -1 && (n3F = sHref.indexOf("%3F")) > 0) {
                sHref = sHref.substring(0, n3F) + "?" + sHref.substring(n3F + 3);
            }
            anchor.setAttribute("href", sHref);
            String sName = Misc.getAttribute(onode, "office:name");
            if (sName != null) {
                anchor.setAttribute("name", sName);
                anchor.setAttribute("title", sName);
            }
            if ((sTarget = Misc.getAttribute(onode, "office:target-frame-name")) != null) {
                anchor.setAttribute("target", sTarget);
            }
        }
        String sStyleName = onode.getAttribute("text:style-name");
        String sVisitedStyleName = onode.getAttribute("text:visited-style-name");
        StyleInfo anchorInfo = new StyleInfo();
        this.styleCv.getTextSc().applyAnchorStyle(sStyleName, sVisitedStyleName, anchorInfo);
        this.styleCv.getTextSc().applyStyle(anchorInfo, anchor);
        return anchor;
    }

    private void createMeta(String sName, String sValue) {
        if (sValue == null) {
            return;
        }
        Element meta = this.htmlDOM.createElement("meta");
        meta.setAttribute("name", sName);
        meta.setAttribute("content", sValue);
        this.htmlDoc.getHeadNode().appendChild(meta);
    }
}

