/*
 *  WSoundPrefs - WMSound Server Preferences Program
 *
 * Copyright (c) 1998, 1999 Pascal Hofstee
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "WSoundPrefs.h"


extern void Initialize(WMScreen *scr);
extern Bool isFormatSupported(char *format);


static void
printHelp(char *progname)
{
	printf(_("Usage: %s [options]\n"), progname);
	puts(_("options:"));
	puts(_(" -display <display> display to be used"));
	puts(_(" --version          print version number and exit"));
}


int
main(int argc, char **argv)
{
	Display		*dpy;
	WMScreen	*scr;
	WMPixmap	*icon;
	char		*dpyName = "";
	char		*path;
	int		i;
	
	WMInitializeApplication("WSoundPrefs", &argc, argv);
	SInitializeApplication(argv[0]);
	
	if (argc > 1) {
		for (i = 1; i < argc; i++) {
			if (strcmp(argv[i], "--version") == 0) {
				printf("WSoundPrefs %s\n", WVERSION);
				exit(0);
			}
			else if (strcmp(argv[i], "-display") == 0) {
				i++;
				if (i >= argc) {
					wwarning(_("too few arguments for %s"), argv[i-1]);
					exit(0);
				}
				dpyName = argv[i];
			}
			else {
				printHelp(argv[0]);
				exit(0);
			}
		}
	}
	
	
	dpy = XOpenDisplay(dpyName);
	if (!dpy) {
		wfatal(_("could not open display %s"), XDisplayName(dpyName));
		exit(0);
	}
	
#ifdef DEBUG
	XSynchronize(dpy, True);
#endif
	
	scr = WMCreateScreen(dpy, DefaultScreen(dpy));
	if (!scr) {
		wfatal(_("could not initialize application"));
		exit(0);
	}

	
	if (isFormatSupported("TIFF"))
		path = WMPathForResourceOfType("WSoundPrefs.tiff", NULL);
	else
		path = WMPathForResourceOfType("WSoundPrefs.xpm", NULL);
	
	if (path) {
		RImage	*tmp;
		
		tmp = RLoadImage(WMScreenRContext(scr), path, 0);
		if (!tmp)
			wwarning(_("could not load image file %s:%s"), path, RMessageForError(RErrorCode));
		else {
			icon = WMCreatePixmapFromRImage(scr, tmp, 0);
			RDestroyImage(tmp);
			if (icon) {
				WMSetApplicationIconImage(scr, icon);
				WMReleasePixmap(icon);
			}
		}
		free(path);
	}

	
	Initialize(scr);
	
	while (1) {
		XEvent event;
		
		WMNextEvent(dpy, &event);
		WMHandleEvent(&event);
	}
}
