/*-
# X-BASED ABACUS
#
#  AbacusP.h
#
###
#
#  Copyright (c) 1994 - 2004	David Albert Bagley, bagleyd@tux.org
#
#  Abacus demo and neat pointers from
#  Copyright (c) 1991 - 1998	Luis Fernandes, elf@ee.ryerson.ca
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "useful",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Abacus */

#ifndef _AbacusP_h
#define _AbacusP_h

#include "Abacus.h"

#ifdef WINVER
#define STRICT

#include <windows.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#ifndef DEMOPATH
#define DEMOPATH "c:\\Windows"
#endif

#if ((WINVER > 0x030a) && !defined(GCL_HBRBACKGROUND))
#undef WINVER
#define WINVER 0x030a
#endif
#if (WINVER <= 0x030a)		/* if WINDOWS 3.1 or less */
#define Pos int
#define SETBACK(h,b) (void)SetClassWord(h,GCW_HBRBACKGROUND,(WORD)b);
#define MoveTO(h,x,y) MoveTo(h,x,y);
#else
#define Pos long
#define SETBACK(h,b) (void)SetClassLong(h,GCL_HBRBACKGROUND,(LONG)b);
#define MoveTO(h,x,y) MoveToEx(h,x,y,NULL);
#endif
#ifndef Point
#define Point POINT
#endif
#ifndef Boolean
#define Boolean BOOL
#endif
#ifndef True
#define True TRUE
#endif
#ifndef False
#define False FALSE
#endif
#define GC COLORREF  /* Equate apples to oranges */

#define RECTANGLE(w,x,y,l,h,c) if ((l)==1 && (h)==1) \
(void)SetPixel(w->core.hDC,x,y,c); \
else (void)Rectangle(w->core.hDC,x,y,x+l,y+h)
#define LINE(w,x1,y1,x2,y2) (void)MoveTO(w->core.hDC,x1,y1); \
  (void)LineTo(w->core.hDC,x2,y2)
#define CIRCLE(w,r,x,y) if(r>0)(void)Ellipse(w->core.hDC,x-r+1,y-r+1,x+r,y+r)
#define DRAWRECTANGLE(w,c,x,y,l,h) hPen = CreatePen(PS_SOLID, 1, c); \
  hOldPen = (HPEN) SelectObject(w->core.hDC, hPen); \
  RECTANGLE(w,x,y,l,h,c); \
  (void) SelectObject(w->core.hDC, hOldPen); \
  (void) DeleteObject(hPen)
#define DRAWRECTANGLE2(w,c,x,y,l,h) hPen = CreatePen(PS_SOLID, 1, c); \
  hOldPen = (HPEN) SelectObject(w->core.hDC, hPen); \
  RECTANGLE(w,x,y,(l)+1,(h)+1,c); \
  (void) SelectObject(w->core.hDC, hOldPen); \
  (void) DeleteObject(hPen)
#define FILLRECTANGLE(w,c,x,y,l,h) hPen = CreatePen(PS_SOLID, 1, c); \
  hOldPen = (HPEN) SelectObject(w->core.hDC, hPen); \
  hBrush = CreateSolidBrush(c); \
  hOldBrush = (HBRUSH) SelectObject(w->core.hDC, hBrush); \
  RECTANGLE(w,x,y,l,h,c); \
  (void) SelectObject(w->core.hDC, hOldBrush); \
  (void) DeleteObject(hBrush); \
  (void) SelectObject(w->core.hDC, hOldPen); \
  (void) DeleteObject(hPen)
#define DRAWCIRCLE(w,c,d,x,y) hPen = CreatePen(PS_SOLID, 1, c); \
  hOldPen = (HPEN) SelectObject(w->core.hDC, hPen); \
  CIRCLE(w,((d+1)>>1),(x)+(d)%2,(y)+(d)%2); \
  (void) SelectObject(w->core.hDC, hOldPen); \
  (void) DeleteObject(hPen)
#define DRAWCIRCLE2(w,c,d,x,y) hPen = CreatePen(PS_SOLID, 1, c); \
  hOldPen = (HPEN) SelectObject(w->core.hDC, hPen); \
  hBrush = CreateSolidBrush(c); \
  hOldBrush = (HBRUSH) SelectObject(w->core.hDC, hBrush); \
  CIRCLE(w,((d+2)>>1),(x)+(d)%2,(y)+(d)%2); \
  (void) SelectObject(w->core.hDC, hOldBrush); \
  (void) DeleteObject(hBrush); \
  (void) SelectObject(w->core.hDC, hOldPen); \
  (void) DeleteObject(hPen)
#define FILLCIRCLE(w,c,d,x,y) hPen = CreatePen(PS_SOLID, 1, c); \
  hOldPen = (HPEN) SelectObject(w->core.hDC, hPen); \
  hBrush = CreateSolidBrush(c); \
  hOldBrush = (HBRUSH) SelectObject(w->core.hDC, hBrush); \
  CIRCLE(w,((d+2)>>1),(x)+(d)%2,(y)+(d)%2); \
  (void) SelectObject(w->core.hDC, hOldBrush); \
  (void) DeleteObject(hBrush); \
  (void) SelectObject(w->core.hDC, hOldPen); \
  (void) DeleteObject(hPen)

#if 0
#define DISPLAY_WARNING(s) (void) fprintf(stderr, s)
#else
#define DISPLAY_INFO(s) (void) MessageBox(w->core.hWnd, s, "Info", MB_OK)
#define DISPLAY_WARNING(s) (void) MessageBox(w->core.hWnd, s, "Warning", MB_OK)
#endif
#define DISPLAY_ERROR(s) (void) fprintf(stderr, "%s\n", s); exit(1)

typedef struct _CorePart {
	HWND        hWnd;
	HDC         hDC;
	HINSTANCE   hInstance;
	Pos         width, height;
} CorePart;

extern HBRUSH hOldBrush, hBrush;
extern HPEN hOldPen, hPen;

extern void DestroyAbacus(AbacusWidget w, HBRUSH brush);
extern void ResizeAbacus(AbacusWidget w);
extern void InitializeAbacus(AbacusWidget w, HBRUSH brush);
extern void ExposeAbacus(AbacusWidget w);
extern void HideAbacus(AbacusWidget w);
extern void SelectAbacus(AbacusWidget w, const int x, const int y);
extern void ReleaseAbacus(AbacusWidget w);
extern void ClearAbacus(AbacusWidget w);
extern void ClearAbacusMaybe(AbacusWidget w);
extern void ClearAbacus2(AbacusWidget w);
extern void IncrementAbacus(AbacusWidget w);
extern void DecrementAbacus(AbacusWidget w);
extern void FormatAbacus(AbacusWidget w);
extern void RomanNumeralsAbacus(AbacusWidget w);
extern void SignAbacus(AbacusWidget w);
extern void QuarterAbacus(AbacusWidget w);
extern void QuarterPercentAbacus(AbacusWidget w);
extern void DemoAbacus(AbacusWidget w);
extern void NextAbacus(AbacusWidget w);
extern void RepeatAbacus(AbacusWidget w);
extern void MoreAbacus(AbacusWidget w);
extern void EnterAbacus(AbacusWidget w);
extern void LeaveAbacus(AbacusWidget w);

extern void MoveAbacus(AbacusWidget w);
extern void SetAbacusString(AbacusWidget w, int reason, char *string);
#if (WINVER <= 0x030a)
extern void Sleep(unsigned long cMilliseconds);
#endif

extern void InitializeAbacusDemo(AbacusWidget w);
extern void ExposeAbacusDemo(AbacusWidget w);
extern void HideAbacusDemo(AbacusWidget w);
extern void SelectAbacusDemo(AbacusWidget w);
extern void ClearAbacusDemo(AbacusWidget w);
extern void DemoAbacusDemo(AbacusWidget w);
extern void NextAbacusDemo(AbacusWidget w);
extern void RepeatAbacusDemo(AbacusWidget w);
extern void MoreAbacusDemo(AbacusWidget w);

#else

#ifndef DEMOPATH
#if 0
#define DEMOPATH "/usr/local/share/games/xabacus"
#endif
#define DEMOPATH "/usr/share/games/xabacus"
#endif

#ifndef Pos
#define Pos Position
#endif
#ifndef Point
#define Point XPoint
#endif
#define NUM_DEGREES 360
#define MULT 64
#define FULLCIRCLE (NUM_DEGREES*MULT)
#define DRAWRECTANGLE2(w,c,i,j,l,h) XDrawRectangle(XtDisplay(w),XtWindow(w),\
	c,i,j,l,h)
#define FILLRECTANGLE(w,c,i,j,l,h) XFillRectangle(XtDisplay(w),XtWindow(w),\
	c,i,j,l,h)
#define DRAWRECTANGLE(w,c,i,j,l,h) XDrawRectangle(XtDisplay(w),XtWindow(w),\
	c,i,j,l,h)
#define FILLCIRCLE(w,c,d,x,y) if(d>0) XFillArc(XtDisplay(w),XtWindow(w),\
	c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWCIRCLE2(w,c,d,x,y) if(d>0) XDrawArc(XtDisplay(w),XtWindow(w),\
	c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWCIRCLE(w,c,d,x,y) if(d>0) XDrawArc(XtDisplay(w),XtWindow(w),\
	c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)

#define DISPLAY_INFO(s) XtWarning(s)
#define DISPLAY_WARNING(s) XtWarning(s)
#define DISPLAY_ERROR(s) XtError(s)

/* This gets around C's inability to do inheritance */
typedef struct _AbacusClassPart {
	int         ignore;
} AbacusClassPart;

typedef struct _AbacusClassRec {
	CoreClassPart core_class;
	AbacusClassPart abacus_class;
} AbacusClassRec;

extern AbacusClassRec abacusClassRec;

extern void Sleep(unsigned long cMilliseconds);
#endif

#define MAXDECKS 2
#define UP 1
#define DOWN 0
#define TOP 1
#define BOTTOM 0
#define CARRY 2	/* I guess it could be even more if you have a weird config
		   also need a space to hold null (not included) */
#define SPECIAL_QUARTERS 2 /* Quarters, QuarterPercents */

/* Migrate to Locale */
#define DECIMAL_SEPARATOR '.'
#define GROUP_SEPARATOR ','
#define GROUPING_SIZE 3

#define MAXLENFORMAT 9

#define LINES 4
#define CHARS 64

#define ABS(a) (((a)<0)?(-(a)):(a))
#define SIGN(a) (((a)<0)?(-1):1)
#define MIN(a,b) (((int)(a)<(int)(b))?(int)(a):(int)(b))
#define MAX(a,b) (((int)(a)>(int)(b))?(int)(a):(int)(b))

typedef struct _DeckPart {
	int         number;
	Boolean     orientation;
	int         factor;
	int        *position;
	int         spaces;	/* spaces between beads */
	int         room;	/* spaces + number */
	Pos         height;
} DeckPart;

typedef struct _AbacusPart {
	DeckPart    decks[MAXDECKS];
	int         currentDeck, currentRail, currentPosition;
	int         rails;	/* number of columns of beads */
	int         decimalPosition, numDigits;
	int         base, displayBase;	/* 10 usually */
	int         delay, mode;
	int         deck, rail, number;
	Pos         width, midHeight, midBarY, railWidth;
	Point       frameSize, beadSize;
	Point       pos, delta, offset;
	Boolean     mono, reverse, script, demo, focus, vertical, aux;
	Boolean     sign, quarter, quarterPercent, romanNumerals;
	Boolean     slot, diamond;
	char       *digits, *mathBuffer;
	FILE       *fp;
	GC          frameGC, borderGC, railGC, inverseGC;
	GC          beadShadeGC[5];
#ifdef WINVER
	char        format[81];
#else
	int         menu;
	char       *format;
	Pixel       foreground, background;
	Pixel       borderColor, beadColor, frameColor, railColor;
	XtCallbackList select;
#endif
} AbacusPart;

typedef struct _AbacusDemoPart {
	int         lessons;
	int         lessonLength, lessonCount;
	int         aux, deck, rail, number, lines;
	int         fontHeight;
	FILE       *fp;
	Boolean     query, started, framed;
	GC          foregroundGC;
#ifdef WINVER
	char        path[81];
#else
	GC          inverseGC;
	char       *path, *font;
	XFontStruct *fontInfo;
	Pixel       background, foreground;
	XtCallbackList select;
#endif
} AbacusDemoPart;

typedef struct _AbacusRec {
	CorePart    core;
	AbacusPart  abacus;
	AbacusDemoPart abacusDemo;
} AbacusRec;


extern void SetAbacus(AbacusWidget w, int reason);
extern void SetAbacusDemo(AbacusWidget w, int reason);
extern void SetAbacusMove(AbacusWidget w, int reason, int aux,
	int deck, int rail, int number);
extern int char2Int(char character);
extern char int2Char(int digit);

extern void dividePieces(char * buf, int base, int pieces,
	int mult, int places);
extern void addStrings(char *finalBuf, char *buf, char *pieceBuf,
	int base);
extern void subStrings(char *finalBuf, char *buf, char *pieceBuf,
	int base);
extern void convertString(char * buf, char * inbuf,
	int base, int displayBase, int decimalPosition);

extern int sizeofRoman(int base, Boolean romanNumerals);
extern int string2Roman(char *buf, char *inbuf, int base);

extern int baseToBottom(int base);

extern void calculate(AbacusWidget w, char *buffer);
extern void ClearRails(AbacusWidget w);
#endif /* _AbacusP_h */
