/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Controller;
import com.icl.saxon.StandardURIResolver;
import com.icl.saxon.expr.AnyNameTest;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.OutputDetails;
import com.icl.saxon.style.LiteralResultElement;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.StyleNodeFactory;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.trax.Templates;
import com.icl.saxon.trax.Transformer;
import com.icl.saxon.trax.URIResolver;
import com.icl.saxon.trax.serialize.OutputFormat;
import com.icl.saxon.trax.serialize.QName;
import com.icl.saxon.tree.Builder;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.Stripper;
import java.util.Vector;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.ParserAdapter;

public class PreparedStyleSheet
implements Templates {
    private DocumentInfo styleDoc;
    private XMLReader styleParser;
    private URIResolver uriResolver = new StandardURIResolver();

    public void setParser(Parser parser) {
        this.styleParser = new ParserAdapter(parser);
    }

    public void setXMLReader(XMLReader xMLReader) {
        this.styleParser = xMLReader;
    }

    public XMLReader getXMLReader() {
        return this.styleParser;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.uriResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void prepare(InputSource inputSource) throws SAXException {
        Stripper stripper = new Stripper();
        stripper.setPreserveSpace(new AnyNameTest(), false);
        stripper.setPreserveSpace(new Name("xsl", "http://www.w3.org/1999/XSL/Transform", "text"), true);
        Builder builder = new Builder();
        builder.setStripper(stripper);
        builder.setNodeFactory(new StyleNodeFactory());
        builder.setDiscardCommentsAndPIs(true);
        builder.setLineNumbering(true);
        builder.setXMLReader(this.styleParser);
        DocumentImpl documentImpl = builder.build(inputSource);
        this.setStyleSheetDocument(documentImpl);
    }

    public void setStyleSheetDocument(DocumentInfo documentInfo) throws SAXException {
        this.styleDoc = documentInfo;
        StyleElement styleElement = (StyleElement)this.styleDoc.getDocumentElement();
        if (styleElement instanceof LiteralResultElement) {
            this.styleDoc = ((LiteralResultElement)styleElement).makeStyleSheet();
        }
        if (!(this.styleDoc.getDocumentElement() instanceof XSLStyleSheet)) {
            throw new SAXException("Top-level element of stylesheet is not xsl:stylesheet or xsl:transform or literal result element");
        }
        XSLStyleSheet xSLStyleSheet = (XSLStyleSheet)this.styleDoc.getDocumentElement();
        xSLStyleSheet.setPreparedStyleSheet(this);
        xSLStyleSheet.preprocess();
    }

    public Transformer newTransformer() {
        Controller controller = new Controller();
        controller.setPreparedStyleSheet(this);
        try {
            controller.setOutputDetails(this.getOutputDetails());
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return controller;
    }

    public DocumentInfo getStyleSheetDocument() {
        return this.styleDoc;
    }

    public OutputFormat getOutputFormat() {
        OutputDetails outputDetails;
        OutputFormat outputFormat = new OutputFormat();
        try {
            outputDetails = this.getOutputDetails();
        }
        catch (SAXException sAXException) {
            return outputFormat;
        }
        outputFormat.setMethod(outputDetails.getMethod());
        outputFormat.setVersion(outputDetails.getVersion());
        outputFormat.setIndenting(outputDetails.getIndent() != null && outputDetails.getIndent().equals("yes"));
        outputFormat.setEncoding(outputDetails.getEncoding());
        outputFormat.setMediaType(outputDetails.getMediaType());
        outputFormat.setDoctypePublicId(outputDetails.getDoctypePublic());
        outputFormat.setDoctypeSystemId(outputDetails.getDoctypeSystem());
        outputFormat.setOmitXMLDeclaration(outputDetails.getOmitDeclaration() != null && outputDetails.getOmitDeclaration().equals("yes"));
        Vector vector = outputDetails.getCdataElements();
        QName[] qNameArray = new QName[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            qNameArray[n] = new QName(((Name)vector.elementAt(n)).getURI(), ((Name)vector.elementAt(n)).getPrefix(), ((Name)vector.elementAt(n)).getLocalName());
            ++n;
        }
        outputFormat.setCDataElements(qNameArray);
        return outputFormat;
    }

    public OutputDetails getOutputDetails() throws SAXException {
        OutputDetails outputDetails = new OutputDetails();
        ((XSLStyleSheet)this.styleDoc.getDocumentElement()).updateOutputDetails(outputDetails);
        return outputDetails;
    }

    public String getMediaType() throws SAXException {
        return this.getOutputDetails().getMediaType();
    }
}

