/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.BinaryExpression;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.SingletonComparison;
import com.icl.saxon.expr.SingletonExpression;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import org.xml.sax.SAXException;

class RelationalExpression
extends BinaryExpression {
    public RelationalExpression() {
    }

    public RelationalExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public Expression simplify() throws SAXException {
        this.p1 = this.p1.simplify();
        this.p2 = this.p2.simplify();
        if (this.p1 instanceof SingletonExpression && (this.p2 instanceof StringValue || this.p2 instanceof NumericValue)) {
            return new SingletonComparison((SingletonExpression)this.p1, this.operator, (Value)this.p2);
        }
        return super.simplify();
    }

    public Value evaluate(Context context) throws SAXException {
        return new BooleanValue(this.evaluateAsBoolean(context));
    }

    public boolean evaluateAsBoolean(Context context) throws SAXException {
        Value value = this.p1.evaluate(context);
        Value value2 = this.p2.evaluate(context);
        return value.compare(this.operator, value2);
    }

    public Expression reduce(int n, Context context) throws SAXException {
        if ((this.getDependencies() & n) != 0) {
            RelationalExpression relationalExpression = new RelationalExpression(this.p1.reduce(n, context), this.operator, this.p2.reduce(n, context));
            relationalExpression.setStaticContext(this.getStaticContext());
            return ((Expression)relationalExpression).simplify();
        }
        return this;
    }
}

