/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NodeSetExpression;
import com.icl.saxon.expr.SortKeyEnumeration;
import com.icl.saxon.sort.MultiKeyComparer;
import com.icl.saxon.sort.SortKeyDefinition;
import java.util.Vector;
import org.xml.sax.SAXException;

public class SortedSelection
extends NodeSetExpression {
    private Expression selection;
    private Vector sortkeys = new Vector(3);

    public SortedSelection(Expression expression) {
        this.selection = expression;
    }

    public void addSortKey(SortKeyDefinition sortKeyDefinition) {
        this.sortkeys.addElement(sortKeyDefinition);
    }

    public Expression simplify() throws SAXException {
        this.selection = this.selection.simplify();
        int n = 0;
        while (n < this.sortkeys.size()) {
            SortKeyDefinition sortKeyDefinition = (SortKeyDefinition)this.sortkeys.elementAt(n);
            sortKeyDefinition.setSortKey(sortKeyDefinition.getSortKey().simplify());
            sortKeyDefinition.setOrder(sortKeyDefinition.getOrder().simplify());
            sortKeyDefinition.setDataType(sortKeyDefinition.getDataType().simplify());
            sortKeyDefinition.setCaseOrder(sortKeyDefinition.getCaseOrder().simplify());
            sortKeyDefinition.setLanguage(sortKeyDefinition.getLanguage().simplify());
            ++n;
        }
        return this;
    }

    public int getDependencies() {
        int n = this.selection.getDependencies();
        int n2 = 0;
        while (n2 < this.sortkeys.size()) {
            SortKeyDefinition sortKeyDefinition = (SortKeyDefinition)this.sortkeys.elementAt(n2);
            n |= sortKeyDefinition.getSortKey().getDependencies() & 0x41;
            n |= sortKeyDefinition.getOrder().getDependencies();
            n |= sortKeyDefinition.getDataType().getDependencies();
            n |= sortKeyDefinition.getCaseOrder().getDependencies();
            n |= sortKeyDefinition.getLanguage().getDependencies();
            ++n2;
        }
        return n;
    }

    public Expression reduce(int n, Context context) throws SAXException {
        if ((n & this.getDependencies()) != 0) {
            Expression expression = this.selection.reduce(n, context);
            SortedSelection sortedSelection = new SortedSelection(expression);
            sortedSelection.setStaticContext(this.getStaticContext());
            int n2 = 0;
            while (n2 < this.sortkeys.size()) {
                SortKeyDefinition sortKeyDefinition = (SortKeyDefinition)this.sortkeys.elementAt(n2);
                SortKeyDefinition sortKeyDefinition2 = new SortKeyDefinition();
                sortKeyDefinition2.setSortKey(sortKeyDefinition.getSortKey().reduce(n & 0x41, context));
                sortKeyDefinition2.setOrder(sortKeyDefinition.getOrder().reduce(n, context));
                sortKeyDefinition2.setDataType(sortKeyDefinition.getDataType().reduce(n, context));
                sortKeyDefinition2.setCaseOrder(sortKeyDefinition.getCaseOrder().reduce(n, context));
                sortKeyDefinition2.setLanguage(sortKeyDefinition.getLanguage().reduce(n, context));
                sortedSelection.addSortKey(sortKeyDefinition2);
                ++n2;
            }
            return sortedSelection.simplify();
        }
        return this;
    }

    public NodeEnumeration enumerate(Context context) throws SAXException {
        NodeEnumeration nodeEnumeration = this.selection.enumerate(context);
        SortKeyEnumeration sortKeyEnumeration = new SortKeyEnumeration(nodeEnumeration);
        MultiKeyComparer multiKeyComparer = new MultiKeyComparer(this.sortkeys, context);
        sortKeyEnumeration.setComparer(multiKeyComparer);
        sortKeyEnumeration.setSortKeys(this.sortkeys);
        sortKeyEnumeration.setContext(context);
        return sortKeyEnumeration;
    }
}

