/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.Loader;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.Name;
import com.icl.saxon.style.ExtensionElementFactory;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.StyleNodeFactory;
import java.util.Vector;
import org.xml.sax.SAXException;

public class ElementAvailable
extends Function {
    public String getName() {
        return "element-available";
    }

    public int getDataType() {
        return 1;
    }

    public Value eval(Vector vector, Context context) throws SAXException {
        int n = this.checkArgumentCount(1, 1);
        Value value = (Value)vector.elementAt(0);
        String string = value.asString();
        try {
            Name name = this.getStaticContext().makeName(string, true);
            String string2 = name.getURI();
            String string3 = name.getLocalName();
            if (string2.equals("http://www.w3.org/1999/XSL/Transform")) {
                boolean bl = new StyleNodeFactory().isXSLElement(string3);
                return new BooleanValue(bl);
            }
            if (string2.equals("http://icl.com/saxon")) {
                boolean bl = new StyleNodeFactory().isSAXONElement(string3);
                return new BooleanValue(bl);
            }
            ExtensionElementFactory extensionElementFactory = this.getFactory(string2);
            if (extensionElementFactory == null) {
                return new BooleanValue(false);
            }
            Class clazz = extensionElementFactory.getExtensionClass(string3);
            if (clazz == null) {
                return new BooleanValue(false);
            }
            StyleElement styleElement = (StyleElement)clazz.newInstance();
            return new BooleanValue(true);
        }
        catch (Exception exception) {
            return new BooleanValue(false);
        }
    }

    private ExtensionElementFactory getFactory(String string) throws SAXException {
        int n = string.lastIndexOf(47);
        if (n < 0 || n == string.length() - 1) {
            return null;
        }
        String string2 = string.substring(n + 1);
        try {
            return (ExtensionElementFactory)Loader.getInstance(string2);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

