/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import java.util.Vector;
import org.xml.sax.SAXException;

public class StringFn
extends Function {
    public String getName() {
        return "string";
    }

    public int getDataType() {
        return 3;
    }

    public int getIntrinsicDependencies() {
        int n = this.arguments.size();
        return n == 0 ? 8 : 0;
    }

    protected Expression reduceIntrinsic(int n, Context context) throws SAXException {
        int n2 = this.checkArgumentCount(0, 1);
        if (n2 == 0 && (n & 8) != 0) {
            return this.evaluate(context);
        }
        return this;
    }

    public Expression simplify() throws SAXException {
        int n = this.checkArgumentCount(0, 1);
        if (n == 0) {
            return this;
        }
        Expression expression = (Expression)this.arguments.elementAt(0);
        if (expression instanceof Value) {
            return new StringValue(((Value)expression).asString());
        }
        return this;
    }

    public Value eval(Vector vector, Context context) throws SAXException {
        int n = this.checkArgumentCount(0, 1);
        if (n == 0) {
            return new StringValue(context.getContextNode().getValue());
        }
        Value value = (Value)vector.elementAt(0);
        return new StringValue(value.asString());
    }
}

